/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Element;

public class EmbeddedContentConsumer
implements KeyInfoContentConsumerComponent {
    private static final TraceComponent tc = Tr.register(EmbeddedContentConsumer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EmbeddedContentConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public Key getKey(Element element, Map map, Map map2) throws SoapSecurityException {
        KeyLocator keyLocator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Element target[" + DOMUtil.getDisplayName(element) + "]," + "Map type," + "Map context)");
        }
        KeyInfoContentConsumerConfig keyInfoContentConsumerConfig = (KeyInfoContentConsumerConfig)map2.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoContentConsumerConfig [" + keyInfoContentConsumerConfig + "].");
        }
        KeyInfoResult keyInfoResult = new KeyInfoResult(keyInfoContentConsumerConfig);
        ResultPool.add(map2, keyInfoResult);
        if (!ConfigUtil.isKeyInfoEmb(keyInfoContentConsumerConfig.getKeyInfoType())) {
            String string = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean bl = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer stringBuffer = new StringBuffer(clsName).append(" expects KeyInfo's type [EMB],");
            stringBuffer.append(" but the type requested in the configuration is [").append(keyInfoContentConsumerConfig.getKeyInfoType()).append("].");
            stringBuffer.append(" Please make sure the KeyInfo used for");
            if ("VerifyingKey".equals(string)) {
                stringBuffer.append(" siganture verification");
            } else {
                stringBuffer.append(" decryption");
            }
            stringBuffer.append(" in the");
            if (bl) {
                stringBuffer.append(" request consumer configuration.");
            } else {
                stringBuffer.append(" response consumer configuration.");
            }
            throw new SoapSecurityException(stringBuffer.toString());
        }
        int n = 0;
        Object v = map2.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[0][n];
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentConsumerConfig.getKeyInfoType());
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentConsumerConfig.getKeyInfoType());
        String string2 = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The type of a key is [" + string2 + "].");
        }
        String string3 = this.getEmbeddedTokenId(element, string);
        keyInfoResult.setIdInSubject(string3);
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID, string3);
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID, string3);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Embedded identifier of a token is [" + string3 + "].");
        }
        if ((keyLocator = keyInfoContentConsumerConfig.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        map2.put("com.ibm.wsspi.wssecurity.token.x509.keyLocator", keyInfoContentConsumerConfig.getKeyLocator());
        map2.remove(keyLocator.getClass());
        if (keyInfoContentConsumerConfig.getTokenConsumer() == null) {
            map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        } else {
            map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE, keyInfoContentConsumerConfig.getTokenConsumer());
        }
        Element element2 = this.getEmbeddedToken(element, string);
        TokenConsumerConfig tokenConsumerConfig = keyInfoContentConsumerConfig.getTokenConsumer();
        if (tokenConsumerConfig == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
        }
        Object object = tokenConsumerConfig.getInstance();
        if (object == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
        }
        map2.put("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey", tokenConsumerConfig);
        object.invoke(element2, map2);
        map2.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
        keyLocator = keyInfoContentConsumerConfig.getKeyLocator();
        object = keyLocator.getKey(map, map2);
        map2.remove(keyLocator.getClass());
        map2.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(Element target,Map type,Map context) returns Key[" + object + "]");
        }
        return object;
    }

    private Element getEmbeddedToken(Element element, String string) throws SoapSecurityException {
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEmbeddedToken(Element elem[" + DOMUtil.getDisplayName(element) + "]," + "String nsWsse[" + string + "])");
        }
        if ((element2 = DOMUtil.getOneElement(element, string, "Embedded")) == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken01");
        }
        Element element3 = DOMUtil.getFirstElement(element2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEmbeddedToken(Element elem,String nsWsse) returns Element[" + DOMUtil.getDisplayName(element3) + "]");
        }
        return element3;
    }

    private String getEmbeddedTokenId(Element element, String string) throws SoapSecurityException {
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEmbeddedTokenId(Element elem[" + DOMUtil.getDisplayName(element) + "]," + "String nsWsse[" + string + "])");
        }
        if ((element2 = DOMUtil.getOneElement(element, string, "Embedded")) == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken01");
        }
        String string2 = element2.getAttribute("wsu:Id");
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken02");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEmbeddedTokenId(Element elem,String nsWsse) returns String[" + string2 + "]");
        }
        return string2;
    }
}

