/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class KeyIdContentConsumer
implements KeyInfoContentConsumerComponent {
    private static final TraceComponent tc = Tr.register(KeyIdContentConsumer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyIdContentConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public Key getKey(Element element, Map map, Map map2) throws SoapSecurityException {
        Object object;
        Object object2;
        Element element2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Element target[" + DOMUtil.getDisplayName(element) + "]," + "Map type," + "Map context)");
        }
        KeyInfoContentConsumerConfig keyInfoContentConsumerConfig = (KeyInfoContentConsumerConfig)map2.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoContentConsumerConfig [" + keyInfoContentConsumerConfig + "].");
        }
        KeyInfoResult keyInfoResult = new KeyInfoResult(keyInfoContentConsumerConfig);
        ResultPool.add(map2, keyInfoResult);
        if (!ConfigUtil.isKeyInfoKeyid(keyInfoContentConsumerConfig.getKeyInfoType())) {
            String string = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean bl = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer stringBuffer = new StringBuffer(clsName).append(" expects KeyInfo's type [KEYID],");
            stringBuffer.append(" but the type requested in the configuration is [").append(keyInfoContentConsumerConfig.getKeyInfoType()).append("].");
            stringBuffer.append(" Please make sure the KeyInfo used for");
            if ("VerifyingKey".equals(string)) {
                stringBuffer.append(" siganture verification");
            } else {
                stringBuffer.append(" decryption");
            }
            stringBuffer.append(" in the");
            if (bl) {
                stringBuffer.append(" request consumer configuration.");
            } else {
                stringBuffer.append(" response consumer configuration.");
            }
            throw new SoapSecurityException(stringBuffer.toString());
        }
        int n = 0;
        Object v = map2.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[0][n];
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentConsumerConfig.getKeyInfoType());
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentConsumerConfig.getKeyInfoType());
        String string2 = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The type of a key is [" + string2 + "].");
        }
        if ((element2 = DOMUtil.getZeroOrOneElement(element, string, "KeyIdentifier")) == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyIdContentConsumer.getKey01");
        }
        String string3 = this.getKeyIdentifier(element2);
        keyInfoResult.setIdInSubject(string3);
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID, string3);
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID, string3);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key identifier is [" + string3 + "].");
        }
        QName qName = this.getValueType(element2, n);
        QName qName2 = this.getEncodingType(element2, n);
        QName qName3 = this.getIdentifierType(element2, n);
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE, qName);
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING, qName2);
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE, qName3);
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE, qName);
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING, qName2);
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE, qName3);
        boolean bl = WSSecurityPlatformContextFactory.getInstance().isServer();
        if (bl && qName != null && (qName.equals(Constants.X509_SKI) || qName.equals(Constants.X509_SKI_OLD))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The " + qName + " key idendifier is found.  It is cached in order to use it for response generator.");
            }
            if ((object2 = (SOAPMessageContext)map2.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
            }
            object2.setProperty("com.ibm.ws.webservices.wssecurity.constants.consumedKeyidValuetype", (Object)qName);
        }
        if ((object2 = keyInfoContentConsumerConfig.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        map2.put("com.ibm.wsspi.wssecurity.token.x509.keyLocator", keyInfoContentConsumerConfig.getKeyLocator());
        map2.remove(object2.getClass());
        if (keyInfoContentConsumerConfig.getTokenConsumer() == null) {
            map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        } else {
            map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE, keyInfoContentConsumerConfig.getTokenConsumer());
        }
        TokenConsumerConfig tokenConsumerConfig = keyInfoContentConsumerConfig.getTokenConsumer();
        if (tokenConsumerConfig != null) {
            object = tokenConsumerConfig.getInstance();
            if (object == null) {
                throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
            }
            map2.put("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey", tokenConsumerConfig);
            object.invoke(element.getOwnerDocument(), map2);
        }
        map2.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
        object2 = keyInfoContentConsumerConfig.getKeyLocator();
        object = object2.getKey(map, map2);
        map2.remove(object2.getClass());
        map2.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(Element target,Map type,Map context) returns Key[" + object + "]");
        }
        return object;
    }

    private QName getValueType(Element element, int n) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueType(Element elem[" + DOMUtil.getDisplayName(element) + "]," + "int wssVersion[" + n + "])");
        }
        QName qName = null;
        if (!element.hasAttribute("ValueType")) {
            throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token16");
        }
        String string = element.getAttribute("ValueType");
        qName = DOMUtil.getQName(element, string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueType(Element elem,int wssVersion) returns QName[" + qName + "]");
        }
        return qName;
    }

    private QName getEncodingType(Element element, int n) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncodingType(Element elem[" + DOMUtil.getDisplayName(element) + "]," + "int wssVersion[" + n + "])");
        }
        QName qName = Constants.BASE64_BINARY;
        if (element.hasAttribute("EncodingType")) {
            String string = element.getAttribute("EncodingType");
            qName = DOMUtil.getQName(element, string, n);
        } else {
            Tr.debug(tc, ConfigUtil.getMessage("security.wssecurity.KeyIdContentConsumer.getEncodingType02"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncodingType(Element elem,int wssVersion) returns QName[" + qName + "]");
        }
        return qName;
    }

    private QName getIdentifierType(Element element, int n) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdentifierType(Element elem[" + DOMUtil.getDisplayName(element) + "]," + "int wssVersion[" + n + "])");
        }
        QName qName = Constants.ITSHA1;
        if (element.hasAttribute("IdentifierType")) {
            String string = element.getAttribute("IdentifierType");
            qName = DOMUtil.getQName(element, string, n);
        } else {
            Tr.debug(tc, ConfigUtil.getMessage("security.wssecurity.KeyIdContentConsumer.getIdentifierType01"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdentifierType(Element elem,int wssVersion) returns QName[" + qName + "]");
        }
        return qName;
    }

    private String getKeyIdentifier(Element element) throws SoapSecurityException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyIdentifier(Element elem[" + DOMUtil.getDisplayName(element) + "])");
        }
        if ((string = DOMUtil.getStringValue(element)) != null && string.length() != 0) {
            string = string.trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyIdentifier(Element elem) returns String[" + string + "]");
        }
        return string;
    }
}

