/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class KeyIdContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register(KeyIdContentGenerator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyIdContentGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public Key getKey(Document document, Element element, Map map, Map map2) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map type," + "Map context)");
        }
        KeyInfoContentGeneratorConfig keyInfoContentGeneratorConfig = (KeyInfoContentGeneratorConfig)map2.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoContentGeneratorConfig [" + keyInfoContentGeneratorConfig + "].");
        }
        if (!ConfigUtil.isKeyInfoKeyid(keyInfoContentGeneratorConfig.getKeyInfoType())) {
            String string = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean bl = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer stringBuffer = new StringBuffer(clsName).append(" expects KeyInfo's type [KEYID],");
            stringBuffer.append(" but the type requested in the configuration is [").append(keyInfoContentGeneratorConfig.getKeyInfoType()).append("].");
            stringBuffer.append(" Please make sure the KeyInfo used for");
            if ("SigningKey".equals(string)) {
                stringBuffer.append(" siganture");
            } else {
                stringBuffer.append(" encryption");
            }
            stringBuffer.append(" in the");
            if (bl) {
                stringBuffer.append(" response generator configuration.");
            } else {
                stringBuffer.append(" request generator configuration.");
            }
            throw new SoapSecurityException(stringBuffer.toString());
        }
        int n = 0;
        Object v = map2.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[0][n];
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentGeneratorConfig.getKeyInfoType());
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentGeneratorConfig.getKeyInfoType());
        if (keyInfoContentGeneratorConfig.getKeyName() == null) {
            map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
            map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
        } else {
            map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, keyInfoContentGeneratorConfig.getKeyName());
            map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, keyInfoContentGeneratorConfig.getKeyName());
        }
        Map map3 = keyInfoContentGeneratorConfig.getProperties();
        String string2 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMIT_ENCODING_TYPE);
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            bl = ConfigUtil.isTrue(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "emitEncodingTypeString [" + string2 + "], emitEncodingType [" + bl + "].");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "emitEncodingTypeString [null or empty], emitEncodingType [" + bl + "].");
        }
        String string3 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE_LN);
        String string4 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE_NS);
        QName qName = Constants.ITSHA1;
        if (string3 != null && string3.length() > 0) {
            qName = string4 == null ? new QName("", string3) : new QName(string4, string3);
        }
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE, qName);
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE, qName);
        string3 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING_LN);
        string4 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING_NS);
        QName qName2 = Constants.BASE64_BINARY;
        if (string3 != null && string3.length() > 0) {
            qName2 = string4 == null ? new QName("", string3) : new QName(string4, string3);
        }
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING, qName2);
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING, qName2);
        string3 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE_LN);
        string4 = (String)map3.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE_NS);
        TokenGeneratorConfig tokenGeneratorConfig = keyInfoContentGeneratorConfig.getTokenGenerator();
        QName qName3 = Constants.X509_SKI_OLD;
        if (string3 != null && string3.length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found local name " + string3 + ", namespace " + (string4 == null ? "<null>" : string4));
            }
            qName3 = string4 == null ? new QName("", string3) : new QName(string4, string3);
        } else {
            boolean bl2 = WSSecurityPlatformContextFactory.getInstance().isServer();
            if (bl2) {
                object3 = (SOAPMessageContext)map2.get("com.ibm.wsspi.wssecurity.core.messageContext");
                if (object3 == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
                }
                object2 = (QName)object3.getProperty("com.ibm.ws.webservices.wssecurity.constants.consumedKeyidValuetype");
                if (object2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cached X509v3 key idendifier [" + qName3 + "] is found.  It is used for value type.");
                    }
                    qName3 = object2;
                } else {
                    QName qName4;
                    object = object3.getProperty("RequestSenderConfig");
                    if (object != null && tokenGeneratorConfig != null && (qName4 = tokenGeneratorConfig.getType()) != null) {
                        if (Constants.X509V3.equals(qName4)) {
                            qName3 = Constants.X509_SKI;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Token type is \"" + qName4 + "\". Therefore using value type \"" + qName3 + "\" for request generator.");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Token type is \"" + qName4 + "\". Leaving value type as \"" + qName3 + "\" for request generator.");
                        }
                    }
                }
            } else if (tokenGeneratorConfig != null && (object3 = tokenGeneratorConfig.getType()) != null) {
                if (Constants.X509V3.equals(object3)) {
                    qName3 = Constants.X509_SKI;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Token type is \"" + object3 + "\". Therefore using value type \"" + qName3 + "\" for request generator.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token type is \"" + object3 + "\". Leaving value type as \"" + qName3 + "\" for request generator.");
                }
            }
        }
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE, qName3);
        String string5 = null;
        if (tokenGeneratorConfig != null) {
            object3 = tokenGeneratorConfig.getInstance();
            if (object3 == null) {
                throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
            }
            map2.put("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey", tokenGeneratorConfig);
            object2 = STRReferenceContentGenerator.getSecurityElement(document, element, n, string, map2);
            object3.invoke(document, (Element)object2, map2);
            string5 = (String)map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        }
        if ((object3 = keyInfoContentGeneratorConfig.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        if (string5 != null) {
            map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID, string5);
        } else {
            map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        }
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        object2 = object3.getKey(map, map2);
        if (string5 == null) {
            string5 = (String)map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        }
        object = DOMUtil.getNamespacePrefix(element, string);
        boolean bl3 = false;
        if (object == null) {
            bl3 = true;
            object = "wsse:";
        } else if (((String)object).length() > 0) {
            object = (String)object + ":";
        }
        Element element2 = document.createElementNS(string, (String)object + "SecurityTokenReference");
        if (bl3) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", string);
        }
        Element element3 = document.createElementNS(string, (String)object + "KeyIdentifier");
        if (bl) {
            DOMUtil.setQNameAttr(element3, null, "EncodingType", qName2, n);
        }
        DOMUtil.setQNameAttr(element3, null, "ValueType", qName3, n);
        element3 = (Element)element2.appendChild(element3);
        Text text = document.createTextNode(string5);
        text = (Text)element3.appendChild(text);
        element2 = (Element)element.appendChild(element2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created the element [" + DOMUtil.getDisplayName(element2) + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(Document doc,Element parent,Map type,Map context) returns Key[" + object2 + "]");
        }
        return object2;
    }
}

