/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class KeyInfoConsumer
implements KeyInfoConsumerComponent {
    private static final TraceComponent tc = Tr.register(KeyInfoConsumer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyInfoConsumer.class.getName();
    public static final String KEYNAME = "KEYNAME";
    public static final String KEYID = "KEYID";
    public static final String STRREF = "STRREF";
    public static final String EMB = "EMB";
    public static final String X509ISSUER = "X509ISSUER";
    public static final String UNKNOWN = "UNKNOWN";
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public Key getKey(Element element, Map map, Map map2) throws SoapSecurityException {
        Object object;
        Object object2;
        KeyInfoResult keyInfoResult;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Element target[" + DOMUtil.getDisplayName(element) + "]," + "Map type," + "Map context)");
        }
        int n = 0;
        Object v = map2.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[0][n];
        Object object3 = null;
        KeyInfoConsumerConfig keyInfoConsumerConfig = (KeyInfoConsumerConfig)map2.remove("com.ibm.wsspi.wssecurity.config.keyinfoConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoConsumerConfig [" + keyInfoConsumerConfig + "].");
        }
        boolean bl = false;
        KeyInfoContentConsumerConfig keyInfoContentConsumerConfig = null;
        Exception[] exceptionArray = new Exception[keyInfoConsumerConfig.getContentConsumers().size()];
        int n2 = 0;
        Iterator iterator = keyInfoConsumerConfig.getContentConsumers().iterator();
        while (iterator != null && iterator.hasNext()) {
            keyInfoContentConsumerConfig = (KeyInfoContentConsumerConfig)iterator.next();
            keyInfoResult = KeyInfoConsumer.getProcessedResult(map2, keyInfoContentConsumerConfig);
            if (keyInfoResult != null) {
                if (keyInfoResult.getError() != null) {
                    exceptionArray[n2++] = keyInfoResult.getError();
                    continue;
                }
                object3 = keyInfoResult.getKey();
                object2 = keyInfoContentConsumerConfig.getProperties();
                object = (String)object2.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW keystore name is : " + (String)object);
                }
                map2.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", object);
                if (bl) continue;
                keyInfoResult.setUsed(true);
                bl = true;
                continue;
            }
            try {
                Object object4;
                object2 = keyInfoContentConsumerConfig.getInstance();
                map2.put("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey", keyInfoContentConsumerConfig);
                object = object2.getKey(element, map, map2);
                if (object == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
                }
                if (object3 == null) {
                    object3 = object;
                    object4 = keyInfoContentConsumerConfig.getProperties();
                    String string2 = (String)object4.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HW keystorename is : " + string2);
                    }
                    map2.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", string2);
                }
                if ((object4 = TokenManager.getUnprocessedToken(map2)) != null) {
                    object4.setProcessed(true);
                }
                if ((keyInfoResult = KeyInfoConsumer.getUnprocessedResult(map2)) != null) {
                    keyInfoResult.setProcessed(true);
                    if (!bl) {
                        keyInfoResult.setUsed(true);
                    }
                    keyInfoResult.setKey((Key)object3);
                }
                bl = true;
            }
            catch (Exception exception) {
                exceptionArray[n2++] = exception;
                object = TokenManager.getUnprocessedToken(map2);
                if (object != null) {
                    object.setProcessed(true);
                }
                if ((keyInfoResult = KeyInfoConsumer.getUnprocessedResult(map2)) == null) continue;
                keyInfoResult.setError(exception);
                keyInfoResult.setProcessed(true);
            }
        }
        iterator = keyInfoConsumerConfig.getOtherContentConsumers().iterator();
        while (iterator != null && iterator.hasNext()) {
            keyInfoContentConsumerConfig = (KeyInfoContentConsumerConfig)iterator.next();
            keyInfoResult = KeyInfoConsumer.getProcessedResult(map2, keyInfoContentConsumerConfig);
            if (keyInfoResult != null) continue;
            try {
                object2 = keyInfoContentConsumerConfig.getInstance();
                map2.put("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey", keyInfoContentConsumerConfig);
                object = object2.getKey(element, map, map2);
                if (object == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
                }
                if (object3 == null) {
                    object3 = object;
                }
                if ((keyInfoResult = KeyInfoConsumer.getUnprocessedResult(map2)) == null) continue;
                keyInfoResult.setProcessed(true);
            }
            catch (Exception exception) {
                keyInfoResult = KeyInfoConsumer.getUnprocessedResult(map2);
                if (keyInfoResult == null) continue;
                keyInfoResult.setError(exception);
                keyInfoResult.setProcessed(true);
            }
        }
        if (!bl) {
            if (n2 == 1) {
                if (exceptionArray[0] instanceof SoapSecurityException) {
                    throw (SoapSecurityException)exceptionArray[0];
                }
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", exceptionArray[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n2 + " exceptions were catched.");
                for (int i = 0; i < n2; ++i) {
                    Tr.debug(tc, "No." + i + "'s exception: " + exceptionArray[i]);
                }
            }
            throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey03", exceptionArray[n2 - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getkey(Element target,Map type,Map context) returns Key[" + object3 + "]");
        }
        return object3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getKeyInfoType(Element element, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoType(Element target[" + DOMUtil.getDisplayName(element) + "]," + "String [" + string + "])");
        }
        String string2 = UNKNOWN;
        Element element2 = DOMUtil.getFirstElement(element);
        if (element2 != null && DOMUtil.equals(element2, Constants.NS_DSIG, "KeyName")) {
            string2 = KEYNAME;
        } else {
            if (!DOMUtil.equals(element2, string, "SecurityTokenReference")) throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKeyInfoType01");
            if (DOMUtil.equals(element2 = DOMUtil.getFirstElement(element2), string, "KeyIdentifier")) {
                string2 = KEYID;
            } else if (DOMUtil.equals(element2, string, "Reference")) {
                string2 = STRREF;
            } else if (DOMUtil.equals(element2, string, "Embedded")) {
                string2 = EMB;
            } else {
                if (!DOMUtil.equals(element2, Constants.NS_DSIG, "X509Data")) throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKeyInfoType01");
                string2 = X509ISSUER;
            }
        }
        if (!tc.isEntryEnabled()) return string2;
        Tr.exit(tc, "getKeyInfoType(Element target,String  nsWsse) returns String[" + string2 + "]");
        return string2;
    }

    public static QName getValueType(Element element, String string, String string2, int n) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueType(Element target[" + DOMUtil.getDisplayName(element) + "]," + "String kitype[" + string + "]," + "String nsWsse[" + string2 + "]," + "int wssVersion[" + n + "])");
        }
        QName qName = null;
        if (string == STRREF) {
            Element element2 = DOMUtil.getOneElement(element, string2, "Reference");
            if (element2 == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType01");
            }
            String string3 = DOMUtil.getAttribute(element2, "ValueType");
            qName = DOMUtil.getQName(element, string3, n);
        } else if (string == KEYID) {
            Element element3 = DOMUtil.getOneElement(element, string2, "KeyIdentifier");
            if (element3 == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType02");
            }
            String string4 = DOMUtil.getAttribute(element3, "ValueType");
            qName = DOMUtil.getQName(element, string4, n);
        } else if (string == EMB) {
            Element element4 = DOMUtil.getOneElement(element, string2, "Embedded");
            if (element4 == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType03");
            }
            Element element5 = DOMUtil.getFirstElement(element4);
            if (element5 != null) {
                if (element5.getNodeName() == "wsse:BinarySecurityToken" && element5.getNamespaceURI() == string2) {
                    String string5 = DOMUtil.getAttribute(element5, "ValueType");
                    qName = DOMUtil.getQName(element, string5, n);
                } else {
                    String string6 = element5.getNodeName();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueType(Element target,String kitype,String nsWsse) returns QName[" + qName + "]");
        }
        return qName;
    }

    private static KeyInfoResult getUnprocessedResult(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnprocessedResult(Map context)");
        }
        KeyInfoResult keyInfoResult = null;
        Result[] resultArray = ResultPool.get(map, KeyInfoResult.class);
        if (resultArray != null) {
            for (int i = 0; i < resultArray.length; ++i) {
                KeyInfoResult keyInfoResult2 = (KeyInfoResult)resultArray[i];
                if (keyInfoResult2.isProcessed()) continue;
                keyInfoResult = keyInfoResult2;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnprocessedResult(Map context) returns KeyInfoResult[" + keyInfoResult + "]");
        }
        return keyInfoResult;
    }

    private static KeyInfoResult getProcessedResult(Map map, KeyInfoContentConsumerConfig keyInfoContentConsumerConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedResult(Map context,KeyInfoContentConsumerConfig kconfig");
        }
        KeyInfoResult keyInfoResult = null;
        Result[] resultArray = ResultPool.get(map, KeyInfoResult.class);
        if (resultArray != null) {
            for (int i = 0; i < resultArray.length; ++i) {
                KeyInfoResult keyInfoResult2 = (KeyInfoResult)resultArray[i];
                if (!keyInfoContentConsumerConfig.equals(keyInfoResult2.getKeyInfoContentConsumer())) continue;
                keyInfoResult = keyInfoResult2;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedResult(Map context,KeyInfoContentConsumerConfig kconfig) returns KeyInfoResult[" + keyInfoResult + "]");
        }
        return keyInfoResult;
    }
}

