/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.WSSKeyInfoComponent;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyInfoGenerator
implements WSSKeyInfoComponent {
    private static final TraceComponent tc = Tr.register(KeyInfoGenerator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyInfoGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public Key getKey(Document document, Element element, Map map, Map map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map type," + "Map context)");
        }
        Key key = null;
        WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)map2.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        KeyInfoGeneratorConfig keyInfoGeneratorConfig = (KeyInfoGeneratorConfig)map2.remove("com.ibm.wsspi.wssecurity.config.keyinfoGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoGeneratorConfig [" + keyInfoGeneratorConfig + "].");
        }
        Element element2 = null;
        element2 = document.createElementNS(Constants.NS_DSIG, "ds:KeyInfo");
        String string = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        boolean bl = false;
        if ("EncryptingKey".equals(string)) {
            bl = true;
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", Constants.NS_DSIG);
        }
        if (wSSGeneratorConfig.isUserDefinedComponentsUsed()) {
            object = DOMUtil.getOneChildElement(element, Constants.NS_DSIG, "KeyInfo");
            Node node = object.getNextSibling();
            element.removeChild((Node)object);
            element2 = (Element)element.insertBefore(element2, node);
        } else {
            element2 = bl ? (Element)element.insertBefore(element2, DOMUtil.getOneChildElement(element, Constants.NS_ENC, "CipherData")) : (Element)element.appendChild(element2);
        }
        object = keyInfoGeneratorConfig.getContentGenerator().getInstance();
        if (object == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey01");
        }
        map2.put("com.ibm.wsspi.wssecurity.config.keyinfoContentGenerator.configKey", keyInfoGeneratorConfig.getContentGenerator());
        key = object.getKey(document, element2, map, map2);
        if (key == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created the element [" + DOMUtil.getDisplayName(element2) + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(Document doc,Element parent,Map type,Map context) returns Key[key]");
        }
        return key;
    }
}

