/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSComponent;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class KeyNameContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register(KeyNameContentGenerator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyNameContentGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public Key getKey(Document document, Element element, Map map, Map map2) throws SoapSecurityException {
        String string;
        Object object;
        WSSComponent wSSComponent;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Document doc[" + DOMUtil.getDisplayName(document) + "]," + "Element parent[" + DOMUtil.getDisplayName(element) + "]," + "Map type," + "Map context)");
        }
        KeyInfoContentGeneratorConfig keyInfoContentGeneratorConfig = (KeyInfoContentGeneratorConfig)map2.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoContentGeneratorConfig [" + keyInfoContentGeneratorConfig + "].");
        }
        if (!ConfigUtil.isKeyInfoKeyname(keyInfoContentGeneratorConfig.getKeyInfoType())) {
            String string2 = (String)map.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean bl = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer stringBuffer = new StringBuffer(clsName).append(" expects KeyInfo's type [KEYNAME],");
            stringBuffer.append(" but the type requested in the configuration is [").append(keyInfoContentGeneratorConfig.getKeyInfoType()).append("].");
            stringBuffer.append(" Please make sure the KeyInfo used for");
            if ("SigningKey".equals(string2)) {
                stringBuffer.append(" siganture");
            } else {
                stringBuffer.append(" encryption");
            }
            stringBuffer.append(" in the");
            if (bl) {
                stringBuffer.append(" response generator configuration.");
            } else {
                stringBuffer.append(" request generator configuration.");
            }
            throw new SoapSecurityException(stringBuffer.toString());
        }
        int n = 0;
        Object v = map2.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string3 = Constants.NAMESPACES[0][n];
        map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentGeneratorConfig.getKeyInfoType());
        map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, keyInfoContentGeneratorConfig.getKeyInfoType());
        if (keyInfoContentGeneratorConfig.getKeyName() == null) {
            map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
            map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
        } else {
            map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, keyInfoContentGeneratorConfig.getKeyName());
            map2.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, keyInfoContentGeneratorConfig.getKeyName());
        }
        String string4 = null;
        TokenGeneratorConfig tokenGeneratorConfig = keyInfoContentGeneratorConfig.getTokenGenerator();
        if (tokenGeneratorConfig != null) {
            wSSComponent = tokenGeneratorConfig.getInstance();
            if (wSSComponent == null) {
                throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
            }
            map2.put("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey", tokenGeneratorConfig);
            object = STRReferenceContentGenerator.getSecurityElement(document, element, n, string3, map2);
            wSSComponent.invoke(document, (Element)object, map2);
            string4 = (String)map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        }
        if ((wSSComponent = keyInfoContentGeneratorConfig.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        if (string4 != null) {
            map.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME, string4);
        } else {
            map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        }
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        map.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        object = wSSComponent.getKey(map, map2);
        if (string4 == null) {
            string4 = (String)map2.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        }
        if ((string = DOMUtil.getNamespacePrefix(element, Constants.NS_DSIG)) == null) {
            string = "ds:";
        } else if (string.length() > 0) {
            string = string + ":";
        }
        Element element2 = document.createElementNS(Constants.NS_DSIG, string + "KeyName");
        String string5 = KeyInfo.X509Data.decodeDName(string4);
        if (string5 != null) {
            string4 = string5;
        }
        Text text = document.createTextNode(string4);
        text = (Text)element2.appendChild(text);
        element2 = (Element)element.appendChild(element2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created the element [" + DOMUtil.getDisplayName(element2) + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(Document doc,Element parent,Map type,Map context) returns Key[" + object + "]");
        }
        return object;
    }
}

