/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.time;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.webservices.wssecurity.time.TimestampResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TimestampConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(TimestampConsumer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TimestampConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Node target[" + DOMUtil.getDisplayName(node) + "]," + "Map context)");
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampConsumer.s01");
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string = Constants.NAMESPACES[1][n];
        TimestampConsumerConfig timestampConsumerConfig = (TimestampConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.timestampConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TimestampConsumerConfig [" + timestampConsumerConfig + "].");
        }
        SoapSecurityException soapSecurityException = null;
        try {
            NonceUtil.checkTimestamp(node, string, timestampConsumerConfig.getTimestampMaxAge(), timestampConsumerConfig.getTimestampClockSkew(), true);
        }
        catch (SoapSecurityException soapSecurityException2) {
            soapSecurityException = soapSecurityException2;
        }
        ResultPool.add(map, new TimestampResult((Element)node, soapSecurityException));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Element target,Map context)");
        }
    }
}

