/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.token;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.AuthResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.token.UserRegistryProcessor;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import com.ibm.wsspi.wssecurity.auth.token.LTPATokenWrapper;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.w3c.dom.Node;

public class LoginProcessor
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(LoginProcessor.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LoginProcessor.class.getName();
    private static final String JAASCONFIG_DEFAULT = "WSLogin";
    private static final String JAASCONFIG_IDASSERTION = "system.wssecurity.IDAssertion";
    private static final String JAASCONFIG_SIGNATURE = "system.wssecurity.Signature";
    private static final String CALLBACKHANDLER_FACTORY_DEFAULT = "com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl";
    private boolean _initialized = false;
    private static final String JAAS_LOGINCONFIG = "com.ibm.wsspi.wssecurity.Caller.assertionLoginConfig";
    private static final String JAAS_PASSLOGINSUBJECT = "com.ibm.wsspi.wssecurity.Caller.passSubjectToLogin";
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Element target[" + DOMUtil.getDisplayName(node) + "], " + "Map context)");
        }
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        Token token = LoginProcessor.checkCaller(wSSConsumerConfig.getCallers(), map);
        this.login(token, map);
        map.remove(JAAS_LOGINCONFIG);
        map.remove(JAAS_PASSLOGINSUBJECT);
        TokenManager.finalizeSubject(map);
        this.cacheInformation(token, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Element target,Map context)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Token checkCaller(Set set, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCaller(Set cconfigs[" + set + "]," + "Map context)");
        }
        Token token = null;
        map.remove(JAAS_LOGINCONFIG);
        map.remove(JAAS_PASSLOGINSUBJECT);
        if (set != null) {
            Object object;
            Object object2;
            Result[] resultArray = ResultPool.get(map, AuthResult.class);
            int n = resultArray.length;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "results.length=" + resultArray.length, resultArray);
            }
            if (n == 0) {
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s01");
            }
            if (n > 2) {
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s02");
            }
            AuthResult authResult = null;
            AuthResult authResult2 = null;
            if (resultArray.length == 1) {
                authResult = (AuthResult)resultArray[0];
                if (authResult.getToken() == null) {
                    throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s03");
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    object2 = (AuthResult)resultArray[i];
                    object = ((AuthResult)object2).getToken();
                    if (object == null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s03");
                    }
                    if (object.isTrusted()) {
                        if (authResult2 != null) {
                            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s04");
                        }
                        authResult2 = object2;
                        continue;
                    }
                    if (authResult != null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s05");
                    }
                    authResult = object2;
                }
            }
            if (tc.isDebugEnabled()) {
                if (authResult2 == null || authResult2.getToken() == null) {
                    Tr.debug(tc, "Caller token [" + authResult.getToken().getType() + "]");
                } else {
                    Tr.debug(tc, "Caller token [" + authResult.getToken().getType() + "], " + "TrustMethod token [" + authResult2.getToken().getType() + "]");
                }
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (WSSConsumerConfig.CallerConfig)iterator.next();
                boolean bl = false;
                WSSConsumerConfig.CallerConfig callerConfig = object.getTrustMethod();
                if (callerConfig == null) {
                    if (authResult2 != null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s06");
                    }
                    bl = true;
                } else if (authResult2 == null) {
                    if (callerConfig.getTokenType() != null || callerConfig.getPart() != null) throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s07");
                    bl = true;
                } else {
                    object2 = callerConfig.getTokenType();
                    if (object2 == null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s08");
                    }
                    if (callerConfig.equals(authResult2._config)) {
                        bl = LoginProcessor.checkProperties(callerConfig, authResult2.getToken());
                    }
                }
                if (!bl) continue;
                bl = false;
                object2 = object.getTokenType();
                if (object2 == null) {
                    throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s09");
                }
                if (object.equals(authResult._config)) {
                    bl = LoginProcessor.checkProperties((WSSConsumerConfig.CallerConfig)object, authResult.getToken());
                }
                if (!bl) continue;
                if (token != null) {
                    throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s10");
                }
                token = authResult.getToken();
                if (object.getProperties() == null) break;
                map.put(JAAS_LOGINCONFIG, object.getProperties().get(JAAS_LOGINCONFIG));
                map.put(JAAS_PASSLOGINSUBJECT, object.getProperties().get(JAAS_PASSLOGINSUBJECT));
                break;
            }
        }
        if (!tc.isEntryEnabled()) return token;
        Tr.exit(tc, "checkCaller(Set cconfigs,Map context) returns Token[" + token + "]");
        return token;
    }

    private static boolean checkProperties(WSSConsumerConfig.CallerConfig callerConfig, Token token) {
        boolean bl;
        block8: {
            Set set;
            Map map;
            block9: {
                block7: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "checkProperties(CallerConfig cconfig[" + callerConfig + "]," + "Token token[" + token + "])");
                    }
                    bl = true;
                    map = callerConfig.getProperties();
                    if (map != null) break block7;
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "properties is null.");
                    break block8;
                }
                set = map.keySet();
                if (set != null && !set.isEmpty()) break block9;
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "CallerConfig's properties has no entry.");
                break block8;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CALLER_TOKEN_NS.equals(string) || com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CALLER_TOKEN_LN.equals(string) || JAAS_LOGINCONFIG.equals(string) || JAAS_PASSLOGINSUBJECT.equals(string)) continue;
                String string2 = (String)map.get(string);
                String[] stringArray = token.getAttributes(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "key [" + string + "], value [" + string2 + "], values [" + stringArray + "].");
                }
                if (stringArray == null || stringArray.length == 0 || stringArray.length > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "values is invalid.");
                    }
                    bl = false;
                    break;
                }
                if (string2.equals(stringArray[0])) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "value [" + string2 + "] is different from values[0] [" + stringArray[0] + "].");
                }
                bl = false;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProperties(CallerConfig cconfig,Token token) returns boolean[" + bl + "]");
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private void login(Token var1_1, Map var2_2) throws SoapSecurityException {
        block69: {
            block67: {
                block66: {
                    if (LoginProcessor.tc.isEntryEnabled()) {
                        Tr.entry(LoginProcessor.tc, "login(Token token[" + var1_1 + "]," + "Map context)");
                    }
                    var3_3 = (Subject)var2_2.get("com.ibm.wsspi.wssecurity.core.subject");
                    var4_4 = ContextManagerFactory.getInstance();
                    var5_5 = null;
                    if (var4_4 == null) {
                        Tr.error(LoginProcessor.tc, "security.wssecurity.ctxmgr.isnull");
                    } else {
                        var5_5 = var4_4.getDefaultRealm();
                    }
                    var6_6 = null;
                    var7_7 = null;
                    try {
                        var6_6 = _wsCredToken._wsCredTokenMapper;
                        if (var6_6 != null && var3_3 != null) {
                            var7_7 = var6_6.createSubjectUniqueID(var3_3);
                        }
                    }
                    catch (Exception var8_8) {
                        Tr.processException((Throwable)var8_8, LoginProcessor.clsName + ".login", "427", this);
                        if (!LoginProcessor.tc.isDebugEnabled()) break block66;
                        Tr.debug(LoginProcessor.tc, "Caught exception while getting unique ID from subject.", new Object[]{var8_8});
                    }
                }
                if (LoginProcessor.tc.isDebugEnabled()) {
                    Tr.debug(LoginProcessor.tc, "Unique ID from tokens in contextSubject: " + var7_7);
                }
                var8_9 = _authCacheClass._authCache;
                var9_10 = null;
                if (var8_9 == null) ** GOTO lbl40
                if (var7_7 == null || var7_7.length() == 0) {
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug(LoginProcessor.tc, "Unique ID based on tokens is null. Look for Subject in AuthCache using token.");
                    }
                    var9_10 = this.getCachedSubjectUsingToken(var8_9, var1_1, var5_5);
                } else {
                    try {
                        var9_10 = var8_9.getSubject(var7_7);
                    }
                    catch (CacheException var10_11) {
                        Tr.processException((Throwable)var10_11, LoginProcessor.clsName + ".login", "450", this);
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug(LoginProcessor.tc, "Caught exception while looking up subject from AuthCache.", new Object[]{var10_11});
                        }
                        break block67;
                    }
lbl40:
                    // 1 sources

                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug(LoginProcessor.tc, "Not looking Subject in cache because SecurityCache instance is null.");
                    }
                }
            }
            if (var9_10 != null) {
                var10_12 = (WSCredential)var9_10.getPublicCredentials(WSCredential.class).iterator().next();
                if (var10_12 != null) {
                    block68: {
                        var11_13 = var10_12.isDestroyed();
                        var12_14 = false;
                        try {
                            var12_14 = var10_12.isForwardable();
                        }
                        catch (Exception var13_22) {
                            var11_13 = true;
                        }
                        var13_23 = false;
                        try {
                            var13_23 = var6_6.checkCushionValidityOfAllTokens(var9_10, var8_9.getCushion());
                        }
                        catch (WSLoginFailedException var14_28) {
                            if (!LoginProcessor.tc.isDebugEnabled()) break block68;
                            Tr.debug(LoginProcessor.tc, "Exception when running checkCushionValidityOfAllTokens");
                        }
                    }
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        if (var12_14) {
                            Tr.debug(LoginProcessor.tc, "credential is forwardable, subject valid = " + var13_23);
                        } else {
                            Tr.debug(LoginProcessor.tc, "non-forwardable Subject");
                        }
                    }
                    if (var11_13 || var12_14 && !var13_23) {
                        var9_10 = null;
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug(LoginProcessor.tc, "Credential has expired or is destroyed, logging in again.");
                        }
                    } else if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug(LoginProcessor.tc, "Cached subject is valid.");
                    }
                } else {
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug(LoginProcessor.tc, "No WSCredential in Subject, logging in again.");
                    }
                    var9_10 = null;
                }
            }
            if (var9_10 != null) break block69;
            if (LoginProcessor.tc.isDebugEnabled()) {
                Tr.debug(LoginProcessor.tc, "Subject not found in AuthCache.");
            }
            var10_12 = this.getLoginConfig(var2_2);
            v0 = var11_13 = (Boolean)var2_2.get("com.ibm.wsspi.wssecurity.Caller.passSubjectToLogin") == false;
            if (LoginProcessor.tc.isDebugEnabled()) {
                Tr.debug(LoginProcessor.tc, "useOldBehavior=" + var11_13);
            }
            try {
                block71: {
                    block72: {
                        block70: {
                            if (!(var1_1 instanceof UsernameToken)) break block70;
                            var12_15 = (UsernameToken)var1_1;
                            var13_24 = var12_15.getUsername();
                            if (var13_24 == null || var13_24.length() == 0) {
                                Tr.error(LoginProcessor.tc, "security.wssecurity.WSEC6735E", new Object[]{var1_1.getType().toString(), "Login cancelled: username string is null or empty."});
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s11", "Login cancelled: username string is null or empty.");
                            }
                            var14_29 = var12_15;
                            var15_31 = (char[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                                public Object run() {
                                    return var14_29.getPassword();
                                }
                            });
                            var16_33 = null;
                            if (var15_31 != null) {
                                var16_33 = new String(var15_31);
                            }
                            if (var16_33 == null || var16_33.length() == 0) {
                                var13_24 = this.callingMappingLoginModule("system.wssecurity.IDAssertion", var1_1, var3_3, var13_24);
                                var9_10 = this.jaasLogin(var2_2, var11_13, (String)var10_12, var3_3, var13_24, var5_5);
                            } else {
                                var9_10 = this.jaasLogin(var2_2, var11_13, (String)var10_12, var3_3, var13_24, var5_5, var16_33);
                            }
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug(LoginProcessor.tc, "UsernameToken found.");
                                Tr.debug(LoginProcessor.tc, "Username [" + var13_24 + "], Password [" + (var15_31 == null ? "null" : "not null") + "].");
                            }
                            break block71;
                        }
                        if (!(var1_1 instanceof X509BSToken)) break block72;
                        var12_16 = (X509BSToken)var1_1;
                        var13_25 = UserRegistryProcessor.mapCertificate(var12_16.getCert());
                        if (var13_25 == null || var13_25.length() == 0) {
                            var13_25 = var1_1.getPrincipal();
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug(LoginProcessor.tc, "User security from X509BSToken.getPrincipal() [" + var13_25 + "]");
                            }
                        } else if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug(LoginProcessor.tc, "User security from UserRegistryProcessor.mapCertificate() [" + var13_25 + "]");
                        }
                        var13_25 = this.callingMappingLoginModule("system.wssecurity.Signature", var1_1, var3_3, var13_25);
                        var9_10 = this.jaasLogin(var2_2, var11_13, (String)var10_12, var3_3, var13_25, var5_5);
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug(LoginProcessor.tc, "X509BSToken found.");
                            Tr.debug(LoginProcessor.tc, "Username [" + var12_16.getCert().getSubjectX500Principal().getName() + "].");
                        }
                        break block71;
                    }
                    if (!(var1_1 instanceof LTPATokenWrapper)) ** GOTO lbl139
                    var13_26 = var12_17 = (LTPATokenWrapper)var1_1;
                    var14_30 = (WSCredential)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                        public Object run() {
                            return var13_26.getWSCredential();
                        }
                    });
                    var15_32 = var12_17.getWSPrincipal();
                    if (var14_30 != null) {
                        this.addToSubject(var2_2, var14_30);
                        this.addToSubject(var2_2, var15_32);
                        this.addToSubject(var2_2, var1_1);
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug(LoginProcessor.tc, "LTPATokenWrapper found.");
                            Tr.debug(LoginProcessor.tc, "WSCredential [" + var14_30 + "].");
                            Tr.debug(LoginProcessor.tc, "WSPrincipal [" + var15_32 + "].");
                        }
                    } else {
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug(LoginProcessor.tc, "No WSCredential found in LTPATokenWrapper.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.WSEC0168E");
lbl139:
                        // 1 sources

                        if (var1_1 instanceof LTPAToken) {
                            var12_18 = (LTPAToken)var1_1;
                            var13_27 = (byte[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                                public Object run() {
                                    return var12_18.getBytes();
                                }
                            });
                            if (var13_27 == null) {
                                if (LoginProcessor.tc.isDebugEnabled()) {
                                    Tr.debug(LoginProcessor.tc, "Null credential value found for the LTPA token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s12", "Login cancelled by invalid token.");
                            }
                            var9_10 = this.jaasLogin(var2_2, var11_13, (String)var10_12, var3_3, var13_27);
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug(LoginProcessor.tc, "LTPA Token found.");
                                Tr.debug(LoginProcessor.tc, "Credential [" + var13_27 + "].");
                            }
                        } else {
                            var12_19 = var1_1.getPrincipal();
                            if (var12_19 == null) {
                                if (LoginProcessor.tc.isDebugEnabled()) {
                                    Tr.debug(LoginProcessor.tc, "Null principal value found for the custom token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", "Login cancelled by invalid token.");
                            }
                            if ((var12_19 = var12_19.trim()).length() == 0) {
                                if (LoginProcessor.tc.isDebugEnabled()) {
                                    Tr.debug(LoginProcessor.tc, "Principal value is zero length value for the custom token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", "Login cancelled by invalid token.");
                            }
                            var12_19 = this.callingMappingLoginModule("system.wssecurity.IDAssertion", var1_1, var3_3, var12_19);
                            var9_10 = this.jaasLogin(var2_2, var11_13, (String)var10_12, var3_3, var12_19, var5_5);
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug(LoginProcessor.tc, "Token [" + var1_1.getType() + "] found.");
                                Tr.debug(LoginProcessor.tc, "Principal [" + var1_1.getPrincipal() + "].");
                            }
                        }
                    }
                }
                if (var6_6 == null || var9_10 == null || var8_9 == null) ** GOTO lbl196
                if (var11_13) {
                    this.addTokensToLoginSubject(var2_2, var9_10);
                } else {
                    var3_3.getPrincipals().clear();
                    var3_3.getPublicCredentials().clear();
                    var3_3.getPrivateCredentials().clear();
                    LoginProcessor.syncSubject(var9_10, var3_3, false);
                }
                var7_7 = var6_6.createSubjectUniqueID(var9_10);
                if (var7_7 == null || var7_7.length() == 0) {
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug(LoginProcessor.tc, "Unique ID is null. Adding Subject to AuthCache");
                    }
                    var8_9.insert(var9_10);
                }
                if (LoginProcessor.tc.isDebugEnabled()) {
                    Tr.debug(LoginProcessor.tc, "Adding Subject with ID " + var7_7 + " to AuthCache");
                }
                var8_9.insert(var9_10, new Object[]{var7_7});
            }
            catch (LoginException var12_20) {
                Tr.processException((Throwable)var12_20, LoginProcessor.clsName + ".login", "687", this);
                Tr.error(LoginProcessor.tc, "security.wssecurity.WSEC6735E", new Object[]{var1_1.getType().toString(), var12_20});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s11", (Throwable)var12_20);
            }
            catch (Exception var12_21) {
                Tr.processException((Throwable)var12_21, LoginProcessor.clsName + ".login", "692", this);
                Tr.error(LoginProcessor.tc, "security.wssecurity.WSEC6735E", new Object[]{var1_1.getType().toString(), var12_21});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s11", (Throwable)var12_21);
            }
        }
        if (LoginProcessor.tc.isDebugEnabled()) {
            Tr.debug(LoginProcessor.tc, "Subject found in AuthCache.");
        }
        LoginProcessor.addToSubject(var2_2, var9_10);
lbl196:
        // 4 sources

        if (LoginProcessor.tc.isDebugEnabled()) {
            Tr.debug(LoginProcessor.tc, "Subject after authentication: " + var9_10);
        }
        var1_1.setUsedToLogin(true);
        if (LoginProcessor.tc.isEntryEnabled()) {
            Tr.exit(LoginProcessor.tc, "login(Token token, Map context)");
        }
    }

    private String callingMappingLoginModule(String string, Token token, Subject subject, String string2) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callingMappingLoginModule(jassLoginConfig=[" + string + "], token=[" + token + "], contextSubject=[" + subject + "], identity=[" + string2 + "])");
        }
        String string3 = null;
        try {
            Tr.debug(tc, "Normalizing identity");
            string3 = KeyStoreKeyLocator.encodedName(string2);
            Tr.debug(tc, "securityName=[" + string3 + "]");
        }
        catch (KeyLocatorException keyLocatorException) {
            Tr.debug(tc, "Error normalizing identity, securityName=[" + string3 + "]");
            string3 = string2;
        }
        WSCallbackHandlerFactoryImpl wSCallbackHandlerFactoryImpl = new WSCallbackHandlerFactoryImpl();
        wSCallbackHandlerFactoryImpl.setXMLToken(token.getElement());
        wSCallbackHandlerFactoryImpl.setUsername(string3);
        HashMap hashMap = new HashMap();
        wSCallbackHandlerFactoryImpl.setProperties(hashMap);
        LoginContext loginContext = new LoginContext(string, subject, wSCallbackHandlerFactoryImpl.newCallbackHandler());
        loginContext.login();
        String string4 = (String)hashMap.get("LoginUsername");
        if (string4 != null && (string4 = string4.trim()).length() != 0) {
            string3 = string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callingMappingLoginModule() returns " + string3);
        }
        return string3;
    }

    public static void addToSubject(Map map, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSubject(context, loginSubject)");
        }
        Subject subject2 = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        LoginProcessor.syncSubject(subject, subject2, true);
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSubject(context, loginSubject)");
        }
    }

    private void addToSubject(Map map, final WSCredential wSCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSubject(context, wsCred)");
        }
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                if (!subject.getPublicCredentials().contains(wSCredential)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding WSCredential to Subject: " + wSCredential);
                    }
                    subject.getPublicCredentials().add(wSCredential);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential already in Subject: " + wSCredential);
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSubject(context, wsCred)");
        }
    }

    private void addToSubject(Map map, final Token token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSubject(context, token)");
        }
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                if (!subject.getPrivateCredentials().contains(token)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Token to Subject: " + token);
                    }
                    subject.getPrivateCredentials().add(token);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token already in Subject: " + token);
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSubject(context, token)");
        }
    }

    private void addToSubject(Map map, final WSPrincipal wSPrincipal) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSubject(context, princ)");
        }
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                if (!subject.getPrincipals().contains(wSPrincipal)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding WSPrincipal to Subject: " + wSPrincipal);
                    }
                    subject.getPrincipals().add(wSPrincipal);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSPrincipal already in Subject: " + wSPrincipal);
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSubject(context, princ)");
        }
    }

    private void addTokensToLoginSubject(Map map, final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTokensToLoginSubject(context, loginSubject)");
        }
        final Subject subject2 = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Iterator<Object> iterator = subject2.getPrivateCredentials().iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (object == null) continue;
                    if (!subject.getPrivateCredentials().contains(object)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding private object to Subject: " + object);
                        }
                        subject.getPrivateCredentials().add(object);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Private object already in Subject: " + object);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTokensToLoginSubject(context, loginSubject)");
        }
    }

    private void cacheInformation(Token token, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheInformation(Token token[" + token + "]," + "Map context)");
        }
        Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
        } else {
            contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderId", subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initial Sender is set.");
            }
            subject = (Subject)contextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderId");
            if (token instanceof X509BSToken) {
                X509Certificate x509Certificate = ((X509BSToken)token).getCert();
                contextManager.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", x509Certificate);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Cert is set.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheInformation(Token token,Map context)");
        }
    }

    private Subject getCachedSubjectUsingToken(SecurityCache securityCache, Token token, String string) {
        Subject subject;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCachedSubjectUsingToken(cache, token, realm)");
            }
            subject = null;
            if (securityCache != null && token != null) {
                try {
                    if (token instanceof UsernameToken) {
                        UsernameToken usernameToken = (UsernameToken)token;
                        String string2 = usernameToken.getUsername();
                        if (string2 != null && string2.length() > 0) {
                            char[] cArray = null;
                            final UsernameToken usernameToken2 = usernameToken;
                            cArray = (char[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                                public Object run() {
                                    return usernameToken2.getPassword();
                                }
                            });
                            String string3 = null;
                            if (cArray != null) {
                                string3 = new String(cArray);
                            }
                            subject = string3 == null || string3.length() == 0 ? securityCache.getSubject(string, string2) : securityCache.getSubject(string, string2, string3);
                        }
                    } else if (token instanceof LTPATokenWrapper) {
                        subject = null;
                    } else if (token instanceof LTPAToken) {
                        final LTPAToken lTPAToken = (LTPAToken)token;
                        byte[] byArray = (byte[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                            public Object run() {
                                return lTPAToken.getBytes();
                            }
                        });
                        if (byArray != null) {
                            subject = securityCache.getSubject(byArray);
                        }
                    } else if (token instanceof X509BSToken) {
                        X509BSToken x509BSToken = (X509BSToken)token;
                        String string4 = UserRegistryProcessor.mapCertificate(x509BSToken.getCert());
                        if (string4 == null || string4.length() == 0) {
                            string4 = token.getPrincipal();
                        }
                        subject = securityCache.getSubject(string, string4);
                    } else if (token.getPrincipal() != null) {
                        subject = securityCache.getSubject(string, token.getPrincipal());
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Caught exception looking up Subject from AuthCache: " + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCachedSubjectUsingToken: returning Subject = " + subject);
        }
        return subject;
    }

    private Subject jaasLogin(Map map, boolean bl, String string, Subject subject, String string2, String string3) throws LoginException, WSLoginFailedException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm)");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
            }
            securityManager.checkPermission(MAP_CREDENTIAL);
        }
        if (string2 == null || string2.length() == 0) {
            throw new WSLoginFailedException("Username is null.");
        }
        LoginContext loginContext = this.getLoginContext(bl, string, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string3, (String)null));
        loginContext.login();
        Subject subject2 = loginContext.getSubject();
        if (subject2 == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        if (bl) {
            LoginProcessor.addToSubject(map, subject2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm)");
        }
        return subject2;
    }

    private Subject jaasLogin(Map map, boolean bl, String string, Subject subject, String string2, String string3, String string4) throws LoginException, WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm, password)");
        }
        if (string2 == null || string2.length() == 0 || string4 == null || string4.length() == 0) {
            throw new WSLoginFailedException("Username and/or password is null.");
        }
        LoginContext loginContext = this.getLoginContext(bl, string, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string3, string4));
        loginContext.login();
        Subject subject2 = loginContext.getSubject();
        if (subject2 == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        if (bl) {
            LoginProcessor.addToSubject(map, subject2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm, password)");
        }
        return subject2;
    }

    private Subject jaasLogin(Map map, boolean bl, String string, Subject subject, byte[] byArray) throws LoginException, WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jaasLogin(context, useOldBehavior, authMech, contextSubject, bytes)");
        }
        LoginContext loginContext = this.getLoginContext(bl, string, subject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(byArray));
        loginContext.login();
        Subject subject2 = loginContext.getSubject();
        if (subject2 == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        if (bl) {
            LoginProcessor.addToSubject(map, subject2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaasLogin(context, useOldBehavior, authMech, contextSubject, bytes)");
        }
        return subject2;
    }

    private static void syncSubject(final Subject subject, final Subject subject2, final boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "syncSubject(source, target, reportErrors=" + bl + ")");
        }
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Iterator<Principal> iterator;
                Iterator<Object> iterator2;
                Iterator<Object> iterator3 = subject.getPublicCredentials().iterator();
                while (iterator3.hasNext()) {
                    iterator2 = iterator3.next();
                    if (iterator2 == null) continue;
                    if (!subject2.getPublicCredentials().contains(iterator2)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding public object to Subject: " + iterator2);
                        }
                        subject2.getPublicCredentials().add(iterator2);
                        continue;
                    }
                    if (bl) {
                        Tr.error(tc, "security.wssecurity.LoginProcessor.s15");
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Public object already in Subject: " + iterator2);
                }
                iterator2 = subject.getPrivateCredentials().iterator();
                while (iterator2.hasNext()) {
                    iterator = iterator2.next();
                    if (iterator == null) continue;
                    if (!subject2.getPrivateCredentials().contains(iterator)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding private object to Subject: " + iterator);
                        }
                        subject2.getPrivateCredentials().add(iterator);
                        continue;
                    }
                    if (bl) {
                        if (iterator instanceof Token) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "ws-sec Token private object already in Subject: " + iterator);
                            continue;
                        }
                        Tr.error(tc, "security.wssecurity.LoginProcessor.s16");
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Private object already in Subject: " + iterator);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Private object already in Subject: " + iterator);
                }
                iterator = subject.getPrincipals().iterator();
                while (iterator.hasNext()) {
                    Principal principal = iterator.next();
                    if (principal == null) continue;
                    if (!subject2.getPrincipals().contains(principal)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding principal object to Subject: " + principal);
                        }
                        subject2.getPrincipals().add(principal);
                        continue;
                    }
                    if (bl) {
                        Tr.error(tc, "security.wssecurity.LoginProcessor.s14");
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Principal object already in Subject: " + principal);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "syncSubject(source, target, reportErrors=" + bl + ")");
        }
    }

    private String getLoginConfig(Map map) throws SoapSecurityException {
        SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginConfig");
        }
        String string = null;
        boolean bl = false;
        string = (String)map.get(JAAS_LOGINCONFIG);
        if (ConfigUtil.hasValue(string)) {
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting com.ibm.wsspi.wssecurity.Caller.passSubjectToLogin to " + bl);
            }
        } else if (securityConfiguration != null) {
            string = securityConfiguration.getAuthMechAuthAlias();
            bl = ConfigUtil.getIsTrueProperty(map, JAAS_PASSLOGINSUBJECT);
        } else {
            map.remove(JAAS_PASSLOGINSUBJECT);
            map.remove(JAAS_LOGINCONFIG);
            throw new SoapSecurityException("JAAS Login Configuration is NULL for Caller Processing");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authMech is " + string);
            Tr.debug(tc, "passLoginSubject is " + bl);
        }
        map.put(JAAS_LOGINCONFIG, string);
        map.put(JAAS_PASSLOGINSUBJECT, new Boolean(bl));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginConfig");
        }
        return string;
    }

    private LoginContext getLoginContext(boolean bl, String string, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        LoginContext loginContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginContext");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating LoginContext without Subject");
            }
            loginContext = new LoginContext(string, callbackHandler);
        } else {
            Subject subject2 = new Subject();
            LoginProcessor.syncSubject(subject, subject2, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating LoginContext with Subject");
            }
            loginContext = new LoginContext(string, subject2, callbackHandler);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginContext");
        }
        return loginContext;
    }

    private static class _authCacheClass {
        static SecurityCache _authCache = null;
        private static final String FACTORY_CLASS = "com.ibm.ws.security.auth.AuthCache";

        private _authCacheClass() {
        }

        private static Method getAuthCacheGetInstanceMethod() {
            Method method2 = null;
            Class clazz = _authCacheClass.getAuthCacheClass();
            if (clazz != null) {
                try {
                    method2 = clazz.getMethod("getInstance", null);
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".getAuthCacheGetInstanceMethod", "1170");
                    throw new UndeclaredThrowableException(exception);
                }
            }
            return method2;
        }

        private static Class getAuthCacheClass() {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz2 = classLoader != null ? classLoader.loadClass(FACTORY_CLASS) : Class.forName(FACTORY_CLASS);
                clazz = clazz2;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".getAuthCacheClass", "1197");
                throw new UndeclaredThrowableException(exception);
            }
            return clazz;
        }

        static {
            try {
                Method method2 = _authCacheClass.getAuthCacheGetInstanceMethod();
                if (method2 != null) {
                    _authCache = (SecurityCache)method2.invoke(null, null);
                    if (tc.isDebugEnabled()) {
                        if (_authCache == null) {
                            Tr.debug(tc, "AuthCache.getInstance method returned null.");
                        } else {
                            Tr.debug(tc, "AuthCache.getInstance method returned an AuthCache instance.");
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get AuthCache.getInstance method.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, clsName + "init", "1154");
            }
        }
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, clsName + "init", "1130");
            }
        }
    }
}

