/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.token;

import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.WebSphereSecurityImpl.SecurityServerImpl;
import com.ibm.websphere.security.UserMapping;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;
import java.security.cert.X509Certificate;
import javax.security.auth.login.LoginException;

public class UserRegistryProcessor {
    private static final TraceComponent tc = Tr.register(UserRegistryProcessor.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UserRegistryProcessor.class.getName();
    private static UserMapping _userMapping;
    private static final String USERMAPPING_IMPL = "com.ibm.ws.security.core.UserMappingImpl";
    private static final Permission PERM;

    public static boolean checkRegistry(String string, char[] cArray) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRegistry()");
        }
        boolean bl = false;
        try {
            SecurityServer securityServer;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (contextManager != null && (securityServer = SecServer.instance) != null) {
                if (tc.isDebugEnabled()) {
                    String string2 = cArray == null ? "null" : "not mull";
                    Tr.debug(tc, "Username [" + string + "], password [" + string2 + "]");
                }
                bl = securityServer.simple_authenticate(new BasicAuthData(string, new String(cArray)));
            }
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".checkRegistry", "%C");
            Tr.error(tc, "security.wssecurity.UserRegistryProcessor.s01", new Object[]{string, exception});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.UserRegistryProcessor.s01", new String[]{string, exception.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRegistry() returns boolean[" + bl + "]");
        }
        return bl;
    }

    public static boolean checkUsername(String string) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkUsername(String username[" + string + "])");
        }
        boolean bl = false;
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (contextManager != null) {
                SecurityServer securityServer = SecServer.instance;
                if (securityServer != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Username [" + string + "]");
                }
                UserRegistry userRegistry = securityServer.getRegistry(contextManager.getDefaultRealm());
                bl = userRegistry.isValidUser(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "registry.isValidUser() [" + string + "] = " + bl);
                }
                if (!bl) {
                    String string2 = userRegistry.getUserSecurityName(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "registry.getUserSecurityName()=" + string2);
                    }
                    bl = userRegistry.isValidUser(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "registry.isValidUser() [" + string2 + "] = " + bl);
                    }
                }
            }
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".checkUsername", "%C");
            Tr.error(tc, "security.wssecurity.UserRegistryProcessor.s02", new Object[]{string, exception});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.UserRegistryProcessor.s02", new String[]{string, exception.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkUsername(String username) returns boolean[" + bl + "]");
        }
        return bl;
    }

    static String mapCertificate(X509Certificate x509Certificate) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate(X509Certificate [" + x509Certificate + "])");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(PERM);
        }
        String string = null;
        UserMapping userMapping = _userMapping;
        if (userMapping != null) {
            try {
                string = userMapping.mapCertificateToName(new X509Certificate[]{x509Certificate});
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".mapCertificate", "84");
                Tr.warning(tc, "security.wssecurity.WSEC5185W", new Object[]{x509Certificate.getSubjectDN().getName(), exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate(X509Certificate) returns " + string);
        }
        return string;
    }

    static {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UserMapping Init");
        }
        if (ContextManagerFactory.getInstance().isServerSecurityEnabled() && WSSecurityPlatformContextFactory.getInstance().isServer()) {
            try {
                Class clazz = UserRegistryProcessor.class;
                Class<?> clazz2 = Class.forName(USERMAPPING_IMPL);
                _userMapping = (UserMapping)clazz2.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tr.processException(classNotFoundException, clsName + ".getUserMapping", "183");
                Tr.error(tc, "security.wssecurity.WSEC5186E", new Object[]{USERMAPPING_IMPL, classNotFoundException});
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.processException(illegalAccessException, clsName + ".getUserMapping", "186");
                Tr.error(tc, "security.wssecurity.WSEC5188E", new Object[]{USERMAPPING_IMPL, illegalAccessException});
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".getUserMapping", "189");
                Tr.error(tc, "security.wssecurity.WSEC5187E", new Object[]{USERMAPPING_IMPL, exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UserMapping Init");
        }
        PERM = new WebSphereRuntimePermission("wssecurity.WSUserRegistry.mapCertificate");
    }

    private static class SecServer {
        private static SecurityServer instance;

        private SecServer() {
        }

        private static void init() {
            try {
                instance = new SecurityServerImpl();
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".SecServer.init", "58");
                throw new ExceptionInInitializerError(exception);
            }
        }

        static {
            SecServer.init();
        }
    }
}

