/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.webservices.engine.MessageContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import org.omg.Security.InvalidCredentialType;
import org.omg.SecurityLevel2.InvalidCredential;

public final class CORBAHelper {
    private static final ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final HashMap originalCallerSubject = new HashMap();
    private static final HashMap originalInvocationSubject = new HashMap();
    private static final TraceComponent tc = Tr.register(CORBAHelper.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String FFDC_SOURCE_ID = "com.ibm.ws.webservices.wssecurity.util.CORBAHelper";
    private static SecurityServer securityServer = null;
    private static final Permission MAP_CREDENTIAL;

    public static boolean isSecurityEnabled() {
        return SecurityContext.isSecurityEnabled();
    }

    public static synchronized void pushCredential(Subject subject, MessageContext messageContext) throws InvalidCredentialType, InvalidCredential {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushCredential(" + subject + ", " + messageContext + ")");
        }
        if (contextManager != null && contextManager.isCellSecurityEnabled()) {
            try {
                Subject subject2 = contextManager.getInvocationSubject();
                Subject subject3 = contextManager.getCallerSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original Caller Subject", subject3);
                    Tr.debug(tc, "Original Invocation Subject", subject2);
                    Tr.debug(tc, "Replace Caller and Invocation Subjects with", subject);
                }
                contextManager.setInvocationSubject(subject);
                contextManager.setCallerSubject(subject);
                originalInvocationSubject.put(messageContext, subject2);
                originalCallerSubject.put(messageContext, subject3);
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException(wSSecurityException, CORBAHelper.class.getName() + ".pushCredential()", "143");
                if (tc.isDebugEnabled()) {
                    StringWriter stringWriter = new StringWriter();
                    wSSecurityException.printStackTrace(new PrintWriter(stringWriter));
                    Tr.debug(tc, "Exception in set Caller/Invocation Subject" + stringWriter.toString());
                }
                throw new InvalidCredential();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushCredential()");
        }
    }

    public static synchronized void popCredential(MessageContext messageContext) throws InvalidCredentialType, InvalidCredential {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popCredential(" + messageContext + ")");
        }
        if (contextManager != null && contextManager.isCellSecurityEnabled()) {
            Subject subject = (Subject)originalCallerSubject.remove(messageContext);
            Subject subject2 = (Subject)originalInvocationSubject.remove(messageContext);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Original caller subject", subject);
                Tr.debug(tc, "Original Invocation Subject", subject2);
            }
            try {
                contextManager.setCallerSubject(subject);
                contextManager.setInvocationSubject(subject2);
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException(wSSecurityException, CORBAHelper.class.getName() + ".pushCredential()", "176");
                if (tc.isDebugEnabled()) {
                    StringWriter stringWriter = new StringWriter();
                    wSSecurityException.printStackTrace(new PrintWriter(stringWriter));
                    Tr.debug(tc, "Exception in set Caller/Invocation Subject" + stringWriter.toString());
                }
                throw new InvalidCredential();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popCredential()");
        }
    }

    public static String getSecurityName() {
        String string;
        block18: {
            WSCredential wSCredential;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getSecurityName()");
                }
                string = null;
                wSCredential = null;
                try {
                    wSCredential = contextManager.getInvocationCredential();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invocation creds = " + (wSCredential == null ? "null" : wSCredential.toString()));
                    }
                }
                catch (WSSecurityException wSSecurityException) {
                    string = null;
                    FFDCFilter.processException(wSSecurityException, FFDC_SOURCE_ID, "313");
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Error in getting security name from credential " + wSSecurityException.toString());
                }
            }
            try {
                if (wSCredential != null) {
                    string = wSCredential.getRealmSecurityName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invocation creds securityName = " + string);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Try getting the principal from received creds");
                    }
                    WSCredential[] wSCredentialArray = contextManager.getCallerCredentials();
                    wSCredential = null;
                    if (wSCredentialArray != null && wSCredentialArray.length != 0) {
                        wSCredential = wSCredentialArray[0];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Received cred = " + wSCredential);
                        }
                        if (wSCredential != null) {
                            string = wSCredential.getRealmSecurityName();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Received cred securityName = " + string);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Received creds = null");
                    }
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                string = null;
                FFDCFilter.processException(generalSecurityException, FFDC_SOURCE_ID, "351");
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "Error in getting security name from credential ", generalSecurityException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName() --> " + string);
        }
        return string;
    }

    static {
        if (contextManager.isCellSecurityEnabled()) {
            InitialContext initialContext = null;
            try {
                initialContext = new InitialContext();
            }
            catch (NamingException namingException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to get initial naming context");
                }
                Tr.error(tc, "security.wssecurity.getting.initialctx.error", new Object[]{namingException});
            }
            if (initialContext != null) {
                try {
                    Object object = initialContext.lookup("SecurityServer");
                    securityServer = (SecurityServer)PortableRemoteObject.narrow((Object)object, (Class)SecurityServer.class);
                }
                catch (NamingException namingException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to lookup Security Server");
                    }
                    Tr.error(tc, "security.wssecurity.securityserver.lookup.error", new Object[]{namingException});
                }
            }
        }
        MAP_CREDENTIAL = new WebSphereRuntimePermission("wssecurity.mapCredential");
    }
}

