/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfidentialDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(ConfidentialDialectElementSelector.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = ConfidentialDialectElementSelector.class.getName();
    public static final int BODYCONTENT = 0;
    public static final int USERNAMETOKEN = 1;
    public static final int DIGESTVALUE = 2;
    public static final int SIGNATURE = 3;
    public static final int WSCONTEXTCONTENT = 4;
    public static final String[] WASDIALECTS = new String[]{"bodycontent".intern(), "usernametoken".intern(), "digestvalue".intern(), "signature".intern(), "wscontextcontent".intern()};

    public void init(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(Node node[" + node + "]," + "Map context)");
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        if (!(node instanceof Document)) {
            throw SoapSecurityException.format("security.wssecurity.IntegralDialectElementSelector.s01", node.getClass().getName(), "Document");
        }
        String string = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + string + "]");
        }
        if (string == null) {
            throw SoapSecurityException.format("Null is not allowed as the WAS dialect");
        }
        if (!Constants.DIALECT_WAS.equals(string)) {
            throw SoapSecurityException.format(clsName + " does not allow the dialect: " + string + ".");
        }
        String string2 = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keyword [" + string2 + "]");
        }
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.util.selector.operation");
        boolean bl = "encryption_mode".equals((String)v);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + v + "]");
        }
        String string3 = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + string3 + "]");
        }
        Object[] objectArray = (Object[])map.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + objectArray + "]");
        }
        Set set = (Set)map.get("com.ibm.ws.webservices.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token configurations [" + set + "]");
        }
        Duration duration = (Duration)map.get("security.wssecurity.integraldialectelementselector.duration");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Duration [" + duration + "]");
        }
        NonceManager nonceManager = (NonceManager)map.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        v = map.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string4 = Constants.NAMESPACES[2][n];
        v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string5 = Constants.NAMESPACES[0][n];
        String string6 = Constants.NAMESPACES[1][n];
        Document document = (Document)node;
        Element element = document.getDocumentElement();
        NodeList nodeList = null;
        if (WASDIALECTS[0].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[0] + "]");
            }
            nodeList = new XPathCanonicalizer.NodeListImpl();
            Object object = null;
            try {
                object = element instanceof SOAPEnvelope ? ((SOAPEnvelope)element).getBody() : DOMUtil.getOneChildElement(element, string4, "Body");
            }
            catch (SOAPException sOAPException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception from SOAPEnvelope.getBody()" + (Object)((Object)sOAPException));
                }
                FFDCFilter.processException((Throwable)sOAPException, this.getClass().getName() + ".getElements", "194", this);
                throw new SoapSecurityException(sOAPException);
            }
            ((XPathCanonicalizer.NodeListImpl)nodeList).add((Node)object);
            nodeList = new PartList("http://www.w3.org/2001/04/xmlenc#Content", nodeList);
        } else if (WASDIALECTS[1].equals(string2)) {
            Element element2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[1] + "]");
            }
            if ((element2 = IntegralDialectElementSelector.getSecurityHeader(map, document)) != null) {
                nodeList = DOMUtil.getOneOrMoreChildElements(element2, string5, "UsernameToken");
            }
            nodeList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", nodeList);
        } else if (WASDIALECTS[2].equals(string2)) {
            Element element3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[2] + "]");
            }
            if ((element3 = IntegralDialectElementSelector.getSecurityHeader(map, document)) != null) {
                nodeList = DOMUtil.getOneOrMoreElements(element3, Constants.NS_DSIG, "DigestValue");
            }
            nodeList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", nodeList);
        } else if (WASDIALECTS[3].equals(string2)) {
            Element element4;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[3] + "]");
            }
            if ((element4 = IntegralDialectElementSelector.getSecurityHeader(map, document)) != null) {
                nodeList = DOMUtil.getOneOrMoreChildElements(element4, Constants.NS_DSIG, "Signature");
            }
            nodeList = new PartList("http://www.w3.org/2001/04/xmlenc#Element", nodeList);
        } else if (WASDIALECTS[4].equals(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing the keyword [" + WASDIALECTS[4] + "]");
            }
            nodeList = IntegralDialectElementSelector.getWSContextHeaderElement(document);
            nodeList = new PartList("http://www.w3.org/2001/04/xmlenc#Content", nodeList);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s03", string2);
        }
        if (string3 != null && bl && (nodeList = IntegralDialectElementSelector.postprocess(document, string3, nodeList, objectArray, duration, string5, string6, nonceManager, false, bl, string, string2)) != null && nodeList.getLength() > 0) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(Node node,Map context) returns NodeList[" + nodeList + "]");
        }
        return nodeList;
    }
}

