/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceUtil {
    private static final String comp = "security.wssecurity";
    private static final String clsName = NamespaceUtil.class.getName();

    public static int checkSoapVersion(Node node, int n, String string) {
        return NamespaceUtil.checkVersion(node.getNamespaceURI(), node.getLocalName(), 2, n, string);
    }

    public static int checkWsseVersion(Node node, int n, String string) {
        return NamespaceUtil.checkVersion(node.getNamespaceURI(), node.getLocalName(), 0, n, string);
    }

    public static int checkWsuVersion(Node node, int n, String string) {
        return NamespaceUtil.checkVersion(node.getNamespaceURI(), node.getLocalName(), 1, n, string);
    }

    public static int checkWsseVersion(QName qName, int n, String string) {
        return NamespaceUtil.checkVersion(qName.getNamespaceURI(), qName.getLocalPart(), 0, n, string);
    }

    public static int checkWsuVersion(QName qName, int n, String string) {
        return NamespaceUtil.checkVersion(qName.getNamespaceURI(), qName.getLocalPart(), 1, n, string);
    }

    private static int checkVersion(String string, String string2, int n, int n2, String string3) {
        if (string2 == null || string3 == null) {
            return -1;
        }
        if (!string2.equals(string3)) {
            return -1;
        }
        int n3 = NamespaceUtil.compareNS(string, n);
        if (n2 >= 0) {
            if (n3 == n2) {
                return n2;
            }
        } else if (n3 >= 0) {
            return n3;
        }
        return -1;
    }

    public static int isSoap(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals(Constants.NS_SOAP)) {
            return 0;
        }
        return string.equals(Constants.NS_SOAP12) ? 1 : -1;
    }

    public static int isWsse(String string) {
        if (string == null) {
            return -1;
        }
        return string.equals(Constants.NS_WSSE) ? 0 : -1;
    }

    public static int isWsu(String string) {
        if (string == null) {
            return -1;
        }
        return string.equals(Constants.NS_WSU) ? 0 : -1;
    }

    private static final int compareNS(String string, int n) {
        for (int i = 0; i < Constants.NAMESPACES[n].length; ++i) {
            if (string != Constants.NAMESPACES[n][i]) continue;
            return i;
        }
        return -1;
    }

    public static NodeList getWsseElementsByTagName(Element element, String string) {
        return NamespaceUtil.getXElementsByTagName(element, string, 0);
    }

    private static NodeList getXElementsByTagName(Element element, String string, int n) {
        NodeList nodeList = null;
        for (int i = 0; i < Constants.NAMESPACES[n].length; ++i) {
            nodeList = element.getElementsByTagNameNS(Constants.NAMESPACES[n][i], string);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            return nodeList;
        }
        return nodeList;
    }

    public static NodeList getWsuElementsByTagName(Element element, String string) {
        return NamespaceUtil.getXElementsByTagName(element, string, 1);
    }

    public static Element getFirstWsseElement(Element element, String string) {
        Element element2 = null;
        for (int i = 0; i < Constants.NAMESPACES[0].length; ++i) {
            element2 = DOMUtil.getFirstElement(element, Constants.NAMESPACES[0][i], string);
            if (element2 == null) continue;
            return element2;
        }
        return element2;
    }

    public static Element getFirstWsuElement(Element element, String string) {
        Element element2 = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            element2 = DOMUtil.getFirstElement(element, Constants.NAMESPACES[1][i], string);
            if (element2 == null) continue;
            return element2;
        }
        return element2;
    }

    public static SOAPHeaderElement getWsseHeaderByName(SOAPEnvelope sOAPEnvelope, String string) throws SoapSecurityException {
        return NamespaceUtil.getHeaderByName(sOAPEnvelope, string, 0);
    }

    public static SOAPHeaderElement getWsuHeaderByName(SOAPEnvelope sOAPEnvelope, String string) throws SoapSecurityException {
        return NamespaceUtil.getHeaderByName(sOAPEnvelope, string, 1);
    }

    private static SOAPHeaderElement getHeaderByName(SOAPEnvelope sOAPEnvelope, String string, int n) throws SoapSecurityException {
        SOAPHeaderElement sOAPHeaderElement = null;
        try {
            for (int i = 0; i < Constants.NAMESPACES[n].length; ++i) {
                SOAPHeaderElement sOAPHeaderElement2 = NamespaceUtil.getHeaderByName(sOAPEnvelope, Constants.NAMESPACES[n][i], string);
                if (sOAPHeaderElement2 == null) continue;
                sOAPHeaderElement = sOAPHeaderElement2;
                break;
            }
        }
        catch (SOAPException sOAPException) {
            Tr.processException(sOAPException, clsName + ".invoke", "333");
            String string2 = n == 0 ? "wsse:" : "wsu:";
            throw SoapSecurityException.format("security.wssecurity.NamespaceUtil.s01", string2 + string, sOAPException.getMessage());
        }
        return sOAPHeaderElement;
    }

    private static SOAPHeaderElement getHeaderByName(SOAPEnvelope sOAPEnvelope, String string, String string2) throws SOAPException {
        SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
        Element element = DOMUtil.getChildElement((Element)sOAPHeader, string, string2);
        if (element == null) {
            return null;
        }
        return (SOAPHeaderElement)((Object)element);
    }

    public static String getWsuAttribute(Element element, String string) {
        String string2 = null;
        for (int i = 0; i < Constants.NAMESPACES[1].length; ++i) {
            string2 = element.getAttributeNS(Constants.NAMESPACES[1][i], string);
            if (string2.length() == 0) continue;
            return string2;
        }
        return string2;
    }

    public static int checkVersion(QName qName, QName qName2) {
        String string;
        if (qName == null || qName2 == null) {
            return -1;
        }
        String string2 = qName.getLocalPart();
        if (string2 != (string = qName2.getLocalPart())) {
            return -1;
        }
        String string3 = qName.getNamespaceURI();
        String string4 = qName2.getNamespaceURI();
        if (string4 == Constants.NAMESPACES[0][0]) {
            return NamespaceUtil.compareNS(string3, 0);
        }
        if (string4 == Constants.NAMESPACES[1][0]) {
            return NamespaceUtil.compareNS(string3, 1);
        }
        return -1;
    }

    public static boolean equals(QName qName, QName qName2) {
        if (qName == null || qName2 == null) {
            return false;
        }
        if (qName.equals(qName2)) {
            return true;
        }
        return NamespaceUtil.checkVersion(qName, qName2) > 0;
    }
}

