/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import javax.xml.soap.SOAPException;

public class WSSoapSecurityUtil {
    private static final TraceComponent tc = Tr.register(WSSoapSecurityUtil.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSoapSecurityUtil.class.getName();

    public static SOAPPort getServiceHandler(MessageContext messageContext) {
        SOAPPort sOAPPort;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServiceHandler", messageContext);
            }
            if ((sOAPPort = messageContext.getPort()) == null) {
                try {
                    Message message = messageContext.getRequestMessage();
                    message.getSOAPEnvelope().getBody();
                    sOAPPort = messageContext.getPort();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Target service", sOAPPort);
                    }
                }
                catch (SOAPException sOAPException) {
                    Tr.processException(sOAPException, clsName + ".getServiceHandler", "119");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "security.wssecurityUnable to find the target service", (Object)sOAPException);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    Tr.processException(webServicesFault, clsName + ".getServiceHandler", "124");
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "security.wssecurityUnable to find the target service", webServicesFault);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceHandler", sOAPPort);
        }
        return sOAPPort;
    }
}

