/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.dsig.PartList;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.XPathTransformer;
import com.ibm.ws.wssecurity.xss4j.dsig.util.XPathUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(XPathElementSelector.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XPathElementSelector.class.getName();

    public void init(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map map) throws SoapSecurityException {
        NodeList nodeList;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(Node node[" + node + "]," + "Map context)");
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String string = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Dialect [" + string + "]");
        }
        if (string == null) {
            throw SoapSecurityException.format("Null is not allowed as the WAS dialect");
        }
        if (!Constants.DIALECT_XPATH.equals(string) && !Constants.DIALECT_FUNCTION.equals(string)) {
            throw SoapSecurityException.format(clsName + " does not allow the dialect: " + string + ".");
        }
        String string2 = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keyword [" + string2 + "]");
        }
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.util.selector.operation");
        boolean bl = "encryption_mode".equals((String)v);
        boolean bl2 = "decryption_mode".equals((String)v);
        boolean bl3 = "signature_mode".equals((String)v);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + v + "]");
        }
        String string3 = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process type [" + string3 + "]");
        }
        Object[] objectArray = (Object[])map.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Elements [" + objectArray + "]");
        }
        Set set = (Set)map.get("com.ibm.ws.webservices.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token generator configs [" + set + "]");
        }
        IDResolver iDResolver = (IDResolver)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ID resolver [" + iDResolver + "]");
        }
        Duration duration = (Duration)map.get("security.wssecurity.integraldialectelementselector.duration");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Duration [" + duration + "]");
        }
        NonceManager nonceManager = (NonceManager)map.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce manager [" + nonceManager + "]");
        }
        boolean bl4 = false;
        if (bl || bl2) {
            boolean bl5 = bl4 = string2 != null && string2.endsWith("node()");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption type is #Content [" + bl4 + "]");
            }
            if (bl4) {
                n = string2.lastIndexOf(47);
                string2 = string2.substring(0, n);
            }
        }
        v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string4 = Constants.NAMESPACES[0][n];
        String string5 = Constants.NAMESPACES[1][n];
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        if (string2.length() == 0) {
            XPathCanonicalizer.NodeListImpl nodeListImpl;
            nodeList = nodeListImpl = new XPathCanonicalizer.NodeListImpl(1);
            nodeListImpl.add(document.getDocumentElement());
        } else {
            try {
                XPathCanonicalizer.NodeListImpl nodeListImpl;
                NodeList nodeList2 = XPathAPI.selectNodeList((Node)node, (String)string2);
                int n2 = nodeList2.getLength();
                nodeList = nodeListImpl = new XPathCanonicalizer.NodeListImpl(n2);
                for (int i = 0; i < n2; ++i) {
                    Node node2 = nodeList2.item(i);
                    if (node2.getNodeType() != 1) continue;
                    nodeListImpl.add(node2);
                }
            }
            catch (TransformerException transformerException) {
                if (!(bl || bl2 || bl3 || "timestamp".equals(string3) || "nonce".equals(string3))) {
                    try {
                        Element element = document.createElementNS(Constants.NS_DSIG, "ds:XPath");
                        Text text = document.createTextNode(string2);
                        element.appendChild(text);
                        XPathTransformer xPathTransformer = new XPathTransformer();
                        xPathTransformer.setParameter(element);
                        SignatureContext signatureContext = new SignatureContext();
                        signatureContext.setIDResolver(iDResolver);
                        Vector vector = XPathUtil.fixTree(node);
                        TransformContext transformContext = new TransformContext(signatureContext, node);
                        xPathTransformer.transform(transformContext);
                        if (vector != null) {
                            XPathUtil.cleanTree(vector);
                        }
                        nodeList = new PartList(transformContext.getNodeset());
                    }
                    catch (TransformException transformException) {
                        Tr.processException(transformException, clsName + ".getElements", "226");
                        throw SoapSecurityException.format("security.wssecurity.XPathElementSelector.s01", string2, (Throwable)transformException);
                    }
                }
                Tr.processException(transformerException, clsName + ".getElements", "232");
                throw SoapSecurityException.format("security.wssecurity.XPathElementSelector.s01", string2, (Throwable)transformerException);
            }
        }
        if (string3 != null) {
            if (bl || bl3) {
                nodeList = IntegralDialectElementSelector.postprocess(document, string3, nodeList, objectArray, duration, string4, string5, nonceManager, bl3, bl, string, string2);
            }
            if (bl && nodeList != null && nodeList.getLength() > 0) {
                throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", string2);
            }
        }
        if (bl || bl2) {
            nodeList = bl4 ? new com.ibm.ws.webservices.wssecurity.enc.PartList("http://www.w3.org/2001/04/xmlenc#Content", nodeList) : new com.ibm.ws.webservices.wssecurity.enc.PartList("http://www.w3.org/2001/04/xmlenc#Element", nodeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(Node node,Map context) returns NodeList[" + nodeList + "]");
        }
        return nodeList;
    }
}

