/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.wim.ConfigService;
import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.InitializationException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.security.authz.Entitlement;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.websphere.wim.util.SDOUtils;
import com.ibm.ws.security.util.WSEncoderDecoder;
import com.ibm.ws.wim.ProfileManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.configmodel.AttributeGroupType;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.InlineExit;
import com.ibm.ws.wim.configmodel.ModificationSubscriber;
import com.ibm.ws.wim.configmodel.ModificationSubscriberList;
import com.ibm.ws.wim.configmodel.NotificationSubscriber;
import com.ibm.ws.wim.configmodel.NotificationSubscriberList;
import com.ibm.ws.wim.configmodel.PluginManagerConfigurationType;
import com.ibm.ws.wim.configmodel.PostExit;
import com.ibm.ws.wim.configmodel.PreExit;
import com.ibm.ws.wim.configmodel.ProfileRepositoryType;
import com.ibm.ws.wim.configmodel.StaticModelType;
import com.ibm.ws.wim.configmodel.SupportedEntityTypesType;
import com.ibm.ws.wim.configmodel.TopicEmitter;
import com.ibm.ws.wim.configmodel.TopicSubscriber;
import com.ibm.ws.wim.management.DynamicReloadManager;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.ws.wim.util.WasVariableResolver;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Type;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

public class ConfigManager
implements ConfigService,
DynamicConfigService {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    private static final String CLASSNAME = ConfigManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static ConfigManager singleton = null;
    private EPackage configSchema = null;
    private DataGraph configDG = null;
    private String wimHomePath = null;
    private String wimConfigXMLFilePath = null;
    private Map uriToSchema = new HashMap(1);
    private Map classNameToURI = new HashMap();
    private String entityTypeXPath = null;
    private List entityTypes = null;
    private String reposXPath = null;
    private List reposIds = null;
    private String propXPath = null;

    private ConfigManager() throws WIMException {
        this.initialize();
    }

    public static synchronized ConfigManager singleton() throws WIMException {
        if (singleton == null) {
            singleton = new ConfigManager();
        }
        return singleton;
    }

    private EPackage loadConfigSchemaFromPackage(String string) throws WIMException {
        try {
            Class<?> clazz = Class.forName(string);
            EPackage ePackage = (EPackage)clazz.getField("eINSTANCE").get(clazz);
            String string2 = ePackage.getNsURI();
            EPackage.Registry.INSTANCE.put((Object)string2, (Object)ePackage);
            this.uriToSchema.put(string2, ePackage);
            this.readPackage(ePackage);
            return ePackage;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InitializationException("CLASS_OR_INTERFACE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new InitializationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InitializationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)illegalAccessException);
        }
    }

    public DataGraph loadConfigFromXML(String string) throws WIMException {
        EDataGraph eDataGraph = null;
        long l = System.currentTimeMillis();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            HashMap hashMap = new HashMap();
            eDataGraph = SDOUtil.loadDataGraph((InputStream)fileInputStream, hashMap);
            if (trcLogger.isLoggable(Level.FINE)) {
                long l2 = System.currentTimeMillis();
                trcLogger.logp(Level.FINE, CLASSNAME, "loadConfigFromXML", "Loaded from " + string + " (" + (l2 - l) + " milliseconds)");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InitializationException("WIM_CONFIG_XML_FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "loadConfigFromXML", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new InitializationException("INVALID_WIM_CONFIG_XML_FILE", WIMMessageHelper.generateMsgParms(string, iOException.getMessage()), CLASSNAME, "loadConfigFromXML", (Throwable)iOException);
        }
        return eDataGraph;
    }

    private void trimStringList(List list) {
        try {
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, ((String)list.get(i)).trim());
                }
            }
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "trimStringList", exception.getMessage(), exception);
        }
    }

    private void trimModificationSubscriberList(ModificationSubscriberList modificationSubscriberList) {
        if (modificationSubscriberList != null) {
            List list = modificationSubscriberList.getModificationSubscriber();
            for (int i = 0; i < list.size(); ++i) {
                ModificationSubscriber modificationSubscriber = (ModificationSubscriber)list.get(i);
                if (modificationSubscriber.getModificationSubscriberReference() != null) {
                    modificationSubscriber.setModificationSubscriberReference(modificationSubscriber.getModificationSubscriberReference().trim());
                }
                this.trimStringList(modificationSubscriber.getRealmList());
            }
        }
    }

    private void trimNotificationSubscriberList(NotificationSubscriberList notificationSubscriberList) {
        if (notificationSubscriberList != null) {
            List list = notificationSubscriberList.getNotificationSubscriber();
            for (int i = 0; i < list.size(); ++i) {
                NotificationSubscriber notificationSubscriber = (NotificationSubscriber)list.get(i);
                if (notificationSubscriber.getNotificationSubscriberReference() == null) continue;
                notificationSubscriber.setNotificationSubscriberReference(notificationSubscriber.getNotificationSubscriberReference().trim());
                this.trimStringList(notificationSubscriber.getRealmList());
            }
        }
    }

    private void trimConfigStringData() {
        try {
            int n;
            Object object;
            Object object2;
            ConfigurationProviderType configurationProviderType = (ConfigurationProviderType)this.configDG.getRootObject().get("configurationProvider");
            StaticModelType staticModelType = configurationProviderType.getStaticModel();
            if (staticModelType != null) {
                this.trimStringList(staticModelType.getPackageName());
            }
            List list = configurationProviderType.getSupportedEntityTypes();
            for (int i = 0; i < list.size(); ++i) {
                SupportedEntityTypesType supportedEntityTypesType = (SupportedEntityTypesType)list.get(i);
                this.trimStringList(supportedEntityTypesType.getRdnProperties());
            }
            List list2 = configurationProviderType.getRepositories();
            for (int i = 0; i < list2.size(); ++i) {
                if (!(list2.get(i) instanceof ProfileRepositoryType)) continue;
                object2 = (ProfileRepositoryType)list2.get(i);
                this.trimStringList(object2.getLoginProperties());
                this.trimStringList(object2.getRepositoriesForGroups());
            }
            PluginManagerConfigurationType pluginManagerConfigurationType = configurationProviderType.getPluginManagerConfiguration();
            if (pluginManagerConfigurationType != null) {
                object2 = pluginManagerConfigurationType.getTopicSubscriberList();
                if (object2 != null) {
                    object = object2.getTopicSubscriber();
                    for (n = 0; n < object.size(); ++n) {
                        TopicSubscriber topicSubscriber = (TopicSubscriber)object.get(n);
                        if (topicSubscriber.getClassName() == null) continue;
                        topicSubscriber.setClassName(topicSubscriber.getClassName().trim());
                    }
                }
                if ((object = pluginManagerConfigurationType.getTopicRegistrationList()) != null) {
                    List list3 = object.getTopicEmitter();
                    for (int i = 0; i < list3.size(); ++i) {
                        TopicEmitter topicEmitter = (TopicEmitter)list3.get(i);
                        PreExit preExit = topicEmitter.getPreExit();
                        this.trimModificationSubscriberList(preExit.getModificationSubscriberList());
                        this.trimNotificationSubscriberList(preExit.getNotificationSubscriberList());
                        List list4 = topicEmitter.getInlineExit();
                        for (int j = 0; j < list4.size(); ++j) {
                            InlineExit inlineExit = (InlineExit)list4.get(j);
                            this.trimModificationSubscriberList(inlineExit.getModificationSubscriberList());
                        }
                        PostExit postExit = topicEmitter.getPostExit();
                        this.trimModificationSubscriberList(postExit.getModificationSubscriberList());
                        this.trimNotificationSubscriberList(postExit.getNotificationSubscriberList());
                    }
                }
            }
            if ((object2 = configurationProviderType.getAuthorization()) != null) {
                object = object2.getAttributeGroups();
                for (n = 0; n < object.size(); ++n) {
                    AttributeGroupType attributeGroupType = (AttributeGroupType)object.get(n);
                    this.trimStringList(attributeGroupType.getAttributeNames());
                    if (attributeGroupType.getGroupName() == null) continue;
                    attributeGroupType.setGroupName(attributeGroupType.getGroupName().trim());
                }
            }
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "trimConfigStringData", exception.getMessage(), exception);
        }
    }

    public synchronized void initialize() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        String string = File.separator;
        try {
            this.wimHomePath = System.getProperty("wim.home");
            if (this.wimHomePath == null) {
                this.wimHomePath = this.buildHomeDirectory();
            } else if (!this.wimHomePath.endsWith(string)) {
                this.wimHomePath = this.wimHomePath + string;
            }
            if (trcLogger.isLoggable(Level.CONFIG)) {
                trcLogger.logp(Level.CONFIG, CLASSNAME, "initialize", "WIM Home Path is " + this.wimHomePath);
            }
            this.configSchema = this.loadConfigSchemaFromPackage("com.ibm.ws.wim.configmodel.ConfigmodelPackage");
            String string2 = this.configSchema.getNsURI();
            EPackage.Registry.INSTANCE.put((Object)string2, (Object)this.configSchema);
            this.wimConfigXMLFilePath = this.wimHomePath + "config" + string + "wimconfig.xml";
            this.configDG = this.loadConfigFromXML(this.wimConfigXMLFilePath);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize", WIMTraceHelper.printDataGraph(this.configDG));
            }
            this.trimConfigStringData();
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize", "Config data after trimming:");
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize", WIMTraceHelper.printDataGraph(this.configDG));
            }
            this.entityTypeXPath = "configurationProvider/supportedEntityTypes[name=\"{0}\"]";
            this.reposXPath = "configurationProvider/repositories[id=\"{0}\"]";
            this.propXPath = "attributes[propertyName=\"{0}\"]";
            this.refreshConfigCache();
        }
        catch (Exception exception) {
            throw new WIMApplicationException("COMPONENT_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms("ConfigManager", exception.toString()), CLASSNAME, "initialize", (Throwable)exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    public EPackage getConfigSchema() {
        return this.configSchema;
    }

    public byte[] getConfigEPackage() throws WIMException {
        String string = "getConfigEPackage";
        try {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            Resource resource = resourceSetImpl.createResource(URI.createURI((String)".ecore"));
            resource.getContents().add((Object)EcoreUtil.copy((EObject)this.configSchema));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2064);
            resource.save((OutputStream)byteArrayOutputStream, Collections.EMPTY_MAP);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new WIMApplicationException(iOException.toString());
        }
    }

    public DataObject getConfig() throws WIMException {
        ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
        profileSecurityManager.checkPermission_SuperUser(new Entitlement("GET", "CONFIGURATION"));
        DataGraph dataGraph = SDOHelper.createDataGraph("http://www.ibm.com/websphere/wim/config");
        DataObject dataObject = DataGraphHelper.cloneDataObject(this.configDG.getRootObject().getDataObject("configurationProvider"));
        dataGraph.getRootObject().setDataObject("configurationProvider", dataObject);
        return dataObject;
    }

    private void encodeDBAdminPassword(WSEncoderDecoder wSEncoderDecoder, DataObject dataObject) {
        String string;
        if (dataObject != null && (string = dataObject.getString("dbAdminPassword")) != null) {
            dataObject.setString("dbAdminPassword", this.encode(wSEncoderDecoder, string));
        }
    }

    private void encodeLDAPAdapterPassword(WSEncoderDecoder wSEncoderDecoder, DataObject dataObject) {
        DataObject dataObject2;
        if (dataObject != null && (dataObject2 = dataObject.getDataObject("ldapServerConfiguration")) != null) {
            List list = dataObject2.getList("ldapServers");
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                String string = dataObject3.getString("bindPassword");
                if (string == null) continue;
                dataObject3.setString("bindPassword", this.encode(wSEncoderDecoder, string));
            }
            String string = dataObject2.getString("sslKeyStorePassword");
            if (string != null) {
                dataObject2.setString("sslKeyStorePassword", this.encode(wSEncoderDecoder, string));
            }
            if ((string = dataObject2.getString("sslTrustStorePassword")) != null) {
                dataObject2.setString("sslTrustStorePassword", this.encode(wSEncoderDecoder, string));
            }
        }
    }

    public void encodePasswords(DataObject dataObject) {
        WSEncoderDecoder wSEncoderDecoder = new WSEncoderDecoder();
        this.encodeDBAdminPassword(wSEncoderDecoder, dataObject.getDataObject("entryMappingRepository"));
        this.encodeDBAdminPassword(wSEncoderDecoder, dataObject.getDataObject("propertyExtensionRepository"));
        List list = dataObject.getList("repositories");
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject2 = (DataObject)list.get(i);
            String string = dataObject2.getType().getName();
            if ("DatabaseRepositoryType".equals(string)) {
                this.encodeDBAdminPassword(wSEncoderDecoder, dataObject2);
                continue;
            }
            if (!"LdapRepositoryType".equals(string)) continue;
            this.encodeLDAPAdapterPassword(wSEncoderDecoder, dataObject2);
        }
    }

    private String encode(WSEncoderDecoder wSEncoderDecoder, String string) {
        if (string != null && !string.equals("")) {
            return wSEncoderDecoder.encode(string);
        }
        return string;
    }

    public void updateConfig(DataObject dataObject) throws WIMException, RemoteException {
        ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
        profileSecurityManager.checkPermission_SuperUser(new Entitlement("UPDATE", "CONFIGURATION"));
        if (!DynamicReloadManager.isRunningOnDeploymentManager() && !DynamicReloadManager.isRunningOnSingleServer()) {
            throw new DynamicUpdateConfigException("DYNAMIC_RELOAD_INVALID_UPDATE_AT_MANAGED_NODE", CLASSNAME, "updateConfig");
        }
        SDOUtils.validateDataObject(dataObject);
        this.encodePasswords(dataObject);
        this.configDG = dataObject.getDataGraph();
        DataGraphHelper.saveDataGraph(this.configDG, this.wimConfigXMLFilePath);
        this.refreshConfigCache();
    }

    public String getWIMHomePath() {
        return this.wimHomePath;
    }

    public String getWIMConfigXMLFilePath() {
        return this.wimConfigXMLFilePath;
    }

    public void createSchema(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createSchema");
        }
        if (!(DynamicReloadManager.isConnectionTypeNone() || DynamicReloadManager.isRunningOnDeploymentManager() || DynamicReloadManager.isRunningOnSingleServer())) {
            throw new DynamicUpdateConfigException("DYNAMIC_RELOAD_INVALID_UPDATE_AT_MANAGED_NODE", CLASSNAME, "createSchema");
        }
        DataObject dataObject2 = dataObject.getDataObject("schema");
        if (dataObject2 == null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "createSchema", "dymaSchema=null");
            }
            return;
        }
        DataObject dataObject3 = this.configDG.getRootObject().getDataObject("configurationProvider");
        List list = dataObject2.getList("entitySchema");
        List list2 = dataObject2.getList("propertySchema");
        List list3 = dataObject2.getList("extensionPropertySchema");
        if (list.size() > 0) {
            DataObject dataObject4 = (DataObject)list.get(0);
            String string = dataObject4.getString("entityName");
            String string2 = dataObject4.getString("nsURI");
            String string3 = SchemaManager.singleton().getQualifiedTypeName(string2, string);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "createSchema", "qualified entity type:" + string3);
            }
            DataObject dataObject5 = dataObject4.getDataObject("entityConfiguration");
            String string4 = dataObject5.getString("defaultParent");
            String string5 = dataObject5.getString("rdnProperty");
            DataObject dataObject6 = dataObject3.getDataObject("supportedEntityTypes[name='" + string3 + "']");
            if (dataObject6 == null) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "createSchema", "new supported entity type");
                }
                dataObject6 = dataObject3.createDataObject("supportedEntityTypes");
                dataObject6.setString("name", string3);
            } else if (string5 != null) {
                List list4 = dataObject6.getList("rdnProperties");
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "createSchema", "clear current RDN properties:" + list4);
                }
                list4.clear();
            }
            if (string4 != null) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "createSchema", "set default parent:" + string4);
                }
                dataObject6.setString("defaultParent", string4);
            }
            if (string5 != null) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "createSchema", "set RDN property:" + string5);
                }
                dataObject6.getList("rdnProperties").add(string5);
            }
            this.createEntityConfiguration(dataObject4, string3, dataObject3);
        } else if (list2.size() > 0) {
            DataObject dataObject7 = (DataObject)list2.get(0);
            String string = dataObject7.getString("propertyName");
            String string6 = SchemaManager.singleton().getQualifiedTypeName(dataObject7.getString("nsURI"), string);
            this.createPropertyConfiguration(dataObject7.getList("repositoryIds"), string6, dataObject7.getList("metaData"), dataObject3);
        } else if (list3.size() > 0) {
            DataObject dataObject8 = (DataObject)list3.get(0);
            String string = dataObject8.getString("propertyName");
            String string7 = SchemaManager.singleton().getQualifiedTypeName(dataObject8.getString("nsURI"), string);
            this.createPropertyExtensionConfiguration(dataObject8.getList("repositoryIds"), string7, dataObject3);
        }
        DataGraphHelper.saveDataGraph(this.configDG, this.wimConfigXMLFilePath);
        this.refreshConfigCache();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createSchema");
        }
    }

    private void createPropertyConfiguration(List list, String string, List list2, DataObject dataObject) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createPropertyConfiguration", "qPropName=" + string);
        }
        List list3 = dataObject.getList("repositories");
        for (int i = 0; i < list3.size(); ++i) {
            DataObject dataObject2 = (DataObject)list3.get(i);
            if (list.size() > 0 && !list.contains(dataObject2.getString("id")) || !"LdapRepositoryType".equals(dataObject2.getType().getName())) continue;
            DataObject dataObject3 = dataObject2.getDataObject("attributeConfiguration");
            for (int j = 0; j < list2.size(); ++j) {
                DataObject dataObject4 = (DataObject)list2.get(j);
                String string2 = dataObject4.getString("name");
                List list4 = dataObject4.getList("values");
                String string3 = dataObject4.getString("repositoryId");
                if (string3 != null && !string3.equals(dataObject2.getString("id")) || !"repositoryPropertyName".equals(string2)) continue;
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "createPropertyConfiguration", "creating prop for repository " + string3);
                }
                if (dataObject3 == null) {
                    dataObject3 = dataObject2.createDataObject("attributeConfiguration");
                }
                DataObject dataObject5 = dataObject3.createDataObject("attributes");
                List list5 = dataObject3.getList("attributes");
                for (int k = 0; k < list5.size(); ++k) {
                    DataObject dataObject6 = (DataObject)list5.get(k);
                    if (!string.equals(dataObject6.getString("propertyName"))) continue;
                    dataObject6.delete();
                }
                dataObject5.setString("propertyName", string);
                dataObject5.setString("name", (String)list4.get(0));
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createPropertyConfiguration");
        }
    }

    private void createPropertyExtensionConfiguration(List list, String string, DataObject dataObject) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createPropertyExtensionConfiguration", "qPropName=" + string);
        }
        List list2 = dataObject.getList("repositories");
        for (int i = 0; i < list2.size(); ++i) {
            DataObject dataObject2;
            DataObject dataObject3 = (DataObject)list2.get(i);
            if (list.size() > 0 && !list.contains(dataObject3.getString("id")) || !"LdapRepositoryType".equals(dataObject3.getType().getName())) continue;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "createPropertyExtensionConfiguration", "creating prop for repository " + dataObject3.getString("id"));
            }
            if ((dataObject2 = dataObject3.getDataObject("attributeConfiguration")) == null) {
                dataObject2 = dataObject3.createDataObject("attributeConfiguration");
            }
            DataObject dataObject4 = dataObject2.createDataObject("propertiesNotSupported");
            List list3 = dataObject2.getList("propertiesNotSupported");
            for (int j = 0; j < list3.size(); ++j) {
                DataObject dataObject5 = (DataObject)list3.get(j);
                if (!string.equals(dataObject5.getString("name"))) continue;
                dataObject5.delete();
            }
            dataObject4.setString("name", string);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createPropertyExtensionConfiguration");
        }
    }

    private void createEntityConfiguration(DataObject dataObject, String string, DataObject dataObject2) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createEntityConfiguration", "entityName=" + string);
        }
        List list = dataObject2.getList("repositories");
        List list2 = dataObject.getList("repositoryIds");
        DataObject dataObject3 = dataObject.getDataObject("entityConfiguration");
        for (int i = 0; i < list.size(); ++i) {
            List<DataObject> list3;
            Object object;
            Object object2;
            String string2;
            Object object3;
            Object object4;
            DataObject dataObject4 = (DataObject)list.get(i);
            String string3 = dataObject4.getString("id");
            if (list2.size() > 0 && !list2.contains(string3)) continue;
            List list4 = dataObject3.getList("actionNotAllow");
            for (int j = 0; j < list4.size(); ++j) {
                object4 = (DataObject)list4.get(j);
                object3 = object4.getString("actionName");
                if ("CREATE".equalsIgnoreCase((String)object3)) {
                    if (dataObject4.getList("EntityTypesNotAllowCreate").contains(string)) continue;
                    dataObject4.getList("EntityTypesNotAllowCreate").add(string);
                    continue;
                }
                if ("UPDATE".equalsIgnoreCase((String)object3)) {
                    if (dataObject4.getList("EntityTypesNotAllowUpdate").contains(string)) continue;
                    dataObject4.getList("EntityTypesNotAllowUpdate").add(string);
                    continue;
                }
                if ("READ".equalsIgnoreCase((String)object3)) {
                    if (dataObject4.getList("EntityTypesNotAllowRead").contains(string)) continue;
                    dataObject4.getList("EntityTypesNotAllowRead").add(string);
                    continue;
                }
                if (!"DELETE".equalsIgnoreCase((String)object3) || dataObject4.getList("EntityTypesNotAllowDelete").contains(string)) continue;
                dataObject4.getList("EntityTypesNotAllowDelete").add(string);
            }
            if (!"LdapRepositoryType".equals(dataObject4.getType().getName())) continue;
            DataObject dataObject5 = dataObject4.getDataObject("ldapEntityTypes[name='" + string + "']");
            if (dataObject5 == null) {
                dataObject5 = dataObject4.createDataObject("ldapEntityTypes");
                dataObject5.setString("name", string);
            }
            object4 = dataObject3.getList("metaData");
            for (int j = 0; j < object4.size(); ++j) {
                DataObject dataObject6 = (DataObject)object4.get(j);
                string2 = dataObject6.getString("name");
                object2 = dataObject6.getList("values");
                object = dataObject6.getString("repositoryId");
                if (object != null && !((String)object).equals(dataObject4.getString("id"))) continue;
                if ("rdnAttributes".equalsIgnoreCase(string2)) {
                    list3 = dataObject5.getList("rdnAttributes");
                    list3.clear();
                    DataObject dataObject7 = dataObject5.createDataObject("rdnAttributes");
                    dataObject7.setString("name", (String)object2.get(0));
                    list3.add(dataObject7);
                    continue;
                }
                if ("objectClasses".equalsIgnoreCase(string2)) {
                    list3 = dataObject5.getList("objectClasses");
                    list3.clear();
                    list3.addAll((Collection<DataObject>)object2);
                    continue;
                }
                if (!"objectClassesForCreate".equalsIgnoreCase(string2)) continue;
                list3 = dataObject5.getList("objectClassesForCreate");
                list3.clear();
                list3.addAll((Collection<DataObject>)object2);
            }
            object3 = dataObject.getList("properties");
            for (int j = 0; j < object3.size(); ++j) {
                string2 = (DataObject)object3.get(j);
                object2 = string2.getString("name");
                object = string2.getList("metaData");
                list3 = new ArrayList<String>(1);
                list3.add((DataObject)string3);
                this.createPropertyConfiguration(list3, (String)object2, (List)object, dataObject2);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createEntityConfiguration");
        }
    }

    public DataObject getRepositoryDataObject(String string) {
        return this.configDG.getRootObject().getDataObject(this.getRepositoryXPath(string));
    }

    public String getDefaultParent(String string) {
        DataObject dataObject = this.getSupportedEntityTypeDataObject(string);
        if (dataObject != null) {
            return dataObject.getString("defaultParent");
        }
        return null;
    }

    public String getDefaultParent(Type type) throws WIMException {
        return this.getDefaultParent(type.getName(), type.getURI());
    }

    public String getDefaultParent(String string, String string2) throws WIMException {
        String string3 = SchemaManager.singleton().getQualifiedTypeName(string, string2);
        DataObject dataObject = this.getSupportedEntityTypeDataObject(string3);
        if (dataObject != null) {
            return dataObject.getString("defaultParent");
        }
        return null;
    }

    private String getEntityTypeXPath(String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = new MessageFormat(this.entityTypeXPath).format(objectArray);
        return string2;
    }

    public DataObject getSupportedEntityTypeDataObject(String string) {
        return this.configDG.getRootObject().getDataObject(this.getEntityTypeXPath(string));
    }

    private String getWIMPropertyXPath(String string) {
        Object[] objectArray = new Object[]{string};
        return new MessageFormat(this.propXPath).format(objectArray);
    }

    private String getRepositoryXPath(String string) {
        Object[] objectArray = new Object[]{string};
        return new MessageFormat(this.reposXPath).format(objectArray);
    }

    public List getRDNProperties(String string) {
        DataObject dataObject = this.getSupportedEntityTypeDataObject(string);
        if (dataObject != null) {
            return dataObject.getList("rdnProperties");
        }
        return null;
    }

    public List getRDNProperties(Type type) throws WIMException {
        return this.getRDNProperties(type.getName(), type.getURI());
    }

    public List getRDNProperties(String string, String string2) throws WIMException {
        String string3 = SchemaManager.singleton().getQualifiedTypeName(string, string2);
        DataObject dataObject = this.getSupportedEntityTypeDataObject(string3);
        if (dataObject != null) {
            return dataObject.getList("rdnProperties");
        }
        return null;
    }

    public List getSupportedEntityTypes() {
        return this.entityTypes;
    }

    public List getRepsoitoryIds() {
        return this.reposIds;
    }

    private void retrieveSupportedEntityTypes() {
        List list = this.configDG.getRootObject().getDataObject("configurationProvider").getList("supportedEntityTypes");
        this.entityTypes = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject = (DataObject)list.get(i);
            this.entityTypes.add(dataObject.getString("name"));
        }
    }

    private void retrieveRepositoryIds() {
        List list = this.configDG.getRootObject().getDataObject("configurationProvider").getList("repositories");
        this.reposIds = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject = (DataObject)list.get(i);
            this.reposIds.add(dataObject.getString("id"));
        }
    }

    private void refreshConfigCache() {
        this.retrieveSupportedEntityTypes();
        this.retrieveRepositoryIds();
    }

    public EClass getConfigEClass(String string) {
        EPackage ePackage;
        String string2 = (String)this.classNameToURI.get(string);
        if (string2 != null && (ePackage = (EPackage)this.uriToSchema.get(string2)) != null) {
            return (EClass)ePackage.getEClassifier(string);
        }
        return null;
    }

    private void readPackage(EPackage ePackage) throws WIMApplicationException {
        String string = ePackage.getNsURI();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "readPackage", "Package Name: " + ePackage.getName() + "\tPackage NSURI:" + string);
        }
        EList eList = ePackage.getEClassifiers();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof EClass)) continue;
            EClass eClass = (EClass)e2;
            String string2 = eClass.getName();
            if (this.classNameToURI.get(string2) != null) {
                throw new WIMApplicationException("The entity type " + string2 + " is aleady defined.");
            }
            this.classNameToURI.put(string2, string);
            if (!trcLogger.isLoggable(Level.FINEST)) continue;
            trcLogger.logp(Level.FINEST, CLASSNAME, "readPackage", "\tClass Name: " + string2);
        }
    }

    public String getCellName() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string = adminService != null ? adminService.getCellName() : System.getProperty("local.cell");
        return string;
    }

    public String getWASConfigDirectory() throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINE);
        String string = null;
        String string2 = this.getCellName();
        String string3 = System.getProperty("user.install.root");
        String string4 = System.getProperty("was.repository.root");
        if (bl) {
            trcLogger.logp(Level.FINE, CLASSNAME, "getWASConfigDirectory", "System vars: cell=" + string2 + ", user.install.root=" + string3 + ", was.repository.root=" + string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            WasVariableResolver wasVariableResolver = new WasVariableResolver();
            String string5 = wasVariableResolver.getVariableValue("WAS_INSTALL_ROOT");
            if (bl) {
                trcLogger.logp(Level.FINE, CLASSNAME, "getWASConfigDirectory", "WAS vars: WAS_INSTALL_ROOT=" + string5);
            }
            if ((string2 = wasVariableResolver.getCellName()) == null || string2.trim().length() == 0) {
                throw new InitializationException("WAS_VARIABLE_NOT_RESOLVED", WIMMessageHelper.generateMsgParms("local.cell"), Level.SEVERE, CLASSNAME, "getWASConfigDirectory");
            }
        }
        if (string4 != null) {
            string = string4 + File.separator + "cells" + File.separator + string2;
        } else if (string3 != null) {
            string = string3 + File.separator + "config" + File.separator + "cells" + File.separator + string2;
        } else {
            throw new InitializationException("WAS_VARIABLE_NOT_RESOLVED", WIMMessageHelper.generateMsgParms("user.install.root"), Level.SEVERE, CLASSNAME, "getWASConfigDirectory");
        }
        if (bl) {
            trcLogger.logp(Level.FINER, CLASSNAME, "getWASConfigDirectory", "WAS Config Directory=" + string);
        }
        return string;
    }

    private String buildHomeDirectory() throws Exception {
        return this.getWASConfigDirectory() + File.separator + "wim" + File.separator;
    }

    private void addEntityConfig(Map map, DataObject dataObject) throws WIMException {
        String string;
        String string2 = (String)map.get("DYNA_CONFIG_KEY_ENTITY_TYPE");
        if (string2 == null) {
            throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_MISSING_VALUE", WIMMessageHelper.generateMsgParms("DYNA_CONFIG_KEY_ENTITY_TYPE"), CLASSNAME, "addEntityConfig");
        }
        if (SchemaManager.singleton().getEClass(string2) == null) {
            throw new DynamicUpdateConfigException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "addEntityConfig");
        }
        List list = (List)map.get("DYNA_CONFIG_KEY_RDNS");
        if (list == null || list.size() == 0) {
            throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_MISSING_VALUE", WIMMessageHelper.generateMsgParms("DYNA_CONFIG_KEY_RDNS"), CLASSNAME, "addEntityConfig");
        }
        for (int i = 0; i < list.size(); ++i) {
            string = (String)list.get(i);
            if (SchemaManager.singleton().getProperty(string2, string) != null) continue;
            throw new DynamicUpdateConfigException("INVALID_RDN_ATTR", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "addEntityConfig");
        }
        String string3 = (String)map.get("DYNA_CONFIG_KEY_DEFAULT_PARENT");
        if (string3 == null) {
            throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_MISSING_VALUE", WIMMessageHelper.generateMsgParms("DYNA_CONFIG_KEY_DEFAULT_PARENT"), CLASSNAME, "addEntityConfig");
        }
        string = dataObject.getDataObject("supportedEntityTypes[name='" + string2 + "']");
        if (string != null) {
            if (!string.getString("defaultParent").equalsIgnoreCase(string3) || !((Object)string.getList("rdnProperties")).equals(list)) {
                throw new DynamicUpdateConfigException("ENTITY_ALREADY_EXIST", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "addEntityConfig");
            }
        } else {
            DataObject dataObject2 = dataObject.createDataObject("supportedEntityTypes");
            dataObject2.setString("name", string2);
            dataObject2.setString("defaultParent", string3);
            dataObject2.getList("rdnProperties").addAll(list);
            ProfileManager.singleton().initializePropertyCache();
        }
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "dynamicUpdateConfig", WIMMessageHelper.generateMsgParms(string, hashtable));
        }
        DataObject dataObject = this.configDG.getRootObject().getDataObject("configurationProvider");
        if ("websphere.usermanager.serviceprovider.add.repository".equals(string)) {
            DataObject dataObject2;
            if (dataObject != null && hashtable != null && (dataObject2 = (DataObject)hashtable.get("DYNA_CONFIG_KEY_REPOS_CONFIG")) != null) {
                this.checkDataObjectType(string, dataObject2);
                List list = dataObject.getList("repositories");
                list.add(dataObject2);
            }
        } else if ("websphere.usermanager.serviceprovider.add.propertyextensionrepository".equals(string)) {
            if (dataObject != null && hashtable != null) {
                DataObject dataObject3 = (DataObject)hashtable.get("DYNA_CONFIG_KEY_PROP_EXT_REPOS_CONFIG");
                this.checkDataObjectType(string, dataObject3);
                if (dataObject3 != null) {
                    dataObject.setDataObject("propertyExtensionRepository", dataObject3);
                }
            }
        } else if ("websphere.usermanager.serviceprovider.add.realm".equals(string)) {
            if (dataObject != null && hashtable != null) {
                DataObject dataObject4 = (DataObject)hashtable.get("DYNA_CONFIG_KEY_REALM_CONFIG");
                this.checkDataObjectType(string, dataObject4);
                DataObject dataObject5 = dataObject.getDataObject("realmConfiguration");
                if (dataObject5 == null) {
                    throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_ADD_REALM_WITHOUT_REALM_CONFIG", CLASSNAME, "dynamicUpdateConfig");
                }
                if (dataObject4 != null) {
                    List list = dataObject5.getList("realms");
                    list.add(dataObject4);
                }
            }
        } else if ("websphere.usermanager.serviceprovider.add.baseentry".equals(string)) {
            if (dataObject != null && hashtable != null) {
                String string2 = (String)hashtable.get("DYNA_CONFIG_KEY_BASE_ENTRY");
                String string3 = (String)hashtable.get("DYNA_CONFIG_KEY_BASE_ENTRY_IN_REPOS");
                String string4 = (String)hashtable.get("DYNA_CONFIG_KEY_REPOS_ID");
                DataObject dataObject6 = this.getRepositoryDataObject(string4);
                DataObject dataObject7 = SDOHelper.createConfigDataObject(dataObject6, "http://www.ibm.com/websphere/wim/config", "baseEntries");
                dataObject7.setString("name", string2);
                dataObject7.setString("nameInRepository", string3);
                dataObject6.getList("baseEntries").add(dataObject7);
            }
        } else if ("websphere.usermanager.serviceprovider.add.entityconfig".equals(string)) {
            this.addEntityConfig(hashtable, dataObject);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "dynamicUpdateConfig");
        }
    }

    private void checkDataObjectType(String string, DataObject dataObject) throws WIMException {
        if (dataObject != null) {
            String string2 = dataObject.getType().getName();
            if ("websphere.usermanager.serviceprovider.add.repository".equals(string) && !"LdapRepositoryType".equals(string2) && !"ProfileRepositoryType".equals(string2) || "websphere.usermanager.serviceprovider.add.propertyextensionrepository".equals(string) && !"PropertyExtensionRepositoryType".equals(string2) || "websphere.usermanager.serviceprovider.add.realm".equals(string) && !"RealmType".equals(string2)) {
                throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_WRONG_DATA_OBJECT_TYPE", WIMMessageHelper.generateMsgParms(string2, string), CLASSNAME, "checkDataObjectType");
            }
        }
    }
}

