/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class EnvironmentManager
implements NotificationListener {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = EnvironmentManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final Logger msgLogger = WIMLogger.getMessageLogger(CLASSNAME);
    private static EnvironmentManager singleton = null;
    private boolean isServerStarted = false;
    private boolean isZOSPlatform = false;

    private EnvironmentManager() throws WIMSystemException {
        this.initialize();
    }

    public static synchronized EnvironmentManager singleton() throws WIMSystemException {
        if (singleton == null) {
            singleton = new EnvironmentManager();
        }
        return singleton;
    }

    private void initialize() throws WIMSystemException {
        String string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        if ((string = System.getProperty("os.name")).equalsIgnoreCase("z/OS") || string.equalsIgnoreCase("OS/390")) {
            this.isZOSPlatform = true;
        }
        try {
            AdminService adminService = this.getAdminService();
            if (adminService != null) {
                Serializable serializable;
                Object object;
                ObjectName objectName;
                Set set;
                String string2 = adminService.getProcessType();
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "processType is " + string2);
                }
                if (!(set = adminService.queryNames(objectName = new ObjectName("WebSphere:type=Server,*"), null)).isEmpty() && "STARTED".equals(object = (String)adminService.getAttribute((ObjectName)(serializable = (ObjectName)set.iterator().next()), "state"))) {
                    this.isServerStarted = true;
                }
                serializable = new NotificationFilterSupport();
                ((NotificationFilterSupport)serializable).enableType("j2ee.state.running");
                object = null;
                object = new ObjectName("WebSphere:*,type=Server");
                adminService.addNotificationListenerExtended((ObjectName)object, this, (NotificationFilter)serializable, null);
            } else {
                msgLogger.logp(Level.WARNING, CLASSNAME, "initialize", "ADMIN_SERVICE_REGISTRATION_FAILED");
            }
        }
        catch (Exception exception) {
            msgLogger.logp(Level.WARNING, CLASSNAME, "initialize", "ADMIN_SERVICE_REGISTRATION_FAILED", exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize", "isServerStarted=" + this.isServerStarted);
        }
    }

    private boolean isServerStartedProcess(String string) {
        boolean bl = false;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isServerStartedProcess");
        }
        if (string.equals("ManagedProcess") || string.equals("DeploymentManager") || string.equals("UnManagedProcess")) {
            bl = true;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isServerStartedProcess", "result=" + bl);
        }
        return bl;
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification.getType().equals("j2ee.state.running")) {
            this.isServerStarted = true;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "handleNotification", "server started.");
            }
        }
    }

    private void checkZOSServerStatus() {
        if (this.isZOSPlatform) {
            try {
                this.getAdminService();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isDirectAccessMode() {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isDirectAccessMode");
        }
        boolean bl = false;
        try {
            if (this.isZOSPlatform) {
                this.checkZOSServerStatus();
            }
            if (this.isNodeAgent() || this.isZOSControlRegion() || !this.isServerStarted) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isDirectAccessMode", "isDirectAccessMode=" + bl);
        }
        return bl;
    }

    public boolean isZOSControlRegion() {
        AdminService adminService;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isZOSControlRegion");
        }
        boolean bl = false;
        if (this.isZOSPlatform && (adminService = this.getAdminService()) != null) {
            String string = adminService.getJvmType();
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "isZOSControlRegion", "JVMType is " + string);
            }
            if (string != null && string.equals("Control")) {
                bl = true;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isZOSControlRegion", "isZOSControlRegion=" + bl);
        }
        return bl;
    }

    public boolean isNodeAgent() {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isNodeAgent");
        }
        boolean bl = false;
        AdminService adminService = this.getAdminService();
        String string = adminService.getProcessType();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "isNodeAgent", "processType is " + string);
        }
        if (string != null && string.equals("NodeAgent")) {
            bl = true;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isNodeAgent", "isNodeAgent=" + bl);
        }
        return bl;
    }

    public boolean isZOSPlatform() {
        return this.isZOSPlatform;
    }

    public AdminService getAdminService() {
        return (AdminService)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AdminServiceFactory.getAdminService();
            }
        });
    }
}

