/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim;

import com.ibm.websphere.wim.DynamicConfigConstants;
import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.security.authz.Entitlement;
import com.ibm.websphere.wim.util.Routines;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.ProfileManager;
import com.ibm.ws.wim.RealmManager;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.management.DynamicReloadManager;
import com.ibm.ws.wim.management.EventDataWrapper;
import com.ibm.ws.wim.management.EventHandler;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventManager
implements EventHandler,
DynamicConfigConstants,
DynamicConfigService {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = RepositoryManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static EventManager singleton = null;
    private static ConfigManager configManager = null;
    private static RepositoryManager repositoryManager = null;
    private static RealmManager realmManager = null;
    private static final String[] supportedEvents = new String[]{"websphere.usermanager.serviceprovider.add.baseentry", "websphere.usermanager.serviceprovider.add.defaultparenttorealm", "websphere.usermanager.serviceprovider.add.entityconfig", "websphere.usermanager.serviceprovider.add.participatingbaseentry", "websphere.usermanager.serviceprovider.add.propertyconfig", "websphere.usermanager.serviceprovider.add.propertyextensionrepository", "websphere.usermanager.serviceprovider.add.realm", "websphere.usermanager.serviceprovider.add.repository", "websphere.usermanager.serviceprovider.update.db.adminidpassword", "websphere.usermanager.serviceprovider.update.entrymapping.adminidpassword", "websphere.usermanager.serviceprovider.update.ldap.bindinfo", "websphere.usermanager.serviceprovider.update.propertyextension.adminidpassword"};
    private HashSet listeningEvents = null;

    public static synchronized EventManager singleton() throws WIMException {
        if (singleton == null) {
            singleton = new EventManager();
        }
        return singleton;
    }

    private EventManager() throws WIMException {
        this.initialize();
    }

    private void initialize() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
        this.listeningEvents = new HashSet();
        for (int i = 0; i < supportedEvents.length; ++i) {
            this.listeningEvents.add(supportedEvents[i]);
        }
        configManager = ConfigManager.singleton();
        SchemaManager.singleton();
        repositoryManager = RepositoryManager.singleton();
        realmManager = RealmManager.singleton();
        ProfileManager.singleton();
        if (DynamicReloadManager.isRunningOnManagedProcOrNodeAgent()) {
            this.registryEvents();
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    public boolean isListeningToEvent(String string) {
        return this.listeningEvents != null && string != null && this.listeningEvents.contains(string);
    }

    public String[] getEventProcessList() {
        return Routines.stringArrayCopy(supportedEvents);
    }

    public void processEvent(String string, EventDataWrapper eventDataWrapper) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "processEvent", "eventType=" + string + ", eventDataWrapper=" + eventDataWrapper);
        }
        Hashtable hashtable = (Hashtable)eventDataWrapper.getObject();
        try {
            this.dynamicUpdateConfig(string, hashtable);
        }
        catch (WIMException wIMException) {
            Routines.logException(trcLogger, CLASSNAME, "processEvent", Level.WARNING, wIMException.getMessage(), wIMException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "processEvent");
        }
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "dynamicUpdateConfig", "eventType=" + string + ", configData=" + hashtable);
        }
        ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
        profileSecurityManager.checkPermission_SuperUser(new Entitlement("DYNAMIC_UPDATE", "CONFIGURATION"));
        if ("websphere.usermanager.serviceprovider.update.ldap.bindinfo".equals(string)) {
            configManager.dynamicUpdateConfig(string, hashtable);
            repositoryManager.dynamicUpdateConfig(string, hashtable);
        } else if ("websphere.usermanager.serviceprovider.add.repository".equals(string) || "websphere.usermanager.serviceprovider.add.propertyextensionrepository".equals(string)) {
            configManager.dynamicUpdateConfig(string, hashtable);
            repositoryManager.dynamicUpdateConfig(string, hashtable);
            ProfileManager.singleton().initializePropertyCache();
            if ("websphere.usermanager.serviceprovider.add.propertyextensionrepository".equals(string)) {
                ProfileManager.singleton().invalidLAProperties();
            }
        } else if ("websphere.usermanager.serviceprovider.add.realm".equals(string)) {
            configManager.dynamicUpdateConfig(string, hashtable);
            realmManager.dynamicUpdateConfig(string, hashtable);
        } else if ("websphere.usermanager.serviceprovider.add.participatingbaseentry".equals(string) || "websphere.usermanager.serviceprovider.add.defaultparenttorealm".equals(string)) {
            realmManager.dynamicUpdateConfig(string, hashtable);
        } else if ("websphere.usermanager.serviceprovider.add.baseentry".equals(string)) {
            configManager.dynamicUpdateConfig(string, hashtable);
            repositoryManager.dynamicUpdateConfig(string, hashtable);
        } else if ("websphere.usermanager.serviceprovider.add.entityconfig".equals(string)) {
            configManager.dynamicUpdateConfig(string, hashtable);
            repositoryManager.dynamicUpdateConfig(string, hashtable);
        } else if ("websphere.usermanager.serviceprovider.add.propertyconfig".equals(string)) {
            repositoryManager.dynamicUpdateConfig(string, hashtable);
        } else if ("websphere.usermanager.serviceprovider.update.db.adminidpassword".equals(string) || "websphere.usermanager.serviceprovider.update.entrymapping.adminidpassword".equals(string) || "websphere.usermanager.serviceprovider.update.propertyextension.adminidpassword".equals(string)) {
            repositoryManager.dynamicUpdateConfig(string, hashtable);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "dynamicUpdateConfig");
        }
    }

    private void registryEvents() {
        for (int i = 0; i < supportedEvents.length; ++i) {
            DynamicReloadManager.singleton().registerEventAtNode(supportedEvents[i], this);
        }
    }
}

