/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim;

import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.wim.ProfileService;
import com.ibm.websphere.wim.exception.AttributeNotSupportedException;
import com.ibm.websphere.wim.exception.CertificateMapFailedException;
import com.ibm.websphere.wim.exception.CertificateMapNotSupportedException;
import com.ibm.websphere.wim.exception.DefaultParentNotFoundException;
import com.ibm.websphere.wim.exception.DuplicateLogonIdException;
import com.ibm.websphere.wim.exception.EntityAlreadyExistsException;
import com.ibm.websphere.wim.exception.EntityIdentifierNotSpecifiedException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.EntityNotInRealmScopeException;
import com.ibm.websphere.wim.exception.EntityTypeNotSupportedException;
import com.ibm.websphere.wim.exception.InvalidIdentifierException;
import com.ibm.websphere.wim.exception.InvalidUniqueIdException;
import com.ibm.websphere.wim.exception.MaxResultsExceededException;
import com.ibm.websphere.wim.exception.MissingSearchControlException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.exception.PageControlException;
import com.ibm.websphere.wim.exception.PasswordCheckFailedException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.SortControlException;
import com.ibm.websphere.wim.exception.SubscriberCriticalException;
import com.ibm.websphere.wim.exception.UpdateOperationalPropertyException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.EnvironmentManager;
import com.ibm.ws.wim.PageCacheEntry;
import com.ibm.ws.wim.PropertyManager;
import com.ibm.ws.wim.RealmManager;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.RepositoryPropertyMap;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.federation.FederationEntity;
import com.ibm.ws.wim.pluginmanager.PluginManager;
import com.ibm.ws.wim.security.authz.EntitlementRequest;
import com.ibm.ws.wim.security.authz.EntityResource;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import com.ibm.ws.wim.util.AsyncUtils;
import com.ibm.ws.wim.util.CommonUtil;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.ws.wim.util.SortHandler;
import com.ibm.ws.wim.util.UniqueNameHelper;
import com.ibm.ws.wim.xpath.ParseException;
import com.ibm.ws.wim.xpath.TokenMgrError;
import com.ibm.ws.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.wim.xpath.mapping.datatype.FederationLogicalNode;
import com.ibm.ws.wim.xpath.mapping.datatype.FederationParenthesisNode;
import com.ibm.ws.wim.xpath.mapping.datatype.LogicalNode;
import com.ibm.ws.wim.xpath.mapping.datatype.ParenthesisNode;
import com.ibm.ws.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.ws.wim.xpath.util.ProfileManagerMetadataMapper;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;

public class ProfileManager
implements ProfileService {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    private static final String CLASSNAME = ProfileManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final String eINSTANCE = "eINSTANCE";
    private static ProfileManager singleton = null;
    private static SchemaManager schemaMgr = null;
    private ConfigManager configMgr = null;
    private static RepositoryManager reposMgr = null;
    private RealmManager realmMgr = null;
    private ProfileSecurityManager profileSecManager = null;
    private String pagingSearchCacheName = "WIMSearchCacheName";
    private DistributedObjectCache pagingSearchCache = null;
    private static PropertyManager propMgr = null;
    private int searchTimeOut;
    private int maxSearchResults;
    private int maxTotalPagingSearchResults;
    private boolean pagingEntityObject = false;
    private boolean pagingCachesDiskOffLoad = false;
    private int pagedEntryTimeToLive;
    private static final String LA = "LA";
    private static final String REPOS = "REPOS";
    private Set laSupportedProps = null;
    private int dMapPriority = 1;
    private static final String TOTAL_PAGED_RESULTS = "TotalPagedResults";
    private static final char CREATE = 'c';
    private static final char GET = 'g';
    private static final char DELETE = 'd';
    private static final char UPDATE = 'u';
    private static final char SEARCH = 's';
    private static final char LOGIN = 'l';
    private static final String CREATE_EMITTER = "create";
    private static final String GET_EMITTER = "get";
    private static final String DELETE_EMITTER = "delete";
    private static final String UPDATE_EMITTER = "update";
    private static final String SEARCH_EMITTER = "search";
    private static final String LOGIN_EMITTER = "login";
    private PluginManager pluginManager = null;

    private ProfileManager() throws WIMException {
        this.initialize();
    }

    public static synchronized ProfileManager singleton() throws WIMException {
        if (singleton == null) {
            singleton = new ProfileManager();
        }
        return singleton;
    }

    private DataObject getDataGraphClone(DataObject dataObject) throws WIMException {
        DataObject dataObject2 = DataGraphHelper.cloneRootDataObject(dataObject);
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        if (changeSummary != null) {
            EChangeSummary eChangeSummary = (EChangeSummary)DataGraphHelper.cloneEObject((EObject)((EDataObject)changeSummary));
            ((EDataGraph)dataObject2.getDataGraph()).setEChangeSummary(eChangeSummary);
        }
        return dataObject2;
    }

    private DataObject getDeepDataGraphClone(DataObject dataObject) throws WIMException {
        DataObject dataObject2 = DataGraphHelper.deepCloneRootDataObject(dataObject);
        return dataObject2;
    }

    private DataObject genericProfileManagerMethod(String string, String string2, char c, DataObject dataObject) throws WIMException {
        DataObject dataObject2 = null;
        DataObject dataObject3 = null;
        DataObject dataObject4 = null;
        boolean bl = false;
        try {
            if (dataObject != null && !dataObject.getType().getName().equals("RootType")) {
                throw new WIMApplicationException("INVALID_DATA_OBJECT_TYPE", WIMMessageHelper.generateMsgParms(dataObject.getType().getName(), string, "RootType"), CLASSNAME, string);
            }
            ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
            dataObject3 = changeSummary != null ? this.getDeepDataGraphClone(dataObject) : this.getDataGraphClone(dataObject);
            dataObject3 = this.pluginManager.preExitCall(string2, dataObject3);
            bl = true;
            switch (c) {
                case 'l': {
                    dataObject4 = this.loginImpl(dataObject3);
                    break;
                }
                case 'u': {
                    dataObject4 = this.updateImpl(dataObject3);
                    break;
                }
                case 's': {
                    dataObject4 = this.searchImpl(dataObject3);
                    break;
                }
                case 'd': {
                    dataObject4 = this.deleteImpl(dataObject3);
                    break;
                }
                case 'c': {
                    dataObject4 = this.createImpl(dataObject3);
                    break;
                }
                case 'g': {
                    dataObject4 = this.getImpl(dataObject3);
                }
            }
            dataObject2 = this.pluginManager.postExitCall(string2, dataObject3, dataObject4);
            if (c == 'g' && !dataObject2.getDataGraph().getChangeSummary().isLogging()) {
                dataObject2.getDataGraph().getChangeSummary().beginLogging();
            }
        }
        catch (SubscriberCriticalException subscriberCriticalException) {
            throw new WIMApplicationException("SUBSCRIBER_CRITICAL_EXCEPTION", WIMMessageHelper.generateMsgParms(subscriberCriticalException.getMessage()), Level.SEVERE, CLASSNAME, string, (Throwable)subscriberCriticalException);
        }
        catch (WIMException wIMException) {
            block16: {
                try {
                    if (bl) {
                        dataObject2 = this.pluginManager.postExitCall(string2, dataObject3, dataObject4);
                    }
                }
                catch (Exception exception) {
                    if (!trcLogger.isLoggable(Level.WARNING)) break block16;
                    trcLogger.logp(Level.WARNING, CLASSNAME, "WIM_API " + string, "GENERIC", exception);
                }
            }
            throw wIMException;
        }
        return dataObject2;
    }

    public DataObject create(DataObject dataObject) throws WIMException {
        String string = CLASSNAME + "." + CREATE_EMITTER;
        return this.genericProfileManagerMethod(CREATE_EMITTER, string, 'c', dataObject);
    }

    public DataObject get(DataObject dataObject) throws WIMException {
        String string = CLASSNAME + "." + GET_EMITTER;
        return this.genericProfileManagerMethod(GET_EMITTER, string, 'g', dataObject);
    }

    public DataObject delete(DataObject dataObject) throws WIMException {
        String string = CLASSNAME + "." + DELETE_EMITTER;
        return this.genericProfileManagerMethod(DELETE_EMITTER, string, 'd', dataObject);
    }

    public DataObject update(DataObject dataObject) throws WIMException {
        String string = CLASSNAME + "." + UPDATE_EMITTER;
        return this.genericProfileManagerMethod(UPDATE_EMITTER, string, 'u', dataObject);
    }

    public DataObject search(DataObject dataObject) throws WIMException {
        String string = CLASSNAME + "." + SEARCH_EMITTER;
        return this.genericProfileManagerMethod(SEARCH_EMITTER, string, 's', dataObject);
    }

    public DataObject login(DataObject dataObject) throws WIMException {
        String string = CLASSNAME + "." + LOGIN_EMITTER;
        return this.genericProfileManagerMethod(LOGIN_EMITTER, string, 'l', dataObject);
    }

    public DataObject createImpl(DataObject dataObject) throws WIMException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        String string2;
        DataObject dataObject2;
        Object object5;
        Object object6;
        String string3;
        Object object7;
        List list;
        String string4;
        String string5;
        DataObject dataObject3;
        String string6;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createImpl", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject4 = DataGraphHelper.cloneRootDataObject(dataObject);
        DataObject dataObject5 = null;
        int n = -1;
        DataObject dataObject6 = null;
        List list2 = null;
        if (AsyncUtils.isCheckAsyncOperationStatus(dataObject4)) {
            string6 = AsyncUtils.getRepositoryId(dataObject4);
            n = reposMgr.getRepositoryIndexByRepositoryID(string6);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "createImpl", "Checking the status of async create in repository " + string6);
            }
            dataObject5 = reposMgr.getRepositories()[n].create(dataObject4);
        } else {
            Object object8;
            int n2 = reposMgr.getNumberOfRepositories();
            dataObject3 = null;
            string5 = null;
            string4 = this.getRealmName(dataObject4);
            list = dataObject4.getList("entities");
            if (list == null) {
                return null;
            }
            if (list.size() > 1) {
                throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", WIMMessageHelper.generateMsgParms("CREATE"), CLASSNAME, "createImpl");
            }
            if (list.size() == 0) {
                throw new EntityNotFoundException("MISSING_ENTITY_DATA_OBJECT", WIMMessageHelper.generateMsgParms(CREATE_EMITTER), CLASSNAME, "createImpl");
            }
            if (list.size() > 1) {
                throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", WIMMessageHelper.generateMsgParms("UPDATE"), CLASSNAME, "createImpl");
            }
            object7 = (DataObject)list.get(0);
            string3 = schemaMgr.getQualifiedTypeName(object7.getType());
            this.profileSecManager.checkPermission_CREATE(new EntityResource(dataObject4, (DataObject)object7));
            this.checkCreateAndModifyTimeStamp(string3, (DataObject)object7);
            object6 = ControlsHelper.getControlMap(dataObject4);
            object5 = (DataObject)object6.get("ViewControl");
            if (object5 != null) {
                DataObject dataObject7 = this.pluginManager.inlineExitCall(CLASSNAME + "." + CREATE_EMITTER, dataObject4, "createInViewExplicit");
                return dataObject7;
            }
            dataObject2 = null;
            string2 = null;
            dataObject2 = object7.getDataObject("parent");
            if (dataObject2 != null && (string2 = dataObject2.getDataObject("identifier").getString("uniqueName")) == null && (string = dataObject2.getDataObject("identifier").getString("uniqueId")) != null && ((string2 = this.getUniqueNameByUniqueId(string, false, null)) == null || string2.length() == 0)) {
                throw new InvalidUniqueIdException("INVALID_PARENT_UNIQUE_ID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "createImpl");
            }
            if (string2 == null) {
                string2 = this.realmMgr.getDefaultParentForEntityInRealm(string3, string4);
            } else if (!this.realmMgr.isUniqueNameInRealm(string2, string4)) {
                throw new EntityNotInRealmScopeException("ENTITY_NOT_IN_REALM_SCOPE", WIMMessageHelper.generateMsgParms(string2, string4), CLASSNAME, "createImpl");
            }
            if (string2 == null) {
                throw new DefaultParentNotFoundException("DEFAULT_PARENT_NOT_FOUND", WIMMessageHelper.generateMsgParms(string3, string4), CLASSNAME, "createImpl");
            }
            string2 = UniqueNameHelper.formatUniqueName(string2);
            if (dataObject2 == null) {
                dataObject2 = object7.createDataObject("parent");
                string = dataObject2.createDataObject("identifier");
            }
            dataObject2.getDataObject("identifier").setString("uniqueName", string2);
            object7.setDataObject("parent", dataObject2);
            if (reposMgr.getNumberOfRepositories() > 1) {
                if (n < 0) {
                    n = reposMgr.getRepositoryIndexByUniqueName(string2);
                }
            } else {
                n = 0;
            }
            string = reposMgr.getRepositoryIDByRepositoryIndex(n);
            this.checkAccessibility('c', "CREATE", string, string3);
            if ((string3.equals("Group") || schemaMgr.isSuperType("Group", string3)) && (object4 = object7.getList("members")) != null && object4.size() > 0 && (object4 = this.setExtIdAndRepositoryIdForEntities((List)object4, string, false, null)) != null && object4.size() > 0) {
                for (int i = 0; i < object4.size(); ++i) {
                    object3 = DataGraphHelper.cloneDataObject((DataObject)object4.get(i));
                    object2 = object3.getDataObject("identifier");
                    object8 = this.retrieveTargetRepository((DataObject)object2);
                    boolean bl = reposMgr.canGroupAcceptMember(string, (String)object8);
                    if (bl || string.equalsIgnoreCase((String)object8)) continue;
                    throw new OperationNotSupportedException("MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", WIMMessageHelper.generateMsgParms(object8), Level.SEVERE, CLASSNAME, "createImpl");
                }
            }
            object4 = object7.getList("groups");
            object = null;
            if (object4 != null && object4.size() > 0) {
                object = this.separateGroups((List)object4, string);
                list2 = DataGraphHelper.cloneList((List)object4);
            }
            if (reposMgr.isAsyncModeSupported(n) && list2 != null && list2.size() > 0) {
                throw new OperationNotSupportedException("ASYNC_CALL_WITH_MULTIPLE_REPOSITORIES_NOT_SUPPORTED", CLASSNAME, "createImpl");
            }
            if (object != null) {
                object7.unset("groups");
                object7.getList("groups").addAll(object);
            }
            if ((object3 = this.configMgr.getRDNProperties(string3)) == null) {
                throw new EntityTypeNotSupportedException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string3));
            }
            object2 = UniqueNameHelper.constructUniqueName((List)object3, object7, string2);
            if (object2 != null && reposMgr.isEntryJoin() && (object8 = reposMgr.getFederationRepository().lookupByUniqueName((String)object2)) != null) {
                throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", WIMMessageHelper.generateMsgParms(object2), Level.SEVERE, CLASSNAME, "createImpl");
            }
            ProfileManager.processReferenceProperty(object7, string3, false, false, null);
            if (object2 != null) {
                if (reposMgr.isPropertyJoin()) {
                    dataObject6 = this.divideDataObject(dataObject4, reposMgr.getRepositoryIDByRepositoryIndex(n));
                }
                object7.createDataObject("identifier").setString("uniqueName", (String)object2);
                if (dataObject6 != null && reposMgr.isAsyncModeSupported(n)) {
                    throw new OperationNotSupportedException("ASYNC_CALL_WITH_MULTIPLE_REPOSITORIES_NOT_SUPPORTED", CLASSNAME, "createImpl");
                }
                dataObject5 = reposMgr.getRepositories()[n].create(dataObject4);
            }
        }
        if (AsyncUtils.isOperationComplete(dataObject5)) {
            string6 = reposMgr.getRepositoryIDByRepositoryIndex(n);
            dataObject3 = (DataObject)dataObject5.getList("entities").get(0);
            string5 = schemaMgr.getQualifiedTypeName(dataObject3.getType());
            string4 = dataObject3.getDataObject("identifier");
            list = DataGraphHelper.cloneDataObject((DataObject)string4);
            list.setString("repositoryId", string6);
            object7 = string4.getString("externalId");
            string3 = string4.getString("uniqueName");
            object6 = null;
            object6 = reposMgr.isEntryJoin() ? reposMgr.getFederationRepository().create(string5, string3, string6, (String)object7) : object7;
            string4.setString("uniqueId", (String)object6);
            string4.setString("repositoryId", string6);
            if (reposMgr.isPropertyJoin() && dataObject6 != null) {
                object5 = dataObject6.getList("entities");
                dataObject2 = (DataObject)object5.get(0);
                dataObject2.setDataObject("identifier", (DataObject)list);
                string2 = reposMgr.getLookasideRepository().create(dataObject6);
            }
            if (list2 != null && list2.size() > 0) {
                for (int i = 0; i < list2.size(); ++i) {
                    dataObject2 = (DataObject)list2.get(i);
                    string2 = dataObject2.getDataObject("identifier");
                    string = string2.getString("repositoryId");
                    if (string6.equals(string)) continue;
                    if (reposMgr.isCrossRepositoryGroupMembership(string6)) {
                        object4 = SDOHelper.createRootDataObject();
                        object = SDOHelper.createEntityDataObject((DataObject)object4, null, "Group");
                        object.setDataObject("identifier", (DataObject)string2);
                        object3 = object.createDataObject("members");
                        object3.setDataObject("identifier", (DataObject)list);
                        object2 = SDOHelper.createControlDataObject((DataObject)object4, null, "GroupMemberControl");
                        this.update((DataObject)object4);
                        continue;
                    }
                    throw new OperationNotSupportedException("MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", WIMMessageHelper.generateMsgParms(string6), Level.SEVERE, CLASSNAME, "createImpl");
                }
            }
            this.profileSecManager.setEntitlements(dataObject, dataObject5, new EntitlementRequest(dataObject));
            this.unsetExternalId(dataObject5);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createImpl", WIMTraceHelper.printDataGraph(dataObject5));
        }
        return dataObject5;
    }

    private void checkCreateAndModifyTimeStamp(String string, DataObject dataObject) throws WIMException {
        String string2 = "checkCreateOrModifyTimeStamp";
        boolean bl = false;
        boolean bl2 = false;
        Property property = null;
        EChangeSummary eChangeSummary = (EChangeSummary)dataObject.getDataGraph().getChangeSummary();
        List list = eChangeSummary.getChangedDataObjects();
        if (list.size() > 0) {
            DataObject dataObject2 = (DataObject)list.get(0);
            for (ChangeSummary.Setting setting : eChangeSummary.getOldValues(dataObject2)) {
                Property property2 = setting.getProperty();
                String string3 = property2.getName();
                if (!"createTimestamp".equalsIgnoreCase(string3) && !"modifyTimestamp".equalsIgnoreCase(string3)) continue;
                throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, string2);
            }
        } else {
            property = schemaMgr.getProperty(string, "createTimestamp");
            if (property != null) {
                bl = dataObject.isSet(property);
            }
            if ((property = schemaMgr.getProperty(string, "modifyTimestamp")) != null) {
                bl2 = dataObject.isSet(property);
            }
            String string4 = null;
            if (bl) {
                string4 = "createTimestamp";
            } else if (bl2) {
                string4 = "modifyTimestamp";
            }
            if (string4 != null) {
                throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms(string4), CLASSNAME, string2);
            }
        }
    }

    private DataObject processIdentifierForLA(DataObject dataObject, String string) throws WIMException {
        FederationEntity federationEntity;
        DataObject dataObject2 = dataObject.getDataObject("identifier");
        DataObject dataObject3 = DataGraphHelper.cloneDataObject(dataObject2);
        String string2 = dataObject2.getString("externalId");
        Object var6_6 = null;
        if (reposMgr.isEntryJoin() && (federationEntity = reposMgr.getFederationRepository().get(string, string2)) != null) {
            dataObject3.setString("externalId", federationEntity.getExternalId());
        }
        dataObject3.setString("repositoryId", string);
        return dataObject3;
    }

    public DataObject searchImpl(DataObject dataObject) throws WIMException {
        Boolean bl;
        String string;
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DataObject dataObject2;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = false;
        DataObject dataObject3 = null;
        List list = null;
        DataObject dataObject4 = null;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchImpl", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject5 = DataGraphHelper.cloneRootDataObject(dataObject);
        if (AsyncUtils.isCheckAsyncOperationStatus(dataObject)) {
            String string2 = AsyncUtils.getRepositoryId(dataObject);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "searchImpl", "Checking the status of async search in repository " + string2);
            }
            dataObject3 = reposMgr.getRepository(string2).search(dataObject);
            bl2 = false;
        }
        int n = reposMgr.getNumberOfRepositories();
        List[] listArray = new List[n];
        for (int i = 0; i < n; ++i) {
            listArray[i] = new BasicEList();
        }
        DataObject dataObject6 = null;
        Map map = ControlsHelper.getControlMap(dataObject5);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        HashSet hashSet = new HashSet();
        List list2 = dataObject5.getList("contexts");
        if (list2 != null && list2.size() > 0) {
            for (int i = 0; i < list2.size(); ++i) {
                dataObject2 = (DataObject)list2.get(i);
                object4 = dataObject2.getString("key");
                if (object4 == null || !"allowOperationIfReposDown".equals(object4)) continue;
                bl4 = (Boolean)dataObject2.get("value");
                bl5 = true;
            }
        }
        DataObject dataObject7 = (DataObject)map.get("SearchControl");
        dataObject2 = (DataObject)map.get("PageControl");
        object4 = (DataObject)map.get("SortControl");
        if (dataObject7 == null && dataObject2 == null && bl2) {
            throw new MissingSearchControlException("MISSING_SEARCH_CONTROL", CLASSNAME, "searchImpl");
        }
        if (dataObject7 == null && bl2) {
            byte[] byArray = dataObject2.getBytes("cookie");
            if (byArray == null) {
                throw new PageControlException("MISSING_COOKIE", CLASSNAME, "searchImpl");
            }
            n4 = dataObject2.getInt("size");
            if (this.pagingSearchCache != null) {
                Integer n5 = (Integer)this.pagingSearchCache.get(TOTAL_PAGED_RESULTS);
                String string3 = new String(byArray);
                PageCacheEntry pageCacheEntry = (PageCacheEntry)this.pagingSearchCache.get(string3);
                int n6 = 0;
                DataObject dataObject8 = null;
                DataObject dataObject9 = null;
                DataObject dataObject10 = null;
                List list3 = null;
                if (pageCacheEntry != null && (dataObject8 = pageCacheEntry.getDataObject()) != null) {
                    dataObject10 = DataGraphHelper.cloneRootDataObject(dataObject8);
                    dataObject10.getList("entities").clear();
                    dataObject9 = DataGraphHelper.cloneRootDataObject(dataObject8);
                    dataObject9.getList("entities").clear();
                    if (dataObject8 != null && (list3 = dataObject8.getList("entities")) != null) {
                        n6 = list3.size();
                    }
                }
                if (n4 == 0) {
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "searchImpl", "clean up the paging cache entry");
                    }
                    this.pagingSearchCache.put(TOTAL_PAGED_RESULTS, new Integer(n5 - n6));
                    this.pagingSearchCache.invalidate(string3);
                } else {
                    DataObject dataObject11;
                    dataObject6 = SDOHelper.createRootDataObject();
                    List list4 = null;
                    if (n6 > n4) {
                        list4 = dataObject6.getList("entities");
                        for (int i = 0; i < n4; ++i) {
                            DataObject dataObject12 = DataGraphHelper.cloneDataObject((DataObject)list3.get(i));
                            list4.add(dataObject12);
                        }
                        dataObject11 = list3.subList(n4, n6);
                        dataObject9.getList("entities").addAll(dataObject11);
                        pageCacheEntry.setDataObject(dataObject9);
                        this.pagingSearchCache.put(string3, pageCacheEntry, this.dMapPriority, this.pagedEntryTimeToLive, 2, null);
                        this.pagingSearchCache.put(TOTAL_PAGED_RESULTS, new Integer(n5 - n4));
                    } else {
                        list4 = list3;
                        this.pagingSearchCache.put(TOTAL_PAGED_RESULTS, new Integer(n5 - n6));
                        this.pagingSearchCache.invalidate(string3);
                        byArray = null;
                    }
                    if (this.pagingEntityObject) {
                        dataObject6.getList("entities").addAll(list4);
                    } else {
                        dataObject10.getList("entities").addAll(list4);
                        dataObject6 = this.get(dataObject10);
                    }
                    if (byArray != null) {
                        dataObject11 = dataObject6.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PageResponseControl");
                        dataObject11.setBytes("cookie", byArray);
                    }
                }
            }
            this.unsetExternalId(dataObject6);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "searchImpl", WIMTraceHelper.printDataObject(dataObject6));
            }
            return dataObject6;
        }
        if (bl2 && dataObject7 != null) {
            n2 = dataObject7.getInt("countLimit");
            if (n2 < 0) {
                throw new SearchControlException("INCORRECT_COUNT_LIMIT", WIMMessageHelper.generateMsgParms(new Integer(n2)), CLASSNAME, "searchImpl");
            }
            if (n2 > 0) {
                dataObject7.setInt("countLimit", n2 + 1);
            } else {
                dataObject7.setInt("countLimit", 0);
            }
            n3 = dataObject7.getInt("searchLimit");
            if (n3 < 0) {
                throw new SearchControlException("INCORRECT_SEARCH_LIMIT", WIMMessageHelper.generateMsgParms(new Integer(n3)), CLASSNAME, "searchImpl");
            }
            int n7 = dataObject7.getInt("timeLimit");
            if (n2 > 0 && dataObject2 != null) {
                throw new SearchControlException("CANNOT_SPECIFY_COUNT_LIMIT", CLASSNAME, "searchImpl");
            }
            if (n7 <= 0) {
                dataObject7.setInt("timeLimit", this.searchTimeOut);
            }
            object3 = dataObject7.getList("searchBases");
            String string4 = this.getRealmName(dataObject5);
            if (!bl5) {
                bl4 = this.realmMgr.getAllowOperationIfReposDown(string4);
            }
            boolean bl6 = false;
            if (object3.size() > 0) {
                listArray = this.divideSearchBases((List)object3, string4, listArray);
                bl6 = true;
            } else {
                listArray = this.getSearchBasesFromRealm(string4, listArray);
            }
            bl3 = this.isAsyncSearch(listArray, stringBuffer);
            if (object4 != null && bl3) {
                object2 = dataObject5.createDataObject("controls", "http://www.ibm.com/websphere/wim", "RequestControl");
                object2.setString("requiredInteractionStyle", "sync");
            }
            list = null;
            if (reposMgr.isPropertyJoin()) {
                object2 = dataObject7.getString("expression");
                if (object2 == null || object2.length() == 0) {
                    throw new SearchControlException("MISSING_SEARCH_EXPRESSION", CLASSNAME, "searchImpl");
                }
                List list5 = DataGraphHelper.cloneList(dataObject7.getList("properties"));
                boolean bl7 = dataObject7.getBoolean("returnSubType");
                object = this.configMgr.getSupportedEntityTypes();
                objectArray = new List[n];
                string = new String();
                bl = false;
                for (int i = 0; i < n; ++i) {
                    Object object5;
                    if (listArray != null) {
                        object5 = listArray[i];
                        if (object5 != null && object5.size() > 0) {
                            if (bl6 || !reposMgr.getRepositoryTypeByRepositoryIndex(i).equals("LdapRepositoryType")) {
                                dataObject7.setList("searchBases", (List)object5);
                            } else {
                                dataObject7.getList("searchBases").clear();
                            }
                        } else {
                            if (n != 1) continue;
                            dataObject7.getList("searchBases").clear();
                        }
                    }
                    object5 = new WIMXPathInterpreter(new StringReader((String)object2));
                    List list6 = null;
                    XPathNode xPathNode = null;
                    List list7 = null;
                    String string5 = reposMgr.getRepositoryIDByRepositoryIndex(i);
                    ProfileManagerMetadataMapper profileManagerMetadataMapper = new ProfileManagerMetadataMapper(string5, (List)object);
                    try {
                        xPathNode = ((WIMXPathInterpreter)object5).parse(profileManagerMetadataMapper);
                        list7 = ((WIMXPathInterpreter)object5).getEntityTypes();
                        bl = true;
                    }
                    catch (AttributeNotSupportedException attributeNotSupportedException) {
                        string = attributeNotSupportedException.getMessage();
                        continue;
                    }
                    catch (ParseException parseException) {
                        throw new SearchControlException("SEARCH_EXPRESSION_ERROR", WIMMessageHelper.generateMsgParms(parseException.getMessage()), CLASSNAME, "searchImpl");
                    }
                    catch (TokenMgrError tokenMgrError) {
                        throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(object2), CLASSNAME, "searchImpl", (Throwable)tokenMgrError);
                    }
                    HashMap hashMap = this.validateAndDivideReturnProperties(list7, list5, string5, bl7);
                    short s = xPathNode.getNodeType();
                    switch (s) {
                        case 4: 
                        case 8: {
                            if (bl3) {
                                throw new OperationNotSupportedException("ASYNC_CALL_WITH_MULTIPLE_REPOSITORIES_NOT_SUPPORTED", CLASSNAME, "searchImpl");
                            }
                            list6 = this.splitSearch(i, list7, xPathNode, dataObject5, hashMap, bl4, hashSet);
                            break;
                        }
                        default: {
                            if (bl3) {
                                dataObject3 = this.searchAsyncRepository(stringBuffer.toString(), dataObject5);
                                break;
                            }
                            list6 = this.propertyJoinSearch(i, xPathNode, dataObject5, hashMap, bl4, hashSet);
                        }
                    }
                    if (list6 == null) continue;
                    objectArray[i] = list6;
                }
                if (!bl.booleanValue()) {
                    throw new SearchControlException("SEARCH_EXPRESSION_ERROR", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "searchImpl");
                }
                list = this.mergeRepositoryEntities((List[])objectArray, bl4, hashSet);
            } else if (bl3) {
                dataObject3 = this.searchAsyncRepository(stringBuffer.toString(), dataObject5);
            } else {
                object2 = new List[n];
                for (int i = 0; i < n; ++i) {
                    List list8;
                    if (listArray != null) {
                        list8 = listArray[i];
                        if (list8 != null && list8.size() > 0) {
                            if (bl6 || !reposMgr.getRepositoryTypeByRepositoryIndex(i).equals("LdapRepositoryType")) {
                                dataObject7.setList("searchBases", list8);
                            } else {
                                dataObject7.getList("searchBases").clear();
                            }
                            object = this.searchRepository(i, dataObject5, null, bl4, hashSet);
                            if (object == null) continue;
                            object2[i] = object;
                            continue;
                        }
                        if (n != 1) continue;
                        dataObject7.getList("searchBases").clear();
                        object = this.searchRepository(i, dataObject5, null, bl4, hashSet);
                        if (object == null) continue;
                        object2[i] = object;
                        continue;
                    }
                    list8 = this.searchRepository(i, dataObject5, null, bl4, hashSet);
                    if (list8 == null) continue;
                    object2[i] = list8;
                }
                list = this.mergeRepositoryEntities((List[])object2, bl4, hashSet);
            }
        }
        if (bl3 || !bl2) {
            if (!AsyncUtils.isOperationComplete(dataObject3)) {
                if (!bl2) {
                    n4 = AsyncUtils.getPagingSize(dataObject5);
                    n2 = AsyncUtils.getCountLimit(dataObject5);
                    n3 = AsyncUtils.getSearchLimit(dataObject5);
                } else if (dataObject2 != null) {
                    n4 = dataObject2.getInt("size");
                }
                if (n4 > 0) {
                    AsyncUtils.setPagingSize(dataObject3, n4);
                }
                if (n2 > 0) {
                    AsyncUtils.setCountLimit(dataObject3, n2);
                }
                if (n3 > 0) {
                    AsyncUtils.setSearchLimit(dataObject3, n3);
                }
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.exiting(CLASSNAME, "searchImpl", WIMTraceHelper.printDataGraph(dataObject3));
                }
                return dataObject3;
            }
            list = dataObject3.getList("entities");
        }
        if (!this.profileSecManager.isCallerSuperUser()) {
            EntitlementRequest entitlementRequest = new EntitlementRequest(dataObject5);
            object3 = list.iterator();
            while (object3.hasNext()) {
                if (this.profileSecManager.checkPermission_SEARCH(new EntityResource(dataObject5, (DataObject)object3.next()), entitlementRequest.getEntitlementFilter()) != null) continue;
                object3.remove();
            }
        }
        dataObject4 = SDOHelper.createRootDataObject();
        int n8 = list.size();
        if (!bl2) {
            n4 = AsyncUtils.getPagingSize(dataObject5);
            n2 = AsyncUtils.getCountLimit(dataObject5);
            n3 = AsyncUtils.getSearchLimit(dataObject5);
        }
        if (n3 <= 0) {
            n3 = this.maxSearchResults;
        } else if (this.maxSearchResults > 0) {
            int n9 = n3 = this.maxSearchResults > n3 ? n3 : this.maxSearchResults;
        }
        if (n3 > 0 && n8 > n3) {
            throw new MaxResultsExceededException("EXCEED_MAX_TOTAL_SEARCH_LIMIT", WIMMessageHelper.generateMsgParms(Integer.toString(n8), Integer.toString(n3)), CLASSNAME, "searchImpl");
        }
        if (n2 > 0 && n2 < n8) {
            n8 = n2;
            object3 = dataObject4.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchResponseControl");
            object3.setBoolean("hasMoreResults", true);
        }
        object3 = new BasicEList();
        for (int i = 0; i < n8; ++i) {
            DataObject dataObject13 = (DataObject)list.get(i);
            object2 = schemaMgr.getQualifiedTypeName(dataObject13.getType());
            ProfileManager.processReferenceProperty(dataObject13, (String)object2, true, bl4, hashSet);
            object3.add(dataObject13);
        }
        Object object6 = null;
        if (object4 != null) {
            List list9 = object4.getList("sortKeys");
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "searchImpl", WIMTraceHelper.printObjectArray(new Object[]{list9}));
            }
            if (list9 == null || list9.size() == 0) {
                throw new SortControlException("MISSING_SORT_KEY", CLASSNAME, "searchImpl");
            }
            object2 = new SortHandler((DataObject)object4);
            object6 = object2.sortEntities((List)object3);
        } else {
            object6 = object3;
        }
        if (dataObject2 != null) {
            n4 = dataObject2.getInt("size");
        }
        if (n4 > 0 && CommonUtil.isDistributedCacheAvailable()) {
            if (this.pagingSearchCache == null) {
                this.pagingSearchCache = CommonUtil.initDistributedCache(this.pagingSearchCacheName, this.maxTotalPagingSearchResults, this.pagingCachesDiskOffLoad);
            }
            if (this.pagingSearchCache != null && n8 > n4) {
                List<List> list10 = null;
                object2 = SDOHelper.createRootDataObject();
                object6 = dataObject4.getList("entities");
                for (int i = 0; i < n4; ++i) {
                    DataObject dataObject14 = DataGraphHelper.cloneDataObject((DataObject)object3.get(i));
                    object6.add(dataObject14);
                }
                DataObject dataObject15 = null;
                if (this.pagingEntityObject) {
                    list10 = object3.subList(n4, n8);
                } else {
                    list10 = object2.getList("entities");
                    for (int i = 0; i < list.size(); ++i) {
                        object = schemaMgr.createDataObject("http://www.ibm.com/websphere/wim", "Entity");
                        object.setDataObject("identifier", ((DataObject)object3.get(i)).getDataObject("identifier"));
                        list10.add((List)object);
                        dataObject15 = schemaMgr.createDataObject("http://www.ibm.com/websphere/wim", "PropertyControl");
                        dataObject15.setList("properties", dataObject7.getList("properties"));
                        dataObject15.setList("contextProperties", dataObject7.getList("contextProperties"));
                    }
                }
                String string6 = this.pagingSearchCacheName + "time:" + String.valueOf(System.currentTimeMillis());
                object2.getList("entities").addAll(list10);
                if (dataObject15 != null) {
                    object2.setDataObject("controls", dataObject15);
                }
                object = new PageCacheEntry(n8, (DataObject)object2);
                objectArray = string6.getBytes();
                string = new String((byte[])objectArray);
                this.pagingSearchCache.put(string, object, this.dMapPriority, this.pagedEntryTimeToLive, 2, null);
                this.pagingSearchCache.put(TOTAL_PAGED_RESULTS, new Integer(n8 - n4));
                bl = dataObject4.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PageResponseControl");
                bl.setBytes("cookie", (byte[])objectArray);
                bl.setInt("totalSize", n8);
            }
        } else if (dataObject2 != null && n4 == 0) {
            object6.clear();
        }
        dataObject4.getList("entities").addAll(object6);
        this.profileSecManager.setEntitlements(dataObject5, dataObject4, new EntitlementRequest(dataObject5));
        this.unsetExternalId(dataObject4);
        if (bl4) {
            DataObject dataObject16 = dataObject4.createDataObject("contexts");
            dataObject16.set("key", (Object)"failureRepositoryIDs");
            dataObject16.set("value", hashSet);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "searchImpl", WIMTraceHelper.printDataGraph(dataObject4));
        }
        return dataObject4;
    }

    public DataObject getImpl(DataObject dataObject) throws WIMException {
        DataObject dataObject2;
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Object object6;
        String string2;
        DataObject dataObject3;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getImpl");
        }
        if (dataObject == null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "getImpl");
            }
            return null;
        }
        boolean bl = false;
        EntitlementRequest entitlementRequest = new EntitlementRequest(dataObject);
        if (entitlementRequest.isExclusive()) {
            this.profileSecManager.setEntitlements(dataObject, dataObject, entitlementRequest);
            trcLogger.exiting(CLASSNAME, "getImpl", null);
            return dataObject;
        }
        Map map = ControlsHelper.getControlMap(dataObject.getDataGraph());
        boolean bl2 = false;
        boolean bl3 = false;
        List list = dataObject.getList("contexts");
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                dataObject3 = (DataObject)list.get(i);
                string2 = dataObject3.getString("key");
                if (string2 != null && "allowOperationIfReposDown".equals(string2)) {
                    bl2 = (Boolean)dataObject3.get("value");
                }
                if (string2 == null || !"trustEntityType".equals(string2)) continue;
                bl3 = Boolean.valueOf((String)dataObject3.get("value")) != false && ProfileSecurityManager.singleton().isCallerSuperUser();
            }
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        dataObject3 = (DataObject)map.get("ViewControl");
        if (dataObject3 != null) {
            string2 = this.pluginManager.inlineExitCall(CLASSNAME + "." + GET_EMITTER, dataObject, "getInViewExplicit");
            return string2;
        }
        if (reposMgr.isPropertyJoin()) {
            bl = this.containLAProperties(map);
        }
        string2 = (DataObject)map.get("CheckGroupMembershipControl");
        DataObject dataObject4 = schemaMgr.createRootDataObject();
        DataObject dataObject5 = dataObject;
        DataObject dataObject6 = DataGraphHelper.cloneRootDataObject(dataObject5);
        dataObject6.getList("entities").clear();
        if (AsyncUtils.isCheckAsyncOperationStatus(dataObject5)) {
            String string3 = AsyncUtils.getRepositoryId(dataObject5);
            dataObject4 = reposMgr.getRepository(string3).get(dataObject5);
            if (AsyncUtils.isOperationComplete(dataObject4)) {
                this.prepareDataGraphForCaller(dataObject4, null, null, false, null);
                List list2 = dataObject4.getList("entities");
                if (list2 != null && !dataObject4.getDataGraph().getChangeSummary().isLogging()) {
                    dataObject4.getDataGraph().getChangeSummary().beginLogging();
                }
            }
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "getImpl");
            }
            return dataObject4;
        }
        List list3 = dataObject5.getList("entities");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<List[], Object> hashMap3 = new HashMap<List[], Object>();
        String string4 = null;
        int n = 0;
        while (list3.size() > 0) {
            ++n;
            object6 = (DataObject)list3.get(0);
            object52 = object6.getType().getName();
            object4 = object6.getDataObject("identifier");
            if (object4 == null) {
                throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", CLASSNAME, "getImpl");
            }
            String string5 = object4.getString("uniqueId");
            object3 = object4.getString("uniqueName");
            if (object3 != null) {
                object3 = UniqueNameHelper.formatUniqueName((String)object3);
                object4.setString("uniqueName", (String)object3);
            }
            if (!(string5 != null && string5.trim().length() != 0 || object3 != null && ((String)object3).trim().length() != 0)) {
                object2 = object4.getString("externalName");
                if (object2 != null && ((String)object2).length() > 0) {
                    object = (DataObject)map.get("ExternalNameControl");
                    if (object != null) {
                        string = null;
                        String string6 = "ExternalNameControl-" + n;
                        if (!hashMap2.containsKey(string6)) {
                            string = DataGraphHelper.cloneRootDataObject(dataObject6);
                        }
                        string.getList("entities").add(object6);
                        hashMap2.put(string6, string);
                        continue;
                    }
                    throw new WIMApplicationException("EXTERNAL_NAME_CONTROL_NOT_FOUND", WIMMessageHelper.generateMsgParms(object2), CLASSNAME, "getImpl");
                }
                throw new InvalidIdentifierException("INVALID_IDENTIFIER", WIMMessageHelper.generateMsgParms(string5, object3), CLASSNAME, "getImpl");
            }
            if (bl3) {
                object2 = schemaMgr.getQualifiedTypeName(object6.getType());
                string4 = RepositoryManager.singleton().getRepositoryID((String)object3);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "getImpl", "Client entity type will be trusted: " + (String)object2);
                }
            } else {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "getImpl", "Client entity type will NOT be trusted: " + (String)object52);
                }
                object = ProfileManager.retrieveEntity(null, (DataObject)object4, bl2, hashSet);
                object2 = schemaMgr.getQualifiedTypeName(object.getType());
                object3 = object4.getString("uniqueName");
                string4 = object4.getString("repositoryId");
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "getImpl", "Entity type retrieved from repository: " + (String)object2);
                }
            }
            this.checkAccessibility('g', "READ", string4, (String)object2);
            if (string2 != null && schemaMgr.isSuperType("Group", (String)object2)) {
                object = object6.getList("members");
                this.setExtIdAndRepositoryIdForEntities((List)object, string4, bl2, hashSet);
            }
            if ((object = this.getRealmName(dataObject5)) != null && !this.realmMgr.isUniqueNameInRealm((String)object3, (String)object)) {
                throw new EntityNotInRealmScopeException("ENTITY_NOT_IN_REALM_SCOPE", WIMMessageHelper.generateMsgParms(object3, object), CLASSNAME, "getImpl");
            }
            string = null;
            string = !hashMap.containsKey(string4) ? DataGraphHelper.cloneRootDataObject(dataObject6) : (DataObject)hashMap.get(string4);
            string.getList("entities").add(object6);
            hashMap.put(string4, string);
        }
        if (this.multipleRepositories(hashMap, hashMap2) && this.containAsychRepository(hashMap, hashMap2)) {
            throw new OperationNotSupportedException("ASYNC_CALL_WITH_MULTIPLE_REPOSITORIES_NOT_SUPPORTED", CLASSNAME, "getImpl");
        }
        for (Object object52 : hashMap2.keySet()) {
            if (!object52.startsWith("ExternalNameControl")) continue;
            object4 = (DataObject)hashMap2.get(object52);
            for (int i = 0; i < reposMgr.getNumberOfRepositories(); ++i) {
                block62: {
                    object3 = null;
                    try {
                        object3 = reposMgr.getRepositories()[i].get((DataObject)object4);
                        if (object3 == null || !reposMgr.isPropertyJoin()) break block62;
                        object2 = dataObject.getDataGraph().getRootObject().getDataObject("Root").getList("controls");
                        try {
                            if (object2.size() != 0) {
                                if (bl) {
                                    object3.getList("controls").clear();
                                    object3.getList("controls").addAll(object2);
                                    RepositoryManager.singleton().getLookasideRepository().get((DataObject)object3);
                                }
                                break block62;
                            }
                            RepositoryManager.singleton().getLookasideRepository().get((DataObject)object3);
                        }
                        catch (WIMException wIMException) {
                            if (!bl2) {
                                throw wIMException;
                            }
                            trcLogger.logp(Level.FINER, CLASSNAME, "getImpl", "IGNORE: exception [" + wIMException.getMessage() + "] on LA repository ");
                            hashSet.add(reposMgr.getLookasideRepositoryID());
                        }
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "getImpl", "IGNORE: exception [" + entityNotFoundException.getMessage() + "] on repository [" + reposMgr.getRepositoryIDByRepositoryIndex(i) + "]");
                    }
                    catch (WIMException wIMException) {
                        if (!bl2) {
                            throw wIMException;
                        }
                        trcLogger.logp(Level.FINER, CLASSNAME, "getImpl", "IGNORE: exception [" + wIMException.getMessage() + "] on repository [" + reposMgr.getRepositoryIDByRepositoryIndex(i) + "]");
                        hashSet.add(reposMgr.getRepositoryIDByRepositoryIndex(i));
                        continue;
                    }
                }
                if (object3 == null) continue;
                this.prepareDataGraphForCaller((DataObject)object3, null, null, bl2, hashSet);
                hashMap3.put((List[])object52, object3);
            }
        }
        for (Object object52 : hashMap.keySet()) {
            object4 = (DataObject)hashMap.get(object52);
            DataObject dataObject7 = null;
            try {
                dataObject7 = reposMgr.getRepository((String)object52).get((DataObject)object4);
            }
            catch (WIMException wIMException) {
                if (!bl2) {
                    throw wIMException;
                }
                trcLogger.logp(Level.FINER, CLASSNAME, "getImpl", "IGNORE: exception [" + wIMException.getMessage() + "] on repository [" + (String)object52 + "]");
                hashSet.add(object52);
                continue;
            }
            if (map.containsKey("GroupMembershipControl")) {
                object3 = (DataObject)map.get("GroupMembershipControl");
                int n2 = object3.getInt("level");
                this.groupMembershipLookup(dataObject7, (String)object52, (DataObject)object3, bl2, hashSet);
            }
            if (map.containsKey("GroupMemberControl")) {
                object3 = (DataObject)map.get("GroupMemberControl");
                int n3 = object3.getInt("level");
                this.groupMembershipLookup(dataObject7, (String)object52, (DataObject)object3, bl2, hashSet);
            }
            if (dataObject7 != null && reposMgr.isPropertyJoin()) {
                object3 = dataObject.getDataGraph().getRootObject().getDataObject("Root").getList("controls");
                try {
                    if (object3.size() != 0) {
                        if (bl) {
                            dataObject7.getList("controls").clear();
                            dataObject7.getList("controls").addAll(object3);
                            RepositoryManager.singleton().getLookasideRepository().get(dataObject7);
                        }
                    } else {
                        RepositoryManager.singleton().getLookasideRepository().get(dataObject7);
                    }
                }
                catch (WIMException wIMException) {
                    if (!bl2) {
                        throw wIMException;
                    }
                    trcLogger.logp(Level.FINER, CLASSNAME, "getImpl", "IGNORE: exception [" + wIMException.getMessage() + "] on LA repository ");
                    hashSet.add(reposMgr.getLookasideRepositoryID());
                }
            }
            this.prepareDataGraphForCaller(dataObject7, null, null, bl2, hashSet);
            hashMap3.put((List[])object52, dataObject7);
        }
        object52 = new List[hashMap3.size()];
        object6 = hashMap3.keySet().iterator();
        n = 0;
        while (object6.hasNext()) {
            object4 = (String)object6.next();
            DataObject dataObject8 = (DataObject)hashMap3.get(object4);
            object52[n++] = dataObject8.getList("entities");
            object3 = dataObject8.getList("controls");
            dataObject4.getList("controls").addAll(object3);
        }
        object4 = this.mergeEntitiesList((List[])object52);
        if (bl3) {
            for (int i = 0; i < object4.size(); ++i) {
                object3 = (DataObject)object4.get(i);
                DataObject dataObject9 = object3.getDataObject("identifier");
                object = dataObject9.getString("repositoryId");
                string = schemaMgr.getQualifiedTypeName(object3.getType());
                this.checkAccessibility('g', "READ", (String)object, string);
            }
        }
        if (!this.profileSecManager.isCallerSuperUser()) {
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                this.profileSecManager.checkPermission_GET(new EntityResource(dataObject, (DataObject)iterator.next()));
            }
        }
        if ((dataObject2 = (DataObject)map.get("SortControl")) != null) {
            object3 = dataObject2.getList("sortKeys");
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "getImpl", WIMTraceHelper.printObjectArray(new Object[]{object3}));
            }
            if (object3 == null || object3.size() == 0) {
                throw new SortControlException("MISSING_SORT_KEY", CLASSNAME, "getImpl");
            }
            SortHandler sortHandler = new SortHandler(dataObject2);
            object4 = sortHandler.sortEntities((List)object4);
        }
        dataObject4.setList("entities", (List)object4);
        this.profileSecManager.setEntitlements(dataObject, dataObject4, new EntitlementRequest(dataObject));
        this.unsetExternalId(dataObject4);
        if (bl2) {
            object3 = dataObject4.createDataObject("contexts");
            object3.set("key", (Object)"failureRepositoryIDs");
            object3.set("value", hashSet);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getImpl");
        }
        return dataObject4;
    }

    private boolean containAsychRepository(HashMap hashMap, HashMap hashMap2) throws WIMException {
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!reposMgr.isAsyncModeSupported((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean multipleRepositories(HashMap hashMap, HashMap hashMap2) {
        return hashMap.size() > 1;
    }

    private boolean containLAProperties(Map map) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "containLAProperties");
        }
        boolean bl = false;
        Set set = this.getLAProperties();
        if (map != null) {
            for (String string : map.keySet()) {
                List list;
                DataObject dataObject;
                if (!schemaMgr.isSuperType("PropertyControl", string) || (dataObject = (DataObject)map.get(string)) == null || (list = dataObject.getList("properties")) == null) continue;
                for (int i = 0; i < list.size() && !bl; ++i) {
                    String string2 = (String)list.get(i);
                    if (set != null && set.contains(string2)) {
                        bl = true;
                        continue;
                    }
                    if (!string2.equals("*")) continue;
                    bl = true;
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "containLAProperties", "" + bl);
        }
        return bl;
    }

    private boolean containLAProperties(String string, DataObject dataObject, List list) throws WIMException {
        String string2;
        HashSet hashSet;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "containLAProperties(reposId,entity)");
        }
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        if (list != null & list.size() > 0) {
            bl2 = true;
            for (int i = 0; i < list.size(); ++i) {
                hashSet = (Property)list.get(i);
                arrayList.add(hashSet.getName());
            }
        }
        HashSet hashSet2 = hashSet = propMgr.getLookAsidePropertyNameSet(string2 = schemaMgr.getQualifiedTypeName(dataObject.getType())) != null ? new HashSet(propMgr.getLookAsidePropertyNameSet(string2)) : null;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "containLAProperties(reposId,entity)", "needCheck=" + bl2 + ", delProNameList=" + arrayList);
            trcLogger.logp(Level.FINEST, CLASSNAME, "containLAProperties(reposId,entity)", "entity type=" + string2 + ", LA props=" + hashSet);
        }
        if (hashSet != null) {
            Property property;
            Set set = propMgr.getRepositoryPropertyNameSet(string, string2);
            if (set != null) {
                for (String string3 : set) {
                    property = schemaMgr.getProperty(string2, string3);
                    if (property == null || !hashSet.contains(string3)) continue;
                    hashSet.remove(string3);
                }
            }
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "containLAProperties(reposId,entity)", "LA props(after removing repo props)=" + hashSet);
            }
            for (String string3 : hashSet) {
                property = schemaMgr.getProperty(string2, string3);
                try {
                    if (dataObject.isSet(property)) {
                        bl = true;
                        break;
                    }
                    if (!bl2 || !arrayList.contains(property.getName())) continue;
                    bl = true;
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!trcLogger.isLoggable(Level.FINEST)) continue;
                    trcLogger.logp(Level.FINEST, CLASSNAME, "containLAProperties(reposId,entity)", "Exception:", illegalArgumentException);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "containLAProperties(reposId,entity)", "" + bl);
        }
        return bl;
    }

    private Set getRepositoryPropertyNameSetWithoutLA(String string, DataObject dataObject) throws WIMException {
        HashSet hashSet = new HashSet(propMgr.getRepositoryPropertyNameSet(string, dataObject.getType()));
        Set set = propMgr.getLookAsidePropertyNameSet(dataObject.getType());
        hashSet.removeAll(set);
        hashSet.remove("identifier");
        hashSet.remove("viewIdentifiers");
        return hashSet;
    }

    private boolean containsRepositoryProperties(String string, DataObject dataObject, EChangeSummary eChangeSummary) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "containsRepositoryProperties");
        }
        boolean bl = false;
        Set set = this.getRepositoryPropertyNameSetWithoutLA(string, dataObject);
        if (set != null && eChangeSummary != null) {
            List list = eChangeSummary.getChangedDataObjects();
            if (list.size() > 0) {
                DataObject dataObject2 = (DataObject)list.get(0);
                for (ChangeSummary.Setting setting : eChangeSummary.getOldValues(dataObject2)) {
                    Property property = setting.getProperty();
                    String string2 = property.getName();
                    if (!set.contains(string2)) continue;
                    bl = true;
                    break;
                }
            } else {
                for (String string3 : set) {
                    try {
                        if (!dataObject.isSet(string3)) continue;
                        bl = true;
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "containsRepositoryProperties", "" + bl);
        }
        return bl;
    }

    private void removeLAProperties(String string, DataObject dataObject, EChangeSummary eChangeSummary) throws WIMException {
        Set set;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "removeLAProperties");
        }
        if ((set = propMgr.getLookAsidePropertyNameSet(dataObject.getType())) != null) {
            for (String string2 : set) {
                try {
                    if (!dataObject.isSet(string2)) continue;
                    dataObject.unset(string2);
                    if (!trcLogger.isLoggable(Level.FINER)) continue;
                    trcLogger.logp(Level.FINER, CLASSNAME, "removeLAProperties", "remove la property " + string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.removePropertyFromChangeSummary(set, eChangeSummary);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "removeLAProperties");
        }
    }

    private void removePropertyFromChangeSummary(Set set, EChangeSummary eChangeSummary) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "removePropertyFromChangeSummary");
        }
        if (eChangeSummary != null) {
            List list = eChangeSummary.getChangedDataObjects();
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject = (DataObject)list.get(i);
                Iterator iterator = eChangeSummary.getOldValues(dataObject).iterator();
                while (iterator.hasNext()) {
                    ChangeSummary.Setting setting = (ChangeSummary.Setting)iterator.next();
                    Property property = setting.getProperty();
                    String string = property.getName();
                    if (set.contains(string)) {
                        if (trcLogger.isLoggable(Level.FINER)) {
                            trcLogger.logp(Level.FINER, CLASSNAME, "removePropertyFromChangeSummary", "removing LA prop from changeSummary: " + string);
                        }
                        iterator.remove();
                        continue;
                    }
                    if (string.equalsIgnoreCase("ibmPrimaryEmail") && set.contains("ibm-primaryEmail")) {
                        if (trcLogger.isLoggable(Level.FINER)) {
                            trcLogger.logp(Level.FINER, CLASSNAME, "removePropertyFromChangeSummary", "removing LA prop from changeSummary: ibm-primaryEmail");
                        }
                        iterator.remove();
                        continue;
                    }
                    if (!string.equalsIgnoreCase("ibmJobTitle") || !set.contains("ibm-jobTitle")) continue;
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "removePropertyFromChangeSummary", "removing LA prop from changeSummary: ibm-jobTitle");
                    }
                    iterator.remove();
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "removePropertyFromChangeSummary");
        }
    }

    private void retainLAProperties(String string, DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "retainLAProperties");
        }
        Set set = propMgr.getRepositoryPropertyNameSet(string, dataObject.getType());
        Set set2 = propMgr.getLookAsidePropertyNameSet(dataObject.getType());
        if (set2 != null && set != null) {
            for (String string2 : set) {
                try {
                    if (!dataObject.isSet(string2) || set2.contains(string2)) continue;
                    dataObject.unset(string2);
                    if (!trcLogger.isLoggable(Level.FINER)) continue;
                    trcLogger.logp(Level.FINER, CLASSNAME, "retainLAProperties", "remove none la property " + string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "retainLAProperties");
        }
    }

    private Set getLAProperties() {
        if (this.laSupportedProps == null) {
            this.laSupportedProps = new HashSet();
            RepositoryPropertyMap repositoryPropertyMap = propMgr.getLookAsidePropertyNameMap();
            Set set = repositoryPropertyMap.getEntityTypes();
            for (String string : set) {
                Set set2 = repositoryPropertyMap.getRepositoryPropertySetByEntityType(string);
                this.laSupportedProps.addAll(set2);
            }
        }
        return this.laSupportedProps;
    }

    protected void invalidLAProperties() {
        this.laSupportedProps = null;
    }

    private List mergeEntitiesList(List[] listArray) {
        BasicEList basicEList = new BasicEList();
        for (int i = 0; i < listArray.length; ++i) {
            if (listArray[i] == null) continue;
            basicEList.addAll(listArray[i]);
        }
        return basicEList;
    }

    public void mergeLookasideDataObject(DataObject dataObject, DataObject dataObject2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "mergeLookasideDataObject", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printDataGraph(dataObject), WIMTraceHelper.printDataGraph(dataObject2)));
        }
        if (dataObject != null && dataObject2 != null) {
            List list = dataObject2.getList("entities");
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                Type type = dataObject3.getType();
                Set set = propMgr.getLookAsidePropertyNameSet(type);
                DataObject dataObject4 = this.getTargetEntity(dataObject, dataObject3.getDataObject("identifier"));
                if (dataObject4 == null || set == null) continue;
                for (String string : set) {
                    Property property = schemaMgr.getProperty(type, string);
                    if (property == null || !dataObject3.isSet(property)) continue;
                    if (property.isMany()) {
                        dataObject4.setList(property, dataObject3.getList(property));
                        continue;
                    }
                    dataObject4.set(property, dataObject3.get(property));
                }
            }
        } else {
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("targetRoot=null or laRoot=null"), CLASSNAME, "mergeLookasideDataObject");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "mergeLookasideDataObject", WIMTraceHelper.printDataObject(dataObject));
        }
    }

    private DataObject getTargetEntity(DataObject dataObject, DataObject dataObject2) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getTargetEntity");
        }
        DataObject dataObject3 = null;
        if (dataObject != null && dataObject2 != null) {
            List list = dataObject.getList("entities");
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject4 = (DataObject)list.get(i);
                DataObject dataObject5 = dataObject4.getDataObject("identifier");
                if (!this.isIdentifierEqual(dataObject5, dataObject2)) continue;
                dataObject3 = dataObject4;
                break;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getTargetEntity");
        }
        return dataObject3;
    }

    private boolean isIdentifierEqual(DataObject dataObject, DataObject dataObject2) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isIdentifierEqual");
        }
        boolean bl = false;
        if (dataObject.getString("uniqueId") != null && dataObject.getString("uniqueId").equals(dataObject2.getString("uniqueId"))) {
            bl = true;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "isIdentifierEqual", "uniqueId matches");
            }
        } else if (dataObject.getString("uniqueName") != null && dataObject.getString("uniqueName").equals(dataObject2.getString("uniqueName"))) {
            bl = true;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "isIdentifierEqual", "uniqueName matches");
            }
        } else if (dataObject.getString("externalId") != null && dataObject.getString("externalId").equals(dataObject2.getString("externalId"))) {
            bl = true;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "isIdentifierEqual", "externalId matches");
            }
        } else if (dataObject.getString("externalName") != null && dataObject.getString("externalName").equals(dataObject2.getString("externalName"))) {
            bl = true;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "isIdentifierEqual", "externalName matches");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isIdentifierEqual");
        }
        return bl;
    }

    public DataObject deleteImpl(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "deleteImpl");
        }
        reposMgr = RepositoryManager.singleton();
        if (dataObject == null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "deleteImpl");
            }
            return null;
        }
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        if (changeSummary.isLogging()) {
            changeSummary.endLogging();
        }
        DataObject dataObject2 = dataObject;
        DataObject dataObject3 = DataGraphHelper.cloneRootDataObject(dataObject2);
        boolean bl = false;
        if (AsyncUtils.isCheckAsyncOperationStatus(dataObject3)) {
            String string = AsyncUtils.getRepositoryId(dataObject3);
            DataObject dataObject4 = reposMgr.getRepository(string).delete(dataObject3);
            if (dataObject4 != null && AsyncUtils.isOperationComplete(dataObject4)) {
                Map map = ControlsHelper.getControlMap(dataObject.getDataGraph());
                DataObject dataObject5 = (DataObject)map.get("DeleteControl");
                if (dataObject5 != null) {
                    bl = dataObject5.getBoolean("returnDeleted");
                }
                dataObject4 = this.postDelete(dataObject4, string, bl);
            }
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "deleteImpl");
            }
            return dataObject4;
        }
        List list = dataObject3.getList("entities");
        if (list.size() == 0) {
            throw new EntityNotFoundException("MISSING_ENTITY_DATA_OBJECT", WIMMessageHelper.generateMsgParms(DELETE_EMITTER), CLASSNAME, "deleteImpl");
        }
        if (list.size() > 1) {
            throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", WIMMessageHelper.generateMsgParms("DELETE"), CLASSNAME, "deleteImpl");
        }
        DataObject dataObject6 = (DataObject)list.get(0);
        Map map = ControlsHelper.getControlMap(dataObject.getDataGraph());
        DataObject dataObject7 = (DataObject)map.get("ViewControl");
        if (dataObject7 != null) {
            DataObject dataObject8 = this.pluginManager.inlineExitCall(CLASSNAME + "." + DELETE_EMITTER, dataObject, "deleteInViewExplicit");
            return dataObject8;
        }
        DataObject dataObject9 = (DataObject)map.get("DeleteControl");
        boolean bl2 = false;
        if (dataObject9 != null) {
            bl2 = dataObject9.getBoolean("deleteDescendants");
            bl = dataObject9.getBoolean("returnDeleted");
        }
        this.profileSecManager.checkPermission_DELETE(new EntityResource(dataObject, dataObject6), bl2);
        DataObject dataObject10 = dataObject6.getDataObject("identifier");
        if (dataObject10 == null) {
            throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", CLASSNAME, "deleteImpl");
        }
        DataObject dataObject11 = dataObject6;
        if (!(dataObject10.isSet("externalId") && dataObject10.isSet("externalName") && dataObject10.isSet("repositoryId"))) {
            dataObject11 = ProfileManager.retrieveEntity(null, dataObject10, false, null);
        }
        String string = dataObject10.getString("repositoryId");
        String string2 = dataObject10.getString("uniqueName");
        String string3 = this.getRealmName(dataObject2);
        if (string3 != null && !this.realmMgr.isUniqueNameInRealm(string2, string3)) {
            throw new EntityNotInRealmScopeException("ENTITY_NOT_IN_REALM_SCOPE", WIMMessageHelper.generateMsgParms(string2, string3), CLASSNAME, "deleteImpl");
        }
        String string4 = schemaMgr.getQualifiedTypeName(dataObject11.getType());
        this.checkAccessibility('d', "DELETE", string, string4);
        EChangeSummary eChangeSummary = (EChangeSummary)DataGraphHelper.cloneEObject((EObject)((EDataObject)changeSummary));
        ((EDataGraph)dataObject3.getDataGraph()).setEChangeSummary(eChangeSummary);
        DataObject dataObject12 = RepositoryManager.singleton().getRepository(string).delete(dataObject3);
        if (dataObject12 != null && AsyncUtils.isOperationComplete(dataObject12)) {
            dataObject12 = this.postDelete(dataObject12, string, bl);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "deleteImpl");
        }
        return dataObject12;
    }

    private DataObject postDelete(DataObject dataObject, String string, boolean bl) throws WIMException {
        String string2;
        String string3;
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "postDelete");
        }
        DataObject dataObject2 = DataGraphHelper.cloneRootDataObject(dataObject);
        List list = dataObject.getList("entities");
        List list2 = dataObject2.getList("entities");
        if (bl) {
            this.prepareDataGraphForCaller(dataObject, null, null, false, null);
        }
        if (reposMgr.isEntryJoin()) {
            for (int i = 0; i < list.size(); ++i) {
                object = (DataObject)list.get(i);
                Object object2 = object.getDataObject("identifier");
                string3 = object2.getString("uniqueName");
                string2 = schemaMgr.getQualifiedTypeName(object.getType());
                FederationEntity federationEntity = new FederationEntity();
                federationEntity.setUniqueId(object2.getString("uniqueId"));
                federationEntity.setUniqueName(string3);
                federationEntity.setRepositoryId(string);
                federationEntity.setExternalId(object2.getString("externalId"));
                reposMgr.getFederationRepository().remove(federationEntity);
            }
        }
        if (reposMgr.isPropertyJoin()) {
            DataObject dataObject3 = schemaMgr.createRootDataObject();
            dataObject3.setList("entities", list2);
            object = reposMgr.getLookasideRepository().delete(dataObject3);
        }
        if (reposMgr.isCrossRepositoryGroupMembership(string)) {
            dataObject2 = DataGraphHelper.cloneRootDataObject(dataObject);
            list2 = dataObject2.getList("entities");
            Set set = reposMgr.getRepositoriesForGroupMembership(string);
            if (set != null) {
                for (Object object2 : set) {
                    if (reposMgr.isDBRepository((String)object2)) {
                        string3 = schemaMgr.createRootDataObject();
                        string3.setList("entities", list2);
                        string3.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMembershipControl");
                        string2 = reposMgr.getRepository((String)object2).delete((DataObject)string3);
                        continue;
                    }
                    if (((String)object2).equals(string)) continue;
                    throw new WIMApplicationException("CANNOT_STORE_ENTITY_FROM_OTHER_REPOSITORY", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "postDelete");
                }
            }
        }
        if (!bl) {
            list.clear();
        }
        if (!dataObject.getDataGraph().getChangeSummary().isLogging()) {
            dataObject.getDataGraph().getChangeSummary().beginLogging();
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "postDelete");
        }
        return dataObject;
    }

    private static DataObject retrieveEntityFromRepository(String string, DataObject dataObject, boolean bl, Set set) throws WIMException {
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "retrieveEntityFromRepository", "(" + string + ", " + dataObject + ", " + bl + ", " + set + ")");
        }
        DataObject dataObject2 = null;
        DataObject dataObject3 = schemaMgr.createRootDataObject();
        String string2 = dataObject.getString("externalId");
        String string3 = dataObject.getString("externalName");
        String string4 = dataObject.getString("uniqueId");
        String string5 = dataObject.getString("uniqueName");
        if (!(string4 != null && string4.length() != 0 || string5 != null && string5.length() != 0)) {
            throw new InvalidIdentifierException("INVALID_IDENTIFIER", WIMMessageHelper.generateMsgParms(string4, string5), CLASSNAME, "retrieveEntityFromRepository");
        }
        if (dataObject2 == null) {
            object = dataObject3.createDataObject("entities");
            DataObject dataObject4 = object.createDataObject("identifier");
            if (string2 != null) {
                dataObject4.setString("externalId", string2);
            } else {
                dataObject4.setString("externalId", string4);
            }
            dataObject4.setString("externalName", string3);
            dataObject4.setString("uniqueName", string5);
            DataObject dataObject5 = dataObject3.createDataObject("controls", "http://www.ibm.com/websphere/wim", "RequestControl");
            dataObject5.setString("requiredInteractionStyle", "sync");
            if (string4 != null && string == null) {
                for (int i = 0; i < reposMgr.getNumberOfRepositories() && dataObject2 == null; ++i) {
                    try {
                        List list;
                        DataObject dataObject6 = reposMgr.getRepositories()[i].get(DataGraphHelper.cloneRootDataObject(dataObject3));
                        if (dataObject6 == null || (list = dataObject6.getList("entities")).size() < 1) continue;
                        dataObject2 = (DataObject)list.get(0);
                        continue;
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        if (!trcLogger.isLoggable(Level.FINER)) continue;
                        trcLogger.logp(Level.FINER, CLASSNAME, "retrieveEntityFromRepository", "EntityNotFoundException[repoIndex=" + i + "] - " + string4);
                        continue;
                    }
                    catch (WIMException wIMException) {
                        if (!bl) {
                            throw wIMException;
                        }
                        trcLogger.logp(Level.FINER, CLASSNAME, "retrieveEntityFromRepository", "IGNORE: exception [" + wIMException.getMessage() + "] when retrieve entity from repository [" + reposMgr.getRepositoryIDByRepositoryIndex(i) + "]");
                        set.add(reposMgr.getRepositoryIDByRepositoryIndex(i));
                    }
                }
            } else {
                List list;
                DataObject dataObject7;
                if (string == null) {
                    string = reposMgr.getRepositoryID(string5);
                }
                if ((dataObject7 = reposMgr.getRepository(string).get(dataObject3)) != null && (list = dataObject7.getList("entities")).size() >= 1) {
                    dataObject2 = (DataObject)list.get(0);
                }
            }
        }
        if (dataObject2 == null) {
            object = null;
            object = string4 != null ? string4 : string5;
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(object), CLASSNAME, "retrieveEntityFromRepository");
        }
        object = dataObject2.getDataObject("identifier");
        dataObject.setString("externalId", object.getString("externalId"));
        dataObject.setString("externalName", object.getString("externalName"));
        dataObject.setString("uniqueId", object.getString("uniqueId"));
        dataObject.setString("uniqueName", object.getString("uniqueName"));
        dataObject.setString("repositoryId", object.getString("repositoryId"));
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "retrieveEntityFromRepository");
        }
        return dataObject2;
    }

    private static DataObject retrieveEntity(String string, DataObject dataObject, boolean bl, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "retrieveEntity", "(" + string + ", " + dataObject + ", " + bl + ", " + set + ")");
        }
        DataObject dataObject2 = null;
        String string2 = dataObject.getString("uniqueId");
        String string3 = dataObject.getString("uniqueName");
        if (!(string2 != null && string2.length() != 0 || string3 != null && string3.length() != 0)) {
            throw new InvalidIdentifierException("INVALID_IDENTIFIER", WIMMessageHelper.generateMsgParms(string2, string3), CLASSNAME, "retrieveEntity");
        }
        if (string3 != null) {
            string3 = UniqueNameHelper.formatUniqueName(string3);
        }
        if (reposMgr.isEntryJoin()) {
            try {
                FederationEntity federationEntity = null;
                federationEntity = string2 != null ? reposMgr.getFederationRepository().lookupByUniqueId(string2) : reposMgr.getFederationRepository().lookupByUniqueName(string3);
                if (federationEntity != null) {
                    String string4 = federationEntity.getEntityType();
                    String string5 = schemaMgr.getTypeNsURI(string4);
                    String string6 = schemaMgr.getTypeName(string4);
                    dataObject2 = schemaMgr.createDataObject(string5, string6);
                    DataObject dataObject3 = dataObject2.createDataObject("identifier");
                    dataObject3.setString("repositoryId", federationEntity.getRepositoryId());
                    dataObject.setString("repositoryId", federationEntity.getRepositoryId());
                    dataObject3.setString("externalId", federationEntity.getExternalId());
                    dataObject.setString("externalId", federationEntity.getExternalId());
                    String string7 = federationEntity.getUniqueName();
                    if (string7 != null) {
                        dataObject3.setString("uniqueName", string7);
                        dataObject.setString("uniqueName", string7);
                    } else if (string3 != null) {
                        dataObject3.setString("uniqueName", string3);
                    } else {
                        dataObject2 = null;
                    }
                }
            }
            catch (WIMException wIMException) {
                if (!bl) {
                    throw wIMException;
                }
                trcLogger.logp(Level.FINER, CLASSNAME, "retrieveEntity", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                set.add(reposMgr.getFederationRepositoryID());
            }
        }
        if (dataObject2 == null) {
            dataObject2 = ProfileManager.retrieveEntityFromRepository(string, dataObject, bl, set);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "retrieveEntity");
        }
        return dataObject2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataObject updateImpl(DataObject dataObject) throws WIMException {
        String string;
        DataObject dataObject2;
        Object object;
        int n;
        List list;
        Object object2;
        ChangeSummary.Setting setting2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateImpl");
        }
        if (dataObject == null) {
            if (!trcLogger.isLoggable(Level.FINER)) return null;
            trcLogger.exiting(CLASSNAME, "updateImpl");
            return null;
        }
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        if (changeSummary.isLogging()) {
            changeSummary.endLogging();
        }
        DataObject dataObject3 = dataObject;
        DataObject dataObject4 = DataGraphHelper.deepCloneRootDataObject(dataObject3);
        DataObject dataObject5 = null;
        int n2 = -1;
        String string2 = null;
        DataObject dataObject6 = null;
        boolean bl = true;
        if (AsyncUtils.isCheckAsyncOperationStatus(dataObject4)) {
            string2 = AsyncUtils.getRepositoryId(dataObject4);
            dataObject5 = reposMgr.getRepository(string2).update(dataObject4);
            if (AsyncUtils.isOperationComplete(dataObject5)) {
                DataObject dataObject7;
                DataObject dataObject8;
                String string3 = null;
                String string4 = null;
                List list2 = dataObject5.getList("entities");
                if (list2.size() > 0 && (dataObject8 = (dataObject7 = (DataObject)list2.get(0)).getDataObject("identifier")) != null) {
                    string3 = dataObject8.getString("uniqueId");
                    string4 = dataObject8.getString("uniqueName");
                }
                dataObject5 = this.postUpdate(dataObject4, dataObject5, null, string3, string4);
            }
            if (!trcLogger.isLoggable(Level.FINER)) return dataObject5;
            trcLogger.exiting(CLASSNAME, "updateImpl");
            return dataObject5;
        }
        List list3 = dataObject4.getList("entities");
        if (list3.size() == 0) {
            throw new EntityNotFoundException("MISSING_ENTITY_DATA_OBJECT", WIMMessageHelper.generateMsgParms(UPDATE_EMITTER), CLASSNAME, "updateImpl");
        }
        if (list3.size() > 1) {
            throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", WIMMessageHelper.generateMsgParms("UPDATE"), CLASSNAME, "updateImpl");
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        List list4 = changeSummary.getChangedDataObjects();
        for (DataObject dataObject9 : list4) {
            for (ChangeSummary.Setting setting2 : changeSummary.getOldValues(dataObject9)) {
                Property property = setting2.getProperty();
                object2 = dataObject9.get(property);
                if (object2 instanceof List && ((List)object2).size() == 0) {
                    object2 = null;
                }
                if (object2 != null && dataObject9.isSet(property) || arrayList.contains(property)) continue;
                arrayList.add(property);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "updateImpl", "deletedAttributes=" + arrayList);
        }
        DataObject dataObject10 = (DataObject)list3.get(0);
        String string5 = dataObject10.getType().getName();
        this.profileSecManager.checkPermission_UPDATE(new EntityResource(dataObject, dataObject10));
        DataObject dataObject11 = dataObject10.getDataObject("identifier");
        if (dataObject11 == null) {
            throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", CLASSNAME, "updateImpl");
        }
        setting2 = dataObject10;
        if (!(dataObject11.isSet("externalId") && dataObject11.isSet("externalName") && dataObject11.isSet("repositoryId"))) {
            setting2 = ProfileManager.retrieveEntity(null, dataObject11, false, null);
        }
        string2 = dataObject11.getString("repositoryId");
        n2 = reposMgr.getRepositoryIndexByRepositoryID(string2);
        String string6 = schemaMgr.getQualifiedTypeName(setting2.getType());
        object2 = dataObject11.getString("uniqueId");
        String string7 = dataObject11.getString("uniqueName");
        String string8 = this.getRealmName(dataObject3);
        if (string8 != null && !this.realmMgr.isUniqueNameInRealm(string7, string8)) {
            throw new EntityNotInRealmScopeException("ENTITY_NOT_IN_REALM_SCOPE", WIMMessageHelper.generateMsgParms(string7, string8), CLASSNAME, "updateImpl");
        }
        this.checkCreateAndModifyTimeStamp(string6, dataObject10);
        ProfileManager.processReferenceProperty(dataObject10, string5, false, false, null);
        if (schemaMgr.isSuperType("Group", string6)) {
            this.setExtIdAndRepositoryIdForEntities(dataObject10.getList("members"), string2, false, null);
            list = dataObject10.getList("members");
            if (list != null && list.size() > 0) {
                for (n = 0; n < list.size(); ++n) {
                    object = DataGraphHelper.cloneDataObject((DataObject)list.get(n));
                    dataObject2 = object.getDataObject("identifier");
                    string = this.retrieveTargetRepository(dataObject2);
                    boolean bl2 = reposMgr.canGroupAcceptMember(string2, string);
                    if (!bl2 && !string2.equalsIgnoreCase(string)) throw new OperationNotSupportedException("MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "updateImpl");
                    if (bl) {
                        // empty if block
                    }
                    bl = false;
                }
            }
        }
        if (reposMgr.isAsyncModeSupported(n2) && reposMgr.isPropertyJoin() && (list = this.divideDataObject(dataObject4, reposMgr.getRepositoryIDByRepositoryIndex(n2))) != null) {
            throw new OperationNotSupportedException("ASYNC_CALL_WITH_MULTIPLE_REPOSITORIES_NOT_SUPPORTED", CLASSNAME, "updateImpl");
        }
        list = dataObject10.getList("groups");
        if (list != null && list.size() > 0) {
            if (reposMgr.isCrossRepositoryGroupMembership(string2)) {
                List list5;
                bl = true;
                this.setExtIdAndRepositoryIdForEntities(list3, string2, false, null);
                HashMap<String, List> hashMap = new HashMap<String, List>();
                for (int i = 0; i < list.size(); ++i) {
                    dataObject2 = DataGraphHelper.cloneDataObject((DataObject)list.get(i));
                    string = dataObject2.getDataObject("identifier");
                    String string9 = this.retrieveTargetRepository((DataObject)string);
                    list5 = (List)hashMap.get(string9);
                    if (list5 == null) {
                        list5 = new BasicEList();
                    }
                    list5.add(dataObject2);
                    hashMap.put(string9, list5);
                }
                object = hashMap.keySet().iterator();
                boolean bl3 = false;
                while (object.hasNext()) {
                    if (bl3) throw new OperationNotSupportedException("ASYNC_CALL_WITH_MULTIPLE_REPOSITORIES_NOT_SUPPORTED", CLASSNAME, "updateImpl");
                    string = (String)object.next();
                    bl3 = reposMgr.isAsyncModeSupported(string);
                }
                string = (EChangeSummary)dataObject4.getDataGraph().getChangeSummary();
                List list6 = (List)hashMap.get(string2);
                if (list6 == null) {
                    dataObject10.unset("groups");
                } else {
                    dataObject10.setList("groups", list6);
                }
                list5 = DataGraphHelper.cloneDataObject(dataObject10);
                if (reposMgr.isPropertyJoin() && this.containLAProperties(string2, dataObject10, arrayList)) {
                    if (this.containsRepositoryProperties(string2, dataObject10, (EChangeSummary)string)) {
                        String string10;
                        this.checkAccessibility('u', "UPDATE", string2, string6);
                        DataObject dataObject12 = DataGraphHelper.deepCloneRootDataObject(dataObject4);
                        this.removeLAProperties(string2, dataObject10, (EChangeSummary)string);
                        dataObject5 = reposMgr.getRepository(string2).update(dataObject4);
                        if (dataObject5.getList("entities").size() == 0) {
                            string10 = dataObject5.createDataObject("entities", dataObject10.getType().getURI(), string6);
                            string10.setDataObject("identifier", dataObject10.getDataObject("identifier"));
                        }
                        string10 = this.processIdentifierForLA(dataObject5.getDataObject("entities.0"), string2);
                        dataObject10 = dataObject12.getDataObject("entities.0");
                        this.retainLAProperties(string2, dataObject10);
                        dataObject10.setDataObject("identifier", (DataObject)string10);
                        string = (EChangeSummary)dataObject4.getDataGraph().getChangeSummary();
                        dataObject12.getDataGraph().getChangeSummary().beginLogging();
                        dataObject12.getDataGraph().getChangeSummary().endLogging();
                        this.removePropertyFromChangeSummary(this.getRepositoryPropertyNameSetWithoutLA(string2, dataObject10), (EChangeSummary)string);
                        ((EDataGraph)dataObject12.getDataGraph()).setEChangeSummary((EChangeSummary)string);
                        dataObject6 = reposMgr.getLookasideRepository().update(dataObject12);
                    } else {
                        dataObject5 = reposMgr.getLookasideRepository().update(dataObject4);
                    }
                } else {
                    this.checkAccessibility('u', "UPDATE", string2, string6);
                    dataObject5 = reposMgr.getRepository(string2).update(dataObject4);
                }
                for (String string10 : reposMgr.getRepositoriesForGroupMembership(string2)) {
                    if (string10.equals(string2) || (list6 = (List)hashMap.get(string10)) == null || list6.size() <= 0) continue;
                    DataObject dataObject13 = SDOHelper.createRootDataObject();
                    DataObject dataObject14 = DataGraphHelper.cloneDataObject((DataObject)list5);
                    dataObject14.setList("groups", list6);
                    dataObject13.getList("entities").add(dataObject14);
                    this.checkAccessibility('u', "UPDATE", string10, string6);
                    DataObject dataObject15 = reposMgr.getRepository(string10).update(dataObject13);
                }
            } else {
                for (n = 0; n < list.size(); ++n) {
                    object = DataGraphHelper.cloneDataObject((DataObject)list.get(n));
                    dataObject2 = object.getDataObject("identifier");
                    string = this.retrieveTargetRepository(dataObject2);
                    if (!string2.equalsIgnoreCase(string)) {
                        throw new OperationNotSupportedException("MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "updateImpl");
                    }
                    if (bl) {
                        // empty if block
                    }
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        if (!bl) {
            EChangeSummary eChangeSummary = (EChangeSummary)dataObject4.getDataGraph().getChangeSummary();
            this.setUniqueName(list);
            if (reposMgr.isPropertyJoin() && this.containLAProperties(string2, dataObject10, arrayList)) {
                if (this.containsRepositoryProperties(string2, dataObject10, eChangeSummary)) {
                    this.checkAccessibility('u', "UPDATE", string2, string6);
                    object = DataGraphHelper.deepCloneRootDataObject(dataObject4);
                    this.removeLAProperties(string2, dataObject10, eChangeSummary);
                    dataObject5 = reposMgr.getRepository(string2).update(dataObject4);
                    if (dataObject5.getList("entities").size() == 0) {
                        DataObject dataObject16 = dataObject5.createDataObject("entities", dataObject10.getType().getURI(), string6);
                        dataObject16.setDataObject("identifier", dataObject10.getDataObject("identifier"));
                    }
                    DataObject dataObject17 = this.processIdentifierForLA(dataObject5.getDataObject("entities.0"), string2);
                    dataObject10 = object.getDataObject("entities.0");
                    this.retainLAProperties(string2, dataObject10);
                    dataObject10.setDataObject("identifier", dataObject17);
                    eChangeSummary = (EChangeSummary)object.getDataGraph().getChangeSummary();
                    object.getDataGraph().getChangeSummary().beginLogging();
                    object.getDataGraph().getChangeSummary().endLogging();
                    this.removePropertyFromChangeSummary(this.getRepositoryPropertyNameSetWithoutLA(string2, dataObject10), eChangeSummary);
                    ((EDataGraph)object.getDataGraph()).setEChangeSummary(eChangeSummary);
                    dataObject6 = reposMgr.getLookasideRepository().update((DataObject)object);
                } else {
                    dataObject5 = reposMgr.getLookasideRepository().update(dataObject4);
                }
            } else {
                this.checkAccessibility('u', "UPDATE", string2, string6);
                dataObject5 = reposMgr.getRepository(string2).update(dataObject4);
            }
        }
        if (AsyncUtils.isOperationComplete(dataObject5)) {
            dataObject5 = this.postUpdate(dataObject4, dataObject5, dataObject6, (String)object2, string7);
        }
        if (!trcLogger.isLoggable(Level.FINER)) return dataObject5;
        trcLogger.exiting(CLASSNAME, "updateImpl");
        return dataObject5;
    }

    private DataObject postUpdate(DataObject dataObject, DataObject dataObject2, DataObject dataObject3, String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "postUpdate");
        }
        if (dataObject2 != null) {
            if (reposMgr.isPropertyJoin() && dataObject3 != null) {
                this.mergeLookasideDataObject(dataObject2, dataObject3);
            }
            this.prepareDataGraphForCaller(dataObject2, string, string2, false, null);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "postUpdate", "profile manager -> update() end.");
            }
            this.profileSecManager.setEntitlements(dataObject, dataObject2, new EntitlementRequest(dataObject));
            if (!dataObject2.getDataGraph().getChangeSummary().isLogging()) {
                dataObject2.getDataGraph().getChangeSummary().beginLogging();
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "postUpdate");
        }
        return dataObject2;
    }

    private String getUniqueName(String string, DataObject dataObject, boolean bl, Set set) throws WIMException {
        String string2 = dataObject.getString("uniqueName");
        if (string2 != null) {
            return string2;
        }
        String string3 = dataObject.getString("uniqueId");
        if (reposMgr.isEntryJoin()) {
            try {
                FederationEntity federationEntity = reposMgr.getFederationRepository().lookupByUniqueId(string3);
                if (federationEntity == null) {
                    throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "getUniqueName");
                }
                return federationEntity.getUniqueName();
            }
            catch (WIMException wIMException) {
                if (!bl) {
                    throw wIMException;
                }
                trcLogger.logp(Level.FINER, CLASSNAME, "getUniqueName", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                set.add(reposMgr.getFederationRepositoryID());
            }
        }
        DataObject dataObject2 = schemaMgr.createRootDataObject();
        DataObject dataObject3 = dataObject2.createDataObject("entities");
        DataObject dataObject4 = dataObject3.createDataObject("identifier");
        dataObject4.setString("externalId", string3);
        DataObject dataObject5 = reposMgr.getRepository(string).get(dataObject2);
        List list = dataObject5.getList("entities");
        if (list.size() == 1) {
            DataObject dataObject6 = ((DataObject)list.get(0)).getDataObject("identifier");
            return dataObject6.getString("uniqueName");
        }
        trcLogger.logp(Level.FINER, CLASSNAME, "getUniqueName", "The underline repository [" + string + "] can not retrieve the entity. ");
        throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "getUniqueName");
    }

    public void initialize() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        this.pluginManager = PluginManager.getPluginManager();
        EnvironmentManager.singleton();
        this.configMgr = ConfigManager.singleton();
        DataObject dataObject = this.configMgr.getConfig();
        schemaMgr = SchemaManager.singleton();
        reposMgr = RepositoryManager.singleton();
        this.realmMgr = RealmManager.singleton();
        this.initializeProviderLevelParameters();
        this.initializePropertyCache();
        this.profileSecManager = ProfileSecurityManager.singleton();
        this.profileSecManager.initialize(dataObject.getDataGraph());
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    private void initializeProviderLevelParameters() throws WIMException {
        DataObject dataObject = ConfigManager.singleton().getConfig();
        this.searchTimeOut = dataObject.getInt("searchTimeOut");
        this.pagingEntityObject = dataObject.getBoolean("pagingEntityObject");
        this.pagingCachesDiskOffLoad = dataObject.getBoolean("pagingCachesDiskOffLoad");
        this.maxSearchResults = dataObject.getInt("maxSearchResults");
        dataObject.getInt("maxPagingResults");
        this.maxTotalPagingSearchResults = dataObject.getInt("maxTotalPagingResults");
        this.pagedEntryTimeToLive = dataObject.getInt("pagedCacheTimeOut");
    }

    public void initializePropertyCache() throws WIMException {
        String string;
        int n;
        RepositoryPropertyMap repositoryPropertyMap;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initializePropertyCache");
        }
        String[] stringArray = reposMgr.getRepositoryIds();
        List list = this.configMgr.getSupportedEntityTypes();
        DataObject dataObject = SDOHelper.createRootDataObject();
        DataObject dataObject2 = SDOHelper.createControlDataObject(dataObject, "http://www.ibm.com/websphere/wim", "PropertyDefinitionControl");
        propMgr = PropertyManager.singleton();
        RepositoryPropertyMap repositoryPropertyMap2 = new RepositoryPropertyMap();
        if (list != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                dataObject2.setString("repositoryId", stringArray[i]);
                repositoryPropertyMap = new RepositoryPropertyMap();
                for (n = 0; n < list.size(); ++n) {
                    string = (String)list.get(n);
                    dataObject2.setString("entityTypeName", string);
                    repositoryPropertyMap = this.loadPropertyDefinition(dataObject, string, repositoryPropertyMap, repositoryPropertyMap2);
                }
                propMgr.setPropertyMapByRepository(stringArray[i], repositoryPropertyMap);
            }
        }
        if (reposMgr.isPropertyJoin()) {
            dataObject = SDOHelper.createRootDataObject();
            DataObject dataObject3 = SDOHelper.createControlDataObject(dataObject, "http://www.ibm.com/websphere/wim", "ExtensionPropertyDefinitionControl");
            repositoryPropertyMap = new RepositoryPropertyMap();
            if (list != null) {
                for (n = 0; n < list.size(); ++n) {
                    string = (String)list.get(n);
                    dataObject3.setString("entityTypeName", string);
                    repositoryPropertyMap = this.loadPropertyDefinition(dataObject, string, repositoryPropertyMap, repositoryPropertyMap2);
                }
                propMgr.setLookAsidePropertyNameMap(repositoryPropertyMap);
            }
        }
        propMgr.setReferenceTypePropertyNameMap(repositoryPropertyMap2);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initializePropertyCache");
        }
    }

    private RepositoryPropertyMap loadPropertyDefinition(DataObject dataObject, String string, RepositoryPropertyMap repositoryPropertyMap, RepositoryPropertyMap repositoryPropertyMap2) throws WIMException {
        DataObject dataObject2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "loadPropertyDefinition", WIMTraceHelper.printDataGraph(dataObject));
        }
        if ((dataObject2 = schemaMgr.getSchema(dataObject)) == null) {
            return repositoryPropertyMap;
        }
        DataObject dataObject3 = dataObject2.getDataObject("schema");
        if (dataObject3 != null) {
            List list = dataObject3.getList("propertySchema");
            if (list == null || list.size() == 0) {
                list = dataObject3.getList("extensionPropertySchema");
            }
            if (list != null && list.size() != 0) {
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> hashSet2 = (HashSet<String>)repositoryPropertyMap2.getRepositoryPropertySetByEntityType(string);
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<String>();
                }
                for (int i = 0; i < list.size(); ++i) {
                    DataObject dataObject4 = (DataObject)list.get(i);
                    String string2 = dataObject4.getString("propertyName");
                    String string3 = dataObject4.getString("nsURI");
                    String string4 = null;
                    string4 = schemaMgr.getQualifiedTypeName(string3, string2);
                    hashSet.add(string4);
                    String string5 = dataObject4.getString("dataType");
                    if (string5 == null || !string5.equals("IdentifierType") || string4.equals("identifier")) continue;
                    hashSet2.add(string4);
                }
                if (hashSet.size() > 0) {
                    repositoryPropertyMap.setRepositoryPropertySetByEntityType(string, hashSet);
                }
                if (hashSet2.size() > 0) {
                    repositoryPropertyMap2.setRepositoryPropertySetByEntityType(string, hashSet2);
                }
            }
        }
        return repositoryPropertyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataObject loginImpl(DataObject dataObject) throws WIMException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List list;
        Object object5;
        Object object6;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "loginImpl");
        }
        if (dataObject == null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "loginImpl");
            }
            return null;
        }
        DataObject dataObject2 = null;
        DataObject dataObject3 = dataObject;
        HashMap hashMap = new HashMap();
        WIMException wIMException = null;
        DataObject dataObject4 = null;
        String string = null;
        String string2 = null;
        byte[] byArray = null;
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        if (AsyncUtils.isCheckAsyncOperationStatus(dataObject)) {
            try {
                object6 = AsyncUtils.getRepositoryId(dataObject);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "loginImpl", "calling adapter [" + (String)object6 + "] to check status");
                }
                if ((object5 = (dataObject2 = reposMgr.getRepository((String)object6).login(dataObject)).getList("entities")).size() == 0) {
                    throw new PasswordCheckFailedException("PRINCIPAL_NOT_FOUND", CLASSNAME, "loginImpl");
                }
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "loginImpl", "after calling adapter [" + (String)object6 + "]");
                }
            }
            catch (WIMException wIMException2) {
                wIMException = wIMException2;
                this.recordLoginException(wIMException2, hashMap);
            }
        } else {
            Object object7;
            int n;
            int n2;
            object6 = dataObject3.getList("entities");
            if (object6.size() == 0) {
                throw new EntityNotFoundException("MISSING_ENTITY_DATA_OBJECT", WIMMessageHelper.generateMsgParms(LOGIN_EMITTER), CLASSNAME, "loginImpl");
            }
            if (object6.size() > 1) {
                throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", WIMMessageHelper.generateMsgParms(LOGIN_EMITTER), CLASSNAME, "loginImpl");
            }
            object5 = (DataObject)object6.get(0);
            string2 = object5.getString("principalName");
            byArray = object5.getBytes("password");
            if (!object5.isSet("certificate") && string2 == null) {
                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", CLASSNAME, "loginImpl");
            }
            list = dataObject3.getList("contexts");
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    object4 = (DataObject)list.get(i);
                    String string3 = object4.getString("key");
                    if (string3 == null || !"allowOperationIfReposDown".equals(string3)) continue;
                    bl = (Boolean)object4.get("value");
                }
            }
            if ((dataObject4 = (DataObject)(object3 = ControlsHelper.getControlMap(dataObject.getDataGraph())).get("LoginControl")) == null) {
                dataObject4 = dataObject3.createDataObject("controls", "http://www.ibm.com/websphere/wim", "LoginControl");
            }
            object4 = dataObject4.getList("searchBases");
            int n3 = reposMgr.getNumberOfRepositories();
            object2 = this.getRealmName(dataObject3);
            object = new List[reposMgr.getNumberOfRepositories()];
            for (n2 = 0; n2 < n3; ++n2) {
                object[n2] = new BasicEList();
            }
            object = object4.size() > 0 ? this.divideSearchBases((List)object4, (String)object2, (List[])object) : this.getSearchBasesFromRealm((String)object2, (List[])object);
            n2 = 0;
            int n4 = 0;
            if (object != null) {
                for (n = 0; n < ((Object)object).length; ++n) {
                    object7 = object[n];
                    if (object7 == null || object7.size() <= 0) continue;
                    if (reposMgr.isAsyncModeSupported(n)) {
                        ++n4;
                        continue;
                    }
                    ++n2;
                }
            }
            if (n2 > 0 && n4 > 0 || n4 > 1) {
                throw new OperationNotSupportedException("ASYNC_CALL_WITH_MULTIPLE_REPOSITORIES_NOT_SUPPORTED", CLASSNAME, "loginImpl");
            }
            try {
                for (n = 0; n < n3; ++n) {
                    Object object8;
                    if (object == null || (object7 = object[n]) == null || object7.size() <= 0) continue;
                    try {
                        DataObject dataObject5 = DataGraphHelper.cloneRootDataObject(dataObject);
                        object8 = ControlsHelper.getControlMap(dataObject5.getDataGraph());
                        DataObject dataObject6 = (DataObject)object8.get("LoginControl");
                        dataObject6.setList("searchBases", (List)object7);
                        DataObject dataObject7 = reposMgr.getRepositories()[n].login(dataObject5);
                        if (trcLogger.isLoggable(Level.FINER)) {
                            trcLogger.logp(Level.FINER, CLASSNAME, "loginImpl", "after calling adapter [" + reposMgr.getRepositoryIDByRepositoryIndex(n) + "]");
                        }
                        if (dataObject2 == null) {
                            if (dataObject7.getList("entities").size() <= 0) continue;
                            dataObject2 = dataObject7;
                            string = reposMgr.getRepositoryIDByRepositoryIndex(n);
                            continue;
                        }
                        if (dataObject7.getList("entities").size() <= 0) continue;
                        throw new DuplicateLogonIdException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "loginImpl");
                    }
                    catch (PasswordCheckFailedException passwordCheckFailedException) {
                        object8 = passwordCheckFailedException.getMessageKey();
                        if ("PRINCIPAL_NOT_FOUND".equals(object8)) continue;
                        if ("MISSING_OR_EMPTY_PRINCIPAL_NAME".equals(object8)) {
                            throw passwordCheckFailedException;
                        }
                        if ("MULTIPLE_PRINCIPALS_FOUND".equals(object8)) {
                            throw passwordCheckFailedException;
                        }
                        wIMException = passwordCheckFailedException;
                        this.recordLoginException(passwordCheckFailedException, hashMap);
                        continue;
                    }
                    catch (CertificateMapFailedException certificateMapFailedException) {
                        wIMException = certificateMapFailedException;
                        this.recordLoginException(certificateMapFailedException, hashMap);
                        continue;
                    }
                    catch (CertificateMapNotSupportedException certificateMapNotSupportedException) {
                        wIMException = certificateMapNotSupportedException;
                        this.recordLoginException(certificateMapNotSupportedException, hashMap);
                        continue;
                    }
                    catch (Exception exception) {
                        wIMException = new WIMException(exception);
                        if (exception instanceof DuplicateLogonIdException) {
                            throw (DuplicateLogonIdException)exception;
                        }
                        if (!bl) {
                            throw wIMException;
                        }
                        trcLogger.logp(Level.FINER, CLASSNAME, "loginImpl", "IGNORE: exception [" + wIMException.getMessage() + "] on repository [" + reposMgr.getRepositoryIDByRepositoryIndex(n) + "]");
                        hashSet.add(reposMgr.getRepositoryIDByRepositoryIndex(n));
                    }
                }
            }
            finally {
                PasswordUtil.erasePassword(byArray);
            }
        }
        int n = hashMap.size();
        if (dataObject2 == null) {
            if (n == 0) {
                if (hashMap.containsKey(CertificateMapNotSupportedException.class.getName())) {
                    throw new CertificateMapNotSupportedException("AUTHENTICATE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms("the specified certificate"), CLASSNAME, "loginImpl");
                }
                throw new PasswordCheckFailedException("PRINCIPAL_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "loginImpl");
            }
            if (n == 1) {
                throw wIMException;
            }
            if (n > 1) {
                trcLogger.logp(Level.FINER, CLASSNAME, "loginImpl", "countedException > 1 [" + n + "]");
                throw new DuplicateLogonIdException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "loginImpl");
            }
        } else if (n == 0) {
            trcLogger.logp(Level.FINER, CLASSNAME, "loginImpl", "login successful.");
        } else if (n >= 1) {
            trcLogger.logp(Level.FINER, CLASSNAME, "loginImpl", "result != null && countedException >= 1");
            throw new DuplicateLogonIdException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "loginImpl");
        }
        if (reposMgr.isPropertyJoin() && (object5 = dataObject2.getList("entities")).size() > 0) {
            list = (DataObject)object5.get(0);
            object3 = schemaMgr.getQualifiedTypeName(list.getType());
            object4 = new ArrayList();
            object4.add(object3);
            List list2 = dataObject4.getList("properties");
            if (list2.size() > 0) {
                object2 = this.validateAndDivideReturnProperties((List)object4, list2, string, false);
                object = (List)((HashMap)object2).get(LA);
                try {
                    if (object != null && object.size() > 0) {
                        DataObject dataObject8 = dataObject2.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
                        dataObject8.setList("properties", (List)object);
                        dataObject2 = reposMgr.getLookasideRepository().get(dataObject2);
                    }
                }
                catch (WIMException wIMException3) {
                    if (!bl) {
                        throw wIMException3;
                    }
                    trcLogger.logp(Level.FINER, CLASSNAME, "loginImpl", "IGNORE: exception [" + wIMException3.getMessage() + "] on LA repository ");
                    hashSet.add(reposMgr.getLookasideRepositoryID());
                }
            }
        }
        this.prepareDataGraphForCaller(dataObject2, null, null, bl, hashSet);
        if (bl) {
            object5 = dataObject2.createDataObject("contexts");
            object5.set("key", (Object)"failureRepositoryIDs");
            object5.set("value", hashSet);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "loginImpl");
        }
        return dataObject2;
    }

    private void recordLoginException(WIMException wIMException, Map map) {
        String string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "recordLoginException");
        }
        if (map.containsKey(string = wIMException.getMessageKey())) {
            int n = (Integer)map.get(string) + 1;
            map.put(string, new Integer(n));
        } else {
            map.put(string, new Integer(1));
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "recordLoginException", "record exception [" + string + "]");
            trcLogger.exiting(CLASSNAME, "recordLoginException");
        }
    }

    private List setExtIdAndRepositoryIdForEntities(List list, String string, boolean bl, Set set) throws WIMException {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            FederationEntity federationEntity;
            DataObject dataObject = (DataObject)list.get(i);
            DataObject dataObject2 = dataObject.getDataObject("identifier");
            if (dataObject2 == null) {
                throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", WIMMessageHelper.generateMsgParms(dataObject), Level.WARNING, CLASSNAME, "setExtIdAndRepositoryUUIDForEntities");
            }
            String string2 = dataObject2.getString("uniqueId");
            String string3 = dataObject2.getString("uniqueName");
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (reposMgr.isEntryJoin()) {
                federationEntity = null;
                try {
                    if (string2 != null) {
                        federationEntity = reposMgr.getFederationRepository().lookupByUniqueId(string2);
                    } else if (string3 != null) {
                        federationEntity = reposMgr.getFederationRepository().lookupByUniqueName(string3);
                    }
                }
                catch (WIMException wIMException) {
                    if (!bl) {
                        throw wIMException;
                    }
                    trcLogger.logp(Level.FINER, CLASSNAME, "setExtIdAndRepositoryUUIDForEntities", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                    set.add(reposMgr.getFederationRepositoryID());
                }
                if (federationEntity != null) {
                    string4 = federationEntity.getExternalId();
                    string5 = federationEntity.getRepositoryId();
                    string6 = federationEntity.getUniqueName();
                } else if (reposMgr.getNumberOfRepositories() == 1) {
                    string4 = string2;
                    string5 = reposMgr.getRepositoryIDByRepositoryIndex(0);
                } else {
                    DataObject dataObject3 = this.getIdentifierByUniqueIdOrUniqueName(string2, string3, bl, set);
                    if (dataObject3 != null) {
                        string4 = dataObject3.getString("uniqueId");
                        string5 = dataObject3.getString("repositoryId");
                        string6 = dataObject3.getString("uniqueName");
                    }
                }
            } else if (reposMgr.getNumberOfRepositories() == 1) {
                if (string2 != null) {
                    string4 = string2;
                    string5 = string;
                }
            } else {
                federationEntity = this.getIdentifierByUniqueIdOrUniqueName(string2, string3, bl, set);
                if (federationEntity != null) {
                    string4 = federationEntity.getString("externalId");
                    string5 = federationEntity.getString("repositoryId");
                    string6 = federationEntity.getString("uniqueName");
                }
            }
            if (string4 != null) {
                dataObject2.setString("externalId", string4);
            }
            if (string5 != null) {
                dataObject2.setString("repositoryId", string5);
            }
            if (string6 == null) continue;
            dataObject2.setString("uniqueName", string6);
        }
        return list;
    }

    private List setUniqueName(List list) throws WIMException {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject = (DataObject)list.get(i);
            DataObject dataObject2 = dataObject.getDataObject("identifier");
            if (dataObject2 == null) {
                throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", WIMMessageHelper.generateMsgParms(dataObject), Level.WARNING, CLASSNAME, "setUniqueName");
            }
            String string = dataObject2.getString("uniqueId");
            String string2 = dataObject2.getString("uniqueName");
            if (string2 != null) continue;
            if (string == null) {
                throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", WIMMessageHelper.generateMsgParms(dataObject), Level.WARNING, CLASSNAME, "setUniqueName");
            }
            string2 = this.getUniqueNameByUniqueId(string, false, null);
            if (string2 == null) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "setUniqueName");
            }
            dataObject2.setString("uniqueName", string2);
        }
        return list;
    }

    private List separateGroups(List list, String string) throws WIMException {
        String string2 = "separateGroups";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string2);
        }
        list = this.setExtIdAndRepositoryIdForEntities(list, string, false, null);
        Object object = new BasicEList();
        if (reposMgr.getNumberOfRepositories() > 1 && list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string3;
                DataObject dataObject = (DataObject)list.get(i);
                DataObject dataObject2 = dataObject.getDataObject("identifier");
                if (dataObject2 == null) {
                    throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", WIMMessageHelper.generateMsgParms(dataObject), Level.WARNING, CLASSNAME, string2);
                }
                String string4 = dataObject2.getString("uniqueName");
                if (string4 == null || !(string3 = reposMgr.getRepositoryID(string4)).equals(string)) continue;
                DataObject dataObject3 = DataGraphHelper.cloneDataObject(dataObject);
                object.add(dataObject3);
                list.remove(i);
                --i;
            }
        } else {
            object = DataGraphHelper.cloneList(list);
            if (list != null) {
                list.clear();
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, string2);
        }
        return object;
    }

    private String getUniqueNameByUniqueId(String string, boolean bl, Set set) throws WIMException {
        String string2 = null;
        if (reposMgr.isEntryJoin()) {
            try {
                FederationEntity federationEntity = reposMgr.getFederationRepository().lookupByUniqueId(string);
                if (federationEntity != null) {
                    string2 = federationEntity.getUniqueName();
                    return string2;
                }
            }
            catch (WIMException wIMException) {
                if (!bl) {
                    throw wIMException;
                }
                trcLogger.logp(Level.FINER, CLASSNAME, "getUniqueNameByUniqueId", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                set.add(reposMgr.getFederationRepositoryID());
            }
        }
        boolean bl2 = false;
        int n = 0;
        DataObject dataObject = SDOHelper.createRootDataObject();
        dataObject.createDataObject("entities").createDataObject("identifier").setString("externalId", string);
        while (n < reposMgr.getNumberOfRepositories() && !bl2) {
            try {
                DataObject dataObject2;
                DataObject dataObject3;
                List list;
                DataObject dataObject4 = reposMgr.getRepositories()[n].get(dataObject);
                if (dataObject4 == null || (list = dataObject4.getList("entities")) == null || (dataObject3 = (DataObject)list.get(0)) == null || (dataObject2 = dataObject3.getDataObject("identifier")) == null) continue;
                string2 = dataObject2.getString("uniqueName");
                bl2 = true;
            }
            catch (EntityNotFoundException entityNotFoundException) {
                ++n;
            }
            catch (WIMException wIMException) {
                if (!bl) {
                    throw wIMException;
                }
                trcLogger.logp(Level.FINER, CLASSNAME, "getUniqueNameByUniqueId", "IGNORE: exception [" + wIMException.getMessage() + "] on repository [" + reposMgr.getRepositoryIDByRepositoryIndex(n) + "]");
                set.add(reposMgr.getRepositoryIDByRepositoryIndex(n));
                ++n;
            }
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataObject getIdentifierByUniqueIdOrUniqueName(String string, String string2, boolean bl, Set set) throws WIMException {
        boolean bl2;
        WIMException wIMException;
        DataObject dataObject;
        block8: {
            DataObject dataObject2;
            DataObject dataObject3;
            block7: {
                dataObject = null;
                wIMException = null;
                bl2 = false;
                dataObject3 = SDOHelper.createRootDataObject();
                dataObject2 = dataObject3.createDataObject("entities").createDataObject("identifier");
                if (string2 == null) break block7;
                int n = reposMgr.getRepositoryIndexByUniqueName(string2);
                if (n < 0) {
                    throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "getIdentifierByUniqueIdOrUniqueName");
                }
                dataObject2.setString("uniqueName", string2);
                DataObject dataObject4 = reposMgr.getRepositories()[n].get(dataObject3);
                if (dataObject4 == null) break block8;
                List list = dataObject4.getList("entities");
                if (list == null) throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "getIdentifierByUniqueIdOrUniqueName");
                DataObject dataObject5 = (DataObject)list.get(0);
                if (dataObject5 == null || (dataObject = dataObject5.getDataObject("identifier")) == null) break block8;
                bl2 = true;
                break block8;
            }
            int n = 0;
            while (n < reposMgr.getNumberOfRepositories() && !bl2) {
                dataObject3 = SDOHelper.createRootDataObject();
                dataObject2 = dataObject3.createDataObject("entities").createDataObject("identifier");
                if (string != null) {
                    dataObject2.setString("externalId", string);
                }
                try {
                    DataObject dataObject6;
                    List list;
                    DataObject dataObject7 = reposMgr.getRepositories()[n].get(dataObject3);
                    if (dataObject7 == null || (list = dataObject7.getList("entities")) == null || (dataObject6 = (DataObject)list.get(0)) == null || (dataObject = dataObject6.getDataObject("identifier")) == null) continue;
                    bl2 = true;
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    ++n;
                    wIMException = entityNotFoundException;
                }
                catch (WIMException wIMException2) {
                    if (!bl) {
                        throw wIMException2;
                    }
                    trcLogger.logp(Level.FINER, CLASSNAME, "getIdentifierByUniqueIdOrUniqueName", "IGNORE: exception [" + wIMException2.getMessage() + "] on repository [" + reposMgr.getRepositoryIDByRepositoryIndex(n) + "]");
                    set.add(reposMgr.getRepositoryIDByRepositoryIndex(n));
                    wIMException = wIMException2;
                }
            }
        }
        if (bl2 || wIMException == null) return dataObject;
        throw wIMException;
    }

    private String getRepositoryIdByUniqueId(String string, boolean bl, Set set) throws WIMException {
        String string2 = null;
        if (reposMgr.getNumberOfRepositories() == 1) {
            return reposMgr.getRepositoryIDByRepositoryIndex(0);
        }
        if (reposMgr.isEntryJoin()) {
            try {
                FederationEntity federationEntity = reposMgr.getFederationRepository().get(string);
                if (federationEntity != null) {
                    string2 = federationEntity.getRepositoryId();
                    return string2;
                }
            }
            catch (WIMException wIMException) {
                if (!bl) {
                    throw wIMException;
                }
                trcLogger.logp(Level.FINER, CLASSNAME, "getRepositoryIdByUniqueId", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                set.add(reposMgr.getFederationRepositoryID());
            }
        }
        boolean bl2 = false;
        int n = 0;
        DataObject dataObject = SDOHelper.createRootDataObject();
        dataObject.createDataObject("entities").createDataObject("identifier").setString("externalId", string);
        while (n < reposMgr.getNumberOfRepositories() && !bl2) {
            try {
                DataObject dataObject2;
                DataObject dataObject3;
                List list;
                DataObject dataObject4 = reposMgr.getRepositories()[n].get(dataObject);
                if (dataObject4 == null || (list = dataObject4.getList("entities")) == null || (dataObject3 = (DataObject)list.get(0)) == null || (dataObject2 = dataObject3.getDataObject("identifier")) == null) continue;
                string2 = dataObject2.getString("repositoryId");
                bl2 = true;
            }
            catch (EntityNotFoundException entityNotFoundException) {
                ++n;
            }
            catch (WIMException wIMException) {
                if (!bl) {
                    throw wIMException;
                }
                trcLogger.logp(Level.FINER, CLASSNAME, "getRepositoryIdByUniqueId", "IGNORE: exception [" + wIMException.getMessage() + "] on repository [" + reposMgr.getRepositoryIDByRepositoryIndex(n) + "]");
                set.add(reposMgr.getRepositoryIDByRepositoryIndex(n));
                ++n;
            }
        }
        return string2;
    }

    private List mergeRepositoryEntities(List[] listArray, boolean bl, Set set) throws WIMException {
        BasicEList basicEList = null;
        if (listArray != null && listArray.length > 0) {
            basicEList = new BasicEList();
            for (int i = 0; i < listArray.length; ++i) {
                if (listArray[i] == null) continue;
                if (reposMgr.isEntryJoin()) {
                    try {
                        this.checkAndCreateEntryInFedTable(i, listArray[i]);
                    }
                    catch (WIMException wIMException) {
                        if (!bl) {
                            throw wIMException;
                        }
                        trcLogger.logp(Level.FINER, CLASSNAME, "mergeRepositoryEntities", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                        set.add(reposMgr.getFederationRepositoryID());
                    }
                }
                basicEList.addAll(listArray[i]);
            }
        }
        return basicEList;
    }

    private void checkAndCreateEntryInFedTable(int n, List list) throws WIMException {
        String string;
        String string2;
        DataObject dataObject;
        HashSet<String> hashSet = new HashSet<String>();
        String string3 = reposMgr.getRepositoryIDByRepositoryIndex(n);
        for (int i = 0; list != null && i < list.size(); ++i) {
            DataObject dataObject2 = (DataObject)list.get(i);
            dataObject = dataObject2.getDataObject("identifier");
            if (dataObject == null) continue;
            string2 = dataObject.getString("externalId");
            string = dataObject.getString("repositoryId");
            if (string == null || !string.equals(string3) || string2 == null) continue;
            hashSet.add(string2);
        }
        if (!hashSet.isEmpty()) {
            Map map = reposMgr.getFederationRepository().lookup(string3, hashSet);
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                dataObject = (DataObject)list.get(i);
                string2 = dataObject.getDataObject("identifier");
                string = string2.getString("externalId");
                if (map == null || map.isEmpty() || map.get(string) == null && hashSet.contains(string)) {
                    object = schemaMgr.getQualifiedTypeName(dataObject.getType());
                    String string4 = string2.getString("uniqueName");
                    String string5 = reposMgr.getFederationRepository().create((String)object, string4, string3, string);
                    string2.setString("uniqueId", string5);
                    continue;
                }
                object = (FederationEntity)map.get(string);
                if (object == null) continue;
                string2.setString("uniqueId", ((FederationEntity)object).getUniqueId());
            }
        }
    }

    public String getEntityType(DataObject dataObject) throws WIMException {
        return this.retrieveEntityType(this.retrieveTargetRepository(dataObject), dataObject);
    }

    private String retrieveEntityType(String string, DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "retrieveEntityType", "(" + string + ", " + dataObject + ")");
        }
        DataObject dataObject2 = ProfileManager.retrieveEntity(string, dataObject, false, null);
        String string2 = schemaMgr.getQualifiedTypeName(dataObject2.getType());
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "retrieveEntityType", string2);
        }
        return string2;
    }

    private boolean containToken(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(string2)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private String retrieveTargetRepository(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "retrieveTargetRepository");
        }
        String string = null;
        String string2 = dataObject.getString("uniqueId");
        String string3 = dataObject.getString("uniqueName");
        if (string2 != null && string2.trim().length() != 0) {
            string = dataObject.getString("repositoryId");
            if (string == null) {
                ProfileManager.retrieveEntity(null, dataObject, false, null);
            }
            string = dataObject.getString("repositoryId");
        } else {
            string = reposMgr.getRepositoryID(string3);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "retrieveTargetRepository", string);
        }
        return string;
    }

    private void mergeSchema(DataGraph dataGraph, Map map) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "mergeSchema");
        }
        DataObject dataObject = dataGraph.getRootObject().getDataObject("Root");
        DataObject dataObject2 = dataObject.getDataObject("schema");
        List list = dataObject.getList("propertyDataTypes");
        for (String string : map.keySet()) {
            List list2;
            DataGraph dataGraph2 = (DataGraph)map.get(string);
            if (dataGraph2 == null) continue;
            DataObject dataObject3 = dataGraph2.getRootObject().getDataObject("Root").getDataObject("schema");
            if (dataObject3 != null) {
                list2 = dataObject3.getList("entitySchema");
                List list3 = dataObject3.getList("propertySchema");
                List list4 = dataObject3.getList("extensionPropertySchema");
                if (list2 != null) {
                    dataObject2.getList("entitySchema").addAll(list2);
                }
                if (list3 != null) {
                    dataObject2.getList("propertySchema").addAll(list3);
                }
                if (list4 != null) {
                    dataObject2.getList("extensionPropertySchema").addAll(list4);
                }
            }
            if ((list2 = dataGraph2.getRootObject().getDataObject("Root").getList("propertyDataTypes")) == null) continue;
            list.addAll(list2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "mergeSchema");
        }
    }

    private void prepareDataGraphForCaller(DataObject dataObject, String string, String string2, boolean bl, Set set) throws WIMException {
        List list;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "prepareDataGraphForCaller");
        }
        if (dataObject != null && (list = dataObject.getList("entities")) != null) {
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject2;
                String string3;
                DataObject dataObject3;
                int n;
                Object object;
                DataObject dataObject4 = (DataObject)list.get(i);
                String string4 = schemaMgr.getQualifiedTypeName(dataObject4.getType());
                DataObject dataObject5 = dataObject4.getDataObject("identifier");
                if (dataObject5 != null) {
                    object = dataObject5.getString("repositoryId");
                    this.prepareForCaller(dataObject5, string4, string, string2, bl, set);
                }
                ProfileManager.processReferenceProperty(dataObject4, string4, true, bl, set);
                if (schemaMgr.isSuperType("Group", string4) && (object = dataObject4.getList("members")) != null) {
                    for (n = 0; n < object.size(); ++n) {
                        dataObject3 = (DataObject)object.get(n);
                        string3 = schemaMgr.getQualifiedTypeName(dataObject3.getType());
                        dataObject2 = dataObject3.getDataObject("identifier");
                        this.prepareForCaller(dataObject2, string3, null, null, bl, set);
                        ProfileManager.processReferenceProperty(dataObject3, string3, true, bl, set);
                    }
                }
                if ((object = dataObject4.getList("groups")) == null) continue;
                for (n = 0; n < object.size(); ++n) {
                    dataObject3 = (DataObject)object.get(n);
                    string3 = schemaMgr.getQualifiedTypeName(dataObject3.getType());
                    dataObject2 = dataObject3.getDataObject("identifier");
                    this.prepareForCaller(dataObject2, string3, null, null, bl, set);
                    ProfileManager.processReferenceProperty(dataObject3, string3, true, bl, set);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "prepareDataGraphForCaller");
        }
    }

    private void prepareForCaller(DataObject dataObject, String string, String string2, String string3, boolean bl, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "prepareForCaller");
        }
        if (dataObject != null) {
            block18: {
                String string4 = dataObject.getString("repositoryId");
                String string5 = dataObject.getString("externalId");
                String string6 = dataObject.getString("uniqueName");
                if (reposMgr.isEntryJoin()) {
                    try {
                        FederationEntity federationEntity = null;
                        federationEntity = string2 != null ? reposMgr.getFederationRepository().lookupByUniqueId(string2) : (string3 != null ? reposMgr.getFederationRepository().lookupByUniqueName(string3) : reposMgr.getFederationRepository().lookupByUniqueName(string6));
                        if (federationEntity == null) {
                            if (trcLogger.isLoggable(Level.FINER)) {
                                trcLogger.logp(Level.FINER, CLASSNAME, "prepareForCaller", "not found by uniqueName [" + string6 + "] so search by extID [" + string5 + "]");
                            }
                            if ((federationEntity = reposMgr.getFederationRepository().get(string4, string5)) != null && trcLogger.isLoggable(Level.FINER)) {
                                trcLogger.logp(Level.FINER, CLASSNAME, "prepareForCaller", "found: " + federationEntity);
                            }
                        }
                        if (federationEntity == null) {
                            String string7 = reposMgr.getFederationRepository().create(string, string6, string4, string5);
                            dataObject.setString("uniqueId", string7);
                            break block18;
                        }
                        String string8 = federationEntity.getUniqueId();
                        string6 = federationEntity.getUniqueName();
                        String string9 = federationEntity.getExternalId();
                        String string10 = dataObject.getString("uniqueName");
                        String string11 = dataObject.getString("externalId");
                        if (!string9.equals(string11) && string11 != null) {
                            reposMgr.getFederationRepository().updateExtId(string8, string11);
                            if (trcLogger.isLoggable(Level.FINER)) {
                                trcLogger.logp(Level.FINER, CLASSNAME, "prepareForCaller", "update fedentity [" + string8 + "] with new extId [" + string11 + "], old value [" + string9 + "]");
                            }
                        }
                        if (!(string10 == null || string6 != null && string6.equals(string10))) {
                            reposMgr.getFederationRepository().updateUniqueName(string8, string10);
                            if (trcLogger.isLoggable(Level.FINER)) {
                                trcLogger.logp(Level.FINER, CLASSNAME, "prepareForCaller", "update fedentity [" + string8 + "] with new uName [" + string10 + "], old value [" + string6 + "]");
                            }
                        }
                        dataObject.setString("uniqueId", string8);
                    }
                    catch (WIMException wIMException) {
                        if (!bl) {
                            throw wIMException;
                        }
                        trcLogger.logp(Level.FINER, CLASSNAME, "prepareForCaller", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                        set.add(reposMgr.getFederationRepositoryID());
                    }
                } else {
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "prepareForCaller", "prepare identifier for caller, set [uniqueId=" + string5 + "]");
                    }
                    if (string5 != null) {
                        dataObject.setString("uniqueId", string5);
                    }
                }
            }
            dataObject.unset("externalId");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "prepareForCaller");
        }
    }

    private void groupMembershipLookup(DataObject dataObject, String string, DataObject dataObject2, boolean bl, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "groupMembershipLookup", "repositoryId=" + string);
        }
        int n = dataObject2.getInt("level");
        if (dataObject != null) {
            List list = dataObject.getList("entities");
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Object object2;
                DataObject dataObject3;
                DataObject dataObject4;
                DataObject dataObject5 = (DataObject)list.get(i);
                DataObject dataObject6 = dataObject5.getDataObject("identifier");
                if (dataObject2.getType().getName().equals("GroupMembershipControl")) {
                    for (Object object3 : reposMgr.getRepositoriesForGroupMembership(string)) {
                        if (((String)object3).equals(string)) continue;
                        DataObject dataObject7 = schemaMgr.createRootDataObject();
                        dataObject4 = dataObject7.createDataObject("entities").createDataObject("identifier");
                        dataObject4.setString("uniqueId", dataObject6.getString("uniqueId"));
                        dataObject4.setString("uniqueName", dataObject6.getString("uniqueName"));
                        dataObject4.setString("repositoryId", dataObject6.getString("repositoryId"));
                        dataObject4.setString("externalId", dataObject6.getString("externalId"));
                        dataObject4.setString("externalName", dataObject6.getString("externalName"));
                        dataObject7.getList("controls").add(DataGraphHelper.cloneDataObject(dataObject2));
                        try {
                            dataObject3 = reposMgr.getRepository((String)object3).get(dataObject7);
                            if (dataObject3 == null) continue;
                            object2 = dataObject3.getList("entities");
                            DataObject dataObject8 = (DataObject)object2.get(0);
                            object = dataObject8.getList("groups");
                            dataObject5.getList("groups").addAll(object);
                        }
                        catch (WIMException wIMException) {
                            if (!bl) {
                                throw wIMException;
                            }
                            trcLogger.logp(Level.FINER, CLASSNAME, "groupMembershipLookup", "IGNORE: exception [" + wIMException.getMessage() + "] on repository [" + (String)object3 + "]");
                            set.add(object3);
                        }
                    }
                }
                if (dataObject2.getType().getName().equals("GroupMemberControl")) {
                    Object object3;
                    String string2 = schemaMgr.getQualifiedTypeName(dataObject5.getType());
                    if (!string2.equals("Group") && !schemaMgr.isSuperType("Group", string2) || (object3 = dataObject5.getList("members")) == null || object3.size() <= 0) continue;
                    for (int j = 0; j < object3.size(); ++j) {
                        boolean bl2;
                        dataObject4 = DataGraphHelper.cloneDataObject((DataObject)object3.get(j));
                        dataObject3 = dataObject4.getDataObject("identifier");
                        object2 = dataObject3.getString("repositoryId");
                        if (string.equalsIgnoreCase((String)object2) || !(bl2 = reposMgr.canGroupAcceptMember(string, (String)object2)) || (object = this.getMembersInOtherRepositories(dataObject5, string, bl, set)) == null || object.isEmpty()) continue;
                        Iterator iterator = object.keySet().iterator();
                        while (iterator.hasNext()) {
                            DataObject dataObject9 = schemaMgr.createRootDataObject();
                            object2 = (String)iterator.next();
                            List list2 = (List)object.get(object2);
                            DataObject dataObject10 = schemaMgr.createDataObject("http://www.ibm.com/websphere/wim", "PropertyControl");
                            dataObject10.setList("properties", dataObject2.getList("properties"));
                            if (n != 1) {
                                dataObject9.getList("controls").add(DataGraphHelper.cloneDataObject(dataObject2));
                            }
                            dataObject9.getList("controls").add(dataObject10);
                            dataObject9.getList("entities").addAll(list2);
                            try {
                                DataObject dataObject11 = reposMgr.getRepository((String)object2).get(dataObject9);
                                if (dataObject11 == null) continue;
                                List list3 = dataObject11.getList("entities");
                                for (int k = 0; k < list3.size(); ++k) {
                                    DataObject dataObject12 = (DataObject)list3.get(k);
                                    String string3 = schemaMgr.getQualifiedTypeName(dataObject12.getType());
                                    if (!schemaMgr.isSuperType("Group", string3)) continue;
                                    dataObject5.getList("members").addAll(dataObject12.getList("members"));
                                }
                                dataObject5.getList("members").addAll(list3);
                            }
                            catch (WIMException wIMException) {
                                if (!bl) {
                                    throw wIMException;
                                }
                                trcLogger.logp(Level.FINER, CLASSNAME, "groupMembershipLookup", "IGNORE: exception [" + wIMException.getMessage() + "] on repository [" + (String)object2 + "]");
                                set.add(object2);
                            }
                        }
                    }
                    continue;
                }
                if ("GroupMembershipControl".equals(dataObject2.getType().getName())) continue;
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(dataObject2.getType().getName()), CLASSNAME, "groupMembershipLookup");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "groupMembershipLookup");
        }
    }

    private Map getMembersInOtherRepositories(DataObject dataObject, String string, boolean bl, Set set) throws WIMException {
        HashMap<String, List> hashMap = null;
        List list = null;
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        if (dataObject != null) {
            List list2 = dataObject.getList("members");
            for (int i = 0; i < list2.size(); ++i) {
                String string2;
                DataObject dataObject2 = (DataObject)list2.get(i);
                DataObject dataObject3 = dataObject2.getDataObject("identifier");
                if (dataObject3 == null || (string2 = dataObject3.getString("repositoryId")).equals(string)) continue;
                DataObject dataObject4 = DataGraphHelper.cloneDataObject(dataObject2);
                if (RepositoryManager.singleton().isEntryJoin()) {
                    try {
                        FederationEntity federationEntity = RepositoryManager.singleton().getFederationRepository().get(string2, dataObject3.getString("externalId"));
                        if (federationEntity != null) {
                            dataObject4.getDataObject("identifier").setString("externalId", federationEntity.getExternalId());
                        }
                    }
                    catch (WIMException wIMException) {
                        if (!bl) {
                            throw wIMException;
                        }
                        trcLogger.logp(Level.FINER, CLASSNAME, "getMembersInOtherRepositories", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                        set.add(reposMgr.getFederationRepositoryID());
                    }
                }
                if (hashMap == null) {
                    hashMap = new HashMap<String, List>();
                }
                if ((list = (List)hashMap.get(string2)) == null) {
                    list = new BasicEList();
                }
                list.add(dataObject4);
                hashMap.put(string2, list);
                hashSet.add(dataObject2);
            }
            if (hashMap != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    list2.remove(iterator.next());
                }
            }
        }
        return hashMap;
    }

    private String getRealmName(DataObject dataObject) throws WIMApplicationException {
        String string = null;
        List list = dataObject.getList("contexts");
        if (list == null || list.size() == 0) {
            string = this.realmMgr.getDefaultRealmName();
        } else {
            for (int i = 0; i < list.size() && (string == null || string.length() == 0); ++i) {
                DataObject dataObject2 = (DataObject)list.get(i);
                String string2 = dataObject2.getString("key");
                if (string2 == null || !"realm".equals(string2)) continue;
                string = (String)dataObject2.get("value");
            }
            if (string == null) {
                string = this.realmMgr.getDefaultRealmName();
            }
        }
        return string;
    }

    private List searchRepository(int n, DataObject dataObject, HashMap hashMap, boolean bl, Set set) throws WIMException {
        DataObject dataObject2;
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchRepository", "reposIndex=" + n);
        }
        DataObject dataObject3 = null;
        List list = null;
        List list2 = null;
        List list3 = null;
        if (hashMap != null) {
            list2 = (List)hashMap.get(REPOS);
            list3 = (List)hashMap.get(LA);
            object = ControlsHelper.getControlMap(dataObject);
            dataObject2 = (DataObject)object.get("SearchControl");
            if (list2 != null) {
                dataObject2.setList("properties", list2);
            } else {
                dataObject2.unset("properties");
            }
        }
        try {
            dataObject3 = reposMgr.getRepositories()[n].search(dataObject);
        }
        catch (WIMException wIMException) {
            if (!bl) {
                throw wIMException;
            }
            trcLogger.logp(Level.FINER, CLASSNAME, "searchRepository", "IGNORE: exception [" + wIMException.getMessage() + "] on repository [" + reposMgr.getRepositoryIDByRepositoryIndex(n) + "]");
            set.add(reposMgr.getRepositoryIDByRepositoryIndex(n));
        }
        if (dataObject3 != null) {
            list = dataObject3.getList("entities");
        }
        if (list != null && list.size() > 0 && list3 != null && list3.size() > 0) {
            object = DataGraphHelper.cloneRootDataObject(dataObject3);
            dataObject2 = object.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
            dataObject2.setList("properties", list3);
            dataObject3 = reposMgr.getLookasideRepository().get((DataObject)object);
        }
        object = reposMgr.getRepositoryIDByRepositoryIndex(n);
        if (dataObject3 != null && (list = dataObject3.getList("entities")) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject4 = ((DataObject)list.get(i)).getDataObject("identifier");
                String string = dataObject4.getString("externalId");
                dataObject4.setString("repositoryId", (String)object);
                if (reposMgr.isEntryJoin()) continue;
                dataObject4.setString("uniqueId", string);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            if (list != null) {
                trcLogger.exiting(CLASSNAME, "searchRepository", "returning " + list.size() + " entities");
            } else {
                trcLogger.exiting(CLASSNAME, "searchRepository", "returning null");
            }
        }
        return list;
    }

    private DataObject searchAsyncRepository(String string, DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchAsyncRepository");
        }
        DataObject dataObject2 = reposMgr.getRepository(string).search(dataObject);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "searchAsyncRepository", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    private List searchLA(int n, DataObject dataObject, HashMap hashMap, boolean bl, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchLA", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        List list = null;
        List list2 = null;
        List list3 = null;
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject3 = (DataObject)map.get("SearchControl");
        if (hashMap != null) {
            list3 = (List)hashMap.get(LA);
            list2 = (List)hashMap.get(REPOS);
        }
        if (list3 != null && list3.size() > 0) {
            dataObject3.setList("properties", list3);
        } else {
            dataObject3.unset("properties");
        }
        try {
            dataObject2 = reposMgr.getLookasideRepository().search(dataObject);
        }
        catch (WIMException wIMException) {
            if (!bl) {
                throw wIMException;
            }
            trcLogger.logp(Level.FINER, CLASSNAME, "searchLA", "IGNORE: exception [" + wIMException.getMessage() + "] on LA repository");
            set.add(reposMgr.getLookasideRepositoryID());
        }
        if (dataObject2 != null) {
            DataObject dataObject4 = DataGraphHelper.cloneRootDataObject(dataObject2);
            list = dataObject4.getList("entities");
            DataObject dataObject5 = dataObject4.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
            if (list2 != null) {
                dataObject5.setList("properties", list2);
            } else {
                dataObject5.unset("properties");
            }
            if (list != null && list.size() > 0) {
                List list4 = this.getEntitiesInRepository(list, n);
                if (list4 != null && list4.size() > 0) {
                    dataObject4.setList("entities", list4);
                    DataObject dataObject6 = null;
                    try {
                        dataObject6 = reposMgr.getRepositories()[n].get(dataObject4);
                    }
                    catch (WIMException wIMException) {
                        if (!bl) {
                            throw wIMException;
                        }
                        trcLogger.logp(Level.FINER, CLASSNAME, "searchLA", "IGNORE: exception [" + wIMException.getMessage() + "] on repository [" + reposMgr.getRepositoryIDByRepositoryIndex(n) + "]");
                        set.add(reposMgr.getRepositoryIDByRepositoryIndex(n));
                    }
                    this.mergeLookasideDataObject(dataObject6, dataObject2);
                    if (dataObject6 != null) {
                        list = dataObject6.getList("entities");
                    }
                } else {
                    list.clear();
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "searchLA", WIMTraceHelper.printObjectArray(new Object[]{list}));
        }
        return list;
    }

    private List getEntitiesInRepository(List list, int n) throws WIMException {
        int n2 = reposMgr.getNumberOfRepositories();
        Object object = new BasicEList();
        List list2 = DataGraphHelper.cloneList(list);
        if (n2 == 1) {
            object = list2;
        } else {
            for (int i = 0; i < list2.size(); ++i) {
                int n3;
                String string;
                DataObject dataObject = (DataObject)list2.get(i);
                DataObject dataObject2 = dataObject.getDataObject("identifier");
                if (dataObject2 == null || (string = dataObject2.getString("repositoryId")) == null || (n3 = reposMgr.getRepositoryIndexByRepositoryID(string)) != n) continue;
                object.add(dataObject);
            }
        }
        return object;
    }

    private List splitSearch(int n, List list, XPathNode xPathNode, DataObject dataObject, HashMap hashMap, boolean bl, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "splitSearch");
        }
        List list2 = null;
        short s = xPathNode.getNodeType();
        switch (s) {
            case 8: {
                xPathNode = (XPathNode)((FederationParenthesisNode)xPathNode).getChild();
                list2 = this.splitSearch(n, list, xPathNode, dataObject, hashMap, bl, set);
                break;
            }
            case 4: {
                DataObject dataObject2;
                int n2;
                String string;
                Object object;
                FederationLogicalNode federationLogicalNode = (FederationLogicalNode)xPathNode;
                XPathNode xPathNode2 = (XPathNode)federationLogicalNode.getLeftChild();
                XPathNode xPathNode3 = (XPathNode)federationLogicalNode.getRightChild();
                String string2 = federationLogicalNode.getOperator();
                List list3 = this.splitSearch(n, list, xPathNode2, dataObject, hashMap, bl, set);
                List list4 = this.splitSearch(n, list, xPathNode3, dataObject, hashMap, bl, set);
                if (string2.equals("or")) {
                    list2 = list3;
                    list2.addAll(list4);
                    break;
                }
                ArrayList<String> arrayList = new ArrayList<String>(list3.size());
                ArrayList<Object> arrayList2 = new ArrayList<Object>(list3.size());
                for (int i = 0; i < list3.size(); ++i) {
                    object = (DataObject)list3.get(i);
                    DataObject dataObject3 = object.getDataObject("identifier");
                    if (dataObject3 == null) continue;
                    string = dataObject3.getString("uniqueName");
                    if (string != null) {
                        arrayList.add(string.toLowerCase());
                        continue;
                    }
                    arrayList2.add(object);
                }
                ArrayList<String> arrayList3 = new ArrayList<String>(list4.size());
                object = new ArrayList(list3.size());
                for (n2 = 0; n2 < list4.size(); ++n2) {
                    string = (DataObject)list4.get(n2);
                    dataObject2 = string.getDataObject("identifier");
                    if (dataObject2 == null) continue;
                    String string3 = dataObject2.getString("uniqueName");
                    if (string3 != null) {
                        arrayList3.add(string3.toLowerCase());
                        continue;
                    }
                    object.add(string);
                }
                if (list3.size() < list4.size()) {
                    list2 = DataGraphHelper.cloneList(list3);
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        string = (String)arrayList.get(n2);
                        if (string == null || arrayList3.contains(string)) continue;
                        dataObject2 = (DataObject)list3.get(n2);
                        list2.remove(list3.get(n2));
                    }
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        list2.remove(arrayList2.get(n2));
                    }
                } else {
                    list2 = DataGraphHelper.cloneList(list4);
                    for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                        string = (String)arrayList3.get(n2);
                        if (string == null || arrayList.contains(string)) continue;
                        list2.remove(list4.get(n2));
                    }
                    for (n2 = 0; n2 < object.size(); ++n2) {
                        list2.remove(object.get(n2));
                    }
                }
                break;
            }
            default: {
                dataObject = this.prepareSearchExpression(list, xPathNode, dataObject);
                list2 = this.propertyJoinSearch(n, xPathNode, dataObject, hashMap, bl, set);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "splitSearch", WIMTraceHelper.printObjectArray(new Object[]{list2}));
        }
        return list2;
    }

    private DataObject prepareSearchExpression(List list, XPathNode xPathNode, DataObject dataObject) {
        String string = "@xsi:type='%ENTITYTYPE%'";
        String string2 = "(";
        String string3 = ")";
        String string4 = " and ";
        String string5 = " or ";
        String string6 = "(%SEARCH_STRING%)";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (dataObject != null && xPathNode != null && list != null) {
            String string7;
            if (list.size() == 1) {
                string7 = string.replaceFirst("%ENTITYTYPE%", (String)list.get(0));
                stringBuffer2.append(string7);
            } else if (list.size() > 1) {
                stringBuffer2.append(string2);
                string7 = string.replaceFirst("%ENTITYTYPE%", (String)list.get(0));
                stringBuffer2.append(string7);
                for (int i = 1; i < list.size(); ++i) {
                    stringBuffer2.append(string5);
                    string7 = string.replaceFirst("%ENTITYTYPE%", (String)list.get(i));
                    stringBuffer2.append(string7);
                }
                stringBuffer2.append(string3);
            }
            short s = xPathNode.getNodeType();
            switch (s) {
                case 2: {
                    xPathNode = (XPathNode)((ParenthesisNode)xPathNode).getChild();
                }
            }
            this.nodeToString(stringBuffer3, xPathNode);
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(string4);
            String string8 = string6.replaceFirst("%SEARCH_STRING%", stringBuffer3.toString());
            stringBuffer.append(string8);
            Map map = ControlsHelper.getControlMap(dataObject);
            DataObject dataObject2 = (DataObject)map.get("SearchControl");
            dataObject2.setString("expression", stringBuffer.toString());
        }
        return dataObject;
    }

    private StringBuffer nodeToString(StringBuffer stringBuffer, XPathNode xPathNode) {
        if (xPathNode != null && stringBuffer != null) {
            short s = xPathNode.getNodeType();
            switch (s) {
                case 1: {
                    stringBuffer = this.nodeToString(stringBuffer, (XPathNode)((LogicalNode)xPathNode).getLeftChild());
                    stringBuffer.append(" " + ((LogicalNode)xPathNode).getOperator() + " ");
                    stringBuffer = this.nodeToString(stringBuffer, (XPathNode)((LogicalNode)xPathNode).getRightChild());
                    break;
                }
                case 2: {
                    stringBuffer = this.nodeToString(stringBuffer, (XPathNode)((ParenthesisNode)xPathNode).getChild());
                    break;
                }
                case 0: {
                    stringBuffer.append(xPathNode.toString());
                    break;
                }
            }
        }
        return stringBuffer;
    }

    private List propertyJoinSearch(int n, XPathNode xPathNode, DataObject dataObject, HashMap hashMap, boolean bl, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "propertyJoinSearch");
        }
        List list = null;
        boolean bl2 = true;
        short s = xPathNode.getNodeType();
        switch (s) {
            case 1: {
                bl2 = ((LogicalNode)xPathNode).isPropertyInRepository();
                break;
            }
            case 2: {
                bl2 = ((ParenthesisNode)xPathNode).isPropertyInRepository();
                break;
            }
            case 0: {
                bl2 = ((PropertyNode)xPathNode).isPropertyInRepository();
            }
        }
        list = bl2 ? this.searchRepository(n, dataObject, hashMap, bl, set) : this.searchLA(n, dataObject, hashMap, bl, set);
        return list;
    }

    private HashMap validateAndDivideReturnProperties(List list, List list2, String string, boolean bl) {
        Collection<String> collection;
        Collection collection2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateAndDivideReturnProperties", WIMTraceHelper.printObjectArray(new Object[]{list, list2, string}));
        }
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List list3 = DataGraphHelper.cloneList(list2);
        List list4 = DataGraphHelper.cloneList(list2);
        if (bl) {
            collection2 = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                collection = schemaMgr.getSubEntityTypes((String)list.get(i));
                if (collection == null) continue;
                collection2.addAll(collection);
            }
            list.addAll(collection2);
        }
        collection2 = propMgr.getLookAsidePropertyNameSet(list);
        Set set = propMgr.getRepositoryPropertyNameSet(string, list);
        collection = new ArrayList();
        for (int i = 0; i < list3.size(); ++i) {
            String string2 = (String)list3.get(i);
            if (!set.contains(string2) && !string2.equals("*")) {
                collection.add(string2);
                continue;
            }
            if (!string2.equals("*")) continue;
            list3.clear();
            list3.add("*");
            list4.clear();
            list4.add("*");
            hashMap.put(REPOS, list3);
            hashMap.put(LA, list4);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "validateAndDivideReturnProperties", "propName=*, returnProps=" + hashMap);
            }
            return hashMap;
        }
        list3.removeAll(collection);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list4.size() && collection2 != null; ++i) {
            String string3 = (String)list4.get(i);
            if (collection2.contains(string3)) continue;
            arrayList.add(string3);
        }
        list4.removeAll(arrayList);
        hashMap.put(REPOS, list3);
        hashMap.put(LA, list4);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateAndDivideReturnProperties", hashMap);
        }
        return hashMap;
    }

    private void checkAccessibility(char c, String string, String string2, String string3) throws WIMException {
        switch (c) {
            case 'c': 
            case 'd': 
            case 'u': {
                if (reposMgr.isReadOnly(string2)) {
                    throw new OperationNotSupportedException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "checkAccessibility");
                }
            }
            case 'g': {
                if (!reposMgr.isAccessEnabled(string, string2) || reposMgr.isEntityTypeActionSupported("UPDATE", string3, reposMgr.getRepositoryIndexByRepositoryID(string2))) break;
                throw new OperationNotSupportedException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "checkAccessibility");
            }
        }
    }

    private boolean isAsyncSearch(List[] listArray, StringBuffer stringBuffer) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isAsyncSearch");
        }
        boolean bl = false;
        int n = reposMgr.getNumberOfRepositories();
        for (int i = 0; i < n; ++i) {
            if (listArray != null && (listArray[i] == null || listArray[i].size() <= 0)) continue;
            boolean bl2 = reposMgr.isAsyncModeSupported(i);
            if (bl2 && bl) {
                throw new OperationNotSupportedException("ASYNC_CALL_WITH_MULTIPLE_REPOSITORIES_NOT_SUPPORTED", CLASSNAME, "isAsyncSearch");
            }
            if (bl2) {
                bl = bl2;
                stringBuffer.append(reposMgr.getRepositoryIDByRepositoryIndex(i));
                continue;
            }
            if (!bl) continue;
            throw new OperationNotSupportedException("ASYNC_CALL_WITH_MULTIPLE_REPOSITORIES_NOT_SUPPORTED", CLASSNAME, "isAsyncSearch");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isAsyncSearch");
        }
        return bl;
    }

    private static void processReferenceProperty(DataObject dataObject, String string, boolean bl, boolean bl2, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "processReferenceProperty", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printDataObject(dataObject), string));
        }
        Set set2 = propMgr.getReferencePropertyNameSet(string);
        EDataObject eDataObject = (EDataObject)dataObject;
        if (set2 != null) {
            for (String string2 : set2) {
                List list;
                Property property = schemaMgr.getProperty(string, string2);
                if (property == null || !dataObject.isSet(property)) continue;
                if (property.isMany()) {
                    list = dataObject.getList(property);
                    for (int i = 0; i < list.size(); ++i) {
                        ProfileManager.processIdentifier((DataObject)list.get(i), bl, bl2, set);
                    }
                    continue;
                }
                list = dataObject.getDataObject(property);
                ProfileManager.processIdentifier((DataObject)list, bl, bl2, set);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "processReferenceProperty", WIMTraceHelper.printDataObject(dataObject));
        }
    }

    private static void processIdentifier(DataObject dataObject, boolean bl, boolean bl2, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "processIdentifier", WIMTraceHelper.printDataObject(dataObject));
        }
        String string = dataObject.getString("uniqueName");
        String string2 = dataObject.getString("uniqueId");
        String string3 = dataObject.getString("externalId");
        String string4 = dataObject.getString("repositoryId");
        if (bl) {
            if (reposMgr.isEntryJoin()) {
                try {
                    FederationEntity federationEntity = null;
                    if (string3 != null && string4 != null && (federationEntity = reposMgr.getFederationRepository().get(string4, string3)) != null) {
                        dataObject.setString("uniqueId", federationEntity.getUniqueId());
                    }
                }
                catch (WIMException wIMException) {
                    if (!bl2) {
                        throw wIMException;
                    }
                    trcLogger.logp(Level.FINER, CLASSNAME, "processIdentifier", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                    set.add(reposMgr.getFederationRepositoryID());
                }
            } else if (string3 != null) {
                dataObject.setString("uniqueId", string3);
            }
            dataObject.unset("externalId");
        } else {
            FederationEntity federationEntity = null;
            if (reposMgr.isEntryJoin()) {
                try {
                    if (string2 != null) {
                        federationEntity = reposMgr.getFederationRepository().lookupByUniqueId(string2);
                        if (federationEntity == null) {
                            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "processIdentifier");
                        }
                        dataObject.setString("externalId", federationEntity.getExternalId());
                        dataObject.setString("repositoryId", federationEntity.getRepositoryId());
                        dataObject.setString("uniqueName", federationEntity.getUniqueName());
                    } else if (string != null && (federationEntity = reposMgr.getFederationRepository().lookupByUniqueName(string)) != null) {
                        dataObject.setString("externalId", federationEntity.getExternalId());
                        dataObject.setString("repositoryId", federationEntity.getRepositoryId());
                        dataObject.setString("uniqueName", federationEntity.getUniqueName());
                    }
                }
                catch (WIMException wIMException) {
                    if (!bl2) {
                        throw wIMException;
                    }
                    trcLogger.logp(Level.FINER, CLASSNAME, "processIdentifier", "IGNORE: exception [" + wIMException.getMessage() + "] on FED repository");
                    set.add(reposMgr.getFederationRepositoryID());
                }
            }
            if (federationEntity == null) {
                if (reposMgr.getNumberOfRepositories() == 1 && reposMgr.isEntryJoin()) {
                    if (string2 != null) {
                        dataObject.setString("externalId", string2);
                        dataObject.setString("repositoryId", reposMgr.getRepositoryIds()[0]);
                    }
                } else {
                    ProfileManager.retrieveEntityFromRepository(null, dataObject, bl2, set);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "processIdentifier", WIMTraceHelper.printDataObject(dataObject));
        }
    }

    private List[] divideSearchBases(List list, String string, List[] listArray) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "divideSearchBases", WIMTraceHelper.printObjectArray(new Object[]{list, string, listArray}));
        }
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (string2 == null || !this.realmMgr.isUniqueNameInRealm(string2, string)) continue;
            int n = reposMgr.getRepositoryIndexByUniqueName(string2);
            listArray[n].add(string2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "divideSearchBases", WIMTraceHelper.printObjectArray(new Object[]{listArray}));
        }
        return listArray;
    }

    private List[] getSearchBasesFromRealm(String string, List[] listArray) throws WIMException {
        Map map;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getSearchBasesFromRealm", WIMTraceHelper.printObjectArray(new Object[]{string, listArray}));
        }
        if ((map = this.realmMgr.getRepositoryIndexWithBaseEntriesByRealmName(string)) == null) {
            for (int i = 0; i < reposMgr.getNumberOfRepositories(); ++i) {
                listArray[i].addAll(reposMgr.getRepositoryBaseEntries(reposMgr.getRepositoryIDByRepositoryIndex(i)));
            }
        } else {
            Set set = map.keySet();
            for (Integer n : set) {
                List list = (List)map.get(n);
                listArray[n].addAll(list);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getSearchBasesFromRealm", WIMTraceHelper.printObjectArray(new Object[]{listArray}));
        }
        return listArray;
    }

    private DataObject divideDataObject(DataObject dataObject, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "divideDataObject", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printDataGraph(dataObject), string));
        }
        DataObject dataObject2 = SDOHelper.createRootDataObject();
        List list = dataObject2.getList("entities");
        boolean bl = false;
        List list2 = dataObject.getList("entities");
        DataObject dataObject3 = (DataObject)list2.get(0);
        String string2 = schemaMgr.getQualifiedTypeName(dataObject3.getType());
        DataObject dataObject4 = DataGraphHelper.cloneDataObject(dataObject3);
        Set set = propMgr.getLookAsidePropertyNameSet(string2);
        if (set != null) {
            Property property;
            Set set2 = propMgr.getRepositoryPropertyNameSet(string, string2);
            if (set2 != null) {
                for (String string3 : set2) {
                    property = schemaMgr.getProperty(string2, string3);
                    if (property == null || !dataObject4.isSet(property)) continue;
                    dataObject4.unset(property);
                }
            }
            for (String string3 : set) {
                property = schemaMgr.getProperty(string2, string3);
                if (property == null || !dataObject3.isSet(property) || !dataObject4.isSet(property)) continue;
                bl = true;
                dataObject3.unset(property);
            }
            if (!bl) {
                dataObject2 = null;
            } else {
                list.add(dataObject4);
            }
        } else {
            dataObject2 = null;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            if (dataObject2 != null) {
                trcLogger.exiting(CLASSNAME, "divideDataObject", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printDataGraph(dataObject), WIMTraceHelper.printDataGraph(dataObject2)));
            } else {
                trcLogger.exiting(CLASSNAME, "divideDataObject");
            }
        }
        return dataObject2;
    }

    private void unsetExternalId(DataObject dataObject) {
        List list;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "unsetExternalId");
        }
        if (dataObject != null && (list = dataObject.getList("entities")) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject2 = (DataObject)list.get(i);
                DataObject dataObject3 = dataObject2.getDataObject("identifier");
                if (dataObject3 == null) continue;
                dataObject3.unset("externalId");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "unsetExternalId");
        }
    }
}

