/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.RepositoryPropertyMap;
import com.ibm.ws.wim.SchemaManager;
import commonj.sdo.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class PropertyManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = PropertyManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static PropertyManager singleton = null;
    HashMap propCache = new HashMap();
    RepositoryPropertyMap lookAsidePropNames = new RepositoryPropertyMap();
    RepositoryPropertyMap referenceTypePropNames = new RepositoryPropertyMap();

    public static synchronized PropertyManager singleton() {
        if (singleton == null) {
            singleton = new PropertyManager();
        }
        return singleton;
    }

    private PropertyManager() {
    }

    public void setPropertyMapByRepository(String string, RepositoryPropertyMap repositoryPropertyMap) {
        if (string != null && repositoryPropertyMap != null) {
            this.propCache.put(string, repositoryPropertyMap);
        }
    }

    public RepositoryPropertyMap getPropertyMapByRepositoryId(String string) {
        if (string != null) {
            return (RepositoryPropertyMap)this.propCache.get(string);
        }
        return null;
    }

    public Set getRepositoryPropertyNameSet(String string, String string2) {
        if (string != null && string2 != null) {
            RepositoryPropertyMap repositoryPropertyMap = (RepositoryPropertyMap)this.propCache.get(string);
            if (repositoryPropertyMap != null) {
                return repositoryPropertyMap.getRepositoryPropertySetByEntityType(string2);
            }
            return null;
        }
        return null;
    }

    public Set getRepositoryPropertyNameSet(String string, Type type) throws WIMException {
        if (type != null) {
            String string2 = SchemaManager.singleton().getQualifiedTypeName(type);
            return this.getRepositoryPropertyNameSet(string, string2);
        }
        return null;
    }

    public Set getRepositoryPropertyNameSet(String string, List list) {
        if (string != null) {
            RepositoryPropertyMap repositoryPropertyMap = (RepositoryPropertyMap)this.propCache.get(string);
            return this.getPropertyNameSet(repositoryPropertyMap, list);
        }
        return null;
    }

    public RepositoryPropertyMap getLookAsidePropertyNameMap() {
        return this.lookAsidePropNames;
    }

    public RepositoryPropertyMap getReferenceTypePropertyNameMap() {
        return this.referenceTypePropNames;
    }

    public void setReferenceTypePropertyNameMap(RepositoryPropertyMap repositoryPropertyMap) {
        this.referenceTypePropNames = repositoryPropertyMap;
    }

    public void setLookAsidePropertyNameMap(RepositoryPropertyMap repositoryPropertyMap) {
        this.lookAsidePropNames = repositoryPropertyMap;
    }

    public Set getLookAsidePropertyNameSet(List list) {
        return this.getPropertyNameSet(this.lookAsidePropNames, list);
    }

    public Set getReferenceTypePropertyNameSet(List list) {
        return this.getPropertyNameSet(this.referenceTypePropNames, list);
    }

    private Set getPropertyNameSet(RepositoryPropertyMap repositoryPropertyMap, List list) {
        HashSet hashSet = null;
        if (repositoryPropertyMap != null) {
            HashSet hashSet2 = null;
            if (list == null) {
                hashSet2 = repositoryPropertyMap.getEntityTypes();
            } else {
                hashSet2 = new HashSet();
                for (int i = 0; i < list.size(); ++i) {
                    hashSet2.add(list.get(i));
                }
            }
            if (hashSet2.size() > 0) {
                hashSet = new HashSet();
                for (String string : hashSet2) {
                    Set set;
                    if (repositoryPropertyMap == null || (set = repositoryPropertyMap.getRepositoryPropertySetByEntityType(string)) == null) continue;
                    hashSet.addAll(set);
                }
            }
        }
        return hashSet;
    }

    public Set getLookAsidePropertyNameSet(String string) {
        Set set = null;
        if (this.lookAsidePropNames != null && string != null) {
            set = this.lookAsidePropNames.getRepositoryPropertySetByEntityType(string);
        }
        return set;
    }

    public Set getLookAsidePropertyNameSet(Type type) throws WIMException {
        Set set = null;
        if (type != null) {
            String string = SchemaManager.singleton().getQualifiedTypeName(type);
            set = this.getLookAsidePropertyNameSet(string);
        }
        return set;
    }

    public Set getReferencePropertyNameSet(String string) {
        Set set = null;
        if (this.referenceTypePropNames != null && string != null) {
            set = this.referenceTypePropNames.getRepositoryPropertySetByEntityType(string);
        }
        return set;
    }

    public Set getReferencePropertyNameSet(Type type) throws WIMException {
        Set set = null;
        if (type != null) {
            String string = SchemaManager.singleton().getQualifiedTypeName(type);
            set = this.getReferencePropertyNameSet(string);
        }
        return set;
    }
}

