/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim;

import com.ibm.websphere.wim.ConfigConstants;
import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.InitializationException;
import com.ibm.websphere.wim.exception.InvalidArgumentException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.config.ConfigValidator;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.util.StringUtil;
import com.ibm.ws.wim.util.UniqueNameHelper;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RealmManager
implements ConfigConstants,
DynamicConfigService {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = RealmManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static RealmManager singleton = null;
    private DataObject configProvider = null;
    private String defaultRealmName = null;
    private Map realmReposIndexWithBaseEntries = null;
    private List securityUseActiveRealms = null;
    private Map defaultParentsInRealms = null;
    private Map realmDelimiters = null;
    private Map realmUserRegistryMapping = null;
    private List baseEntries = new ArrayList();
    private Map allowOperationIfReposDownMap = null;
    private Map realmParticipatingBaseEntries = null;

    private RealmManager() throws WIMException {
        this.initialize();
    }

    public static synchronized RealmManager singleton() throws WIMException {
        if (singleton == null) {
            singleton = new RealmManager();
        }
        return singleton;
    }

    private void initialize() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        this.configProvider = ConfigManager.singleton().getConfig();
        DataObject dataObject = this.configProvider.getDataObject("realmConfiguration");
        if (dataObject != null) {
            this.defaultRealmName = dataObject.getString("defaultRealm");
            List[] listArray = RepositoryManager.singleton().getRepositoriesBaseEntries();
            for (int i = 0; i < listArray.length; ++i) {
                this.baseEntries.addAll(listArray[i]);
            }
            List list = dataObject.getList("realms");
            this.securityUseActiveRealms = new ArrayList();
            this.allowOperationIfReposDownMap = new HashMap();
            this.realmDelimiters = new HashMap();
            this.defaultParentsInRealms = new HashMap();
            this.realmReposIndexWithBaseEntries = new HashMap();
            this.realmUserRegistryMapping = new HashMap();
            this.realmParticipatingBaseEntries = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject2 = (DataObject)list.get(i);
                this.processRealm(dataObject2, false);
            }
        } else if (trcLogger.isLoggable(Level.INFO)) {
            trcLogger.logp(Level.INFO, CLASSNAME, "initialize", "MISSING_REALM_CONFIGURATION");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    public String getDefaultRealmName() {
        return this.defaultRealmName;
    }

    public Set getRealmNames() {
        return this.realmDelimiters.keySet();
    }

    public String getDelimiter(String string) throws WIMException {
        String string2;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getDelimiter", "realmName=" + string);
        }
        if ((string2 = (String)this.realmDelimiters.get(string)) == null) {
            throw new InvalidArgumentException("INVALID_REALM_NAME", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getDelimiter");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getDelimiter", "delimiter=" + string2);
        }
        return string2;
    }

    public boolean getAllowOperationIfReposDown(String string) throws WIMException {
        boolean bl = (Boolean)this.allowOperationIfReposDownMap.get(string);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getAllowOperationIfReposDown", "allowOperationIfReposDown=" + bl);
        }
        return bl;
    }

    public List getRealmBaseEntries(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getRealmBaseEntries");
        }
        if (string == null) {
            return new ArrayList();
        }
        List list = (List)this.realmParticipatingBaseEntries.get(string);
        if (list == null) {
            throw new InvalidArgumentException("INVALID_REALM_NAME", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getRealmBaseEntries");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getRealmBaseEntries");
        }
        return list;
    }

    public String getDefaultParentForEntityInRealm(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getDefaultParentForEntityInRealm", "entType=" + string + ", realmName=" + string2);
        }
        String string3 = ConfigManager.singleton().getDefaultParent(string);
        if (string2 != null) {
            Map map;
            this.validateRealmName(string2);
            String string4 = null;
            if (this.defaultParentsInRealms != null && (map = (Map)this.defaultParentsInRealms.get(string2)) != null && (string4 = (String)map.get(string)) != null) {
                string3 = string4;
            }
            if (string4 == null && !this.isUniqueNameInRealm(string3, string2)) {
                string3 = null;
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getDefaultParentForEntityInRealm", "defaultParent=" + string3);
        }
        return string3;
    }

    public boolean isUniqueNameInRealm(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "isUniqueNameInRealm", "uniqueName=" + string + ", realmName=" + string2);
        }
        boolean bl = false;
        if (string2 == null) {
            bl = true;
        } else if (this.realmParticipatingBaseEntries != null) {
            this.validateRealmName(string2);
            if (string != null) {
                string = UniqueNameHelper.getValidUniqueName(string);
                List list = (List)this.realmParticipatingBaseEntries.get(string2);
                if (list != null) {
                    for (int i = 0; i < list.size() && !bl; ++i) {
                        String string3 = (String)list.get(i);
                        if (!StringUtil.endsWithIgnoreCase(string, string3)) continue;
                        bl = true;
                    }
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "isUniqueNameInRealm", "inRealm=" + bl);
        }
        return bl;
    }

    public List getSecurityUseActiveRealms() {
        return this.securityUseActiveRealms;
    }

    public String parseIdDelimiterVirtualRealmName(String string, String string2) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "parseIdDelimiterVirtualRealmName");
        }
        String string3 = (String)this.realmDelimiters.get(string2);
        String string4 = string;
        char c = '\\';
        int n = string.lastIndexOf(string3);
        if (n != -1) {
            if (string.charAt(n - 1) != c) {
                String string5 = string.substring(n + 1, string.length());
                if (string5.equals(string2)) {
                    string4 = this.removeEscapeChar(string.substring(0, n), string3, c);
                }
            } else {
                string4 = this.removeEscapeChar(string, string3, c);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "parseIdDelimiterVirtualRealmName");
        }
        return string4;
    }

    public String getURMapInputPropertyInRealm(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getURMapInputPropertyInRealm", "realmName=" + string + ", urMapInfo" + string2);
        }
        String string3 = null;
        if (this.realmUserRegistryMapping != null) {
            Map map = (Map)this.realmUserRegistryMapping.get(string);
            if (map != null && map.size() != 0) {
                String[] stringArray = (String[])map.get(string2);
                if (stringArray != null) {
                    string3 = stringArray[0];
                }
            } else {
                throw new InvalidArgumentException("INVALID_REALM_NAME", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getURMapInputPropertyInRealm");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getURMapInputPropertyInRealm", "result=" + string3);
        }
        return string3;
    }

    public String getURMapOutputPropertyInRealm(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getURMapOutputPropertyInRealm", "realmName=" + string + ", urMapInfo" + string2);
        }
        String string3 = null;
        if (this.realmUserRegistryMapping != null) {
            Map map = (Map)this.realmUserRegistryMapping.get(string);
            if (map != null && map.size() != 0) {
                String[] stringArray = (String[])map.get(string2);
                if (stringArray != null) {
                    string3 = stringArray[1];
                }
            } else {
                throw new InvalidArgumentException("INVALID_REALM_NAME", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getURMapOutputPropertyInRealm");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getURMapOutputPropertyInRealm", "result=" + string3);
        }
        return string3;
    }

    private String removeEscapeChar(String string, String string2, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.stringCount(string, string2);
        if (n == 0) {
            return string;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = string.indexOf(string2);
            if (string.charAt(n2 - 1) != c) {
                stringBuffer.append(string.substring(0, n2 + 1));
                string = string.substring(n2 + 1);
                continue;
            }
            stringBuffer.append(string.substring(0, n2 - 1));
            stringBuffer.append(string.substring(n2, n2 + 1));
            string = string.substring(n2 + 1);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private int stringCount(String string, String string2) {
        int n = 0;
        if (string != null) {
            int n2 = string.indexOf(string2);
            while (n2 >= 0) {
                ++n;
                n2 = string.indexOf(string2, n2 + 1);
            }
        }
        return n;
    }

    protected Map getRepositoryIndexWithBaseEntriesByRealmName(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getRepositoryIndexWithBaseEntriesByRealmName", "realmName=" + string);
        }
        Map map = null;
        if (this.realmReposIndexWithBaseEntries != null && (map = (Map)this.realmReposIndexWithBaseEntries.get(string)) == null) {
            throw new InvalidArgumentException("INVALID_REALM_NAME", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getRepositoryIndexWithBaseEntriesByRealmName");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getRepositoryIndexWithBaseEntriesByRealmName", "result=" + map);
        }
        return map;
    }

    private Map seperateParticipatingBaseEntriesByReposIndex(List list) throws WIMException {
        HashMap<Integer, ArrayList<String>> hashMap = null;
        if (list != null) {
            hashMap = new HashMap<Integer, ArrayList<String>>();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                int n = RepositoryManager.singleton().getRepositoryIndexByUniqueName(string);
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(new Integer(n));
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
                hashMap.put(new Integer(n), arrayList);
            }
        }
        return hashMap;
    }

    private String[] getUserRegistryMappingInfo(DataObject dataObject) {
        String[] stringArray = new String[]{dataObject.getString("propertyForInput"), dataObject.getString("propertyForOutput")};
        return stringArray;
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "dynamicUpdateConfig", "eventType=" + string);
        }
        if ("websphere.usermanager.serviceprovider.add.realm".equals(string)) {
            DataObject dataObject = (DataObject)hashtable.get("DYNA_CONFIG_KEY_REALM_CONFIG");
            if (dataObject != null) {
                this.processRealm(dataObject, true);
            }
        } else if (("websphere.usermanager.serviceprovider.add.participatingbaseentry".equals(string) || "websphere.usermanager.serviceprovider.add.defaultparenttorealm".equals(string)) && hashtable != null) {
            String string2 = (String)hashtable.get("DYNA_CONFIG_KEY_REALM_NAME");
            if (string2 == null) {
                throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_MISSING_VALUE", WIMMessageHelper.generateMsgParms("DYNA_CONFIG_KEY_REALM_NAME", string), CLASSNAME, "dynamicUpdateConfig");
            }
            this.validateRealmName(string2);
            if ("websphere.usermanager.serviceprovider.add.participatingbaseentry".equals(string)) {
                String string3 = (String)hashtable.get("DYNA_CONFIG_KEY_BASE_ENTRY");
                if (string3 == null) {
                    throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_MISSING_VALUE", WIMMessageHelper.generateMsgParms("DYNA_CONFIG_KEY_REALM_NAME", string), CLASSNAME, "dynamicUpdateConfig");
                }
                if (!ConfigValidator.isBaseEntryInRepository((ConfigurationProviderType)ConfigManager.singleton().getConfig(), string3)) {
                    throw new DynamicUpdateConfigException("BASE_ENTRY_CANNOT_BE_ADDED_TO_REALM", WIMMessageHelper.generateMsgParms(string3, string2), CLASSNAME, "dynamicUpdateConfig");
                }
                ArrayList<String> arrayList = (ArrayList<String>)this.realmParticipatingBaseEntries.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string3);
                this.realmParticipatingBaseEntries.put(string2, arrayList);
                Map map = this.seperateParticipatingBaseEntriesByReposIndex(arrayList);
                if (map != null) {
                    this.realmReposIndexWithBaseEntries.put(string2, map);
                }
            } else if ("websphere.usermanager.serviceprovider.add.defaultparenttorealm".equals(string)) {
                String string4;
                String string5 = (String)hashtable.get("DYNA_CONFIG_KEY_ENTITY_TYPE");
                if (string5 == null) {
                    throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_MISSING_VALUE", WIMMessageHelper.generateMsgParms("DYNA_CONFIG_KEY_ENTITY_TYPE", string), CLASSNAME, "dynamicUpdateConfig");
                }
                Object object = ConfigManager.singleton().getSupportedEntityTypes();
                if (!object.contains(string5)) {
                    throw new DynamicUpdateConfigException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string5), CLASSNAME, "dynamicUpdateConfig");
                }
                object = (Map)this.defaultParentsInRealms.get(string2);
                if (object != null) {
                    if (object.get(string5) != null) {
                        throw new DynamicUpdateConfigException("DEFAULT_PARENT_ALREADY_DEFINED", WIMMessageHelper.generateMsgParms(string5, string2), CLASSNAME, "dynamicUpdateConfig");
                    }
                } else {
                    object = new HashMap<String, String>();
                }
                if ((string4 = (String)hashtable.get("DYNA_CONFIG_KEY_DEFAULT_PARENT")) == null) {
                    throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_MISSING_VALUE", WIMMessageHelper.generateMsgParms("DYNA_CONFIG_KEY_DEFAULT_PARENT", string), CLASSNAME, "dynamicUpdateConfig");
                }
                if (!this.isUniqueNameInRealm(string4, string2)) {
                    throw new DynamicUpdateConfigException("ENTITY_NOT_IN_REALM_SCOPE", WIMMessageHelper.generateMsgParms(string4, string2), CLASSNAME, "dynamicUpdateConfig");
                }
                object.put(string5, string4);
                this.defaultParentsInRealms.put(string2, object);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "dynamicUpdateConfig");
        }
    }

    private void validateRealmName(String string) throws WIMException {
        Set set = this.getRealmNames();
        if (string != null && set != null && !set.contains(string)) {
            throw new InvalidArgumentException("INVALID_REALM_NAME", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "validateRealmName");
        }
    }

    private void processRealm(DataObject dataObject, boolean bl) throws WIMException {
        String string;
        String[] stringArray;
        DataObject dataObject2;
        Object object;
        Object object2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "processRealm", "dynaUpdate=" + bl);
        }
        String string2 = dataObject.getString("name");
        String string3 = dataObject.getString("securityUse");
        if (string3.equalsIgnoreCase("active")) {
            this.securityUseActiveRealms.add(string2);
        }
        String string4 = dataObject.getString("delimiter");
        this.realmDelimiters.put(string2, string4);
        Boolean bl2 = dataObject.getBoolean("allowOperationIfReposDown");
        this.allowOperationIfReposDownMap.put(string2, bl2);
        List list = dataObject.getList("participatingBaseEntries");
        if (list.size() == 0) {
            if (bl) {
                throw new DynamicUpdateConfigException("MISSING_REALM_RELATED_PARAMETER", WIMMessageHelper.generateMsgParms("participatingBaseEntries", string2), CLASSNAME, "processRealm");
            }
            throw new InitializationException("MISSING_REALM_RELATED_PARAMETER", WIMMessageHelper.generateMsgParms("participatingBaseEntries", string2), CLASSNAME, "processRealm");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object2 = (DataObject)list.get(i);
            object = object2.getString("name");
            if (object != null && !RepositoryManager.matchBaseEntryIgnoreCase(this.baseEntries, (String)object)) {
                if (bl) {
                    throw new DynamicUpdateConfigException("INVALID_BASE_ENTRY_NAME", WIMMessageHelper.generateMsgParms(object, "participatingBaseEntries"), CLASSNAME, "processRealm");
                }
                throw new InitializationException("INVALID_BASE_ENTRY_NAME", WIMMessageHelper.generateMsgParms(object, "participatingBaseEntries"), CLASSNAME, "processRealm");
            }
            if (object == null) continue;
            object = UniqueNameHelper.getValidUniqueName((String)object);
            arrayList.add((String)object);
        }
        this.realmParticipatingBaseEntries.put(string2, arrayList);
        Map map = this.seperateParticipatingBaseEntriesByReposIndex(arrayList);
        if (map != null) {
            this.realmReposIndexWithBaseEntries.put(string2, map);
        }
        object2 = new HashMap();
        object = dataObject.getList("defaultParents");
        for (int i = 0; i < object.size(); ++i) {
            dataObject2 = (DataObject)object.get(i);
            stringArray = dataObject2.getString("entityTypeName");
            string = dataObject2.getString("parentUniqueName");
            object2.put(stringArray, string);
        }
        this.defaultParentsInRealms.put(string2, object2);
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        dataObject2 = dataObject.getDataObject("uniqueUserIdMapping");
        this.checkRealmMapping(dataObject2, string2, "uniqueUserIdMapping", bl);
        stringArray = this.getUserRegistryMappingInfo(dataObject2);
        hashMap.put("uniqueUserIdMapping", stringArray);
        string = dataObject.getDataObject("userSecurityNameMapping");
        String[] stringArray2 = this.getUserRegistryMappingInfo((DataObject)string);
        hashMap.put("userSecurityNameMapping", stringArray2);
        DataObject dataObject3 = dataObject.getDataObject("userDisplayNameMapping");
        String[] stringArray3 = this.getUserRegistryMappingInfo(dataObject3);
        hashMap.put("userDisplayNameMapping", stringArray3);
        DataObject dataObject4 = dataObject.getDataObject("uniqueGroupIdMapping");
        String[] stringArray4 = this.getUserRegistryMappingInfo(dataObject4);
        hashMap.put("uniqueGroupIdMapping", stringArray4);
        DataObject dataObject5 = dataObject.getDataObject("groupSecurityNameMapping");
        String[] stringArray5 = this.getUserRegistryMappingInfo(dataObject5);
        hashMap.put("groupSecurityNameMapping", stringArray5);
        DataObject dataObject6 = dataObject.getDataObject("groupDisplayNameMapping");
        String[] stringArray6 = this.getUserRegistryMappingInfo(dataObject6);
        hashMap.put("groupDisplayNameMapping", stringArray6);
        this.realmUserRegistryMapping.put(string2, hashMap);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "processRealm");
        }
    }

    private void checkRealmMapping(DataObject dataObject, String string, String string2, boolean bl) throws WIMException {
        if (dataObject == null) {
            if (bl) {
                throw new DynamicUpdateConfigException("MISSING_REALM_RELATED_PARAMETER", WIMMessageHelper.generateMsgParms(string2, string), CLASSNAME, "checkRealmMapping");
            }
            throw new InitializationException("MISSING_REALM_RELATED_PARAMETER", WIMMessageHelper.generateMsgParms(string2, string), CLASSNAME, "checkRealmMapping");
        }
    }
}

