/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim;

import com.ibm.websphere.wim.ConfigConstants;
import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.InvalidRepositoryIdException;
import com.ibm.websphere.wim.exception.InvalidUniqueNameException;
import com.ibm.websphere.wim.exception.MissingInitPropertyException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.federation.FederationRepository;
import com.ibm.ws.wim.lookaside.LookasideRepository;
import com.ibm.ws.wim.util.StringUtil;
import com.ibm.ws.wim.util.UniqueNameHelper;
import com.ibm.wsspi.wim.Repository;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepositoryManager
implements DynamicConfigService,
ConfigConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = RepositoryManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static RepositoryManager singleton = null;
    private FederationRepository fedRepos = null;
    private Set dbReposIds = null;
    private LookasideRepository laRepos = null;
    private Repository[] repositories = null;
    private DataObject[] reposConfigs = null;
    private String[] reposIds = null;
    private String[] reposTypes = null;
    private List[] reposNodes = null;
    private boolean entryJoin = false;
    private boolean propertyJoin = false;
    private int numOfRepos;
    private Map[] actionNotSupport = null;
    private boolean[] isGenerateUniqueId = null;
    private boolean[] isSortingSupported = null;
    private boolean[] isAsyncModeSupported = null;
    private boolean[] readOnlyFlags = null;
    private Map repositoriesForGroupMembers = null;
    private Set[] repositoriesForGroup = null;
    public static final String ACTION_READ = "READ";
    public static final String ACTION_CREATE = "CREATE";
    public static final String ACTION_UPDATE = "UPDATE";
    public static final String ACTION_DELETE = "DELETE";
    public static final String DB_ADAPTER_CLASS = "com.ibm.ws.wim.adapter.db.DBAdapter";
    public static final String FILE_ADAPTER_CLASS = "com.ibm.ws.wim.adapter.file.was.FileAdapter";
    public static final String LDAP_ADAPTER_CLASS = "com.ibm.ws.wim.adapter.ldap.LdapAdapter";
    public static final String LA_ADAPTER_CLASS = "com.ibm.ws.wim.lookaside.LookasideAdapter";
    public static final String FED_ADAPTER_CLASS = "com.ibm.ws.wim.federation.FederationAdapter";
    private static final String FED_ID = "FED";
    private static final String LA_ID = "LA";

    private RepositoryManager() throws WIMException {
        this.initialize();
    }

    public static synchronized RepositoryManager singleton() throws WIMException {
        if (singleton == null) {
            singleton = new RepositoryManager();
        }
        return singleton;
    }

    public LookasideRepository getLookasideRepository() {
        return this.laRepos;
    }

    public FederationRepository getFederationRepository() {
        return this.fedRepos;
    }

    public Repository[] getRepositories() {
        return this.repositories;
    }

    public Repository getRepository(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getRepository", "reposId=" + string);
        }
        int n = this.getRepositoryIndexByRepositoryID(string);
        Repository repository2 = null;
        if (n != -1) {
            repository2 = this.repositories[n];
        }
        if (repository2 == null) {
            throw new InvalidRepositoryIdException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getRepository");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getRepository");
        }
        return repository2;
    }

    public Repository getTargetRepository(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getTargetRepository", "uniqueName=" + string);
        }
        int n = this.getRepositoryIndexByUniqueName(string);
        Repository repository2 = null;
        if (n != -1) {
            repository2 = this.repositories[n];
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getTargetRepository");
        }
        return repository2;
    }

    public String getLookasideRepositoryID() {
        return LA_ID;
    }

    public String getFederationRepositoryID() {
        return FED_ID;
    }

    public String getRepositoryID(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getRepositoryID", "uniqueName=" + string);
        }
        int n = this.getRepositoryIndexByUniqueName(string);
        String string2 = null;
        if (n != -1) {
            string2 = this.reposIds[n];
        }
        if (string2 == null) {
            throw new InvalidUniqueNameException("ENTITY_NOT_IN_REALM_SCOPE", WIMMessageHelper.generateMsgParms(string, "defined in WIM"), CLASSNAME, "getRepositoryID");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getRepositoryID");
        }
        return string2;
    }

    protected int getRepositoryIndexByUniqueName(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getRepositoryIndexByUniqueName", "uniqueName=" + string);
        }
        int n = -1;
        string = UniqueNameHelper.getValidUniqueName(string).trim();
        int n2 = string.length();
        block0: for (int i = 0; i < this.reposNodes.length; ++i) {
            List list = this.reposNodes[i];
            for (int j = 0; j < list.size(); ++j) {
                String string2 = (String)list.get(j);
                int n3 = string2.length();
                if (n3 == 0) {
                    n = i;
                    break block0;
                }
                if (n2 == n3 && string.equalsIgnoreCase(string2)) {
                    n = i;
                    break block0;
                }
                if (n2 <= n3 || !StringUtil.endsWithIgnoreCase(string, "," + string2)) continue;
                n = i;
                break block0;
            }
        }
        if (n == -1) {
            throw new InvalidUniqueNameException("ENTITY_NOT_IN_REALM_SCOPE", WIMMessageHelper.generateMsgParms(string, "defined"), CLASSNAME, "getRepositoryIndexByUniqueName");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getRepositoryIndexByUniqueName", "reposIndex=" + n);
        }
        return n;
    }

    public List[] getRepositoriesBaseEntries() {
        return this.reposNodes;
    }

    public List getRepositoryBaseEntries(String string) throws WIMException {
        int n = this.getRepositoryIndexByRepositoryID(string);
        List list = null;
        if (n != -1) {
            list = this.reposNodes[n];
        }
        return list;
    }

    public DataObject getRepositoryConfig(String string) throws WIMException {
        int n = this.getRepositoryIndexByRepositoryID(string);
        DataObject dataObject = null;
        if (n != -1) {
            dataObject = this.reposConfigs[n];
        }
        return dataObject;
    }

    public String[] getRepositoryIds() {
        return this.reposIds;
    }

    protected int getRepositoryIndexByRepositoryID(String string) throws WIMException {
        if (string == null) {
            throw new InvalidRepositoryIdException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateNullMsgParms(), CLASSNAME, "getRepositoryIndexByRepositoryID");
        }
        int n = -1;
        for (int i = 0; i < this.reposIds.length; ++i) {
            if (!string.equalsIgnoreCase(this.reposIds[i])) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new InvalidRepositoryIdException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getRepositoryIndexByRepositoryID");
        }
        return n;
    }

    public int getNumberOfRepositories() {
        return this.numOfRepos;
    }

    public boolean isEntryJoin() {
        return this.entryJoin;
    }

    public boolean isPropertyJoin() {
        return this.propertyJoin;
    }

    private Class loadAdapterClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        trcLogger.entering(CLASSNAME, "loadAdapterClass");
        try {
            clazz = Class.forName(string);
            trcLogger.log(Level.FINEST, "Successfully loaded class " + string + " with default class loader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            clazz = Class.forName(string, true, classLoader);
            trcLogger.log(Level.FINEST, "Successfully loaded class " + string + " with context class loader");
        }
        trcLogger.exiting(CLASSNAME, "loadAdapterClass");
        return clazz;
    }

    private void initialize() throws WIMException {
        Object object;
        Object object2;
        DataObject dataObject;
        DataObject dataObject2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        if ((dataObject2 = (dataObject = ConfigManager.singleton().getConfig()).getDataObject("entryMappingRepository")) != null) {
            this.entryJoin = true;
            object2 = dataObject2.getString("adapterClassName");
            if (object2 == null || ((String)object2).length() == 0) {
                object2 = FED_ADAPTER_CLASS;
            }
            try {
                object = this.loadAdapterClass((String)object2);
                this.fedRepos = (FederationRepository)((Class)object).newInstance();
                this.fedRepos.initialize(dataObject2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(FED_ID, classNotFoundException.getMessage()), CLASSNAME, "initialize", (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(FED_ID, instantiationException.getMessage()), CLASSNAME, "initialize", (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(FED_ID, illegalAccessException.getMessage()), CLASSNAME, "initialize", (Throwable)illegalAccessException);
            }
        }
        if ((object2 = dataObject.getDataObject("propertyExtensionRepository")) != null) {
            this.propertyJoin = true;
            object = object2.getString("adapterClassName");
            if (object == null || ((String)object).length() == 0) {
                object = LA_ADAPTER_CLASS;
            }
            try {
                Class clazz = this.loadAdapterClass((String)object);
                this.laRepos = (LookasideRepository)clazz.newInstance();
                this.laRepos.initialize((DataObject)object2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(LA_ID, classNotFoundException.getMessage()), CLASSNAME, "initialize", (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(LA_ID, instantiationException.getMessage()), CLASSNAME, "initialize", (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(LA_ID, illegalAccessException.getMessage()), CLASSNAME, "initialize", (Throwable)illegalAccessException);
            }
        }
        object = dataObject.getList("repositories");
        this.numOfRepos = object.size();
        this.reposNodes = new List[this.numOfRepos];
        this.repositories = new Repository[this.numOfRepos];
        this.reposConfigs = new DataObject[this.numOfRepos];
        this.reposIds = new String[this.numOfRepos];
        this.reposTypes = new String[this.numOfRepos];
        this.actionNotSupport = new HashMap[this.numOfRepos];
        this.isGenerateUniqueId = new boolean[this.numOfRepos];
        this.isSortingSupported = new boolean[this.numOfRepos];
        this.isAsyncModeSupported = new boolean[this.numOfRepos];
        this.repositoriesForGroup = new Set[this.numOfRepos];
        this.readOnlyFlags = new boolean[this.numOfRepos];
        for (int i = 0; i < object.size(); ++i) {
            List list;
            List list2;
            List list3;
            Collection collection;
            String string;
            Object object3;
            DataObject dataObject3;
            this.reposConfigs[i] = dataObject3 = (DataObject)object.get(i);
            this.reposIds[i] = dataObject3.getString("id");
            List list4 = dataObject3.getList("baseEntries");
            this.reposNodes[i] = new ArrayList(list4.size());
            for (int j = 0; j < list4.size(); ++j) {
                object3 = (DataObject)list4.get(j);
                string = object3.getString("name");
                string = UniqueNameHelper.getValidUniqueName(string);
                this.reposNodes[i].add(string.trim());
            }
            List list5 = dataObject3.getList("repositoriesForGroups");
            this.repositoriesForGroup[i] = new HashSet();
            if (list5 != null && list5.size() > 0) {
                if (this.repositoriesForGroupMembers == null) {
                    this.repositoriesForGroupMembers = new HashMap();
                }
                for (int j = 0; j < list5.size(); ++j) {
                    string = ((String)list5.get(j)).trim();
                    this.repositoriesForGroup[i].add(string);
                    collection = (Set)this.repositoriesForGroupMembers.get(string);
                    if (collection == null) {
                        collection = new HashSet<String>();
                    }
                    collection.add(this.reposIds[i]);
                    this.repositoriesForGroupMembers.put(string, collection);
                }
            }
            object3 = dataObject3.getType().getName();
            this.reposTypes[i] = object3;
            string = dataObject3.getString("adapterClassName");
            if (string == null) {
                if (((String)object3).equals("DatabaseRepositoryType")) {
                    string = DB_ADAPTER_CLASS;
                } else if (((String)object3).equals("FileRepositoryType")) {
                    string = FILE_ADAPTER_CLASS;
                } else if (((String)object3).equals("LdapRepositoryType")) {
                    string = LDAP_ADAPTER_CLASS;
                } else {
                    throw new MissingInitPropertyException("MISSING_INI_PROPERTY", WIMMessageHelper.generateMsgParms("adapterClassName"), CLASSNAME, "initialize");
                }
            }
            try {
                collection = this.loadAdapterClass(string);
                this.repositories[i] = (Repository)((Class)((Object)collection)).newInstance();
                this.repositories[i].initialize(dataObject3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(this.reposIds[i], classNotFoundException.getMessage()), CLASSNAME, "initialize", (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(this.reposIds[i], instantiationException.getMessage()), CLASSNAME, "initialize", (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(this.reposIds[i], illegalAccessException.getMessage()), CLASSNAME, "initialize", (Throwable)illegalAccessException);
            }
            if (((String)object3).equals("DatabaseRepositoryType") || ((String)object3).equals("ProfileRepositoryType")) {
                if (this.dbReposIds == null) {
                    this.dbReposIds = new HashSet();
                }
                this.dbReposIds.add(dataObject3.getString("id"));
            }
            this.actionNotSupport[i] = new HashMap();
            collection = dataObject3.getList("EntityTypesNotAllowCreate");
            if (collection != null && collection.size() != 0) {
                this.actionNotSupport[i].put(ACTION_CREATE, collection);
            }
            if ((list3 = dataObject3.getList("EntityTypesNotAllowRead")) != null && list3.size() != 0) {
                this.actionNotSupport[i].put(ACTION_READ, list3);
            }
            if ((list2 = dataObject3.getList("EntityTypesNotAllowUpdate")) != null && list2.size() != 0) {
                this.actionNotSupport[i].put(ACTION_UPDATE, list2);
            }
            if ((list = dataObject3.getList("EntityTypesNotAllowDelete")) != null && list.size() != 0) {
                this.actionNotSupport[i].put(ACTION_DELETE, list);
            }
            this.isGenerateUniqueId[i] = !dataObject3.getBoolean("isExtIdUnique");
            this.isSortingSupported[i] = dataObject3.getBoolean("supportSorting");
            this.isAsyncModeSupported[i] = dataObject3.getBoolean("supportAsyncMode");
            this.readOnlyFlags[i] = dataObject3.getBoolean("readOnly");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    public boolean isAsyncModeSupported(String string) throws WIMException {
        return this.isAsyncModeSupported(this.getRepositoryIndexByRepositoryID(string));
    }

    public boolean isAsyncModeSupported(int n) {
        return this.isAsyncModeSupported[n];
    }

    public boolean isEntityTypeActionSupported(String string, String string2, String string3) throws WIMException {
        int n = this.getRepositoryIndexByRepositoryID(string3);
        return this.isEntityTypeActionSupported(string, string2, n);
    }

    public boolean isEntityTypeActionSupported(String string, String string2, int n) {
        Map map = this.actionNotSupport[n];
        if (map == null || map.size() == 0) {
            return true;
        }
        List list = (List)map.get(string);
        if (list == null || list.size() == 0) {
            return true;
        }
        return !list.contains(string2);
    }

    public boolean isGenerateUniqueId(String string) throws WIMException {
        int n = this.getRepositoryIndexByRepositoryID(string);
        return this.isGenerateUniqueId[n];
    }

    public boolean isReadOnly(int n) {
        return this.readOnlyFlags[n];
    }

    public boolean isReadOnly(String string) throws WIMException {
        return this.readOnlyFlags[this.getRepositoryIndexByRepositoryID(string)];
    }

    public boolean isSortingSupported(int n) {
        return this.isSortingSupported[n];
    }

    public String getRepositoryIDByRepositoryIndex(int n) {
        return this.reposIds[n];
    }

    public String getRepositoryTypeByRepositoryIndex(int n) {
        return this.reposTypes[n];
    }

    public boolean isAccessEnabled(String string, String string2) throws WIMException {
        int n = this.getRepositoryIndexByRepositoryID(string2);
        Map map = this.actionNotSupport[n];
        if (map == null || map.size() == 0) {
            return false;
        }
        return map.containsKey(string);
    }

    public boolean isDBRepository(String string) {
        if (this.dbReposIds != null) {
            return this.dbReposIds.contains(string);
        }
        return false;
    }

    public boolean isEntityInDBRepository(String string) throws WIMException {
        if (this.dbReposIds != null) {
            return this.dbReposIds.contains(this.getRepositoryID(string));
        }
        return false;
    }

    public boolean isCrossRepositoryGroupMembership(String string) throws WIMException {
        String string2;
        int n = this.getRepositoryIndexByRepositoryID(string);
        int n2 = this.repositoriesForGroup[n].size();
        if (n2 > 1) {
            return true;
        }
        return n2 == 1 && !string.equals(string2 = (String)this.repositoriesForGroup[n].iterator().next());
    }

    public Set getRepositoriesForGroupMembership(String string) throws WIMException {
        int n = this.getRepositoryIndexByRepositoryID(string);
        return this.repositoriesForGroup[n];
    }

    public boolean canGroupAcceptMember(String string, String string2) {
        Set set;
        if (this.repositoriesForGroupMembers != null && (set = (Set)this.repositoriesForGroupMembers.get(string)) != null) {
            return set.contains(string2);
        }
        return false;
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "dynamicUpdateConfig", "updateEvent=" + string);
        }
        if ("websphere.usermanager.serviceprovider.update.ldap.bindinfo".equalsIgnoreCase(string)) {
            int n;
            Repository repository2;
            DataObject dataObject;
            String string2 = (String)hashtable.get("DYNA_CONFIG_KEY_REPOS_ID");
            if (string2 == null) {
                throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_MISSING_VALUE", WIMMessageHelper.generateMsgParms("DYNA_CONFIG_KEY_REPOS_ID", "websphere.usermanager.serviceprovider.update.ldap.bindinfo"), CLASSNAME, "dynamicUpdateConfig");
            }
            String string3 = (String)hashtable.get("DYNA_CONFIG_KEY_LDAP_BIND_DN");
            byte[] byArray = (byte[])hashtable.get("DYNA_CONFIG_KEY_LDAP_BIND_PASSWORD");
            if (string3 != null && byArray == null) {
                throw new DynamicUpdateConfigException("DYNA_UPDATE_CONFIG_MISSING_VALUE", WIMMessageHelper.generateMsgParms("DYNA_CONFIG_KEY_LDAP_BIND_PASSWORD", "websphere.usermanager.serviceprovider.update.ldap.bindinfo"), CLASSNAME, "dynamicUpdateConfig");
            }
            if (string3 == null && byArray == null) {
                DataGraph dataGraph = ConfigManager.singleton().loadConfigFromXML(ConfigManager.singleton().getWIMConfigXMLFilePath());
                dataObject = dataGraph.getRootObject().getDataObject("configurationProvider");
                repository2 = dataObject.getDataObject("repositories[id=" + string2 + "]");
                if (repository2 == null) {
                    throw new InvalidRepositoryIdException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "dynamicUpdateConfig");
                }
                hashtable.put("DYNA_CONFIG_KEY_REPOS_CONFIG", repository2);
            }
            if (!"LdapRepositoryType".equals((dataObject = this.reposConfigs[n = this.getRepositoryIndexByRepositoryID(string2)]).getType().getName())) {
                throw new DynamicUpdateConfigException("NOT_LDAP_REPOSITORY", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "dynamicUpdateConfig");
            }
            repository2 = this.repositories[n];
            try {
                ((DynamicConfigService)((Object)repository2)).dynamicUpdateConfig(string, hashtable);
            }
            catch (RemoteException remoteException) {
                throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(remoteException.getMessage()), CLASSNAME, "dynamicUpdateConfig", (Throwable)remoteException);
            }
        }
        if ("websphere.usermanager.serviceprovider.add.entityconfig".equalsIgnoreCase(string)) {
            Hashtable hashtable2 = (Hashtable)hashtable.get("DYNA_CONFIG_KEY_ENTITY_CONFIGS");
            if (hashtable2 != null) {
                Set set = hashtable2.keySet();
                for (String string4 : set) {
                    int n = this.getRepositoryIndexByRepositoryID(string4);
                    DataObject dataObject = this.reposConfigs[n];
                    if (!"LdapRepositoryType".equals(dataObject.getType().getName())) {
                        throw new DynamicUpdateConfigException("NOT_LDAP_REPOSITORY", WIMMessageHelper.generateMsgParms(string4), CLASSNAME, "dynamicUpdateConfig");
                    }
                    Repository repository3 = this.repositories[n];
                    try {
                        ((DynamicConfigService)((Object)repository3)).dynamicUpdateConfig(string, hashtable);
                    }
                    catch (RemoteException remoteException) {
                        throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(remoteException.getMessage()), CLASSNAME, "dynamicUpdateConfig", (Throwable)remoteException);
                    }
                }
            }
        } else {
            if ("websphere.usermanager.serviceprovider.add.propertyconfig".equalsIgnoreCase(string)) {
                String string5 = (String)hashtable.get("DYNA_CONFIG_KEY_REPOS_ID");
                int n = this.getRepositoryIndexByRepositoryID(string5);
                try {
                    ((DynamicConfigService)((Object)this.repositories[n])).dynamicUpdateConfig(string, hashtable);
                }
                catch (RemoteException remoteException) {
                    throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(remoteException.getMessage()), CLASSNAME, "dynamicUpdateConfig", (Throwable)remoteException);
                }
            }
            if (string.equals("websphere.usermanager.serviceprovider.add.baseentry")) {
                String string6 = (String)hashtable.get("DYNA_CONFIG_KEY_BASE_ENTRY");
                String string7 = (String)hashtable.get("DYNA_CONFIG_KEY_REPOS_ID");
                if (string7 != null && string7.trim().length() != 0 && string6 != null && string6.trim().length() != 0) {
                    int n = this.getRepositoryIndexByRepositoryID(string7);
                    List list = this.reposNodes[n];
                    boolean bl = RepositoryManager.matchBaseEntryIgnoreCase(list, string6);
                    if (bl) {
                        throw new DynamicUpdateConfigException("BASE_ENTRY_ALREADY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string6, string7), Level.SEVERE, CLASSNAME, "dynamicUpdateConfig");
                    }
                    try {
                        ((DynamicConfigService)((Object)this.repositories[n])).dynamicUpdateConfig(string, hashtable);
                    }
                    catch (RemoteException remoteException) {
                        throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(remoteException.getMessage()), CLASSNAME, "dynamicUpdateConfig", (Throwable)remoteException);
                    }
                    list.add(string6);
                    this.reposNodes[n] = list;
                }
            } else if (string.equals("websphere.usermanager.serviceprovider.add.repository")) {
                DataObject dataObject = (DataObject)hashtable.get("DYNA_CONFIG_KEY_REPOS_CONFIG");
                this.addNewRepository(dataObject);
            } else if (string.equals("websphere.usermanager.serviceprovider.add.propertyextensionrepository")) {
                if (this.propertyJoin) {
                    throw new DynamicUpdateConfigException("PROPERTY_EXTENSION_REPOSITORY_ALREADY_DEFINED", CLASSNAME, "dynamicUpdateConfig");
                }
                DataObject dataObject = (DataObject)hashtable.get("DYNA_CONFIG_KEY_PROP_EXT_REPOS_CONFIG");
                if (dataObject != null) {
                    String string8 = dataObject.getString("adapterClassName");
                    if (string8 == null || string8.length() == 0) {
                        string8 = LA_ADAPTER_CLASS;
                    }
                    try {
                        Class clazz = this.loadAdapterClass(string8);
                        this.laRepos = (LookasideRepository)clazz.newInstance();
                        this.laRepos.initialize(dataObject);
                    }
                    catch (Exception exception) {
                        throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms("propertyExtensionRepository", exception.getMessage()), CLASSNAME, "dynamicUpdateConfig");
                    }
                    this.propertyJoin = true;
                }
            } else if (string.equals("websphere.usermanager.serviceprovider.update.db.adminidpassword")) {
                String string9 = (String)hashtable.get("DYNA_CONFIG_KEY_REPOS_ID");
                if (string9 != null && string9.trim().length() != 0) {
                    int n = this.getRepositoryIndexByRepositoryID(string9);
                    try {
                        ((DynamicConfigService)((Object)this.repositories[n])).dynamicUpdateConfig(string, hashtable);
                    }
                    catch (RemoteException remoteException) {
                        throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(remoteException.getMessage()), CLASSNAME, "dynamicUpdateConfig", (Throwable)remoteException);
                    }
                }
            } else if (string.equals("websphere.usermanager.serviceprovider.update.entrymapping.adminidpassword")) {
                if (!this.entryJoin) {
                    throw new DynamicUpdateConfigException("ENTRY_MAPPING_REPOSITORY_NOT_DEFINED", CLASSNAME, "dynamicUpdateConfig");
                }
                try {
                    ((DynamicConfigService)((Object)this.fedRepos)).dynamicUpdateConfig(string, hashtable);
                }
                catch (RemoteException remoteException) {
                    throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(remoteException.getMessage()), CLASSNAME, "dynamicUpdateConfig", (Throwable)remoteException);
                }
            } else if (string.equals("websphere.usermanager.serviceprovider.update.propertyextension.adminidpassword")) {
                if (!this.propertyJoin) {
                    throw new DynamicUpdateConfigException("PROPERTY_EXTENSION_REPOSITORY_NOT_DEFINED", CLASSNAME, "dynamicUpdateConfig");
                }
                try {
                    ((DynamicConfigService)((Object)this.laRepos)).dynamicUpdateConfig(string, hashtable);
                }
                catch (RemoteException remoteException) {
                    throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(remoteException.getMessage()), CLASSNAME, "dynamicUpdateConfig", (Throwable)remoteException);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "dynamicUpdateConfig");
        }
    }

    private void addNewRepository(DataObject dataObject) throws WIMException {
        List list;
        List list2;
        List list3;
        Map[] mapArray;
        String string;
        Repository[] repositoryArray;
        int n;
        Set[] setArray;
        int n2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "addNewRepository");
        }
        int n3 = this.reposConfigs.length;
        DataObject[] dataObjectArray = new DataObject[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            dataObjectArray[i] = SDOHelper.cloneDataObject(this.reposConfigs[i]);
        }
        dataObjectArray[n3] = dataObject;
        this.reposConfigs = dataObjectArray;
        String[] stringArray = new String[n3 + 1];
        String[] stringArray2 = new String[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = this.reposIds[i];
            stringArray2[i] = this.reposTypes[i];
        }
        stringArray[n3] = dataObject.getString("id");
        this.reposIds = stringArray;
        List list4 = dataObject.getList("baseEntries");
        List[] listArray = new List[n3 + 1];
        List[] listArray2 = new List[n3 + 1];
        for (n2 = 0; n2 < n3; ++n2) {
            listArray[n2] = this.reposNodes[n2];
        }
        listArray[n3] = new ArrayList(list4.size());
        listArray2[n3] = new ArrayList(list4.size());
        for (n2 = 0; n2 < list4.size(); ++n2) {
            setArray = (Set[])list4.get(n2);
            String string2 = setArray.getString("name");
            listArray[n3].add(setArray.getString("name").trim());
        }
        this.reposNodes = listArray;
        List list5 = dataObject.getList("repositoriesForGroups");
        setArray = new Set[n3 + 1];
        for (n = 0; n < n3; ++n) {
            setArray[n] = this.repositoriesForGroup[n];
        }
        setArray[n3] = new HashSet();
        if (list5 != null && list5.size() > 0) {
            if (this.repositoriesForGroupMembers == null) {
                this.repositoriesForGroupMembers = new HashMap();
            }
            n = list5.size();
            for (int i = 0; i < list5.size(); ++i) {
                repositoryArray = ((String)list5.get(i)).trim();
                setArray[n3].add(repositoryArray);
                HashSet<String> hashSet = (HashSet<String>)this.repositoriesForGroupMembers.get(repositoryArray);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(this.reposIds[n3]);
                this.repositoriesForGroupMembers.put(repositoryArray, hashSet);
            }
        }
        this.repositoriesForGroup = setArray;
        stringArray2[n3] = string = dataObject.getType().getName();
        this.reposTypes = stringArray2;
        String string3 = dataObject.getString("adapterClassName");
        if (string3 == null) {
            if (string.equals("DatabaseRepositoryType")) {
                string3 = DB_ADAPTER_CLASS;
            } else if (string.equals("FileRepositoryType")) {
                string3 = FILE_ADAPTER_CLASS;
            } else if (string.equals("LdapRepositoryType")) {
                string3 = LDAP_ADAPTER_CLASS;
            } else {
                throw new MissingInitPropertyException("MISSING_INI_PROPERTY", WIMMessageHelper.generateMsgParms("adapterClassName"), CLASSNAME, "addNewRepository");
            }
        }
        repositoryArray = new Repository[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            repositoryArray[i] = this.repositories[i];
        }
        try {
            mapArray = this.loadAdapterClass(string3);
            repositoryArray[n3] = (Repository)mapArray.newInstance();
            this.repositories = repositoryArray;
            this.repositories[n3].initialize(dataObject);
        }
        catch (Exception exception) {
            throw new DynamicUpdateConfigException("CLASS_OR_INTERFACE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string3, "adapterClassName"), CLASSNAME, "addNewRepository");
        }
        if (string.equals("DatabaseRepositoryType") || string.equals("ProfileRepositoryType")) {
            if (this.dbReposIds == null) {
                this.dbReposIds = new HashSet();
            }
            this.dbReposIds.add(dataObject.getString("id"));
        }
        mapArray = new Map[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            mapArray[i] = this.actionNotSupport[i];
        }
        mapArray[n3] = new HashMap();
        List list6 = dataObject.getList("EntityTypesNotAllowCreate");
        if (list6 != null && list6.size() != 0) {
            mapArray[n3].put(ACTION_CREATE, list6);
        }
        if ((list3 = dataObject.getList("EntityTypesNotAllowRead")) != null && list3.size() != 0) {
            mapArray[n3].put(ACTION_READ, list3);
        }
        if ((list2 = dataObject.getList("EntityTypesNotAllowUpdate")) != null && list2.size() != 0) {
            mapArray[n3].put(ACTION_UPDATE, list2);
        }
        if ((list = dataObject.getList("EntityTypesNotAllowDelete")) != null && list.size() != 0) {
            mapArray[n3].put(ACTION_DELETE, list);
        }
        this.actionNotSupport = mapArray;
        boolean[] blArray = new boolean[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            blArray[i] = this.isGenerateUniqueId[i];
        }
        blArray[n3] = !dataObject.getBoolean("isExtIdUnique");
        this.isGenerateUniqueId = blArray;
        boolean[] blArray2 = new boolean[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            blArray2[i] = blArray2[i];
        }
        blArray2[n3] = dataObject.getBoolean("supportSorting");
        this.isSortingSupported = blArray2;
        boolean[] blArray3 = new boolean[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            blArray3[i] = this.isAsyncModeSupported[i];
        }
        blArray3[n3] = dataObject.getBoolean("supportAsyncMode");
        this.isAsyncModeSupported = blArray3;
        boolean[] blArray4 = new boolean[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            blArray4[i] = this.readOnlyFlags[i];
        }
        blArray4[n3] = dataObject.getBoolean("readOnly");
        this.readOnlyFlags = blArray4;
        ++this.numOfRepos;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "addNewRepository");
        }
    }

    public static boolean matchBaseEntryIgnoreCase(List list, String string) {
        boolean bl = false;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "matchBaseEntryIgnoreCase", "Locale=" + Locale.getDefault() + ", baseEntry=" + string + ",  baseEntries=" + list);
        }
        if (list != null && string != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!string.equalsIgnoreCase((String)list.get(i))) continue;
                bl = true;
                break;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "matchBaseEntryIgnoreCase", "result=" + bl);
        }
        return bl;
    }
}

