/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim;

import com.ibm.websphere.wim.Service;
import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.CertificateMapFailedException;
import com.ibm.websphere.wim.exception.CertificateMapNotSupportedException;
import com.ibm.websphere.wim.exception.DuplicateLogonIdException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InvalidUniqueNameException;
import com.ibm.websphere.wim.exception.MissingInitPropertyException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.exception.PasswordCheckFailedException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.ws.wim.adapter.file.was.FileAdapter;
import com.ibm.ws.wim.config.ConfigSessionManager;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.ParticipatingBaseEntriesType;
import com.ibm.ws.wim.configmodel.RealmConfigurationType;
import com.ibm.ws.wim.configmodel.RealmType;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.ws.wim.util.UniqueNameHelper;
import com.ibm.wsspi.wim.Repository;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SPIServiceProvider
implements Service {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = SPIServiceProvider.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private Service service = null;
    private String sessionId = null;
    private ConfigurationProviderType configDO = null;
    private RealmConfigurationType realmConfig = null;
    private String defaultRealmName = null;
    private Map realmParticipatingBaseEntries = new HashMap();
    private Map realm2ReposSearchBases = new HashMap();
    private Repository[] repositories = null;
    private List reposDOs = null;
    private String[] reposIds = null;
    private int numOfRepos = 0;
    private List[] reposNodes = null;
    private List[] reposNodesLowerCase = null;

    public SPIServiceProvider(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "<init>", "inputSessionId=" + string);
        }
        this.sessionId = string;
        this.service = ServiceProvider.singleton();
        this.initialize();
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "<init>");
        }
    }

    public void initialize() throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "getting the config for sessionId=" + this.sessionId);
        }
        this.configDO = (ConfigurationProviderType)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return ConfigSessionManager.singleton().getConfig(SPIServiceProvider.this.sessionId);
            }
        });
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "current config=" + WIMTraceHelper.printDataGraph((DataObject)this.configDO));
        }
        this.processRepositories();
        this.processRealms();
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    private void processRepositories() throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "processRepositories");
        }
        List list = ConfigUtils.getProfileRepositories(this.configDO);
        this.numOfRepos = list.size();
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "processRepositories", "number of repos=" + this.numOfRepos);
        }
        this.repositories = new Repository[this.numOfRepos];
        this.reposDOs = new ArrayList();
        this.reposNodes = new List[this.numOfRepos];
        this.reposNodesLowerCase = new List[this.numOfRepos];
        this.reposIds = new String[this.numOfRepos];
        String string = null;
        for (int i = 0; i < this.numOfRepos; ++i) {
            this.repositories[i] = null;
            DataObject dataObject = (DataObject)list.get(i);
            this.reposDOs.add(dataObject);
            this.reposIds[i] = string = dataObject.getString("id");
            List list2 = dataObject.getList("baseEntries");
            this.reposNodes[i] = new ArrayList(list2.size());
            this.reposNodesLowerCase[i] = new ArrayList(list2.size());
            for (int j = 0; j < list2.size(); ++j) {
                DataObject dataObject2 = (DataObject)list2.get(j);
                String string2 = dataObject2.getString("name");
                string2 = UniqueNameHelper.getValidUniqueName(string2);
                this.reposNodes[i].add(string2.trim());
                this.reposNodesLowerCase[i].add(string2.trim().toLowerCase());
            }
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "processRepositories");
        }
    }

    private void processRealms() throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "processRealms");
        }
        this.realmConfig = this.configDO.getRealmConfiguration();
        this.defaultRealmName = this.realmConfig.getDefaultRealm();
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "processRealms", "defaultRealmName=" + this.defaultRealmName);
        }
        List list = this.realmConfig.getRealms();
        for (int i = 0; i < list.size(); ++i) {
            RealmType realmType = (RealmType)list.get(i);
            String string = realmType.getName();
            List list2 = realmType.getParticipatingBaseEntries();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int j = 0; j < list2.size(); ++j) {
                arrayList.add(((ParticipatingBaseEntriesType)list2.get(j)).getName());
            }
            this.realmParticipatingBaseEntries.put(string, arrayList);
            Map map = this.seperateParticipatingBaseEntriesByReposIndex(arrayList);
            if (map == null) continue;
            this.realm2ReposSearchBases.put(string, map);
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "processRealms", "realmParticipatingBaseEntries=" + this.realmParticipatingBaseEntries + ", realm2ReposSearchBases=" + this.realm2ReposSearchBases);
        }
    }

    private Map seperateParticipatingBaseEntriesByReposIndex(List list) throws WIMException {
        HashMap<Integer, ArrayList<String>> hashMap = null;
        if (list != null) {
            hashMap = new HashMap<Integer, ArrayList<String>>();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                int n = this.getRepositoryIndexByUniqueName(string);
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(new Integer(n));
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
                hashMap.put(new Integer(n), arrayList);
            }
        }
        return hashMap;
    }

    private int getRepositoryIndexByUniqueName(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "getRepositoryIndexByUniqueName", "uniqueName=" + string);
        }
        int n = -1;
        String string2 = string.trim().toLowerCase();
        block0: for (int i = 0; i < this.reposNodesLowerCase.length; ++i) {
            List list = this.reposNodesLowerCase[i];
            for (int j = 0; j < list.size(); ++j) {
                String string3 = (String)list.get(j);
                if (string3.length() == 0) {
                    n = i;
                    break block0;
                }
                if (string2.length() == string3.length() && string2.equals(string3)) {
                    n = i;
                    break block0;
                }
                if (string2.length() <= string3.length() || !string2.endsWith("," + string3)) continue;
                n = i;
                break block0;
            }
        }
        if (n == -1) {
            throw new InvalidUniqueNameException("ENTITY_NOT_IN_REALM_SCOPE", WIMMessageHelper.generateMsgParms(string, "defined"), CLASSNAME, "getRepositoryIndexByUniqueName");
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "getRepositoryIndexByUniqueName", "reposIndex=" + n);
        }
        return n;
    }

    private Map initializeRepositories(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "initializeRepositories", "realm=" + string);
        }
        Map map = (Map)this.realm2ReposSearchBases.get(string);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            DataObject dataObject = (DataObject)this.reposDOs.get(n);
            if (dataObject == null) continue;
            this.reposDOs.set(n, null);
            String string2 = dataObject.getString("id");
            String string3 = dataObject.getType().getName();
            String string4 = dataObject.getString("adapterClassName");
            if (string4 == null) {
                if (string3.equals("DatabaseRepositoryType")) {
                    string4 = "com.ibm.ws.wim.adapter.db.DBAdapter";
                } else if (string3.equals("FileRepositoryType")) {
                    string4 = "com.ibm.ws.wim.adapter.file.was.FileAdapter";
                } else if (string3.equals("LdapRepositoryType")) {
                    string4 = "com.ibm.ws.wim.adapter.ldap.LdapAdapter";
                } else {
                    throw new MissingInitPropertyException("MISSING_INI_PROPERTY", WIMMessageHelper.generateMsgParms("adapterClassName"), CLASSNAME, "initializeRepositories");
                }
            }
            try {
                Object object;
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "initializeRepositories", "initializing repository: " + string2);
                }
                if (string3.equals("FileRepositoryType") && string4.equals("com.ibm.ws.wim.adapter.file.was.FileAdapter")) {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "initializeRepositories", "initializing file repository with sessionId: " + this.sessionId);
                    }
                    this.repositories[n] = object = new FileAdapter(this.sessionId, (DataObject)this.configDO, dataObject);
                    continue;
                }
                try {
                    object = Class.forName(string4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    object = Class.forName(string4, true, classLoader);
                }
                this.repositories[n] = (Repository)((Class)object).newInstance();
                this.repositories[n].initialize(dataObject);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(string2, classNotFoundException.getMessage()), CLASSNAME, "initializeRepositories", (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(string2, instantiationException.getMessage()), CLASSNAME, "initializeRepositories", (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(string2, illegalAccessException.getMessage()), CLASSNAME, "initializeRepositories", (Throwable)illegalAccessException);
            }
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "initializeRepositories");
        }
        return map;
    }

    public DataObject getConfig() throws WIMException, RemoteException {
        return (DataObject)this.configDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject login(DataObject dataObject) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "login");
        }
        if (dataObject == null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "login");
            }
            return null;
        }
        DataObject dataObject2 = null;
        HashMap hashMap = new HashMap();
        WIMApplicationException wIMApplicationException = null;
        String string = null;
        String string2 = null;
        byte[] byArray = null;
        List list = dataObject.getList("entities");
        if (list.size() == 0) {
            throw new EntityNotFoundException("MISSING_ENTITY_DATA_OBJECT", WIMMessageHelper.generateMsgParms("login"), CLASSNAME, "login");
        }
        if (list.size() > 1) {
            throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", WIMMessageHelper.generateMsgParms("login"), CLASSNAME, "login");
        }
        DataObject dataObject3 = (DataObject)list.get(0);
        string2 = dataObject3.getString("principalName");
        byArray = dataObject3.getBytes("password");
        Map map = ControlsHelper.getControlMap(dataObject.getDataGraph());
        if (map.get("LoginControl") == null) {
            dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "LoginControl");
        }
        String string3 = this.getRealmName(dataObject);
        Map map2 = this.initializeRepositories(string3);
        try {
            for (Integer n : map2.keySet()) {
                Object object;
                List list2 = (List)map2.get(n);
                int n2 = n;
                if (list2 == null || list2.size() <= 0) continue;
                try {
                    DataObject dataObject4 = DataGraphHelper.cloneRootDataObject(dataObject);
                    object = ControlsHelper.getControlMap(dataObject4.getDataGraph());
                    DataObject dataObject5 = (DataObject)object.get("LoginControl");
                    dataObject5.setList("searchBases", list2);
                    DataObject dataObject6 = this.repositories[n2].login(dataObject4);
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "login", "after calling adapter [" + this.reposIds[n2] + "]");
                    }
                    if (dataObject2 == null) {
                        if (dataObject6.getList("entities").size() <= 0) continue;
                        dataObject2 = dataObject6;
                        string = this.reposIds[n2];
                        continue;
                    }
                    if (dataObject6.getList("entities").size() <= 0) continue;
                    throw new DuplicateLogonIdException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "login");
                }
                catch (PasswordCheckFailedException passwordCheckFailedException) {
                    object = passwordCheckFailedException.getMessageKey();
                    if ("PRINCIPAL_NOT_FOUND".equals(object)) continue;
                    if ("MISSING_OR_EMPTY_PRINCIPAL_NAME".equals(object)) {
                        throw passwordCheckFailedException;
                    }
                    if ("MULTIPLE_PRINCIPALS_FOUND".equals(object)) {
                        throw passwordCheckFailedException;
                    }
                    wIMApplicationException = passwordCheckFailedException;
                    this.recordLoginException(passwordCheckFailedException, hashMap);
                }
                catch (CertificateMapFailedException certificateMapFailedException) {
                    wIMApplicationException = certificateMapFailedException;
                    this.recordLoginException(certificateMapFailedException, hashMap);
                }
                catch (CertificateMapNotSupportedException certificateMapNotSupportedException) {
                    wIMApplicationException = certificateMapNotSupportedException;
                    this.recordLoginException(certificateMapNotSupportedException, hashMap);
                }
            }
        }
        finally {
            PasswordUtil.erasePassword(byArray);
        }
        int n = hashMap.size();
        if (dataObject2 == null) {
            if (n == 0) {
                if (hashMap.containsKey(CertificateMapNotSupportedException.class.getName())) {
                    throw new CertificateMapNotSupportedException("AUTHENTICATE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms("the specified certificate"), CLASSNAME, "login");
                }
                throw new PasswordCheckFailedException("PRINCIPAL_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "login");
            }
            if (n == 1) {
                throw wIMApplicationException;
            }
            if (n > 1) {
                trcLogger.logp(Level.FINER, CLASSNAME, "login", "countedException > 1 [" + n + "]");
                throw new DuplicateLogonIdException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "login");
            }
        } else if (n == 0) {
            trcLogger.logp(Level.FINER, CLASSNAME, "login", "login successful.");
        } else if (n >= 1) {
            trcLogger.logp(Level.FINER, CLASSNAME, "login", "result != null && countedException >= 1");
            throw new DuplicateLogonIdException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "login");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "login");
        }
        return dataObject2;
    }

    public DataObject search(DataObject dataObject) throws WIMException, RemoteException {
        DataObject dataObject2;
        block7: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "WIM_API search", WIMTraceHelper.printDataGraph(dataObject));
            }
            dataObject2 = null;
            try {
                DataObject dataObject3 = DataGraphHelper.cloneRootDataObject(dataObject);
                Map map = ControlsHelper.getControlMap(dataObject3);
                DataObject dataObject4 = (DataObject)map.get("SearchControl");
                int n = dataObject4.getInt("countLimit");
                if (n < 0) {
                    throw new SearchControlException("INCORRECT_COUNT_LIMIT", WIMMessageHelper.generateMsgParms(new Integer(n)), CLASSNAME, "search");
                }
                dataObject4.setInt("countLimit", n);
                String string = this.getRealmName(dataObject3);
                Map map2 = this.initializeRepositories(string);
                dataObject2 = SDOHelper.createRootDataObject();
                int n2 = 0;
                DataObject dataObject5 = map2.keySet().iterator();
                while (dataObject5.hasNext()) {
                    int n3 = (Integer)dataObject5.next();
                    List list = this.searchRepository(n3, dataObject3);
                    if (list == null || list.size() <= 0) continue;
                    n2 += list.size();
                    if (list == null) continue;
                    dataObject2.getList("entities").addAll(list);
                }
                if (n > 0 && n < n2) {
                    dataObject5 = dataObject2.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchResponseControl");
                    dataObject5.setBoolean("hasMoreResults", true);
                }
            }
            catch (Exception exception) {
                if (!trcLogger.isLoggable(Level.FINER)) break block7;
                trcLogger.logp(Level.FINER, CLASSNAME, "WIM_API search", exception.getMessage(), exception);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_API search", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    private String getRealmName(DataObject dataObject) throws WIMApplicationException {
        String string = null;
        List list = dataObject.getList("contexts");
        if (list == null || list.size() == 0) {
            string = this.defaultRealmName;
        } else {
            for (int i = 0; i < list.size() && (string == null || string.length() == 0); ++i) {
                DataObject dataObject2 = (DataObject)list.get(i);
                String string2 = dataObject2.getString("key");
                if (string2 == null || !"realm".equals(string2)) continue;
                string = (String)dataObject2.get("value");
            }
            if (string == null) {
                string = this.defaultRealmName;
            }
        }
        return string;
    }

    private List searchRepository(int n, DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchRepository");
        }
        DataObject dataObject2 = null;
        List list = null;
        dataObject2 = this.repositories[n].search(dataObject);
        if (dataObject2 != null) {
            list = dataObject2.getList("entities");
        }
        if (dataObject2 != null && (list = dataObject2.getList("entities")) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject3 = ((DataObject)list.get(i)).getDataObject("identifier");
                String string = dataObject3.getString("externalId");
                dataObject3.setString("repositoryId", this.reposIds[n]);
                dataObject3.setString("uniqueId", string);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "searchRepository", WIMTraceHelper.printObjectArray(new Object[]{list}));
        }
        return list;
    }

    private void recordLoginException(WIMException wIMException, Map map) {
        String string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "recordLoginException");
        }
        if (map.containsKey(string = wIMException.getMessageKey())) {
            int n = (Integer)map.get(string) + 1;
            map.put(string, new Integer(n));
        } else {
            map.put(string, new Integer(1));
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "recordLoginException", "record exception [" + string + "]");
            trcLogger.exiting(CLASSNAME, "recordLoginException");
        }
    }

    public DataObject create(DataObject dataObject) throws WIMException, RemoteException {
        throw new WIMException("API not implemented: create");
    }

    public DataObject createDataObject(String string, String string2) throws WIMException, RemoteException {
        return this.service.createDataObject(string, string2);
    }

    public DataObject createRootDataObject() throws WIMException, RemoteException {
        return this.service.createRootDataObject();
    }

    public DataObject createSchema(DataObject dataObject) throws WIMException, RemoteException {
        throw new WIMException("API not implemented: createSchema");
    }

    public DataObject delete(DataObject dataObject) throws WIMException, RemoteException {
        throw new WIMException("API not implemented: delete");
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException, RemoteException {
        throw new WIMException("API not implemented: dynamicUpdateConfig");
    }

    public DataObject get(DataObject dataObject) throws WIMException, RemoteException {
        throw new WIMException("API not implemented: get");
    }

    public byte[] getConfigEPackage() throws WIMException, RemoteException {
        throw new WIMException("API not implemented: getConfigEPackage");
    }

    public byte[] getEPackages(String string) throws WIMException, RemoteException {
        return this.service.getEPackages(string);
    }

    public DataObject getSchema(DataObject dataObject) throws WIMException, RemoteException {
        return this.service.getSchema(dataObject);
    }

    public DataObject update(DataObject dataObject) throws WIMException, RemoteException {
        throw new WIMException("API not implemented: update");
    }
}

