/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim;

import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.SchemaService;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.InitializationException;
import com.ibm.websphere.wim.exception.InvalidEntityTypeException;
import com.ibm.websphere.wim.exception.InvalidPropertyDefinitionException;
import com.ibm.websphere.wim.exception.InvalidRepositoryIdException;
import com.ibm.websphere.wim.exception.InvalidSchemaException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.exception.SchemaAlreadyExistException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.security.authz.Entitlement;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.websphere.wim.util.XSDHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.ProfileManager;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.schema.DBDataType;
import com.ibm.ws.wim.management.DynamicReloadManager;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import com.ibm.ws.wim.util.AsyncUtils;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.wsspi.wim.Repository;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;

public class SchemaManager
implements SchemaService,
DynamicConfigService {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    public static final String CLASSNAME = SchemaManager.class.getName();
    public static final String WIM_XML_EXTENSION_FILE = "wimxmlextension.xml";
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static SchemaManager singleton = null;
    private static final String eINSTANCE = "eINSTANCE";
    private ConfigManager iConfigMgr = null;
    private Map iPrefixToURI = new HashMap();
    private Map iEntitySubTypes = new Hashtable();
    private String iXMLExtFilePath = null;
    private Map uriToSchema = null;
    private Map iEntityProps = new Hashtable();
    private Map iProperties = new Hashtable();
    private DataGraph iXMLExtDG = null;

    private SchemaManager() throws WIMException {
        this.uriToSchema = new HashMap();
        this.initialize();
    }

    public static synchronized SchemaManager singleton() throws WIMException {
        if (singleton == null) {
            singleton = new SchemaManager();
        }
        return singleton;
    }

    public void initialize() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        this.iConfigMgr = ConfigManager.singleton();
        DataObject dataObject = this.iConfigMgr.getConfig();
        DataObject dataObject2 = dataObject.getDataObject("dynamicModel");
        String string = File.separator;
        if (dataObject2 != null) {
            String string2 = dataObject2.getString("xsdFileName");
            if (string2 == null) {
                string2 = this.iConfigMgr.getWIMHomePath() + "model" + string + "wimextension.xsd";
            } else if (string2.indexOf(string) == -1) {
                string2 = this.iConfigMgr.getWIMHomePath() + "model" + string + string2;
            }
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize", "Use dynamic WIM model: " + string2);
            }
            this.loadModelFromXSD(string2);
        } else {
            DataObject dataObject3 = dataObject.getDataObject("staticModel");
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize", "Use static WIM model.");
            }
            this.loadModelFromPackage(dataObject3);
        }
        this.iXMLExtFilePath = this.iConfigMgr.getWIMHomePath() + "model" + string + WIM_XML_EXTENSION_FILE;
        this.loadModelFromExtXML(this.iXMLExtFilePath);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    public DataObject getWimXmlExtXml(String string) throws InitializationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getWimXmlExtXml", "The path for wimxmlextension.xml provided is " + string);
        }
        long l = System.currentTimeMillis();
        DataObject dataObject = null;
        if (null == string || string.trim().length() == 0) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "getWimXmlExtXml", "Exiting since the file path for wimxmlextension.xml is empty or null");
            }
            return dataObject;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            HashMap hashMap = new HashMap();
            this.iXMLExtDG = SDOUtil.loadDataGraph((InputStream)fileInputStream, hashMap);
            if (trcLogger.isLoggable(Level.FINER)) {
                long l2 = System.currentTimeMillis();
                trcLogger.logp(Level.FINER, CLASSNAME, "getWimXmlExtXml", "Loaded from " + string + " (" + (l2 - l) + " milliseconds)");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "getWimXmlExtXml", "XML extension file " + string + " is not found.");
            }
            return dataObject;
        }
        catch (IOException iOException) {
            throw new InitializationException("INVALID_WIM_EXTENSION_XML_FILE", WIMMessageHelper.generateMsgParms(string, iOException.getMessage()), CLASSNAME, "getWimXmlExtXml", (Throwable)iOException);
        }
        if (null != this.iXMLExtDG) {
            dataObject = this.iXMLExtDG.getRootObject();
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getWimXmlExtXml", WIMTraceHelper.printDataObject(dataObject));
        }
        return dataObject;
    }

    public String getNsPrefix(String string) {
        for (String string2 : this.iPrefixToURI.keySet()) {
            String string3 = (String)this.iPrefixToURI.get(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public String getNsURI(String string) {
        if (string == null || string.length() == 0) {
            return "http://www.ibm.com/websphere/wim";
        }
        return (String)this.iPrefixToURI.get(string);
    }

    private void addPrefixToURIMap(String string, String string2) throws InvalidSchemaException {
        if (string2 == null || string2.trim().length() == 0) {
            throw new InvalidSchemaException("INVALID_NS_URI", CLASSNAME, "addPrefixToURIMap");
        }
        if (string == null) {
            string = string2.substring(string2.lastIndexOf("/") + 1);
        }
        if (this.iPrefixToURI.containsValue(string2)) {
            throw new InvalidSchemaException("DUPLICATE_NS_URI", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "addPrefixToURIMap");
        }
        if (this.iPrefixToURI.containsKey(string)) {
            throw new InvalidSchemaException("DUPLICATE_NS_PREFIX", WIMMessageHelper.generateMsgParms(string, string2), CLASSNAME, "addPrefixToURIMap");
        }
        this.iPrefixToURI.put(string, string2);
    }

    private void loadModelFromXSD(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "loadModelFromXSD", string);
        }
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        XSDEcoreBuilder xSDEcoreBuilder = new XSDEcoreBuilder();
        Collection collection = xSDEcoreBuilder.generate(URI.createFileURI((String)string));
        for (EPackage ePackage : collection) {
            String string2 = ePackage.getNsURI();
            String string3 = ePackage.getNsPrefix();
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "loadModelFromXSD", "Package nsURI: " + string2 + ", nsPrefix=" + string3);
            }
            this.addPrefixToURIMap(string3, string2);
            ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
            EPackage.Registry.INSTANCE.put((Object)string2, (Object)ePackage);
            this.uriToSchema.put(string2, ePackage);
            this.readPackage(ePackage);
        }
        if (EPackage.Registry.INSTANCE.get((Object)"http://www.ibm.com/websphere/wim") == null) {
            throw new InitializationException("WIM_MODEL_PACKAGE_NOT_FOUND_IN_XSD", WIMMessageHelper.generateMsgParms("http://www.ibm.com/websphere/wim", string), CLASSNAME, "loadModelFromXSD");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "loadModelFromXSD");
        }
    }

    private void loadModelFromPackage(DataObject dataObject) throws WIMException {
        List list = dataObject.getList("packageName");
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "loadModelFromPackage", list);
        }
        if (!list.contains("com.ibm.websphere.wim.model.ModelPackage")) {
            list.add("com.ibm.websphere.wim.model.ModelPackage");
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            try {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "loadModelFromPackage", "loading package " + string);
                }
                Class<?> clazz = Class.forName(string);
                EPackage ePackage = (EPackage)clazz.getField(eINSTANCE).get(clazz);
                String string2 = ePackage.getNsURI();
                String string3 = ePackage.getNsPrefix();
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "loadModelFromPackage", "nsURI=" + string2 + ", nsPrefix=" + string3);
                }
                this.addPrefixToURIMap(string3, string2);
                EPackage.Registry.INSTANCE.put((Object)string2, (Object)ePackage);
                this.uriToSchema.put(string2, ePackage);
                this.readPackage(ePackage);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InitializationException("CLASS_OR_INTERFACE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadModelFromPackage", (Throwable)classNotFoundException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new InitializationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadModelFromPackage", (Throwable)noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InitializationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadModelFromPackage", (Throwable)illegalAccessException);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "loadModelFromPackage");
        }
    }

    private EPackage createPackage(String string, String string2, String string3) throws InvalidSchemaException {
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        EPackage ePackage = ecoreFactory.createEPackage();
        ePackage.setNsURI(string);
        if (string3 != null) {
            ePackage.setName(string3);
        }
        if (string2 != null) {
            ePackage.setNsPrefix(string2);
        }
        ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
        EPackage.Registry.INSTANCE.put((Object)string, (Object)ePackage);
        this.uriToSchema.put(string, ePackage);
        string2 = ePackage.getNsPrefix();
        this.addPrefixToURIMap(string2, string);
        return ePackage;
    }

    private void addEntitySchema(DataObject dataObject, DataObject dataObject2) throws WIMException {
        Object object;
        Object object2;
        String string;
        Object object32;
        DataObject dataObject3;
        EPackage ePackage;
        String string2 = dataObject.getString("entityName");
        String string3 = dataObject.getString("nsURI");
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "addEntitySchema", "entityName=" + string2 + ", nsURI=" + string3);
        }
        if ((ePackage = EPackage.Registry.INSTANCE.getEPackage(string3)) == null) {
            ePackage = this.createPackage(string3, dataObject.getString("nsPrefix"), null);
        }
        if (this.getEClass(string2, string3) != null) {
            throw new SchemaAlreadyExistException("ENTITY_TYPE_ALREADY_DEFINED", WIMMessageHelper.generateMsgParms(string2, string3), CLASSNAME, "addEntitySchema");
        }
        String string4 = dataObject.getString("parentEntityName");
        EClass eClass = this.getEClass(string4);
        if (eClass == null) {
            throw new InvalidEntityTypeException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string4), CLASSNAME, "addEntitySchema");
        }
        List list = dataObject.getList("properties");
        ArrayList<EStructuralFeature> arrayList = new ArrayList<EStructuralFeature>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            dataObject3 = (DataObject)list.get(i);
            String string5 = dataObject3.getString("name");
            if (this.getProperty(string2, string5) != null) {
                throw new SchemaAlreadyExistException("PROPERTY_TYPE_ALREADY_DEFINED", WIMMessageHelper.generateMsgParms(string5, string2), CLASSNAME, "addEntitySchema");
            }
            object32 = XSDHelper.getGlobalFeature(string5);
            if (object32 == null) {
                throw new InvalidSchemaException("PROPERTY_NOT_DEFINED", WIMMessageHelper.generateMsgParms(string5), CLASSNAME, "addEntitySchema");
            }
            arrayList.add((EStructuralFeature)object32);
        }
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        dataObject3 = ecoreFactory.createEClass();
        dataObject3.setName(string2);
        dataObject3.getESuperTypes().add((Object)eClass);
        ePackage.getEClassifiers().add((Object)dataObject3);
        for (int i = 0; i < arrayList.size(); ++i) {
            object32 = (DataObject)list.get(i);
            string = object32.getString("name");
            object2 = XSDHelper.getNsURIFromQualifiedName(string);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "addEntitySchema", "Processing property " + string + ", propURI=" + (String)object2);
            }
            object = (EStructuralFeature)arrayList.get(i);
            EStructuralFeature eStructuralFeature = (EStructuralFeature)EcoreUtil.copy((EObject)object);
            object.setTransient(false);
            object.setVolatile(false);
            object.setDerived(false);
            boolean bl = object32.getBoolean("multiValued");
            if (bl) {
                object.setUpperBound(-1);
            } else {
                object.setUpperBound(1);
            }
            dataObject3.getEStructuralFeatures().add(object);
            ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)object, (String)object2);
        }
        for (Object object32 : this.iEntitySubTypes.keySet()) {
            string = this.getEClass((String)object32);
            if (string == null || !string.isSuperTypeOf((EClass)dataObject3)) continue;
            object2 = (Set)this.iEntitySubTypes.get(object32);
            object2.add(this.getQualifiedTypeName(string3, dataObject3.getName()));
        }
        if (dataObject2 != null) {
            DataObject dataObject4 = DataGraphHelper.cloneDataObject(dataObject);
            object32 = dataObject4.getDataObject("entityConfiguration");
            if (object32 != null) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "addEntitySchema", "Remove entity config from schema extension data");
                }
                object32.delete();
            }
            list = dataObject4.getList("properties");
            for (int i = 0; i < list.size(); ++i) {
                object2 = (DataObject)list.get(i);
                object = object2.getList("metaData");
                for (int j = 0; j < object.size(); ++j) {
                    DataObject dataObject5 = (DataObject)object.get(j);
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "addEntitySchema", "Remove prop metadata from schema extension data");
                    }
                    dataObject5.delete();
                }
            }
            dataObject2.getList("entitySchema").add(dataObject4);
        }
        this.iEntitySubTypes.clear();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "addEntitySchema", "New entity type '" + string2 + "' is created.");
        }
    }

    public EDataType getEDataType(String string) {
        XMLTypePackage xMLTypePackage = XMLTypePackage.eINSTANCE;
        EDataType eDataType = null;
        if ("String".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getString();
        } else if ("Int".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getInt();
        } else if ("Date".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getDate();
        } else if ("Boolean".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getBoolean();
        } else if ("AnySimpleType".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getAnySimpleType();
        } else if ("Long".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getLong();
        } else if ("Double".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getDouble();
        } else if ("Base64Binary".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getBase64Binary();
        } else if ("AnyURI".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getAnyURI();
        } else if ("Byte".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getByte();
        } else if ("DateTime".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getDateTime();
        } else if ("Short".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getShort();
        } else if ("Token".equalsIgnoreCase(string)) {
            eDataType = xMLTypePackage.getToken();
        }
        return eDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertySchema(DataObject dataObject, DataObject dataObject2) throws WIMException {
        EClass eClass;
        String string;
        Object object;
        String string2;
        String string3 = dataObject.getString("propertyName");
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        String string4 = dataObject.getString("dataType");
        String string5 = dataObject.getString("nsURI");
        String string6 = dataObject.getString("nsPrefix");
        String string7 = this.getQualifiedTypeName(string5, string3);
        List list = dataObject.getList("applicableEntityTypeNames");
        ArrayList<EClass> arrayList = new ArrayList<EClass>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            string2 = (String)list.get(i);
            EClass eClass2 = this.getEClass(string2);
            if (eClass2 == null) {
                throw new InvalidEntityTypeException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "addPropertySchema");
            }
            if (this.getProperty(string2, string7) != null) {
                throw new SchemaAlreadyExistException("PROPERTY_TYPE_ALREADY_DEFINED", WIMMessageHelper.generateMsgParms(string7, string2), CLASSNAME, "addPropertySchema");
            }
            arrayList.add(eClass2);
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string5);
        if (ePackage == null) {
            ePackage = this.createPackage(string5, string6, null);
        }
        string2 = this.getEDataType(string4);
        boolean bl = dataObject.getBoolean("multiValued");
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (EClass)arrayList.get(i);
            string = null;
            if (string2 != null) {
                string = ecoreFactory.createEAttribute();
                string.setEType((EClassifier)string2);
            } else {
                eClass = this.getEClass(string4);
                if (eClass == null) {
                    throw new InvalidSchemaException("REFERENCE_TYPE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string4), CLASSNAME, "addPropertySchema");
                }
                string = ecoreFactory.createEReference();
                string.setEType((EClassifier)eClass);
                ((EReference)string).setContainment(true);
            }
            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)string, 4);
            string.setName(string3);
            string.setUnique(false);
            if (bl) {
                string.setUpperBound(-1);
            } else {
                string.setUpperBound(1);
            }
            eClass = this.getDocumentRoot("http://www.ibm.com/websphere/wim");
            eClass.getEStructuralFeatures().add((Object)string);
            ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)string, string5);
            object.getEStructuralFeatures().add((Object)string);
        }
        if (dataObject2 != null) {
            DataObject dataObject3 = DataGraphHelper.cloneDataObject(dataObject);
            object = dataObject3.getList("metaData");
            string = "";
            while (object.size() != 0) {
                eClass = (DataObject)object.get(0);
                String string8 = eClass.getString("name");
                if ("applicationId".equals(string8)) {
                    string = (String)eClass.getList("values").get(0);
                }
                eClass.delete();
            }
            if (null != string && string.trim().length() > 0) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "addPropertySchema", "The application Id of the extended property is " + string);
                }
                eClass = dataObject3.createDataObject("metaData");
                eClass.set("name", (Object)"applicationId");
                eClass.getList("values").add(string.trim());
            }
            dataObject2.getList("propertySchema").add(dataObject3);
        }
        this.readPackage(this.getSchemaPackage(string5));
        SchemaManager schemaManager = this;
        synchronized (schemaManager) {
            this.iEntityProps.clear();
        }
    }

    private EClass getDocumentRoot(String string) {
        EPackage ePackage = this.getSchemaPackage(string);
        if (ePackage != null) {
            EList eList = ePackage.getEClassifiers();
            for (int i = 0; i < eList.size(); ++i) {
                EClass eClass;
                String string2;
                Object e2 = eList.get(i);
                if (!(e2 instanceof EClass) || !"DocumentRoot".equals(string2 = (eClass = (EClass)e2).getName())) continue;
                return eClass;
            }
        }
        return null;
    }

    private void loadModelFromExtXML(String string) throws WIMException {
        DataObject dataObject;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "loadModelFromExtXML", string);
        }
        if (null == (dataObject = this.getWimXmlExtXml(string))) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "loadModelFromExtXML", "XML extension file " + string + " is not found. No extension will be added.");
            }
            return;
        }
        DataObject dataObject2 = dataObject.getDataObject("schema");
        if (dataObject2 != null) {
            List list = dataObject2.getList("entitySchema");
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                this.addEntitySchema(dataObject3, null);
            }
            List list2 = dataObject2.getList("propertySchema");
            for (int i = 0; i < list2.size(); ++i) {
                DataObject dataObject4 = (DataObject)list2.get(i);
                this.addPropertySchema(dataObject4, null);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "loadModelFromExtXML");
        }
    }

    private DataObject postGetSchema(DataObject dataObject, DataObject dataObject2) throws WIMException {
        String string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "postGetSchema");
        }
        if ((string = AsyncUtils.getPostProcessing(dataObject2)) != null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "postGetSchema", "postProcess str=" + string);
            }
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (string.indexOf(":") < 0) {
                string2 = string;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
            }
            if (string2.equals("appendPropertySchema")) {
                this.appendPropertySchema(string3, string4, dataObject);
            } else if (string2.equals("appendEntityTypeSchema")) {
                this.appendEntityTypeSchema(dataObject);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "postGetSchema");
        }
        return dataObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    public DataObject getSchema(DataObject dataObject) throws WIMException {
        Object object;
        String string;
        DataObject dataObject2;
        block29: {
            block34: {
                block33: {
                    DataObject dataObject3;
                    block32: {
                        DataObject dataObject4;
                        block31: {
                            DataObject dataObject5;
                            DataObject dataObject6;
                            block30: {
                                if (trcLogger.isLoggable(Level.FINER)) {
                                    trcLogger.entering(CLASSNAME, "getSchema");
                                }
                                ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
                                profileSecurityManager.checkPermission_SuperUser(new Entitlement("GET", "SCHEMA"));
                                dataObject2 = null;
                                if (AsyncUtils.isCheckAsyncOperationStatus(dataObject)) {
                                    String string2 = AsyncUtils.getRepositoryId(dataObject);
                                    dataObject2 = RepositoryManager.singleton().getRepository(string2).getSchema(dataObject);
                                    if (AsyncUtils.isOperationComplete(dataObject2)) {
                                        dataObject2 = this.postGetSchema(dataObject2, dataObject);
                                    } else {
                                        AsyncUtils.setPostProcessing(dataObject2, dataObject);
                                    }
                                    if (dataObject2 == null) {
                                        throw new WIMApplicationException("INVALID_DATA_OBJECT", CLASSNAME, "getSchema");
                                    }
                                    this.addRequiredEntityTypeForRDN(dataObject2);
                                    if (trcLogger.isLoggable(Level.FINER)) {
                                        trcLogger.exiting(CLASSNAME, "getSchema");
                                    }
                                    return dataObject2;
                                }
                                Map map = ControlsHelper.getControlMap(dataObject);
                                DataObject dataObject7 = (DataObject)map.get("DataTypeControl");
                                dataObject6 = (DataObject)map.get("ExtensionPropertyDataTypeControl");
                                dataObject4 = (DataObject)map.get("PropertyDefinitionControl");
                                dataObject3 = (DataObject)map.get("ExtensionPropertyDefinitionControl");
                                dataObject5 = (DataObject)map.get("EntityTypeControl");
                                if (dataObject7 == null) break block30;
                                string = dataObject7.getString("repositoryId");
                                if (trcLogger.isLoggable(Level.FINER)) {
                                    trcLogger.logp(Level.FINER, CLASSNAME, "getSchema", "DataTypeControl is specified with repositoryId=" + string);
                                }
                                dataObject2 = string != null && string.length() != 0 ? RepositoryManager.singleton().getRepository(string).getSchema(dataObject) : this.getDataTypesFromSchema();
                                break block29;
                            }
                            if (dataObject6 != null) {
                                if (trcLogger.isLoggable(Level.FINER)) {
                                    trcLogger.logp(Level.FINER, CLASSNAME, "getSchema", "LookasideDataTypeControl is specified.");
                                }
                                if (RepositoryManager.singleton().isPropertyJoin()) {
                                    dataObject2 = RepositoryManager.singleton().getLookasideRepository().getSchema(dataObject);
                                    break block29;
                                } else {
                                    if (trcLogger.isLoggable(Level.FINER)) {
                                        trcLogger.logp(Level.FINER, CLASSNAME, "getSchema", "Property join is not turned on while LookasideDataTypeControl is specified.");
                                    }
                                    throw new WIMApplicationException("PROPERTY_EXTENSION_REPOSITORY_NOT_DEFINED", CLASSNAME, "getSchema");
                                }
                            }
                            if (dataObject5 == null) break block31;
                            string = dataObject5.getString("repositoryId");
                            if (trcLogger.isLoggable(Level.FINER)) {
                                trcLogger.logp(Level.FINER, CLASSNAME, "getSchema", "EntityTypeControl is specified with repositoryId=" + string);
                            }
                            if (AsyncUtils.isOperationComplete(dataObject2 = string == null || string.length() == 0 ? this.getSupportedEntityTypes(dataObject5) : RepositoryManager.singleton().getRepository(string).getSchema(dataObject))) {
                                this.appendEntityTypeSchema(dataObject2);
                                break block29;
                            } else {
                                AsyncUtils.setPostProcessing(dataObject2, "appendEntityTypeSchema");
                            }
                            break block29;
                        }
                        if (dataObject4 == null) break block32;
                        string = dataObject4.getString("repositoryId");
                        object = dataObject4.getString("entityTypeName");
                        if (trcLogger.isLoggable(Level.FINER)) {
                            trcLogger.logp(Level.FINER, CLASSNAME, "getSchema", "PropertyDefinitionControl is specified with repositoryId=" + string + ", entityTypeName=" + (String)object);
                        }
                        if (object == null || ((String)object).trim().length() == 0) {
                            throw new WIMApplicationException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms("entityTypeName"), CLASSNAME, "getSchema");
                        }
                        EClass eClass = this.getEClass((String)object);
                        if (eClass == null) {
                            throw new InvalidEntityTypeException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(object), CLASSNAME, "getSchema");
                        }
                        dataObject2 = string == null || string.length() == 0 ? this.getPropertySchema(dataObject4) : RepositoryManager.singleton().getRepository(string).getSchema(dataObject);
                        if (AsyncUtils.isOperationComplete(dataObject2)) {
                            this.appendPropertySchema("propertySchema", (String)object, dataObject2);
                            break block29;
                        } else {
                            AsyncUtils.setPostProcessing(dataObject2, "appendPropertySchema:propertySchema:" + (String)object);
                        }
                        break block29;
                    }
                    if (dataObject3 == null) break block29;
                    string = dataObject3.getString("entityTypeName");
                    if (string == null || string.trim().length() == 0) {
                        throw new WIMApplicationException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms("entityTypeName"), CLASSNAME, "getSchema");
                    }
                    object = this.getEClass(string);
                    if (object == null) {
                        throw new InvalidEntityTypeException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getSchema");
                    }
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "getSchema", "LookasideDataTypeControl is specified.");
                    }
                    if (!RepositoryManager.singleton().isPropertyJoin()) break block33;
                    dataObject2 = RepositoryManager.singleton().getLookasideRepository().getSchema(dataObject);
                    if (!AsyncUtils.isOperationComplete(dataObject2)) break block29;
                    break block34;
                }
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "getSchema", "Property join is not turned on while LookasidePropertyDefinitionControl is specified.");
                }
                throw new WIMApplicationException("PROPERTY_EXTENSION_REPOSITORY_NOT_DEFINED", CLASSNAME, "getSchema");
            }
            this.appendPropertySchema("extensionPropertySchema", string, dataObject2);
        }
        string = dataObject2.getDataObject("schema");
        if (string != null && (object = string.getList("propertySchema")) != null && object.size() > 0) {
            for (int i = 0; i < object.size(); ++i) {
                DataObject dataObject8 = (DataObject)object.get(i);
                if ("ibmPrimaryEmail".equals(dataObject8.getString("propertyName"))) {
                    dataObject8.setString("propertyName", "ibm-primaryEmail");
                    dataObject8.setString("dataType", "String");
                    dataObject8.setString("multiValued", "false");
                    continue;
                }
                if (!"ibmJobTitle".equals(dataObject8.getString("propertyName"))) continue;
                dataObject8.setString("propertyName", "ibm-jobTitle");
                dataObject8.setString("dataType", "String");
                dataObject8.setString("multiValued", "true");
            }
        }
        if (dataObject2 == null) {
            throw new WIMApplicationException("INVALID_DATA_OBJECT", CLASSNAME, "getSchema");
        }
        this.addRequiredEntityTypeForRDN(dataObject2);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getSchema");
        }
        return dataObject2;
    }

    private void addRequiredEntityTypeForRDN(DataObject dataObject) {
        List list;
        DataObject dataObject2;
        if (dataObject != null && (dataObject2 = dataObject.getDataObject("schema")) != null && (list = dataObject2.getList("propertySchema")) != null) {
            List list2;
            List list3;
            String string;
            int n;
            List list4 = this.iConfigMgr.getSupportedEntityTypes();
            HashMap hashMap = new HashMap();
            for (n = 0; n < list4.size(); ++n) {
                string = (String)list4.get(n);
                list3 = this.iConfigMgr.getRDNProperties(string);
                if (list3 == null || list3.size() <= 0) continue;
                list2 = (ArrayList<String>)hashMap.get((String)list3.get(0));
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                    hashMap.put((String)list3.get(0), list2);
                }
                list2.add(string);
            }
            for (n = 0; n < list.size(); ++n) {
                string = ((DataObject)list.get(n)).getString("propertyName");
                if (!hashMap.containsKey(string)) continue;
                list3 = (List)hashMap.get(string);
                list2 = ((DataObject)list.get(n)).getList("requiredEntityTypeNames");
                list3.removeAll(list2);
                list2.addAll(list3);
            }
        }
    }

    private void appendEntityTypeSchema(DataObject dataObject) throws WIMException {
        List list;
        DataObject dataObject2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "appendEntityTypeSchema");
        }
        if (dataObject != null && (dataObject2 = dataObject.getDataObject("schema")) != null && (list = dataObject2.getList("entitySchema")) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                String string = dataObject3.getString("entityName");
                String string2 = dataObject3.getString("nsURI");
                if (string == null || string.length() == 0) {
                    throw new WIMApplicationException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms("entityName"), CLASSNAME, "appendEntityTypeSchema");
                }
                EList eList = this.getEClass(this.getQualifiedTypeName(string2, string)).getESuperTypes();
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "appendEntityTypeSchema", "get super types [" + string + "]: [" + eList + "]");
                }
                if (eList != null && eList.size() > 0) {
                    EClass eClass = (EClass)eList.get(0);
                    String string3 = eClass.getName();
                    String string4 = eClass.getEPackage().getNsURI();
                    String string5 = this.getQualifiedTypeName(string4, string3);
                    dataObject3.setString("parentEntityName", string5);
                    if (!trcLogger.isLoggable(Level.FINER)) continue;
                    trcLogger.logp(Level.FINER, CLASSNAME, "appendEntityTypeSchema", "set super types : [" + string5 + "]");
                    continue;
                }
                if (!trcLogger.isLoggable(Level.FINER)) continue;
                trcLogger.logp(Level.FINER, CLASSNAME, "appendEntityTypeSchema", "no super type retrieved. ");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "appendEntityTypeSchema");
        }
    }

    private void appendPropertySchema(String string, String string2, DataObject dataObject) throws WIMException {
        List list;
        DataObject dataObject2;
        EClass eClass;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "appendPropertySchema");
        }
        if ((eClass = this.getEClass(string2)) == null) {
            throw new InvalidEntityTypeException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "appendPropertySchema");
        }
        if (dataObject != null && (dataObject2 = dataObject.getDataObject("schema")) != null && (list = dataObject2.getList(string)) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                String string3 = dataObject3.getString("propertyName");
                if (string3 == null || string3.length() == 0) {
                    throw new WIMApplicationException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms("propertyName"), CLASSNAME, "appendPropertySchema");
                }
                String string4 = dataObject3.getString("nsURI");
                String string5 = this.getNsPrefix(string4);
                String string6 = this.getQualifiedTypeName(dataObject3.getString("nsURI"), string3);
                Property property = this.getProperty(string2, string6);
                if (property == null) continue;
                if (property.isMany()) {
                    dataObject3.setBoolean("multiValued", true);
                } else {
                    dataObject3.setBoolean("multiValued", false);
                }
                dataObject3.setString("dataType", property.getType().getName());
                dataObject3.setString("nsPrefix", string5);
                dataObject3.setString("nsURI", string4);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "appendPropertySchema");
        }
    }

    private DataObject getSupportedEntityTypes(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getSupportedEntityTypes");
        }
        DataObject dataObject2 = this.createRootDataObject();
        DataObject dataObject3 = dataObject2.createDataObject("schema");
        List list = dataObject.getList("entityTypeNames");
        if (list == null || list.size() == 0) {
            Set set = this.getSubEntityTypes("Entity");
            if (set != null) {
                for (String string : set) {
                    DataObject dataObject4 = dataObject3.createDataObject("entitySchema");
                    dataObject4.setString("entityName", this.getTypeName(string));
                    dataObject4.setString("nsURI", this.getTypeNsURI(string));
                }
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                DataObject dataObject5 = dataObject3.createDataObject("entitySchema");
                dataObject5.setString("entityName", this.getTypeName(string));
                dataObject5.setString("nsURI", this.getTypeNsURI(string));
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getSupportedEntityTypes");
        }
        return dataObject2;
    }

    private DataObject getPropertySchema(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getPropertySchema");
        }
        DataObject dataObject2 = this.createRootDataObject();
        DataObject dataObject3 = dataObject2.createDataObject("schema");
        String string = dataObject.getString("entityTypeName");
        if (string == null || string.length() == 0) {
            throw new WIMApplicationException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms("entityTypeName"), CLASSNAME, "getPropertySchema");
        }
        List list = dataObject.getList("propertyNames");
        if (list == null || list.size() == 0) {
            List list2 = this.getProperties(string);
            for (int i = 0; i < list2.size(); ++i) {
                Property property = (Property)list2.get(i);
                String string2 = property.getName();
                DataObject dataObject4 = dataObject3.createDataObject("propertySchema");
                dataObject4.setString("propertyName", string2);
            }
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "getPropertySchema", "append property schema: " + list2);
            }
        } else {
            List list3 = this.getPropertyNames(string);
            if (list3 != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string3 = (String)list.get(i);
                    if (!list3.contains(string3)) continue;
                    DataObject dataObject5 = dataObject3.createDataObject("propertySchema");
                    dataObject5.setString("propertyName", string3);
                }
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "getPropertySchema", "append property schema: " + list);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getPropertySchema");
        }
        return dataObject2;
    }

    private DataObject getDataTypesFromSchema() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getDataTypesFromSchema");
        }
        DataObject dataObject = this.createRootDataObject();
        DataObject dataObject2 = dataObject.createDataObject("schema");
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.getSubEntityTypes("wim:Entity");
        for (String string : set) {
            List list = this.getProperties(string);
            for (int i = 0; i < list.size(); ++i) {
                Property property = (Property)list.get(i);
                String string2 = property.getType().getName();
                hashSet.add(string2);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "getDataTypesFromSchema", "cached datatypes [" + hashSet + "]. ");
        }
        for (String string : hashSet) {
            dataObject2.getList("propertyDataTypes").add(string);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDataTypesFromSchema");
        }
        return dataObject;
    }

    public DataObject createSchema(DataObject dataObject) throws WIMException {
        Object object;
        List list;
        Object object2;
        Object object3;
        DataObject dataObject2;
        block40: {
            int n;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "createSchema", WIMTraceHelper.printDataObject(dataObject));
            }
            ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
            profileSecurityManager.checkPermission_SuperUser(new Entitlement("CREATE", "SCHEMA"));
            if (!(DynamicReloadManager.isConnectionTypeNone() || DynamicReloadManager.isRunningOnDeploymentManager() || DynamicReloadManager.isRunningOnSingleServer())) {
                throw new DynamicUpdateConfigException("DYNAMIC_RELOAD_INVALID_UPDATE_AT_MANAGED_NODE", CLASSNAME, "createSchema");
            }
            DataObject dataObject3 = null;
            if (dataObject == null || (dataObject3 = dataObject.getDataObject("schema")) == null) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.exiting(CLASSNAME, "createSchema", "Null DataObject or no schema present in the dataobject.");
                }
                return dataObject;
            }
            this.validateSchemaAttributes(dataObject3);
            dataObject3 = DataGraphHelper.cloneDataObject(dataObject3);
            if (this.iXMLExtDG == null) {
                this.iXMLExtDG = SDOFactory.eINSTANCE.createEDataGraph();
                this.iXMLExtDG.createRootObject("http://www.ibm.com/websphere/wim", "DocumentRoot");
            }
            if ((dataObject2 = this.iXMLExtDG.getRootObject().getDataObject("schema")) == null) {
                dataObject2 = this.iXMLExtDG.getRootObject().createDataObject("schema");
            }
            List list2 = dataObject3.getList("entitySchema");
            List list3 = dataObject3.getList("propertySchema");
            List list4 = dataObject3.getList("extensionPropertySchema");
            ArrayList<String> arrayList = null;
            DataObject dataObject4 = null;
            if (list2.size() > 0) {
                dataObject4 = (DataObject)list2.get(0);
            } else if (list3.size() > 0) {
                dataObject4 = (DataObject)list3.get(0);
            } else if (list4.size() > 0) {
                dataObject4 = (DataObject)list4.get(0);
            } else {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.exiting(CLASSNAME, "createSchema");
                }
                return dataObject;
            }
            arrayList = dataObject4.getList("repositoryIds");
            if (arrayList.size() == 0) {
                object3 = RepositoryManager.singleton().getRepositoryIds();
                arrayList = new ArrayList<String>(((String[])object3).length);
                for (n = 0; n < ((String[])object3).length; ++n) {
                    arrayList.add(object3[n]);
                }
            }
            if (list2.size() > 0) {
                this.addEntitySchema(dataObject4, dataObject2);
            } else if (list3.size() > 0 || list4.size() > 0) {
                if (list3.size() > 0) {
                    this.validateDBRepositoryPropertySchemaAttributes(dataObject4, arrayList);
                } else {
                    this.validateLAPropertySchemaAttributes(dataObject4, arrayList);
                }
                this.addPropertySchema(dataObject4, dataObject2);
            }
            this.iConfigMgr.createSchema(dataObject);
            object3 = new ArrayList(arrayList.size());
            if (list2.size() > 0 || list3.size() > 0) {
                for (n = 0; n < arrayList.size(); ++n) {
                    object2 = (String)arrayList.get(n);
                    Repository repository2 = RepositoryManager.singleton().getRepository((String)object2);
                    try {
                        repository2.createSchema(dataObject);
                        object3.add(object2);
                        continue;
                    }
                    catch (WIMException wIMException) {
                        if (!trcLogger.isLoggable(Level.FINE)) continue;
                        trcLogger.logp(Level.FINE, CLASSNAME, "createSchema", "Repository '" + (String)object2 + "' does not support creating new schema: " + wIMException.toString());
                    }
                }
            } else if (list4.size() > 0) {
                RepositoryManager.singleton().getLookasideRepository().createSchema(dataObject);
                ProfileManager.singleton().invalidLAProperties();
            }
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "createSchema", "repositoryIds=" + object3);
            }
            String string = null;
            try {
                object2 = ConfigManager.singleton().getRepsoitoryIds();
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "createSchema", "all reposIds=" + object2);
                }
                for (int i = 0; i < object2.size(); ++i) {
                    string = (String)object2.get(i);
                    list = ConfigManager.singleton().getRepositoryDataObject(string);
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "createSchema", "reposId=" + string + ", type=" + list.getType().getName());
                    }
                    if (object3.contains(string) || !"FileRepositoryType".equals(list.getType().getName())) continue;
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "createSchema", "Calling createSchema on File Repository '" + string + "' so that it can reload the file registry data.");
                    }
                    object = RepositoryManager.singleton().getRepository(string);
                    object.createSchema(dataObject);
                }
            }
            catch (WIMException wIMException) {
                if (!trcLogger.isLoggable(Level.FINE)) break block40;
                trcLogger.logp(Level.FINE, CLASSNAME, "createSchema", "Repository '" + string + "' does not support creating new schema: " + wIMException.toString());
            }
        }
        if (object3.size() > 0) {
            object2 = dataObject.getDataObject("schema");
            DataObject dataObject5 = null;
            list = object2.getList("propertySchema");
            if (list.size() > 0) {
                dataObject5 = (DataObject)list.get(0);
            } else {
                object = object2.getList("entitySchema");
                if (object.size() > 0) {
                    dataObject5 = (DataObject)object.get(0);
                }
            }
            if (dataObject5 != null) {
                dataObject5.unset("repositoryIds");
                dataObject5.getList("repositoryIds").addAll(object3);
            }
        }
        object2 = SDOFactory.eINSTANCE.createEDataGraph();
        object2.createRootObject("http://www.ibm.com/websphere/wim", "DocumentRoot");
        object2.getRootObject().setDataObject("schema", DataGraphHelper.cloneDataObject(dataObject2));
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "createSchema", "Saving into " + this.iXMLExtFilePath + "." + WIMTraceHelper.printDataGraph((DataGraph)object2));
        }
        DataGraphHelper.saveDataGraph((DataGraph)object2, this.iXMLExtFilePath);
        ProfileManager.singleton().initializePropertyCache();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createSchema", WIMTraceHelper.printDataObject(dataObject));
        }
        return dataObject;
    }

    public void validateSchemaAttributes(DataObject dataObject) throws WIMException {
        List list;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateSchemaAttributes");
        }
        if ((list = dataObject.getList("entitySchema")).size() > 1) {
            throw new InvalidSchemaException("CAN_NOT_CREATE_MULTIPLE_ENTITY_TYPES", CLASSNAME, "validateSchemaAttributes");
        }
        List list2 = dataObject.getList("propertySchema");
        List list3 = dataObject.getList("extensionPropertySchema");
        if (list2.size() > 1 || list3.size() > 1 || list2.size() > 0 && list3.size() > 0) {
            throw new InvalidSchemaException("CAN_NOT_CREATE_MULTIPLE_PROPERTY_TYPES", CLASSNAME, "validateSchemaAttributes");
        }
        if (list.size() > 0 && (list2.size() > 0 || list3.size() > 0)) {
            throw new InvalidSchemaException("CAN_NOT_CREATE_BOTH_ENTITY_AND_PROPERTY", CLASSNAME, "validateSchemaAttributes");
        }
        DataObject dataObject2 = null;
        if (list.size() > 0) {
            dataObject2 = (DataObject)list.get(0);
        } else if (list2.size() > 0) {
            dataObject2 = (DataObject)list2.get(0);
        } else if (list3.size() > 0) {
            if (!RepositoryManager.singleton().isPropertyJoin()) {
                throw new DynamicUpdateConfigException("PROPERTY_EXTENSION_REPOSITORY_NOT_DEFINED", CLASSNAME, "validateSchemaAttributes");
            }
            dataObject2 = (DataObject)list3.get(0);
        } else {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "validateSchemaAttributes");
            }
            return;
        }
        List list4 = dataObject2.getList("repositoryIds");
        if (list4 != null) {
            for (int i = 0; i < list4.size(); ++i) {
                String string = (String)list4.get(i);
                if (RepositoryManager.singleton().getRepository(string) != null) continue;
                throw new InvalidRepositoryIdException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "validateSchemaAttributes");
            }
        }
        if (list.size() > 0) {
            this.validateEnityTypeSchemaAttributes(dataObject2);
        } else if (list2.size() > 0 || list3.size() > 0) {
            this.validatePropertyTypeSchemaAttributes(dataObject2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateSchemaAttributes");
        }
    }

    private void validateWellFormedNessOfNsuriIfNullNsPrefix(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateWellFormedNessOfNsuriIfNullNsPrefix", "nsURI=" + string + ", nsPrefix=" + string2);
        }
        if (!(string == null && string.length() <= 0 || string2 != null && string2.length() != 0 || (string2 = this.getNsPrefix(string)) != null)) {
            String string3 = new String(string).trim();
            try {
                string2 = string3.substring(string3.lastIndexOf("/") + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null || string2.length() == 0) {
                throw new InvalidSchemaException("INVALID_NS_URI", CLASSNAME, "validateWellFormedNessOfNsuriIfNullNsPrefix");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateWellFormedNessOfNsuriIfNullNsPrefix");
        }
    }

    private void validateDBPropertySchemaAttributes(DataObject dataObject, List list) throws WIMException {
        String string;
        DataObject dataObject2;
        int n;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateDBPropertySchemaAttributes", "reqReposIds=" + list);
        }
        boolean bl = false;
        String string2 = dataObject.getString("propertyName");
        List list2 = dataObject.getList("metaData");
        String string3 = dataObject.getString("dataType");
        DBDataType dBDataType = DAOHelper.getDBDataTypeFromCommonDataType(string3);
        String string4 = null;
        for (n = 0; n < list.size(); ++n) {
            string4 = (String)list.get(n);
            if ("LA".equals(string4)) {
                bl = true;
                break;
            }
            dataObject2 = RepositoryManager.singleton().getRepositoryConfig(string4);
            string = dataObject2.getType().getName();
            if (!"DatabaseRepositoryType".equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "validateDBPropertySchemaAttributes", "isRepoTypeDB=" + bl);
            }
            return;
        }
        if ("OBJECT".equalsIgnoreCase(dBDataType.getDatatype()) && (dBDataType.getClassname() == null || dBDataType.getClassname().length() == 0)) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "validateDBPropertySchemaAttributes", "className=" + dBDataType.getClassname());
            }
            throw new InvalidPropertyDefinitionException("INVALID_PROPERTY_DATA_TYPE", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "validateDBPropertySchemaAttributes");
        }
        for (n = 0; n < list2.size(); ++n) {
            dataObject2 = (DataObject)list2.get(n);
            string = dataObject2.getString("name");
            String string5 = (String)dataObject2.getList("values").get(0);
            if (!"isComposite".equals(string) || !Boolean.valueOf(string5).booleanValue()) continue;
            throw new OperationNotSupportedException("OPERATION_NOT_SUPPORTED_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string4 + "|" + "isComposite"), CLASSNAME, "validateDBPropertySchemaAttributes");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateDBPropertySchemaAttributes");
        }
    }

    private void validateLAPropertySchemaAttributes(DataObject dataObject, List list) throws WIMException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (!arrayList.contains("LA")) {
            arrayList.add("LA");
        }
        this.validateDBPropertySchemaAttributes(dataObject, arrayList);
    }

    private void validateDBRepositoryPropertySchemaAttributes(DataObject dataObject, List list) throws WIMException {
        this.validateDBPropertySchemaAttributes(dataObject, list);
    }

    private void validateEnityTypeSchemaAttributes(DataObject dataObject) throws WIMException {
        String string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateEnityTypeSchemaAttributes");
        }
        if ((string = dataObject.getString("entityName")) == null || string.length() == 0) {
            throw new WIMApplicationException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms("entityName"), CLASSNAME, "validateEnityTypeSchemaAttributes");
        }
        String string2 = dataObject.getString("nsURI");
        this.validateWellFormedNessOfNsuriIfNullNsPrefix(string2, dataObject.getString("nsPrefix"));
        if (this.getEClass(string, string2) != null) {
            throw new SchemaAlreadyExistException("ENTITY_TYPE_ALREADY_DEFINED", WIMMessageHelper.generateMsgParms(string, string2), CLASSNAME, "validateEnityTypeSchemaAttributes");
        }
        String string3 = dataObject.getString("parentEntityName");
        EClass eClass = this.getEClass(string3);
        if (eClass == null) {
            throw new InvalidEntityTypeException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "validateEnityTypeSchemaAttributes");
        }
        List list = dataObject.getList("properties");
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject2 = (DataObject)list.get(i);
            String string4 = dataObject2.getString("name");
            if (this.getProperty(string, string4) != null) {
                throw new SchemaAlreadyExistException("PROPERTY_TYPE_ALREADY_DEFINED", WIMMessageHelper.generateMsgParms(string4, string), CLASSNAME, "validateEnityTypeSchemaAttributes");
            }
            EStructuralFeature eStructuralFeature = XSDHelper.getGlobalFeature(string4);
            if (eStructuralFeature != null) continue;
            throw new InvalidSchemaException("PROPERTY_NOT_DEFINED", WIMMessageHelper.generateMsgParms(string4), CLASSNAME, "validateEnityTypeSchemaAttributes");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateEnityTypeSchemaAttributes");
        }
    }

    private void validatePropertyTypeSchemaAttributes(DataObject dataObject) throws WIMException {
        Object object;
        Object object2;
        String string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validatePropertyTypeSchemaAttributes");
        }
        if ((string = dataObject.getString("propertyName")) == null || string.length() == 0) {
            throw new WIMApplicationException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms("propertyName"), CLASSNAME, "validatePropertyTypeSchemaAttributes");
        }
        String string2 = dataObject.getString("dataType");
        String string3 = dataObject.getString("nsURI");
        this.validateWellFormedNessOfNsuriIfNullNsPrefix(string3, dataObject.getString("nsPrefix"));
        String string4 = this.getQualifiedTypeName(string3, string);
        List list = dataObject.getList("applicableEntityTypeNames");
        for (int i = 0; i < list.size(); ++i) {
            object2 = (String)list.get(i);
            object = this.getEClass((String)object2);
            if (object == null) {
                throw new InvalidEntityTypeException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(object2), CLASSNAME, "validatePropertyTypeSchemaAttributes");
            }
            if (this.getProperty((String)object2, string4) == null) continue;
            throw new SchemaAlreadyExistException("PROPERTY_TYPE_ALREADY_DEFINED", WIMMessageHelper.generateMsgParms(string4, object2), CLASSNAME, "validatePropertyTypeSchemaAttributes");
        }
        EDataType eDataType = this.getEDataType(string2);
        if (eDataType == null && (object2 = this.getEClass(string2)) == null) {
            throw new InvalidSchemaException("REFERENCE_TYPE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "validatePropertyTypeSchemaAttributes");
        }
        object2 = dataObject.getList("requiredEntityTypeNames");
        if (object2 != null) {
            object = dataObject.getList("applicableEntityTypeNames");
            for (int i = 0; i < object2.size(); ++i) {
                String string5 = (String)object2.get(i);
                if (object.contains(string5)) continue;
                throw new InvalidPropertyDefinitionException("INVALID_PROPERTY_DEFINITION", WIMMessageHelper.generateMsgParms("requiredEntityTypeNames", string5, string), CLASSNAME, "validatePropertyTypeSchemaAttributes");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validatePropertyTypeSchemaAttributes");
        }
    }

    private void readPackage(EPackage ePackage) throws WIMApplicationException {
        String string = ePackage.getNsURI();
        String string2 = ePackage.getNsPrefix();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "readPackage", "Package Name: " + ePackage.getName() + "\tPackage NSURI:" + string + "\tPreFix: " + string2);
        }
        EList eList = ePackage.getEClassifiers();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof EClass)) continue;
            EClass eClass = (EClass)e2;
            String string3 = eClass.getName();
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "readPackage", "\tClass Name: " + string3);
            }
            EList eList2 = eClass.getEAllStructuralFeatures();
            for (int j = 0; j < eList2.size(); ++j) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)eList2.get(j);
                String string4 = eStructuralFeature.getName();
                if (!trcLogger.isLoggable(Level.FINEST)) continue;
                trcLogger.logp(Level.FINEST, CLASSNAME, "readPackage", "\t\tStructrual Feature: " + eStructuralFeature);
            }
        }
    }

    public String getQualifiedTypeName(String string, String string2) {
        if (!"http://www.ibm.com/websphere/wim".equals(string)) {
            String string3 = this.getNsPrefix(string);
            if (string3 != null) {
                return string3 + ":" + string2;
            }
            return string2;
        }
        return string2;
    }

    public String getQualifiedTypeName(Type type) {
        return this.getQualifiedTypeName(type.getURI(), type.getName());
    }

    public String getQualifedTypeName(EClass eClass) {
        String string = ExtendedMetaData.INSTANCE.getNamespace((EClassifier)eClass);
        String string2 = eClass.getName();
        return this.getQualifiedTypeName(string, string2);
    }

    public EClass getEClass(String string, String string2) {
        String string3;
        EPackage ePackage;
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "http://www.ibm.com/websphere/wim";
        }
        if ((ePackage = (EPackage)AccessController.doPrivileged(new PrivilegedAction(string3 = string2){
            final /* synthetic */ String val$uri1;
            {
                this.val$uri1 = string;
            }

            public Object run() {
                return EPackage.Registry.INSTANCE.getEPackage(this.val$uri1);
            }
        })) != null) {
            return (EClass)ePackage.getEClassifier(string);
        }
        return null;
    }

    public boolean isSuperType(String string, String string2) {
        EClass eClass;
        EClass eClass2 = this.getEClass(string);
        if (eClass2 != null && (eClass = this.getEClass(string2)) != null) {
            return eClass2.isSuperTypeOf(eClass);
        }
        return false;
    }

    public String getSuperType(List list, String string) {
        if (list.contains(string)) {
            return string;
        }
        EClass eClass = this.getEClass(string);
        if (eClass != null) {
            eClass = (EClass)eClass.getESuperTypes().iterator().next();
            while (eClass != null) {
                String string2 = this.getQualifedTypeName(eClass);
                if (list.contains(string2)) {
                    return string2;
                }
                eClass = eClass.getESuperTypes().size() != 0 ? (EClass)eClass.getESuperTypes().iterator().next() : null;
            }
        }
        return null;
    }

    public Set getSubEntityTypes(String string) {
        HashSet<String> hashSet = (HashSet<String>)this.iEntitySubTypes.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            EClass eClass = this.getEClass(string);
            if (eClass == null) {
                trcLogger.logp(Level.FINER, CLASSNAME, "getSubEntityTypes", "EMF package is not visible.  Package will re-registered");
                this.reRegisterPackages();
                eClass = this.getEClass(string);
            }
            if (eClass != null) {
                for (String string2 : this.iPrefixToURI.keySet()) {
                    String string3 = (String)this.iPrefixToURI.get(string2);
                    EPackage ePackage = XSDHelper.getPackage(string3);
                    if (ePackage == null) {
                        ePackage = (EPackage)this.uriToSchema.get(string3);
                        EPackage.Registry.INSTANCE.put((Object)string3, (Object)ePackage);
                    }
                    EList eList = ePackage.getEClassifiers();
                    for (int i = 0; i < eList.size(); ++i) {
                        EClass eClass2;
                        Object e2 = eList.get(i);
                        if (!(e2 instanceof EClass) || !eClass.isSuperTypeOf(eClass2 = (EClass)e2) || eClass.equals(eClass2)) continue;
                        hashSet.add(this.getQualifiedTypeName(string3, eClass2.getName()));
                    }
                }
                this.iEntitySubTypes.put(string, hashSet);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getProperties(String string) {
        ArrayList<EProperty> arrayList = (ArrayList<EProperty>)this.iEntityProps.get(string);
        if (arrayList == null) {
            SchemaManager schemaManager = this;
            synchronized (schemaManager) {
                EClass eClass = this.getEClass(string);
                if (eClass != null) {
                    EList eList = eClass.getEAllStructuralFeatures();
                    arrayList = new ArrayList<EProperty>(eList.size());
                    for (int i = 0; i < eList.size(); ++i) {
                        EStructuralFeature eStructuralFeature = (EStructuralFeature)eList.get(i);
                        arrayList.add(SDOUtil.adaptProperty((EStructuralFeature)eStructuralFeature));
                    }
                    this.iEntityProps.put(string, arrayList);
                }
            }
        }
        return arrayList;
    }

    public List getPropertyNames(String string) {
        ArrayList<String> arrayList = null;
        List list = this.getProperties(string);
        if (list != null) {
            arrayList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(((Property)list.get(i)).getName());
            }
        }
        return arrayList;
    }

    public List getProperties(Type type) {
        String string = this.getQualifiedTypeName(type.getURI(), type.getName());
        return this.getProperties(string);
    }

    public String getQualifiedPropertyName(Property property) {
        return XSDHelper.getQualifiedPropertyName(property);
    }

    public String getQualifiedPropertyName(EStructuralFeature eStructuralFeature) {
        return XSDHelper.getQualifiedPropertyName(eStructuralFeature);
    }

    public Property getProperty(Type type, String string) {
        String string2 = type.getURI() + ":" + type.getName() + ":" + string;
        Property property = (Property)this.iProperties.get(string2);
        if (property == null) {
            String string3 = null;
            String string4 = null;
            int n = string.indexOf(":");
            if (n > 1) {
                string3 = this.getNsURI(string.substring(0, n));
                string4 = string.substring(n + 1);
            } else {
                string4 = string;
            }
            property = XSDHelper.getLocalProperty(type.getURI(), type.getName(), string3, string4);
            if (property != null) {
                this.iProperties.put(string2, property);
            }
        }
        return property;
    }

    public Property getProperty(String string, String string2) {
        String string3 = null;
        String string4 = null;
        int n = string2.indexOf(":");
        if (n > 1) {
            string3 = this.getNsURI(string2.substring(0, n));
            string4 = string2.substring(n + 1);
        } else {
            string4 = string2;
        }
        String string5 = null;
        String string6 = null;
        n = string.indexOf(":");
        if (n > 1) {
            string5 = this.getNsURI(string.substring(0, n));
            string6 = string.substring(n + 1);
        } else {
            string6 = string;
        }
        Property property = XSDHelper.getLocalProperty(string5, string6, string3, string4);
        if (property == null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "getProperty", "EMF package is not visible.  Package will re-registered");
            }
            this.reRegisterPackages();
            return XSDHelper.getLocalProperty(string5, string6, string3, string4);
        }
        return property;
    }

    public Property getProperty(EStructuralFeature eStructuralFeature) {
        return SDOUtil.adaptProperty((EStructuralFeature)eStructuralFeature);
    }

    public EClass getEClass(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(":");
        if (n > 1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        return this.getEClass(string3, this.getNsURI(string2));
    }

    public EClass getEClass(Type type) {
        return this.getEClass(type.getName(), type.getURI());
    }

    private void reRegisterPackages() {
        for (String string : this.uriToSchema.keySet()) {
            if (EPackage.Registry.INSTANCE.getEPackage(string) != null) continue;
            EPackage.Registry.INSTANCE.put((Object)string, (Object)((EPackage)this.uriToSchema.get(string)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getEPackages(String string3) throws WIMException {
        String string2 = "getEPackages";
        try {
            Object object;
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            Resource resource = resourceSetImpl.createResource(URI.createURI((String)".ecore"));
            if (string3 != null) {
                object = EPackage.Registry.INSTANCE.getEPackage(string3);
                if (object == null && (object = (EPackage)this.uriToSchema.get(string3)) != null) {
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, string2, "Re-register package: " + string3);
                    }
                    EPackage.Registry.INSTANCE.put((Object)string3, object);
                }
                if (object == null) throw new InvalidSchemaException("SCHEMA_PACKAGE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, string2);
                resource.getContents().add(object);
                for (EPackage ePackage = object.getESuperPackage(); ePackage != null; ePackage = ePackage.getESuperPackage()) {
                    resource.getContents().add((Object)ePackage);
                }
            } else {
                for (String string3 : this.uriToSchema.keySet()) {
                    EPackage ePackage = (EPackage)this.uriToSchema.get(string3);
                    if (EPackage.Registry.INSTANCE.getEPackage(string3) == null) {
                        if (trcLogger.isLoggable(Level.FINER)) {
                            trcLogger.logp(Level.FINER, CLASSNAME, string2, "Re-register package: " + string3);
                        }
                        EPackage.Registry.INSTANCE.put((Object)string3, (Object)ePackage);
                    }
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, string2, "Returning package: " + string3);
                    }
                    resource.getContents().add((Object)ePackage);
                }
            }
            object = new ByteArrayOutputStream(2064);
            resource.save((OutputStream)object, Collections.EMPTY_MAP);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            throw new WIMApplicationException(iOException.toString());
        }
    }

    public DataObject createRootDataObject() throws WIMException {
        if (EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/wim") == null) {
            this.reRegisterPackages();
        }
        return SDOHelper.createRootDataObject();
    }

    public DataObject createDataObject(String string, String string2) {
        return SDOHelper.createDataObject(string, string2);
    }

    public EPackage getSchemaPackage(String string) {
        return XSDHelper.getPackage(string);
    }

    public String getTypeNsURI(String string) {
        String string2 = null;
        int n = string.indexOf(":");
        if (n > 1) {
            string2 = string.substring(0, n);
        }
        return this.getNsURI(string2);
    }

    public DataObject createDataObject(DataObject dataObject, String string, String string2) {
        return dataObject.createDataObject(string, this.getTypeNsURI(string2), this.getTypeName(string2));
    }

    public String getTypeName(String string) {
        int n = string.indexOf(":");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "dynamicUpdateConfig", "not implemented for SchemaManager.");
        }
    }
}

