/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.db;

import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.ProfileService;
import com.ibm.websphere.wim.common.RepositoryProperty;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.EntityHasDescendantsException;
import com.ibm.websphere.wim.exception.EntityIdentifierNotSpecifiedException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InvalidIdentifierException;
import com.ibm.websphere.wim.exception.InvalidInitPropertyException;
import com.ibm.websphere.wim.exception.InvalidPropertyDefinitionException;
import com.ibm.websphere.wim.exception.MissingMandatoryPropertyException;
import com.ibm.websphere.wim.exception.MissingSearchControlException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.exception.PasswordCheckFailedException;
import com.ibm.websphere.wim.exception.PropertyNotDefinedException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.UpdateOperationalPropertyException;
import com.ibm.websphere.wim.exception.UpdatePropertyException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.websphere.wim.util.UniqueIdGenerator;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.db.DBAccount;
import com.ibm.ws.wim.adapter.db.DBEntity;
import com.ibm.ws.wim.adapter.db.DBEntityIdEntityType;
import com.ibm.ws.wim.adapter.db.DBExtIdReposId;
import com.ibm.ws.wim.adapter.db.DBPropertyCache;
import com.ibm.ws.wim.adapter.db.PropertyToUpdate;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.dao.QuerySet;
import com.ibm.ws.wim.dao.schema.DBDataType;
import com.ibm.ws.wim.dao.schema.DBRepositoryProperty;
import com.ibm.ws.wim.util.AsyncUtils;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.ws.wim.util.PasswordEncryptionUtil;
import com.ibm.ws.wim.util.SearchParameter;
import com.ibm.ws.wim.util.UniqueNameHelper;
import com.ibm.ws.wim.xpath.ParseException;
import com.ibm.ws.wim.xpath.TokenMgrError;
import com.ibm.ws.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.wim.xpath.db.util.DBXPathTranslateHelper;
import com.ibm.ws.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.wsspi.wim.Repository;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DBAdapter
implements Repository,
DynamicConfigService {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DBAdapter.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private DataAccessObject dao = null;
    private DBPropertyCache propertyManager = null;
    private ProfileService ps = null;
    private int entityRetrievalLimit = 200;
    private int saltLength = 12;
    private String encryptionKey = "rZ15ws0ely9yHk3zCs3sTMv/ho8fY17s";
    private String ENCRYPTION_KEY = "1234567890abcdef";
    private List loginProperties = null;
    private String reposId = null;
    private SchemaManager schemaMgr = null;
    private ConfigManager configMgr = null;
    private String namespace = "http://www.ibm.com/websphere/wim";

    public void initialize(DataObject dataObject) throws WIMException {
        Object object;
        int n;
        List list;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        block23: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "WIM_SPI initialize (DataObject reposConfig)");
            }
            if (dataObject == null) {
                throw new WIMSystemException("LOAD_DATAGRAPH_FAILED", WIMMessageHelper.generateMsgParms("Database repository configuration is not defined."), CLASSNAME, "initialize (DataObject reposConfig)");
            }
            this.schemaMgr = SchemaManager.singleton();
            this.configMgr = ConfigManager.singleton();
            this.reposId = dataObject.getString("id");
            string6 = dataObject.getString("databaseType");
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize (DataObject reposConfig)", "dbType is " + string6);
            }
            string5 = dataObject.getString("dataSourceName");
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize (DataObject reposConfig)", "datasource name is " + string5);
            }
            string4 = dataObject.getString("dbURL");
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize (DataObject reposConfig)", "dbURL is " + string4);
            }
            string3 = dataObject.getString("dbAdminId");
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize (DataObject reposConfig)", "userId is " + string3);
            }
            string2 = dataObject.getString("dbAdminPassword");
            string = dataObject.getString("JDBCDriverClass");
            if (dataObject.isSet("entityRetrievalLimit")) {
                this.entityRetrievalLimit = dataObject.getInt("entityRetrievalLimit");
            }
            if (dataObject.isSet("saltLength")) {
                this.saltLength = dataObject.getInt("saltLength");
            }
            PasswordEncryptionUtil.setSaltLength(this.saltLength);
            String string7 = dataObject.getString("encryptionKey");
            if (string7 != null) {
                this.encryptionKey = string7;
                try {
                    this.ENCRYPTION_KEY = PasswordEncryptionUtil.decrypt(this.encryptionKey.trim(), null).trim();
                }
                catch (NullPointerException nullPointerException) {
                    this.ENCRYPTION_KEY = this.encryptionKey;
                    if (this.ENCRYPTION_KEY.length() == 16) break block23;
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "initialize (DataObject reposConfig)", "The length of encryption key needs to be 16 characters", nullPointerException);
                    }
                    throw new InvalidInitPropertyException("INVALID_INIT_PROPERTY", WIMMessageHelper.generateMsgParms("encryptionKey"), CLASSNAME, "initialize (DataObject reposConfig)");
                }
            }
        }
        if ((list = dataObject.getList("loginProperties")) != null && list.size() != 0) {
            this.loginProperties = new ArrayList();
            for (n = 0; n < list.size(); ++n) {
                this.loginProperties.add(list.get(n));
            }
        } else {
            List list2 = this.configMgr.getSupportedEntityTypes();
            for (int i = 0; i < list2.size(); ++i) {
                object = (String)list2.get(i);
                if (!this.schemaMgr.isSuperType("PersonAccount", (String)object)) continue;
                this.loginProperties = this.configMgr.getRDNProperties((String)object);
                break;
            }
        }
        this.dao = DAOHelper.getNewDAOClass(string6, string5, string4, string3, string2, string);
        this.propertyManager = new DBPropertyCache(this.dao);
        if (this.loginProperties != null && this.loginProperties.size() > 0) {
            for (n = 0; n < this.loginProperties.size(); ++n) {
                String string8 = (String)this.loginProperties.get(n);
                if (this.propertyManager.getPropertyDefinition(string8) != null) continue;
                object = this.propertyManager.getSupportedAttributes("PersonAccount");
                String string9 = null;
                if (object != null) {
                    string9 = "[";
                    Iterator iterator = object.iterator();
                    boolean bl = true;
                    while (iterator.hasNext()) {
                        if (bl) {
                            bl = false;
                        } else {
                            string9 = string9 + ", ";
                        }
                        string9 = string9 + (String)iterator.next();
                    }
                    string9 = string9 + "]";
                }
                throw new WIMConfigurationException("CONFIG_VALUE_NOT_VALID", WIMMessageHelper.generateMsgParms(string8, "loginProperties", string9), CLASSNAME, "initialize (DataObject reposConfig)");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI initialize (DataObject reposConfig)");
        }
    }

    public DataObject create(DataObject dataObject) throws WIMException {
        DataObject dataObject2;
        int n;
        Object object;
        List list;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI create(DataObject inRoot)", WIMTraceHelper.printDataObject(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.reposId, CLASSNAME, "create(DataObject inRoot)");
        DataObject dataObject3 = null;
        dataObject3 = this.schemaMgr.createRootDataObject();
        List list2 = dataObject.getList("entities");
        DataObject dataObject4 = (DataObject)list2.get(0);
        String string = dataObject4.getDataObject("identifier").getString("uniqueName");
        String string2 = this.schemaMgr.getQualifiedTypeName(dataObject4.getType());
        if (this.schemaMgr.isSuperType("PersonAccount", string2)) {
            if (dataObject4.isSet("principalName")) {
                throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", this.reposId), CLASSNAME, "create(DataObject inRoot)");
            }
            if (dataObject4.isSet("realm")) {
                throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("realm", this.reposId), CLASSNAME, "create(DataObject inRoot)");
            }
        }
        if (dataObject4.isSet("createTimestamp")) {
            throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms("createTimestamp", CLASSNAME, "create(DataObject inRoot)"));
        }
        if (dataObject4.isSet("modifyTimestamp")) {
            throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms("modifyTimestamp", CLASSNAME, "create(DataObject inRoot)"));
        }
        String string3 = UniqueIdGenerator.newUniqueId();
        dataObject4.getDataObject("identifier").setString("uniqueId", string3);
        DBEntity dBEntity = new DBEntity();
        dBEntity.setUniqueName(string);
        dBEntity.setEntityType(string2);
        dBEntity.setUniqueId(string3);
        long l = this.dao.createDBEntity(dBEntity);
        DataObject dataObject5 = dataObject4.getDataObject("parent");
        String string4 = dataObject5.getDataObject("identifier").getString("uniqueName");
        String string5 = dataObject5.getDataObject("identifier").getString("uniqueId");
        DBEntity dBEntity2 = new DBEntity();
        dBEntity2.setUniqueName(string4);
        dBEntity2.setUniqueId(string5);
        this.dao.createParentRelationship(l, dBEntity2);
        long l2 = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l2);
        dataObject4.set("createTimestamp", (Object)timestamp);
        dataObject4.set("modifyTimestamp", (Object)timestamp);
        this.createProperties(l, dataObject4);
        if (dataObject4.isSet("groups") && (list = dataObject4.getList("groups")).size() > 0) {
            object = new ArrayList();
            for (n = 0; n < list.size(); ++n) {
                dataObject2 = ((DataObject)list.get(n)).getDataObject("identifier");
                object.add(dataObject2);
            }
            this.dao.createGroupRelationsForEntity(this.reposId, string3, (List)object);
        }
        if (this.schemaMgr.isSuperType("Group", string2) && dataObject4.isSet("members") && (list = dataObject4.getList("members")).size() > 0) {
            object = new ArrayList();
            for (n = 0; n < list.size(); ++n) {
                dataObject2 = ((DataObject)list.get(n)).getDataObject("identifier");
                object.add(dataObject2);
            }
            this.dao.createGroupRelationsForGroup(l, (List)object, this.reposId);
        }
        list = dataObject3.createDataObject("entities", dataObject4.getType().getURI(), dataObject4.getType().getName());
        object = list.createDataObject("identifier");
        object.setString("uniqueName", string);
        object.setString("uniqueId", string3);
        object.setString("externalName", string);
        object.setString("externalId", string3);
        object.setString("repositoryId", this.reposId);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI create(DataObject inRoot)", WIMTraceHelper.printDataObject(dataObject3));
        }
        return dataObject3;
    }

    public DataObject get(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI get(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.reposId, CLASSNAME, "get(DataObject)");
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        DataObject dataObject3 = null;
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject4 = (DataObject)map.get("PropertyControl");
        DataObject dataObject5 = (DataObject)map.get("GroupMemberControl");
        DataObject dataObject6 = (DataObject)map.get("GroupMembershipControl");
        DataObject dataObject7 = (DataObject)map.get("AncestorControl");
        DataObject dataObject8 = (DataObject)map.get("DescendantControl");
        DataObject dataObject9 = (DataObject)map.get("CheckGroupMembershipControl");
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = null;
        List list = null;
        if (dataObject4 != null) {
            arrayList = dataObject4.getList("properties");
            list = dataObject4.getList("contextProperties");
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject10 = (DataObject)list.get(i);
                arrayList.add(dataObject10.getString("value"));
            }
        } else {
            arrayList = new ArrayList<String>();
        }
        stringArray = arrayList.toArray(stringArray);
        List list2 = dataObject.getList("entities");
        for (int i = 0; i < list2.size(); ++i) {
            List list3;
            String[] stringArray2;
            DataObject dataObject11 = (DataObject)list2.get(i);
            String[] stringArray3 = dataObject11.getType().getName();
            String string = null;
            String string2 = dataObject11.getDataObject("identifier").getString("externalId");
            String string3 = dataObject11.getDataObject("identifier").getString("uniqueName");
            String string4 = dataObject11.getDataObject("identifier").getString("repositoryId");
            string4 = string4 == null || string4.trim().length() == 0 ? this.reposId : string4.trim();
            DBEntity dBEntity = null;
            if (string4.equalsIgnoreCase(this.reposId)) {
                List list4;
                String string5;
                Object object;
                int n;
                Object object2;
                int n2;
                string = string2;
                if (string != null && string.trim().length() != 0) {
                    dBEntity = this.dao.findDBEntityByUniqueId(string);
                } else if (string3 != null && string3.trim().length() != 0) {
                    dBEntity = this.dao.findDBEntityByUniqueNameKey(string3);
                }
                if (dBEntity == null) {
                    throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms("[" + string + "/" + string3 + "]"), CLASSNAME, "get(DataObject)");
                }
                stringArray3 = stringArray2 = dBEntity.getEntityType();
                dataObject3 = dataObject2.createDataObject("entities", this.schemaMgr.getTypeNsURI((String)stringArray2), this.schemaMgr.getTypeName((String)stringArray2));
                list3 = dataObject3.createDataObject("identifier");
                long l = dBEntity.getEntityId();
                list3.setString("uniqueId", dBEntity.getUniqueId());
                list3.setString("externalId", dBEntity.getUniqueId());
                list3.setString("uniqueName", dBEntity.getUniqueName());
                list3.setString("externalName", dBEntity.getUniqueName());
                list3.setString("repositoryId", this.reposId);
                if (string2 == null) {
                    string2 = dBEntity.getUniqueId();
                }
                if (stringArray.length > 0) {
                    this.getProperties(dataObject3, l, stringArray);
                }
                if (dataObject7 != null) {
                    n2 = dataObject7.getInt("level");
                    if (n2 == 0) {
                        n2 = dBEntity.getUniqueName().length();
                    }
                    long l2 = l;
                    object2 = dataObject3;
                    for (n = 0; n < n2 && (object = this.dao.findParent(l2)) != null; ++n) {
                        long l3 = ((DBEntity)object).getEntityId();
                        String string6 = ((DBEntity)object).getEntityType();
                        String string7 = ((DBEntity)object).getUniqueId();
                        String string8 = ((DBEntity)object).getUniqueName();
                        DataObject dataObject12 = object2.createDataObject("parent", this.schemaMgr.getTypeNsURI(string6), string6);
                        DataObject dataObject13 = dataObject12.createDataObject("identifier");
                        dataObject13.setString("uniqueName", string8);
                        dataObject13.setString("uniqueId", string7);
                        dataObject13.setString("externalName", string8);
                        dataObject13.setString("externalId", string7);
                        dataObject13.setString("repositoryId", this.reposId);
                        String[] stringArray4 = ControlsHelper.getPropertyNames(dataObject7);
                        if (stringArray4 != null && stringArray4.length != 0) {
                            this.getProperties(dataObject12, l3, stringArray4);
                        }
                        l2 = l3;
                        object2 = dataObject12;
                    }
                }
                if (dataObject8 != null) {
                    n2 = dataObject8.getInt("level");
                    List list5 = null;
                    string5 = dataObject8.getString("expression");
                    if (string5 != null) {
                        object2 = new WIMXPathInterpreter(new StringReader(string5));
                        try {
                            XPathNode xPathNode = ((WIMXPathInterpreter)object2).parse(null);
                        }
                        catch (ParseException parseException) {
                            throw new SearchControlException("MISSING_SEARCH_EXPRESSION", CLASSNAME, "get(DataObject)");
                        }
                        catch (TokenMgrError tokenMgrError) {
                            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string5), CLASSNAME, "get(DataObject)", (Throwable)tokenMgrError);
                        }
                        list5 = ((WIMXPathInterpreter)object2).getEntityTypes();
                    }
                    boolean bl = dataObject8.getBoolean("treeView");
                    String[] stringArray5 = ControlsHelper.getPropertyNames(dataObject8);
                    if (bl && n2 != 1) {
                        throw new OperationNotSupportedException("OPERATION_NOT_SUPPORTED_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("treeView", this.reposId), CLASSNAME, "get(DataObject)");
                    }
                    if (n2 == 0) {
                        object = this.dao.getAllDescendantsByUniqueNameKey(dBEntity.getTruncUniqueName(), list5);
                        this.getEntityInformationByEntityIds((List)object, stringArray5, dataObject3, "children");
                    } else {
                        object = new ArrayList();
                        if (n2 == 1) {
                            object = this.dao.getChildrenByUniqueNameKey(dBEntity.getTruncUniqueName(), list5);
                        } else {
                            object = this.dao.getChildrenByUniqueNameKey(dBEntity.getTruncUniqueName(), list5);
                            for (int j = 0; j < n2 - 1 && (list4 = this.dao.getChildrenByEntityIdList((List)object, list5)) != null; ++j) {
                                object.addAll(list4);
                            }
                        }
                        if (object != null) {
                            this.getEntityInformationByEntityIds((List)object, stringArray5, dataObject3, "children");
                        }
                    }
                }
                if (this.schemaMgr.isSuperType("Group", (String)stringArray3) && dataObject5 != null) {
                    List list6 = null;
                    String[] stringArray6 = ControlsHelper.getPropertyNames(dataObject5);
                    string5 = dataObject5.getString("expression");
                    if (string5 != null) {
                        object2 = new WIMXPathInterpreter(new StringReader(string5));
                        try {
                            XPathNode xPathNode = ((WIMXPathInterpreter)object2).parse(null);
                        }
                        catch (ParseException parseException) {
                            throw new SearchControlException("MISSING_SEARCH_EXPRESSION", CLASSNAME, "get(DataObject)");
                        }
                        catch (TokenMgrError tokenMgrError) {
                            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string5), CLASSNAME, "get(DataObject)", (Throwable)tokenMgrError);
                        }
                        list6 = ((WIMXPathInterpreter)object2).getEntityTypes();
                    }
                    int n3 = dataObject5.getInt("level");
                    n = dataObject5.getBoolean("treeView") ? 1 : 0;
                    object = dataObject5.getList("searchBases");
                    Set[] setArray = null;
                    if (n3 == 1) {
                        setArray = this.dao.getImmediateGroupMembers(l, list6, (List)object);
                    } else if (n3 == 0 && n == 0) {
                        setArray = this.dao.getNestedGroupMembers(l, list6, (List)object);
                    } else {
                        throw new OperationNotSupportedException("OPERATION_NOT_SUPPORTED_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("treeView", this.reposId), CLASSNAME, "get(DataObject)");
                    }
                    if (setArray[0] != null && setArray[0].size() != 0) {
                        list4 = this.getEntityIdsFromDBEntityIdEntityTypeSet(setArray[0]);
                        this.getEntityInformationByEntityIds(list4, stringArray6, dataObject3, "members");
                    }
                    if (setArray[1] != null && setArray[1].size() != 0) {
                        this.getOtherRepositoryGroupMembers(setArray[1], dataObject3);
                    }
                }
            } else if (dataObject6 != null) {
                String string9 = this.schemaMgr.getQualifiedTypeName(dataObject11.getType());
                dataObject3 = dataObject2.createDataObject("entities", this.schemaMgr.getTypeNsURI(string9), string9);
                list3 = dataObject3.createDataObject("identifier");
                list3.setString("uniqueId", dataObject11.getDataObject("identifier").getString("uniqueId"));
                list3.setString("externalId", dataObject11.getDataObject("identifier").getString("externalId"));
                list3.setString("uniqueName", dataObject11.getDataObject("identifier").getString("uniqueName"));
                list3.setString("externalName", dataObject11.getDataObject("identifier").getString("externalName"));
                list3.setString("repositoryId", dataObject11.getDataObject("identifier").getString("repositoryId"));
            }
            if (dataObject6 != null) {
                stringArray2 = ControlsHelper.getPropertyNames(dataObject6);
                list3 = dataObject6.getList("searchBases");
                int n = dataObject6.getInt("level");
                boolean bl = dataObject6.getBoolean("treeView");
                List list7 = null;
                if (n == 1) {
                    list7 = this.dao.getImmediateGroupsForEntity(string2, string4, list3);
                } else if (n == 0 && !bl) {
                    list7 = this.dao.getNestedGroupsForEntity(string2, string4, this.reposId, new ArrayList(), list3);
                } else {
                    throw new OperationNotSupportedException("OPERATION_NOT_SUPPORTED_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("treeView", this.reposId), CLASSNAME, "get(DataObject)");
                }
                this.getEntityInformationByEntityIds(list7, stringArray2, dataObject3, "groups");
            }
            if (dataObject9 == null) continue;
            int n = dataObject9.getInt("level");
            list3 = dataObject2.createDataObject("controls", "http://www.ibm.com/websphere/wim", "CheckGroupMembershipControl");
            list3.setBoolean("inGroup", this.isMemberInGroup(dBEntity, dataObject11, n));
        }
        this.setPrincipleName(dataObject2, arrayList);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI get(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMemberInGroup(DBEntity dBEntity, DataObject dataObject, int n) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isMemberInGroup");
        }
        boolean bl = false;
        List list = dataObject.getList("groups");
        if (list.size() > 0) {
            DataObject dataObject2 = (DataObject)list.get(0);
            DBEntity dBEntity2 = this.getDBEntityByIdentifier(dataObject2.getDataObject("identifier"));
            if (dBEntity2 == null) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(dataObject2.getString("uniqueName|uniqueId"), CLASSNAME, "isMemberInGroup"));
            }
            if (dBEntity != null) {
                bl = this.dao.isMemberInGroup(dBEntity2.getEntityId(), dBEntity.getUniqueId(), this.reposId, this.reposId, n);
            } else {
                String string = dataObject.getDataObject("identifier").getString("externalId");
                String string2 = dataObject.getDataObject("identifier").getString("repositoryId");
                if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0) throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", CLASSNAME, "isMemberInGroup");
                bl = this.dao.isMemberInGroup(dBEntity2.getEntityId(), string, string2, this.reposId, n);
            }
        } else if (dBEntity != null && this.schemaMgr.isSuperType("Group", dBEntity.getEntityType())) {
            List list2 = dataObject.getList("members");
            if (list2.size() > 0) {
                DataObject dataObject3 = (DataObject)list2.get(0);
                DBEntity dBEntity3 = this.getDBEntityByIdentifier(dataObject3.getDataObject("identifier"));
                if (dBEntity3 != null) {
                    bl = this.dao.isMemberInGroup(dBEntity.getEntityId(), dBEntity3.getUniqueId(), this.reposId, this.reposId, n);
                } else {
                    String string = dataObject3.getString("externalId");
                    String string3 = dataObject3.getString("repositoryId");
                    if (string == null || string.trim().length() == 0 || string3 == null || string3.trim().length() == 0) throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", CLASSNAME, "isMemberInGroup");
                    bl = this.dao.isMemberInGroup(dBEntity.getEntityId(), string, string3, this.reposId, n);
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!trcLogger.isLoggable(Level.FINER)) return bl;
        trcLogger.exiting(CLASSNAME, "isMemberInGroup");
        return bl;
    }

    private void getOtherRepositoryGroupMembers(Set set, DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getOtherRepositoryGroupMembers(Set extIdReposId, DataObject entity)");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EClass eClass = SchemaManager.singleton().getEClass("Entity");
            DataObject dataObject2 = (DataObject)EcoreUtil.create((EClass)eClass);
            DataObject dataObject3 = dataObject2.createDataObject("identifier");
            DBExtIdReposId dBExtIdReposId = (DBExtIdReposId)iterator.next();
            dataObject3.setString("externalId", dBExtIdReposId.getExtId());
            dataObject3.setString("repositoryId", dBExtIdReposId.getReposId().trim());
            dataObject.getList("members").add(dataObject2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getOtherRepositoryGroupMembers(Set extIdReposId, DataObject entity)");
        }
    }

    private List getEntityIdsFromDBEntityIdEntityTypeSet(Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getEntityIdsFromDBEntityIdEntityTypeSet(Set entIdEntType)");
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (DBEntityIdEntityType dBEntityIdEntityType : set) {
            arrayList.add(dBEntityIdEntityType.getEntId());
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getEntityIdsFromDBEntityIdEntityTypeSet(Set entIdEntType)");
        }
        return arrayList;
    }

    private void getEntityInformationByEntityIds(List list, String[] stringArray, DataObject dataObject, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getEntityInformationByEntityIds(List entityIdList, String[] propNames, DataObject entity, String DO_PROPERTYNAME)");
        }
        if (list == null || list.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = null;
        if (list != null && list.size() != 0) {
            stringBuffer = new StringBuffer(256);
            stringBuffer.append(this.dao.getQuerySet().ENTITY_ID_IN);
        }
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(list.get(i));
            if (i == list.size() - 1) continue;
            stringBuffer.append(this.dao.getQuerySet().COMMA);
        }
        stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        StringBuffer stringBuffer4 = null;
        StringBuffer stringBuffer5 = null;
        StringBuffer stringBuffer6 = null;
        StringBuffer stringBuffer7 = null;
        Object var13_13 = null;
        Object var14_14 = null;
        Object var15_15 = null;
        int n = 1;
        block10: for (int i = 0; i < stringArray.length; ++i) {
            DBRepositoryProperty dBRepositoryProperty = this.propertyManager.getPropertyDefinition(stringArray[i]);
            if (dBRepositoryProperty == null && stringArray[i].equals("principalName") && this.loginProperties != null && this.loginProperties.size() > 0) {
                dBRepositoryProperty = this.propertyManager.getPropertyDefinition((String)this.loginProperties.get(0));
            }
            if (dBRepositoryProperty == null || dBRepositoryProperty.isComposite()) continue;
            short s = DAOHelper.getDataTypeId(dBRepositoryProperty.getDataType());
            switch (s) {
                case 0: {
                    if (stringBuffer2 == null) {
                        stringBuffer2 = new StringBuffer(256);
                        n = (short)(n + 1);
                        stringBuffer2.append(dBRepositoryProperty.getPropId());
                        continue block10;
                    }
                    stringBuffer2.append(this.dao.getQuerySet().COMMA);
                    stringBuffer2.append(dBRepositoryProperty.getPropId());
                    continue block10;
                }
                case 3: {
                    if (stringBuffer3 == null) {
                        stringBuffer3 = new StringBuffer(256);
                        n = (short)(n + 1);
                        stringBuffer3.append(dBRepositoryProperty.getPropId());
                        continue block10;
                    }
                    stringBuffer3.append(this.dao.getQuerySet().COMMA);
                    stringBuffer3.append(dBRepositoryProperty.getPropId());
                    continue block10;
                }
                case 1: {
                    if (stringBuffer5 == null) {
                        stringBuffer5 = new StringBuffer(256);
                        n = (short)(n + 1);
                        stringBuffer5.append(dBRepositoryProperty.getPropId());
                        continue block10;
                    }
                    stringBuffer5.append(this.dao.getQuerySet().COMMA);
                    stringBuffer5.append(dBRepositoryProperty.getPropId());
                    continue block10;
                }
                case 2: {
                    if (stringBuffer4 == null) {
                        stringBuffer4 = new StringBuffer(256);
                        n = (short)(n + 1);
                        stringBuffer4.append(dBRepositoryProperty.getPropId());
                        continue block10;
                    }
                    stringBuffer4.append(this.dao.getQuerySet().COMMA);
                    stringBuffer4.append(dBRepositoryProperty.getPropId());
                    continue block10;
                }
                case 4: {
                    if (stringBuffer6 == null) {
                        stringBuffer6 = new StringBuffer(256);
                        n = (short)(n + 1);
                        stringBuffer6.append(dBRepositoryProperty.getPropId());
                        continue block10;
                    }
                    stringBuffer6.append(this.dao.getQuerySet().COMMA);
                    stringBuffer6.append(dBRepositoryProperty.getPropId());
                    continue block10;
                }
                case 5: {
                    continue block10;
                }
                case 6: {
                    if (stringBuffer7 == null) {
                        stringBuffer7 = new StringBuffer(256);
                        n = (short)(n + 1);
                        stringBuffer7.append(dBRepositoryProperty.getPropId());
                        continue block10;
                    }
                    stringBuffer7.append(this.dao.getQuerySet().COMMA);
                    stringBuffer7.append(dBRepositoryProperty.getPropId());
                    continue block10;
                }
                default: {
                    throw new WIMApplicationException("INVALID_PROPERTY_DATA_TYPE", WIMMessageHelper.generateMsgParms(dBRepositoryProperty.getDataType()), CLASSNAME, "getEntityInformationByEntityIds(List entityIdList, String[] propNames, DataObject entity, String DO_PROPERTYNAME)");
                }
            }
        }
        StringBuffer stringBuffer8 = new StringBuffer((stringBuffer.length() + 512) * n);
        stringBuffer8.append(this.dao.getQuerySet().findDBEntityGeneral);
        stringBuffer8.append(this.dao.getQuerySet().AND);
        stringBuffer8.append(stringBuffer);
        if (stringBuffer2 != null) {
            stringBuffer8.append(this.dao.getQuerySet().UNION);
            stringBuffer8.append(this.dao.getSpecificDatatypePropertyForEntitiesQuery((short)0));
            stringBuffer8.append(this.dao.getQuerySet().findDBPropertyIdIn);
            stringBuffer8.append(stringBuffer2);
            stringBuffer8.append(this.dao.getQuerySet().RIGHT_BRACKET);
            stringBuffer8.append(this.dao.getQuerySet().AND);
            stringBuffer8.append(stringBuffer);
        }
        if (stringBuffer3 != null) {
            stringBuffer8.append(this.dao.getQuerySet().UNION);
            stringBuffer8.append(this.dao.getSpecificDatatypePropertyForEntitiesQuery((short)3));
            stringBuffer8.append(this.dao.getQuerySet().findDBPropertyIdIn);
            stringBuffer8.append(stringBuffer3);
            stringBuffer8.append(this.dao.getQuerySet().RIGHT_BRACKET);
            stringBuffer8.append(this.dao.getQuerySet().AND);
            stringBuffer8.append(stringBuffer);
        }
        if (stringBuffer5 != null) {
            stringBuffer8.append(this.dao.getQuerySet().UNION);
            stringBuffer8.append(this.dao.getSpecificDatatypePropertyForEntitiesQuery((short)1));
            stringBuffer8.append(this.dao.getQuerySet().findDBPropertyIdIn);
            stringBuffer8.append(stringBuffer5);
            stringBuffer8.append(this.dao.getQuerySet().RIGHT_BRACKET);
            stringBuffer8.append(this.dao.getQuerySet().AND);
            stringBuffer8.append(stringBuffer);
        }
        if (stringBuffer4 != null) {
            stringBuffer8.append(this.dao.getQuerySet().UNION);
            stringBuffer8.append(this.dao.getSpecificDatatypePropertyForEntitiesQuery((short)2));
            stringBuffer8.append(this.dao.getQuerySet().findDBPropertyIdIn);
            stringBuffer8.append(stringBuffer4);
            stringBuffer8.append(this.dao.getQuerySet().RIGHT_BRACKET);
            stringBuffer8.append(this.dao.getQuerySet().AND);
            stringBuffer8.append(stringBuffer);
        }
        if (stringBuffer6 != null) {
            stringBuffer8.append(this.dao.getQuerySet().UNION);
            stringBuffer8.append(this.dao.getSpecificDatatypePropertyForEntitiesQuery((short)4));
            stringBuffer8.append(this.dao.getQuerySet().findDBPropertyIdIn);
            stringBuffer8.append(stringBuffer6);
            stringBuffer8.append(this.dao.getQuerySet().RIGHT_BRACKET);
            stringBuffer8.append(this.dao.getQuerySet().AND);
            stringBuffer8.append(stringBuffer);
        }
        stringBuffer8.append(this.dao.getQuerySet().findSpecificPropertyForEntitiesOrderBy);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.log(Level.FINER, stringBuffer8.toString());
        }
        this.dao.getDBEntityInformation(stringBuffer8.toString(), dataObject, string, this.reposId);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getEntityInformationByEntityIds(List entityIdList, String[] propNames, DataObject entity, String DO_PROPERTYNAME)");
        }
    }

    private void getProperties(DataObject dataObject, long l, String[] stringArray) throws WIMException {
        String string;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getProperties(DataObject entity, long entityId, String[] propNames, DataObject propCtrl)");
        }
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        StringBuffer stringBuffer4 = null;
        StringBuffer stringBuffer5 = null;
        StringBuffer stringBuffer6 = null;
        StringBuffer stringBuffer7 = null;
        StringBuffer stringBuffer8 = null;
        boolean bl = false;
        boolean[] blArray = null;
        if (stringArray != null) {
            block9: for (int i = 0; i < stringArray.length; ++i) {
                DBRepositoryProperty dBRepositoryProperty;
                string = stringArray[i];
                if (string.equals("*")) {
                    this.dao.readAllDBPropertiesForEntity(l, dataObject);
                }
                if ((dBRepositoryProperty = this.propertyManager.getPropertyDefinition(string)) == null && string.equals("principalName") && this.loginProperties != null && this.loginProperties.size() > 0) {
                    dBRepositoryProperty = this.propertyManager.getPropertyDefinition((String)this.loginProperties.get(0));
                }
                if (dBRepositoryProperty == null) continue;
                if (dBRepositoryProperty.isComposite()) {
                    if (!bl) {
                        blArray = new boolean[DAOHelper.types.length];
                        for (int j = 0; j < DAOHelper.types.length; ++j) {
                            blArray[j] = false;
                        }
                        bl = true;
                        stringBuffer8 = new StringBuffer(256);
                        stringBuffer8.append(dBRepositoryProperty.getPropId());
                    } else {
                        stringBuffer8.append(this.dao.getQuerySet().COMMA);
                        stringBuffer8.append(dBRepositoryProperty.getPropId());
                    }
                    this.appendCompositeProperty(dBRepositoryProperty, stringBuffer8, blArray);
                    continue;
                }
                String string2 = dBRepositoryProperty.getDataType();
                short s = DAOHelper.getDataTypeId(string2);
                switch (s) {
                    case 0: {
                        stringBuffer = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer);
                        continue block9;
                    }
                    case 3: {
                        stringBuffer2 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer2);
                        continue block9;
                    }
                    case 2: {
                        stringBuffer3 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer3);
                        continue block9;
                    }
                    case 1: {
                        stringBuffer4 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer4);
                        continue block9;
                    }
                    case 4: {
                        stringBuffer5 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer5);
                        continue block9;
                    }
                    case 5: {
                        stringBuffer6 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer6);
                        continue block9;
                    }
                    case 6: {
                        stringBuffer7 = this.buildGetPropertyQuery(s, dBRepositoryProperty.getPropId(), stringArray.length, stringBuffer7);
                    }
                }
            }
            if (stringBuffer != null) {
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readDBProperties(l, stringBuffer, (short)0, dataObject);
            }
            if (stringBuffer2 != null) {
                stringBuffer2.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readDBProperties(l, stringBuffer2, (short)3, dataObject);
            }
            if (stringBuffer3 != null) {
                stringBuffer3.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readDBProperties(l, stringBuffer3, (short)2, dataObject);
            }
            if (stringBuffer4 != null) {
                stringBuffer4.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readDBProperties(l, stringBuffer4, (short)1, dataObject);
            }
            if (stringBuffer5 != null) {
                stringBuffer5.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readDBProperties(l, stringBuffer5, (short)4, dataObject);
            }
            if (stringBuffer6 != null) {
                stringBuffer6.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readDBProperties(l, stringBuffer6, (short)5, dataObject);
            }
            if (stringBuffer7 != null) {
                stringBuffer7.append(this.dao.getQuerySet().RIGHT_BRACKET);
                this.dao.readDBProperties(l, stringBuffer7, (short)6, dataObject);
            }
        }
        if (bl) {
            HashMap<Long, DataObject> hashMap = new HashMap<Long, DataObject>();
            hashMap.put(new Long(l), dataObject);
            string = DAOHelper.buildEntityIdSQL(hashMap);
            this.dao.getCompositeProperties(hashMap, stringBuffer8.toString(), blArray, string, true);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getProperties(DataObject entity, long entityId, String[] propNames, DataObject propCtrl)");
        }
    }

    private StringBuffer buildGetPropertyQuery(short s, Integer n, int n2, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(256 + n2 * 8);
            stringBuffer.append(this.dao.getDBPropValuesByEntityQuery(s));
            stringBuffer.append(n);
        } else {
            stringBuffer.append(this.dao.getQuerySet().COMMA);
            stringBuffer.append(n);
        }
        return stringBuffer;
    }

    public DataObject delete(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI delete(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.reposId, CLASSNAME, "delete(DataObject)");
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject2 = (DataObject)map.get("DeleteControl");
        DataObject dataObject3 = (DataObject)map.get("GroupMembershipControl");
        DataObject dataObject4 = this.schemaMgr.createRootDataObject();
        List list = dataObject.getList("entities");
        DataObject dataObject5 = (DataObject)list.get(0);
        if (dataObject3 != null) {
            String string = dataObject5.getDataObject("identifier").getString("externalId");
            String string2 = dataObject5.getDataObject("identifier").getString("repositoryId");
            if (string != null && string2 != null) {
                DBExtIdReposId dBExtIdReposId = new DBExtIdReposId();
                dBExtIdReposId.setExtId(string);
                dBExtIdReposId.setReposId(string2);
                this.dao.unassignMemberFromAllGroups(dBExtIdReposId);
            }
        } else {
            boolean bl = false;
            if (dataObject2 != null) {
                bl = dataObject2.getBoolean("deleteDescendants");
            }
            HashSet hashSet = null;
            hashSet = new HashSet();
            String string = dataObject5.getDataObject("identifier").getString("uniqueName");
            if (string != null) {
                this.delete(string, hashSet, bl);
            }
            for (DBEntity dBEntity : hashSet) {
                String string3 = dBEntity.getEntityType();
                String string4 = this.schemaMgr.getTypeNsURI(string3);
                DataObject dataObject6 = dataObject4.createDataObject("entities", string4, this.schemaMgr.getTypeName(string3)).createDataObject("identifier");
                dataObject6.setString("uniqueName", dBEntity.getUniqueName());
                dataObject6.setString("uniqueId", dBEntity.getUniqueId());
                dataObject6.setString("externalName", dBEntity.getUniqueName());
                dataObject6.setString("externalId", dBEntity.getUniqueId());
                dataObject6.setString("repositoryId", this.reposId);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI delete(DataObject)", WIMTraceHelper.printDataObject(dataObject4));
        }
        return dataObject4;
    }

    private void delete(String string, Set set, boolean bl) throws WIMException {
        boolean bl2;
        if (!bl && (bl2 = this.dao.checkIfEntityHasDescendants(DAOHelper.getTruncatedUniqueName(string)))) {
            throw new EntityHasDescendantsException("ENTITY_HAS_DESCENDENTS", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "delete(String uniqueName, Set deletedSet, boolean deleteDescendant)");
        }
        List list = null;
        ArrayList<String> arrayList = null;
        DBEntity dBEntity = this.dao.findDBEntityByUniqueNameKey(DAOHelper.getTruncatedUniqueName(string));
        String string2 = null;
        Object var9_9 = null;
        if (dBEntity != null) {
            list = this.dao.findDBEntitysByParentName(string);
            if (list != null) {
                arrayList = new ArrayList<String>();
                for (int i = 0; i < list.size(); ++i) {
                    DBEntity dBEntity2 = (DBEntity)list.get(i);
                    arrayList.add(dBEntity2.getUniqueId());
                    set.add(dBEntity2);
                }
            }
            if (arrayList != null && arrayList.size() != 0) {
                Hashtable<String, ArrayList<String>> hashtable = new Hashtable<String, ArrayList<String>>();
                hashtable.put(this.reposId, arrayList);
                this.dao.deleteDBGroupRelation(hashtable);
            }
            this.dao.deleteEntityWithDescendants(string);
            if (var9_9 != null) {
                this.dao.deleteEntityWithDescendants(string2);
            }
        } else {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "delete(String uniqueName, Set deletedSet, boolean deleteDescendant)");
        }
    }

    private void updateChangeSummary(ChangeSummary changeSummary, DataObject dataObject) throws WIMException {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateChangeSummary(ChangeSummary changeSummary, DataObject outRoot)");
        }
        changeSummary.endLogging();
        List list = changeSummary.getChangedDataObjects();
        DataObject dataObject2 = null;
        dataObject2 = (DataObject)list.get(0);
        DataObject dataObject3 = dataObject2.getDataObject("identifier");
        DBEntity dBEntity = this.getDBEntityByIdentifier(dataObject3);
        long l = dBEntity.getEntityId();
        String string2 = dBEntity.getEntityType();
        Object var11_9 = null;
        long l2 = -1L;
        byte[] byArray = null;
        Hashtable[] hashtableArray = new Hashtable[7];
        for (ChangeSummary.Setting setting : changeSummary.getOldValues(dataObject2)) {
            object4 = setting.getProperty();
            object3 = new PropertyToUpdate();
            object2 = object4.getName();
            if (this.schemaMgr.isSuperType("PersonAccount", string2) && ((String)object2).equals("principalName")) {
                throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", this.reposId), CLASSNAME, "updateChangeSummary(ChangeSummary changeSummary, DataObject outRoot)");
            }
            if (((String)object2).equals("password")) {
                byArray = dataObject2.getBytes(object4);
            }
            string = this.propertyManager.getPropertyDefinition((String)object2).getDataType();
            object = this.propertyManager.getPropertyDefinition((String)object2).getPropId();
            short s = DAOHelper.getDataTypeId(string);
            ((PropertyToUpdate)object3).setName((String)object2);
            ((PropertyToUpdate)object3).setOldValue(setting.getValue());
            ((PropertyToUpdate)object3).setNewValue(dataObject2.get(object4));
            hashtableArray[s].put(object, object3);
        }
        long l3 = System.currentTimeMillis();
        object4 = new Timestamp(l3);
        object3 = this.propertyManager.getPropertyDefinition("modifyTimestamp").getPropId();
        object2 = new PropertyToUpdate();
        ((PropertyToUpdate)object2).setName("modifyTimestamp");
        ((PropertyToUpdate)object2).setNewValue(object4);
        hashtableArray[4].put(object3, object2);
        this.dao.updateProperties((short)0, l, hashtableArray);
        if (byArray != null) {
            string = null;
            object = null;
            if (byArray != null) {
                string = PasswordEncryptionUtil.generateSalt(this.saltLength);
                object = this.encrypt(byArray, string);
            }
            this.dao.updateAccount(l, (byte[])object, string, null, null);
        }
        string = SDOHelper.createEntityDataObject(dataObject, this.schemaMgr.getTypeNsURI(string2), this.schemaMgr.getTypeName(string2));
        object = string.createDataObject("identifier");
        object.set("uniqueName", (Object)dataObject2.getDataObject("identifier").getString("uniqueName"));
        object.set("externalName", (Object)dataObject2.getDataObject("identifier").getString("externalName"));
        object.set("uniqueId", (Object)dataObject2.getDataObject("identifier").getString("uniqueId"));
        object.set("externalId", (Object)dataObject2.getDataObject("identifier").getString("externalId"));
        object.set("repositoryId", (Object)this.reposId);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI updateChangeSummary(ChangeSummary changeSummary, DataObject outRoot)", WIMTraceHelper.printDataGraph(dataObject));
        }
    }

    public DataObject update(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI update(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.reposId, CLASSNAME, "update(DataObject)");
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        if (changeSummary.isLogging()) {
            this.updateChangeSummary(changeSummary, dataObject2);
        } else {
            List list = dataObject.getList("entities");
            DataObject dataObject3 = (DataObject)list.get(0);
            Map map = ControlsHelper.getControlMap(dataObject);
            DBExtIdReposId dBExtIdReposId = new DBExtIdReposId();
            long l = 0L;
            String string = dataObject3.getDataObject("identifier").getString("repositoryId");
            if (string == null) {
                string = this.reposId;
            }
            dBExtIdReposId.setReposId(string);
            if (!string.equals(this.reposId)) {
                List list2;
                String string2 = dataObject3.getDataObject("identifier").getString("externalId");
                dBExtIdReposId.setExtId(string2);
                DataObject dataObject4 = (DataObject)map.get("GroupMembershipControl");
                int n = 1;
                if (dataObject4 != null) {
                    n = dataObject4.getInt("modifyMode");
                }
                if ((list2 = dataObject3.getList("groups")) != null && list2.size() != 0) {
                    this.groupMembershipUpdate(list2, dBExtIdReposId, n);
                }
            } else {
                List list3;
                int n;
                DataObject dataObject5;
                DBEntity dBEntity = null;
                String string3 = null;
                String string4 = dataObject3.getDataObject("identifier").getString("externalId");
                String string5 = null;
                if (string4 != null && string4.trim().length() != 0) {
                    dBEntity = this.dao.findDBEntityByUniqueId(string4);
                } else {
                    string5 = dataObject3.getDataObject("identifier").getString("externalName");
                    if (string5 == null || string5.trim().length() == 0) {
                        string5 = dataObject3.getDataObject("identifier").getString("uniqueName");
                    }
                    if (string5 != null && string5.trim().length() != 0) {
                        dBEntity = this.dao.findDBEntityByUniqueNameKey(string5);
                    }
                }
                if (dBEntity == null) {
                    throw new InvalidIdentifierException("INVALID_IDENTIFIER", WIMMessageHelper.generateMsgParms("[" + string4 + "/" + string5 + "]"), CLASSNAME, "update(DataObject)");
                }
                dBExtIdReposId.setExtId(dBEntity.getUniqueId());
                l = dBEntity.getEntityId();
                string3 = dBEntity.getEntityType();
                if (this.schemaMgr.isSuperType("PersonAccount", this.schemaMgr.getQualifiedTypeName(dataObject3.getType())) && dataObject3.isSet("principalName")) {
                    throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", this.reposId), CLASSNAME, "update(DataObject)");
                }
                if (dataObject3.isSet("createTimestamp")) {
                    throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms("createTimestamp", CLASSNAME, "update(DataObject)"));
                }
                if (dataObject3.isSet("modifyTimestamp")) {
                    throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms("modifyTimestamp", CLASSNAME, "update(DataObject)"));
                }
                string5 = dBEntity.getTruncUniqueName();
                List list4 = this.configMgr.getRDNProperties(string3);
                dataObject3.getDataObject("identifier").set("uniqueName", (Object)dBEntity.getUniqueName());
                dataObject3.getDataObject("identifier").set("externalName", (Object)dBEntity.getUniqueName());
                dataObject3.getDataObject("identifier").set("uniqueId", (Object)dBEntity.getUniqueId());
                dataObject3.getDataObject("identifier").set("externalId", (Object)dBEntity.getUniqueId());
                dataObject3.getDataObject("identifier").set("repositoryId", (Object)this.reposId);
                this.updateProperties(dBEntity.getEntityId(), list4, dataObject3, false);
                if (dataObject3.isSet("groups")) {
                    dataObject5 = (DataObject)map.get("GroupMembershipControl");
                    n = 1;
                    if (dataObject5 != null) {
                        n = dataObject5.getInt("modifyMode");
                    }
                    list3 = dataObject3.getList("groups");
                    this.groupMembershipUpdate(list3, dBExtIdReposId, n);
                }
                if (this.schemaMgr.isSuperType("Group", string3) && dataObject3.isSet("members")) {
                    dataObject5 = (DataObject)map.get("GroupMemberControl");
                    n = 1;
                    if (dataObject5 != null) {
                        n = dataObject5.getInt("modifyMode");
                    }
                    list3 = dataObject3.getList("members");
                    this.groupMemberUpdate(list3, l, n);
                }
                dataObject5 = SDOHelper.createEntityDataObject(dataObject2, this.schemaMgr.getTypeNsURI(string3), this.schemaMgr.getTypeName(string3));
                DataObject dataObject6 = dataObject5.createDataObject("identifier");
                dataObject6.set("uniqueName", (Object)dataObject3.getDataObject("identifier").getString("uniqueName"));
                dataObject6.set("externalName", (Object)dataObject3.getDataObject("identifier").getString("externalName"));
                dataObject6.set("uniqueId", (Object)dataObject3.getDataObject("identifier").getString("uniqueId"));
                dataObject6.set("externalId", (Object)dataObject3.getDataObject("identifier").getString("externalId"));
                dataObject6.set("repositoryId", (Object)this.reposId);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI update(DataObject)", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    private void updateProperties(long l, List list, DataObject dataObject, boolean bl) throws WIMException {
        Object object;
        int n;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateProperties(long entId, List rdnProp, DataObject entity)");
        }
        Object var7_5 = null;
        Object var8_6 = null;
        long l2 = -1L;
        Hashtable[] hashtableArray = new Hashtable[7];
        Hashtable[] hashtableArray2 = new Hashtable[7];
        Hashtable<Integer, Object> hashtable = null;
        byte[] byArray = null;
        boolean bl2 = false;
        boolean bl3 = false;
        EClass eClass = this.schemaMgr.getEClass(dataObject.getType());
        EList eList = eClass.getEAllStructuralFeatures();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (n = 0; n < list.size(); ++n) {
            object = ((String)list.get(n)).toLowerCase();
            arrayList.add(n, (String)object);
        }
        for (n = 0; n < eList.size(); ++n) {
            Object object2;
            DBRepositoryProperty dBRepositoryProperty;
            object = (EStructuralFeature)eList.get(n);
            Property property = this.schemaMgr.getProperty((EStructuralFeature)object);
            String string = this.schemaMgr.getQualifiedPropertyName((EStructuralFeature)object);
            if (!dataObject.isSet(property) || !this.isPersistentProperty(string) || (dBRepositoryProperty = this.propertyManager.getPropertyDefinition(string)) == null) continue;
            Integer n2 = dBRepositoryProperty.getPropId();
            String string2 = dBRepositoryProperty.getDataType();
            short s = DAOHelper.getDataTypeId(string2);
            if (this.propertyManager.isCompositeProperty(string)) {
                if (hashtable == null) {
                    hashtable = new Hashtable<Integer, Object>();
                }
                object2 = new Object[2];
                if (this.propertyManager.isMultivaluedProperty(string)) {
                    object2[0] = string;
                    object2[1] = dataObject.getList(property);
                } else {
                    object2[0] = string;
                    object2[1] = dataObject.get(property);
                }
                hashtable.put(n2, object2);
                continue;
            }
            if (this.propertyManager.isMultivaluedProperty(string)) {
                if (hashtableArray2[s] == null) {
                    hashtableArray2[s] = new Hashtable();
                }
                hashtableArray2[s].put(n2, dataObject.getList(property));
                bl3 = true;
                continue;
            }
            if (string.equalsIgnoreCase("password")) {
                byArray = dataObject.getBytes(string);
                continue;
            }
            if (arrayList.contains(string.toLowerCase())) {
                if (hashtableArray[s] == null) {
                    hashtableArray[s] = new Hashtable();
                }
                object2 = new PropertyToUpdate();
                ((PropertyToUpdate)object2).setName(string);
                ((PropertyToUpdate)object2).setNewValue(dataObject.get(property));
                hashtableArray[s].put(n2, object2);
                bl2 = true;
                String string3 = this.dao.renameEntity(l, (String)((PropertyToUpdate)object2).getNewValue());
                dataObject.getDataObject("identifier").setString("uniqueName", string3);
                dataObject.getDataObject("identifier").setString("externalName", string3);
                if (l2 <= 0L) continue;
                this.dao.renameEntity(l2, (String)((PropertyToUpdate)object2).getNewValue());
                continue;
            }
            if (hashtableArray2[s] == null) {
                hashtableArray2[s] = new Hashtable();
            }
            hashtableArray2[s].put(n2, dataObject.get(property));
            bl3 = true;
        }
        if (bl2) {
            this.dao.updateProperties((short)0, l, hashtableArray);
        }
        if (bl3) {
            this.dao.replaceProperties((short)0, l, hashtableArray2, this.propertyManager.getMultiValuePropertyIds(), this.reposId);
        }
        if (byArray != null) {
            String string = PasswordEncryptionUtil.generateSalt(this.saltLength);
            object = this.encrypt(byArray, string);
            this.dao.updateAccount(l, (byte[])object, string, null, null);
            PasswordUtil.erasePassword(byArray);
        }
        if (hashtable != null) {
            this.replaceCompositeProperties(l, hashtable);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateProperties(long entId, List rdnProp, DataObject entity)");
        }
    }

    private void replaceCompositeProperties(long l, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "replaceCompositeProperties(long entId, Hashtable compProps)");
        }
        this.dao.deleteCompositeProperties((short)0, l, hashtable);
        this.createCompositeProperties(l, hashtable, this.propertyManager.getMultiValuePropertyIds());
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "replaceCompositeProperties(long entId, Hashtable compProps)");
        }
    }

    private boolean isPersistentProperty(String string) {
        boolean bl = true;
        return !"identifier".equals(string) && !"partyRoles".equals(string) && !"parent".equals(string) && !"children".equals(string) && !"accounts".equals(string) && !"groups".equals(string) && !"entitlementInfo".equals(string) && !"groups".equals(string) && !"children".equals(string) && !"members".equals(string);
    }

    private void groupMembershipUpdate(List list, DBExtIdReposId dBExtIdReposId, int n) throws WIMException {
        if (list != null && list.size() > 0) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject = ((DataObject)list.get(i)).getDataObject("identifier");
                DBEntity dBEntity = this.getDBEntityByIdentifier(dataObject);
                arrayList.add(new Long(dBEntity.getEntityId()));
            }
            if (n == 1) {
                this.dao.assignMemberToGroups(dBExtIdReposId, arrayList);
            } else if (n == 2) {
                this.dao.unassignMemberFromAllGroups(dBExtIdReposId);
                this.dao.assignMemberToGroups(dBExtIdReposId, arrayList);
            } else if (n == 3) {
                this.dao.unassignMemberFromGroups(dBExtIdReposId, arrayList);
            }
        }
    }

    private void groupMemberUpdate(List list, long l, int n) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "groupMemberUpdate(List members, long grpEntId, int mode)");
        }
        if (list != null && list.size() > 0) {
            ArrayList<DBExtIdReposId> arrayList = new ArrayList<DBExtIdReposId>();
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject = ((DataObject)list.get(i)).getDataObject("identifier");
                DBExtIdReposId dBExtIdReposId = null;
                DBEntity dBEntity = null;
                try {
                    dBEntity = this.getDBEntityByIdentifier(dataObject);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    dBEntity = null;
                }
                if (dBEntity != null) {
                    dBExtIdReposId = new DBExtIdReposId();
                    dBExtIdReposId.setExtId(dBEntity.getUniqueId());
                    dBExtIdReposId.setReposId(this.reposId);
                } else {
                    String string = dataObject.getString("externalId");
                    String string2 = dataObject.getString("repositoryId");
                    if (string != null && string2 != null) {
                        dBExtIdReposId = new DBExtIdReposId();
                        dBExtIdReposId.setExtId(string);
                        dBExtIdReposId.setReposId(string2);
                    } else {
                        throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(dataObject.getString("uniqueName") + "/" + dataObject.getString("uniqueId")), CLASSNAME, "groupMemberUpdate(List members, long grpEntId, int mode)");
                    }
                }
                if (dBExtIdReposId == null) continue;
                arrayList.add(dBExtIdReposId);
            }
            if (n == 1) {
                this.dao.assignMembersToGroup(arrayList, l);
            } else if (n == 2) {
                this.dao.unassignAllMembersFromGroup(l);
                this.dao.assignMembersToGroup(arrayList, l);
            } else if (n == 3) {
                this.dao.unassignMembersFromGroup(arrayList, l, this.reposId);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "groupMemberUpdate(List members, long grpEntId, int mode)");
        }
    }

    private DBEntity getDBEntityByIdentifier(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getDBEntityByIdentifier(DataObject identifier)");
        }
        String string = dataObject.getString("externalId");
        String string2 = null;
        DBEntity dBEntity = null;
        if (string == null || string.length() == 0) {
            string = dataObject.getString("uniqueId");
        }
        if (string != null && string.trim().length() != 0) {
            dBEntity = this.dao.findDBEntityByUniqueId(string);
        } else {
            string2 = dataObject.getString("externalName");
            if (string2 == null || string2.trim().length() == 0) {
                string2 = dataObject.getString("uniqueName");
            }
            if (string2 != null && string2.trim().length() != 0) {
                dBEntity = this.dao.findDBEntityByUniqueNameKey(string2);
            }
        }
        if (dBEntity == null) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms("[" + string + "/" + string2 + "]"), CLASSNAME, "getDBEntityByIdentifier(DataObject identifier)");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDBEntityByIdentifier(DataObject identifier)");
        }
        return dBEntity;
    }

    public DataObject search(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI search(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.reposId, CLASSNAME, "search(DataObject)");
        DataObject dataObject2 = null;
        String string = null;
        Map map = null;
        try {
            String string2;
            Object object;
            Object object2;
            int n;
            Object object3;
            String string3;
            Object object4;
            Map map2 = ControlsHelper.getControlMap(dataObject);
            DataObject dataObject3 = (DataObject)map2.get("SearchControl");
            if (dataObject3 == null) {
                throw new MissingSearchControlException("MISSING_SEARCH_CONTROL", CLASSNAME, "search(DataObject)");
            }
            List list = dataObject3.getList("properties");
            string = dataObject3.getString("expression");
            if (string == null || string.length() == 0) {
                throw new SearchControlException("MISSING_SEARCH_EXPRESSION", CLASSNAME, "search(DataObject)");
            }
            List list2 = dataObject3.getList("searchBases");
            boolean bl = dataObject3.getBoolean("returnSubType");
            WIMXPathInterpreter wIMXPathInterpreter = new WIMXPathInterpreter(new StringReader(string));
            XPathNode xPathNode = wIMXPathInterpreter.parse(null);
            HashMap hashMap = new HashMap();
            List list3 = wIMXPathInterpreter.getEntityTypes();
            HashSet hashSet = new HashSet();
            if (bl) {
                for (int i = 0; i < list3.size(); ++i) {
                    object4 = this.schemaMgr.getSubEntityTypes((String)list3.get(i));
                    if (object4 != null) {
                        hashSet.addAll(object4);
                    }
                    hashSet.add((String)list3.get(i));
                }
            } else {
                hashSet.addAll(list3);
            }
            if (list.size() == 1 && (string3 = (String)list.get(0)).equals("*")) {
                list.clear();
                object4 = hashSet.iterator();
                while (object4.hasNext()) {
                    object3 = this.propertyManager.getSupportedAttributes((String)object4.next());
                    if (object3 == null) continue;
                    list.addAll(object3);
                }
            }
            StringBuffer stringBuffer = new StringBuffer(256);
            object4 = new boolean[DAOHelper.types.length];
            object3 = new StringBuffer(256);
            ArrayList<DBRepositoryProperty> arrayList = new ArrayList<DBRepositoryProperty>();
            for (n = 0; n < list.size(); n += 1) {
                object2 = (String)list.get(n);
                DBRepositoryProperty dBRepositoryProperty = this.propertyManager.getPropertyDefinition((String)object2);
                if (dBRepositoryProperty != null) {
                    arrayList.add(dBRepositoryProperty);
                    continue;
                }
                if (!((String)object2).equals("principalName") || this.loginProperties == null || this.loginProperties.size() <= 0 || (dBRepositoryProperty = this.propertyManager.getPropertyDefinition((String)this.loginProperties.get(0))) == null) continue;
                arrayList.add(dBRepositoryProperty);
            }
            n = 0;
            if (arrayList == null || arrayList.size() == 0) {
                n = 1;
            }
            dataObject2 = this.schemaMgr.createRootDataObject();
            object2 = null;
            boolean bl2 = false;
            String string4 = null;
            String string5 = null;
            if (xPathNode != null) {
                object2 = xPathNode.getPropertyNodes(hashMap);
            }
            if (object2 != null) {
                while (object2.hasNext()) {
                    object = (PropertyNode)object2.next();
                    string2 = ((PropertyNode)object).getName();
                    if (!string2.equals("principalName")) continue;
                    if (hashMap.size() > 1) {
                        throw new SearchControlException("CANNOT_SEARCH_PRINCIPAL_NAME_WITH_OTHER_PROPS", CLASSNAME, "search(DataObject)");
                    }
                    bl2 = true;
                    string4 = (String)((PropertyNode)object).getValue();
                    string5 = ((PropertyNode)object).getOperator();
                }
            }
            if (bl2) {
                map = this.searchByPrincipalName(hashSet, string4, string5, list2, arrayList, dataObject2, (boolean[])object4, stringBuffer, (StringBuffer)object3);
            } else {
                object = new ArrayList();
                string2 = this.buildSearchConditionWhereClause(hashSet, xPathNode, (List)object, list2);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "search(DataObject)", "Search Condition WHERE: " + WIMTraceHelper.printObjectArray(new Object[]{string2}));
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                int n2 = this.searchString(stringBuffer2, string2, (List)object, arrayList, dataObject2, (boolean[])object4, stringBuffer, (StringBuffer)object3);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "search(DataObject)", "Search SQL " + WIMTraceHelper.printObjectArray(new Object[]{stringBuffer2.toString()}));
                }
                map = this.dao.search(stringBuffer2.toString(), (List)object, n != 0, dataObject2, this.reposId, n2);
            }
            object = dataObject2.getList("entities");
            if ((stringBuffer != null || object3 != null) && object.size() > 0) {
                string2 = DAOHelper.buildEntityIdSQL(map);
                if (stringBuffer.length() > 0) {
                    this.dao.getCompositeProperties(map, stringBuffer.toString(), (boolean[])object4, string2, true);
                }
                if (((StringBuffer)object3).length() > 0) {
                    this.dao.getObjectProperties(map, ((StringBuffer)object3).toString(), string2, true);
                }
            }
            this.setPrincipleName(dataObject2, list);
        }
        catch (ParseException parseException) {
            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "search(DataObject)", (Throwable)parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "search(DataObject)", (Throwable)tokenMgrError);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI search(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    private void setPrincipleName(DataObject dataObject, List list) {
        if (list != null && list.contains("principalName")) {
            List list2 = dataObject.getList("entities");
            for (int i = 0; i < list2.size(); ++i) {
                String string;
                String string2;
                Property property;
                DataObject dataObject2 = (DataObject)list2.get(i);
                Type type = dataObject2.getType();
                String string3 = this.schemaMgr.getQualifiedTypeName(type);
                if (this.loginProperties == null || this.loginProperties.size() <= 0 || (property = this.schemaMgr.getProperty(type, string2 = (String)this.loginProperties.get(0))) == null) continue;
                if (this.schemaMgr.isSuperType("LoginAccount", string3) && (string = dataObject2.getString(property)) != null) {
                    dataObject2.setString("principalName", string);
                }
                if (list.contains(string2)) continue;
                dataObject2.unset(property);
            }
        }
    }

    private String getRDNValue(String string) {
        String string2 = null;
        if (string != null) {
            String string3 = string;
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            while (!bl) {
                n = string.indexOf(",");
                n2 = string.indexOf("\\");
                if (n2 == n - 1) {
                    string3 = string.substring(n);
                    continue;
                }
                bl = true;
            }
            string3 = string.substring(0, n);
            int n3 = string3.indexOf("=");
            string2 = string3.substring(n3 + 1);
        }
        return string2;
    }

    private String buildUniqueIdSQL(List list) {
        StringBuffer stringBuffer = new StringBuffer(256);
        DataObject dataObject = ((DataObject)list.get(0)).getDataObject("identifier");
        String string = dataObject.getString("externalId");
        stringBuffer.append(this.dao.getQuerySet().SINGLE_QUOTE);
        stringBuffer.append(DAOHelper.formatValueForDB(string));
        stringBuffer.append(this.dao.getQuerySet().SINGLE_QUOTE);
        for (int i = 1; i < list.size(); ++i) {
            stringBuffer.append(this.dao.getQuerySet().COMMA);
            dataObject = ((DataObject)list.get(i)).getDataObject("identifier");
            string = dataObject.getString("externalId");
            stringBuffer.append(this.dao.getQuerySet().SINGLE_QUOTE);
            stringBuffer.append(DAOHelper.formatValueForDB(string));
            stringBuffer.append(this.dao.getQuerySet().SINGLE_QUOTE);
        }
        return stringBuffer.toString();
    }

    private int searchString(StringBuffer stringBuffer, String string, List list, List list2, DataObject dataObject, boolean[] blArray, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws WIMException {
        String string2 = "http://www.ibm.com/websphere/wim";
        int n = 1;
        int n2 = 1;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchString(StringBuffer sql, String conditionWhere, List parameters, List returnPropDefs, DataObject returnRT)", WIMTraceHelper.printObjectArray(new Object[]{stringBuffer, string, list, list2, dataObject, stringBuffer2, stringBuffer3}));
        }
        if (list2 == null || list2.size() == 0) {
            stringBuffer.ensureCapacity(256 + string.length());
            stringBuffer.append(this.dao.getQuerySet().searchDBNoResultPropertyWhere);
            stringBuffer.append(string);
        } else {
            DBRepositoryProperty dBRepositoryProperty = null;
            StringBuffer stringBuffer4 = null;
            StringBuffer stringBuffer5 = null;
            StringBuffer stringBuffer6 = null;
            StringBuffer stringBuffer7 = null;
            StringBuffer stringBuffer8 = null;
            StringBuffer stringBuffer9 = null;
            boolean bl = false;
            block9: for (int i = 0; i < list2.size(); ++i) {
                dBRepositoryProperty = (DBRepositoryProperty)list2.get(i);
                if (dBRepositoryProperty.getParentCompositeName() != null && trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "searchString(StringBuffer sql, String conditionWhere, List parameters, List returnPropDefs, DataObject returnRT)", "A component property '" + dBRepositoryProperty.getName() + "' that is part of a composite property was specified stand alone.");
                }
                if (dBRepositoryProperty.isComposite()) {
                    if (!bl) {
                        for (int j = 0; j < DAOHelper.types.length; ++j) {
                            blArray[j] = false;
                        }
                        bl = true;
                        stringBuffer2.append(dBRepositoryProperty.getPropId());
                    } else {
                        stringBuffer2.append(this.dao.getQuerySet().COMMA_AND_SPACE);
                        stringBuffer2.append(dBRepositoryProperty.getPropId());
                    }
                    this.appendCompositeProperty(dBRepositoryProperty, stringBuffer2, blArray);
                    continue;
                }
                String string3 = dBRepositoryProperty.getDataType();
                short s = DAOHelper.getDataTypeId(string3);
                switch (s) {
                    case 0: {
                        if (stringBuffer4 == null) {
                            stringBuffer4 = new StringBuffer(256);
                            ++n;
                            stringBuffer4.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer4.append(this.dao.getQuerySet().COMMA);
                        stringBuffer4.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 3: {
                        if (stringBuffer5 == null) {
                            stringBuffer5 = new StringBuffer(256);
                            ++n;
                            stringBuffer5.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer5.append(this.dao.getQuerySet().COMMA);
                        stringBuffer5.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 1: {
                        if (stringBuffer7 == null) {
                            stringBuffer7 = new StringBuffer(256);
                            ++n;
                            stringBuffer7.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer7.append(this.dao.getQuerySet().COMMA);
                        stringBuffer7.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 2: {
                        if (stringBuffer6 == null) {
                            stringBuffer6 = new StringBuffer(256);
                            ++n;
                            stringBuffer6.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer6.append(this.dao.getQuerySet().COMMA);
                        stringBuffer6.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 4: {
                        if (stringBuffer8 == null) {
                            stringBuffer8 = new StringBuffer(256);
                            ++n;
                            stringBuffer8.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer8.append(this.dao.getQuerySet().COMMA);
                        stringBuffer8.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 5: {
                        if (stringBuffer9 == null) {
                            stringBuffer9 = new StringBuffer(256);
                            ++n;
                            stringBuffer9.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer9.append(this.dao.getQuerySet().COMMA);
                        stringBuffer9.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    case 6: {
                        if (stringBuffer3.length() == 0) {
                            ++n;
                            stringBuffer3.append(dBRepositoryProperty.getPropId());
                            continue block9;
                        }
                        stringBuffer3.append(this.dao.getQuerySet().COMMA);
                        stringBuffer3.append(dBRepositoryProperty.getPropId());
                        continue block9;
                    }
                    default: {
                        throw new WIMApplicationException("INVALID_PROPERTY_DATA_TYPE", WIMMessageHelper.generateMsgParms(dBRepositoryProperty.getDataType()), CLASSNAME, "searchString(StringBuffer sql, String conditionWhere, List parameters, List returnPropDefs, DataObject returnRT)");
                    }
                }
            }
            stringBuffer.ensureCapacity((string.length() + 512) * n);
            stringBuffer.append(this.dao.getQuerySet().findDBEntityGeneral);
            stringBuffer.append(this.dao.getQuerySet().AND);
            stringBuffer.append(string);
            if (stringBuffer4 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findStringPropertyForEntities);
                stringBuffer.append(this.dao.getQuerySet().findDBPropertyIdIn);
                stringBuffer.append(stringBuffer4);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer5 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findIntegerPropertyForEntities);
                stringBuffer.append(this.dao.getQuerySet().findDBPropertyIdIn);
                stringBuffer.append(stringBuffer5);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer6 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findDoublePropertyForEntities);
                stringBuffer.append(this.dao.getQuerySet().findDBPropertyIdIn);
                stringBuffer.append(stringBuffer6);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer7 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findLongPropertyForEntities);
                stringBuffer.append(this.dao.getQuerySet().findDBPropertyIdIn);
                stringBuffer.append(stringBuffer7);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer8 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findTimestampPropertyForEntities);
                stringBuffer.append(this.dao.getQuerySet().findDBPropertyIdIn);
                stringBuffer.append(stringBuffer8);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            if (stringBuffer9 != null) {
                stringBuffer.append(this.dao.getQuerySet().UNION);
                stringBuffer.append(this.dao.getQuerySet().findReferencePropertyForEntities);
                stringBuffer.append(this.dao.getQuerySet().findDBPropertyIdIn);
                stringBuffer.append(stringBuffer9);
                stringBuffer.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer.append(this.dao.getQuerySet().AND);
                stringBuffer.append(string);
                ++n2;
            }
            stringBuffer.append(this.dao.getQuerySet().findSpecificPropertyForEntitiesOrderBy);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "searchString(StringBuffer sql, String conditionWhere, List parameters, List returnPropDefs, DataObject returnRT)", WIMTraceHelper.printObjectArray(new Object[]{new Integer(n2)}));
        }
        return n2;
    }

    private String buildSearchByPrincipalNameConditionWhereClause(Set set, StringBuffer stringBuffer, StringBuffer stringBuffer2, List list) throws WIMApplicationException {
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "buildSearchByPrincipalNameConditionWhereClause(Set entTypes, StringBuffer fromClause, StringBuffer whereClause, List parameters, List searchBases)", WIMTraceHelper.printObjectArray(new Object[]{set, stringBuffer, stringBuffer2, list}));
        }
        StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.length() + stringBuffer2.length() + 128);
        stringBuffer3.append(this.dao.getQuerySet().searchDBEntitySubSelect);
        stringBuffer3.append(stringBuffer);
        stringBuffer3.append(stringBuffer2);
        stringBuffer3.append(this.dao.getQuerySet().AND);
        stringBuffer3.append(this.dao.getQuerySet().LEFT_BRACKET);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            stringBuffer3.append(this.dao.getQuerySet().searchDBEntityTypeCondition);
            object = (String)iterator.next();
            stringBuffer3.append((String)object);
            stringBuffer3.append(this.dao.getQuerySet().SINGLE_QUOTE);
        }
        while (iterator.hasNext()) {
            stringBuffer3.append(this.dao.getQuerySet().OR);
            stringBuffer3.append(this.dao.getQuerySet().searchDBEntityTypeCondition);
            object = (String)iterator.next();
            stringBuffer3.append((String)object);
            stringBuffer3.append(this.dao.getQuerySet().SINGLE_QUOTE);
        }
        stringBuffer3.append(this.dao.getQuerySet().RIGHT_BRACKET);
        if (list != null && list.size() > 0) {
            object = this.dao.getQuerySet();
            StringBuffer stringBuffer4 = new StringBuffer();
            boolean bl = false;
            stringBuffer4.append(((QuerySet)object).AND);
            stringBuffer4.append(((QuerySet)object).LEFT_BRACKET);
            for (int i = 0; i < list.size(); ++i) {
                int n = ((QuerySet)object).SEARCH_BASE_EXPRESSION.indexOf(63);
                if (bl) {
                    stringBuffer4.append(((QuerySet)object).OR);
                }
                StringBuffer stringBuffer5 = new StringBuffer(((QuerySet)object).SEARCH_BASE_EXPRESSION);
                String string = (String)list.get(i);
                stringBuffer5.replace(n, n + 1, UniqueNameHelper.formatUniqueName(string).toLowerCase());
                stringBuffer4.append(stringBuffer5);
                bl = true;
            }
            stringBuffer4.append(((QuerySet)object).RIGHT_BRACKET);
            stringBuffer3.append(stringBuffer4);
        }
        stringBuffer3.append(this.dao.getQuerySet().RIGHT_BRACKET);
        object = stringBuffer3.toString();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "buildSearchByPrincipalNameConditionWhereClause(Set entTypes, StringBuffer fromClause, StringBuffer whereClause, List parameters, List searchBases)", WIMTraceHelper.printObjectArray(new Object[]{object}));
        }
        return object;
    }

    private Map searchByPrincipalName(Set set, String string, String string2, List list, List list2, DataObject dataObject, boolean[] blArray, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws WIMException {
        Object object;
        short s;
        StringBuffer stringBuffer3 = new StringBuffer(256);
        StringBuffer stringBuffer4 = new StringBuffer(256);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = null;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchByPrincipalName(Set entTypes, String value, String operator, List searchBases, List props, DataObject returnRT, boolean[] compositeTypes, StringBuffer compositeQuery, StringBuffer objectQuery)", WIMTraceHelper.printObjectArray(new Object[]{set, string, string2, list}));
        }
        if (UniqueNameHelper.getValidUniqueName(string) != null) {
            stringBuffer4.append(this.dao.getQuerySet().searchFromDBEntityAndDBTableStringValue);
            stringBuffer3.append(this.dao.getQuerySet().WHERE);
            stringBuffer3.append(this.dao.getQuerySet().UNIQUE_NAME_KEY);
            if (string2.equals("=") && string instanceof String && string.indexOf(42) >= 0) {
                string2 = "LIKE";
                string = string.replace('*', '%');
            }
            s = 0;
            string2 = this.dao.getOperator(string2, s);
            stringBuffer3.append(string2 + " ");
            stringBuffer3.append("?");
            object = new SearchParameter(s, null, string.toLowerCase());
            arrayList.add(object);
        } else if (this.loginProperties != null && this.loginProperties.size() > 0) {
            stringBuffer4.append(this.dao.getQuerySet().searchFromDBEntity);
            stringBuffer3.append(this.dao.getQuerySet().searchWhere1Equals1);
            stringBuffer3.append(this.dao.getQuerySet().AND);
            if (this.loginProperties != null && this.loginProperties.size() > 0) {
                stringBuffer3.append(this.dao.getQuerySet().LEFT_BRACKET);
            }
            s = 0;
            for (int i = 0; this.loginProperties != null && i < this.loginProperties.size(); ++i) {
                String string3;
                StringBuffer stringBuffer5 = new StringBuffer();
                StringBuffer stringBuffer6 = new StringBuffer();
                s = (short)(s + 1);
                stringBuffer5.append("S" + s);
                DBRepositoryProperty dBRepositoryProperty = this.propertyManager.getPropertyDefinition((String)this.loginProperties.get(i));
                if (dBRepositoryProperty == null) {
                    throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED", WIMMessageHelper.generateMsgParms(this.loginProperties.get(i)), CLASSNAME, "searchByPrincipalName(Set entTypes, String value, String operator, List searchBases, List props, DataObject returnRT, boolean[] compositeTypes, StringBuffer compositeQuery, StringBuffer objectQuery)");
                }
                if (dBRepositoryProperty.isCaseSensitive()) {
                    stringBuffer6.append(stringBuffer5 + this.dao.getQuerySet().dotColumnValue);
                } else {
                    stringBuffer6.append(stringBuffer5 + this.dao.getQuerySet().dotColumnValueKey);
                }
                if (stringBuffer4.toString().indexOf(" " + stringBuffer5) == -1) {
                    stringBuffer4.append(this.dao.getQuerySet().COMMA);
                    stringBuffer4.append(this.dao.getQuerySet().dbTableStringValue);
                    stringBuffer4.append(stringBuffer5);
                }
                String string4 = dBRepositoryProperty.getDataType();
                short s2 = DAOHelper.getDataTypeId(string4);
                Integer n = dBRepositoryProperty.getPropId();
                if (i > 0) {
                    stringBuffer3.append(this.dao.getQuerySet().OR);
                }
                stringBuffer3.append(this.dao.getQuerySet().LEFT_BRACKET);
                stringBuffer3.append(stringBuffer5);
                stringBuffer3.append(this.dao.getQuerySet().searchDBEntityJoinCondition);
                stringBuffer3.append(stringBuffer5);
                stringBuffer3.append(this.dao.getQuerySet().searchPropertyIdCondition);
                SearchParameter searchParameter = new SearchParameter(3, n);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(searchParameter);
                stringBuffer3.append(this.dao.getQuerySet().LEFT_BRACKET);
                stringBuffer3.append(stringBuffer6 + " ");
                if (string2.equals("=") && string instanceof String && string.indexOf(42) >= 0) {
                    string2 = "LIKE";
                    string = string.replace('*', '%');
                }
                string2 = this.dao.getOperator(string2, s2);
                stringBuffer3.append(string2 + " ");
                stringBuffer3.append("?");
                stringBuffer3.append(this.dao.getQuerySet().RIGHT_BRACKET);
                stringBuffer3.append(this.dao.getQuerySet().RIGHT_BRACKET);
                searchParameter = new SearchParameter(s2, n, string);
                if (!dBRepositoryProperty.isCaseSensitive() && (string3 = (String)searchParameter.paramValue) != null) {
                    searchParameter.paramValue = string3.toLowerCase();
                }
                arrayList.add(searchParameter);
            }
            if (this.loginProperties != null && this.loginProperties.size() > 0) {
                stringBuffer3.append(this.dao.getQuerySet().RIGHT_BRACKET);
            }
        }
        if (stringBuffer4.length() > 0 && stringBuffer3.length() > 0) {
            String string5 = this.buildSearchByPrincipalNameConditionWhereClause(set, stringBuffer4, stringBuffer3, list);
            object = new StringBuffer();
            boolean bl = false;
            if (list2 == null || list2.size() == 0) {
                bl = true;
            }
            int n = this.searchString((StringBuffer)object, string5, arrayList, list2, dataObject, blArray, stringBuffer, stringBuffer2);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "searchByPrincipalName(Set entTypes, String value, String operator, List searchBases, List props, DataObject returnRT, boolean[] compositeTypes, StringBuffer compositeQuery, StringBuffer objectQuery)", "Search SQL " + WIMTraceHelper.printObjectArray(new Object[]{((StringBuffer)object).toString()}));
            }
            map = this.dao.search(((StringBuffer)object).toString(), arrayList, bl, dataObject, this.reposId, n);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "searchByPrincipalName(Set entTypes, String value, String operator, List searchBases, List props, DataObject returnRT, boolean[] compositeTypes, StringBuffer compositeQuery, StringBuffer objectQuery)");
        }
        return map;
    }

    private String buildSearchConditionWhereClause(Set set, XPathNode xPathNode, List list, List list2) throws WIMException {
        Object object;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "String buildSearchConditionWhereClause(Set, XPathNode, List, List)", WIMTraceHelper.printObjectArray(new Object[]{set, xPathNode, list, list2}));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(set);
        DBXPathTranslateHelper dBXPathTranslateHelper = new DBXPathTranslateHelper(arrayList, xPathNode, list, this.propertyManager, this.dao);
        StringBuffer stringBuffer3 = new StringBuffer();
        dBXPathTranslateHelper.genSearchString(stringBuffer3, xPathNode);
        stringBuffer = dBXPathTranslateHelper.getWhereClause();
        stringBuffer2 = dBXPathTranslateHelper.getFromClause();
        StringBuffer stringBuffer4 = new StringBuffer(stringBuffer2.length() + stringBuffer.length() + 128);
        stringBuffer4.append(this.dao.getQuerySet().searchDBEntitySubSelect);
        stringBuffer4.append(stringBuffer2);
        stringBuffer4.append(stringBuffer);
        stringBuffer4.append(this.dao.getQuerySet().AND);
        stringBuffer4.append(this.dao.getQuerySet().LEFT_BRACKET);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            stringBuffer4.append(this.dao.getQuerySet().searchDBEntityTypeCondition);
            object = (String)iterator.next();
            stringBuffer4.append((String)object);
            stringBuffer4.append(this.dao.getQuerySet().SINGLE_QUOTE);
        }
        while (iterator.hasNext()) {
            stringBuffer4.append(this.dao.getQuerySet().OR);
            stringBuffer4.append(this.dao.getQuerySet().searchDBEntityTypeCondition);
            object = (String)iterator.next();
            stringBuffer4.append((String)object);
            stringBuffer4.append(this.dao.getQuerySet().SINGLE_QUOTE);
        }
        stringBuffer4.append(this.dao.getQuerySet().RIGHT_BRACKET);
        if (list2 != null && list2.size() > 0) {
            object = this.dao.getQuerySet();
            StringBuffer stringBuffer5 = new StringBuffer();
            boolean bl = false;
            stringBuffer5.append(((QuerySet)object).AND);
            stringBuffer5.append(((QuerySet)object).LEFT_BRACKET);
            for (int i = 0; i < list2.size(); ++i) {
                int n = ((QuerySet)object).SEARCH_BASE_EXPRESSION.indexOf(63);
                if (bl) {
                    stringBuffer5.append(((QuerySet)object).OR);
                }
                StringBuffer stringBuffer6 = new StringBuffer(((QuerySet)object).SEARCH_BASE_EXPRESSION);
                String string = (String)list2.get(i);
                stringBuffer6.replace(n, n + 1, UniqueNameHelper.formatUniqueName(string).toLowerCase());
                stringBuffer5.append(stringBuffer6);
                bl = true;
            }
            stringBuffer5.append(((QuerySet)object).RIGHT_BRACKET);
            stringBuffer4.append(stringBuffer5);
        }
        stringBuffer4.append(this.dao.getQuerySet().RIGHT_BRACKET);
        object = stringBuffer4.toString();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "String buildSearchConditionWhereClause(Set, XPathNode, List, List)", WIMTraceHelper.printObjectArray(new Object[]{object, list}));
        }
        return object;
    }

    public DataObject login(DataObject dataObject) throws WIMException {
        int n;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI login(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.reposId, CLASSNAME, "login(DataObject)");
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        List list = dataObject.getList("entities");
        DataObject dataObject3 = (DataObject)list.get(0);
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject4 = (DataObject)map.get("LoginControl");
        String string = dataObject3.getString("principalName");
        byte[] byArray = dataObject3.getBytes("password");
        if (string == null || string.trim().length() == 0) {
            throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", CLASSNAME, "login(DataObject)");
        }
        if (byArray == null || byArray.length == 0) {
            throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PASSWORD", CLASSNAME, "login(DataObject)");
        }
        List list2 = null;
        if (dataObject4 != null) {
            list2 = dataObject4.getList("searchBases");
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.schemaMgr.getQualifiedTypeName(dataObject3.getType());
        hashSet.add(string2);
        hashSet.addAll(this.schemaMgr.getSubEntityTypes(string2));
        DataObject dataObject5 = this.schemaMgr.createRootDataObject();
        Map map2 = this.searchByPrincipalName(hashSet, string, "=", list2, null, dataObject5, null, null, null);
        if (map2 == null || map2.size() == 0) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "WIM_SPI login(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
            }
            return dataObject2;
        }
        if (map2.size() > 1) {
            throw new PasswordCheckFailedException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "login(DataObject)");
        }
        DataObject dataObject6 = dataObject2.createDataObject("entities", "http://www.ibm.com/websphere/wim", "PersonAccount");
        Set set = map2.keySet();
        Iterator iterator = set.iterator();
        long l = (Long)iterator.next();
        DBAccount dBAccount = this.dao.getDBAccountByEntId(l);
        boolean bl = false;
        byte[] byArray2 = dBAccount.getPassword();
        String string3 = dBAccount.getSalt();
        String string4 = null;
        string4 = string3 == null || string3.trim().length() == 0 ? PasswordEncryptionUtil.hash(byArray).trim() : PasswordEncryptionUtil.hash(PasswordEncryptionUtil.getSaltedTextBytes(string3.trim(), byArray)).trim();
        byte[] byArray3 = null;
        String string5 = PasswordEncryptionUtil.decrypt(this.encryptionKey.trim(), null).trim();
        byArray3 = PasswordEncryptionUtil.formatPassword(PasswordEncryptionUtil.encrypt(string4, string5).trim().getBytes());
        byte[] byArray4 = null;
        byArray4 = PasswordEncryptionUtil.formatPassword(byArray2);
        if (byArray4 != null && byArray3 != null && byArray4.length == byArray3.length) {
            n = 0;
            for (n = 0; n < byArray4.length && byArray4[n] == byArray3[n]; ++n) {
            }
            if (n == byArray4.length) {
                bl = true;
            }
        }
        if (!bl) {
            throw new PasswordCheckFailedException("PASSWORD_MATCH_FAILED_FOR_PRINCIPALNAME", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "login(DataObject)");
        }
        n = 0;
        DataObject dataObject7 = (DataObject)map2.get(new Long(l));
        DataObject dataObject8 = dataObject7.getDataObject("identifier");
        dataObject6.setDataObject("identifier", dataObject8);
        if (dataObject4 != null) {
            List list3 = dataObject4.getList("properties");
            if (list3.contains("principalName")) {
                list3.remove("principalName");
                n = 1;
            }
            String[] stringArray = new String[]{};
            stringArray = list3.toArray(stringArray);
            this.getProperties(dataObject6, l, stringArray);
        }
        if (n != 0) {
            dataObject6.setString("principalName", string);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI login(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    private void createProperties(long l, DataObject dataObject) throws WIMException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Property property;
        Object object52;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createProperties(long mbrId, DataObject entity)");
        }
        String string = this.schemaMgr.getQualifiedTypeName(dataObject.getType());
        Hashtable[] hashtableArray = new Hashtable[7];
        Hashtable<Object, Object[]> hashtable = null;
        byte[] byArray = null;
        HashSet hashSet = this.propertyManager.getMandatoryAttributes(string);
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        for (Object object52 : hashSet) {
            property = this.schemaMgr.getProperty(string, (String)object52);
            if (dataObject.isSet(property)) {
                object4 = this.propertyManager.getPropertyDefinition((String)object52);
                object3 = ((DBRepositoryProperty)object4).getPropId();
                object2 = ((RepositoryProperty)object4).getDataType();
                short s = DAOHelper.getDataTypeId((String)object2);
                if (this.propertyManager.isCompositeProperty((String)object52)) {
                    if (hashtable == null) {
                        hashtable = new Hashtable<Object, Object[]>();
                    }
                    if (this.propertyManager.isMultivaluedProperty((String)object52)) {
                        object = new Object[]{object52, dataObject.getList(property)};
                        hashtable.put(object3, (Object[])object);
                        continue;
                    }
                    object = new Object[]{object52, dataObject.get(property)};
                    hashtable.put(object3, (Object[])object);
                    continue;
                }
                if (hashtableArray[s] == null) {
                    hashtableArray[s] = new Hashtable();
                }
                if (this.propertyManager.isMultivaluedProperty((String)object52)) {
                    hashtableArray[s].put(object3, dataObject.getList(property));
                    continue;
                }
                if (((String)object52).equalsIgnoreCase("password")) {
                    byArray = dataObject.getBytes((String)object52);
                    continue;
                }
                hashtableArray[s].put(object3, dataObject.get(property));
                continue;
            }
            object4 = new Object[]{object52};
            throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", (Object[])object4, CLASSNAME, "createProperties(long mbrId, DataObject entity)");
        }
        object52 = this.propertyManager.getSupportedAttributes(string);
        property = object52.iterator();
        while (property.hasNext()) {
            object4 = (Object[])property.next();
            trcLogger.log(Level.FINEST, "Database property name is '" + (String)object4 + "' Type is " + string);
            object3 = this.schemaMgr.getProperty(string, (String)object4);
            trcLogger.log(Level.FINEST, "SchemaManager property is: " + object3);
            try {
                if (object3 == null || !dataObject.isSet((Property)object3) || hashSet.contains(object3)) continue;
                object2 = this.propertyManager.getPropertyDefinition((String)object4);
                Integer n = ((DBRepositoryProperty)object2).getPropId();
                object = ((RepositoryProperty)object2).getDataType();
                short s = DAOHelper.getDataTypeId((String)object);
                if (this.propertyManager.isCompositeProperty((String)object4)) {
                    Object[] objectArray;
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    if (this.propertyManager.isMultivaluedProperty((String)object4)) {
                        objectArray = new Object[]{object4, dataObject.getList((Property)object3)};
                        hashtable.put(n, objectArray);
                        continue;
                    }
                    objectArray = new Object[]{object4, dataObject.get((Property)object3)};
                    hashtable.put(n, objectArray);
                    continue;
                }
                if (hashtableArray[s] == null) {
                    hashtableArray[s] = new Hashtable();
                }
                if (this.propertyManager.isMultivaluedProperty((String)object4)) {
                    hashtableArray[s].put(n, dataObject.getList((Property)object3));
                    continue;
                }
                if (((String)object4).equalsIgnoreCase("password")) {
                    byArray = dataObject.getBytes((String)object4);
                    continue;
                }
                hashtableArray[s].put(n, dataObject.get((Property)object3));
            }
            catch (Exception exception) {
                throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "createProperties(long mbrId, DataObject entity)", (Throwable)exception);
            }
        }
        this.dao.createProperties((short)0, l, hashtableArray, null, this.propertyManager.getMultiValuePropertyIds(), this.reposId);
        if (hashtable != null && hashtable.size() != 0) {
            this.createCompositeProperties(l, hashtable, this.propertyManager.getMultiValuePropertyIds());
        }
        if (byArray != null && this.schemaMgr.isSuperType("PersonAccount", string)) {
            object4 = PasswordEncryptionUtil.generateSalt(this.saltLength);
            object3 = this.encrypt(byArray, (String)object4);
            this.dao.createAccount(l, (byte[])object3, (String)object4, null, null);
            PasswordUtil.erasePassword(byArray);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createProperties(long mbrId, DataObject entity)");
        }
    }

    private void createCompositeProperties(long l, Hashtable hashtable, Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createCompositeProperties(short schema, long mbrId, Hashtable compAttrs, Set multiValProps)");
        }
        Set set2 = hashtable.keySet();
        for (Integer n : set2) {
            Object[] objectArray = (Object[])hashtable.get(n);
            String string = (String)objectArray[0];
            List<Object> list = null;
            if (set.contains(n)) {
                list = (List)objectArray[1];
            } else {
                list = new ArrayList();
                list.add(objectArray[1]);
            }
            this.createOneCompositeProperty(n, string, l, list, null);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createCompositeProperties(short schema, long mbrId, Hashtable compAttrs, Set multiValProps)");
        }
    }

    private void createOneCompositeProperty(Integer n, String string, long l, List list, Long l2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createOneCompositeProperty");
        }
        for (int i = 0; i < list.size(); ++i) {
            Hashtable[] hashtableArray = new Hashtable[7];
            Long l3 = this.dao.createCompositePropValue((short)0, n, l, null, null);
            DataObject dataObject = (DataObject)list.get(i);
            Set set = (Set)this.propertyManager.getCompositeProperties().get(string);
            Set set2 = this.propertyManager.getRequiredComponentProperties(string);
            for (String string2 : set) {
                Object[] objectArray;
                String string3 = DAOHelper.resumeComponentName(string2, string);
                if (dataObject.isSet(string3)) {
                    objectArray = this.propertyManager.getPropertyDefinition(string2);
                    Integer n2 = objectArray.getPropId();
                    String string4 = objectArray.getDataType();
                    short s = DAOHelper.getDataTypeId(string4);
                    if (this.propertyManager.isCompositeProperty(string2)) {
                        ArrayList<Object> arrayList = null;
                        if (this.propertyManager.isMultivaluedProperty(string2)) {
                            arrayList = dataObject.getList(string3);
                        } else {
                            arrayList = new ArrayList<Object>();
                            arrayList.add(dataObject.get(string3));
                        }
                        this.createOneCompositeProperty(n2, string2, l, arrayList, l3);
                        continue;
                    }
                    if (hashtableArray[s] == null) {
                        hashtableArray[s] = new Hashtable();
                    }
                    if (this.propertyManager.isMultivaluedProperty(string2)) {
                        hashtableArray[s].put(n2, dataObject.getList(string3));
                        continue;
                    }
                    hashtableArray[s].put(n2, dataObject.get(string3));
                    continue;
                }
                if (!set2.contains(string2)) continue;
                objectArray = new Object[]{string3};
                throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", objectArray, CLASSNAME, "createOneCompositeProperty");
            }
            this.dao.createProperties((short)0, l, hashtableArray, l3, this.propertyManager.getMultiValuePropertyIds(), this.reposId);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createOneCompositeProperty");
        }
    }

    private byte[] encrypt(byte[] byArray, String string) throws WIMSystemException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "encrypt");
        }
        String string2 = null;
        string2 = string == null || string.trim().length() == 0 ? PasswordEncryptionUtil.hash(byArray).trim() : PasswordEncryptionUtil.hash(PasswordEncryptionUtil.getSaltedTextBytes(string.trim(), byArray)).trim();
        byte[] byArray2 = null;
        byArray2 = PasswordEncryptionUtil.formatPassword(PasswordEncryptionUtil.encrypt(string2, this.ENCRYPTION_KEY).trim().getBytes());
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "encrypt");
        }
        return byArray2;
    }

    public DataObject getSchema(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getSchema(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.reposId, CLASSNAME, "getSchema(DataObject)");
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject3 = (DataObject)map.get("DataTypeControl");
        DataObject dataObject4 = (DataObject)map.get("PropertyDefinitionControl");
        DataObject dataObject5 = (DataObject)map.get("EntityTypeControl");
        if (dataObject3 != null) {
            Set set = this.propertyManager.getSupportedPropertyTypes();
            DataObject dataObject6 = dataObject2.getDataObject("schema");
            if (dataObject6 == null) {
                dataObject6 = dataObject2.createDataObject("schema");
            }
            for (String string : set) {
                dataObject6.getList("propertyDataTypes").add(string);
            }
        } else if (dataObject5 != null) {
            List list;
            List list2 = ConfigManager.singleton().getSupportedEntityTypes();
            DataObject dataObject7 = dataObject2.getDataObject("schema");
            if (dataObject7 == null) {
                dataObject7 = dataObject2.createDataObject("schema");
            }
            if ((list = dataObject5.getList("entityTypeNames")) == null || list.size() == 0) {
                if (list2 != null && list2.size() > 0) {
                    for (int i = 0; i < list2.size(); ++i) {
                        DataObject dataObject8 = dataObject7.createDataObject("entitySchema");
                        String string = (String)list2.get(i);
                        String string2 = this.schemaMgr.getTypeNsURI(string);
                        dataObject8.set("entityName", (Object)string);
                        dataObject8.set("nsURI", (Object)string2);
                    }
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    String string = (String)list.get(i);
                    if (list2.contains(string)) {
                        DataObject dataObject9 = dataObject7.createDataObject("entitySchema");
                        String string3 = this.schemaMgr.getTypeNsURI(string);
                        dataObject9.set("entityName", (Object)string);
                        dataObject9.set("nsURI", (Object)string3);
                        continue;
                    }
                    if (!trcLogger.isLoggable(Level.FINER)) continue;
                    trcLogger.logp(Level.FINER, CLASSNAME, "getSchema(DataObject)", "The entity type " + string + " is not supported in repository " + this.reposId);
                }
            }
        } else if (dataObject4 != null) {
            DataObject dataObject10 = dataObject2.getDataObject("schema");
            if (dataObject10 == null) {
                dataObject10 = dataObject2.createDataObject("schema");
            }
            String string = dataObject4.getString("entityTypeName");
            List list = dataObject4.getList("propertyNames");
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    DataObject dataObject11;
                    String string4 = (String)list.get(i);
                    DBRepositoryProperty dBRepositoryProperty = this.propertyManager.getPropertyDefinition(string4);
                    if (dBRepositoryProperty == null) {
                        if (string4.equals("principalName") && this.schemaMgr.getProperty(string, string4) != null) {
                            dataObject11 = dataObject10.createDataObject("propertySchema");
                            dataObject11.set("propertyName", (Object)this.schemaMgr.getTypeName(string4));
                            String string5 = this.schemaMgr.getTypeNsURI(string4);
                            dataObject11.set("nsURI", (Object)string5);
                            dataObject11.set("nsPrefix", (Object)this.schemaMgr.getNsPrefix(string5));
                        }
                        if (!trcLogger.isLoggable(Level.FINER)) continue;
                        trcLogger.logp(Level.FINER, CLASSNAME, "getSchema(DataObject)", "The property " + string4 + " is not defined in repository " + this.reposId);
                        continue;
                    }
                    dataObject11 = dataObject10.createDataObject("propertySchema");
                    DAOHelper.setPropertySchema(dBRepositoryProperty, string4, dataObject11, string);
                }
            } else {
                Set set = this.propertyManager.getSupportedAttributes(string);
                if (set != null) {
                    for (String string6 : set) {
                        DBRepositoryProperty dBRepositoryProperty = this.propertyManager.getPropertyDefinition(string6);
                        if (dBRepositoryProperty == null) {
                            if (!trcLogger.isLoggable(Level.FINER)) continue;
                            trcLogger.logp(Level.FINER, CLASSNAME, "getSchema(DataObject)", "The property " + string6 + " is not defined in repository " + this.reposId);
                            continue;
                        }
                        DataObject dataObject12 = dataObject10.createDataObject("propertySchema");
                        DAOHelper.setPropertySchema(dBRepositoryProperty, string6, dataObject12, string);
                    }
                }
                if (this.schemaMgr.isSuperType("PersonAccount", string)) {
                    String string6;
                    DataObject dataObject13 = dataObject10.createDataObject("propertySchema");
                    dataObject13.set("propertyName", (Object)this.schemaMgr.getTypeName("principalName"));
                    string6 = this.schemaMgr.getTypeNsURI("principalName");
                    dataObject13.set("nsURI", (Object)string6);
                    dataObject13.set("nsPrefix", (Object)this.schemaMgr.getNsPrefix(string6));
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getSchema(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    public DataObject createSchema(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI createSchema(DataObject)", WIMTraceHelper.printDataObject(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.reposId, CLASSNAME, "createSchema(DataObject)");
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        DataObject dataObject3 = dataObject.getDataObject("schema");
        if (dataObject3 != null) {
            List list;
            String string;
            Object object;
            String string2;
            List list2 = dataObject3.getList("entitySchema");
            if (list2 != null && list2.size() > 0) {
                for (int i = 0; i < list2.size(); ++i) {
                    DataObject dataObject4 = (DataObject)list2.get(i);
                    string2 = dataObject4.getString("nsURI");
                    object = dataObject4.getString("entityName");
                    if (!string2.equals("http://www.ibm.com/websphere/wim")) {
                        object = this.schemaMgr.getQualifiedTypeName(string2, (String)object);
                    }
                    string = dataObject4.getString("parentEntityName");
                    this.dao.createNewPropertyEntityRelationInDB((String)object, string, this.propertyManager);
                    this.propertyManager.updatePropertyEntityRelationCache((String)object, string);
                }
            }
            if ((list = dataObject3.getList("propertySchema")) != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    int n;
                    Object object2;
                    Object object3;
                    Object object4;
                    string2 = (DataObject)list.get(i);
                    object = new DBRepositoryProperty();
                    string = string2.getString("nsURI");
                    String string3 = string2.getString("propertyName");
                    if (!string.equals("http://www.ibm.com/websphere/wim")) {
                        string3 = this.schemaMgr.getQualifiedTypeName(string, string3);
                    }
                    ((RepositoryProperty)object).setName(string3);
                    List list3 = string2.getList("metaData");
                    String string4 = string2.getString("dataType");
                    DBDataType dBDataType = DAOHelper.getDBDataTypeFromCommonDataType(string4);
                    ((RepositoryProperty)object).setDataType(dBDataType.getDatatype());
                    if (dBDataType.getClassname() != null && dBDataType.getClassname().length() != 0) {
                        ((DBRepositoryProperty)object).setClassName(dBDataType.getClassname());
                    }
                    ((RepositoryProperty)object).setMultipleValued(string2.getBoolean("multiValued"));
                    for (int j = 0; j < list3.size(); ++j) {
                        object4 = (DataObject)list3.get(j);
                        object3 = object4.getString("name");
                        object2 = (String)object4.getList("values").get(0);
                        if (((String)object3).equals("classname")) {
                            ((DBRepositoryProperty)object).setClassName((String)object2);
                            continue;
                        }
                        if (((String)object3).equals("applicationId")) {
                            ((DBRepositoryProperty)object).setApplicationId((String)object2);
                            continue;
                        }
                        if (((String)object3).equals("caseExactMatch")) {
                            ((RepositoryProperty)object).setCaseSensitive(new Boolean((String)object2));
                            continue;
                        }
                        if (((String)object3).equals("description")) {
                            ((DBRepositoryProperty)object).setDescription((String)object2);
                            continue;
                        }
                        if (((String)object3).equals("isComposite")) {
                            n = new Boolean((String)object2).booleanValue();
                            if (n != 0) {
                                throw new OperationNotSupportedException("OPERATION_NOT_SUPPORTED_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(this.reposId + "|" + "isComposite"), CLASSNAME, "createSchema(DataObject)");
                            }
                            ((DBRepositoryProperty)object).setComposite(n != 0);
                            continue;
                        }
                        if (((String)object3).equals("multiValued")) {
                            ((RepositoryProperty)object).setMultipleValued(new Boolean((String)object2));
                            continue;
                        }
                        if (((String)object3).equals("readOnly")) {
                            ((DBRepositoryProperty)object).setReadOnly(new Boolean((String)object2));
                            continue;
                        }
                        if (((String)object3).equals("valueLength")) {
                            ((RepositoryProperty)object).setValueLength(new Integer((String)object2));
                            continue;
                        }
                        if (!((String)object3).equals("metaName")) continue;
                        ((DBRepositoryProperty)object).setMetadataName((String)object2);
                    }
                    if (dBDataType.getDatatype().equals("OBJECT") && (((DBRepositoryProperty)object).getClassName() == null || ((DBRepositoryProperty)object).getClassName().length() == 0)) {
                        throw new InvalidPropertyDefinitionException("INVALID_PROPERTY_DATA_TYPE", WIMMessageHelper.generateMsgParms(string2.getString("propertyName")), CLASSNAME, "createSchema(DataObject)");
                    }
                    if (string4.equalsIgnoreCase("STRING") && ((RepositoryProperty)object).getValueLength() == 0) {
                        ((RepositoryProperty)object).setValueLength(254);
                    }
                    if (((DBRepositoryProperty)object).getMetadataName() == null) {
                        ((DBRepositoryProperty)object).setMetadataName("DEFAULT");
                    }
                    if (((DBRepositoryProperty)object).getApplicationId() == null) {
                        ((DBRepositoryProperty)object).setApplicationId("com.ibm.websphere.wim");
                    }
                    List list4 = string2.getList("applicableEntityTypeNames");
                    object4 = new HashSet();
                    for (int j = 0; j < list4.size(); ++j) {
                        object2 = (String)list4.get(j);
                        object4.add(object2);
                        Set set = this.schemaMgr.getSubEntityTypes((String)object2);
                        if (set.size() == 0) continue;
                        object4.addAll(set);
                    }
                    object3 = string2.getList("requiredEntityTypeNames");
                    object2 = null;
                    if (object3 != null) {
                        object2 = new HashSet();
                        for (int j = 0; j < object3.size(); ++j) {
                            String string5 = (String)object3.get(j);
                            if (list4.contains(string5)) {
                                object2.add(string5);
                                Set set = this.schemaMgr.getSubEntityTypes(string5);
                                if (set.size() == 0) continue;
                                object2.addAll(set);
                                continue;
                            }
                            throw new InvalidPropertyDefinitionException("INVALID_PROPERTY_DEFINITION", WIMMessageHelper.generateMsgParms("requiredEntityTypeNames", string5, ((RepositoryProperty)object).getName()), CLASSNAME, "createSchema(DataObject)");
                        }
                    }
                    ((RepositoryProperty)object).setApplicableEntityTypes((Set)object4);
                    ((RepositoryProperty)object).setRequiredEntityTypes((Set)object2);
                    n = this.dao.createPropertyDefinition((DBRepositoryProperty)object);
                    ((DBRepositoryProperty)object).setPropId(new Integer(n));
                    this.propertyManager.updatePropertyCache((DBRepositoryProperty)object);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI createSchema(DataObject)", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    private void appendCompositeProperty(DBRepositoryProperty dBRepositoryProperty, StringBuffer stringBuffer, boolean[] blArray) {
        Set set;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "appendCompositeProperty(DBRepositoryProperty propDef, StringBuffer compositeQuery, boolean[] compositeTypes)");
        }
        if ((set = dBRepositoryProperty.getComponentPropertyNames()) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                DBRepositoryProperty dBRepositoryProperty2 = this.propertyManager.getPropertyDefinition((String)iterator.next());
                if (dBRepositoryProperty2.isComposite()) {
                    stringBuffer.append(this.dao.getQuerySet().COMMA_AND_SPACE);
                    stringBuffer.append(dBRepositoryProperty2.getPropId());
                    this.appendCompositeProperty(dBRepositoryProperty2, stringBuffer, blArray);
                    continue;
                }
                String string = dBRepositoryProperty2.getDataType();
                short s = DAOHelper.getDataTypeId(string);
                blArray[s] = true;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "appendCompositeProperty(DBRepositoryProperty propDef, StringBuffer compositeQuery, boolean[] compositeTypes)");
        }
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        String string2;
        DBEntity dBEntity;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
        }
        if (string.equals("websphere.usermanager.serviceprovider.update.db.adminidpassword")) {
            byte[] byArray = (byte[])hashtable.get("DYNA_CONFIG_KEY_DB_ADMIN_PASSWORD");
            try {
                String string3 = new String(byArray, "UTF-8");
                this.dao.reload(string3);
            }
            catch (Exception exception) {
                throw new DynamicUpdateConfigException("REPOSITORY_CONNECTION_FAILED", WIMMessageHelper.generateMsgParms(this.reposId, "DYNA_CONFIG_KEY_DB_ADMIN_PASSWORD"), CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
            }
        } else if (string.equals("websphere.usermanager.serviceprovider.add.baseentry") && (dBEntity = this.dao.findDBEntityByUniqueNameKey(DAOHelper.getTruncatedUniqueName(string2 = (String)hashtable.get("DYNA_CONFIG_KEY_BASE_ENTRY")))) == null) {
            throw new DynamicUpdateConfigException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "dynamicUpdateConfig(String updateEvent, Map configData)");
        }
    }
}

