/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.db;

import com.ibm.websphere.wim.common.RepositoryProperty;
import com.ibm.websphere.wim.exception.InvalidPropertyDefinitionException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.dao.QuerySet;
import com.ibm.ws.wim.dao.schema.DBRepositoryProperty;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBPropertyCache {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DBPropertyCache.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static DBPropertyCache singleton = null;
    protected Hashtable cache = null;
    private Set memberRefPropertyNames = new HashSet();
    private Set supportedPropertyTypes = new HashSet();
    private Hashtable supportedPropertiesForEntity = null;
    private Hashtable mandatoryPropertiesForEntity = new Hashtable();
    private Set multivaluePropertyIds = new HashSet();
    private Map compositeProperties = new HashMap();
    private Map requiredComponentProperties = new HashMap();
    private Set supportedEntityTypes = new HashSet();
    private Set multivaluedProperty = new HashSet();
    private DataAccessObject dao;
    private int bufferSize = 254;

    public DBPropertyCache(DataAccessObject dataAccessObject) throws WIMException {
        this.init(dataAccessObject);
    }

    /*
     * Loose catch block
     */
    private synchronized void init(DataAccessObject dataAccessObject) throws WIMException {
        block62: {
            Object object;
            Object object2;
            int n;
            int n2;
            Object object3;
            Object object4;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "init");
            }
            Statement statement = null;
            Statement statement2 = null;
            Statement statement3 = null;
            Statement statement4 = null;
            ResultSet resultSet = null;
            Connection connection = null;
            this.dao = dataAccessObject;
            this.cache = new Hashtable();
            this.mandatoryPropertiesForEntity = new Hashtable();
            this.supportedPropertiesForEntity = new Hashtable();
            HashSet<String> hashSet = null;
            HashSet<Object> hashSet2 = null;
            class CompositeProperty {
                int compositePropertyId;
                String compositePropertyName;

                CompositeProperty() {
                }
            }
            HashSet<CompositeProperty> hashSet3 = null;
            this.memberRefPropertyNames = new HashSet();
            connection = this.dao.getConnection();
            QuerySet querySet = this.dao.getQuerySet();
            statement = connection.prepareStatement(querySet.findDBAllProperties);
            resultSet = statement.executeQuery();
            RepositoryProperty repositoryProperty = null;
            String string = null;
            String string2 = querySet.findDBAllCompositeProperties;
            boolean bl = true;
            boolean bl2 = true;
            int n3 = -1;
            while (resultSet.next()) {
                HashSet<String> hashSet4;
                int n4 = resultSet.getInt(1);
                object4 = resultSet.getString(13);
                if (bl2 || n3 != n4) {
                    int n5;
                    if (!bl2) {
                        if (hashSet2 != null) {
                            repositoryProperty.setRequiredEntityTypes(hashSet2);
                        }
                        if (hashSet != null) {
                            repositoryProperty.setApplicableEntityTypes(hashSet);
                            if (DAOHelper.isPropInCommonSchema(string, hashSet)) {
                                this.cache.put(string, repositoryProperty);
                                if (trcLogger.isLoggable(Level.FINER)) {
                                    trcLogger.logp(Level.FINER, CLASSNAME, "init", "Property: " + string + " has been added into DB cache");
                                }
                            }
                        }
                    } else {
                        bl2 = false;
                    }
                    string = resultSet.getString(2);
                    object3 = new HashSet();
                    object3.add(object4);
                    if (!DAOHelper.isPropInCommonSchema(string, (Set)object3)) continue;
                    repositoryProperty = new DBRepositoryProperty();
                    ((DBRepositoryProperty)repositoryProperty).setPropId(new Integer(n4));
                    repositoryProperty.setName(string);
                    String string3 = resultSet.getString(3).trim();
                    repositoryProperty.setDataType(string3);
                    if (string3.equals("IDENTIFIER")) {
                        this.memberRefPropertyNames.add(string);
                    }
                    hashSet4 = resultSet.getString(4);
                    ((DBRepositoryProperty)repositoryProperty).setMetadataName((String)((Object)hashSet4));
                    int n6 = resultSet.getInt(5);
                    ((DBRepositoryProperty)repositoryProperty).setComposite(n6 != 0);
                    if (((DBRepositoryProperty)repositoryProperty).isComposite()) {
                        HashSet hashSet5 = new HashSet();
                        HashSet hashSet6 = new HashSet();
                        this.compositeProperties.put(string, hashSet5);
                        this.requiredComponentProperties.put(string, hashSet6);
                        CompositeProperty compositeProperty = new CompositeProperty();
                        compositeProperty.compositePropertyId = n4;
                        compositeProperty.compositePropertyName = string;
                        if (hashSet3 == null) {
                            hashSet3 = new HashSet<CompositeProperty>();
                        }
                        hashSet3.add(compositeProperty);
                        if (bl) {
                            bl = false;
                        } else {
                            string2 = string2.concat(",");
                        }
                        string2 = string2.concat(new Integer(n4).toString());
                    }
                    n2 = resultSet.getInt(6);
                    repositoryProperty.setValueLength(n2);
                    n = resultSet.getInt(7);
                    ((DBRepositoryProperty)repositoryProperty).setReadOnly(n != 0);
                    int n7 = resultSet.getInt(8);
                    repositoryProperty.setMultipleValued(n7 != 0);
                    if (n7 == 1) {
                        this.multivaluedProperty.add(string);
                        this.multivaluePropertyIds.add(new Integer(n4));
                    }
                    repositoryProperty.setCaseSensitive((n5 = resultSet.getInt(9)) != 0);
                    if (string3.equalsIgnoreCase("OBJECT")) {
                        if (n6 == 0) {
                            object2 = resultSet.getString(10);
                            ((DBRepositoryProperty)repositoryProperty).setClassName((String)object2);
                            try {
                                object = Class.forName((String)object2);
                                if (!Serializable.class.isAssignableFrom((Class<?>)object)) {
                                    Object[] objectArray = new Object[]{string};
                                    throw new InvalidPropertyDefinitionException("INVALID_PROPERTY_DATA_TYPE", objectArray, CLASSNAME, "init");
                                }
                                ((DBRepositoryProperty)repositoryProperty).setClassName((String)object2);
                            }
                            catch (ClassCastException classCastException) {
                                Object[] objectArray = new Object[]{string};
                                throw new InvalidPropertyDefinitionException("INVALID_PROPERTY_DATA_TYPE", objectArray, CLASSNAME, "init", (Throwable)classCastException);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                Object[] objectArray = new Object[]{string};
                                throw new InvalidPropertyDefinitionException("INVALID_PROPERTY_DATA_TYPE", objectArray, CLASSNAME, "init", (Throwable)classNotFoundException);
                            }
                            this.supportedPropertyTypes.add(object2);
                        }
                    } else {
                        this.supportedPropertyTypes.add(string3);
                    }
                    object2 = resultSet.getString(11);
                    ((DBRepositoryProperty)repositoryProperty).setDescription((String)object2);
                    object = resultSet.getString(12);
                    ((DBRepositoryProperty)repositoryProperty).setApplicationId((String)object);
                    n3 = n4;
                    hashSet = new HashSet<String>();
                    hashSet2 = new HashSet<Object>();
                }
                hashSet.add((String)object4);
                this.supportedEntityTypes.add(object4);
                object3 = (Set)this.supportedPropertiesForEntity.get(object4);
                if (object3 == null) {
                    object3 = new HashSet<Object>();
                }
                object3.add(string);
                this.supportedPropertiesForEntity.put(object4, object3);
                int n8 = resultSet.getInt(14);
                if (n8 == 0) continue;
                hashSet2.add(object4);
                hashSet4 = (Set)this.mandatoryPropertiesForEntity.get(object4);
                if (hashSet4 == null) {
                    hashSet4 = new HashSet<String>();
                }
                hashSet4.add(string);
                this.mandatoryPropertiesForEntity.put(object4, hashSet4);
            }
            if (repositoryProperty != null) {
                repositoryProperty.setApplicableEntityTypes(hashSet);
                repositoryProperty.setRequiredEntityTypes(hashSet2);
                if (DAOHelper.isPropInCommonSchema(string, hashSet)) {
                    this.cache.put(string, repositoryProperty);
                }
            }
            if (hashSet3 != null && hashSet3.size() > 0) {
                string2 = string2 + " ) ";
                string2 = string2 + querySet.findDBAllCompositePropertiesOrderBy;
                resultSet.close();
                statement2 = connection.prepareStatement(string2, 1003, 1007);
                resultSet = statement2.executeQuery();
                Iterator iterator = hashSet3.iterator();
                object4 = null;
                object3 = null;
                while (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    String string4 = resultSet.getString(2);
                    n2 = resultSet.getInt(3);
                    n = resultSet.getInt(4);
                    String string5 = resultSet.getString(5);
                    String string6 = resultSet.getString(6);
                    object2 = (Set)this.compositeProperties.get(string6);
                    object2.add(string5);
                    this.compositeProperties.put(string6, object2);
                    object = (DBRepositoryProperty)this.cache.get(string6);
                    ((DBRepositoryProperty)object).setComponentPropertyNames((Set)object2);
                    this.cache.put(string6, object);
                    if (n2 != 1) continue;
                    Set set = (Set)this.requiredComponentProperties.get(string6);
                    set.add(string5);
                    this.requiredComponentProperties.put(string6, set);
                }
            }
            Iterator iterator = this.supportedEntityTypes.iterator();
            while (iterator.hasNext()) {
                object4 = (Set)this.supportedPropertiesForEntity.get(iterator.next());
                object3 = this.getCompositeProperties();
                if (object3 == null) continue;
                Set set = object3.keySet();
                for (String string7 : set) {
                    if (object4 == null || !object4.contains(string7)) continue;
                    Set set2 = (Set)this.compositeProperties.get(string7);
                    object4.removeAll(set2);
                }
            }
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            statement3 = connection.prepareStatement(querySet.getAllSupportedPropertyTypes);
            resultSet = statement3.executeQuery();
            while (resultSet.next()) {
                this.supportedPropertyTypes.add(resultSet.getString(1).trim());
            }
            Object var33_52 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement3 != null) {
                    statement3.close();
                }
                if (statement4 != null) {
                    statement4.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    this.dao.closeConnection(connection);
                }
                break block62;
            }
            catch (Exception exception) {}
            break block62;
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "init", (Throwable)sQLException);
                }
                catch (Exception exception) {
                    throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "init", (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                Object var33_53 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (statement2 != null) {
                        statement2.close();
                    }
                    if (statement3 != null) {
                        statement3.close();
                    }
                    if (statement4 != null) {
                        statement4.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        this.dao.closeConnection(connection);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "init");
        }
    }

    public Set getMandatoryAttributes(String string) {
        return (Set)this.mandatoryPropertiesForEntity.get(string);
    }

    public Set getSupportedAttributes(String string) {
        return (Set)this.supportedPropertiesForEntity.get(string);
    }

    public DBRepositoryProperty getPropertyDefinition(String string) {
        return (DBRepositoryProperty)this.cache.get(string);
    }

    public boolean isCompositeProperty(String string) {
        return this.compositeProperties.containsKey(string);
    }

    public boolean isMultivaluedProperty(String string) {
        return this.multivaluedProperty.contains(string);
    }

    public Set getMultiValuePropertyIds() {
        return this.multivaluePropertyIds;
    }

    public Map getCompositeProperties() {
        return this.compositeProperties;
    }

    public Set getRequiredComponentProperties(String string) {
        return (Set)this.requiredComponentProperties.get(string);
    }

    public Set getSupportedPropertyTypes() {
        return this.supportedPropertyTypes;
    }

    public void updatePropertyCache(DBRepositoryProperty dBRepositoryProperty) {
        Object object;
        Object object22;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updatePropertyCache(DBRepositoryProperty prop)");
        }
        this.cache.put(dBRepositoryProperty.getName(), dBRepositoryProperty);
        Set set = dBRepositoryProperty.getRequiredEntityTypes();
        if (set != null && set.size() > 0) {
            for (Object object22 : set) {
                object = (Set)this.mandatoryPropertiesForEntity.get(object22);
                if (object == null) {
                    object = new HashSet<String>();
                }
                object.add(dBRepositoryProperty.getName());
                this.mandatoryPropertiesForEntity.put(object22, object);
            }
        }
        if (dBRepositoryProperty.getDataType().equals("IDENTIFIER")) {
            this.memberRefPropertyNames.add(dBRepositoryProperty.getName());
        }
        if (dBRepositoryProperty.isMultipleValued()) {
            this.multivaluedProperty.add(dBRepositoryProperty.getName());
            this.multivaluePropertyIds.add(dBRepositoryProperty.getPropId());
        }
        Set set2 = dBRepositoryProperty.getApplicableEntityTypes();
        object22 = set2.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            this.supportedEntityTypes.add(object);
            HashSet<String> hashSet = (HashSet<String>)this.supportedPropertiesForEntity.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(dBRepositoryProperty.getName());
            this.supportedPropertiesForEntity.put(object, hashSet);
        }
        if (dBRepositoryProperty.getDataType().equals("OBJECT")) {
            object = dBRepositoryProperty.getClassName();
            this.supportedPropertyTypes.add(object);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updatePropertyCache(DBRepositoryProperty prop)");
        }
    }

    public void updatePropertyEntityRelationCache(String string, String string2) {
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updatePropertyEntityRelationCache(String newEntName, String parentEntName)");
        }
        this.supportedEntityTypes.add(string);
        Set set = (Set)this.supportedPropertiesForEntity.get(string2);
        HashSet hashSet = null;
        if (set != null) {
            hashSet = new HashSet();
            object = set.iterator();
            while (object.hasNext()) {
                hashSet.add(object.next());
            }
        }
        this.supportedPropertiesForEntity.put(string, hashSet);
        object = (Set)this.mandatoryPropertiesForEntity.get(string2);
        HashSet hashSet2 = new HashSet();
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                hashSet2.add(iterator.next());
            }
        }
        this.mandatoryPropertiesForEntity.put(string, hashSet2);
        for (String string3 : set) {
            DBRepositoryProperty dBRepositoryProperty = this.getPropertyDefinition(string3);
            Set set2 = dBRepositoryProperty.getApplicableEntityTypes();
            set2.add(string);
            dBRepositoryProperty.setApplicableEntityTypes(set2);
            Set set3 = (Set)this.mandatoryPropertiesForEntity.get(string);
            if (set3 == null || !set3.contains(string3)) continue;
            HashSet<String> hashSet3 = dBRepositoryProperty.getRequiredEntityTypes();
            if (hashSet3 == null) {
                hashSet3 = new HashSet<String>();
            }
            hashSet3.add(string);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updatePropertyEntityRelationCache(String newEntName, String parentEntName)");
        }
    }
}

