/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.file.was;

import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.SchemaConstants;
import com.ibm.websphere.wim.exception.CertificateMapNotSupportedException;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.EntityAlreadyExistsException;
import com.ibm.websphere.wim.exception.EntityHasDescendantsException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InitializationException;
import com.ibm.websphere.wim.exception.InvalidArgumentException;
import com.ibm.websphere.wim.exception.MissingMandatoryPropertyException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.exception.PasswordCheckFailedException;
import com.ibm.websphere.wim.exception.RemoveEntityException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.UpdateOperationalPropertyException;
import com.ibm.websphere.wim.exception.UpdatePropertyException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.UniqueIdGenerator;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.file.was.FileData;
import com.ibm.ws.wim.adapter.file.was.FileRegistryEventHandler;
import com.ibm.ws.wim.adapter.file.was.FileUtils;
import com.ibm.ws.wim.adapter.file.was.FileXPathHelper;
import com.ibm.ws.wim.management.DynamicReloadManager;
import com.ibm.ws.wim.util.AsyncUtils;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.ws.wim.util.UniqueNameHelper;
import com.ibm.wsspi.wim.Repository;
import com.ibm.wsspi.wim.RepositoryImpl;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FileAdapter
extends RepositoryImpl
implements Repository,
DynamicConfigService,
SchemaConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = FileAdapter.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    public static final String UNIQUE_ID_PATH = "identifier/uniqueId";
    public static final String EXTERNAL_ID_PATH = "identifier/externalId";
    public static final String EXTERNAL_NAME_PATH = "identifier/externalName";
    public static final String UNIQUE_NAME_PATH = "identifier/uniqueName";
    public static final String DO_ENTITIES0 = "entities.0";
    public static final int INITIAL_CURRENT_LEVEL = 0;
    public static final List IDENTIFIER_REF = DataGraphHelper.IDENTIFIER_REF;
    protected static final String WILDCARD = "*";
    private FileData fileData = null;
    private String sessionId = null;
    private String fileID = null;
    private String MDAlgorithm = null;
    private List baseEntries = new ArrayList();
    private List loginProperties = new ArrayList();
    private List loginPropertiesType = new ArrayList();
    private String mappedPrincipalNameProperty = null;
    private boolean mappedPrincipalNamePropertyMultiValued = false;
    private List skipProps = null;
    private int saltLength;
    private Map entityRDNs;
    private Set allEntityProps = null;
    private Set allEntityCtxProps = null;
    private Set allEntityRefProps = null;
    private SchemaManager schemaMgr;
    private boolean reloadSchema = true;
    private ConfigManager configMgr;
    private static FileRegistryEventHandler freh = null;
    private boolean caseSensitive = false;

    public FileAdapter() {
    }

    public FileAdapter(String string, DataObject dataObject, DataObject dataObject2) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI <init>", "sessionId=" + string + ", cfgDO=" + WIMTraceHelper.printDataGraph(dataObject));
        }
        try {
            this.sessionId = string;
            this.schemaMgr = SchemaManager.singleton();
            if (dataObject != null) {
                this.getEntityRDNsFromConfigDO(dataObject);
            } else {
                this.getEntityRDNsFromConfigManager();
            }
            this.allEntityProps = new HashSet();
            this.allEntityCtxProps = new HashSet();
            this.allEntityRefProps = new HashSet();
            if (dataObject2 == null) {
                if (bl) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "<init>", "File Repository is not configured, initialize with default settings.");
                }
                this.fileID = "InternalFileRepository";
                this.saltLength = 12;
                this.MDAlgorithm = "SHA-1";
                String string2 = ConfigManager.singleton().getWASConfigDirectory();
                this.baseEntries.add("o=defaultWIMFileBasedRealm");
                this.fileData = new FileData(string, string2, null, this.entityRDNs, this.fileID, this.baseEntries, this.caseSensitive);
                this.fileData.load(null);
            } else {
                this.initialize(dataObject2);
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new InitializationException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(this.fileID, exception.getMessage()), Level.SEVERE, CLASSNAME, "<init>", (Throwable)exception);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI <init>");
        }
    }

    public void initialize(DataObject dataObject) throws WIMException {
        super.initialize(dataObject);
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI initialize");
        }
        try {
            this.fileID = dataObject.getString("id");
            this.schemaMgr = SchemaManager.singleton();
            String string = dataObject.getString("baseDirectory");
            if (string == null) {
                string = ConfigManager.singleton().getWASConfigDirectory();
            }
            if (!FileUtils.fileExists(string)) {
                throw new InitializationException("DIRECTORY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "initialize");
            }
            String string2 = dataObject.getString("fileName");
            this.MDAlgorithm = dataObject.getString("messageDigestAlgorithm");
            this.saltLength = dataObject.isSet("saltLength") ? dataObject.getInt("saltLength") : 12;
            this.caseSensitive = dataObject.getBoolean("caseSensitive");
            if (bl) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize", "from configDO, fileName=" + string2 + ", MDAlgo=" + this.MDAlgorithm + ", saltLength=" + this.saltLength + ", caseSensitive=" + this.caseSensitive);
            }
            List list = dataObject.getList("baseEntries");
            for (int i = 0; i < list.size(); ++i) {
                this.baseEntries.add(((DataObject)list.get(i)).getString("name"));
            }
            if (this.baseEntries.size() == 0 && this.sessionId != null) {
                this.baseEntries.add("o=defaultWIMFileBasedRealm");
            }
            if (this.sessionId == null) {
                this.getEntityRDNsFromConfigManager();
                List list2 = dataObject.getList("loginProperties");
                if (list2.size() > 0) {
                    this.loginProperties.clear();
                    this.loginPropertiesType.clear();
                    for (int i = 0; i < list2.size(); ++i) {
                        this.loginProperties.add((String)list2.get(i));
                        this.loginPropertiesType.add(Boolean.FALSE);
                    }
                }
                if (this.loginProperties.size() > 0) {
                    this.mappedPrincipalNameProperty = (String)this.loginProperties.get(0);
                }
                this.getContextAndRefrenceProperties();
            }
            if (bl) {
                trcLogger.logp(Level.FINER, CLASSNAME, "initialize", "baseEntries=" + this.baseEntries + ", loginProperties=" + this.loginProperties);
            }
            this.fileData = new FileData(this.sessionId, string, string2, this.entityRDNs, this.fileID, this.baseEntries, this.caseSensitive);
            this.fileData.load(null);
            if (this.sessionId == null && DynamicReloadManager.isRunningOnManagedProcOrNodeAgent()) {
                if (freh == null) {
                    String string3 = "websphere.usermanager.fileregistry.change";
                    freh = new FileRegistryEventHandler(string3, this.fileID, this.fileData);
                    DynamicReloadManager.singleton().registerEventAtNode(string3, freh);
                } else {
                    freh.addFileId(this.fileID, this.fileData);
                }
            }
            if (bl) {
                trcLogger.exiting(CLASSNAME, "WIM_SPI initialize");
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new InitializationException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(this.fileID, exception.getMessage()), Level.SEVERE, CLASSNAME, "initialize", (Throwable)exception);
        }
    }

    private void getEntityRDNsFromConfigManager() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getEntityRDNsFromConfigManager");
        }
        this.configMgr = ConfigManager.singleton();
        List list = this.configMgr.getSupportedEntityTypes();
        int n = list.size();
        this.entityRDNs = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            String string = (String)list.get(i);
            List list2 = this.configMgr.getRDNProperties(string);
            Vector<String> vector = new Vector<String>(list2.size());
            for (n2 = 0; n2 < list2.size(); ++n2) {
                String string2 = (String)list2.get(n2);
                vector.add(string2);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
                if (stringTokenizer.countTokens() <= 1) continue;
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(stringTokenizer.nextToken());
                }
            }
            this.entityRDNs.put(string, vector);
            if (!FileData.isSuperType("PersonAccount", string)) continue;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.loginProperties.add((String)vector.get(n2));
                this.loginPropertiesType.add(Boolean.FALSE);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getEntityRDNsFromConfigManager", "entityRDNs=" + this.entityRDNs + ", loginProperties=" + this.loginProperties);
        }
    }

    private void getEntityRDNsFromConfigDO(DataObject dataObject) throws WIMException {
        List list;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getEntityRDNsFromConfigDO");
        }
        if ((list = dataObject.getList("supportedEntityTypes")) == null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "WIM_SPI getEntityRDNsFromConfigDO", "No Supported Entity type found");
            }
            return;
        }
        int n = list.size();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "WIM_SPI getEntityRDNsFromConfigDO", "Supported Entities=" + n);
        }
        this.entityRDNs = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            DataObject dataObject2 = (DataObject)list.get(i);
            String string = dataObject2.getString("name");
            List list2 = dataObject2.getList("rdnProperties");
            Vector<String> vector = new Vector<String>(list2.size());
            for (n2 = 0; n2 < list2.size(); ++n2) {
                String string2 = (String)list2.get(n2);
                vector.add(string2);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
                if (stringTokenizer.countTokens() <= 1) continue;
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(stringTokenizer.nextToken());
                }
            }
            this.entityRDNs.put(string, vector);
            if (!FileData.isSuperType("PersonAccount", string)) continue;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.loginProperties.add((String)vector.get(n2));
                this.loginPropertiesType.add(Boolean.FALSE);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getEntityRDNsFromConfigDO", "entityRDNs=" + this.entityRDNs + ", loginProperties=" + this.loginProperties);
        }
    }

    private void getContextAndRefrenceProperties() {
        if (this.reloadSchema) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "WIM_SPI getContextAndRefrenceProperties");
            }
            this.reloadSchema = false;
            this.skipProps = new ArrayList();
            this.skipProps.add("identifier");
            this.skipProps.add("viewIdentifiers");
            this.skipProps.add("parent");
            this.skipProps.add("children");
            this.skipProps.add("groups");
            this.skipProps.add("createTimestamp");
            this.skipProps.add("modifyTimestamp");
            this.skipProps.add("entitlementInfo");
            this.allEntityProps = new HashSet();
            this.allEntityCtxProps = new HashSet();
            this.allEntityRefProps = new HashSet();
            for (String string : this.entityRDNs.keySet()) {
                List list = this.schemaMgr.getProperties(string);
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "WIM_SPI getContextAndRefrenceProperties", "entityType=" + string + ", propList=" + list);
                }
                for (int i = 0; list != null && i < list.size(); ++i) {
                    Property property = (Property)list.get(i);
                    String string2 = property.getName();
                    if (property.isMany()) {
                        int n;
                        if (string2.equals(this.mappedPrincipalNameProperty)) {
                            this.mappedPrincipalNamePropertyMultiValued = true;
                        }
                        if ((n = this.loginProperties.indexOf(string2)) != -1) {
                            this.loginPropertiesType.set(n, Boolean.TRUE);
                        }
                    }
                    if ("LangType".equals(property.getType().getName())) {
                        this.allEntityCtxProps.add(string2);
                        continue;
                    }
                    if (this.skipProps.contains(string2)) continue;
                    if ("IdentifierType".equals(property.getType().getName())) {
                        this.allEntityRefProps.add(string2);
                        continue;
                    }
                    this.allEntityProps.add(string2);
                }
            }
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "WIM_SPI getContextAndRefrenceProperties", "allEntityRefProps=" + this.allEntityRefProps + "\nallEntityCtxProps=" + this.allEntityCtxProps + "\nallEntityProps=" + this.allEntityProps);
            }
        }
    }

    public DataObject create(DataObject dataObject) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI create", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        String string = null;
        try {
            AsyncUtils.asyncOperationNotSupported(dataObject, this.fileID, CLASSNAME, "create");
            dataObject2 = this.schemaMgr.createRootDataObject();
            List list = dataObject.getList("entities");
            for (int i = 0; i < list.size(); ++i) {
                Object object4;
                Object object2;
                String string2;
                Object object3;
                DataObject dataObject3 = (DataObject)list.get(i);
                DataObject dataObject4 = DataGraphHelper.cloneDataObject(dataObject3);
                String string3 = dataObject4.getType().getName();
                if (dataObject4.isSet("createTimestamp")) {
                    throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms("createTimestamp"), CLASSNAME, "create");
                }
                if (dataObject4.isSet("modifyTimestamp")) {
                    throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms("modifyTimestamp"), CLASSNAME, "create");
                }
                DataObject dataObject5 = dataObject4.getDataObject("identifier");
                string = dataObject5.getString("uniqueName");
                String string4 = this.fileData.getEntityID(dataObject4);
                dataObject5.setString("externalName", string);
                if (this.fileData.exists(string4, string)) {
                    throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "create");
                }
                if (this.isPersonAccountType(string3)) {
                    if (dataObject4.isSet("principalName")) {
                        throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", this.fileID), CLASSNAME, "create");
                    }
                    if (dataObject4.isSet("realm")) {
                        throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("realm", this.fileID), CLASSNAME, "create");
                    }
                }
                if (this.isAccountType(string3) && dataObject4.isSet("password")) {
                    dataObject4.set("password", (Object)FileData.hash(dataObject4.getBytes("password"), this.saltLength, this.MDAlgorithm));
                }
                EClass eClass = this.schemaMgr.getEClass(dataObject4.getType());
                EList eList = eClass.getEAllReferences();
                for (int j = 0; j < eList.size(); ++j) {
                    object3 = (EReference)eList.get(j);
                    string2 = object3.getName();
                    object2 = object3.getEType().getName();
                    if (!dataObject4.isSet(string2) || !"Entity".equals(object2) && !"Group".equals(object2) && !this.allEntityRefProps.contains(string2)) continue;
                    if (object3.getUpperBound() == 1) {
                        this.fileData.mustExist(null, this.getUniqueName(dataObject4.getDataObject(string2)));
                        continue;
                    }
                    object4 = dataObject4.getList(string2);
                    for (int k = 0; k < object4.size(); ++k) {
                        String string5 = this.getUniqueName((DataObject)object4.get(k));
                        this.fileData.mustExist(null, string5);
                    }
                }
                HashSet<Object> hashSet = null;
                if (dataObject4.isSet("groups")) {
                    object3 = dataObject4.getList("groups");
                    hashSet = new HashSet<Object>();
                    for (int j = 0; j < object3.size(); ++j) {
                        object2 = (DataObject)object3.get(j);
                        object4 = this.getUniqueName((DataObject)object2);
                        if (!this.fileData.groupMustExist(null, (String)object4)) continue;
                        hashSet.add(object4);
                    }
                    dataObject4.unset("groups");
                }
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = UniqueIdGenerator.newUniqueId();
                    dataObject5.setString("uniqueId", string4);
                    dataObject5.setString("externalId", string4);
                }
                dataObject4.setString("createTimestamp", this.fileData.getDateString());
                this.fileData.addEntity(string3, dataObject4, true);
                object3 = dataObject2.createDataObject("entities", dataObject4.getType().getURI(), string3);
                string2 = object3.createDataObject("identifier");
                string2.setString("uniqueName", string);
                string2.setString("externalName", string);
                string2.setString("uniqueId", string4);
                string2.setString("externalId", string4);
                string2.setString("repositoryId", this.fileID);
                if (hashSet == null) continue;
                for (Object object4 : hashSet) {
                    this.fileData.addMemberDNToGroup((String)object4, string, false);
                }
                this.fileData.saveEntities();
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            WIMApplicationException wIMApplicationException = new WIMApplicationException("ENTITY_CREATE_FAILED", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), Level.SEVERE, CLASSNAME, "create", (Throwable)exception);
            wIMApplicationException.setRootErrorSource(this.fileID);
            throw wIMApplicationException;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI create", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    private boolean isPersonAccountType(String string) {
        return FileData.isSuperType("PersonAccount", string);
    }

    private boolean isAccountType(String string) {
        return this.isPersonAccountType(string) || FileData.isSuperType("LoginAccount", string);
    }

    private void copyDataObject(DataObject dataObject, DataObject dataObject2, List list, List list2, List arrayList) throws Exception {
        DataObject dataObject3;
        this.getContextAndRefrenceProperties();
        boolean bl = false;
        ArrayList<String> arrayList2 = null;
        if (list != null) {
            if (list.contains("principalName") && this.mappedPrincipalNameProperty != null) {
                if (!list.contains(WILDCARD) && !list.contains(this.mappedPrincipalNameProperty)) {
                    list.add(this.mappedPrincipalNameProperty);
                }
                bl = true;
            }
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                if (!this.allEntityRefProps.contains(string)) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<String>();
                    if (arrayList != null) {
                        arrayList2.addAll(arrayList);
                    }
                }
                arrayList2.add(string);
            }
            if (list.contains(WILDCARD)) {
                Iterator iterator = this.allEntityRefProps.iterator();
                while (iterator.hasNext()) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList();
                        if (arrayList != null) {
                            arrayList2.addAll(arrayList);
                        }
                    }
                    arrayList2.add((String)iterator.next());
                }
            }
        }
        if (arrayList2 == null) {
            arrayList2 = arrayList;
        }
        DataGraphHelper.copyDataObject(dataObject, dataObject2, list, list2, arrayList2);
        if (bl && this.mappedPrincipalNameProperty != null && FileData.isSuperType("LoginAccount", dataObject.getType().getName())) {
            if (this.mappedPrincipalNamePropertyMultiValued) {
                List list3 = dataObject.getList(this.mappedPrincipalNameProperty);
                if (list3.size() > 0) {
                    dataObject.set("principalName", list3.get(0));
                }
            } else {
                dataObject.set("principalName", dataObject.get(this.mappedPrincipalNameProperty));
            }
        }
        if ((dataObject3 = dataObject.getDataObject("identifier")) != null && !dataObject3.isSet("repositoryId")) {
            dataObject3.setString("repositoryId", this.fileID);
        }
    }

    public DataObject get(DataObject dataObject) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI get", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        String string = null;
        try {
            AsyncUtils.asyncOperationNotSupported(dataObject, this.fileID, CLASSNAME, "get");
            Map map = ControlsHelper.getControlMap(dataObject);
            DataObject dataObject3 = (DataObject)map.get("PropertyControl");
            DataObject dataObject4 = (DataObject)map.get("AncestorControl");
            DataObject dataObject5 = (DataObject)map.get("DescendantControl");
            DataObject dataObject6 = (DataObject)map.get("GroupMembershipControl");
            DataObject dataObject7 = (DataObject)map.get("GroupMemberControl");
            DataObject dataObject8 = (DataObject)map.get("CheckGroupMembershipControl");
            List list = null;
            List list2 = null;
            if (dataObject3 != null) {
                list = dataObject3.getList("properties");
                list2 = dataObject3.getList("contextProperties");
            }
            List list3 = dataObject.getList("entities");
            for (int i = 0; i < list3.size(); ++i) {
                Object object;
                Object object2;
                List list4;
                List list5;
                int n;
                DataObject dataObject9 = (DataObject)list3.get(i);
                String string2 = dataObject9.getType().getName();
                EClass eClass = this.schemaMgr.getEClass(dataObject9.getType());
                string = this.getUniqueName(dataObject9);
                DataObject dataObject10 = this.fileData.getByDN(string);
                String string3 = dataObject10.getType().getName();
                DataObject dataObject11 = dataObject2.createDataObject("entities", dataObject10.getType().getURI(), string3);
                this.copyDataObject(dataObject11, dataObject10, list, list2, IDENTIFIER_REF);
                if (dataObject7 != null) {
                    n = dataObject7.getInt("level");
                    if (n < 0) {
                        throw new InvalidArgumentException("INVALID_LEVEL_IN_CONTROL", WIMMessageHelper.generateMsgParms(new Integer(n), "GroupMemberControl"), Level.WARNING, CLASSNAME, "get");
                    }
                    list5 = dataObject7.getList("properties");
                    list4 = dataObject7.getList("contextProperties");
                    object2 = new FileXPathHelper(dataObject7.getString("expression"), dataObject7.getList("searchBases"), this.loginProperties, this.loginPropertiesType, this.caseSensitive);
                    this.getGroupMembers(dataObject10, dataObject11, list5, list4, n, 0, (FileXPathHelper)object2, new HashSet());
                }
                if (dataObject6 != null) {
                    n = dataObject6.getInt("level");
                    if (n < 0) {
                        throw new InvalidArgumentException("INVALID_LEVEL_IN_CONTROL", WIMMessageHelper.generateMsgParms(new Integer(n), "GroupMembershipControl"), Level.WARNING, CLASSNAME, "get");
                    }
                    list5 = dataObject6.getList("properties");
                    list4 = dataObject6.getList("contextProperties");
                    object2 = this.schemaMgr.getEClass("Group");
                    object = new FileXPathHelper(dataObject6.getString("expression"), dataObject6.getList("searchBases"), this.loginProperties, this.loginPropertiesType, this.caseSensitive);
                    this.getGroupMembership(string, dataObject11, (EClass)object2, list5, list4, n, 0, (FileXPathHelper)object, new HashSet());
                }
                if (dataObject8 != null) {
                    n = dataObject8.getInt("level");
                    if (n < 0) {
                        throw new InvalidArgumentException("INVALID_LEVEL_IN_CONTROL", WIMMessageHelper.generateMsgParms(new Integer(n), "CheckGroupMembershipControl"), Level.WARNING, CLASSNAME, "get");
                    }
                    boolean bl2 = this.fileData.checkGroupMembership(dataObject9, n);
                    list4 = dataObject2.createDataObject("controls", "http://www.ibm.com/websphere/wim", "CheckGroupMembershipControl");
                    list4.setBoolean("inGroup", bl2);
                }
                if (dataObject4 != null) {
                    n = dataObject4.getInt("level");
                    if (n < 0) {
                        throw new InvalidArgumentException("INVALID_LEVEL_IN_CONTROL", WIMMessageHelper.generateMsgParms(new Integer(n), "AncestorControl"), Level.WARNING, CLASSNAME, "get");
                    }
                    List list6 = dataObject4.getList("properties");
                    list4 = dataObject4.getList("contextProperties");
                    object2 = this.getAncestorDNs(string, n);
                    object = dataObject11;
                    try {
                        for (int j = 0; j < object2.size(); ++j) {
                            String string4 = (String)object2.get(j);
                            DataObject dataObject12 = this.fileData.getByDN(string4);
                            String string5 = dataObject12.getType().getName();
                            EClass eClass2 = this.schemaMgr.getEClass(dataObject12.getType());
                            DataObject dataObject13 = (DataObject)EcoreUtil.create((EClass)eClass2);
                            this.copyDataObject(dataObject13, dataObject12, list, list2, IDENTIFIER_REF);
                            object.setDataObject("parent", dataObject13);
                            object = dataObject13;
                        }
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        // empty catch block
                    }
                }
                if (dataObject5 == null) continue;
                n = dataObject5.getInt("level");
                if (n < 0) {
                    throw new InvalidArgumentException("INVALID_LEVEL_IN_CONTROL", WIMMessageHelper.generateMsgParms(new Integer(n), "DescendantControl"), Level.WARNING, CLASSNAME, "get");
                }
                List list7 = dataObject5.getList("properties");
                list4 = dataObject5.getList("contextProperties");
                object2 = new FileXPathHelper(dataObject5.getString("expression"), dataObject5.getList("searchBases"), this.loginProperties, this.loginPropertiesType, this.caseSensitive);
                object = this.fileData.getByDN(string);
                this.getDescendants((DataObject)object, dataObject11, list7, list4, n, 0, dataObject5.getBoolean("treeView"), (FileXPathHelper)object2);
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            WIMApplicationException wIMApplicationException = new WIMApplicationException("ENTITY_GET_FAILED", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), Level.SEVERE, CLASSNAME, "get", (Throwable)exception);
            wIMApplicationException.setRootErrorSource(this.fileID);
            throw wIMApplicationException;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI get", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    private void getGroupMembers(DataObject dataObject, DataObject dataObject2, List list, List list2, int n, int n2, FileXPathHelper fileXPathHelper, Set set) throws Exception {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getGroupMembers", "currentLevel=" + n2 + ", for group: " + dataObject.getString(UNIQUE_NAME_PATH));
        }
        if (!FileData.isSuperType("Group", dataObject.getType().getName())) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "WIM_SPI getGroupMembers", "Entity is not a group:" + dataObject.getType().getName());
            }
            return;
        }
        int n3 = n2 + 1;
        List list3 = dataObject.getList("members");
        for (int i = 0; i < list3.size(); ++i) {
            DataObject dataObject3 = (DataObject)list3.get(i);
            String string = dataObject3.getString(UNIQUE_NAME_PATH);
            if (set.contains(string)) continue;
            set.add(string);
            DataObject dataObject4 = this.fileData.getByDN(string);
            boolean bl = false;
            if (fileXPathHelper == null || fileXPathHelper.evaluate(dataObject4)) {
                bl = true;
                EClass eClass = this.schemaMgr.getEClass(dataObject4.getType());
                DataObject dataObject5 = (DataObject)EcoreUtil.create((EClass)eClass);
                this.copyDataObject(dataObject5, dataObject4, list, list2, IDENTIFIER_REF);
                dataObject2.getList("members").add(dataObject5);
            }
            if (n != 0 && n3 >= n || !FileData.isSuperType("Group", dataObject4.getType().getName())) continue;
            this.getGroupMembers(dataObject4, dataObject2, list, list2, n, n3, fileXPathHelper, set);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getGroupMembers", "Members returned are:" + set);
        }
    }

    private void getGroupMembership(String string, DataObject dataObject, EClass eClass, List list, List list2, int n, int n2, FileXPathHelper fileXPathHelper, Set set) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getGroupMembership", "currentLevel=" + n2 + ", for member: " + string);
        }
        int n3 = n2 + 1;
        List list3 = this.fileData.getGroupsForEntity(string, fileXPathHelper);
        for (int i = 0; i < list3.size(); ++i) {
            String string2 = (String)list3.get(i);
            if (set.contains(string2)) continue;
            set.add(string2);
            DataObject dataObject2 = this.fileData.getByDN(string2);
            DataObject dataObject3 = (DataObject)EcoreUtil.create((EClass)eClass);
            this.copyDataObject(dataObject3, dataObject2, list, list2, IDENTIFIER_REF);
            dataObject.getList("groups").add(dataObject3);
            if (n != 0 && n3 >= n) continue;
            this.getGroupMembership(string2, dataObject, eClass, list, list2, n, n3, fileXPathHelper, set);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getGroupMembership", "Groups returned are:" + set);
        }
    }

    private List getAncestorDNs(String string, int n) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.trim().length() == 0) {
            return arrayList;
        }
        String string2 = string;
        int n2 = string2.indexOf(",");
        int n3 = 0;
        while (n2 > 0) {
            string2 = string2.substring(n2 + 1);
            arrayList.add(string2);
            n2 = string2.indexOf(",");
            if (n == 0 || ++n3 < n) continue;
            break;
        }
        return arrayList;
    }

    private void getDescendants(DataObject dataObject, DataObject dataObject2, List list, List list2, int n, int n2, boolean bl, FileXPathHelper fileXPathHelper) throws Exception {
        boolean bl2 = trcLogger.isLoggable(Level.FINER);
        String string = dataObject.getString(UNIQUE_NAME_PATH);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getDescendants", "currentLevel=" + n2 + ", for parent: " + string);
        }
        int n3 = n2 + 1;
        Set set = this.fileData.getImmediateDescendants(string);
        for (String string2 : set) {
            EClass eClass;
            DataObject dataObject3 = this.fileData.getByDN(string2);
            DataObject dataObject4 = null;
            if (fileXPathHelper == null || fileXPathHelper.evaluate(dataObject3)) {
                eClass = this.schemaMgr.getEClass(dataObject3.getType());
                dataObject4 = (DataObject)EcoreUtil.create((EClass)eClass);
                this.copyDataObject(dataObject4, dataObject3, list, list2, IDENTIFIER_REF);
                dataObject2.getList("children").add(dataObject4);
            }
            if (n != 0 && n3 >= n) continue;
            if (bl) {
                if (dataObject4 == null && FileData.isSuperType("OrgContainer", dataObject3.getType().getName())) {
                    eClass = this.schemaMgr.getEClass(dataObject3.getType());
                    dataObject4 = (DataObject)EcoreUtil.create((EClass)eClass);
                    this.copyDataObject(dataObject4, dataObject3, list, list2, IDENTIFIER_REF);
                    dataObject2.getList("children").add(dataObject4);
                }
                this.getDescendants(dataObject3, dataObject4, list, list2, n, n3, bl, fileXPathHelper);
                continue;
            }
            this.getDescendants(dataObject3, dataObject2, list, list2, n, n3, bl, fileXPathHelper);
        }
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getDescendants");
        }
    }

    private void deleteAll(String string, Map map, boolean bl) throws Exception {
        if (string != null) {
            Collection collection;
            DataObject dataObject = this.fileData.getByDN(string);
            String string2 = dataObject.getType().getName();
            if (FileData.isSuperType("OrgContainer", string2)) {
                collection = this.fileData.getImmediateDescendants(string);
                if (bl) {
                    for (String string3 : collection) {
                        this.deleteAll(string3, map, true);
                    }
                } else if (collection.size() > 0) {
                    throw new EntityHasDescendantsException("ENTITY_HAS_DESCENDENTS", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "deleteAll");
                }
            }
            if ((collection = this.fileData.deleteEntity(string, true)) != null) {
                map.put(string, collection);
            }
            this.fileData.cleanReferences(null, string);
        }
    }

    public DataObject delete(DataObject dataObject) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI delete", WIMTraceHelper.printDataGraph(dataObject));
        }
        String string = null;
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        try {
            Object object;
            AsyncUtils.asyncOperationNotSupported(dataObject, this.fileID, CLASSNAME, "delete");
            Map map = ControlsHelper.getControlMap(dataObject);
            DataObject dataObject3 = (DataObject)map.get("DeleteControl");
            boolean bl2 = dataObject3 != null ? dataObject3.getBoolean("deleteDescendants") : false;
            List list = dataObject.getList("entities");
            HashMap hashMap = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                Object object2 = (DataObject)list.get(i);
                string = object2.getString(UNIQUE_NAME_PATH);
                if (string == null) {
                    object = this.fileData.getEntityID((DataObject)object2);
                    string = this.fileData.getDNForID((String)object);
                }
                this.deleteAll(string, hashMap, bl2);
            }
            for (Object object2 : hashMap.keySet()) {
                object = (List)hashMap.get(object2);
                String string2 = (String)object.get(0);
                String string3 = (String)object.get(1);
                DataObject dataObject4 = this.schemaMgr.createDataObject(dataObject2, "entities", string2);
                DataObject dataObject5 = dataObject4.createDataObject("identifier");
                dataObject5.setString("uniqueName", string);
                dataObject5.setString("externalName", string);
                dataObject5.setString("uniqueId", string3);
                dataObject5.setString("externalId", string3);
                dataObject5.setString("repositoryId", this.fileID);
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            RemoveEntityException removeEntityException = new RemoveEntityException("ENTITY_DELETE_FAILED", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), Level.SEVERE, CLASSNAME, "delete", (Throwable)exception);
            removeEntityException.setRootErrorSource(this.fileID);
            throw removeEntityException;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI delete", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    private DataObject buildReturnDataObjectForUpdate(DataObject dataObject, DataObject dataObject2) throws Exception {
        if (dataObject == null) {
            dataObject = this.schemaMgr.createRootDataObject();
        }
        String string = dataObject2.getType().getName();
        DataObject dataObject3 = dataObject.createDataObject("entities", dataObject2.getType().getURI(), string);
        this.copyDataObject(dataObject3, dataObject2, null, null, IDENTIFIER_REF);
        return dataObject;
    }

    public DataObject update(DataObject dataObject) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        boolean bl2 = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI update", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        String string = null;
        Object var7_6 = null;
        Object var8_7 = null;
        Object var9_8 = null;
        try {
            AsyncUtils.asyncOperationNotSupported(dataObject, this.fileID, CLASSNAME, "update");
            ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
            List list = changeSummary.getChangedDataObjects();
            if (list.size() > 0) {
                for (DataObject dataObject3 : list) {
                    String string2 = dataObject3.getType().getName();
                    Vector vector = (Vector)this.entityRDNs.get(string2);
                    Property property = dataObject3.getContainmentProperty();
                    String string3 = property.getName();
                    if (this.skipProps.contains(string3)) {
                        throw new OperationNotSupportedException("UPDATE_PROPERTY_NOT_SUPPORTED_WITH_CHANGESUMMARY", CLASSNAME, "update");
                    }
                    if (!"entities".equals(string3)) continue;
                    string = dataObject3.getString(UNIQUE_NAME_PATH);
                    if (bl2) {
                        trcLogger.logp(Level.FINEST, CLASSNAME, "update", "updating: " + string);
                    }
                    ArrayList<ModificationItem> arrayList = new ArrayList<ModificationItem>();
                    String string4 = null;
                    for (ChangeSummary.Setting setting : changeSummary.getOldValues(dataObject3)) {
                        Property property2 = setting.getProperty();
                        String string5 = property2.getName();
                        if ("createTimestamp".equals(string5)) {
                            throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms("createTimestamp"), CLASSNAME, "update");
                        }
                        if ("modifyTimestamp".equals(string5)) {
                            throw new UpdateOperationalPropertyException("CANNOT_SPECIFIED_OPERATIONAL_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms("modifyTimestamp"), CLASSNAME, "update");
                        }
                        if (this.isPersonAccountType(string2)) {
                            if ("principalName".equals(string5)) {
                                throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", this.fileID), CLASSNAME, "update");
                            }
                            if ("realm".equals(string5)) {
                                throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("realm", this.fileID), CLASSNAME, "update");
                            }
                        }
                        Object object = setting.getValue();
                        Object object2 = dataObject3.get(property2);
                        if (vector != null && vector.contains(string5)) {
                            if (((String)object2).trim().length() <= 0) {
                                throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms(string5), CLASSNAME, "update");
                            }
                            string4 = UniqueNameHelper.constructUniqueName((List)vector, dataObject3, UniqueNameHelper.getParentDN(string));
                            if (bl) {
                                trcLogger.logp(Level.FINER, CLASSNAME, "update", "1. DN has changed: oldDN=" + string + " #newDN=" + string4);
                            }
                            if (this.fileData.exists(null, string4)) {
                                throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", WIMMessageHelper.generateMsgParms(string4), Level.SEVERE, CLASSNAME, "update");
                            }
                        } else if ("password".equals(string5) && object2 != null) {
                            object2 = FileData.hash((byte[])object2, this.saltLength, this.MDAlgorithm);
                        }
                        if (object instanceof List && ((List)object).size() == 0) {
                            object = null;
                        }
                        if (object2 instanceof List && ((List)object2).size() == 0) {
                            object2 = null;
                        }
                        if (object == null) {
                            arrayList.add(new ModificationItem(1, new BasicAttribute(string5, object2)));
                        } else if (object2 == null) {
                            arrayList.add(new ModificationItem(3, new BasicAttribute(string5, object2)));
                        } else {
                            arrayList.add(new ModificationItem(2, new BasicAttribute(string5, object2)));
                        }
                        if (!bl2) continue;
                        trcLogger.logp(Level.FINEST, CLASSNAME, "update", "changed " + property2.getName() + " from '" + object + "' to '" + object2 + "'");
                    }
                    if (string4 != null) {
                        DataObject dataObject4 = this.fileData.rename(string2, string, string4);
                        string = string4;
                    }
                    this.fileData.modifyProperties(string, arrayList);
                    dataObject2 = this.buildReturnDataObjectForUpdate(dataObject2, this.fileData.getByDN(string));
                }
                if (bl2) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "update", "updated");
                }
            } else {
                List list2 = dataObject.getList("entities");
                Map map = ControlsHelper.getControlMap(dataObject);
                DataObject dataObject5 = (DataObject)map.get("GroupMemberControl");
                DataObject dataObject6 = (DataObject)map.get("GroupMembershipControl");
                int n = 1;
                if (dataObject5 != null) {
                    n = dataObject5.getInt("modifyMode");
                }
                int n2 = 1;
                if (dataObject6 != null) {
                    n2 = dataObject6.getInt("modifyMode");
                }
                Vector<String> vector = null;
                Vector<String> vector2 = null;
                Object var20_31 = null;
                for (int i = 0; i < list2.size(); ++i) {
                    DataObject dataObject7 = (DataObject)list2.get(i);
                    string = this.getUniqueName(dataObject7);
                    String string6 = dataObject7.getType().getName();
                    if (this.isPersonAccountType(string6)) {
                        if (dataObject7.isSet("principalName")) {
                            throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", this.fileID), CLASSNAME, "update");
                        }
                        if (dataObject7.isSet("realm")) {
                            throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("realm", this.fileID), CLASSNAME, "update");
                        }
                    }
                    String string7 = null;
                    boolean bl3 = false;
                    DataObject dataObject8 = dataObject7.getDataObject("parent");
                    if (dataObject8 != null) {
                        string7 = dataObject8.getString(UNIQUE_NAME_PATH);
                        if (!this.fileData.normalizedStringsAreEqual(UniqueNameHelper.getParentDN(string), string7)) {
                            bl3 = true;
                        }
                    } else {
                        string7 = UniqueNameHelper.getParentDN(string);
                    }
                    String string8 = null;
                    List list3 = (List)this.entityRDNs.get(string6);
                    if (list3 != null) {
                        string8 = UniqueNameHelper.constructUniqueName(list3, dataObject7, string7, false);
                    }
                    if (string8 == null && bl3) {
                        int n3 = string.indexOf(UniqueNameHelper.getParentDN(string));
                        string8 = string.substring(0, n3) + string7;
                    }
                    ArrayList<ModificationItem> arrayList = new ArrayList<ModificationItem>();
                    EClass eClass = this.schemaMgr.getEClass(dataObject7.getType());
                    EList eList = eClass.getEAllStructuralFeatures();
                    for (int j = 0; j < eList.size(); ++j) {
                        String string9;
                        int n4;
                        Object object;
                        String string10;
                        EAttribute eAttribute;
                        if (eList.get(j) instanceof EAttribute) {
                            eAttribute = (EAttribute)eList.get(j);
                            string10 = eAttribute.getName();
                            if ("uniqueName".equals(string10) || "externalId".equals(string10) || "uniqueId".equals(string10) || !dataObject7.isSet(string10)) continue;
                            if (list3 != null && list3.contains(string10) && ((String)(object = (String)dataObject7.get(string10))).trim().length() <= 0) {
                                throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms(string10), CLASSNAME, "update");
                            }
                            object = null;
                            if (eAttribute.getUpperBound() == 1) {
                                if ("createTimestamp".equals(string10) || "modifyTimestamp".equals(string10)) continue;
                                if ("password".equals(string10)) {
                                    object = new BasicAttribute(string10, FileData.hash(dataObject7.getBytes(string10), this.saltLength, this.MDAlgorithm));
                                    arrayList.add(new ModificationItem(2, (Attribute)object));
                                    continue;
                                }
                                object = new BasicAttribute(string10, dataObject7.get(string10));
                                arrayList.add(new ModificationItem(2, (Attribute)object));
                                continue;
                            }
                            object = new BasicAttribute(string10, dataObject7.getList(string10));
                            arrayList.add(new ModificationItem(2, (Attribute)object));
                            continue;
                        }
                        if (!(eList.get(j) instanceof EReference) || !dataObject7.isSet(string10 = (eAttribute = (EReference)eList.get(j)).getName()) || "identifier".equals(string10) || "children".equals(string10)) continue;
                        if ("members".equals(string10)) {
                            object = dataObject7.getList(string10);
                            vector2 = new Vector<String>();
                            for (n4 = 0; n4 < object.size(); ++n4) {
                                string9 = this.getUniqueName((DataObject)object.get(n4));
                                if (!this.fileData.mustExist(null, string9)) continue;
                                vector2.add(string9);
                            }
                            continue;
                        }
                        if ("groups".equals(string10)) {
                            object = dataObject7.getList(string10);
                            vector = new Vector<String>();
                            for (n4 = 0; n4 < object.size(); ++n4) {
                                string9 = this.getUniqueName((DataObject)object.get(n4));
                                if (!this.fileData.groupMustExist(null, string9)) continue;
                                vector.add(string9);
                            }
                            continue;
                        }
                        object = null;
                        object = eAttribute.getUpperBound() == 1 ? new BasicAttribute(string10, dataObject7.get(string10)) : new BasicAttribute(string10, dataObject7.getList(string10));
                        arrayList.add(new ModificationItem(2, (Attribute)object));
                    }
                    if (string8 != null && !string.equals(string8)) {
                        if (bl) {
                            trcLogger.logp(Level.FINER, CLASSNAME, "update", "2. DN has changed: oldDN=" + string + " #newDN=" + string8);
                        }
                        if (this.fileData.exists(null, string8)) {
                            throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", WIMMessageHelper.generateMsgParms(string8), Level.SEVERE, CLASSNAME, "update");
                        }
                        DataObject dataObject9 = this.fileData.rename(string6, string, string8);
                        string = string8;
                    }
                    if (arrayList.size() > 0) {
                        if (bl) {
                            trcLogger.logp(Level.FINER, CLASSNAME, "update", "update entry " + string + " with attributes " + arrayList + "....");
                        }
                        this.fileData.modifyProperties(string, arrayList);
                        arrayList = null;
                    }
                    if (vector2 != null) {
                        this.fileData.updateGroupMembers(string, vector2, n);
                        vector2 = null;
                    }
                    if (vector != null) {
                        this.fileData.updateGroupMembership(string, vector, n2);
                        vector = null;
                    }
                    dataObject2 = this.buildReturnDataObjectForUpdate(dataObject2, this.fileData.getByDN(string));
                }
            }
            this.fileData.saveEntities();
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            WIMApplicationException wIMApplicationException = new WIMApplicationException("ENTITY_UPDATE_FAILED", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), Level.SEVERE, CLASSNAME, "update", (Throwable)exception);
            wIMApplicationException.setRootErrorSource(this.fileID);
            throw wIMApplicationException;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI update", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    private void printProperties(String string) {
        List list = this.schemaMgr.getProperties(string);
        for (int i = 0; i < list.size(); ++i) {
            Property property = (Property)list.get(i);
            String string2 = property.getType().getName();
            if (!trcLogger.isLoggable(Level.FINER)) continue;
            trcLogger.logp(Level.FINER, CLASSNAME, "printProperties", "entityType=" + string + ", name=" + property.getName() + ", type=" + string2);
        }
    }

    private String getUniqueName(DataObject dataObject) throws Exception {
        String string = null;
        if ("IdentifierType".equals(dataObject.getType().getName())) {
            String string2 = dataObject.getString("externalId");
            if (string2 == null) {
                string2 = dataObject.getString("uniqueId");
            }
            if (string2 != null) {
                string = this.fileData.getDNForID(string2);
            } else {
                string = dataObject.getString("uniqueName");
                if (string == null) {
                    string = dataObject.getString("externalName");
                }
            }
        } else if (dataObject.getDataObject("identifier") != null) {
            String string3 = this.fileData.getEntityID(dataObject);
            if (string3 != null) {
                string = this.fileData.getDNForID(string3);
            } else {
                string = dataObject.getString(UNIQUE_NAME_PATH);
                if (string == null) {
                    string = dataObject.getString(EXTERNAL_NAME_PATH);
                }
            }
        }
        return string;
    }

    public DataObject search(DataObject dataObject) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI search", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        try {
            AsyncUtils.asyncOperationNotSupported(dataObject, this.fileID, CLASSNAME, "search");
            Map map = ControlsHelper.getControlMap(dataObject);
            DataObject dataObject3 = (DataObject)map.get("SearchControl");
            List list = dataObject3.getList("properties");
            List list2 = dataObject3.getList("contextProperties");
            List list3 = dataObject3.getList("searchBases");
            int n = dataObject3.getInt("timeLimit");
            String string = dataObject3.getString("expression");
            boolean bl2 = dataObject3.getBoolean("returnSubType");
            if (string == null || string.length() == 0) {
                throw new SearchControlException("MISSING_SEARCH_EXPRESSION", Level.SEVERE, CLASSNAME, "search");
            }
            FileXPathHelper fileXPathHelper = new FileXPathHelper(string, list3, this.loginProperties, this.loginPropertiesType, this.caseSensitive);
            List list4 = fileXPathHelper.getEntityTypes();
            List list5 = null;
            try {
                list5 = list4.size() > 1 ? this.fileData.search(list4, fileXPathHelper, true, bl2) : this.fileData.search((String)list4.get(0), fileXPathHelper, true, bl2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "search", (Throwable)illegalArgumentException);
            }
            dataObject2 = this.schemaMgr.createRootDataObject();
            DataObject dataObject42 = null;
            for (DataObject dataObject42 : list5) {
                EClass eClass = this.schemaMgr.getEClass(dataObject42.getType());
                DataObject dataObject5 = (DataObject)EcoreUtil.create((EClass)eClass);
                this.copyDataObject(dataObject5, dataObject42, list, list2, IDENTIFIER_REF);
                dataObject2.getList("entities").add(dataObject5);
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            WIMApplicationException wIMApplicationException = new WIMApplicationException("ENTITY_SEARCH_FAILED", WIMMessageHelper.generateMsgParms(exception.getMessage()), Level.SEVERE, CLASSNAME, "search", (Throwable)exception);
            wIMApplicationException.setRootErrorSource(this.fileID);
            throw wIMApplicationException;
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI search", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataObject login(DataObject dataObject) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI login", WIMTraceHelper.printDataGraph(dataObject));
        }
        DataObject dataObject2 = null;
        DataObject dataObject3 = null;
        Object var6_5 = null;
        String string = null;
        Map map = ControlsHelper.getControlMap(dataObject);
        try {
            String string2;
            DataObject dataObject4;
            AsyncUtils.asyncOperationNotSupported(dataObject, this.fileID, CLASSNAME, "login");
            DataObject dataObject5 = dataObject.getDataObject(DO_ENTITIES0);
            if (dataObject5.isSet("certificate")) {
                throw new CertificateMapNotSupportedException("AUTHENTICATION_WITH_CERT_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(this.fileID), CLASSNAME, "login");
            }
            string = dataObject5.getString("principalName");
            byte[] byArray = dataObject5.getBytes("password");
            if (byArray == null || byArray.length == 0) {
                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PASSWORD", null, Level.WARNING, CLASSNAME, "login");
            }
            String string3 = null;
            String string4 = null;
            DataObject dataObject6 = dataObject5.getDataObject("identifier");
            String string5 = dataObject5.getType().getName();
            String string6 = dataObject5.getType().getURI();
            if (dataObject6 != null) {
                string3 = dataObject6.getString("uniqueName");
                string4 = this.fileData.getIDFromIdentifier(dataObject6);
            }
            if (UniqueNameHelper.isDN(string) != null) {
                string3 = string;
            }
            if (string3 != null && string3.trim().length() != 0) {
                try {
                    dataObject3 = this.fileData.getByDN(string3);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    if (bl) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "WIM_SPI login", "principal DN, " + string3 + ", not found in " + this.fileID, entityNotFoundException);
                    }
                    dataObject2 = this.schemaMgr.createRootDataObject();
                }
            } else if (string4 != null && string4.trim().length() != 0) {
                dataObject3 = this.fileData.getByID(string4);
            } else {
                List list;
                String string7;
                FileXPathHelper fileXPathHelper;
                List list2;
                if (string == null || string.trim().length() == 0) throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", CLASSNAME, "login");
                dataObject4 = (DataObject)map.get("LoginControl");
                string2 = "'";
                if (string.indexOf("'") != -1) {
                    string2 = "\"";
                }
                if ((list2 = this.fileData.search(string5, fileXPathHelper = new FileXPathHelper(string7 = "//entities[@xsi:type=" + string2 + string5 + string2 + " and " + "principalName" + "=" + string2 + string + string2 + "]", list = dataObject4.getList("searchBases"), this.loginProperties, this.loginPropertiesType, this.caseSensitive), true, true)).size() == 1) {
                    dataObject3 = (DataObject)list2.get(0);
                } else if (list2.size() > 1) {
                    throw new PasswordCheckFailedException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "login");
                }
            }
            if (dataObject3 != null) {
                if (!this.checkPassword(byArray, dataObject3.getBytes("password"))) throw new PasswordCheckFailedException("PASSWORD_MATCH_FAILED", null, Level.WARNING, CLASSNAME, "login");
                dataObject4 = (DataObject)map.get("LoginControl");
                string2 = dataObject4 != null ? dataObject4.getList("properties") : null;
                dataObject2 = this.schemaMgr.createRootDataObject();
                DataObject dataObject7 = dataObject2.createDataObject("entities", string6, dataObject3.getType().getName());
                this.copyDataObject(dataObject7, dataObject3, (List)((Object)string2), null, IDENTIFIER_REF);
                if (string != null) {
                    dataObject7.setString("principalName", string);
                }
            } else {
                if (bl) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "WIM_SPI login", "principal, " + string + ", not found in " + this.fileID);
                }
                dataObject2 = this.schemaMgr.createRootDataObject();
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            if (!bl) throw new WIMApplicationException("PASSWORD_CHECKED_FAILED", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), Level.SEVERE, CLASSNAME, "login", (Throwable)exception);
            trcLogger.logp(Level.FINER, CLASSNAME, "WIM_SPI login", "Login failed", exception);
            throw new WIMApplicationException("PASSWORD_CHECKED_FAILED", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), Level.SEVERE, CLASSNAME, "login", (Throwable)exception);
        }
        if (!bl) return dataObject2;
        trcLogger.exiting(CLASSNAME, "WIM_SPI login", WIMTraceHelper.printDataGraph(dataObject2));
        return dataObject2;
    }

    private boolean checkPassword(byte[] byArray, byte[] byArray2) throws WIMException {
        boolean bl = false;
        try {
            if (byArray != null && byArray2 != null) {
                String string = new String(byArray2).trim();
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "checkPassword", "setHashed=#" + string + "#");
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                byte[] byArray3 = FileData.hash(byArray, string3, string2);
                String string4 = new String(byArray3).trim();
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "checkPassword", "inpHashed=#" + string4 + "#");
                }
                if (string.equals(string4)) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINER, CLASSNAME, "checkPassword", "Password match failed", exception);
            throw new PasswordCheckFailedException("PASSWORD_MATCH_FAILED", null, Level.WARNING, CLASSNAME, "checkPassword", (Throwable)exception);
        }
        return bl;
    }

    public void dumpFileData() {
        this.fileData.dumpFileData();
    }

    public DataObject createSchema(DataObject dataObject) throws WIMException {
        this.reloadSchema = true;
        this.fileData.load(null);
        AsyncUtils.asyncOperationNotSupported(dataObject, this.fileID, CLASSNAME, "createSchema");
        throw new OperationNotSupportedException("OPERATION_NOT_SUPPORTED_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("createSchema", this.fileID), CLASSNAME, "createSchema");
    }

    public DataObject getSchema(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getSchema", WIMTraceHelper.printDataObject(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.fileID, CLASSNAME, "getSchema");
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        DataObject dataObject3 = dataObject2.getDataObject("schema");
        if (dataObject3 == null) {
            dataObject3 = dataObject2.createDataObject("schema");
        }
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject4 = (DataObject)map.get("DataTypeControl");
        DataObject dataObject5 = (DataObject)map.get("PropertyDefinitionControl");
        DataObject dataObject6 = (DataObject)map.get("EntityTypeControl");
        SchemaManager schemaManager = SchemaManager.singleton();
        if (dataObject4 != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Set set = schemaManager.getSubEntityTypes("wim:Entity");
            for (String string : set) {
                List list = schemaManager.getProperties(string);
                for (int i = 0; i < list.size(); ++i) {
                    Property property = (Property)list.get(i);
                    String string2 = property.getType().getName();
                    hashSet.add(string2);
                }
            }
            for (String string : hashSet) {
                dataObject3.getList("propertyDataTypes").add(string);
            }
        } else if (dataObject6 != null) {
            List list = ConfigManager.singleton().getSupportedEntityTypes();
            List list2 = dataObject6.getList("entityTypeNames");
            if (list2 == null || list2.size() == 0) {
                if (list != null && list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        DataObject dataObject7 = dataObject3.createDataObject("entitySchema");
                        String string = (String)list.get(i);
                        String string3 = schemaManager.getTypeNsURI(string);
                        dataObject7.set("entityName", (Object)string);
                        dataObject7.set("nsURI", (Object)string3);
                    }
                }
            } else {
                for (int i = 0; i < list2.size(); ++i) {
                    String string = (String)list2.get(i);
                    if (list.contains(string)) {
                        DataObject dataObject8 = dataObject3.createDataObject("entitySchema");
                        String string4 = schemaManager.getTypeNsURI(string);
                        dataObject8.set("entityName", (Object)string);
                        dataObject8.set("nsURI", (Object)string4);
                        continue;
                    }
                    if (!trcLogger.isLoggable(Level.FINE)) continue;
                    trcLogger.logp(Level.FINE, CLASSNAME, "getSchema", "The entity type " + string + " is not supported in repository " + this.fileID);
                }
            }
        } else if (dataObject5 != null) {
            String string = dataObject5.getString("entityTypeName");
            List list = dataObject5.getList("propertyNames");
            if (list != null && list.size() > 0) {
                List list3 = schemaManager.getPropertyNames(string);
                if (list3 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        String string5 = (String)list.get(i);
                        if (!list3.contains(string5)) continue;
                        DataObject dataObject9 = dataObject3.createDataObject("propertySchema");
                        dataObject9.setString("propertyName", string5);
                    }
                }
            } else {
                List list4 = schemaManager.getProperties(string);
                for (int i = 0; list4 != null && i < list4.size(); ++i) {
                    Property property = (Property)list4.get(i);
                    String string6 = property.getName();
                    DataObject dataObject10 = dataObject3.createDataObject("propertySchema");
                    dataObject10.setString("propertyName", string6);
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getSchema", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    public List getBaseEntries() {
        return this.baseEntries;
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI dynamicUpdateConfig", WIMMessageHelper.generateMsgParms(string, WIMTraceHelper.printMapWithoutPassword(hashtable)));
        }
        if ("websphere.usermanager.serviceprovider.add.baseentry".equalsIgnoreCase(string)) {
            String string2 = (String)hashtable.get("DYNA_CONFIG_KEY_BASE_ENTRY");
            if ((string2 = UniqueNameHelper.getValidUniqueName(string2)) == null || string2.trim().equals("")) {
                throw new DynamicUpdateConfigException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "dynamicUpdateConfig");
            }
            for (int i = 0; i < this.baseEntries.size(); ++i) {
                String string3 = (String)this.baseEntries.get(i);
                if (!string3.equalsIgnoreCase(string2)) continue;
                throw new DynamicUpdateConfigException("BASE_ENTRY_ALREADY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string2, this.fileID), CLASSNAME, "dynamicUpdateConfig");
            }
            this.fileData.addBaseEntry(string2);
            this.baseEntries.add(string2);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "WIM_SPI dynamicUpdateConfig", WIMMessageHelper.generateMsgParms(string, WIMTraceHelper.printMapWithoutPassword(hashtable)));
            }
        }
    }
}

