/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.file.was;

import com.ibm.websphere.wim.exception.EntityHasDescendantsException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InitializationException;
import com.ibm.websphere.wim.exception.InvalidArgumentException;
import com.ibm.websphere.wim.exception.InvalidEntityTypeException;
import com.ibm.websphere.wim.exception.NetworkConfigSyncException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.file.was.FileAdapter;
import com.ibm.ws.wim.adapter.file.was.FileUtils;
import com.ibm.ws.wim.adapter.file.was.FileXPathHelper;
import com.ibm.ws.wim.management.DynamicReloadManager;
import com.ibm.ws.wim.management.EventDataWrapper;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.ws.wim.util.PasswordEncryptionUtil;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class FileData {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME;
    private static final Logger trcLogger;
    private static final String DEFAULT_FILE_NAME = "fileRegistry.xml";
    private static final int ENTITY_TYPE = 0;
    private static final int IDENTIFIER_TYPE = 1;
    private static final int MULTI_VALUED = 0;
    private static final int SINGLE_VALUED = 1;
    private String sessionId;
    private String baseDir;
    private String fileName;
    private String absoluteFileName;
    private String fileID;
    private List baseEntries;
    private Object[] handbackObjectArray = new Object[2];
    private Map entityRDN;
    private Map entityDN2DO = Collections.synchronizedMap(new HashMap());
    private Map entityID2DN = Collections.synchronizedMap(new HashMap());
    private Map entityReference = Collections.synchronizedMap(new HashMap());
    private DataGraph entityDG;
    private DataObject entityRoot;
    private int numOfEntities;
    private static SchemaManager schemaMgr;
    private boolean caseSensitive = false;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH);

    public FileData(String string, String string2, String string3, Map map, String string4, List list, boolean bl) throws WIMException {
        boolean bl2 = trcLogger.isLoggable(Level.FINER);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "<init>", "sessionId=" + string + ", baseDir=" + string2 + ", fileName=" + string3 + ", fileID=" + string4 + ", baseEntries=" + list + ", caseSensitive=" + bl + "\n entityRDN=" + map);
        }
        this.sessionId = string;
        this.baseDir = string2;
        this.entityRDN = map;
        this.fileID = string4;
        this.baseEntries = list;
        this.caseSensitive = bl;
        this.fileName = string3 == null || string3.trim().length() == 0 ? DEFAULT_FILE_NAME : string3;
        this.absoluteFileName = string2 + File.separator + this.fileName;
        this.handbackObjectArray[0] = string4;
        for (String string5 : map.keySet()) {
            Vector<EntityRefData> vector;
            if (FileData.isSuperType("Group", string5)) {
                vector = new Vector<EntityRefData>(1);
                vector.add(new EntityRefData("members", 0, 0));
                this.entityReference.put(string5, vector);
                continue;
            }
            if (!FileData.isSuperType("Person", string5) && !FileData.isSuperType("PersonAccount", string5)) continue;
            vector = new Vector(2);
            vector.add(new EntityRefData("manager", 0, 1));
            vector.add(new EntityRefData("secretary", 0, 1));
            this.entityReference.put(string5, vector);
        }
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "<init>", "sessionId=" + this.sessionId + ", baseDir=" + this.baseDir + ", fileName=" + this.fileName + ", absoluteFileName=" + this.absoluteFileName + ", fileID=" + this.fileID + ", baseEntries=" + this.baseEntries + ", caseSensitive=" + this.caseSensitive + "\n entityRDN=" + this.entityRDN + "\n entityReference=" + this.entityReference);
        }
    }

    private RepositoryContext extractFileInWorkspaceContext(String string) throws Exception {
        RepositoryContext repositoryContext;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "extractFileInWorkspaceContext", "sessionId=" + string);
        }
        WorkSpace workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(string);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "getWorkspace", "UserPath: " + workSpace.getUserPath() + ", Path: " + workSpace.getPath() + ", RootContextPath-Name: " + workSpace.getRootContext().getName() + ", RootContextPath-Path: " + workSpace.getRootContext().getPath() + ", RootContextPath-URI: " + workSpace.getRootContext().getURI());
        }
        if ((repositoryContext = workSpace.findContext("cells/" + DynamicReloadManager.getCellName())) != null) {
            if (repositoryContext.isAvailable(this.fileName)) {
                if (bl) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "extractFileInWorkspaceContext", "File " + this.fileName + " is available in the context.");
                }
                repositoryContext.extract(this.fileName, false);
            } else {
                if (bl) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "extractFileInWorkspaceContext", "File " + this.fileName + " is unavailable and hence creating it.");
                }
                Resource.Factory factory = workSpace.getResourceFactoryRegistry().getFactory(URI.createURI((String)this.fileName));
                Resource resource = factory.createResource(URI.createURI((String)this.fileName));
                boolean bl2 = repositoryContext.getResourceSet().getResources().add((Object)resource);
                if (bl) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "extractFileInWorkspaceContext", "resourceAdded=" + bl2);
                }
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "extractFileInWorkspaceContext", "context=" + repositoryContext);
        }
        return repositoryContext;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void load(DataObject var1_1) throws WIMException {
        var3_2 = FileData.trcLogger.isLoggable(Level.FINER);
        if (var3_2) {
            FileData.trcLogger.entering(FileData.CLASSNAME, "load");
        }
        var4_3 = this.absoluteFileName;
        if (var1_1 == null) {
            try {
                if (this.sessionId != null) {
                    if (var3_2) {
                        FileData.trcLogger.logp(Level.FINER, FileData.CLASSNAME, "load", "loading for session=" + this.sessionId);
                    }
                    if ((var5_4 = this.extractFileInWorkspaceContext(this.sessionId)) == null) ** GOTO lbl29
                    var4_3 = var5_4.getPath() + File.separator + this.fileName;
                    if (var3_2) {
                        FileData.trcLogger.logp(Level.FINER, FileData.CLASSNAME, "load", "Loading file: " + var4_3);
                    }
                    this.entityDG = FileUtils.loadFileAsDataGraph(var4_3);
                }
                if (var3_2) {
                    FileData.trcLogger.logp(Level.FINER, FileData.CLASSNAME, "load", "Loading file: " + var4_3);
                }
                this.entityDG = FileUtils.loadFileAsDataGraph(var4_3);
            }
            catch (FileNotFoundException var5_5) {
                FileData.trcLogger.logp(Level.FINER, FileData.CLASSNAME, "load", var5_5.getMessage());
            }
            catch (Exception var5_6) {
                throw new InitializationException("ERROR_READING_FILE", WIMMessageHelper.generateMsgParms(var4_3, var5_6.getMessage()), Level.SEVERE, FileData.CLASSNAME, "load", (Throwable)var5_6);
            }
        } else {
            if (var3_2) {
                FileData.trcLogger.logp(Level.FINER, FileData.CLASSNAME, "load", "Refreshing the cache with new root DO.");
            }
            this.entityDG = var1_1.getDataGraph();
            FileData.trcLogger.logp(Level.FINEST, FileData.CLASSNAME, "load", "Loaded Data:" + this.entityDG);
        }
lbl29:
        // 5 sources

        this.entityRoot = null;
        this.numOfEntities = 0;
        this.entityID2DN.clear();
        this.entityDN2DO.clear();
        if (this.entityDG != null) {
            this.entityRoot = this.entityDG.getRootObject().getDataObject("Root");
            var5_4 = this.entityRoot.getList("entities");
            this.numOfEntities = var5_4.size();
            if (var3_2) {
                FileData.trcLogger.logp(Level.FINER, FileData.CLASSNAME, "load", "Number of entities=" + this.numOfEntities);
            }
            for (var6_7 = 0; var6_7 < this.numOfEntities; ++var6_7) {
                var7_8 = (DataObject)var5_4.get(var6_7);
                var8_9 = this.getEntityID(var7_8);
                var9_10 = var7_8.getString("identifier/uniqueName");
                this.entityID2DN.put(var8_9, var9_10);
                this.entityDN2DO.put(var9_10, var7_8);
            }
            if (FileData.trcLogger.isLoggable(Level.FINEST)) {
                FileData.trcLogger.logp(Level.FINEST, FileData.CLASSNAME, "load", "Data in File Registry=\n" + WIMTraceHelper.printDataGraph(this.entityDG));
            }
        } else if (var3_2) {
            FileData.trcLogger.logp(Level.FINER, FileData.CLASSNAME, "load", "No data exists in the file registry or root DO is empty.");
        }
    }

    public synchronized void addEntity(String string, DataObject dataObject, boolean bl) throws WIMException {
        boolean bl2 = trcLogger.isLoggable(Level.FINER);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "addEntity", string);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "addEntity", "inputDO=" + WIMTraceHelper.printDataObject(dataObject));
        }
        String string2 = null;
        try {
            if (this.entityDG == null) {
                if (bl2) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "addEntity", "Creating first entity in the file: entityType=" + string);
                }
                this.entityRoot = SchemaManager.singleton().createRootDataObject();
                this.entityDG = this.entityRoot.getDataGraph();
            }
            this.entityRoot.getList("entities").add(dataObject);
            ++this.numOfEntities;
            String string3 = this.getEntityID(dataObject);
            string2 = dataObject.getString("identifier/uniqueName");
            this.entityID2DN.put(string3, string2);
            this.entityDN2DO.put(string2, dataObject);
            if (bl2) {
                trcLogger.logp(Level.FINER, CLASSNAME, "addEntity", "Number of entities=" + this.numOfEntities);
            }
            if (bl) {
                this.saveEntities();
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            WIMApplicationException wIMApplicationException = new WIMApplicationException("ENTITY_CREATE_FAILED", WIMMessageHelper.generateMsgParms(string2, exception.getMessage()), Level.SEVERE, CLASSNAME, "addEntity", (Throwable)exception);
            wIMApplicationException.setRootErrorSource(this.fileID);
        }
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "addEntity", "Added " + string + ":" + string2);
        }
    }

    public String getEntityID(DataObject dataObject) {
        String string = dataObject.getString("identifier/externalId");
        if (string == null) {
            string = dataObject.getString("identifier/uniqueId");
        }
        return string;
    }

    public String getIDFromIdentifier(DataObject dataObject) {
        String string = dataObject.getString("externalId");
        if (string == null) {
            string = dataObject.getString("externalId");
        }
        return string;
    }

    public static boolean isSuperType(String string, String string2) {
        return string.equals(string2) || schemaMgr.isSuperType(string, string2);
    }

    public void addMemberDNToGroup(String string, String string2, boolean bl) throws Exception {
        DataObject dataObject;
        boolean bl2;
        boolean bl3 = trcLogger.isLoggable(Level.FINEST);
        if (bl3) {
            trcLogger.entering(CLASSNAME, "addMemberDNToGroup", "adding member " + string2 + " to group " + string);
        }
        if (!(bl2 = this.checkGroupMembership(dataObject = this.getByDN(string), string2, 1, 0))) {
            DataObject dataObject2 = this.getByDN(string2);
            DataGraphHelper.copyDataObject(dataObject.createDataObject("members"), dataObject2, null, null, FileAdapter.IDENTIFIER_REF);
            dataObject.set("modifyTimestamp", (Object)this.getDateString());
            if (bl) {
                this.saveEntities();
            }
        }
        if (bl3) {
            trcLogger.exiting(CLASSNAME, "addMemberDNToGroup", "member added=" + !bl2);
        }
    }

    public void removeMemberDNFromGroup(String string, String string2, boolean bl) throws Exception {
        boolean bl2 = trcLogger.isLoggable(Level.FINEST);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "removeMemberDNFromGroup", string);
        }
        DataObject dataObject = this.getByDN(string);
        boolean bl3 = false;
        List list = dataObject.getList("members");
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject2 = (DataObject)list.get(i);
            String string3 = dataObject2.getString("identifier/uniqueName");
            if (!this.normalizedStringsAreEqual(string3, string2)) continue;
            dataObject2.delete();
            dataObject.set("modifyTimestamp", (Object)this.getDateString());
            bl3 = true;
            if (!bl) break;
            this.saveEntities();
            break;
        }
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "removeMemberDNFromGroup", "member deleted=" + bl3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGroupsForEntity(String string, FileXPathHelper fileXPathHelper) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getGroupsForEntity", string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.entityDN2DO;
        synchronized (map) {
            block3: for (String string2 : this.entityDN2DO.keySet()) {
                DataObject dataObject = this.getByDN(string2);
                if (!FileData.isSuperType("Group", dataObject.getType().getName()) || fileXPathHelper != null && !fileXPathHelper.evaluate(dataObject)) continue;
                List list = dataObject.getList("members");
                for (int i = 0; i < list.size(); ++i) {
                    DataObject dataObject2 = (DataObject)list.get(i);
                    String string3 = dataObject2.getString("identifier/uniqueName");
                    if (!this.normalizedStringsAreEqual(string, string3)) continue;
                    arrayList.add(string2);
                    continue block3;
                }
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getGroupsForEntity", "returning:" + arrayList);
        }
        return arrayList;
    }

    public boolean checkGroupMembership(DataObject dataObject, int n) throws Exception {
        String string;
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "checkGroupMembership(entity,level)", "level=" + n);
        }
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        if (FileData.isSuperType("Group", dataObject.getType().getName())) {
            string2 = dataObject.getString("identifier/uniqueName");
            if (string2 == null) {
                string = this.getEntityID(dataObject);
                string2 = this.getDNForID(string);
            }
            if ((string3 = dataObject.getString("members.0/identifier/uniqueName")) == null) {
                string = this.getEntityID(dataObject.getDataObject("members.0"));
                string3 = this.getDNForID(string);
            }
        } else {
            string3 = dataObject.getString("identifier/uniqueName");
            if (string3 == null) {
                string = this.getEntityID(dataObject);
                string3 = this.getDNForID(string);
            }
            if ((string2 = dataObject.getString("groups.0/identifier/uniqueName")) == null) {
                string = this.getEntityID(dataObject.getDataObject("groups.0"));
                string2 = this.getDNForID(string);
            }
        }
        string = this.getByDN(string2);
        this.getByDN(string3);
        if (bl) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "checkGroupMembership(entity,level)", "memberDN=" + string3);
        }
        bl2 = this.checkGroupMembership((DataObject)string, string3, n, 0);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "checkGroupMembership(entity,level)", "inGroup=" + bl2);
        }
        return bl2;
    }

    private boolean checkGroupMembership(DataObject dataObject, String string, int n, int n2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "checkGroupMembership", "currentLevel=" + n2 + ", groupDN=" + dataObject.getString("identifier/uniqueName"));
        }
        int n3 = n2 + 1;
        boolean bl2 = false;
        if (FileData.isSuperType("Group", dataObject.getType().getName())) {
            String string2;
            DataObject dataObject2;
            int n4;
            List list = dataObject.getList("members");
            for (n4 = 0; n4 < list.size(); ++n4) {
                dataObject2 = (DataObject)list.get(n4);
                string2 = dataObject2.getString("identifier/uniqueName");
                if (!this.normalizedStringsAreEqual(string2, string)) continue;
                bl2 = true;
                break;
            }
            if (!(bl2 || n != 0 && n3 >= n)) {
                list = dataObject.getList("members");
                for (n4 = 0; n4 < list.size(); ++n4) {
                    dataObject2 = (DataObject)list.get(n4);
                    string2 = this.getByDN(dataObject2.getString("identifier/uniqueName"));
                    if (!FileData.isSuperType("Group", string2.getType().getName())) continue;
                    bl2 |= this.checkGroupMembership((DataObject)string2, string, n, n3);
                }
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "checkGroupMembership", "inGroup=" + bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accountExists(String string, String string2) throws Exception {
        boolean bl = false;
        Map map = this.entityDN2DO;
        synchronized (map) {
            for (String string3 : this.entityDN2DO.keySet()) {
                DataObject dataObject = this.getByDN(string3);
                if (!FileData.isSuperType("LoginAccount", dataObject.getType().getName()) || !this.normalizedStringsAreEqual(string, dataObject.getString(string2))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean mustExist(String string, String string2) throws EntityNotFoundException {
        if (!this.normalizedBaseEntriesAreEqual(string2) && !this.exists(string, string2)) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "mustExist");
        }
        return true;
    }

    public boolean groupMustExist(String string, String string2) throws Exception {
        if (this.mustExist(string, string2)) {
            DataObject dataObject = null;
            dataObject = string != null ? this.getByID(string) : this.getByDN(string2);
            if (!FileData.isSuperType("Group", dataObject.getType().getName())) {
                String string3 = string != null ? string : string2;
                throw new InvalidEntityTypeException("ENTITY_IS_NOT_A_GROUP", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, "groupMustExist");
            }
        }
        return true;
    }

    public boolean exists(String string, String string2) {
        return string != null && this.entityID2DN.containsKey(string) || string2 != null && this.containsNormalizedKey(this.entityDN2DO, string2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List search(String string, FileXPathHelper fileXPathHelper, boolean bl, boolean bl2) throws Exception {
        boolean bl3 = trcLogger.isLoggable(Level.FINEST);
        if (bl3) {
            trcLogger.entering(CLASSNAME, "search", string + ", searchStr=" + fileXPathHelper.getNode());
        }
        Vector<DataObject> vector = new Vector<DataObject>();
        if (fileXPathHelper.getPrincipalNameDN() != null) {
            DataObject dataObject = this.getByDN(fileXPathHelper.getPrincipalNameDN());
            if (dataObject != null) {
                vector.add(dataObject);
            }
            return vector;
        }
        Map map = this.entityDN2DO;
        synchronized (map) {
            for (DataObject dataObject : this.entityDN2DO.values()) {
                if (!string.equals(dataObject.getType().getName()) && (!bl2 || !FileData.isSuperType(string, dataObject.getType().getName())) || !fileXPathHelper.evaluate(dataObject)) continue;
                vector.add(dataObject);
                if (bl) continue;
                break;
            }
        }
        if (bl3) {
            trcLogger.exiting(CLASSNAME, "search", "Number of matched entities=" + vector.size());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List search(List list, FileXPathHelper fileXPathHelper, boolean bl, boolean bl2) throws Exception {
        boolean bl3 = trcLogger.isLoggable(Level.FINEST);
        if (bl3) {
            trcLogger.entering(CLASSNAME, "search(List)", list + ", searchStr=" + fileXPathHelper.getNode());
        }
        Vector<DataObject> vector = new Vector<DataObject>();
        if (fileXPathHelper.getPrincipalNameDN() != null) {
            DataObject dataObject = this.getByDN(fileXPathHelper.getPrincipalNameDN());
            if (dataObject != null) {
                vector.add(dataObject);
            }
            return vector;
        }
        Map map = this.entityDN2DO;
        synchronized (map) {
            for (DataObject dataObject : this.entityDN2DO.values()) {
                boolean bl4 = false;
                for (int i = 0; i < list.size(); ++i) {
                    String string = (String)list.get(i);
                    if (!string.equals(dataObject.getType().getName()) && (!bl2 || !FileData.isSuperType(string, dataObject.getType().getName()))) continue;
                    bl4 = true;
                    break;
                }
                if (!bl4 || !fileXPathHelper.evaluate(dataObject)) continue;
                vector.add(dataObject);
                if (bl) continue;
                break;
            }
        }
        if (bl3) {
            trcLogger.exiting(CLASSNAME, "search(List)", "Number of matched entities=" + vector.size());
        }
        return vector;
    }

    public DataObject get(String string, String string2) throws Exception {
        DataObject dataObject;
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "get", string + ":" + string2);
        }
        DataObject dataObject2 = dataObject = this.entityDG != null ? this.entityRoot.getDataObject(string2) : null;
        if (bl) {
            trcLogger.exiting(CLASSNAME, "get", WIMTraceHelper.printDataObject(dataObject));
        }
        return dataObject;
    }

    public DataObject getByDN(String string) throws Exception {
        String string2;
        DataObject dataObject = (DataObject)this.entityDN2DO.get(string);
        if (dataObject == null && !this.caseSensitive && (string2 = this.containsNormalizedKey(this.entityDN2DO, string)) != null) {
            dataObject = (DataObject)this.entityDN2DO.get(string2);
        }
        if (dataObject == null) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getByDN");
        }
        return dataObject;
    }

    public String getDNForID(String string) throws Exception {
        String string2 = (String)this.entityID2DN.get(string);
        if (string2 == null) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.FINE, CLASSNAME, "getDNForID");
        }
        return string2;
    }

    public DataObject getByID(String string) throws Exception {
        return this.getByDN((String)this.entityID2DN.get(string));
    }

    public Set getImmediateDescendants(String string) {
        List list;
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getImmediateDescendants(DN)", "DN:" + string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (this.entityDG != null && (list = this.entityRoot.getList("entities")) != null) {
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject = (DataObject)list.get(i);
                DataObject dataObject2 = dataObject.getDataObject("parent");
                if (!this.identifierMatches(null, string, dataObject2, 0)) continue;
                hashSet.add(dataObject.getString("identifier/uniqueName"));
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getImmediateDescendants(DN)", "Descendants:" + hashSet);
        }
        return hashSet;
    }

    public synchronized List deleteEntity(String string, boolean bl) throws Exception {
        String string2;
        boolean bl2 = trcLogger.isLoggable(Level.FINEST);
        if (bl2) {
            trcLogger.entering(CLASSNAME, "deleteEntity(DN,save)", "DN:" + string + " #save=" + bl);
        }
        ArrayList<String> arrayList = null;
        DataObject dataObject = (DataObject)this.entityDN2DO.remove(string);
        if (dataObject == null && !this.caseSensitive && (string2 = this.containsNormalizedKey(this.entityDN2DO, string)) != null) {
            dataObject = (DataObject)this.entityDN2DO.remove(string2);
        }
        if (dataObject != null) {
            arrayList = new ArrayList<String>();
            arrayList.add(dataObject.getType().getName());
            string2 = this.getEntityID(dataObject);
            arrayList.add(string2);
            this.entityID2DN.remove(string2);
            dataObject.delete();
            --this.numOfEntities;
            if (bl) {
                this.saveEntities();
            }
        } else {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "deleteEntity(DN,save)");
        }
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "deleteEntity(DN,save)", "deleted " + arrayList + ", numOfEntities=" + this.numOfEntities);
        }
        return arrayList;
    }

    private DataObject hasReference(DataObject dataObject, EntityRefData entityRefData, String string, String string2) {
        DataObject dataObject2 = null;
        String string3 = entityRefData.getRefProperty();
        int n = entityRefData.getValueType();
        int n2 = entityRefData.getEntityType();
        if (n == 0) {
            List list = dataObject.getList(string3);
            if (list == null) {
                return dataObject2;
            }
            for (int i = 0; i < list.size(); ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                if (!this.identifierMatches(string, string2, dataObject3, n2)) continue;
                dataObject2 = dataObject3;
                break;
            }
        } else {
            DataObject dataObject4 = dataObject.getDataObject(string3);
            if (this.identifierMatches(string, string2, dataObject4, n2)) {
                dataObject2 = dataObject4;
            }
        }
        return dataObject2;
    }

    public synchronized void cleanReferences(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "cleanReferences(ID, DN)", "ID:" + string + ", #DN:" + string2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = false;
        List list = this.entityRoot.getList("entities");
        if (list == null || list.size() == 0) {
            if (bl) {
                trcLogger.exiting(CLASSNAME, "cleanReferences(ID, DN)", "No entities in the repository");
            }
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject = (DataObject)list.get(i);
            Vector vector = (Vector)this.entityReference.get(dataObject.getType().getName());
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                DataObject dataObject2 = this.hasReference(dataObject, (EntityRefData)vector.get(j), string, string2);
                if (dataObject2 == null) continue;
                bl2 = true;
                dataObject2.delete();
                hashSet.add(dataObject.getString("identifier/uniqueName"));
                dataObject.set("modifyTimestamp", (Object)this.getDateString());
            }
        }
        if (bl2) {
            this.saveEntities();
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "cleanReferences(ID, DN)", "References deleted from:" + hashSet);
        }
    }

    public synchronized void changeReferences(String string, String string2) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "changeReferences(oldDN,newDN)", "oldDN:" + string + ", #newDN:" + string2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        List list = this.entityRoot.getList("entities");
        if (list == null || list.size() == 0) {
            if (bl) {
                trcLogger.exiting(CLASSNAME, "changeReferences(oldDN,newDN)", "No entities in the repository");
            }
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject = (DataObject)list.get(i);
            Vector vector = (Vector)this.entityReference.get(dataObject.getType().getName());
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                DataObject dataObject2 = this.hasReference(dataObject, (EntityRefData)vector.get(j), null, string);
                if (dataObject2 == null) continue;
                if (dataObject2.getType().getName().equals("identifier")) {
                    dataObject2.setString("uniqueName", string2);
                    dataObject2.setString("externalName", string2);
                } else {
                    dataObject2.setString("identifier/uniqueName", string2);
                    dataObject2.setString("identifier/externalName", string2);
                }
                hashSet.add(dataObject.getString("identifier/uniqueName"));
                dataObject.set("modifyTimestamp", (Object)this.getDateString());
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "changeReferences(oldDN,newDN)", "References updated for:" + hashSet);
        }
    }

    public void modifyProperties(String string, List list) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "modifyProperties(DN,modItems)", "DN:" + string);
        }
        DataObject dataObject = this.getByDN(string);
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            ModificationItem modificationItem = (ModificationItem)list.get(i);
            int n = modificationItem.getModificationOp();
            Attribute attribute = modificationItem.getAttribute();
            String string2 = attribute.getID();
            if (n == 2 || n == 3) {
                if (bl) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "modifyProperties(DN,modItems)", "removing property:" + string2);
                }
                dataObject.unset(string2);
            }
            if (n != 2 && n != 1) continue;
            if (bl) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "modifyProperties(DN,modItems)", "adding property:" + string2);
            }
            if ((object = attribute.get()) instanceof List) {
                List list2 = (List)object;
                for (int j = 0; j < list2.size(); ++j) {
                    if (list2.get(j) instanceof DataObject) {
                        DataObject dataObject2 = dataObject.createDataObject(string2);
                        DataGraphHelper.copyDataObject(dataObject2, (DataObject)list2.get(j), DataGraphHelper.WILDCARD_LIST, DataGraphHelper.WILDCARD_LIST, DataGraphHelper.WILDCARD_LIST);
                        continue;
                    }
                    dataObject.getList(string2).add(list2.get(j));
                }
                continue;
            }
            dataObject.set(string2, object);
        }
        dataObject.set("modifyTimestamp", (Object)this.getDateString());
        if (bl) {
            trcLogger.exiting(CLASSNAME, "modifyProperties(DN,modItems)");
        }
    }

    public DataObject rename(String string, String string2, String string3) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "rename(entityType,DN,newDN)", "DN:" + string2 + " #newDN:" + string3);
        }
        if (string2 == null || string3 == null) {
            throw new InvalidArgumentException("ENTITY_IDENTIFIER_NOT_SPECIFIED", null, Level.SEVERE, CLASSNAME, "rename(entityType,DN,newDN)");
        }
        if (FileData.isSuperType("OrgContainer", string) && this.getImmediateDescendants(string2).size() > 0) {
            throw new EntityHasDescendantsException("ENTITY_HAS_DESCENDENTS", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "rename(entityType,DN,newDN)");
        }
        DataObject dataObject = this.getByDN(string2);
        DataObject dataObject2 = dataObject.getDataObject("identifier");
        String string4 = dataObject2.getString("uniqueName");
        String string5 = this.getEntityID(dataObject);
        dataObject2.set("uniqueName", (Object)string3);
        dataObject2.set("externalName", (Object)string3);
        dataObject.set("modifyTimestamp", (Object)this.getDateString());
        this.entityDN2DO.remove(string4);
        this.entityDN2DO.put(string3, dataObject);
        this.entityID2DN.put(string5, string3);
        this.changeReferences(string4, string3);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "rename(entityType,DN,newDN)");
        }
        return dataObject;
    }

    public void updateGroupMembership(String string, List list, int n) throws Exception {
        block5: {
            block4: {
                List list2;
                if (n == 2 && (list2 = this.getGroupsForEntity(string, null)) != null) {
                    for (int i = 0; i < list2.size(); ++i) {
                        this.removeMemberDNFromGroup((String)list2.get(i), string, false);
                    }
                }
                if (n != 1 && n != 2) break block4;
                for (int i = 0; i < list.size(); ++i) {
                    this.addMemberDNToGroup((String)list.get(i), string, false);
                }
                break block5;
            }
            if (n != 3) break block5;
            for (int i = 0; i < list.size(); ++i) {
                this.removeMemberDNFromGroup((String)list.get(i), string, false);
            }
        }
    }

    public void updateGroupMembers(String string, List list, int n) throws Exception {
        block4: {
            block3: {
                if (n == 2) {
                    DataObject dataObject = this.getByDN(string);
                    dataObject.unset("members");
                }
                if (n != 1 && n != 2) break block3;
                for (int i = 0; i < list.size(); ++i) {
                    this.addMemberDNToGroup(string, (String)list.get(i), false);
                }
                break block4;
            }
            if (n != 3) break block4;
            for (int i = 0; i < list.size(); ++i) {
                this.removeMemberDNFromGroup(string, (String)list.get(i), false);
            }
        }
    }

    public boolean identifierMatches(String string, String string2, DataObject dataObject, int n) {
        DataObject dataObject2;
        if (dataObject == null) {
            return false;
        }
        DataObject dataObject3 = dataObject2 = 0 == n ? dataObject.getDataObject("identifier") : dataObject;
        if (dataObject2 == null) {
            return false;
        }
        String string3 = this.getIDFromIdentifier(dataObject2);
        String string4 = dataObject2.getString("uniqueName");
        if (string != null && string3 != null && string.equals(string3)) {
            return true;
        }
        return string2 != null && string4 != null && this.normalizedStringsAreEqual(string2, string4);
    }

    public synchronized void saveEntities() throws WIMException {
        String string;
        boolean bl;
        block15: {
            bl = trcLogger.isLoggable(Level.FINEST);
            if (bl) {
                trcLogger.entering(CLASSNAME, "saveEntities", "filename=" + this.fileName + ", absoluteFileName=" + this.absoluteFileName);
            }
            string = this.absoluteFileName;
            try {
                if (this.sessionId != null) {
                    RepositoryContext repositoryContext;
                    if (bl) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "saveEntities", "saving for session=" + this.sessionId);
                    }
                    if ((repositoryContext = this.extractFileInWorkspaceContext(this.sessionId)) != null) {
                        int n = 1;
                        if (!repositoryContext.isAvailable(this.fileName)) {
                            n = 0;
                        }
                        string = repositoryContext.getPath() + File.separator + this.fileName;
                        if (bl) {
                            trcLogger.logp(Level.FINER, CLASSNAME, "saveEntities", "operation=" + n);
                            trcLogger.logp(Level.FINER, CLASSNAME, "saveEntities", "saving to " + string);
                        }
                        DataGraphHelper.saveDataGraphWithoutCopyright(this.entityDG, string);
                        repositoryContext.notifyChanged(n, this.fileName);
                        if (bl) {
                            List list = repositoryContext.getModifiedList(true);
                            if (list.size() > 0) {
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    trcLogger.logp(Level.FINER, CLASSNAME, "saveEntities", "Status changed for " + iterator.next().toString());
                                }
                            } else {
                                trcLogger.logp(Level.FINER, CLASSNAME, "saveEntities", "No resource was modified");
                            }
                        }
                        break block15;
                    }
                    trcLogger.logp(Level.FINER, CLASSNAME, "saveEntities", "Repository Context is null.");
                    throw new WIMApplicationException("ERROR_WRITING_FILE", WIMMessageHelper.generateMsgParms(string, "Null Workspace Context"), Level.SEVERE, CLASSNAME, "saveEntities");
                }
                if (DynamicReloadManager.isRunningOnDeploymentManager() || DynamicReloadManager.isRunningOnSingleServer() || DynamicReloadManager.isConnectionTypeNone()) {
                    DataGraphHelper.saveDataGraphWithoutCopyright(this.entityDG, string);
                    if (DynamicReloadManager.isRunningOnDeploymentManager()) {
                        this.handbackObjectArray[1] = this.entityDG.getRootObject();
                        EventDataWrapper eventDataWrapper = new EventDataWrapper("websphere.usermanager.fileregistry.change", this.handbackObjectArray);
                        DynamicReloadManager.singleton().broadcastEventAtDeploymentManager("websphere.usermanager.fileregistry.change", "File Registry Change Event for " + this.fileID, eventDataWrapper);
                    }
                    break block15;
                }
                throw new NetworkConfigSyncException("DYNAMIC_RELOAD_INVALID_UPDATE_AT_MANAGED_NODE", Level.SEVERE, CLASSNAME, "saveEntities");
            }
            catch (Exception exception) {
                throw new WIMApplicationException("ERROR_WRITING_FILE", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), Level.SEVERE, CLASSNAME, "saveEntities", (Throwable)exception);
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "saveEntities", "saved to file=" + string);
        }
    }

    protected static byte[] hash(byte[] byArray, int n, String string) throws WIMException {
        String string2 = PasswordEncryptionUtil.generateSalt(n);
        return FileData.hash(byArray, string2, string);
    }

    protected static byte[] hash(byte[] byArray, String string, String string2) throws WIMException {
        byte[] byArray2 = PasswordUtil.getByteArrayPassword(string);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray3[i] = byArray2[i];
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i++] = byArray[i];
        }
        String string3 = PasswordEncryptionUtil.hash(byArray3, string2);
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(":");
        stringBuffer.append(string);
        stringBuffer.append(":");
        stringBuffer.append(string3);
        PasswordUtil.erasePassword(byArray3);
        return stringBuffer.toString().getBytes();
    }

    public boolean normalizedStringsAreEqual(String string, String string2) {
        if (this.caseSensitive) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    private boolean normalizedBaseEntriesAreEqual(String string) {
        if (this.caseSensitive) {
            return this.baseEntries.contains(string);
        }
        return RepositoryManager.matchBaseEntryIgnoreCase(this.baseEntries, string);
    }

    public String containsNormalizedKey(Map map, String string) {
        if (map.containsKey(string)) {
            return string;
        }
        if (!this.caseSensitive) {
            for (String string2 : map.keySet()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
        }
        return null;
    }

    public String getDateString() {
        StringBuffer stringBuffer = new StringBuffer(this.sdf.format(new Date()));
        stringBuffer.insert(stringBuffer.length() - 2, ":");
        return stringBuffer.toString();
    }

    protected void dumpFileData() {
        boolean bl = trcLogger.isLoggable(Level.FINE);
        if (bl) {
            trcLogger.entering(CLASSNAME, "dumpFileData");
            trcLogger.logp(Level.FINE, CLASSNAME, "dumpFileData", "entityRDN=" + this.entityRDN);
            trcLogger.logp(Level.FINE, CLASSNAME, "dumpFileData", "entityRererence=" + this.entityReference);
            trcLogger.logp(Level.FINE, CLASSNAME, "dumpFileData", "numOfEntities=" + this.numOfEntities);
            trcLogger.logp(Level.FINE, CLASSNAME, "dumpFileData", "entityDNs=" + this.entityDN2DO.keySet());
            trcLogger.logp(Level.FINE, CLASSNAME, "dumpFileData", "entityID2DNs=" + this.entityID2DN);
            trcLogger.logp(Level.FINE, CLASSNAME, "dumpFileData", "entityDG=" + WIMTraceHelper.printDataGraph(this.entityDG));
        }
    }

    public synchronized void addBaseEntry(String string) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "addBaseEntry", "Adding " + string);
        }
        this.baseEntries.add(string);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "addBaseEntry", "baseEntries=" + this.baseEntries);
        }
    }

    static {
        block2: {
            CLASSNAME = FileData.class.getName();
            trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
            try {
                schemaMgr = SchemaManager.singleton();
            }
            catch (WIMException wIMException) {
                if (!trcLogger.isLoggable(Level.FINE)) break block2;
                trcLogger.logp(Level.FINE, CLASSNAME, "staticInit", "failed to get SchemaManager", wIMException);
            }
        }
    }

    class EntityRefData {
        String refProp = null;
        int vType;
        int eType;

        EntityRefData(String string, int n, int n2) {
            this.refProp = string;
            this.vType = n;
            this.eType = n2;
        }

        String getRefProperty() {
            return this.refProp;
        }

        int getValueType() {
            return this.vType;
        }

        int getEntityType() {
            return this.eType;
        }

        public String toString() {
            return "refProp=" + this.refProp + ", vType=" + this.vType + ", eType=" + this.eType;
        }
    }
}

