/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.file.was;

import com.ibm.websphere.wim.ras.WIMLogger;
import commonj.sdo.DataGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class FileUtils {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = FileUtils.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public static boolean fileExists(String string) {
        try {
            File file;
            if (string != null && (file = new File(string)).exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINER, CLASSNAME, "fileExists", "checking for file: " + string, exception);
        }
        return false;
    }

    public static DataGraph loadFileAsDataGraph(String string) throws Exception {
        EDataGraph eDataGraph = null;
        long l = System.currentTimeMillis();
        trcLogger.logp(Level.FINER, CLASSNAME, "loadFileAsDataGraph", "Loading from " + string);
        HashMap<String, ExtendedMetaData> hashMap = new HashMap<String, ExtendedMetaData>();
        hashMap.put("EXTENDED_META_DATA", ExtendedMetaData.INSTANCE);
        FileInputStream fileInputStream = new FileInputStream(string);
        eDataGraph = SDOUtil.loadDataGraph((InputStream)fileInputStream, hashMap);
        fileInputStream.close();
        if (trcLogger.isLoggable(Level.FINER)) {
            long l2 = System.currentTimeMillis();
            trcLogger.logp(Level.FINER, CLASSNAME, "loadFileAsDataGraph", "Loaded from " + string + " (" + (l2 - l) + " milliseconds)");
        }
        trcLogger.logp(Level.FINEST, CLASSNAME, "loadFileAsDataGraph", "Loaded Data:" + eDataGraph);
        return eDataGraph;
    }
}

