/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.file.was;

import com.ibm.websphere.wim.exception.InvalidArgumentException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.adapter.file.was.FileData;
import com.ibm.ws.wim.util.StringUtil;
import com.ibm.ws.wim.util.UniqueNameHelper;
import com.ibm.ws.wim.xpath.TokenMgrError;
import com.ibm.ws.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.wim.xpath.mapping.datatype.LogicalNode;
import com.ibm.ws.wim.xpath.mapping.datatype.ParenthesisNode;
import com.ibm.ws.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import commonj.sdo.DataObject;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileXPathHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = FileXPathHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private Stack logOps = null;
    private DataObject entity = null;
    private List entityTypes = null;
    private XPathNode node = null;
    private List searchBases = null;
    private List loginProperties = null;
    private List loginPropertiesType = null;
    private boolean isPrincipalNameSearch = false;
    private String principalNameDN = null;
    private boolean caseSensitive = false;

    public FileXPathHelper() {
    }

    public FileXPathHelper(boolean bl) {
        this.caseSensitive = bl;
    }

    public FileXPathHelper(String string, List list, List list2, List list3, boolean bl) throws WIMException {
        boolean bl2 = trcLogger.isLoggable(Level.FINEST);
        if (bl2) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "<init>", "searchExpr=" + string + ", searchBases=" + list);
        }
        this.logOps = new Stack();
        this.parseSearchExpression(string);
        this.searchBases = list;
        this.loginProperties = list2;
        this.loginPropertiesType = list3;
        this.caseSensitive = bl;
    }

    public List getEntityTypes() {
        return this.entityTypes;
    }

    public XPathNode getNode() {
        return this.node;
    }

    public boolean isPrincipalNameSearch() {
        return this.isPrincipalNameSearch;
    }

    public String getPrincipalNameDN() {
        return this.principalNameDN;
    }

    public void parseSearchExpression(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "parseSearchExpression", "parsing " + string);
        }
        try {
            if (string == null || string.trim().length() == 0) {
                return;
            }
            WIMXPathInterpreter wIMXPathInterpreter = new WIMXPathInterpreter(new StringReader(string));
            this.node = wIMXPathInterpreter.parse(null);
            this.entityTypes = wIMXPathInterpreter.getEntityTypes();
            HashMap hashMap = new HashMap();
            if (this.node != null) {
                Iterator iterator = this.node.getPropertyNodes(hashMap);
                while (iterator.hasNext()) {
                    PropertyNode propertyNode = (PropertyNode)iterator.next();
                    propertyNode.setName(this.removeNamespace(propertyNode.getName()));
                    String string2 = (String)propertyNode.getValue();
                    this.validatePropertyNode(propertyNode);
                    this.countWildcardsAndValidatePattern(string2);
                }
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMApplicationException("MALFORMED_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), Level.WARNING, CLASSNAME, "parseSearchExpression", (Throwable)exception);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "parseSearchExpression", (Throwable)tokenMgrError);
        }
    }

    public void validatePropertyNode(PropertyNode propertyNode) throws Exception {
        String string = propertyNode.getName();
        if (this.isPrincipalNameSearch) {
            throw new WIMApplicationException("CANNOT_SEARCH_PRINCIPAL_NAME_WITH_OTHER_PROPS", Level.WARNING, CLASSNAME, "validatePropertyNode");
        }
        if ("principalName".equals(string)) {
            this.isPrincipalNameSearch = true;
            String string2 = (String)propertyNode.getValue();
            if (string2 != null && !string2.trim().equals("") && UniqueNameHelper.isDN(string2) != null) {
                this.principalNameDN = string2;
            }
        }
    }

    public int countWildcardsAndValidatePattern(String string) throws InvalidArgumentException {
        int n;
        int n2 = 0;
        try {
            n = string.indexOf("*");
            if (n != -1) {
                while (n != -1 && n + 1 <= string.length()) {
                    ++n2;
                    n = string.indexOf("*", n + 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 1) {
            n = 0;
            if (n2 == 2 && string.length() > 2 && string.startsWith("*") && string.endsWith("*")) {
                n = 1;
            }
            if (n == 0) {
                throw new InvalidArgumentException("INVALID_SEARCH_PATTERN", WIMMessageHelper.generateMsgParms(string), Level.WARNING, CLASSNAME, "countWildcardAndValidatePattern");
            }
        }
        return n2;
    }

    public String removeNamespace(String string) {
        String string2 = string.replace('\'', ' ').trim();
        int n = string2.indexOf(":");
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }

    public void setEntity(DataObject dataObject) {
        this.entity = dataObject;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "setEntity", "evaluate search expression for " + dataObject.getString("identifier/uniqueName"));
        }
    }

    public boolean evaluate(DataObject dataObject) throws Exception {
        this.setEntity(dataObject);
        if (this.entityTypes == null && this.node == null) {
            return this.matchSearchBase();
        }
        if (this.matchEntityType()) {
            if (this.node != null) {
                return this.evaluateXPathNode(this.node);
            }
            return this.matchSearchBase();
        }
        return false;
    }

    public boolean evaluateXPathNode(XPathNode xPathNode) throws Exception {
        switch (xPathNode.getNodeType()) {
            case 0: {
                return this.evaluateXPathNode((PropertyNode)xPathNode);
            }
            case 2: {
                return this.evaluateXPathNode((ParenthesisNode)xPathNode);
            }
            case 1: {
                return this.evaluateXPathNode((LogicalNode)xPathNode);
            }
        }
        return false;
    }

    private boolean evaluateXPathNode(PropertyNode propertyNode) throws Exception {
        boolean bl;
        boolean bl2;
        block19: {
            bl2 = trcLogger.isLoggable(Level.FINEST);
            if (bl2) {
                trcLogger.entering(CLASSNAME, "evaluateXPathNode(propertyNode)", "evaluating " + propertyNode);
            }
            bl = false;
            if (this.matchSearchBase()) {
                try {
                    String string = propertyNode.getName();
                    String string2 = propertyNode.getOperator();
                    String string3 = (String)propertyNode.getValue();
                    if (this.isPrincipalNameSearch) {
                        if (this.principalNameDN != null) {
                            bl = this.patternMatch(this.entity.getString("identifier/uniqueName"), string2, string3);
                        } else {
                            for (int i = 0; i < this.loginProperties.size(); ++i) {
                                String string4 = (String)this.loginProperties.get(i);
                                if (Boolean.FALSE.equals((Boolean)this.loginPropertiesType.get(i))) {
                                    bl = this.patternMatch(this.entity.getString(string4), string2, string3);
                                    if (!bl) continue;
                                    break;
                                }
                                List list = this.entity.getList(string4);
                                for (int j = 0; j < list.size() && !(bl = this.patternMatch((String)list.get(j), string2, string3)); ++j) {
                                }
                            }
                        }
                        return bl;
                    }
                    if (!this.entity.isSet(string)) break block19;
                    Object object = this.entity.get(string);
                    if (object instanceof List) {
                        List list = (List)object;
                        for (int i = 0; i < list.size(); ++i) {
                            object = list.get(i);
                            if (object instanceof DataObject) {
                                DataObject dataObject = (DataObject)object;
                                if (dataObject.getType().getName().equals("IdentifierType")) {
                                    String string5 = dataObject.getString("uniqueName");
                                    if (string5 == null) {
                                        string5 = dataObject.getString("externalName");
                                    }
                                    bl = this.patternMatch(string5, string2, string3);
                                }
                            } else {
                                bl = this.patternMatch(object, string2, string3);
                            }
                            if (!bl) {
                                continue;
                            }
                            break block19;
                        }
                        break block19;
                    }
                    String string6 = String.valueOf(object);
                    bl = this.patternMatch(string6, string2, string3);
                }
                catch (Exception exception) {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "evaluateXPathNode(propertyNode)", "Exception occurred:", exception);
                    }
                    throw exception;
                }
            }
        }
        if (bl2) {
            trcLogger.exiting(CLASSNAME, "evaluateXPathNode(propertyNode)", "match=" + bl);
        }
        return bl;
    }

    public boolean matchSearchBase() {
        boolean bl = true;
        if (this.searchBases != null && this.searchBases.size() > 0) {
            String string = null;
            DataObject dataObject = this.entity.getDataObject("identifier");
            if (dataObject != null) {
                string = dataObject.getString("uniqueName");
            }
            if (string != null) {
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "matchSearchBase", "evaluating dn:" + string);
                }
                bl = false;
                for (int i = 0; i < this.searchBases.size(); ++i) {
                    if (!this.normalizedStringsEndsWith(string, (String)this.searchBases.get(i))) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public boolean matchEntityType() {
        boolean bl = false;
        String string = this.entity.getType().getName();
        for (int i = 0; i < this.entityTypes.size(); ++i) {
            if (!FileData.isSuperType((String)this.entityTypes.get(i), string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean normalizedStringsAreEqual(String string, String string2) {
        if (this.caseSensitive) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    private boolean normalizedStringsStartsWith(String string, String string2) {
        if (this.caseSensitive) {
            return string.startsWith(string2);
        }
        return StringUtil.startsWithIgnoreCase(string, string2);
    }

    private boolean normalizedStringsEndsWith(String string, String string2) {
        if (this.caseSensitive) {
            return string.endsWith(string2);
        }
        return StringUtil.endsWithIgnoreCase(string, string2);
    }

    private int normalizedStringContains(String string, String string2) {
        if (this.caseSensitive) {
            return string.indexOf(string2);
        }
        return StringUtil.containsIgnoreCase(string, string2);
    }

    public boolean patternMatch(Object object, String string, String string2) {
        try {
            if (string.equals("=") || string.equals("!=")) {
                String string3 = (String)object;
                if (string.equals("=") && string3 == null && string2 == null) {
                    return true;
                }
                if (string3 != null && string2 != null) {
                    int n = this.countWildcardsAndValidatePattern(string2);
                    if (n == 2) {
                        String string4 = string2.substring(1, string2.length() - 1);
                        if (string.equals("=") && this.normalizedStringContains(string3, string4) != -1) {
                            return true;
                        }
                        if (string.equals("!=") && this.normalizedStringContains(string3, string4) == -1) {
                            return true;
                        }
                    } else if (n == 1) {
                        int n2 = string2.indexOf("*");
                        String string5 = string2.substring(0, n2);
                        String string6 = string2.substring(n2 + 1);
                        if (string.equals("=") && this.normalizedStringsStartsWith(string3, string5) && this.normalizedStringsEndsWith(string3, string6)) {
                            return true;
                        }
                        if (!(!string.equals("!=") || this.normalizedStringsStartsWith(string3, string5) && this.normalizedStringsEndsWith(string3, string6))) {
                            return true;
                        }
                    } else {
                        if (string.equals("=") && this.normalizedStringsAreEqual(string3, string2)) {
                            return true;
                        }
                        if (string.equals("!=") && !this.normalizedStringsAreEqual(string3, string2)) {
                            return true;
                        }
                    }
                }
            } else {
                int n = Integer.parseInt(object.toString());
                int n3 = Integer.parseInt(string2);
                if (string.equals("<")) {
                    return n < n3;
                }
                if (string.equals(">")) {
                    return n > n3;
                }
                if (string.equals("<=")) {
                    return n <= n3;
                }
                if (string.equals(">=")) {
                    return n >= n3;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    private boolean evaluateXPathNode(LogicalNode logicalNode) throws Exception {
        boolean bl = false;
        boolean bl2 = this.evaluateXPathNode((XPathNode)logicalNode.getLeftChild());
        boolean bl3 = this.evaluateXPathNode((XPathNode)logicalNode.getRightChild());
        if (logicalNode.getOperator().equalsIgnoreCase("and")) {
            bl = bl2 && bl3;
        } else if (logicalNode.getOperator().equalsIgnoreCase("or")) {
            bl = bl2 || bl3;
        } else {
            throw new WIMApplicationException("Logical operator " + logicalNode.getOperator() + " is not supported");
        }
        return bl;
    }

    private boolean evaluateXPathNode(ParenthesisNode parenthesisNode) throws Exception {
        return this.evaluateXPathNode((XPathNode)parenthesisNode.getChild());
    }
}

