/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.file.was.commands;

import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.wim.exception.InvalidArgumentException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.security.authz.Entitlement;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.file.was.FileAdapter;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.config.SupportedEntityTypeConfigHelper;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.registry.util.UserRegistryValidator;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import commonj.sdo.DataObject;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileRegistryCommandsProvider
extends SimpleCommandProvider {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = FileRegistryCommandsProvider.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    static final String RB = "com.ibm.websphere.wim.ras.properties.CWWIMMessages";
    private String PROP_PERSON_ACCOUNT_RDN = "uid";
    private String DEFAULT_PARENT = "o=defaultWIMFileBasedRealm";
    private String userId;
    private String uniqueName;
    private String parent;
    private String groupName;
    private String groupDesc;
    private byte[] password;
    private String accountUniqueName = null;
    private String groupUniqueName = null;
    private FileAdapter fileAdapter;
    private SchemaManager schemaManager = null;

    public String addFileRegistryAccount(AbstractAdminCommand abstractAdminCommand) throws WIMException {
        try {
            this.userId = this.getAndValidateStringParam(abstractAdminCommand, "userId");
            if (this.getAndValidateStringParam(abstractAdminCommand, "password") != null) {
                this.password = this.getAndValidateStringParam(abstractAdminCommand, "password").getBytes();
            }
            this.parent = this.getAndValidateStringParam(abstractAdminCommand, "parent");
            trcLogger.logp(Level.FINER, CLASSNAME, "addFileRegistryAccount", "userId=" + this.userId + ", parent=" + this.parent);
            trcLogger.logp(Level.FINER, CLASSNAME, "addFileRegistryAccount", "Check caller's permission to create account.");
            ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
            profileSecurityManager.checkPermission_SuperUser(new Entitlement("ADDFILEREGISTRYACCOUNT"));
            this.initialize(abstractAdminCommand);
            trcLogger.logp(Level.FINER, CLASSNAME, "addFileRegistryAccount", "Proceed to create PersonAccount");
            this.fileAdapter.create(this.getCreateDO());
            if (this.password != null) {
                PasswordUtil.erasePassword(this.password);
            }
            return this.getLocalizedMessage("FILE_REGISTRY_ACCOUNT_ADDED", this.userId + "(" + this.accountUniqueName + ")");
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getLocalizedMessage()), CLASSNAME, "addFileRegistryAccount");
        }
    }

    public String addFileRegistryGroup(AbstractAdminCommand abstractAdminCommand) throws WIMException {
        try {
            this.groupName = this.getAndValidateStringParam(abstractAdminCommand, "cn");
            this.groupDesc = this.getAndValidateStringParam(abstractAdminCommand, "description");
            this.parent = this.getAndValidateStringParam(abstractAdminCommand, "parent");
            trcLogger.logp(Level.FINER, CLASSNAME, "addFileRegistryGroup", "cn=" + this.groupName + ", desc=" + this.groupDesc + ", parent=" + this.parent);
            trcLogger.logp(Level.FINER, CLASSNAME, "addFileRegistryGroup", "Check caller's permission to create group.");
            ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
            profileSecurityManager.checkPermission_SuperUser(new Entitlement("ADDFILEREGISTRYGROUP"));
            this.initialize(abstractAdminCommand);
            trcLogger.logp(Level.FINER, CLASSNAME, "addFileRegistryGroup", "Proceed to create Group");
            this.fileAdapter.create(this.getCreateGroupDO());
            return this.groupUniqueName;
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getLocalizedMessage()), CLASSNAME, "addFileRegistryGroup");
        }
    }

    public String changeFileRegistryAccountPassword(AbstractAdminCommand abstractAdminCommand) throws WIMException {
        try {
            this.userId = this.getAndValidateStringParam(abstractAdminCommand, "userId");
            if (this.getAndValidateStringParam(abstractAdminCommand, "password") != null) {
                this.password = this.getAndValidateStringParam(abstractAdminCommand, "password").getBytes();
            }
            this.uniqueName = this.getAndValidateStringParam(abstractAdminCommand, "uniqueName");
            trcLogger.logp(Level.FINER, CLASSNAME, "changeFileRegistryAccountPassword", "userId=" + this.userId + ", uniqueName=" + this.uniqueName);
            trcLogger.logp(Level.FINER, CLASSNAME, "changeFileRegistryAccountPassword", "Check caller's permission to update account.");
            ProfileSecurityManager profileSecurityManager = ProfileSecurityManager.singleton();
            profileSecurityManager.checkPermission_SuperUser(new Entitlement("CHANGEFILEREGISTRYACCOUNTPASSWORD"));
            this.initialize(abstractAdminCommand);
            trcLogger.logp(Level.FINER, CLASSNAME, "changeFileRegistryAccountPassword", "Proceed to update PersonAccount");
            this.updateAccount();
            if (this.password != null) {
                PasswordUtil.erasePassword(this.password);
            }
            return this.getLocalizedMessage("FILE_REGISTRY_ACCOUNT_PASSWORD_CHANGED", this.userId + "(" + this.accountUniqueName + ")");
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getLocalizedMessage()), CLASSNAME, "changeFileRegistryAccountPassword");
        }
    }

    private void initialize(AbstractAdminCommand abstractAdminCommand) throws Exception {
        List list;
        Object object;
        String string = abstractAdminCommand.getConfigSession().toString();
        trcLogger.entering(CLASSNAME, "initialize", "session " + string);
        ConfigManager.singleton();
        this.schemaManager = SchemaManager.singleton();
        ConfigurationProviderType configurationProviderType = ConfigUtils.getConfigProvider(string);
        if (configurationProviderType != null && (object = SupportedEntityTypeConfigHelper.getSupportEntityTypeByName(list = configurationProviderType.getSupportedEntityTypes(), "PersonAccount")) != null) {
            List list2 = object.getRdnProperties();
            trcLogger.logp(Level.FINER, CLASSNAME, "initialize", "RDNs of PersonAccount=" + list2);
            if (list2 != null && list2.size() > 0) {
                this.PROP_PERSON_ACCOUNT_RDN = (String)list2.get(0);
            }
        }
        list = (DataObject)ConfigUtils.getRepositoryById(string, "InternalFileRepository", false);
        trcLogger.logp(Level.FINER, CLASSNAME, "initialize", "Using " + this.PROP_PERSON_ACCOUNT_RDN + " as RDN of PersonAccount");
        this.fileAdapter = new FileAdapter(string, (DataObject)ConfigUtils.getConfigProvider(string), (DataObject)list);
        object = this.fileAdapter.getBaseEntries();
        trcLogger.logp(Level.FINER, CLASSNAME, "initialize", "baseEntries of File Repository=" + object);
        if (object != null && object.size() > 0) {
            this.DEFAULT_PARENT = (String)object.get(0);
        }
        trcLogger.logp(Level.FINER, CLASSNAME, "initialize", "Using " + this.DEFAULT_PARENT + " as parent of PersonAccount.");
        trcLogger.exiting(CLASSNAME, "initialize");
    }

    private String getLocalizedMessage(String string, String string2) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(RB, Locale.getDefault());
            return MessageFormat.format(resourceBundle.getString(string), string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    private DataObject getCreateDO() throws Exception {
        trcLogger.entering(CLASSNAME, "getCreateDO");
        DataObject dataObject = this.schemaManager.createRootDataObject();
        DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "PersonAccount");
        dataObject2.set(this.PROP_PERSON_ACCOUNT_RDN, (Object)this.userId);
        dataObject2.set("password", (Object)this.password);
        dataObject2.set("cn", (Object)this.userId);
        dataObject2.set("sn", (Object)this.userId);
        if (this.parent != null) {
            this.DEFAULT_PARENT = this.parent;
        }
        DataObject dataObject3 = dataObject2.createDataObject("parent").createDataObject("identifier");
        dataObject3.setString("uniqueName", this.DEFAULT_PARENT);
        this.accountUniqueName = this.PROP_PERSON_ACCOUNT_RDN + "=" + this.userId + "," + this.DEFAULT_PARENT;
        dataObject2.createDataObject("identifier").setString("uniqueName", this.accountUniqueName);
        trcLogger.exiting(CLASSNAME, "getCreateDO", WIMTraceHelper.printDataGraph(dataObject));
        return dataObject;
    }

    private DataObject getCreateGroupDO() throws Exception {
        trcLogger.entering(CLASSNAME, "getCreateGroupDO");
        DataObject dataObject = this.schemaManager.createRootDataObject();
        DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "Group");
        dataObject2.set("cn", (Object)this.groupName);
        if (this.groupDesc != null) {
            dataObject2.getList("description").add(this.groupDesc);
        }
        if (this.parent != null) {
            this.DEFAULT_PARENT = this.parent;
        }
        DataObject dataObject3 = dataObject2.createDataObject("parent").createDataObject("identifier");
        dataObject3.setString("uniqueName", this.DEFAULT_PARENT);
        this.groupUniqueName = "cn=" + this.groupName + "," + this.DEFAULT_PARENT;
        dataObject2.createDataObject("identifier").setString("uniqueName", this.groupUniqueName);
        trcLogger.exiting(CLASSNAME, "getCreateGroupDO", WIMTraceHelper.printDataGraph(dataObject));
        return dataObject;
    }

    private void updateAccount() throws Exception {
        this.fileAdapter.update(this.getUpdateDO());
    }

    private DataObject getUpdateDO() throws Exception {
        trcLogger.entering(CLASSNAME, "getUpdateDO");
        DataObject dataObject = this.schemaManager.createRootDataObject();
        DataObject dataObject2 = null;
        if (this.uniqueName == null) {
            this.accountUniqueName = this.PROP_PERSON_ACCOUNT_RDN + "=" + this.userId + "," + this.DEFAULT_PARENT;
            trcLogger.logp(Level.FINER, CLASSNAME, "getUpdateDO", "uniqueName=" + this.accountUniqueName);
        } else {
            this.accountUniqueName = this.uniqueName;
        }
        dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "PersonAccount");
        dataObject2.createDataObject("identifier").setString("uniqueName", this.accountUniqueName);
        dataObject2.set("password", (Object)this.password);
        trcLogger.exiting(CLASSNAME, "getUpdateDO", WIMTraceHelper.printDataGraph(dataObject));
        return dataObject;
    }

    private String getAndValidateStringParam(AbstractAdminCommand abstractAdminCommand, String string) throws WIMException {
        String string2 = null;
        try {
            string2 = (String)abstractAdminCommand.getParameter(string);
            if (string2 != null && string2.trim().length() == 0) {
                throw new InvalidArgumentException("INVALID_PARAMETER_VALUE", WIMMessageHelper.generateMsgParms(string));
            }
        }
        catch (InvalidParameterNameException invalidParameterNameException) {
            invalidParameterNameException.printStackTrace();
        }
        return string2;
    }

    private void validateUserIdAndPassword(String string) throws Exception {
        System.out.println("Initializing user registry validator for sessionId=" + string);
        UserRegistryValidator userRegistryValidator = new UserRegistryValidator(string);
        System.out.println("Validating userId " + this.userId);
        System.out.println("getUsers=" + userRegistryValidator.getUsers(this.userId, 1));
        System.out.println("Validating userId " + this.userId + " and password " + new String(this.password));
        System.out.println("checkPassword=" + userRegistryValidator.checkPassword(this.userId, new String(this.password)));
    }
}

