/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.ldap;

import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.SchemaConstants;
import com.ibm.websphere.wim.exception.CertificateMapFailedException;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.EntityHasDescendantsException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.EntityTypeNotSupportedException;
import com.ibm.websphere.wim.exception.InvalidEntityTypeException;
import com.ibm.websphere.wim.exception.InvalidPropertyValueException;
import com.ibm.websphere.wim.exception.MissingMandatoryPropertyException;
import com.ibm.websphere.wim.exception.PasswordCheckFailedException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.UpdatePropertyException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.websphere.wim.util.UniqueIdGenerator;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.ldap.LdapAttribute;
import com.ibm.ws.wim.adapter.ldap.LdapConfigManager;
import com.ibm.ws.wim.adapter.ldap.LdapConnection;
import com.ibm.ws.wim.adapter.ldap.LdapConstants;
import com.ibm.ws.wim.adapter.ldap.LdapEntity;
import com.ibm.ws.wim.adapter.ldap.LdapEntry;
import com.ibm.ws.wim.adapter.ldap.LdapHelper;
import com.ibm.ws.wim.adapter.ldap.LdapSearchControl;
import com.ibm.ws.wim.adapter.ldap.LdapURL;
import com.ibm.ws.wim.util.AsyncUtils;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.ws.wim.util.NodeHelper;
import com.ibm.ws.wim.util.UniqueNameHelper;
import com.ibm.ws.wim.xpath.ParseException;
import com.ibm.ws.wim.xpath.TokenMgrError;
import com.ibm.ws.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.wim.xpath.ldap.util.LdapXPathTranslateHelper;
import com.ibm.ws.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.wsspi.wim.Repository;
import com.ibm.wsspi.wim.RepositoryImpl;
import com.sun.jndi.ldap.LdapName;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchResult;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LdapAdapter
extends RepositoryImpl
implements Repository,
DynamicConfigService,
SchemaConstants,
LdapConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LdapAdapter.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final Logger msgLogger = WIMLogger.getMessageLogger(CLASSNAME);
    private SchemaManager iSchemaMgr = null;
    private LdapConfigManager iLdapConfigMgr = null;
    protected LdapConnection iLdapConn = null;
    private boolean isActiveDirectory = false;

    public void initialize(DataObject dataObject) throws WIMException {
        super.initialize(dataObject);
        this.iSchemaMgr = SchemaManager.singleton();
        this.iLdapConfigMgr = new LdapConfigManager();
        this.iLdapConfigMgr.initialize(dataObject);
        this.isActiveDirectory = this.iLdapConfigMgr.isActiveDirectory();
        this.iLdapConn = new LdapConnection(this.iLdapConfigMgr);
        this.iLdapConn.initialize(dataObject);
        if (this.iLdapConfigMgr.getLdapType().startsWith("DOMINO") && this.iLdapConfigMgr.isAnyExtIdDN()) {
            this.resetDefaultDominoExtIdAttributes(dataObject);
        }
    }

    private void resetDefaultDominoExtIdAttributes(DataObject dataObject) throws WIMException {
        List list;
        int n;
        DataObject dataObject2 = dataObject.getDataObject("attributeConfiguration");
        if (dataObject2 != null && (n = (list = dataObject2.getList("externalIdAttributes")).size()) > 0) {
            return;
        }
        if (!this.isDominounidSupport()) {
            return;
        }
        this.iLdapConfigMgr.resetDefaultDominoExtIdAttribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDominounidSupport() throws WIMException {
        DirContext dirContext = null;
        try {
            dirContext = this.iLdapConn.getDirContext();
            DirContext dirContext2 = dirContext.getSchema("");
            Attributes attributes2 = dirContext2.getAttributes("AttributeDefinition/dominounid");
            boolean bl = true;
            return bl;
        }
        catch (NameNotFoundException nameNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (NamingException namingException) {
            trcLogger.logp(Level.FINE, CLASSNAME, "isDominounidSupport", "LDAP exception: " + namingException.toString(true));
            boolean bl = false;
            return bl;
        }
        finally {
            this.iLdapConn.releaseDirContext(dirContext);
        }
    }

    public DataObject create(DataObject dataObject) throws WIMException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI create", WIMTraceHelper.printDataGraph(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.getRepositoryId(), CLASSNAME, "create");
        DataObject dataObject2 = (DataObject)dataObject.getList("entities").get(0);
        Type type = dataObject2.getType();
        String string2 = type.getName();
        DataObject dataObject3 = this.iSchemaMgr.createRootDataObject();
        DataObject dataObject4 = dataObject2.getDataObject("identifier");
        dataObject2.unset("identifier");
        String string3 = dataObject4.getString("externalName");
        String string4 = dataObject4.getString("uniqueName");
        LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(type);
        if (ldapEntity == null) {
            throw new EntityTypeNotSupportedException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "create");
        }
        String string5 = ldapEntity.getName();
        if (this.iLdapConfigMgr.isPersonAccount(string5)) {
            if (dataObject2.isSet("principalName")) {
                throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", this.getRepositoryId()), CLASSNAME, "create");
            }
            if (dataObject2.isSet("realm")) {
                throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("realm", this.getRepositoryId()), CLASSNAME, "create");
            }
        }
        EClass eClass = this.iSchemaMgr.getEClass(dataObject2.getType());
        EList eList = eClass.getEAllStructuralFeatures();
        BasicAttributes basicAttributes = new BasicAttributes();
        List list = null;
        List list2 = null;
        for (int i = 0; i < eList.size(); ++i) {
            object7 = (EStructuralFeature)eList.get(i);
            object6 = this.iSchemaMgr.getProperty((EStructuralFeature)object7);
            object5 = this.iSchemaMgr.getQualifiedPropertyName((EStructuralFeature)object7);
            if (!dataObject2.isSet(object6)) continue;
            if (this.iLdapConfigMgr.isPersistentProperty((String)object5)) {
                Set set = this.getAttribute(dataObject2, null, (Property)object6, (String)object5, ldapEntity);
                object4 = set.iterator();
                while (object4.hasNext()) {
                    basicAttributes.put((Attribute)object4.next());
                }
                continue;
            }
            if ("members".equals(object5)) {
                list2 = dataObject2.getList(object6);
                continue;
            }
            if (!"groups".equals(object5)) continue;
            list = dataObject2.getList(object6);
        }
        if (string3 == null) {
            string3 = this.getDN(string4, string5, basicAttributes, false, true);
        }
        Attribute attribute = ldapEntity.getObjectClassAttribute(string3);
        basicAttributes.put(attribute);
        object7 = ldapEntity.getExtId();
        object6 = null;
        object5 = this.iLdapConfigMgr.getAttribute((String)object7);
        if (object5 != null && ((LdapAttribute)object5).isWIMGenerate()) {
            object6 = UniqueIdGenerator.newUniqueId();
            basicAttributes.put(new BasicAttribute((String)object6, object6));
        }
        boolean bl = this.iLdapConfigMgr.isGroup(string5);
        if (list2 != null && list2.size() > 0) {
            if (!bl) {
                throw new InvalidEntityTypeException("ENTITY_IS_NOT_A_GROUP", WIMMessageHelper.generateMsgParms(string4), Level.SEVERE, CLASSNAME, "create");
            }
            object4 = this.iLdapConfigMgr.getMemberAttribute(attribute);
            if (list2.size() > 0) {
                object3 = new BasicAttribute((String)object4);
                for (int i = 0; i < list2.size(); ++i) {
                    object2 = ((DataObject)list2.get(i)).getDataObject("identifier");
                    object = this.iLdapConn.getEntityByIdentifier((DataObject)object2, null, null, false, false);
                    string = ((LdapEntry)object).getDN();
                    object3.add(string);
                }
                basicAttributes.put((Attribute)object3);
            }
        } else if (bl && (object3 = this.iLdapConfigMgr.getDummyMember((String)(object4 = this.iLdapConfigMgr.getMemberAttribute(attribute)))) != null) {
            BasicAttribute basicAttribute = new BasicAttribute((String)object4, object3);
            basicAttributes.put(basicAttribute);
        }
        object4 = this.iLdapConfigMgr.getAttributesWithDefaultValue();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            String string6 = (String)object3.next();
            object2 = this.iLdapConfigMgr.getLdapAttribute(string6);
            if (object2 == null || (object = ((LdapAttribute)object2).getDefaultValue(string5)) == null || LdapHelper.inAttributes(string6, basicAttributes)) continue;
            basicAttributes.put(new BasicAttribute(((LdapAttribute)object2).getName(), object));
        }
        object3 = this.iLdapConfigMgr.getAttributesWithDefaultAttribute();
        Object object8 = object3.iterator();
        while (object8.hasNext()) {
            Attribute attribute2;
            object2 = (String)object8.next();
            object = this.iLdapConfigMgr.getLdapAttribute((String)object2);
            if (object == null || (string = ((LdapAttribute)object).getDefaultAttribute(string5)) == null || LdapHelper.inAttributes((String)object2, basicAttributes) || (attribute2 = basicAttributes.get(string)) == null) continue;
            basicAttributes.put(LdapHelper.cloneAttribute(((LdapAttribute)object).getName(), attribute2));
        }
        object8 = null;
        if (this.iLdapConfigMgr.getLdapType().equals("AD2003")) {
            object8 = basicAttributes.remove("userAccountControl");
        }
        object2 = this.iLdapConn.createSubcontext(string3, basicAttributes);
        try {
            object2.close();
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "create");
        }
        if (object8 != null) {
            object = new BasicAttributes();
            object.put((Attribute)object8);
            try {
                this.iLdapConn.modifyAttributes(string3, 2, (Attributes)object);
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "create");
            }
        }
        if (list != null) {
            this.updateGroups(string3, list, 1);
        }
        if (object6 == null) {
            object6 = this.getExtId(string3, (String)object7, null);
        }
        this.iLdapConn.invalidateNamesCache();
        object = dataObject3.createDataObject("entities", type.getURI(), string2);
        string = object.createDataObject("identifier");
        if (this.iLdapConfigMgr.needTranslateRDN(string2) && !this.iLdapConfigMgr.needTranslateRDN()) {
            string.setString("uniqueName", this.iLdapConfigMgr.switchToNode(string3));
        } else {
            string.setString("uniqueName", string4);
        }
        string.setString("externalName", string3);
        string.setString("externalId", (String)object6);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI create", WIMTraceHelper.printDataGraph(dataObject3));
        }
        return dataObject3;
    }

    private String getExtId(String string, String string2, Attributes attributes2) throws WIMException {
        Object object;
        if ("distinguishedName".equalsIgnoreCase(string2)) {
            return LdapHelper.toUpperCase(string);
        }
        Attribute attribute = null;
        if (attributes2 != null) {
            attribute = attributes2.get(string2);
        }
        if (attribute == null) {
            object = new String[]{string2};
            attributes2 = this.iLdapConn.checkAttributesCache(string, (String[])object);
            attribute = attributes2.get(string2);
        }
        if (attribute == null) {
            return LdapHelper.toUpperCase(string);
        }
        if (attribute.size() > 1) {
            throw new WIMSystemException("EXT_ID_HAS_MULTIPLE_VALUES", WIMMessageHelper.generateMsgParms(attribute), CLASSNAME, "getExtId(String DN, javax.naming.directory.Attributes attributes)");
        }
        object = this.iLdapConfigMgr.getAttribute(string2);
        try {
            Object object2 = attribute.get();
            if (object != null && "octetString".equalsIgnoreCase(((LdapAttribute)object).getSyntax())) {
                return LdapHelper.getOctetString((byte[])object2);
            }
            return object2.toString();
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getExtId(String DN, javax.naming.directory.Attributes attributes)");
        }
    }

    private Object getPropertyValue(Property property, String string, Object object) {
        return object;
    }

    private Set getAttribute(DataObject dataObject, Object object, Property property, String string, LdapEntity ldapEntity) throws WIMException {
        HashMap<String, Attribute> hashMap = new HashMap<String, Attribute>();
        String string2 = this.iLdapConfigMgr.getAttributeName(ldapEntity, string);
        String string3 = property.getType().getName();
        LdapAttribute ldapAttribute = this.iLdapConfigMgr.getLdapAttribute(string2);
        String string4 = this.iLdapConfigMgr.getLdapType();
        List list = null;
        if (property.isMany()) {
            list = object != null ? (ArrayList)object : dataObject.getList(property);
        } else {
            list = new ArrayList(1);
            if (object != null) {
                list.add(object);
            } else {
                list.add(dataObject.get(property));
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            Attribute attribute;
            String string5 = string2;
            Object e2 = list.get(i);
            Object object2 = null;
            if ("String".equals(string3)) {
                object2 = LdapHelper.getStringLdapValue(e2, ldapAttribute, string4);
            } else if ("DateTime".equals(string3)) {
                object2 = LdapHelper.getDateLdapValue(e2, ldapAttribute, string4);
            } else if ("IdentifierType".equals(string3)) {
                if (e2 != null) {
                    attribute = (DataObject)e2;
                    try {
                        LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier((DataObject)attribute, null, null, false, false);
                        object2 = ldapEntry.getDN();
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        throw new InvalidPropertyValueException("INVALID_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getAttribute", (Throwable)entityNotFoundException);
                    }
                }
            } else if ("Base64Binary".equals(string3)) {
                object2 = ldapAttribute != null && "unicodePwd".equalsIgnoreCase(ldapAttribute.getSyntax()) ? (Object)LdapHelper.encodePassword(new String((byte[])e2)) : e2;
            } else if ("Int".equals(string3)) {
                object2 = LdapHelper.getIntLdapValue(e2, ldapAttribute, string4);
            } else if ("LangType".equals(string3)) {
                attribute = (DataObject)e2;
                object2 = attribute.getString("value");
            } else {
                object2 = e2.toString();
            }
            if (object2 == null) continue;
            attribute = (Attribute)hashMap.get(string5);
            if (attribute == null) {
                attribute = new BasicAttribute(string5);
                hashMap.put(string5, attribute);
            }
            attribute.add(object2);
        }
        HashSet hashSet = new HashSet(hashMap.values());
        return hashSet;
    }

    private List getGroups(String string) throws WIMException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.iLdapConfigMgr.getGroupMemberFilter(string);
        String[] stringArray = this.iLdapConfigMgr.getGroupSearchBases();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            NamingEnumeration namingEnumeration = this.iLdapConn.search(string3, string2, 2, LDAP_ATTR_OBJECTCLASS_ARRAY);
            while (namingEnumeration.hasMoreElements()) {
                String string4;
                SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                if (searchResult == null || (string4 = searchResult.getName()) == null || string4.trim().length() == 0) continue;
                arrayList.add(LdapHelper.prepareDN(string4, string3));
            }
        }
        return arrayList;
    }

    private void updateGroupMember(String string, String string2) throws WIMException {
        Serializable serializable;
        Object object;
        Object object2;
        if (!this.iLdapConfigMgr.updateGroupMembership()) {
            return;
        }
        String string3 = this.iLdapConfigMgr.getGroupMemberFilter(string);
        String[] stringArray = this.iLdapConfigMgr.getMemberAttributes();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            object2 = new ModificationItem(3, new BasicAttribute(string4, string));
            object = null;
            if (string2 != null) {
                serializable = new ModificationItem(1, new BasicAttribute(string4, string2));
                object = new ModificationItem[]{serializable, object2};
            } else {
                object = new ModificationItem[]{object2};
            }
            hashMap.put(string4.toLowerCase(), object);
        }
        String[] stringArray2 = this.iLdapConfigMgr.getGroupSearchBases();
        for (int i = 0; i < stringArray2.length; ++i) {
            object2 = stringArray2[i];
            object = this.iLdapConn.search((String)object2, string3, 2, LDAP_ATTR_OBJECTCLASS_ARRAY);
            while (object.hasMoreElements()) {
                String string5;
                serializable = (SearchResult)object.nextElement();
                if (serializable == null || (string5 = ((NameClassPair)serializable).getName()) == null || string5.trim().length() == 0) continue;
                String string6 = LdapHelper.prepareDN(string5, (String)object2);
                Attributes attributes2 = ((SearchResult)serializable).getAttributes();
                String string7 = this.iLdapConfigMgr.getMemberAttribute(attributes2.get("objectClass"));
                ModificationItem[] modificationItemArray = (ModificationItem[])hashMap.get(string7.toLowerCase());
                if (modificationItemArray == null) continue;
                try {
                    this.iLdapConn.modifyAttributes(string6, modificationItemArray);
                }
                catch (Exception exception) {
                    if (!trcLogger.isLoggable(Level.FINE)) continue;
                    trcLogger.logp(Level.FINE, CLASSNAME, "updateGroupMember", "Updating group " + string6 + " for " + string + " failed due to: " + exception.toString());
                }
            }
        }
    }

    public DataObject delete(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI delete(DataGraph)", WIMTraceHelper.printDataGraph(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.getRepositoryId(), CLASSNAME, "delete(DataGraph)");
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject2 = (DataObject)map.get("DeleteControl");
        boolean bl = false;
        if (dataObject2 != null) {
            bl = dataObject2.getBoolean("deleteDescendants");
        }
        DataObject dataObject3 = (DataObject)dataObject.getList("entities").get(0);
        DataObject dataObject4 = dataObject3.getDataObject("identifier");
        LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(dataObject4, null, null, false, false);
        DataObject dataObject5 = this.iSchemaMgr.createRootDataObject();
        List list = this.deleteAll(ldapEntry, bl);
        for (int i = 0; i < list.size(); ++i) {
            LdapEntry ldapEntry2 = (LdapEntry)list.get(i);
            this.createEntityFromLdapEntry(dataObject5, "entities", ldapEntry2, null);
            this.updateGroupMember(ldapEntry.getDN(), null);
            this.iLdapConn.invalidateAttributes(ldapEntry2.getDN(), ldapEntry2.getExtId(), ldapEntry2.getUniqueName());
        }
        this.iLdapConn.invalidateNamesCache();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI delete(DataGraph)", WIMTraceHelper.printDataGraph(dataObject5));
        }
        return dataObject5;
    }

    private List deleteAll(LdapEntry ldapEntry, boolean bl) throws WIMException {
        String string;
        String string2 = ldapEntry.getDN();
        ArrayList<LdapEntry> arrayList = new ArrayList<LdapEntry>();
        List list = this.getDescendants(string2, 1);
        if (list.size() > 0) {
            if (bl) {
                for (int i = 0; i < list.size(); ++i) {
                    LdapEntry ldapEntry2 = (LdapEntry)list.get(i);
                    string = ldapEntry.getDN();
                    arrayList.addAll(this.deleteAll(ldapEntry2, true));
                }
            } else {
                throw new EntityHasDescendantsException("ENTITY_HAS_DESCENDENTS", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "deleteAll");
            }
        }
        this.deletePreExit(string2);
        List list2 = this.getGroups(string2);
        this.iLdapConn.destroySubcontext(string2);
        arrayList.add(ldapEntry);
        for (int i = 0; i < list2.size(); ++i) {
            string = (String)list2.get(i);
            this.iLdapConn.invalidateAttributes(string, null, null);
        }
        return arrayList;
    }

    protected void deletePreExit(String string) throws WIMException {
    }

    private List getDescendants(String string, int n) throws WIMException {
        int n2 = 1;
        if (n == 0) {
            n2 = 2;
        }
        ArrayList<LdapEntry> arrayList = new ArrayList<LdapEntry>();
        Set set = this.iLdapConn.searchEntities(string, "objectClass=*", null, n2, null, null, false, false);
        for (LdapEntry ldapEntry : set) {
            arrayList.add(ldapEntry);
        }
        return arrayList;
    }

    private void updateGroups(String string, List list, int n) throws WIMException {
        if (list.size() > 0) {
            String string2 = null;
            List list2 = this.iLdapConfigMgr.getGroupTypes();
            for (int i = 0; i < list.size(); ++i) {
                String string3;
                LdapEntry ldapEntry;
                block23: {
                    Attribute attribute;
                    Attributes attributes2;
                    DataObject dataObject = ((DataObject)list.get(i)).getDataObject("identifier");
                    ldapEntry = this.iLdapConn.getEntityByIdentifier(dataObject, list2, null, false, false);
                    if (!this.iLdapConfigMgr.isGroup(ldapEntry.getType())) {
                        throw new InvalidEntityTypeException("ENTITY_IS_NOT_A_GROUP", WIMMessageHelper.generateMsgParms(dataObject.getString("uniqueName")), Level.SEVERE, CLASSNAME, "updateGroups(String, List, int)");
                    }
                    string3 = ldapEntry.getDN();
                    if (string2 == null) {
                        attributes2 = ldapEntry.getAttributes();
                        attribute = attributes2.get("objectClass");
                        string2 = this.iLdapConfigMgr.getMemberAttribute(attribute);
                    }
                    attributes2 = new BasicAttributes();
                    attribute = new BasicAttribute(string2, string);
                    attributes2.put(attribute);
                    try {
                        if (3 == n) {
                            try {
                                this.iLdapConn.modifyAttributes(string3, 3, attributes2);
                            }
                            catch (NoSuchAttributeException noSuchAttributeException) {
                                if (trcLogger.isLoggable(Level.FINE)) {
                                    trcLogger.logp(Level.FINE, CLASSNAME, "updateGroups(String, List, int)", "Entity " + string + " is already not a member of group " + string3 + ":" + noSuchAttributeException.toString(true));
                                }
                                break block23;
                            }
                            catch (OperationNotSupportedException operationNotSupportedException) {
                                if (trcLogger.isLoggable(Level.FINE)) {
                                    trcLogger.logp(Level.FINE, CLASSNAME, "updateGroups(String, List, int)", "Entity " + string + " is already not a member of group " + string3 + ":" + operationNotSupportedException.toString(true));
                                }
                                break block23;
                            }
                        }
                        if (2 == n) {
                            try {
                                this.iLdapConn.modifyAttributes(string3, 2, attributes2);
                            }
                            catch (NoSuchAttributeException noSuchAttributeException) {
                                if (trcLogger.isLoggable(Level.FINE)) {
                                    trcLogger.logp(Level.FINE, CLASSNAME, "updateGroups(String, List, int)", "Entity " + string + " is already not a member of group " + string3 + ":" + noSuchAttributeException.toString(true));
                                }
                                break block23;
                            }
                            catch (OperationNotSupportedException operationNotSupportedException) {
                                if (trcLogger.isLoggable(Level.FINE)) {
                                    trcLogger.logp(Level.FINE, CLASSNAME, "updateGroups(String, List, int)", "Entity " + string + " is already not a member of group " + string3 + ":" + operationNotSupportedException.toString(true));
                                }
                                break block23;
                            }
                        }
                        try {
                            this.iLdapConn.modifyAttributes(string3, 1, attributes2);
                        }
                        catch (AttributeInUseException attributeInUseException) {
                            if (trcLogger.isLoggable(Level.FINE)) {
                                trcLogger.logp(Level.FINE, CLASSNAME, "updateGroups(String, List, int)", "Entity " + string + " is already a member of group " + string3 + ":" + attributeInUseException.toString(true));
                            }
                        }
                        catch (NameAlreadyBoundException nameAlreadyBoundException) {
                            if (trcLogger.isLoggable(Level.FINE)) {
                                trcLogger.logp(Level.FINE, CLASSNAME, "updateGroups(String, List, int)", "Entity " + string + " is already a member of group" + string3 + ":" + nameAlreadyBoundException.toString(true));
                            }
                        }
                    }
                    catch (NamingException namingException) {
                        throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "updateGroups(String, List, int)");
                    }
                }
                this.iLdapConn.invalidateAttributes(string3, ldapEntry.getExtId(), ldapEntry.getUniqueName());
            }
        }
    }

    private DataObject updateByChangeSummary(DataObject dataObject, List list) throws WIMException {
        DataObject dataObject2 = (DataObject)dataObject.getList("entities").get(0);
        String string = this.iSchemaMgr.getQualifiedTypeName(dataObject2.getType());
        DataObject dataObject3 = dataObject2.getDataObject("identifier");
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(dataObject3, arrayList, null, false, false);
        String string2 = ldapEntry.getDN();
        String string3 = ldapEntry.getExtId();
        String string4 = ldapEntry.getUniqueName();
        String string5 = ldapEntry.getType();
        LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(string5);
        String[] stringArray = LdapHelper.getRDNAttributes(string2);
        String[] stringArray2 = null;
        DataObject dataObject4 = this.iSchemaMgr.createRootDataObject();
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        ArrayList<ModificationItem> arrayList2 = new ArrayList<ModificationItem>();
        for (DataObject dataObject5 : list) {
            String string6 = this.iSchemaMgr.getQualifiedTypeName(dataObject5.getType());
            if (!string5.equals(string6)) continue;
            DataObject dataObject6 = dataObject5.getDataObject("identifier");
            String string7 = dataObject6.getString("uniqueName");
            String string8 = dataObject6.getString("externalId");
            if (!string4.equalsIgnoreCase(string7) && !string3.equals(string8)) continue;
            for (ChangeSummary.Setting setting : changeSummary.getOldValues(dataObject5)) {
                Cloneable cloneable;
                Iterator iterator;
                Object object;
                Property property = setting.getProperty();
                String string9 = this.iSchemaMgr.getQualifiedPropertyName(property);
                if ("principalName".equals(string9) && this.iSchemaMgr.isSuperType("LoginAccount", string)) {
                    throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", this.getRepositoryId()), CLASSNAME, "updateByChangeSummary");
                }
                Iterator iterator2 = setting.getValue();
                Object object2 = dataObject5.get(property);
                if (iterator2 instanceof List && ((List)((Object)iterator2)).size() == 0) {
                    iterator2 = null;
                }
                if (object2 instanceof List && ((List)object2).size() == 0) {
                    object2 = null;
                }
                Object var31_31 = null;
                if (iterator2 != null && object2 != null && object2 instanceof List) {
                    object = (List)object2;
                    iterator = (List)((Object)iterator2);
                    cloneable = new ArrayList(object);
                    object.removeAll((Collection<?>)((Object)iterator));
                    iterator.removeAll((Collection<?>)((Object)cloneable));
                    object2 = object;
                    iterator2 = iterator;
                }
                if (!this.iLdapConfigMgr.isPersistentProperty(string9)) continue;
                if (object2 == null) {
                    object = this.iLdapConfigMgr.getAttributeName(ldapEntity, string9);
                    iterator = new BasicAttribute((String)object);
                    arrayList2.add(new ModificationItem(3, (Attribute)((Object)iterator)));
                    continue;
                }
                object = this.getAttribute(dataObject2, object2, property, string9, ldapEntity);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    cloneable = (Attribute)iterator.next();
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!cloneable.getID().equalsIgnoreCase(stringArray[i])) continue;
                        if (stringArray2 == null) {
                            stringArray2 = new String[stringArray.length];
                        }
                        try {
                            stringArray2[i] = (String)cloneable.get();
                        }
                        catch (NamingException namingException) {
                            trcLogger.logp(Level.FINE, CLASSNAME, "updateByChangeSummary", namingException.toString(true));
                            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "updateByChangeSummary");
                        }
                        bl = true;
                    }
                    if (bl) continue;
                    if (iterator2 == null) {
                        if (this.isActiveDirectory && "unicodePwd".equalsIgnoreCase(cloneable.getID())) {
                            arrayList2.add(new ModificationItem(2, (Attribute)cloneable));
                            continue;
                        }
                        arrayList2.add(new ModificationItem(1, (Attribute)cloneable));
                        continue;
                    }
                    if (iterator2 instanceof List) {
                        arrayList2.add(new ModificationItem(1, (Attribute)cloneable));
                        continue;
                    }
                    arrayList2.add(new ModificationItem(2, (Attribute)cloneable));
                }
                if (iterator2 == null || !(iterator2 instanceof List) || ((List)((Object)iterator2)).size() <= 0) continue;
                object = this.getAttribute(dataObject2, iterator2, property, string9, ldapEntity);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    cloneable = (Attribute)iterator.next();
                    arrayList2.add(new ModificationItem(3, (Attribute)cloneable));
                }
            }
        }
        if (arrayList2.size() > 0) {
            ModificationItem[] modificationItemArray = new ModificationItem[]{};
            modificationItemArray = arrayList2.toArray(modificationItemArray);
            try {
                this.iLdapConn.modifyAttributes(string2, modificationItemArray);
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "updateByChangeSummary");
            }
        }
        this.iLdapConn.invalidateAttributes(string2, string3, string4);
        this.iLdapConn.invalidateNamesCache();
        return dataObject4;
    }

    private DataObject updateByDataGraph(DataObject dataObject) throws WIMException {
        Object object;
        ModificationItem[] modificationItemArray;
        int n;
        DataObject dataObject2 = this.iSchemaMgr.createRootDataObject();
        DataObject dataObject3 = (DataObject)dataObject.getList("entities").get(0);
        String string = this.iSchemaMgr.getQualifiedTypeName(dataObject3.getType());
        if (this.iSchemaMgr.isSuperType("LoginAccount", string) && dataObject3.isSet("principalName")) {
            throw new UpdatePropertyException("CAN_NOT_UPDATE_PROPERTY_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("principalName", this.getRepositoryId()), CLASSNAME, "updateByDataGraph");
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        DataObject dataObject4 = dataObject3.getDataObject("identifier");
        LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(dataObject4, arrayList, null, false, false);
        String string2 = ldapEntry.getDN();
        String string3 = ldapEntry.getExtId();
        String string4 = ldapEntry.getUniqueName();
        String string5 = ldapEntry.getType();
        LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(string5);
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject5 = (DataObject)map.get("GroupMemberControl");
        DataObject dataObject6 = (DataObject)map.get("GroupMembershipControl");
        EClass eClass = this.iSchemaMgr.getEClass(dataObject3.getType());
        EList eList = eClass.getEAllStructuralFeatures();
        ArrayList<ModificationItem> arrayList2 = new ArrayList<ModificationItem>();
        List list = null;
        List list2 = null;
        String[] stringArray = LdapHelper.getRDNAttributes(string2);
        String[] stringArray2 = null;
        for (n = 0; n < eList.size(); ++n) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)eList.get(n);
            modificationItemArray = this.iSchemaMgr.getProperty(eStructuralFeature);
            object = this.iSchemaMgr.getQualifiedPropertyName(eStructuralFeature);
            if (!dataObject3.isSet((Property)modificationItemArray)) continue;
            if (this.iLdapConfigMgr.isPersistentProperty((String)object)) {
                Set set = this.getAttribute(dataObject3, null, (Property)modificationItemArray, (String)object, ldapEntity);
                for (Object object2 : set) {
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!object2.getID().equalsIgnoreCase(stringArray[i])) continue;
                        if (stringArray2 == null) {
                            stringArray2 = new String[stringArray.length];
                        }
                        try {
                            stringArray2[i] = (String)object2.get();
                        }
                        catch (NamingException namingException) {
                            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "updateByDataGraph");
                        }
                        bl = true;
                    }
                    if (bl) continue;
                    arrayList2.add(new ModificationItem(2, (Attribute)object2));
                }
                continue;
            }
            if ("members".equals(object)) {
                list2 = dataObject3.getList((Property)modificationItemArray);
                continue;
            }
            if (!"groups".equals(object)) continue;
            list = dataObject3.getList((Property)modificationItemArray);
        }
        n = 0;
        int n2 = 1;
        if (list2 != null && list2.size() > 0) {
            if (!this.iLdapConfigMgr.isGroup(string5)) {
                throw new InvalidEntityTypeException("ENTITY_IS_NOT_A_GROUP", WIMMessageHelper.generateMsgParms(ldapEntry.getUniqueName()), Level.SEVERE, CLASSNAME, "updateByDataGraph");
            }
            modificationItemArray = this.iLdapConfigMgr.getMemberAttribute(ldapEntry.getAttributes().get("objectClass"));
            object = new BasicAttribute((String)modificationItemArray);
            if (dataObject5 != null) {
                n2 = dataObject5.getInt("modifyMode");
            }
            for (int i = 0; i < list2.size(); ++i) {
                Object object2;
                DataObject dataObject7 = ((DataObject)list2.get(i)).getDataObject("identifier");
                object2 = this.iLdapConn.getEntityByIdentifier(dataObject7, null, null, false, false);
                String string6 = ((LdapEntry)object2).getDN();
                this.iLdapConn.invalidateAttributes(string6, ((LdapEntry)object2).getExtId(), ((LdapEntry)object2).getUniqueName());
                object.add(string6);
            }
            if (3 == n2) {
                arrayList2.add(new ModificationItem(3, (Attribute)object));
            } else if (2 == n2) {
                arrayList2.add(new ModificationItem(2, (Attribute)object));
            } else {
                arrayList2.add(new ModificationItem(1, (Attribute)object));
            }
            n = 1;
        }
        if (arrayList2.size() > 0) {
            modificationItemArray = new ModificationItem[]{};
            modificationItemArray = arrayList2.toArray(modificationItemArray);
            try {
                this.iLdapConn.modifyAttributes(string2, modificationItemArray);
            }
            catch (AttributeInUseException attributeInUseException) {
                if (n != 0 && 1 == n2) {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "updateByDataGraph", "Entity  is already a member of group " + string2 + ":" + attributeInUseException.toString(true));
                    }
                }
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(attributeInUseException.toString(true)), Level.SEVERE, CLASSNAME, "updateByDataGraph");
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                if (n != 0 && 3 == n2) {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "updateByDataGraph", "Entity  is already not a member of group " + string2 + ":" + noSuchAttributeException.toString(true));
                    }
                }
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(noSuchAttributeException.toString(true)), Level.SEVERE, CLASSNAME, "updateByDataGraph");
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                if (n != 0 && 3 == n2) {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.logp(Level.FINE, CLASSNAME, "updateByDataGraph", "Entity  is already not a member of group " + string2 + ":" + operationNotSupportedException.toString(true));
                    }
                }
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(operationNotSupportedException.toString(true)), Level.SEVERE, CLASSNAME, "updateByDataGraph");
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "updateByDataGraph");
            }
        }
        modificationItemArray = null;
        boolean bl = false;
        if (stringArray2 != null && !(modificationItemArray = LdapHelper.replaceRDN(string2, stringArray, stringArray2)).equalsIgnoreCase(string2)) {
            this.iLdapConn.rename(string2, (String)modificationItemArray);
            this.updateGroupMember(string2, (String)modificationItemArray);
            ArrayList<String> arrayList3 = new ArrayList<String>(1);
            arrayList3.add(string5);
            ldapEntry = this.iLdapConn.getEntityByIdentifier((String)modificationItemArray, null, null, arrayList3, null, false, false);
            bl = true;
        }
        if (list != null) {
            int n3 = 1;
            if (dataObject6 != null) {
                n3 = dataObject6.getInt("modifyMode");
            }
            this.updateGroups((String)(bl ? modificationItemArray : string2), list, n3);
        }
        this.iLdapConn.invalidateAttributes(string2, string3, string4);
        this.iLdapConn.invalidateNamesCache();
        this.createEntityFromLdapEntry(dataObject2, "entities", ldapEntry, null);
        return dataObject2;
    }

    public DataObject update(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI update", WIMTraceHelper.printDataGraph(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.getRepositoryId(), CLASSNAME, "update");
        DataObject dataObject2 = null;
        ChangeSummary changeSummary = dataObject.getDataGraph().getChangeSummary();
        List list = changeSummary.getChangedDataObjects();
        dataObject2 = list.size() > 0 ? this.updateByChangeSummary(dataObject, list) : this.updateByDataGraph(dataObject);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI update", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    private DataObject createIdentiferFromLdapEntry(LdapEntry ldapEntry) throws WIMException {
        DataObject dataObject = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "IdentifierType");
        dataObject.setString("uniqueName", ldapEntry.getUniqueName());
        dataObject.setString("externalId", ldapEntry.getExtId());
        dataObject.setString("externalName", ldapEntry.getDN());
        dataObject.setString("repositoryId", this.getRepositoryId());
        return dataObject;
    }

    private DataObject createEntityFromLdapEntry(DataObject dataObject, String string, LdapEntry ldapEntry, List list) throws WIMException {
        String string2 = ldapEntry.getType();
        DataObject dataObject2 = this.iSchemaMgr.createDataObject(dataObject, string, string2);
        DataObject dataObject3 = dataObject2.createDataObject("identifier");
        dataObject3.setString("uniqueName", ldapEntry.getUniqueName());
        dataObject3.setString("externalId", ldapEntry.getExtId());
        dataObject3.setString("externalName", ldapEntry.getDN());
        dataObject3.setString("repositoryId", this.getRepositoryId());
        this.populateEntity(dataObject2, list, ldapEntry.getAttributes());
        return dataObject2;
    }

    public DataObject get(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI get", WIMTraceHelper.printDataGraph(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.getRepositoryId(), CLASSNAME, "get");
        DataObject dataObject2 = this.iSchemaMgr.createRootDataObject();
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject3 = (DataObject)map.get("PropertyControl");
        DataObject dataObject4 = (DataObject)map.get("GroupMembershipControl");
        DataObject dataObject5 = (DataObject)map.get("GroupMemberControl");
        DataObject dataObject6 = (DataObject)map.get("AncestorControl");
        DataObject dataObject7 = (DataObject)map.get("DescendantControl");
        DataObject dataObject8 = (DataObject)map.get("CheckGroupMembershipControl");
        List list = null;
        if (dataObject3 != null) {
            list = dataObject3.getList("properties");
        }
        boolean bl = false;
        if (!(dataObject5 == null || this.iLdapConfigMgr.getMembershipAttribute() != null && this.iLdapConfigMgr.isDefaultMbrAttr())) {
            bl = true;
        }
        List list2 = dataObject.getList("entities");
        for (int i = 0; i < list2.size(); ++i) {
            DataObject dataObject9 = (DataObject)list2.get(i);
            String string = this.iSchemaMgr.getQualifiedTypeName(dataObject9.getType());
            DataObject dataObject10 = dataObject9.getDataObject("identifier");
            LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(dataObject10, null, list, dataObject4 != null || dataObject8 != null, bl);
            DataObject dataObject11 = this.createEntityFromLdapEntry(dataObject2, "entities", ldapEntry, list);
            this.getGroups(dataObject11, ldapEntry, dataObject4);
            if (this.iLdapConfigMgr.isGroup(ldapEntry.getType())) {
                this.getMembers(dataObject11, ldapEntry, dataObject5);
            }
            this.getDescendants(dataObject11, ldapEntry, dataObject7);
            this.getAncestors(dataObject11, ldapEntry, dataObject6);
            if (dataObject8 == null) continue;
            int n = dataObject8.getInt("level");
            DataObject dataObject12 = dataObject2.createDataObject("controls", "http://www.ibm.com/websphere/wim", "CheckGroupMembershipControl");
            dataObject12.setBoolean("inGroup", this.isMemberInGroup(dataObject9, ldapEntry, n));
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI get", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    private boolean getGroupsByMembership(DataObject dataObject, LdapEntry ldapEntry, String[] stringArray, int n, List list, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getGroupsByMembership", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printDataObject(dataObject), ldapEntry, WIMTraceHelper.printObjectArray(stringArray), new Integer(n), list, string));
        }
        boolean bl = n == 0 && this.iLdapConfigMgr.getMembershipAttributeScope() == 0;
        boolean bl2 = false;
        String string2 = this.iLdapConfigMgr.getMembershipAttribute();
        Attribute attribute = ldapEntry.getAttributes().get(string2);
        if (attribute == null) {
            bl2 = this.iLdapConfigMgr.getLdapType().startsWith("IDS") && string2 != null && string2.equalsIgnoreCase("ibm-allGroups") ? false : this.getGroupsByMember(dataObject, ldapEntry, stringArray, n, list, string);
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "getGroupsByMembership", bl2);
            }
            return bl2;
        }
        if (attribute.size() == 0) {
            bl2 = false;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "getGroupsByMembership", bl2);
            }
            return bl2;
        }
        HashMap<Object, Attribute> hashMap = null;
        if (bl) {
            hashMap = new HashMap<Object, Attribute>();
        }
        HashSet<String> hashSet = new HashSet<String>();
        List list2 = this.iLdapConfigMgr.getGroupTypes();
        try {
            LdapURL[] ldapURLArray;
            Object object7;
            Object object2;
            Object object3;
            boolean bl3;
            Object object4;
            Object object5;
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                object5 = (String)namingEnumeration.nextElement();
                if (string != null && string.equalsIgnoreCase((String)object5)) {
                    bl2 = true;
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.exiting(CLASSNAME, "getGroupsByMembership", bl2);
                    }
                    return bl2;
                }
                if (!LdapHelper.isUnderBases((String)object5, stringArray)) continue;
                object4 = null;
                try {
                    object4 = this.iLdapConn.getEntityByIdentifier((String)object5, null, null, list2, list, bl, false);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    if (!trcLogger.isLoggable(Level.FINE)) continue;
                    trcLogger.logp(Level.FINE, CLASSNAME, "getGroupsByMembership", "Group " + (String)object5 + " is not found and ingored.");
                    continue;
                }
                if (!this.iLdapConfigMgr.isGroup(((LdapEntry)object4).getType())) {
                    if (!trcLogger.isLoggable(Level.FINE)) continue;
                    trcLogger.logp(Level.FINE, CLASSNAME, "getGroupsByMembership", "Ldap entry " + (String)object5 + " is not a Group.");
                    continue;
                }
                if (dataObject != null) {
                    this.createEntityFromLdapEntry(dataObject, "groups", (LdapEntry)object4, list);
                }
                if (!bl) continue;
                String string3 = ((String)object5).toLowerCase();
                hashMap.put(string3, ((LdapEntry)object4).getAttributes().get(string2));
                hashSet.add(string3);
            }
            object5 = null;
            object4 = null;
            boolean bl4 = bl3 = this.iLdapConfigMgr.getMembershipAttributeScope() != 2 && this.iLdapConfigMgr.supportDynamicGroup();
            if (bl3) {
                object5 = this.iLdapConn.getDynamicGroups(stringArray, list, true);
                object4 = new HashMap(object5.size());
                for (Object object6 : object5.keySet()) {
                    String string4 = ((String)object6).toLowerCase();
                    object3 = (LdapEntry)object5.get(object6);
                    object2 = ((LdapEntry)object3).getAttributes();
                    object7 = object2.get(this.iLdapConfigMgr.getDynamicMemberAttribute(object2.get("objectClass")));
                    if (object7 == null || (ldapURLArray = LdapHelper.getLdapURLs((Attribute)object7)) == null || ldapURLArray.length <= 0) continue;
                    object4.put(object6, ldapURLArray);
                    if (hashMap.containsKey(string4) || !this.iLdapConn.isMemberInURLQuery(ldapURLArray, ldapEntry.getDN())) continue;
                    if (string != null && string.equalsIgnoreCase((String)object6)) {
                        bl2 = true;
                        if (trcLogger.isLoggable(Level.FINER)) {
                            trcLogger.exiting(CLASSNAME, "getGroupsByMembership", new Boolean(bl2));
                        }
                        return bl2;
                    }
                    if (dataObject != null) {
                        this.createEntityFromLdapEntry(dataObject, "groups", (LdapEntry)object3, list);
                    }
                    if (!bl) continue;
                    hashMap.put(string4, ((LdapEntry)object3).getAttributes().get(string2));
                    hashSet.add(string4);
                }
            }
            if (!bl && string != null) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.exiting(CLASSNAME, "getGroupsByMembership", new Boolean(bl2));
                }
                return bl2;
            }
            while (hashSet.size() > 0) {
                HashSet hashSet2 = new HashSet();
                for (String string4 : hashSet) {
                    LdapEntry ldapEntry2;
                    object3 = (Attribute)hashMap.get(string4.toLowerCase());
                    if (object3 != null) {
                        object2 = object3.getAll();
                        while (object2.hasMoreElements()) {
                            object7 = (String)object2.nextElement();
                            if (string != null && string.equalsIgnoreCase((String)object7)) {
                                bl2 = true;
                                if (trcLogger.isLoggable(Level.FINER)) {
                                    trcLogger.exiting(CLASSNAME, "getGroupsByMembership", new Boolean(bl2));
                                }
                                return bl2;
                            }
                            if (!LdapHelper.isUnderBases(string4, stringArray) || hashMap.containsKey(ldapURLArray = ((String)object7).toLowerCase())) continue;
                            ldapEntry2 = null;
                            try {
                                ldapEntry2 = this.iLdapConn.getEntityByIdentifier((String)object7, null, null, list2, list, bl, false);
                            }
                            catch (EntityNotFoundException entityNotFoundException) {
                                if (!trcLogger.isLoggable(Level.FINE)) continue;
                                trcLogger.logp(Level.FINE, CLASSNAME, "getGroupsByMembership", "Group " + (String)object7 + " is not found and ingored.");
                                continue;
                            }
                            if (!this.iLdapConfigMgr.isGroup(ldapEntry2.getType())) {
                                if (!trcLogger.isLoggable(Level.FINE)) continue;
                                trcLogger.logp(Level.FINE, CLASSNAME, "getGroupsByMembership", "Ldap entry " + (String)object7 + " is not a Group.");
                                continue;
                            }
                            if (dataObject != null) {
                                this.createEntityFromLdapEntry(dataObject, "groups", ldapEntry2, list);
                            }
                            if (!bl) continue;
                            hashMap.put(ldapURLArray, ldapEntry2.getAttributes().get(string2));
                            if (hashSet.contains(ldapURLArray)) continue;
                            hashSet2.add(ldapURLArray);
                        }
                    }
                    if (!bl3) continue;
                    for (Object object7 : object4.keySet()) {
                        ldapURLArray = ((String)object7).toLowerCase();
                        if (hashMap.containsKey(ldapURLArray) || !this.iLdapConn.isMemberInURLQuery((LdapURL[])object4.get(object7), string4)) continue;
                        if (string != null && string.equalsIgnoreCase((String)object7)) {
                            bl2 = true;
                            if (trcLogger.isLoggable(Level.FINER)) {
                                trcLogger.exiting(CLASSNAME, "getGroupsByMembership", new Boolean(bl2));
                            }
                            return bl2;
                        }
                        ldapEntry2 = (LdapEntry)object5.get(object7);
                        if (dataObject != null) {
                            this.createEntityFromLdapEntry(dataObject, "groups", ldapEntry2, list);
                        }
                        hashMap.put(ldapURLArray, ldapEntry2.getAttributes().get(string2));
                        if (hashSet.contains(ldapURLArray)) continue;
                        hashSet2.add(ldapURLArray);
                    }
                }
                hashSet = hashSet2;
            }
        }
        catch (NamingException namingException) {
            trcLogger.logp(Level.FINE, CLASSNAME, "getGroupsByMembership", namingException.toString(true));
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "getGroupsByMembership");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getGroupsByMembership", new Boolean(bl2));
        }
        return bl2;
    }

    private boolean getGroupsByMember(DataObject dataObject, LdapEntry ldapEntry, String[] stringArray, int n, List list, String string) throws WIMException {
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        String string2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getGroupsByMember", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printDataObject(dataObject), ldapEntry, WIMTraceHelper.printObjectArray(stringArray), new Integer(n), list, string));
        }
        boolean bl2 = n == 0 && !this.iLdapConfigMgr.isMemberAttributesNestedScope();
        boolean bl3 = false;
        String string3 = this.iLdapConfigMgr.getGroupMemberFilter(ldapEntry.getDN());
        List list2 = this.iLdapConfigMgr.getGroupTypes();
        Object object4 = new HashSet();
        HashSet<Object> hashSet = new HashSet<Object>();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            Set set = this.iLdapConn.searchEntities(stringArray[i], string3, null, 2, list2, list, false, false);
            for (Object object5 : set) {
                if (dataObject != null) {
                    this.createEntityFromLdapEntry(dataObject, "groups", (LdapEntry)object5, list);
                }
                string2 = ((LdapEntry)object5).getDN();
                if (string != null && string.equalsIgnoreCase(string2)) {
                    bl3 = true;
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.exiting(CLASSNAME, "getGroupsByMember", bl3);
                    }
                    return bl3;
                }
                if (!bl2) continue;
                object3 = string2.toLowerCase();
                object4.add(object3);
                hashSet.add(object3);
            }
        }
        Map map = null;
        HashMap<Object, Object> hashMap = null;
        boolean bl4 = bl = !this.iLdapConfigMgr.isMemberAttributesAllScope() && this.iLdapConfigMgr.supportDynamicGroup();
        if (bl) {
            map = this.iLdapConn.getDynamicGroups(stringArray, list, false);
            hashMap = new HashMap<Object, Object>(map.size());
            for (Object object5 : map.keySet()) {
                string2 = ((String)object5).toLowerCase();
                object3 = (LdapEntry)map.get(object5);
                Attributes attributes2 = ((LdapEntry)object3).getAttributes();
                object2 = attributes2.get(this.iLdapConfigMgr.getDynamicMemberAttribute(attributes2.get("objectClass")));
                if (object2 == null || (object = LdapHelper.getLdapURLs((Attribute)object2)) == null || ((Object)object).length <= 0) continue;
                hashMap.put(object5, object);
                if (hashSet.contains(string2) || !this.iLdapConn.isMemberInURLQuery((LdapURL[])object, ldapEntry.getDN())) continue;
                if (string != null && string.equalsIgnoreCase((String)object5)) {
                    bl3 = true;
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.exiting(CLASSNAME, "getGroupsByMember", new Boolean(bl3));
                    }
                    return bl3;
                }
                if (dataObject != null) {
                    this.createEntityFromLdapEntry(dataObject, "groups", (LdapEntry)object3, list);
                }
                if (!bl2) continue;
                object4.add(string2);
                hashSet.add(string2);
            }
        }
        if (!bl2 && string != null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "getGroupsByMember", new Boolean(bl3));
            }
            return bl3;
        }
        while (object4.size() > 0) {
            Object object5;
            Iterator iterator = new HashSet();
            object5 = object4.iterator();
            while (object5.hasNext()) {
                string2 = (String)object5.next();
                string3 = this.iLdapConfigMgr.getGroupMemberFilter(string2);
                int n3 = stringArray.length;
                for (int i = 0; i < n3; ++i) {
                    object2 = this.iLdapConn.searchEntities(stringArray[i], string3, null, 2, list2, list, false, false);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        LdapEntry ldapEntry2 = (LdapEntry)object.next();
                        String string4 = ldapEntry2.getDN();
                        if (string != null && string.equalsIgnoreCase(string4)) {
                            bl3 = true;
                            if (trcLogger.isLoggable(Level.FINER)) {
                                trcLogger.exiting(CLASSNAME, "getGroupsByMember", new Boolean(bl3));
                            }
                            return bl3;
                        }
                        String string5 = string4.toLowerCase();
                        if (hashSet.contains(string5)) continue;
                        if (dataObject != null) {
                            this.createEntityFromLdapEntry(dataObject, "groups", ldapEntry2, list);
                        }
                        hashSet.add(string5);
                        if (object4.contains(string5)) continue;
                        iterator.add((String)string5);
                    }
                }
                if (!bl) continue;
                for (String string6 : hashMap.keySet()) {
                    object2 = string6.toLowerCase();
                    if (hashSet.contains(object2) || !this.iLdapConn.isMemberInURLQuery((LdapURL[])hashMap.get(string6), string2)) continue;
                    object = (LdapEntry)map.get(string6);
                    if (string != null && string.equalsIgnoreCase(string6)) {
                        bl3 = true;
                        if (trcLogger.isLoggable(Level.FINER)) {
                            trcLogger.exiting(CLASSNAME, "getGroupsByMember", new Boolean(bl3));
                        }
                        return bl3;
                    }
                    if (dataObject != null) {
                        this.createEntityFromLdapEntry(dataObject, "groups", (LdapEntry)object, list);
                    }
                    hashSet.add(object2);
                    if (object4.contains(object2)) continue;
                    iterator.add((Object)object2);
                }
            }
            object4 = iterator;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getGroupsByMember", new Boolean(bl3));
        }
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMemberInGroup(DataObject dataObject, LdapEntry ldapEntry, int n) throws WIMException {
        Object object;
        List list = dataObject.getList("groups");
        LdapEntry ldapEntry2 = null;
        String string = null;
        if (list.size() > 0) {
            ldapEntry2 = ldapEntry;
            object = (DataObject)list.get(0);
            LdapEntry ldapEntry3 = this.iLdapConn.getEntityByIdentifier(object.getDataObject("identifier"), null, null, false, false);
            if (!this.iLdapConfigMgr.isGroup(ldapEntry3.getType())) {
                throw new InvalidEntityTypeException("ENTITY_IS_NOT_A_GROUP", WIMMessageHelper.generateMsgParms(ldapEntry3.getUniqueName()), Level.SEVERE, CLASSNAME, "isMemberInGroup");
            }
            string = ldapEntry3.getDN();
        } else {
            if (!this.iLdapConfigMgr.isGroup(ldapEntry.getType())) return false;
            object = dataObject.getList("members");
            if (object.size() <= 0) return false;
            DataObject dataObject2 = (DataObject)object.get(0);
            ldapEntry2 = this.iLdapConn.getEntityByIdentifier(dataObject2.getDataObject("identifier"), null, null, true, false);
            string = ldapEntry.getDN();
        }
        object = this.iLdapConfigMgr.getGroupSearchBases();
        if (this.iLdapConfigMgr.getMembershipAttribute() == null) return this.getGroupsByMember(null, ldapEntry2, (String[])object, n, null, string);
        return this.getGroupsByMembership(null, ldapEntry2, (String[])object, n, null, string);
    }

    private void getGroups(DataObject dataObject, LdapEntry ldapEntry, DataObject dataObject2) throws WIMException {
        if (dataObject2 == null) {
            return;
        }
        int n = dataObject2.getInt("level");
        List list = dataObject2.getList("properties");
        String[] stringArray = null;
        List list2 = dataObject2.getList("searchBases");
        int n2 = list2.size();
        String[] stringArray2 = this.iLdapConfigMgr.getGroupSearchBases();
        if (n2 == 0) {
            stringArray = stringArray2;
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(n2);
            for (int i = 0; i < n2; ++i) {
                String string = (String)list2.get(i);
                String string2 = this.getDN(string, null, null, true, false);
                arrayList.add(string2);
            }
            stringArray = arrayList.toArray(new String[0]);
        }
        stringArray = NodeHelper.getTopNodes(stringArray);
        if (this.iLdapConfigMgr.getMembershipAttribute() != null) {
            this.getGroupsByMembership(dataObject, ldapEntry, stringArray, n, list, null);
        } else {
            this.getGroupsByMember(dataObject, ldapEntry, stringArray, n, list, null);
        }
    }

    private LdapSearchControl getLdapSearchControl(DataObject dataObject) throws WIMException {
        Object object;
        Object object2;
        List list = dataObject.getList("properties");
        int n = dataObject.getInt("countLimit");
        int n2 = dataObject.getInt("timeLimit");
        boolean bl = dataObject.getBoolean("returnSubType");
        String string = dataObject.getString("expression");
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList arrayList = null;
        String string2 = null;
        boolean bl2 = false;
        String string3 = null;
        if (string != null && string.trim().length() > 0) {
            object2 = new WIMXPathInterpreter(new StringReader(string));
            try {
                Object object3;
                Object object4;
                object = ((WIMXPathInterpreter)object2).parse(null);
                List list2 = ((WIMXPathInterpreter)object2).getEntityTypes();
                if (bl) {
                    for (int i = 0; i < list2.size(); ++i) {
                        object4 = (String)list2.get(i);
                        hashSet.add((String)object4);
                        object3 = this.iLdapConfigMgr.getLdapSubEntityTypes((String)object4);
                        hashSet.addAll((Collection<String>)object3);
                    }
                } else {
                    hashSet.addAll(list2);
                }
                arrayList = new ArrayList(hashSet);
                if (object != null) {
                    HashMap hashMap = new HashMap();
                    object4 = object.getPropertyNodes(hashMap);
                    while (object4.hasNext()) {
                        object3 = (PropertyNode)object4.next();
                        String string4 = ((PropertyNode)object3).getName();
                        if (!string4.equals("principalName")) continue;
                        if (hashMap.size() > 1) {
                            throw new SearchControlException("CANNOT_SEARCH_PRINCIPAL_NAME_WITH_OTHER_PROPS", CLASSNAME, "getLdapSearchControl");
                        }
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) {
                    if (object.getNodeType() != 0) {
                        throw new SearchControlException("CANNOT_SEARCH_PRINCIPAL_NAME_WITH_OTHER_PROPS", CLASSNAME, "getLdapSearchControl");
                    }
                    PropertyNode propertyNode = (PropertyNode)object;
                    object4 = (String)propertyNode.getValue();
                    object3 = UniqueNameHelper.getValidUniqueName((String)object4);
                    if (object3 == null) {
                        string2 = this.getPrincipalNameFilter((String)object4);
                    }
                    string3 = this.getDN((String)object3, "PersonAccount", null, true, false);
                }
                string2 = this.getSearchFilter(hashSet, (XPathNode)object);
            }
            catch (ParseException parseException) {
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getLdapSearchControl", (Throwable)parseException);
            }
            catch (TokenMgrError tokenMgrError) {
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getLdapSearchControl", (Throwable)tokenMgrError);
            }
        } else {
            object2 = this.iLdapConfigMgr.getLdapEntities();
            for (int i = 0; i < ((LdapEntity[])object2).length; ++i) {
                hashSet.add(object2[i].getName());
            }
        }
        string2 = string2 != null ? "(&" + this.iLdapConfigMgr.getEntityTypesFilter(hashSet) + string2 + ")" : this.iLdapConfigMgr.getEntityTypesFilter(hashSet);
        object2 = this.getBases(dataObject, arrayList);
        if (string3 != null) {
            object2 = !LdapHelper.isUnderBases(string3, (String[])object2) ? new String[]{} : new String[]{string3};
        }
        object = new LdapSearchControl((String[])object2, arrayList, string2, list, n, n2);
        if (string3 != null) {
            ((LdapSearchControl)object).setScope(0);
        }
        return object;
    }

    private String getSearchFilter(Set set, XPathNode xPathNode) throws WIMException {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        Object var6_5 = null;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getSearchFilter", WIMMessageHelper.generateMsgParms(set, WIMTraceHelper.printObjectArray(new Object[]{xPathNode})));
        }
        if (xPathNode != null) {
            LdapXPathTranslateHelper ldapXPathTranslateHelper = new LdapXPathTranslateHelper(set, this.iLdapConfigMgr);
            ldapXPathTranslateHelper.genSearchString(stringBuffer, xPathNode);
            if (stringBuffer.length() > 0 && (stringBuffer.charAt(0) != '(' || stringBuffer.charAt(stringBuffer.length() - 1) != ')')) {
                stringBuffer.insert(0, '(');
                stringBuffer.append(')');
            }
            string = stringBuffer.toString();
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "getSearchFilter", WIMTraceHelper.printObjectArray(new Object[]{string}));
            }
        }
        return string;
    }

    private void getMembers(DataObject dataObject, LdapEntry ldapEntry, DataObject dataObject2) throws WIMException {
        if (dataObject2 == null) {
            return;
        }
        int n = dataObject2.getInt("level");
        List list = dataObject2.getList("properties");
        List list2 = this.getEntityTypes(dataObject2);
        String[] stringArray = this.getBases(dataObject2, list2);
        if (!this.iLdapConfigMgr.isDefaultMbrAttr()) {
            this.getMembersByMember(dataObject, ldapEntry, stringArray, n, list, list2);
        } else if (this.iLdapConfigMgr.getMembershipAttribute() != null) {
            this.getMembersByMembership(dataObject, ldapEntry, stringArray, n, list, list2);
        } else {
            this.getMembersByMember(dataObject, ldapEntry, stringArray, n, list, list2);
        }
    }

    private String[] getBases(DataObject dataObject, List list) throws WIMException {
        String[] stringArray = null;
        List list2 = dataObject.getList("searchBases");
        int n = list2.size();
        if (n > 0) {
            stringArray = list2.toArray(new String[0]);
            stringArray = NodeHelper.getTopNodes(stringArray);
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                String string2 = stringArray[i];
                stringArray[i] = string = this.getDN(string2, null, null, true, false);
            }
        } else {
            ArrayList arrayList = new ArrayList();
            if (list == null) {
                stringArray = this.iLdapConfigMgr.getTopLdapNodes();
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity((String)list.get(i));
                    if (ldapEntity == null) {
                        stringArray = this.iLdapConfigMgr.getTopLdapNodes();
                        break;
                    }
                    arrayList.addAll(ldapEntity.getSearchBaseList());
                }
                if (stringArray == null) {
                    stringArray = arrayList.toArray(new String[0]);
                    stringArray = NodeHelper.getTopNodes(stringArray);
                }
            }
        }
        return stringArray;
    }

    private void getMembersByMembership(DataObject dataObject, LdapEntry ldapEntry, String[] stringArray, int n, List list, List list2) throws WIMException {
        Object object;
        Object object2;
        String[] stringArray2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getMembersByMembership", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printDataObject(dataObject), ldapEntry, WIMTraceHelper.printObjectArray(stringArray), new Integer(n), list, list2));
        }
        boolean bl = n == 0 && this.iLdapConfigMgr.getMembershipAttributeScope() == 0;
        String string = this.iLdapConfigMgr.getMembershipAttribute();
        boolean bl2 = this.iLdapConfigMgr.containGroup(list2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        StringBuffer stringBuffer = new StringBuffer("(&(" + string + "={0})");
        if (list2.size() > 1 || !bl2 && bl) {
            stringBuffer.append("(|");
        }
        Object[] objectArray = list2.iterator();
        while (objectArray.hasNext()) {
            stringArray2 = this.iLdapConfigMgr.getLdapEntity((String)objectArray.next());
            stringBuffer.append(stringArray2.getSearchFilter());
        }
        if (!bl2 && bl) {
            objectArray = this.iLdapConfigMgr.getLdapEntity("Group");
            stringBuffer.append(objectArray.getSearchFilter());
            arrayList.addAll(objectArray.getSearchBaseList());
        }
        if (list2.size() > 1 || !bl2 && bl) {
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
        objectArray = new Object[]{ldapEntry.getDN()};
        stringArray2 = new String[]{};
        stringArray2 = arrayList.toArray(stringArray2);
        stringArray2 = NodeHelper.getTopNodes(stringArray2);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; i < stringArray2.length; ++i) {
            Set set = this.iLdapConn.searchEntities(stringArray2[i], stringBuffer.toString(), objectArray, 2, list2, list, false, false);
            Iterator object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = (LdapEntry)object3.next();
                String string2 = ((LdapEntry)object2).getDN();
                if (this.iLdapConfigMgr.isGroup(((LdapEntry)object2).getType())) {
                    if (bl) {
                        object = string2.toLowerCase();
                        hashSet.add((String)object);
                        hashSet2.add((String)object);
                    }
                    if (!bl2) continue;
                }
                if (!LdapHelper.isUnderBases(string2, stringArray)) continue;
                this.createEntityFromLdapEntry(dataObject, "members", (LdapEntry)object2, list);
            }
        }
        if (bl) {
            while (hashSet.size() > 0) {
                HashSet<String> hashSet3 = new HashSet<String>();
                for (String string3 : hashSet) {
                    object2 = string3.toLowerCase();
                    objectArray[0] = string3;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        object = this.iLdapConn.searchEntities(stringArray2[i], stringBuffer.toString(), objectArray, 2, list2, list, false, false);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            LdapEntry ldapEntry2 = (LdapEntry)iterator.next();
                            String string4 = ldapEntry2.getDN();
                            String string5 = string4.toLowerCase();
                            if (!hashSet2.contains(string5) && this.iLdapConfigMgr.isGroup(ldapEntry2.getType())) {
                                if (!hashSet.contains(string5)) {
                                    hashSet3.add(string5);
                                }
                                hashSet2.add(string5);
                                if (!bl2) continue;
                            }
                            if (!LdapHelper.isUnderBases(string4, stringArray)) continue;
                            this.createEntityFromLdapEntry(dataObject, "members", ldapEntry2, list);
                        }
                    }
                }
                hashSet = hashSet3;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getMembersByMembership");
        }
    }

    private void getMembersByMember(DataObject dataObject, LdapEntry ldapEntry, String[] stringArray, int n, List list, List list2) throws WIMException {
        block21: {
            Object object;
            Object object2;
            String string;
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "getMembersByMember", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printDataObject(dataObject), ldapEntry, WIMTraceHelper.printObjectArray(stringArray), new Integer(n), list, list2));
            }
            Attributes attributes2 = ldapEntry.getAttributes();
            Attribute attribute = this.iLdapConfigMgr.getGroupMemberAttrs(attributes2, attributes2.get("objectClass"));
            if (this.iLdapConfigMgr.supportDynamicGroup() && (string = this.iLdapConfigMgr.getDynamicMemberAttribute(attributes2.get("objectClass"))) != null && (object2 = this.getDynamicMembers(attributes2.remove(string))) != null && object2.size() > 0) {
                if (attribute == null) {
                    object = null;
                    if (attributes2.get("objectClass") != null) {
                        object = this.iLdapConfigMgr.getMemberAttribute(attributes2.get("objectClass"));
                    }
                    attribute = new BasicAttribute((String)object);
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    attribute.add(object.next());
                }
            }
            if (attribute == null) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.exiting(CLASSNAME, "getMembersByMember");
                }
                return;
            }
            boolean bl = n == 0 && !this.iLdapConfigMgr.isMemberAttributesNestedScope();
            object2 = new HashMap();
            try {
                Object object3;
                Object object4;
                String string2;
                Object object5;
                Object object6;
                object = attribute.getAll();
                while (object.hasMoreElements()) {
                    object6 = (String)object.next();
                    if (this.iLdapConfigMgr.isDummyMember((String)object6) || !LdapHelper.isUnderBases((String)object6, stringArray) || !this.startWithSameRDN((String)object6, list2, bl)) continue;
                    object5 = null;
                    try {
                        object5 = this.iLdapConn.getEntityByIdentifier((String)object6, null, null, list2, list, false, bl);
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        if (!trcLogger.isLoggable(Level.FINE)) continue;
                        trcLogger.logp(Level.FINE, CLASSNAME, "getMembersByMember", "Group member " + (String)object6 + " is not found and ignored.");
                        continue;
                    }
                    string2 = ((LdapEntry)object5).getType();
                    if (LdapHelper.isEntityTypeInList(string2, list2)) {
                        this.createEntityFromLdapEntry(dataObject, "members", (LdapEntry)object5, list);
                    }
                    if (!bl || !this.iLdapConfigMgr.isGroup(string2) || (object4 = this.iLdapConfigMgr.getGroupMemberAttrs((Attributes)(object3 = ((LdapEntry)object5).getAttributes()), object3.get("objectClass"))) == null) continue;
                    object2.put(((String)object6).toLowerCase(), object4);
                }
                if (!bl) break block21;
                object = new HashSet(object2.keySet());
                while (object.size() > 0) {
                    object6 = new HashSet();
                    object5 = object.iterator();
                    while (object5.hasNext()) {
                        string2 = (String)object5.next();
                        object3 = string2.toLowerCase();
                        attribute = (Attribute)object2.get(object3);
                        if (attribute == null) continue;
                        object4 = attribute.getAll();
                        while (object4.hasMoreElements()) {
                            String string3 = (String)object4.next();
                            String string4 = string3.toLowerCase();
                            if (this.iLdapConfigMgr.isDummyMember(string3) || !LdapHelper.isUnderBases(string3, stringArray) || !this.startWithSameRDN(string3, list2, bl) || object2.containsKey(string4)) continue;
                            LdapEntry ldapEntry2 = null;
                            try {
                                ldapEntry2 = this.iLdapConn.getEntityByIdentifier(string3, null, null, list2, list, false, bl);
                            }
                            catch (EntityNotFoundException entityNotFoundException) {
                                if (!trcLogger.isLoggable(Level.FINE)) continue;
                                trcLogger.logp(Level.FINE, CLASSNAME, "getMembersByMember", "Group member " + string3 + " is not found and ignored.");
                                continue;
                            }
                            String string5 = ldapEntry2.getType();
                            if (LdapHelper.isEntityTypeInList(string5, list2)) {
                                this.createEntityFromLdapEntry(dataObject, "members", ldapEntry2, list);
                            }
                            if (!bl || !this.iLdapConfigMgr.isGroup(string5)) continue;
                            Attributes attributes3 = ldapEntry2.getAttributes();
                            Attribute attribute2 = this.iLdapConfigMgr.getGroupMemberAttrs(attributes3, attributes3.get("objectClass"));
                            if (attribute2 != null) {
                                object2.put(string3.toLowerCase(), attribute2);
                            }
                            if (object.contains(string4)) continue;
                            object6.add(string4);
                        }
                    }
                    object = object6;
                }
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "getMembersByMember");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getMembersByMember");
        }
    }

    private boolean startWithSameRDN(String string, List list, boolean bl) {
        string = string.toLowerCase();
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (this.iLdapConfigMgr.isGroup(string2)) {
                bl2 = true;
            }
            if (!this.iLdapConfigMgr.getLdapEntity(string2).startWithSameRDN(string)) continue;
            return true;
        }
        return bl && !bl2 && this.iLdapConfigMgr.getLdapEntity("Group").startWithSameRDN(string);
    }

    private void getAncestors(DataObject dataObject, LdapEntry ldapEntry, DataObject dataObject2) throws WIMException {
        if (dataObject2 == null) {
            return;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getAncestors");
        }
        List list = dataObject2.getList("properties");
        int n = dataObject2.getInt("level");
        List list2 = this.getEntityTypes(dataObject2);
        String[] stringArray = this.getBases(dataObject2, list2);
        boolean bl = dataObject2.getBoolean("treeView");
        String string = ldapEntry.getDN();
        List list3 = this.iLdapConn.getAncestorDNs(string, n);
        DataObject dataObject3 = dataObject;
        for (int i = 0; i < list3.size(); ++i) {
            String string2 = (String)list3.get(i);
            if (string2.length() == 0 || !LdapHelper.isUnderBases(string2, stringArray)) continue;
            LdapEntry ldapEntry2 = this.iLdapConn.getEntityByIdentifier(string2, null, null, list2, list, false, false);
            String string3 = ldapEntry2.getType();
            DataObject dataObject4 = null;
            dataObject4 = list2.contains(string3) ? this.createEntityFromLdapEntry(dataObject3, "parent", ldapEntry2, list) : this.createEntityFromLdapEntry(dataObject3, "parent", ldapEntry2, null);
            dataObject3 = dataObject4;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getAncestors");
        }
    }

    private void getDescendants(DataObject dataObject, LdapEntry ldapEntry, DataObject dataObject2) throws WIMException {
        String string;
        String string2;
        if (dataObject2 == null) {
            return;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getDescendants");
        }
        List list = dataObject2.getList("properties");
        int n = dataObject2.getInt("level");
        List list2 = this.getEntityTypes(dataObject2);
        String[] stringArray = this.getBases(dataObject2, list2);
        boolean bl = dataObject2.getBoolean("treeView");
        int n2 = 1;
        if (n == 0 && !bl) {
            n2 = 2;
        }
        Object object = new HashSet();
        HashMap<String, DataObject> hashMap = new HashMap<String, DataObject>();
        Set set = this.iLdapConn.searchEntities(ldapEntry.getDN(), "objectClass=*", null, n2, list2, list, false, false);
        for (Object object2 : set) {
            string2 = ((LdapEntry)object2).getType();
            string = ((LdapEntry)object2).getDN();
            Object object3 = null;
            if (LdapHelper.isUnderBases(string, stringArray) && list2.contains(string2)) {
                object3 = this.createEntityFromLdapEntry(dataObject, "children", (LdapEntry)object2, list);
            } else if (bl) {
                object3 = this.createEntityFromLdapEntry(dataObject, "children", (LdapEntry)object2, null);
            }
            if (!bl) continue;
            object.add(string);
            hashMap.put(string, (DataObject)object3);
        }
        if (bl) {
            while (object.size() > 0) {
                Object object2;
                HashSet hashSet = new HashSet();
                object2 = object.iterator();
                while (object2.hasNext()) {
                    string2 = (String)object2.next();
                    string = (DataObject)hashMap.get(string2);
                    set = this.iLdapConn.searchEntities(string2, "objectClass=*", null, n2, list2, list, false, false);
                    for (LdapEntry ldapEntry2 : set) {
                        String string3 = ldapEntry2.getType();
                        String string4 = ldapEntry2.getDN();
                        DataObject dataObject3 = null;
                        if (list2.contains(string3)) {
                            dataObject3 = this.createEntityFromLdapEntry((DataObject)string, "children", ldapEntry2, list);
                        } else if (bl) {
                            dataObject3 = this.createEntityFromLdapEntry((DataObject)string, "children", ldapEntry2, null);
                        }
                        if (object.contains(string4)) continue;
                        hashSet.add(string4);
                        hashMap.put(string4, dataObject3);
                    }
                }
                object = hashSet;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDescendants");
        }
    }

    private List getEntityTypes(DataObject dataObject) throws WIMException {
        String string = "getEntityTypes";
        String string2 = dataObject.getString("expression");
        HashSet<String> hashSet = new HashSet<String>();
        if (string2 != null && string2.trim().length() > 0) {
            Object object;
            WIMXPathInterpreter wIMXPathInterpreter = new WIMXPathInterpreter(new StringReader(string2));
            try {
                object = wIMXPathInterpreter.parse(null);
            }
            catch (ParseException parseException) {
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, string, (Throwable)parseException);
            }
            catch (TokenMgrError tokenMgrError) {
                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, string, (Throwable)tokenMgrError);
            }
            object = wIMXPathInterpreter.getEntityTypes();
            hashSet.addAll((Collection<String>)object);
        } else {
            LdapEntity[] ldapEntityArray = this.iLdapConfigMgr.getLdapEntities();
            for (int i = 0; i < ldapEntityArray.length; ++i) {
                hashSet.add(ldapEntityArray[i].getName());
            }
        }
        return new ArrayList(hashSet);
    }

    public DataObject login(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI login", WIMTraceHelper.printDataGraph(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.getRepositoryId(), CLASSNAME, "login");
        List list = dataObject.getList("entities");
        DataObject dataObject2 = (DataObject)list.get(0);
        String string = this.iSchemaMgr.getQualifiedTypeName(dataObject2.getType());
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject3 = (DataObject)map.get("LoginControl");
        if (dataObject3 == null) {
            dataObject3 = SDOHelper.createControlDataObject(dataObject, "http://www.ibm.com/websphere/wim", "LoginControl");
        }
        LdapSearchControl ldapSearchControl = null;
        String string2 = dataObject2.getString("principalName");
        byte[] byArray = dataObject2.getBytes("password");
        List list2 = dataObject2.getList("certificate");
        int n = list2.size();
        LdapEntry ldapEntry = null;
        DataObject dataObject4 = this.iSchemaMgr.createRootDataObject();
        if (n > 0) {
            X509Certificate[] x509CertificateArray = new X509Certificate[n];
            try {
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])list2.get(i));
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    x509CertificateArray[i] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new CertificateMapFailedException();
            }
            catch (CertificateException certificateException) {
                throw new CertificateMapFailedException();
            }
            ldapSearchControl = this.getLdapSearchControl(dataObject3);
            ldapEntry = this.mapCertificate(x509CertificateArray, ldapSearchControl);
            if (ldapEntry == null) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.exiting(CLASSNAME, "WIM_SPI login", WIMTraceHelper.printDataGraph(dataObject4));
                }
                return dataObject4;
            }
        } else {
            if (string2 == null || string2.trim().length() == 0) {
                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", CLASSNAME, "login");
            }
            if (byArray == null || byArray.length == 0) {
                throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PASSWORD", CLASSNAME, "login");
            }
            String string3 = "'";
            if (string2.indexOf("'") != -1) {
                string3 = "\"";
            }
            String string4 = "@xsi:type=" + string3 + string + string3 + " and " + "principalName" + "=" + string3 + string2 + string3;
            dataObject3.setString("expression", string4);
            ldapSearchControl = this.getLdapSearchControl(dataObject3);
            String[] stringArray = ldapSearchControl.getBases();
            String string5 = ldapSearchControl.getFilter();
            int n2 = ldapSearchControl.getCountLimit();
            int n3 = ldapSearchControl.getTimeLimit();
            List list3 = ldapSearchControl.getEntityTypes();
            List list4 = ldapSearchControl.getPropertyNmaes();
            int n4 = ldapSearchControl.getScope();
            int n5 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Set set = this.iLdapConn.searchEntities(stringArray[i], string5, null, n4, list3, list4, false, false, n2, n3);
                    if (set.size() > 1) {
                        throw new PasswordCheckFailedException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "login");
                    }
                    if (set.size() != 1) continue;
                    if (n5 == 0) {
                        ldapEntry = (LdapEntry)set.iterator().next();
                    }
                    if (++n5 <= 1) continue;
                    throw new PasswordCheckFailedException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "login");
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
            if (ldapEntry == null) {
                if (trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.exiting(CLASSNAME, "WIM_SPI login", WIMTraceHelper.printDataGraph(dataObject4));
                }
                return dataObject4;
            }
            String string6 = ldapEntry.getDN();
            this.authenticateWithPassword(string6, byArray, string2);
        }
        this.createEntityFromLdapEntry(dataObject4, "entities", ldapEntry, dataObject3.getList("properties"));
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI login", WIMTraceHelper.printDataGraph(dataObject4));
        }
        return dataObject4;
    }

    private void authenticateWithPassword(String string, byte[] byArray, String string2) throws WIMException {
        try {
            DirContext dirContext = this.iLdapConn.createDirContext(string, byArray);
            dirContext.close();
        }
        catch (AuthenticationNotSupportedException authenticationNotSupportedException) {
            throw new com.ibm.websphere.wim.exception.AuthenticationNotSupportedException("AUTHENTICATE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(this.getRepositoryId(), authenticationNotSupportedException.toString(true)), CLASSNAME, "authenticateWithPassword");
        }
        catch (AuthenticationException authenticationException) {
            throw new PasswordCheckFailedException("PASSWORD_CHECKED_FAILED", WIMMessageHelper.generateMsgParms(string2, authenticationException.toString(true)), CLASSNAME, "authenticateWithPassword");
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, nameNotFoundException.toString(true)), CLASSNAME, "authenticateWithPassword");
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "authenticateWithPassword");
        }
    }

    private LdapEntry mapCertificate(X509Certificate[] x509CertificateArray, LdapSearchControl ldapSearchControl) throws WIMException {
        LdapEntry ldapEntry = null;
        X509Certificate x509Certificate = x509CertificateArray[0];
        if ("filterDescriptorMode".equalsIgnoreCase(this.iLdapConfigMgr.getCertificateMapMode())) {
            String string = this.iLdapConfigMgr.getCertificateLDAPFilter(x509Certificate);
            String[] stringArray = ldapSearchControl.getBases();
            int n = ldapSearchControl.getCountLimit();
            int n2 = ldapSearchControl.getTimeLimit();
            List list = ldapSearchControl.getEntityTypes();
            List list2 = ldapSearchControl.getPropertyNmaes();
            int n3 = ldapSearchControl.getScope();
            int n4 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Set set = this.iLdapConn.searchEntities(stringArray[i], string, null, n3, list, list2, false, false, n, n2);
                    if (set.size() > 1) {
                        throw new CertificateMapFailedException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "mapCertificate");
                    }
                    if (set.size() != 1) continue;
                    if (n4 == 0) {
                        ldapEntry = (LdapEntry)set.iterator().next();
                    }
                    if (++n4 <= 1) continue;
                    throw new CertificateMapFailedException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "mapCertificate");
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
        } else {
            String string = LdapHelper.getValidDN(x509Certificate.getSubjectDN().getName());
            try {
                ldapEntry = this.iLdapConn.getEntityByIdentifier(string, null, null, null, ldapSearchControl.getPropertyNmaes(), false, false);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        return ldapEntry;
    }

    private String getPrincipalNameFilter(String string) {
        List list = this.iLdapConfigMgr.getLoginAttributes();
        string = LdapName.escapeAttributeValue(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 1) {
            stringBuffer.append("(|");
        }
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append("(" + list.get(i) + "=" + string + ")");
        }
        if (list.size() > 1) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private List getLoginAttributes(DataObject dataObject) {
        ArrayList<String> arrayList = null;
        List list = dataObject.getList("mappedProperties");
        LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity("Person");
        int n = list.size();
        if (n == 0) {
            arrayList = this.iLdapConfigMgr.getLoginAttributes();
        } else {
            arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                String string = (String)list.get(i);
                arrayList.add(this.iLdapConfigMgr.getAttributeName(ldapEntity, string));
            }
        }
        return arrayList;
    }

    private String getPersonUniqueId(String string) {
        int n = string.indexOf("account");
        if (n == 0) {
            return string.substring("account".length());
        }
        return string;
    }

    private String getPersonUniqueName(String string) {
        return null;
    }

    public DataObject search(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI search", WIMTraceHelper.printDataGraph(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.getRepositoryId(), CLASSNAME, "search");
        String string = null;
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject2 = (DataObject)map.get("SearchControl");
        if (dataObject2 != null && ((string = dataObject2.getString("expression")) == null || string.length() == 0)) {
            throw new SearchControlException("MISSING_SEARCH_EXPRESSION", CLASSNAME, "search");
        }
        LdapSearchControl ldapSearchControl = this.getLdapSearchControl(dataObject2);
        String[] stringArray = ldapSearchControl.getBases();
        String string2 = ldapSearchControl.getFilter();
        int n = ldapSearchControl.getCountLimit();
        int n2 = ldapSearchControl.getTimeLimit();
        List list = ldapSearchControl.getEntityTypes();
        List list2 = ldapSearchControl.getPropertyNmaes();
        int n3 = ldapSearchControl.getScope();
        DataObject dataObject3 = this.iSchemaMgr.createRootDataObject();
        for (int i = 0; i < stringArray.length; ++i) {
            Set set = this.iLdapConn.searchEntities(stringArray[i], string2, null, n3, list, list2, false, false, n, n2);
            for (LdapEntry ldapEntry : set) {
                this.createEntityFromLdapEntry(dataObject3, "entities", ldapEntry, list2);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI search", WIMTraceHelper.printDataGraph(dataObject3));
        }
        return dataObject3;
    }

    private void getPropertyDefinitions(DataObject dataObject, DataObject dataObject2) throws InvalidEntityTypeException {
        String string = dataObject2.getString("entityTypeName");
        if (string != null) {
            LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(string);
            if (ldapEntity == null) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "getPropertyDefinitions(DataObject, DataObject)", "Entity type " + string + " is invalid and is ignored.");
                }
                return;
            }
            ArrayList arrayList = dataObject2.getList("propertyNames");
            Set set = ldapEntity.getProperties();
            if (arrayList.size() == 0) {
                arrayList = new ArrayList(set);
            } else {
                arrayList.retainAll(set);
            }
            DataObject dataObject3 = dataObject.getDataObject("schema");
            if (dataObject3 == null) {
                dataObject3 = dataObject.createDataObject("schema");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                LdapAttribute ldapAttribute;
                String string2 = (String)arrayList.get(i);
                if (this.iSchemaMgr.getProperty(string, string2) == null && trcLogger.isLoggable(Level.FINER)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "getPropertyDefinitions(DataObject, DataObject)", "Property type " + string2 + " is invalid and is ignored.");
                }
                String string3 = this.iSchemaMgr.getTypeName(string2);
                String string4 = this.iSchemaMgr.getTypeNsURI(string2);
                DataObject dataObject4 = dataObject3.createDataObject("propertySchema");
                dataObject4.set("propertyName", (Object)string3);
                dataObject4.set("nsURI", (Object)string4);
                dataObject4.set("nsPrefix", (Object)this.iSchemaMgr.getNsPrefix(string4));
                DataObject dataObject5 = null;
                String string5 = this.iLdapConfigMgr.getAttributeName(ldapEntity, string2);
                if (!string2.equals(string5)) {
                    dataObject5 = dataObject4.createDataObject("metaData");
                    dataObject5.set("name", (Object)"repositoryPropertyName");
                    dataObject5.getList("values").add(string5);
                }
                if ((ldapAttribute = this.iLdapConfigMgr.getLdapAttribute(string5)) == null || ldapAttribute.getSyntax() == null) continue;
                if (dataObject5 == null) {
                    dataObject5 = dataObject4.createDataObject("metaData");
                }
                dataObject5.set("name", (Object)"repositoryDataType");
                dataObject5.getList("values").add(ldapAttribute.getSyntax());
            }
        }
    }

    private void getDataTypes(DataObject dataObject, DataObject dataObject2) throws InvalidEntityTypeException {
        DataObject dataObject3 = dataObject.getDataObject("schema");
        if (dataObject3 == null) {
            dataObject3 = dataObject.createDataObject("schema");
        }
        dataObject3.setList("propertyDataTypes", this.iLdapConfigMgr.getDataTypes());
    }

    private void getEntityTypeDefinitions(DataObject dataObject, DataObject dataObject2) throws InvalidEntityTypeException {
        Object object;
        Object object2;
        int n;
        Object object3;
        List list = dataObject2.getList("entityTypeNames");
        LdapEntity[] ldapEntityArray = null;
        if (list != null && list.size() > 0) {
            object3 = new ArrayList(list.size());
            for (n = 0; n < list.size(); ++n) {
                object2 = (String)list.get(n);
                object = this.iLdapConfigMgr.getLdapEntity((String)object2);
                if (object == null) {
                    if (!trcLogger.isLoggable(Level.FINE)) continue;
                    trcLogger.logp(Level.FINE, CLASSNAME, "getEntityTypeDefinitions(DataObject, DataObject)", "Entity type " + (String)object2 + " is invalid and is ignored.");
                    continue;
                }
                object3.add(object);
            }
            ldapEntityArray = object3.toArray(new LdapEntity[0]);
        } else {
            ldapEntityArray = this.iLdapConfigMgr.getLdapEntities();
        }
        object3 = dataObject.getDataObject("schema");
        if (object3 == null) {
            object3 = dataObject.createDataObject("schema");
        }
        for (n = 0; n < ldapEntityArray.length; ++n) {
            object2 = ldapEntityArray[n];
            object = ((LdapEntity)object2).getName();
            DataObject dataObject3 = object3.createDataObject("entitySchema");
            String string = this.iSchemaMgr.getTypeName((String)object);
            String string2 = this.iSchemaMgr.getTypeNsURI((String)object);
            dataObject3.set("entityName", (Object)string);
            dataObject3.set("nsURI", (Object)string2);
            DataObject dataObject4 = dataObject3.createDataObject("entityConfiguration");
            DataObject dataObject5 = dataObject4.createDataObject("metaData");
            dataObject5.set("name", (Object)"rdnAttributes");
            String[][] stringArray = ((LdapEntity)object2).getRDNAttributes();
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i];
                String string3 = null;
                if (stringArray2.length == 1) {
                    string3 = stringArray2[0];
                } else {
                    for (int j = 0; j < stringArray2.length; ++j) {
                        string3 = j > 0 ? string3 + "+" + stringArray2[j] : stringArray2[j];
                    }
                }
                dataObject5.getList("values").add(string3);
            }
            dataObject5 = dataObject4.createDataObject("metaData");
            dataObject5.set("name", (Object)"objectClasses");
            dataObject5.setList("values", ((LdapEntity)object2).getObjectClasses());
            dataObject5 = dataObject4.createDataObject("metaData");
            dataObject5.set("name", (Object)"searchFilter");
            dataObject5.getList("values").add(((LdapEntity)object2).getSearchFilter());
            dataObject5 = dataObject4.createDataObject("metaData");
            dataObject5.set("name", (Object)"searchBases");
            dataObject5.getList("values").addAll(((LdapEntity)object2).getSearchBaseList());
            String string4 = "1";
        }
    }

    public DataObject getSchema(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getSchema", WIMTraceHelper.printDataGraph(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.getRepositoryId(), CLASSNAME, "getSchema");
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject2 = (DataObject)map.get("EntityTypeControl");
        DataObject dataObject3 = (DataObject)map.get("PropertyDefinitionControl");
        DataObject dataObject4 = (DataObject)map.get("DataTypeControl");
        DataObject dataObject5 = this.iSchemaMgr.createRootDataObject();
        if (dataObject2 != null) {
            this.getEntityTypeDefinitions(dataObject5, dataObject2);
        }
        if (dataObject3 != null) {
            this.getPropertyDefinitions(dataObject5, dataObject3);
        }
        if (dataObject4 != null) {
            this.getDataTypes(dataObject5, dataObject4);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getSchema", WIMTraceHelper.printDataGraph(dataObject5));
        }
        return dataObject5;
    }

    public DataObject createSchema(DataObject dataObject) throws WIMException {
        DataObject dataObject2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI createSchema", WIMTraceHelper.printDataGraph(dataObject));
        }
        AsyncUtils.asyncOperationNotSupported(dataObject, this.getRepositoryId(), CLASSNAME, "createSchema");
        DataObject dataObject3 = dataObject.getDataObject("schema");
        if (dataObject3 != null) {
            dataObject2 = ConfigManager.singleton().getRepositoryDataObject(this.getRepositoryId());
            this.iLdapConfigMgr.initialize(dataObject2);
            this.iLdapConn.initializeRetrieveAttrIds();
        }
        dataObject2 = this.iSchemaMgr.createRootDataObject();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI createSchema", WIMTraceHelper.printDataGraph(dataObject2));
        }
        return dataObject2;
    }

    private void populateEntity(DataObject dataObject, List list, Attributes attributes2) throws WIMException {
        if (list == null) {
            return;
        }
        String string = this.iSchemaMgr.getQualifiedTypeName(dataObject.getType());
        LdapEntity ldapEntity = this.iLdapConfigMgr.getLdapEntity(string);
        Set set = ldapEntity.getAttributes();
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
            while (namingEnumeration.hasMore()) {
                boolean bl = false;
                Attribute attribute = namingEnumeration.next();
                String string2 = attribute.getID();
                if (set.contains(string2)) {
                    bl = true;
                } else {
                    for (String string3 : set) {
                        if (!string3.equalsIgnoreCase(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl && ("userPassword".equalsIgnoreCase(string2) || "unicodePwd".equalsIgnoreCase(string2))) {
                    bl = true;
                }
                Set set2 = this.iLdapConfigMgr.getPropertyName(ldapEntity, string2);
                boolean bl2 = false;
                if (set2.contains("ibmPrimaryEmail") && set2.contains("ibm-primaryEmail")) {
                    bl2 = true;
                }
                if (set2.contains("ibmJobTitle") && set2.contains("ibm-jobTitle")) {
                    bl2 = true;
                }
                Iterator iterator = set2.iterator();
                block4: while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (string4.equalsIgnoreCase("ibmPrimaryEmail") && bl2 || string4.equalsIgnoreCase("ibmJobTitle") && bl2) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        String string5 = (String)list.get(i);
                        if ((!"*".equals(string5) || !bl) && !string5.equalsIgnoreCase(string4)) continue;
                        Property property = this.iSchemaMgr.getProperty(dataObject.getType(), string4);
                        if (property == null) continue block4;
                        this.setPropertyValue(dataObject, attribute, property, this.iLdapConfigMgr.getLdapAttribute(string2));
                        continue block4;
                    }
                }
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "populateEntity");
        }
    }

    private String getString(boolean bl, Object object) {
        if (bl) {
            return LdapHelper.getOctetString((byte[])object);
        }
        return object.toString();
    }

    private String getDateString(Object object) throws WIMSystemException {
        String string = "getDateString(Object)";
        if (object instanceof Date) {
            return SDOHelper.getDateString((Date)object);
        }
        SimpleDateFormat simpleDateFormat = null;
        StringBuffer stringBuffer = new StringBuffer(object.toString());
        int n = stringBuffer.indexOf("Z");
        if (n == -1) {
            n = stringBuffer.indexOf("z");
        }
        if (n != -1) {
            stringBuffer.replace(n, n, "-0000");
        }
        if (this.iLdapConfigMgr.getLdapType().startsWith("IDS")) {
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
            stringBuffer = new StringBuffer(stringBuffer.substring(0, 18) + stringBuffer.substring(21));
        } else {
            simpleDateFormat = this.iLdapConfigMgr.getLdapType().startsWith("SUNONE") || this.iLdapConfigMgr.getLdapType().startsWith("DOMINO") || this.iLdapConfigMgr.getLdapType().startsWith("NDS") ? new SimpleDateFormat("yyyyMMddHHmmssZ") : new SimpleDateFormat("yyyyMMddHHmmss.SZ");
        }
        Date date = null;
        try {
            date = simpleDateFormat.parse(stringBuffer.toString());
        }
        catch (java.text.ParseException parseException) {
            throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(parseException.toString()), Level.WARNING, CLASSNAME, string);
        }
        return SDOHelper.getDateString(date);
    }

    private void setPropertyValue(DataObject dataObject, Attribute attribute, Property property, LdapAttribute ldapAttribute) throws WIMException {
        block46: {
            String string = property.getType().getName();
            boolean bl = property.isMany();
            String string2 = "string";
            if (ldapAttribute != null) {
                string2 = ldapAttribute.getSyntax();
            }
            try {
                if ("String".equals(string)) {
                    boolean bl2 = "octetString".equalsIgnoreCase(string2);
                    if (bl) {
                        NamingEnumeration<?> namingEnumeration = attribute.getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            Object e2 = namingEnumeration.nextElement();
                            if (e2 == null) continue;
                            dataObject.getList(property).add(this.getString(bl2, e2));
                        }
                    } else {
                        Object object = attribute.get();
                        if (object != null) {
                            dataObject.set(property, (Object)this.getString(bl2, object));
                        }
                    }
                    break block46;
                }
                if ("DateTime".equals(string)) {
                    if (bl) {
                        NamingEnumeration<?> namingEnumeration = attribute.getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            Object e3 = namingEnumeration.nextElement();
                            if (e3 == null) continue;
                            dataObject.getList(property).add(this.getDateString(e3));
                        }
                    } else {
                        Object object = attribute.get();
                        if (object != null) {
                            dataObject.set(property, (Object)this.getDateString(object));
                        }
                    }
                    break block46;
                }
                if ("Int".equals(string)) {
                    if (bl) {
                        NamingEnumeration<?> namingEnumeration = attribute.getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            Object e4 = namingEnumeration.nextElement();
                            if (e4 == null) continue;
                            dataObject.getList(property).add(new Integer(e4.toString()));
                        }
                    } else {
                        Object object = attribute.get();
                        if (object != null) {
                            dataObject.setInt(property, Integer.parseInt(object.toString()));
                        }
                    }
                    break block46;
                }
                if ("IdentifierType".equals(string)) {
                    try {
                        if (bl) {
                            NamingEnumeration<?> namingEnumeration = attribute.getAll();
                            while (namingEnumeration.hasMoreElements()) {
                                String string3 = (String)namingEnumeration.nextElement();
                                if (string3 == null) continue;
                                LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(string3, null, null, null, null, false, false);
                                dataObject.getList(property).add(this.createIdentiferFromLdapEntry(ldapEntry));
                            }
                        } else {
                            String string4 = (String)attribute.get();
                            if (string4 != null) {
                                LdapEntry ldapEntry = this.iLdapConn.getEntityByIdentifier(string4, null, null, null, null, false, false);
                                dataObject.set(property, (Object)this.createIdentiferFromLdapEntry(ldapEntry));
                            }
                        }
                        break block46;
                    }
                    catch (WIMException wIMException) {
                        if ("LDAP_ENTRY_NOT_FOUND".equalsIgnoreCase(wIMException.getMessageKey())) {
                            throw new WIMSystemException("INVALID_PROPERTY_VALUE", WIMMessageHelper.generateMsgParms(property.getName(), dataObject.getDataObject("identifier").getString("externalName")), CLASSNAME, "setValue(DataObject, Object, String, String)");
                        }
                        throw wIMException;
                    }
                }
                if ("Base64Binary".equals(string)) {
                    if (bl) {
                        NamingEnumeration<?> namingEnumeration = attribute.getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            Object e5 = namingEnumeration.nextElement();
                            if (e5 == null) continue;
                            dataObject.getList(property).add(e5);
                        }
                    } else {
                        Object object = attribute.get();
                        if (object != null) {
                            dataObject.set(property, object);
                        }
                    }
                } else if ("LangType".equals(string)) {
                    if (bl) {
                        NamingEnumeration<?> namingEnumeration = attribute.getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            Object e6 = namingEnumeration.nextElement();
                            if (e6 == null) continue;
                            DataObject dataObject2 = dataObject.createDataObject(property);
                            dataObject2.set("value", e6);
                        }
                    } else {
                        Object object = attribute.get();
                        if (object != null) {
                            DataObject dataObject3 = dataObject.createDataObject(property);
                            dataObject3.set("value", object);
                        }
                    }
                } else if (bl) {
                    NamingEnumeration<?> namingEnumeration = attribute.getAll();
                    while (namingEnumeration.hasMoreElements()) {
                        Object e7 = namingEnumeration.nextElement();
                        if (e7 == null) continue;
                        dataObject.getList(property).add(e7);
                    }
                } else {
                    Object object = attribute.get();
                    if (object != null) {
                        dataObject.set(property, object);
                    }
                }
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.WARNING, CLASSNAME, "setValue(DataObject, Object, String, String)");
            }
            catch (ClassCastException classCastException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "setValue(DataObject, Object, String, String)", classCastException.toString());
                }
                msgLogger.logp(Level.SEVERE, CLASSNAME, "setValue(DataObject, Object, String, String)", "INVALID_PROPERTY_DATA_TYPE", WIMMessageHelper.generateMsgParms(property.getName()));
            }
            catch (ArrayStoreException arrayStoreException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "setValue(DataObject, Object, String, String)", arrayStoreException.toString());
                }
                msgLogger.logp(Level.SEVERE, CLASSNAME, "setValue(DataObject, Object, String, String)", "INVALID_PROPERTY_DATA_TYPE", WIMMessageHelper.generateMsgParms(property.getName()));
            }
        }
    }

    private String getDN(String string, String string2, Attributes attributes2, boolean bl, boolean bl2) throws WIMException {
        String string3 = null;
        String string4 = this.iLdapConfigMgr.getLdapNode(string);
        if (string4 != null) {
            return string4;
        }
        string = this.iLdapConfigMgr.switchToLdapNode(string);
        if ((bl2 || this.iLdapConfigMgr.needTranslateRDN()) && this.iLdapConfigMgr.needTranslateRDN(string2)) {
            try {
                Object object;
                Object object2;
                if (string2 != null && (object2 = this.iLdapConfigMgr.getLdapEntity(string2)) != null && attributes2 != null) {
                    object = LdapHelper.getRDNAttributes(string);
                    String[][] stringArray = ((LdapEntity)object2).getWIMRDNProperties();
                    String[][] stringArray2 = ((LdapEntity)object2).getRDNAttributes();
                    Attribute[] attributeArray = new Attribute[stringArray.length];
                    String[] stringArray3 = new String[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray4 = stringArray[i];
                        boolean bl3 = true;
                        for (int j = 0; j < stringArray4.length; ++j) {
                            if (stringArray4[j].equalsIgnoreCase((String)object[j])) continue;
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        String[] stringArray5 = stringArray2[i];
                        for (int j = 0; j < stringArray5.length; ++j) {
                            attributeArray[j] = attributes2.get(stringArray5[j]);
                            if (attributeArray[j] == null && !bl) {
                                throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms(stringArray4[j]), CLASSNAME, "getDN");
                            }
                            stringArray3[j] = (String)attributeArray[j].get();
                        }
                        string3 = LdapHelper.replaceRDN(string, stringArray5, stringArray3);
                    }
                }
                if (string3 == null && bl) {
                    object2 = this.iLdapConn.getAttributesByUniqueName(string, new String[0], null);
                    object = object2.get("distinguishedName");
                    string3 = (String)object.get();
                }
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "getDN");
            }
        }
        if (string3 == null) {
            string3 = string;
        } else if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "getDN", "Translated DN: " + string3);
        }
        return string3;
    }

    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI dynamicUpdateConfig", WIMMessageHelper.generateMsgParms(string, WIMTraceHelper.printMapWithoutPassword(hashtable)));
        }
        if ("websphere.usermanager.serviceprovider.update.ldap.bindinfo".equalsIgnoreCase(string)) {
            this.iLdapConn.dynamicUpdateConfig(string, hashtable);
        } else if ("websphere.usermanager.serviceprovider.add.baseentry".equalsIgnoreCase(string)) {
            String string2 = (String)hashtable.get("DYNA_CONFIG_KEY_BASE_ENTRY");
            if ((string2 = UniqueNameHelper.getValidUniqueName(string2)) == null) {
                throw new DynamicUpdateConfigException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateNullMsgParms(), CLASSNAME, "dynamicUpdateConfig");
            }
            String string3 = (String)hashtable.get("DYNA_CONFIG_KEY_BASE_ENTRY_IN_REPOS");
            if (string3 != null) {
                if ((string3 = UniqueNameHelper.getValidUniqueName(string3)) == null) {
                    throw new DynamicUpdateConfigException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateNullMsgParms(), CLASSNAME, "dynamicUpdateConfig");
                }
            } else {
                string3 = string2;
            }
            try {
                this.iLdapConn.lookup(string3);
            }
            catch (NamingException namingException) {
                throw new DynamicUpdateConfigException("BASE_ENTRY_NOT_FOUND_IN_REPOSITORY", WIMMessageHelper.generateMsgParms(string2, this.iReposId), Level.SEVERE, CLASSNAME, "dynamicUpdateConfig");
            }
            this.iLdapConfigMgr.addBaseEntry(string2, string3);
        } else if ("websphere.usermanager.serviceprovider.add.entityconfig".equalsIgnoreCase(string)) {
            Map map = (Map)hashtable.get("DYNA_CONFIG_KEY_ENTITY_CONFIGS");
            if (map != null) {
                Set set = map.keySet();
                for (String string4 : set) {
                    if (!this.iReposId.equals(string4)) continue;
                    DataObject dataObject = (DataObject)map.get(string4);
                    this.iLdapConfigMgr.addLdapEntity(dataObject);
                }
            }
        } else if ("websphere.usermanager.serviceprovider.add.propertyconfig".equalsIgnoreCase(string)) {
            DataObject dataObject = (DataObject)hashtable.get("DYNA_CONFIG_KEY_PROP_CONFIG");
            this.iLdapConfigMgr.addAttribute(dataObject);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI dynamicUpdateConfig");
        }
    }

    private List getDynamicMembers(Attribute attribute) throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "getDynamicMembers", WIMMessageHelper.generateMsgParms(attribute));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (attribute != null) {
            try {
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    String string;
                    LdapURL ldapURL = new LdapURL((String)namingEnumeration.nextElement());
                    if (!ldapURL.parsedOK()) continue;
                    int n = 0;
                    String string2 = ldapURL.get_scope();
                    if (string2 != null) {
                        if (string2.compareToIgnoreCase("base") == 0) {
                            n = 0;
                        } else if (string2.compareToIgnoreCase("one") == 0) {
                            n = 1;
                        } else if (string2.compareToIgnoreCase("sub") == 0) {
                            n = 2;
                        }
                    }
                    if ((string = ldapURL.get_filter()) == null) {
                        string = "(objectClass=*)";
                    }
                    String string3 = ldapURL.get_dn();
                    String[] stringArray = ldapURL.get_attributes();
                    NamingEnumeration namingEnumeration2 = this.iLdapConn.search(string3, string, n, stringArray);
                    while (namingEnumeration2.hasMoreElements()) {
                        SearchResult searchResult = (SearchResult)namingEnumeration2.nextElement();
                        if (searchResult == null) continue;
                        String string4 = LdapHelper.prepareDN(searchResult.getName(), string3);
                        arrayList.add(string4);
                    }
                }
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getDynamicMembers");
            }
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "getDynamicMembers");
        }
        return arrayList;
    }
}

