/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.ldap;

import com.ibm.websphere.wim.ConfigConstants;
import com.ibm.websphere.wim.SchemaConstants;
import com.ibm.websphere.wim.exception.CertificateMapperException;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.InitializationException;
import com.ibm.websphere.wim.exception.InvalidInitPropertyException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.ldap.LdapAttribute;
import com.ibm.ws.wim.adapter.ldap.LdapConstants;
import com.ibm.ws.wim.adapter.ldap.LdapEntity;
import com.ibm.ws.wim.adapter.ldap.LdapHelper;
import com.ibm.ws.wim.util.NodeHelper;
import com.ibm.ws.wim.util.StringLengthComparator;
import com.ibm.ws.wim.util.UniqueNameHelper;
import commonj.sdo.DataObject;
import commonj.sdo.Type;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LdapConfigManager
implements ConfigConstants,
SchemaConstants,
LdapConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LdapConfigManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private ConfigManager iConfigMgr = null;
    private SchemaManager iSchemaMgr = null;
    private String iLdapType = null;
    private String[] iNodes = null;
    private String[] iNodesForCompare = null;
    private String[] iLdapNodes = null;
    private String[] iLdapNodesForCompare = null;
    private String[] iTopLdapNodes = null;
    private boolean iNeedSwitchNode = false;
    private boolean iNeedTranslateRDN = false;
    private List iLdapEntityTypeList = null;
    private LdapEntity[] iLdapEntities = null;
    private Set iAttrs = null;
    private Set iOperAttrs = null;
    private Set iDefaultValueAttrs = null;
    private Set iDefaultAttrAttrs = null;
    private Map iAttrNameToAttrMap = null;
    private Map iPropToAttrMap = null;
    private Map iAttrToPropMap = null;
    private Set iExtIds = null;
    private Set iConAttrs = null;
    private boolean isAnyExtIdDN = false;
    private String[] iMbrAttrs = null;
    private boolean iMbrAttrsAllScope = false;
    private boolean iMbrAttrsNestedScope = false;
    private short[] iMbrAttrScope = null;
    private Map iMbrAttrMap = null;
    private Map iDummyMbrMap = null;
    private boolean iUseDefaultMbrAttr = false;
    private String[] iDynaMbrAttrs = null;
    private Map iDynaMbrAttrMap = null;
    private List iDynaMbrObjectClass = new ArrayList();
    private String iDynaGrpFilter = null;
    private String iGrpMbrFilter = null;
    private String iMembershipAttrName = null;
    private short iMembershipAttrScope = 0;
    private List iLoginAttrs = null;
    private char[] iSpecialChars = new char[]{'(', ')', '\\'};
    private List iPersonAccountTypes = null;
    private List iPersonTypes = null;
    private List iGroupTypes = null;
    private String[] iGroupSearchBases = null;
    private boolean iUpdateGrpMbrship = false;
    private List iDataTypes = null;
    private List entityTypeProps = new ArrayList(3);
    public MessageFormat[] CONDITION_FORMATS = new MessageFormat[]{new MessageFormat("({0}={1})"), new MessageFormat("(!({0}={1}))"), new MessageFormat("(&({0}>={1})(!({0}={1})))"), new MessageFormat("(&({0}<={1})(!({0}={1})))"), new MessageFormat("({0}>={1})"), new MessageFormat("({0}<={1})")};
    private String iCertMapMode = null;
    private String[] iCertFilterEles = null;

    public LdapConfigManager() throws WIMException {
        this.iConfigMgr = ConfigManager.singleton();
        this.iSchemaMgr = SchemaManager.singleton();
    }

    public void initialize(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize(DataObject)");
        }
        this.iLdapType = dataObject.getString("ldapServerType");
        this.iLdapType = this.iLdapType == null ? "IDS52" : this.iLdapType.toUpperCase();
        this.setCertificateMapMode(dataObject.getString("certificateMapMode"));
        if ("filterDescriptorMode".equalsIgnoreCase(this.getCertificateMapMode())) {
            this.setCertificateFilter(dataObject.getString("certificateFilter"));
        }
        this.setNodes(dataObject.getList("baseEntries"));
        this.setLDAPEntities(dataObject.getList("ldapEntityTypes"));
        this.setGroupConfiguration(dataObject.getDataObject("groupConfiguration"));
        DataObject dataObject2 = dataObject.getDataObject("attributeConfiguration");
        this.setAttributes(dataObject2);
        this.setExtIdAttributes(dataObject2);
        this.setRDNProperties();
        this.setConfidentialAttributes();
        this.setGroupMemberFilter();
        this.setLoginProperties(dataObject.getList("loginProperties"));
        this.iNeedTranslateRDN = dataObject.getBoolean("translateRDN");
        this.entityTypeProps.add("parent");
        this.entityTypeProps.add("children");
        this.entityTypeProps.add("members");
        if (trcLogger.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LDAPServerType: ").append(this.iLdapType).append("\n");
            stringBuffer.append("Nodes: ").append(WIMTraceHelper.printObjectArray(this.iNodes)).append("\n");
            stringBuffer.append("ReposNodes: ").append(WIMTraceHelper.printObjectArray(this.iLdapNodes)).append("\n");
            stringBuffer.append("TopReposNodes: ").append(WIMTraceHelper.printObjectArray(this.iTopLdapNodes)).append("\n");
            stringBuffer.append("NeedSwitchNode: ").append(this.iNeedSwitchNode).append("\n");
            stringBuffer.append("LDAPEntities: ").append("\n");
            for (int i = 0; i < this.iLdapEntities.length; ++i) {
                stringBuffer.append(this.iLdapEntities[i].toString());
            }
            stringBuffer.append("GroupMemberAttrs: ").append(this.iMbrAttrMap).append("memberAttrs: ").append(WIMTraceHelper.printObjectArray(this.iMbrAttrs)).append("scopes: ").append(WIMTraceHelper.printShortArray(this.iMbrAttrScope)).append("\n");
            stringBuffer.append("GroupMemberFilter: ").append(this.iGrpMbrFilter).append("\n");
            stringBuffer.append("GroupDynaMemberAttrs: ").append(this.iDynaMbrAttrMap).append("\n");
            stringBuffer.append("DynaGroupFilter: ").append(this.iDynaGrpFilter).append("\n");
            stringBuffer.append("GroupMembershipAttrs: ").append(this.iMembershipAttrName).append(" scope: ").append(this.iMembershipAttrScope).append("\n");
            stringBuffer.append("PropToAttrMap: ").append(this.iPropToAttrMap).append("\n");
            stringBuffer.append("AttrToPropMap: ").append(this.iAttrToPropMap).append("\n");
            stringBuffer.append("ExtIds: ").append(this.iExtIds).append("\n");
            stringBuffer.append("AllAttrs: ").append(this.iAttrs).append("\n");
            stringBuffer.append("ConfidentialAttrs: ").append(this.iConAttrs).append("\n");
            stringBuffer.append("LoginAttrs: ").append(this.iLoginAttrs).append("\n");
            trcLogger.logp(Level.FINE, CLASSNAME, "initialize(DataObject)", stringBuffer.toString());
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize(DataObject)");
        }
    }

    public List getLoginAttributes() {
        return this.iLoginAttrs;
    }

    private void setLoginProperties(List list) {
        if (this.iPersonAccountTypes.size() > 0) {
            String string;
            int n;
            LdapEntity ldapEntity = this.getLdapEntity((String)this.iPersonAccountTypes.get(this.iPersonAccountTypes.size() - 1));
            this.iLoginAttrs = new ArrayList();
            for (n = 0; n < list.size(); ++n) {
                string = (String)list.get(n);
                this.iLoginAttrs.add(this.getAttributeName(ldapEntity, string));
            }
            if (this.iLoginAttrs.size() == 0) {
                String[][] stringArray = ldapEntity.getRDNAttributes();
                this.iLoginAttrs.add(stringArray[0][0]);
            }
            for (n = 0; n < this.iPersonAccountTypes.size(); ++n) {
                string = (String)this.iPersonAccountTypes.get(n);
                LdapEntity ldapEntity2 = this.getLdapEntity(string);
                String string2 = (String)this.iLoginAttrs.get(0);
                ldapEntity2.addPropertyAttributeMap("principalName", string2);
                ldapEntity2.addPropertyAttributeMap(string2, string2);
            }
        }
    }

    public String switchToNode(String string) {
        if (string == null || !this.iNeedSwitchNode) {
            return string;
        }
        String string2 = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        String string3 = null;
        int n = this.iLdapNodesForCompare.length;
        for (int i = 0; i < n; ++i) {
            int n2 = string2.indexOf(this.iLdapNodesForCompare[i]);
            if (n2 <= -1) continue;
            if (n2 == 0) {
                if (this.iLdapNodesForCompare[i].length() > 0) {
                    return this.iNodes[i];
                }
                string3 = this.iNodes[i];
                if (string3 != null && string3.length() != 0) {
                    stringBuffer.append(",");
                }
                bl = true;
                break;
            }
            stringBuffer = new StringBuffer(stringBuffer.substring(0, n2));
            string3 = this.iNodes[i];
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        if (string3 != null && string3.length() != 0) {
            stringBuffer.append(string3);
        } else if (string3 != null) {
            stringBuffer = new StringBuffer(stringBuffer.substring(0, stringBuffer.length() - 1));
        }
        return stringBuffer.toString();
    }

    public String switchToLdapNode(String string) {
        if (string == null || !this.iNeedSwitchNode) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = string.toLowerCase();
        String string3 = null;
        int n = this.iNodesForCompare.length;
        for (int i = 0; i < n; ++i) {
            int n2 = string2.lastIndexOf(this.iNodesForCompare[i]);
            if (n2 <= -1) continue;
            if (n2 == 0) {
                if (this.iNodesForCompare[i].length() > 0 && this.iNodesForCompare[i].length() == string.length()) {
                    return this.iLdapNodes[i];
                }
                if (this.iLdapNodes[i].length() > 0) {
                    string3 = "," + this.iLdapNodes[i];
                    continue;
                }
                string3 = this.iLdapNodes[i];
                continue;
            }
            if (string.length() - n2 != this.iNodesForCompare[i].length()) continue;
            string3 = this.iLdapNodes[i];
            if (string3 != null && string3.length() == 0 && stringBuffer.charAt(n2 - 1) == ',') {
                stringBuffer = new StringBuffer(stringBuffer.substring(0, n2 - 1));
                break;
            }
            stringBuffer = new StringBuffer(stringBuffer.substring(0, n2));
            break;
        }
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private String[] getRepositoryNodes() {
        return this.iLdapNodes;
    }

    private String[] getRepositoryNodesForCompare() {
        return this.iLdapNodesForCompare;
    }

    private String[] getNodes() {
        return this.iNodes;
    }

    private String[] getNodesForCompare() {
        return this.iNodesForCompare;
    }

    public String[] getTopLdapNodes() {
        return this.iTopLdapNodes;
    }

    public String getLdapNode(String string) {
        string = string.toLowerCase();
        for (int i = 0; i < this.iNodesForCompare.length; ++i) {
            if (!this.iNodesForCompare[i].equals(string)) continue;
            return this.iLdapNodes[i];
        }
        return null;
    }

    public String getNode(String string) {
        string = string.toLowerCase();
        for (int i = 0; i < this.iLdapNodesForCompare.length; ++i) {
            if (!this.iLdapNodesForCompare[i].equals(string)) continue;
            return this.iNodes[i];
        }
        return null;
    }

    public void addBaseEntry(String string, String string2) {
        if (string2 == null) {
            string2 = string;
        } else if (!this.iNeedSwitchNode && !string.equalsIgnoreCase(string2)) {
            this.iNeedSwitchNode = true;
        }
        String string3 = string.toLowerCase();
        HashMap<String, String> hashMap = new HashMap<String, String>(this.iNodesForCompare.length);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(this.iNodesForCompare.length);
        hashMap.put(string3, string);
        hashMap2.put(string3, string2);
        for (int i = 0; i < this.iNodesForCompare.length; ++i) {
            hashMap.put(this.iNodesForCompare[i], this.iNodes[i]);
            hashMap2.put(this.iNodesForCompare[i], this.iLdapNodes[i]);
        }
        String[] stringArray = new String[this.iNodesForCompare.length + 1];
        System.arraycopy(this.iNodesForCompare, 0, stringArray, 0, this.iNodesForCompare.length);
        stringArray[stringArray.length - 1] = string.toLowerCase();
        Arrays.sort(stringArray, new StringLengthComparator());
        String[] stringArray2 = new String[this.iNodesForCompare.length + 1];
        String[] stringArray3 = new String[this.iLdapNodes.length + 1];
        String[] stringArray4 = new String[this.iLdapNodesForCompare.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = (String)hashMap.get(stringArray[i]);
            stringArray3[i] = (String)hashMap2.get(stringArray[i]);
            stringArray4[i] = stringArray3[i].toLowerCase();
        }
        this.iNodes = stringArray2;
        this.iNodesForCompare = stringArray;
        this.iLdapNodes = stringArray3;
        this.iLdapNodesForCompare = stringArray4;
        this.iTopLdapNodes = NodeHelper.getTopNodes(stringArray4);
        if (trcLogger.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Nodes: ").append(WIMTraceHelper.printObjectArray(this.iNodes)).append("\n");
            stringBuffer.append("NodesForCompare: ").append(WIMTraceHelper.printObjectArray(this.iNodesForCompare)).append("\n");
            stringBuffer.append("ReposNodes: ").append(WIMTraceHelper.printObjectArray(this.iLdapNodes)).append("\n");
            stringBuffer.append("ReposNodesForCompare: ").append(WIMTraceHelper.printObjectArray(this.iLdapNodesForCompare)).append("\n");
            stringBuffer.append("TopReposNodes: ").append(WIMTraceHelper.printObjectArray(this.iTopLdapNodes)).append("\n");
            stringBuffer.append("NeedSwitchNode: ").append(this.iNeedSwitchNode).append("\n");
            trcLogger.logp(Level.FINE, CLASSNAME, "addBaseEntry", stringBuffer.toString());
        }
    }

    private void setNodes(List list) throws InvalidInitPropertyException {
        String string;
        String string2;
        String[] stringArray;
        int n;
        int n2 = list.size();
        HashMap<String, String> hashMap = new HashMap<String, String>(n2);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(n2);
        String[] stringArray2 = new String[n2];
        for (n = 0; n < list.size(); ++n) {
            stringArray = (String[])list.get(n);
            String string3 = UniqueNameHelper.getValidUniqueName(stringArray.getString("name"));
            if (string3 == null) {
                throw new InvalidInitPropertyException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateNullMsgParms(), CLASSNAME, "setNodes(List)");
            }
            string2 = stringArray.getString("nameInRepository");
            if (string2 == null) {
                string2 = string3;
            } else if ((string2 = LdapHelper.getValidDN(string2)) == null) {
                throw new InvalidInitPropertyException("INVALID_DN_SYNTAX", WIMMessageHelper.generateNullMsgParms(), CLASSNAME, "setNodes(List)");
            }
            if (!this.iNeedSwitchNode && !string3.equalsIgnoreCase(string2)) {
                this.iNeedSwitchNode = true;
            }
            stringArray2[n] = string2;
            string = string3.toLowerCase();
            hashMap.put(string, string3);
            hashMap2.put(string, string2);
        }
        n = hashMap.size();
        stringArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(stringArray, new StringLengthComparator());
        this.iNodes = new String[n];
        this.iNodesForCompare = new String[n];
        this.iLdapNodes = new String[n];
        this.iLdapNodesForCompare = new String[n];
        for (int i = 0; i < n; ++i) {
            string2 = stringArray[i];
            string = (String)hashMap.get(string2);
            String string4 = (String)hashMap2.get(string2);
            String string5 = string4.toLowerCase();
            this.iNodes[i] = string;
            this.iNodesForCompare[i] = string2;
            this.iLdapNodes[i] = string4;
            this.iLdapNodesForCompare[i] = string5;
        }
        this.iTopLdapNodes = NodeHelper.getTopNodes(stringArray2);
    }

    private void setDefaultLDAPEntries() throws WIMException {
        int n = 3;
        this.iLdapEntityTypeList = new ArrayList(n);
        this.iLdapEntities = new LdapEntity[n];
        this.iPersonAccountTypes = new ArrayList(n);
        this.iPersonTypes = new ArrayList(n);
        this.iGroupTypes = new ArrayList(n);
        ArrayList arrayList = new ArrayList();
        LdapEntity ldapEntity = new LdapEntity("PersonAccount");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.iLdapType.startsWith("AD")) {
            arrayList2.add("user");
        } else {
            arrayList2.add("inetOrgPerson");
        }
        ldapEntity.setObjectClasses(arrayList2);
        ldapEntity.setObjectClassesForCreate(arrayList2);
        if (this.iLdapType.startsWith("AD")) {
            ldapEntity.setSearchFilter("(ObjectCategory=Person)");
        } else {
            ldapEntity.setSearchFilter(null);
        }
        ldapEntity.setSearchBases(this.getTopLdapNodes());
        this.iLdapEntityTypeList.add("PersonAccount");
        this.iLdapEntities[0] = ldapEntity;
        this.iPersonAccountTypes.add("PersonAccount");
        ldapEntity = new LdapEntity("Group");
        arrayList2 = new ArrayList();
        if (this.iLdapType.startsWith("AD")) {
            arrayList2.add("group");
        } else {
            arrayList2.add("groupOfNames");
        }
        ldapEntity.setObjectClasses(arrayList2);
        ldapEntity.setObjectClassesForCreate(arrayList2);
        if (this.iLdapType.startsWith("AD")) {
            ldapEntity.setSearchFilter("(ObjectCategory=Group)");
        } else {
            ldapEntity.setSearchFilter(null);
        }
        this.iLdapEntityTypeList.add("Group");
        this.iLdapEntities[1] = ldapEntity;
        this.iGroupTypes.add("Group");
        ldapEntity.setSearchBases(this.getTopLdapNodes());
        arrayList.addAll(ldapEntity.getSearchBaseList());
        this.iGroupSearchBases = arrayList.toArray(new String[0]);
        this.iGroupSearchBases = NodeHelper.getTopNodes(this.iGroupSearchBases);
        ldapEntity = new LdapEntity("OrgContainer");
        String[][] stringArray = new String[][]{{"o"}, {"ou"}};
        String[] stringArray2 = new String[]{"organization", "organizationalUnit"};
        ldapEntity.setRDNAttributes(stringArray, stringArray2);
        arrayList2 = new ArrayList();
        arrayList2.add("organization");
        arrayList2.add("organizationalUnit");
        ldapEntity.setObjectClasses(arrayList2);
        ldapEntity.setObjectClassesForCreate(arrayList2);
        ldapEntity.setSearchFilter(null);
        this.iLdapEntityTypeList.add("OrgContainer");
        this.iLdapEntities[2] = ldapEntity;
        ldapEntity.setSearchBases(this.getTopLdapNodes());
    }

    public void addAttribute(DataObject dataObject) {
        String string = dataObject.getString("name");
        String string2 = string.toLowerCase();
        LdapAttribute ldapAttribute = (LdapAttribute)this.iAttrNameToAttrMap.get(string2);
        if (ldapAttribute == null) {
            ldapAttribute = new LdapAttribute(string);
            this.iAttrNameToAttrMap.put(string2, ldapAttribute);
        }
        ldapAttribute.setSyntax(dataObject.getString("syntax"));
        String string3 = dataObject.getString("propertyName");
        List list = dataObject.getList("entityTypes");
        if (list.size() == 0) {
            if (string3 != null) {
                this.iPropToAttrMap.put(string3, string);
                HashSet<String> hashSet = (HashSet<String>)this.iAttrToPropMap.get(string2);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    this.iAttrToPropMap.put(string2, hashSet);
                }
                hashSet.add(string3);
            }
            if (dataObject.isSet("defaultValue")) {
                this.iDefaultValueAttrs.add(string2);
                for (int i = 0; i < this.iLdapEntityTypeList.size(); ++i) {
                    ldapAttribute.setDefaultValue((String)this.iLdapEntityTypeList.get(i), dataObject.getString("defaultValue"));
                }
            }
            if (dataObject.isSet("defaultAttribute")) {
                this.iDefaultAttrAttrs.add(string2);
                for (int i = 0; i < this.iLdapEntityTypeList.size(); ++i) {
                    ldapAttribute.setDefaultAttribute((String)this.iLdapEntityTypeList.get(i), dataObject.getString("defaultAttribute"));
                }
            }
            for (int i = 0; i < this.iLdapEntities.length; ++i) {
                if (this.iLdapEntities[i].getProperty(string3) == null) continue;
                this.iLdapEntities[i].addPropertyAttributeMap(string3, string);
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                String string4 = (String)list.get(i);
                if (string3 != null) {
                    LdapEntity ldapEntity = this.getLdapEntity(string4);
                    ldapEntity.addPropertyAttributeMap(string3, string);
                }
                ldapAttribute.addEntityType(string4);
                if (dataObject.isSet("defaultValue")) {
                    this.iDefaultValueAttrs.add(string2);
                    ldapAttribute.setDefaultValue(string4, dataObject.getString("defaultValue"));
                }
                if (!dataObject.isSet("defaultAttribute")) continue;
                this.iDefaultAttrAttrs.add(string2);
                ldapAttribute.setDefaultAttribute(string4, dataObject.getString("defaultAttribute"));
            }
        }
    }

    public void addLdapEntity(DataObject dataObject) throws DynamicUpdateConfigException, WIMException {
        String[] stringArray;
        Object object;
        String string = dataObject.getString("name");
        if (this.getLdapEntity(string) != null) {
            throw new DynamicUpdateConfigException("DUPLICATE_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "addLdapEntity");
        }
        LdapEntity ldapEntity = new LdapEntity(dataObject);
        if (ldapEntity.getSearchBases() == null) {
            ldapEntity.setSearchBases(this.getTopLdapNodes());
        } else {
            object = ldapEntity.getSearchBases();
            stringArray = new String[((String[])object).length];
            for (int i = 0; i < ((String[])object).length; ++i) {
                stringArray[i] = this.switchToLdapNode((String)object[i]);
            }
            ldapEntity.setSearchBases(stringArray);
        }
        ldapEntity.setExtId((String)this.iExtIds.iterator().next());
        object = this.iConfigMgr.getRDNProperties(string);
        stringArray = new String[object.size()][];
        String[][] stringArray2 = new String[object.size()][];
        for (int i = 0; i < object.size(); ++i) {
            stringArray[i] = LdapHelper.getRDNs((String)object.get(i));
            stringArray2[i] = new String[((String)stringArray[i]).length];
            for (int j = 0; j < ((String)stringArray[i]).length; ++j) {
                String string2 = stringArray[i][j];
                stringArray2[i][j] = this.getAttributeName(ldapEntity, string2);
            }
        }
        ldapEntity.setRDNProperties((String[][])stringArray, stringArray2);
        if (this.iSchemaMgr.isSuperType("PersonAccount", string)) {
            this.iPersonAccountTypes.add(string);
        } else if (this.iSchemaMgr.isSuperType("Person", string)) {
            this.iPersonTypes.add(string);
        } else if (this.iSchemaMgr.isSuperType("Group", string)) {
            this.iGroupTypes.add(string);
            List list = ldapEntity.getSearchBaseList();
            String[] stringArray3 = new String[this.iGroupSearchBases.length + list.size()];
            System.arraycopy(this.iGroupSearchBases, 0, stringArray3, 0, this.iGroupSearchBases.length);
            for (int i = this.iGroupSearchBases.length + 1; i < stringArray3.length; ++i) {
                stringArray3[i] = (String)list.get(i);
            }
            this.iGroupSearchBases = NodeHelper.getTopNodes(stringArray3);
        }
        this.iLdapEntityTypeList.add(string);
        LdapEntity[] ldapEntityArray = new LdapEntity[this.iLdapEntities.length + 1];
        System.arraycopy(this.iLdapEntities, 0, ldapEntityArray, 0, this.iLdapEntities.length);
        ldapEntityArray[ldapEntityArray.length - 1] = ldapEntity;
        this.iLdapEntities = ldapEntityArray;
    }

    private void setLDAPEntities(List list) throws WIMException {
        int n = list.size();
        if (n > 0) {
            this.iLdapEntityTypeList = new ArrayList(n);
            this.iLdapEntities = new LdapEntity[n];
            this.iPersonAccountTypes = new ArrayList(n);
            this.iPersonTypes = new ArrayList(n);
            this.iGroupTypes = new ArrayList(n);
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < n; ++i) {
                DataObject dataObject = (DataObject)list.get(i);
                String string = dataObject.getString("name");
                if (this.getLdapEntity(string) != null) {
                    throw new InitializationException("DUPLICATE_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "setLDAPEntities");
                }
                LdapEntity ldapEntity = new LdapEntity(dataObject);
                if (ldapEntity.getSearchBases() == null) {
                    ldapEntity.setSearchBases(this.getTopLdapNodes());
                } else {
                    String[] stringArray = ldapEntity.getSearchBases();
                    String[] stringArray2 = new String[stringArray.length];
                    for (int j = 0; j < stringArray.length; ++j) {
                        stringArray2[j] = this.switchToLdapNode(stringArray[j]);
                    }
                    ldapEntity.setSearchBases(stringArray2);
                }
                this.iLdapEntityTypeList.add(string);
                this.iLdapEntities[i] = ldapEntity;
                if (this.iSchemaMgr.isSuperType("PersonAccount", string)) {
                    this.iPersonAccountTypes.add(string);
                    continue;
                }
                if (this.iSchemaMgr.isSuperType("Person", string)) {
                    this.iPersonTypes.add(string);
                    continue;
                }
                if (!this.iSchemaMgr.isSuperType("Group", string)) continue;
                this.iGroupTypes.add(string);
                arrayList.addAll(ldapEntity.getSearchBaseList());
            }
            this.iGroupSearchBases = arrayList.toArray(new String[0]);
            this.iGroupSearchBases = NodeHelper.getTopNodes(this.iGroupSearchBases);
        } else {
            this.setDefaultLDAPEntries();
        }
    }

    public List getPersonTypes() {
        return this.iPersonTypes;
    }

    public List getGroupTypes() {
        return this.iGroupTypes;
    }

    public List getPersonAccountTypes() {
        return this.iPersonAccountTypes;
    }

    private void setRDNProperties() {
        List list = this.iConfigMgr.getSupportedEntityTypes();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            LdapEntity ldapEntity = this.getLdapEntity(string);
            if (ldapEntity == null) continue;
            List list2 = this.iConfigMgr.getRDNProperties(string);
            String[][] stringArray = new String[list2.size()][];
            String[][] stringArray2 = new String[list2.size()][];
            for (int j = 0; j < list2.size(); ++j) {
                stringArray[j] = LdapHelper.getRDNs((String)list2.get(j));
                stringArray2[j] = new String[stringArray[j].length];
                for (int k = 0; k < stringArray[j].length; ++k) {
                    String string2 = stringArray[j][k];
                    stringArray2[j][k] = this.getAttributeName(ldapEntity, string2);
                }
            }
            ldapEntity.setRDNProperties(stringArray, stringArray2);
            if (!ldapEntity.needTranslateRDN()) continue;
            this.iNeedTranslateRDN = true;
        }
    }

    public LdapEntity[] getLdapEntities() {
        return this.iLdapEntities;
    }

    public String getLdapType() {
        return this.iLdapType;
    }

    public LdapEntity getLdapEntity(Type type) {
        return this.getLdapEntity(this.iSchemaMgr.getQualifiedTypeName(type.getURI(), type.getName()));
    }

    private void setExtIdAttributes(DataObject dataObject) {
        int n;
        Object object;
        this.iExtIds = new HashSet();
        if (dataObject != null) {
            object = dataObject.getList("externalIdAttributes");
            int n2 = object.size();
            for (n = 0; n < n2; ++n) {
                int n3;
                DataObject dataObject2 = (DataObject)object.get(n);
                String string = dataObject2.getString("name");
                LdapAttribute ldapAttribute = new LdapAttribute(string);
                ldapAttribute.setSyntax(dataObject2.getString("syntax"));
                ldapAttribute.setWIMGenerate(dataObject2.getBoolean("wimGenerate"));
                this.iAttrNameToAttrMap.put(string.toLowerCase(), ldapAttribute);
                List list = dataObject2.getList("entityTypes");
                if (list.size() == 0) {
                    for (n3 = 0; n3 < this.iLdapEntities.length; ++n3) {
                        this.iLdapEntities[n3].setExtId(string);
                    }
                } else {
                    for (n3 = 0; n3 < list.size(); ++n3) {
                        String string2 = (String)list.get(n3);
                        LdapEntity ldapEntity = this.getLdapEntity(string2);
                        ldapEntity.setExtId(string);
                    }
                }
                if (string.equalsIgnoreCase("DistinguishedName")) {
                    this.isAnyExtIdDN = true;
                }
                this.iExtIds.add(string.toLowerCase());
            }
        }
        object = null;
        String string = "string";
        if (this.iLdapType.startsWith("IDS") && !this.iLdapType.startsWith("IDS4")) {
            object = "ibm-entryuuid";
        } else if (this.iLdapType.startsWith("AD")) {
            object = "objectguid";
            string = "octetString";
        } else if (this.iLdapType.startsWith("SUNONE")) {
            object = "nsuniqueid";
        } else if (this.iLdapType.startsWith("NDS")) {
            object = "guid";
            string = "octetString";
        } else {
            object = "DistinguishedName";
        }
        n = 0;
        for (int i = 0; i < this.iLdapEntities.length; ++i) {
            if (this.iLdapEntities[i].getExtId() != null) continue;
            this.iLdapEntities[i].setExtId((String)object);
            n = 1;
        }
        if (n != 0) {
            if (!((String)object).equalsIgnoreCase("DistinguishedName")) {
                this.iExtIds.add(((String)object).toLowerCase());
                LdapAttribute ldapAttribute = new LdapAttribute((String)object);
                ldapAttribute.setSyntax(string);
                this.iAttrNameToAttrMap.put(((String)object).toLowerCase(), ldapAttribute);
            } else {
                this.isAnyExtIdDN = true;
            }
        }
    }

    public void resetDefaultDominoExtIdAttribute() {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "resetDefaultDominoExtIdAttribute()");
        }
        String string = "dominounid";
        for (int i = 0; i < this.iLdapEntities.length; ++i) {
            if (!this.iLdapEntities[i].getExtId().equalsIgnoreCase("DistinguishedName")) continue;
            this.iLdapEntities[i].setExtId(string);
        }
        this.iExtIds.add(string.toLowerCase());
        LdapAttribute ldapAttribute = new LdapAttribute(string);
        ldapAttribute.setSyntax("string");
        this.iAttrNameToAttrMap.put(string.toLowerCase(), ldapAttribute);
        this.isAnyExtIdDN = false;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "resetDefaultDominoExtIdAttribute()");
        }
    }

    public Set getAttributesWithDefaultValue() {
        return this.iDefaultValueAttrs;
    }

    public Set getAttributesWithDefaultAttribute() {
        return this.iDefaultAttrAttrs;
    }

    private void setCertificateMapMode(String string) {
        this.iCertMapMode = "filterDescriptorMode".equalsIgnoreCase(string) ? "filterDescriptorMode" : "exactDNMode";
    }

    private void setCertificateFilter(String string) throws CertificateMapperException {
        this.iCertFilterEles = LdapHelper.parseFilterDescriptor(string);
    }

    public String getCertificateLDAPFilter(X509Certificate x509Certificate) throws CertificateMapperException {
        if (this.iCertFilterEles == null) {
            throw new CertificateMapperException("INVALID_CERTIFICATE_FILTER", CLASSNAME, "getCertificateLDAPFilter");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.iCertFilterEles.length; ++i) {
            String string = this.iCertFilterEles[i];
            if (string.charAt(0) != '$') {
                stringBuffer.append(string);
                continue;
            }
            if (string.equals("${UniqueKey}")) {
                stringBuffer.append(LdapHelper.getUniqueKey(x509Certificate));
                continue;
            }
            if (string.equals("${PublicKey}")) {
                stringBuffer.append(x509Certificate.getPublicKey().getEncoded());
                continue;
            }
            if (string.equals("${BasicConstraints}")) continue;
            if (string.startsWith("${Issuer")) {
                stringBuffer.append(LdapHelper.getDNSubField(string.substring(8, string.length() - 1), x509Certificate.getIssuerDN().getName()));
                continue;
            }
            if (string.equals("${IssuerUniqueID}") || string.equals("${KeyUsage}")) continue;
            if (string.equals("${NotAfter}")) {
                stringBuffer.append(x509Certificate.getNotAfter().toString());
                continue;
            }
            if (string.equals("${NotBefore}")) {
                stringBuffer.append(x509Certificate.getNotBefore().toString());
                continue;
            }
            if (string.equals("${SerialNumber}")) {
                stringBuffer.append(x509Certificate.getSerialNumber());
                continue;
            }
            if (string.equals("${SigAlgName}")) {
                stringBuffer.append(x509Certificate.getSigAlgName());
                continue;
            }
            if (string.equals("${SigAlgOID}")) {
                stringBuffer.append(x509Certificate.getSigAlgOID());
                continue;
            }
            if (string.equals("${SigAlgParams}")) {
                stringBuffer.append(x509Certificate.getSigAlgParams());
                continue;
            }
            if (string.equals("${Signature}")) continue;
            if (string.startsWith("${Subject")) {
                stringBuffer.append(LdapHelper.getDNSubField(string.substring(9, string.length() - 1), x509Certificate.getSubjectDN().getName()));
                continue;
            }
            if (string.equals("${SubjectUniqueID}")) continue;
            if (string.equals("${TBSCertificate}")) {
                throw new CertificateMapperException("getTBSCertificate() is unsupported");
            }
            if (string.equals("${Version}")) {
                stringBuffer.append(x509Certificate.getVersion());
                continue;
            }
            throw new CertificateMapperException("unknown variable: " + string);
        }
        return stringBuffer.toString();
    }

    public String getCertificateMapMode() {
        return this.iCertMapMode;
    }

    private void setDefaultAttributes() {
        this.iDataTypes.add("String");
        this.iDataTypes.add("Base64Binary");
        if (this.iLdapType.equals("ADAM")) {
            LdapAttribute ldapAttribute = new LdapAttribute("unicodePwd");
            ldapAttribute.setSyntax("unicodePwd");
            this.iAttrNameToAttrMap.put("unicodePwd".toLowerCase(), ldapAttribute);
            this.iPropToAttrMap.put("password", "unicodePwd");
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("password");
            this.iAttrToPropMap.put("unicodePwd".toLowerCase(), hashSet);
            ldapAttribute = new LdapAttribute("groupType");
            this.iDefaultValueAttrs.add("groupType".toLowerCase());
            ldapAttribute.setDefaultValue("Group", "8");
            this.iAttrNameToAttrMap.put("groupType".toLowerCase(), ldapAttribute);
        } else if (this.iLdapType.startsWith("AD")) {
            LdapAttribute ldapAttribute = new LdapAttribute("samAccountName");
            LdapEntity ldapEntity = this.getLdapEntity("PersonAccount");
            ldapEntity.addPropertyAttributeMap("uid", "samAccountName");
            this.iDefaultAttrAttrs.add("samAccountName".toLowerCase());
            ldapAttribute.addEntityType("Group");
            ldapAttribute.setDefaultAttribute("Group", "cn");
            ldapAttribute = new LdapAttribute("unicodePwd");
            ldapAttribute.setSyntax("unicodePwd");
            this.iAttrNameToAttrMap.put("unicodePwd".toLowerCase(), ldapAttribute);
            this.iPropToAttrMap.put("password", "unicodePwd");
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("password");
            this.iAttrToPropMap.put("unicodePwd".toLowerCase(), hashSet);
            ldapAttribute = new LdapAttribute("userAccountControl");
            this.iDefaultValueAttrs.add("userAccountControl".toLowerCase());
            ldapAttribute.setDefaultValue("PersonAccount", "544");
            this.iAttrNameToAttrMap.put("userAccountControl".toLowerCase(), ldapAttribute);
            ldapAttribute = new LdapAttribute("groupType");
            this.iDefaultValueAttrs.add("groupType".toLowerCase());
            ldapAttribute.setDefaultValue("Group", "8");
            this.iAttrNameToAttrMap.put("groupType".toLowerCase(), ldapAttribute);
        } else {
            LdapAttribute ldapAttribute = new LdapAttribute("userPassword");
            this.iAttrNameToAttrMap.put("userPassword".toLowerCase(), ldapAttribute);
            this.iPropToAttrMap.put("password", "userPassword");
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("password");
            this.iAttrToPropMap.put("userPassword".toLowerCase(), hashSet);
        }
    }

    private void setAttributes(DataObject dataObject) {
        Object object;
        String string;
        DataObject dataObject2;
        int n;
        EList eList;
        Object object2;
        this.iAttrs = new HashSet();
        this.iOperAttrs = new HashSet();
        this.iAttrNameToAttrMap = new Hashtable();
        this.iPropToAttrMap = new Hashtable();
        this.iAttrToPropMap = new Hashtable();
        this.iDefaultValueAttrs = new HashSet();
        this.iDefaultAttrAttrs = new HashSet();
        this.iDataTypes = new ArrayList();
        HashSet<String> hashSet = new HashSet<String>();
        if (dataObject != null) {
            List list = dataObject.getList("attributes");
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                this.addAttribute(dataObject3);
            }
            object2 = dataObject.getList("propertiesNotSupported");
            int n3 = object2.size();
            eList = new HashMap();
            for (n = 0; n < n3; ++n) {
                dataObject2 = (DataObject)object2.get(n);
                string = dataObject2.getString("name");
                object = dataObject2.getList("entityTypes");
                if (object.size() == 0) {
                    hashSet.add(string);
                    if (string.equals("ibm-primaryEmail")) {
                        hashSet.add("ibmPrimaryEmail");
                        continue;
                    }
                    if (!string.equals("ibm-jobTitle")) continue;
                    hashSet.add("ibmJobTitle");
                    continue;
                }
                for (int i = 0; i < object.size(); ++i) {
                    String string2 = (String)object.get(i);
                    HashSet<String> hashSet2 = (HashSet<String>)eList.get(string2);
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<String>();
                        eList.put(string2, hashSet2);
                    }
                    hashSet2.add(string);
                    if (string.equals("ibm-primaryEmail")) {
                        hashSet2.add("ibmPrimaryEmail");
                        continue;
                    }
                    if (!string.equals("ibm-jobTitle")) continue;
                    hashSet2.add("ibmJobTitle");
                }
            }
        } else {
            this.setDefaultAttributes();
            hashSet.add("homeAddress");
            hashSet.add("businessAddress");
            if (this.iLdapType.startsWith("AD")) {
                hashSet.add("description");
                hashSet.add("jpegPhoto");
                hashSet.add("labeledURI");
                hashSet.add("carLicense");
                hashSet.add("pager");
                hashSet.add("roomNumber");
                hashSet.add("localityName");
                hashSet.add("stateOrProvinceName");
                hashSet.add("countryName");
                hashSet.add("employeeNumber");
                hashSet.add("employeeType");
                hashSet.add("businessCategory");
                hashSet.add("departmentNumber");
            }
        }
        this.iOperAttrs.add("createTimestamp");
        this.iOperAttrs.add("modifyTimestamp");
        for (int i = 0; i < this.iLdapEntities.length; ++i) {
            LdapEntity ldapEntity = this.iLdapEntities[i];
            object2 = ldapEntity.getName();
            EClass eClass = this.iSchemaMgr.getEClass((String)object2);
            if (eClass == null) continue;
            eList = eClass.getEAllStructuralFeatures();
            for (n = 0; n < eList.size(); ++n) {
                dataObject2 = (EStructuralFeature)eList.get(n);
                string = this.iSchemaMgr.getQualifiedPropertyName((EStructuralFeature)dataObject2);
                if (hashSet.contains(string)) continue;
                object = this.getAttributeName(ldapEntity, string);
                String string3 = dataObject2.getEType().getName();
                if (!this.iDataTypes.contains(string3)) {
                    this.iDataTypes.add(string3);
                }
                if (!this.iOperAttrs.contains(object)) {
                    this.iAttrs.add(object);
                }
                if (ldapEntity.getAttribute(string) != null) continue;
                ldapEntity.addPropertyAttributeMap(string, (String)object);
            }
        }
    }

    public List getDataTypes() {
        return this.iDataTypes;
    }

    public boolean isPersistentProperty(String string) {
        boolean bl = true;
        return !"identifier".equals(string) && !"partyRoles".equals(string) && !"parent".equals(string) && !"children".equals(string) && !"accounts".equals(string) && !"groups".equals(string) && !"entitlementInfo".equals(string) && !"groups".equals(string) && !"children".equals(string) && !"members".equals(string);
    }

    public String[] getAttributeNames(List list, List list2, boolean bl, boolean bl2) {
        Object object;
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<LdapEntity> arrayList = null;
        if (list != null && list.size() > 0) {
            arrayList = new ArrayList<LdapEntity>(list.size());
            for (n = 0; n < list.size(); ++n) {
                object = (String)list.get(n);
                LdapEntity ldapEntity = this.getLdapEntity((String)object);
                if (ldapEntity == null) continue;
                arrayList.add(ldapEntity);
            }
        }
        if (list2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                LdapEntity ldapEntity;
                int n2;
                object = (String)list2.get(n);
                if ("*".equals(object)) {
                    if (arrayList != null && arrayList.size() > 0) {
                        for (n2 = 0; n2 < arrayList.size(); ++n2) {
                            ldapEntity = (LdapEntity)arrayList.get(n2);
                            hashSet.addAll(ldapEntity.getAttributes());
                        }
                    } else {
                        hashSet.addAll(this.getAllSuppotedAttributes());
                    }
                    hashSet.removeAll(this.entityTypeProps);
                    continue;
                }
                if (arrayList != null && arrayList.size() > 0) {
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        ldapEntity = (LdapEntity)arrayList.get(n2);
                        hashSet.add(this.getAttributeName(ldapEntity, (String)object));
                    }
                    continue;
                }
                hashSet.addAll(this.getAttributeNames((String)object));
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            for (n = 0; n < arrayList.size(); ++n) {
                object = (LdapEntity)arrayList.get(n);
                if (!"distinguishedName".equalsIgnoreCase(((LdapEntity)object).getExtId())) {
                    hashSet.add(((LdapEntity)object).getExtId());
                }
                if (!this.needTranslateRDN() || !this.needTranslateRDN(((LdapEntity)object).getName())) continue;
                hashSet.addAll(((LdapEntity)object).getRDNAttributesList());
            }
        } else {
            if (this.needTranslateRDN()) {
                LdapEntity[] ldapEntityArray = this.getLdapEntities();
                for (int i = 0; i < ldapEntityArray.length; ++i) {
                    hashSet.addAll(ldapEntityArray[i].getRDNAttributesList());
                }
            }
            hashSet.addAll(this.getExtIds());
        }
        hashSet.add("objectClass");
        if (bl && this.getMembershipAttribute() != null) {
            hashSet.add(this.getMembershipAttribute());
        }
        if (bl2) {
            String[] stringArray = this.getMemberAttributes();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                hashSet.add(stringArray[i]);
            }
            if (this.supportDynamicGroup()) {
                String[] stringArray2 = this.getDynamicMemberAttributes();
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i] == null) continue;
                    hashSet.add(stringArray2[i]);
                }
            }
        }
        return hashSet.toArray(new String[0]);
    }

    public String getAttributeName(LdapEntity ldapEntity, String string) {
        String string2 = ldapEntity.getAttribute(string);
        if (string2 == null) {
            string2 = (String)this.iPropToAttrMap.get(string);
        }
        if (string2 == null) {
            int n = string.indexOf(":");
            if (n > -1) {
                return string.substring(n + 1);
            }
            return string;
        }
        return string2;
    }

    public Set getPropertyName(LdapEntity ldapEntity, String string) {
        Set<String> set = ldapEntity.getProperty(string);
        if (set == null) {
            set = (Set)this.iAttrToPropMap.get(string.toLowerCase());
        }
        if (set == null || set.size() == 0) {
            String string2;
            int n = string.indexOf(";");
            if (n > 0 && (set = ldapEntity.getProperty(string2 = string.substring(0, n))) == null) {
                set = (Set)this.iAttrToPropMap.get(string2.toLowerCase());
            }
            if (set == null || set.size() == 0) {
                set = new HashSet<String>();
                set.add(string);
            }
        }
        return set;
    }

    public Set getAttributeNames(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.iLdapEntities.length; ++i) {
            String string2 = this.iLdapEntities[i].getAttribute(string);
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        String string3 = (String)this.iPropToAttrMap.get(string);
        if (string3 != null) {
            hashSet.add(string3);
        }
        if (hashSet.size() == 0) {
            int n = string.indexOf(":");
            if (n > -1) {
                hashSet.add(string.substring(n + 1));
            } else {
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    public Set getAttributeNames(Set set, String string) {
        Set<String> set2 = new HashSet();
        if (set == null) {
            set2 = this.getAttributeNames(string);
        } else {
            for (String string2 : set) {
                String string3;
                LdapEntity ldapEntity = this.getLdapEntity(string2);
                if (ldapEntity == null || (string3 = this.getAttributeName(ldapEntity, string)) == null) continue;
                set2.add(string3);
            }
        }
        return set2;
    }

    public LdapEntity getLdapEntity(String string) {
        if (string != null) {
            for (int i = 0; i < this.iLdapEntityTypeList.size(); ++i) {
                String string2 = (String)this.iLdapEntityTypeList.get(i);
                if (string2 != null && string2.equals(string)) {
                    return this.iLdapEntities[i];
                }
                if (!this.iSchemaMgr.isSuperType(string, string2)) continue;
                return this.iLdapEntities[i];
            }
        }
        return null;
    }

    public LdapAttribute getAttribute(String string) {
        return (LdapAttribute)this.iAttrNameToAttrMap.get(string.toLowerCase());
    }

    public Map getAttributes() {
        return this.iAttrNameToAttrMap;
    }

    public LdapAttribute getLdapAttribute(String string) {
        return (LdapAttribute)this.iAttrNameToAttrMap.get(string.toLowerCase());
    }

    public String getSyntax(String string) {
        LdapAttribute ldapAttribute = (LdapAttribute)this.iAttrNameToAttrMap.get(string.toLowerCase());
        if (ldapAttribute != null) {
            return ldapAttribute.getSyntax();
        }
        return "string";
    }

    public Set getConfidentialAttributes() {
        return this.iConAttrs;
    }

    public boolean isAnyExtIdDN() {
        return this.isAnyExtIdDN;
    }

    public Set getAllSuppotedAttributes() {
        return this.iAttrs;
    }

    public Set getOpertionalAttributes() {
        return this.iOperAttrs;
    }

    private void setConfidentialAttributes() {
        this.iConAttrs = new HashSet();
        this.iConAttrs.add("unicodePwd");
        this.iConAttrs.add("userPassword");
    }

    private void setGroupConfiguration(DataObject dataObject) {
        this.setUpdateGroupMembership(dataObject);
        this.setMemberAttributes(dataObject);
        this.setMembershipAttribute(dataObject);
        this.setDynaMemberAttributes(dataObject);
    }

    private static short getMembershipScope(String string) {
        if (string != null) {
            if ("direct".equalsIgnoreCase(string = string.trim())) {
                return 0;
            }
            if ("nested".equalsIgnoreCase(string)) {
                return 1;
            }
            if ("all".equalsIgnoreCase(string)) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    private void setMembershipAttribute(DataObject dataObject) {
        DataObject dataObject2 = null;
        if (dataObject != null) {
            dataObject2 = dataObject.getDataObject("membershipAttribute");
        }
        if (dataObject2 == null) {
            if (this.iLdapType.startsWith("AD")) {
                this.iMembershipAttrName = "memberof";
                this.iMembershipAttrScope = 0;
            }
        } else {
            String string = dataObject2.getString("name");
            if (string.trim().length() == 0) {
                this.iMembershipAttrName = null;
            } else {
                this.iMembershipAttrName = string;
                String string2 = dataObject2.getString("scope");
                this.iMembershipAttrScope = string2 == null ? (short)0 : LdapHelper.getMembershipScope(string2);
            }
        }
    }

    private void setMemberAttributes(DataObject dataObject) {
        String string;
        int n;
        ArrayList<String> arrayList;
        Object object;
        int n2;
        List list = null;
        if (dataObject != null) {
            list = dataObject.getList("memberAttributes");
        }
        List list2 = this.getGroupTypes();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n2 = 0; n2 < list2.size(); ++n2) {
            object = this.getLdapEntity((String)list2.get(n2));
            arrayList = ((LdapEntity)object).getObjectClasses();
            for (n = 0; n < arrayList.size(); ++n) {
                string = (String)arrayList.get(n);
                arrayList2.add(string);
            }
        }
        this.iDummyMbrMap = new HashMap();
        if (list != null && list.size() > 0) {
            n2 = list.size();
            this.iMbrAttrMap = new HashMap(n2);
            object = new ArrayList(n2);
            arrayList = new ArrayList<String>(n2);
            for (n = 0; n < n2; ++n) {
                string = (DataObject)list.get(n);
                String string2 = string.getString("name");
                if (string2 == null || string2.trim().length() <= 0) continue;
                String string3 = string.getString("objectClass");
                String string4 = string.getString("scope");
                String string5 = string.getString("dummyMember");
                if (string4 == null) {
                    string4 = "direct";
                }
                if (string3 == null) {
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        this.iMbrAttrMap.put((String)arrayList2.get(i), string2);
                    }
                } else {
                    this.iMbrAttrMap.put(string3.toLowerCase(), string2);
                }
                if (string5 != null) {
                    if (string5.trim().length() == 0) {
                        this.iDummyMbrMap.remove(string2);
                    } else {
                        this.iDummyMbrMap.put(string2, string5);
                    }
                } else if (this.iLdapType.startsWith("IDS") || this.iLdapType.startsWith("DOMINO")) {
                    this.iDummyMbrMap.put(string2, "uid=dummy");
                }
                if (!arrayList.contains(string2)) {
                    arrayList.add(string2);
                    object.add(string4);
                }
                if (string3 == null || arrayList2.contains(string3.toLowerCase())) continue;
                this.getLdapEntity((String)this.getGroupTypes().get(0)).addObjectClass(string3);
            }
            this.iMbrAttrs = arrayList.toArray(new String[0]);
            this.iMbrAttrScope = new short[this.iMbrAttrs.length];
            this.iMbrAttrsAllScope = true;
            this.iMbrAttrsNestedScope = true;
            for (n = 0; n < object.size(); ++n) {
                this.iMbrAttrScope[n] = LdapHelper.getMembershipScope((String)object.get(n));
                if (this.iMbrAttrScope[n] == 0) {
                    this.iMbrAttrsAllScope = false;
                    this.iMbrAttrsNestedScope = false;
                    continue;
                }
                if (this.iMbrAttrScope[n] != 1) continue;
                this.iMbrAttrsAllScope = false;
            }
        } else {
            this.iMbrAttrMap = new HashMap(arrayList2.size());
            this.iMbrAttrScope = new short[arrayList2.size()];
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                this.iMbrAttrMap.put((String)arrayList2.get(n2), "member");
                this.iMbrAttrScope[n2] = 0;
            }
            this.iMbrAttrs = new String[1];
            this.iMbrAttrs[0] = "member";
            if (this.iLdapType.startsWith("IDS") || this.iLdapType.startsWith("DOMINO")) {
                this.iDummyMbrMap.put("member", "uid=dummy");
            }
            this.iUseDefaultMbrAttr = true;
        }
    }

    private void setDynaMemberAttributes(DataObject dataObject) {
        List list = null;
        if (dataObject != null) {
            list = dataObject.getList("dynamicMemberAttributes");
        }
        LdapEntity ldapEntity = this.getLdapEntity("Group");
        if (list != null && list.size() > 0) {
            Object object;
            LdapEntity ldapEntity2;
            int n;
            int n2 = list.size();
            this.iDynaMbrAttrMap = new HashMap(n2);
            ArrayList<Object> arrayList = new ArrayList<Object>(n2);
            List list2 = this.getGroupTypes();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (n = 0; n < list2.size(); ++n) {
                ldapEntity2 = this.getLdapEntity((String)list2.get(n));
                object = ldapEntity2.getObjectClasses();
                for (int i = 0; i < object.size(); ++i) {
                    String string = (String)object.get(i);
                    arrayList2.add(string);
                }
            }
            for (n = 0; n < n2; ++n) {
                ldapEntity2 = (DataObject)list.get(n);
                object = ldapEntity2.getString("name");
                if (object == null || ((String)object).trim().length() <= 0) continue;
                String string = ldapEntity2.getString("objectClass");
                if (string == null) {
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        this.iDynaMbrAttrMap.put((String)arrayList2.get(i), object);
                        this.iDynaMbrObjectClass.add(arrayList2.get(i));
                    }
                } else {
                    this.iDynaMbrAttrMap.put(string.toLowerCase(), object);
                    this.iDynaMbrObjectClass.add(string);
                }
                if (!arrayList.contains(object)) {
                    arrayList.add(object);
                }
                if (string == null || ldapEntity.getObjectClasses().contains(string.toLowerCase())) continue;
                ldapEntity.addObjectClass(string);
            }
            this.iDynaMbrAttrs = arrayList.toArray(new String[0]);
            this.setDynamicGroupFilter();
        }
    }

    public String getMembershipAttribute() {
        return this.iMembershipAttrName;
    }

    public short getMembershipAttributeScope() {
        return this.iMembershipAttrScope;
    }

    public boolean supportDynamicGroup() {
        return this.iDynaMbrAttrs != null;
    }

    public String[] getMemberAttributes() {
        return this.iMbrAttrs;
    }

    public String[] getDynamicMemberAttributes() {
        return this.iDynaMbrAttrs;
    }

    public short[] getMemberAttributesScope() {
        return this.iMbrAttrScope;
    }

    public String getDynamicGroupFilter() {
        return this.iDynaGrpFilter;
    }

    public String getDynamicMemberAttribute(Attribute attribute) throws WIMSystemException {
        if (this.iDynaMbrAttrs == null) {
            return null;
        }
        if (attribute != null) {
            try {
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)namingEnumeration.nextElement();
                    if (string2 == null || (string = (String)this.iDynaMbrAttrMap.get(string2.toLowerCase())) == null) continue;
                    return string;
                }
            }
            catch (NamingException namingException) {
                trcLogger.logp(Level.SEVERE, CLASSNAME, "getDynamicMemberAttribute", namingException.toString(true));
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "getDynamicMemberAttribute");
            }
        }
        return null;
    }

    public String getMemberAttribute(Attribute attribute) throws WIMSystemException {
        if (this.iMbrAttrs.length == 1) {
            return this.iMbrAttrs[0];
        }
        if (attribute != null) {
            try {
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)namingEnumeration.nextElement();
                    if (string2 == null || (string = (String)this.iMbrAttrMap.get(string2.toLowerCase())) == null) continue;
                    return string;
                }
            }
            catch (NamingException namingException) {
                trcLogger.logp(Level.SEVERE, CLASSNAME, "getMemberAttribute(Attribute)", namingException.toString(true));
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "getMemberAttribute(Attribute)");
            }
        }
        return this.iMbrAttrs[0];
    }

    public String[] getLdapNodes() {
        return this.iLdapNodes;
    }

    public String getExtId(String string) {
        LdapEntity ldapEntity = this.getLdapEntity(string);
        if (ldapEntity != null) {
            return ldapEntity.getExtId();
        }
        if (this.iExtIds.size() == 1) {
            return (String)this.iExtIds.iterator().next();
        }
        return "distinguishedName";
    }

    public String getExtIdFromAttributes(String string, String string2, Attributes attributes2) throws WIMSystemException {
        String string3 = this.getExtId(string2);
        if ("distinguishedName".equalsIgnoreCase(string3)) {
            return LdapHelper.toUpperCase(string);
        }
        Attribute attribute = null;
        attribute = attributes2.get(string3);
        if (attribute == null) {
            throw new WIMSystemException("EXT_ID_VALUE_IS_NULL", WIMMessageHelper.generateMsgParms(string3, string), CLASSNAME, "getExtId(String DN, javax.naming.directory.Attributes attributes)");
        }
        if (attribute.size() > 1) {
            throw new WIMSystemException("EXT_ID_HAS_MULTIPLE_VALUES", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "getExtId(String DN, javax.naming.directory.Attributes attributes)");
        }
        LdapAttribute ldapAttribute = this.getAttribute(string3);
        try {
            Object object = attribute.get();
            if (ldapAttribute != null && "octetString".equalsIgnoreCase(ldapAttribute.getSyntax())) {
                return LdapHelper.getOctetString((byte[])object);
            }
            return object.toString();
        }
        catch (NamingException namingException) {
            trcLogger.logp(Level.SEVERE, CLASSNAME, "getExtId(String DN, javax.naming.directory.Attributes attributes)", namingException.toString(true));
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "getExtId(String DN, javax.naming.directory.Attributes attributes)");
        }
    }

    public Set getExtIds() {
        return this.iExtIds;
    }

    public String getLdapRDNFilter(LdapEntity ldapEntity, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '+' || cArray[n - 1] == '\\') continue;
            arrayList.add(string.substring(n2, n));
            n2 = n + 1;
        }
        arrayList.add(string.substring(n2));
        for (n = 0; n < arrayList.size(); ++n) {
            Object object;
            String string2 = (String)arrayList.get(n);
            int n3 = string2.indexOf(61);
            if (n3 <= 0) continue;
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1);
            if (ldapEntity != null) {
                object = this.getAttributeName(ldapEntity, string3);
                stringBuffer.append("(").append((String)object).append("=").append(string4).append(")");
                continue;
            }
            object = this.getAttributeNames(string3);
            if (object.size() > 1) {
                stringBuffer.append("(|");
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                stringBuffer.append("(").append(string5).append("=").append(string4).append(")");
            }
            if (object.size() <= 1) continue;
            stringBuffer.append(")");
        }
        if (arrayList.size() > 1) {
            stringBuffer.insert(0, "(&").append(")");
        }
        return stringBuffer.toString();
    }

    public boolean retrieveMemberAttribute(int n) {
        if (n == 1) {
            return false;
        }
        return this.iMbrAttrScope.length != 1 || this.iMbrAttrScope[0] != 2 && this.iMbrAttrScope[0] != 1;
    }

    public String getEntityType(Attributes attributes2, String string, String string2, String string3, List list) throws WIMSystemException {
        String string4 = "Entity";
        Attribute attribute = attributes2.get("objectClass");
        if (attribute != null) {
            int n;
            int n2 = this.iLdapEntities.length;
            ArrayList<String> arrayList = new ArrayList<String>(n2);
            block0: for (n = 0; n < n2; ++n) {
                LdapEntity ldapEntity = this.iLdapEntities[n2 - (n + 1)];
                List list2 = ldapEntity.getObjectClasses();
                for (int i = 0; i < list2.size(); ++i) {
                    String string5 = (String)list2.get(i);
                    if (!LdapHelper.containIngorecaseValue(attribute, string5)) continue;
                    String string6 = ldapEntity.getName();
                    if (list != null && list.size() > 0) {
                        for (int j = 0; j < list.size(); ++j) {
                            String string7 = (String)list.get(j);
                            if (!this.iSchemaMgr.isSuperType(string7, string6)) continue;
                            arrayList.add(string6);
                        }
                        continue block0;
                    }
                    arrayList.add(ldapEntity.getName());
                    continue block0;
                }
            }
            n = arrayList.size();
            if (n == 1) {
                string4 = (String)arrayList.get(0);
            } else if (n > 1) {
                string4 = (String)arrayList.get(0);
            }
        } else {
            string4 = (String)list.get(0);
        }
        return string4;
    }

    public boolean needTranslateRDN() {
        return this.iNeedTranslateRDN;
    }

    public boolean needTranslateRDN(String string) {
        LdapEntity ldapEntity;
        if (string != null && (ldapEntity = this.getLdapEntity(string)) != null) {
            return ldapEntity.needTranslateRDN();
        }
        return this.iNeedTranslateRDN;
    }

    public String getDummyMember(String string) {
        return (String)this.iDummyMbrMap.get(string);
    }

    public boolean isDummyMember(String string) {
        return this.iDummyMbrMap.containsValue(string);
    }

    private void setSpecialCharactors(char[] cArray) {
        this.iSpecialChars = cArray;
    }

    public char[] getSepcialCharactors() {
        return this.iSpecialChars;
    }

    public String escapeSpecialCharacters(String string) {
        int n;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        char[] cArray2 = this.getSepcialCharactors();
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < cArray2.length; ++n) {
                if (cArray[i] != cArray2[n] || (i <= 0 || cArray[i - 1] == '\\') && i != 0) continue;
                stringBuffer.append("\\");
            }
            stringBuffer.append(cArray[i]);
        }
        n = 0;
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            if ((n = stringBuffer.indexOf("\\*", n)) < 0) {
                n3 = stringBuffer.length();
                continue;
            }
            stringBuffer.deleteCharAt(n);
            n3 = n;
        }
        return stringBuffer.toString();
    }

    private void setGroupMemberFilter() {
        LdapEntity ldapEntity = this.getLdapEntity("Group");
        String string = ldapEntity.getSearchFilter();
        StringBuffer stringBuffer = new StringBuffer("(&");
        stringBuffer.append(string);
        if (this.iMbrAttrs.length == 1) {
            stringBuffer.append("(").append(this.iMbrAttrs[0]).append("={0}))");
        } else {
            stringBuffer.append("(|");
            for (int i = 0; i < this.iMbrAttrs.length; ++i) {
                stringBuffer.append("(").append(this.iMbrAttrs[i]).append("={0})");
            }
            stringBuffer.append("))");
        }
        this.iGrpMbrFilter = stringBuffer.toString();
    }

    private void setDynamicGroupFilter() {
        int n;
        LdapEntity ldapEntity = this.getLdapEntity("Group");
        String string = ldapEntity.getSearchFilter();
        StringBuffer stringBuffer = new StringBuffer("(&");
        if (this.iDynaMbrObjectClass != null && this.iDynaMbrObjectClass.size() > 0) {
            if (this.iDynaMbrObjectClass.size() == 1) {
                stringBuffer.append("(|(objectclass=").append(this.iDynaMbrObjectClass.get(0)).append(")");
                stringBuffer.append(string);
                stringBuffer.append(")");
            } else {
                stringBuffer.append("(|");
                for (n = 0; n < this.iDynaMbrObjectClass.size(); ++n) {
                    stringBuffer.append("(objectclass=").append(this.iDynaMbrObjectClass.get(n)).append(")");
                }
                stringBuffer.append(string);
                stringBuffer.append(")");
            }
        } else {
            stringBuffer.append(string);
        }
        if (this.iDynaMbrAttrs.length == 1) {
            stringBuffer.append("(").append(this.iDynaMbrAttrs[0]).append("=*))");
        } else {
            stringBuffer.append("(|");
            for (n = 0; n < this.iDynaMbrAttrs.length; ++n) {
                stringBuffer.append("(").append(this.iDynaMbrAttrs[n]).append("=*)");
            }
            stringBuffer.append("))");
        }
        this.iDynaGrpFilter = stringBuffer.toString();
    }

    public String getGroupMemberFilter() {
        return this.iGrpMbrFilter;
    }

    public String getGroupMemberFilter(String string) {
        string = this.escapeSpecialCharacters(string);
        Object[] objectArray = new Object[]{string};
        return new MessageFormat(this.iGrpMbrFilter).format(objectArray);
    }

    public Attribute getGroupMemberAttrs(Attributes attributes2, Attribute attribute) throws WIMException {
        Attribute attribute2 = null;
        String string = null;
        if (attribute != null) {
            string = this.getMemberAttribute(attribute);
            attribute2 = attributes2.remove(string);
        } else {
            String[] stringArray = this.getMemberAttributes();
            for (int i = 0; i < stringArray.length && (attribute2 = attributes2.remove(stringArray[i])) == null; ++i) {
            }
        }
        return attribute2;
    }

    public String getEntityTypesFilter(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        if (set.size() > 1) {
            stringBuffer.append("(|");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            LdapEntity ldapEntity = this.getLdapEntity((String)iterator.next());
            if (ldapEntity == null) continue;
            stringBuffer.append(ldapEntity.getSearchFilter());
        }
        if (set.size() > 1) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public List getLdapSubEntityTypes(String string) {
        ArrayList arrayList = new ArrayList(this.iSchemaMgr.getSubEntityTypes(string));
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (this.getLdapEntity(string2) != null) continue;
            arrayList2.add(string2);
        }
        arrayList.removeAll(arrayList2);
        return arrayList;
    }

    public Object getLdapValue(Object object, String string, String string2) throws WIMSystemException {
        Object object2;
        LdapAttribute ldapAttribute = this.getLdapAttribute(string2);
        if ("String".equals(string)) {
            object2 = LdapHelper.getStringLdapValue(object, ldapAttribute, this.getLdapType());
        } else if ("DateTime".equals(string)) {
            object2 = LdapHelper.getDateLdapValue(object, ldapAttribute, this.getLdapType());
        } else if ("Int".equals(string)) {
            object2 = LdapHelper.getIntLdapValue(object, ldapAttribute, this.getLdapType());
        } else if ("LangType".equals(string)) {
            if (object instanceof DataObject) {
                DataObject dataObject = (DataObject)object;
                object2 = dataObject.getString("value");
            } else {
                object2 = object.toString();
            }
        } else {
            object2 = object;
        }
        return object2;
    }

    private void setUpdateGroupMembership(DataObject dataObject) {
        if (dataObject != null && dataObject.isSet("updateGroupMembership")) {
            this.iUpdateGrpMbrship = dataObject.getBoolean("updateGroupMembership");
        } else if (this.getLdapType().startsWith("DOMINO") || this.getLdapType().startsWith("SUNONE")) {
            this.iUpdateGrpMbrship = true;
        }
    }

    public boolean updateGroupMembership() {
        return this.iUpdateGrpMbrship;
    }

    public boolean isMemberAttributesAllScope() {
        return this.iMbrAttrsAllScope;
    }

    public boolean isMemberAttributesNestedScope() {
        return this.iMbrAttrsNestedScope;
    }

    public boolean isPerson(String string) {
        return this.iPersonTypes.contains(string);
    }

    public boolean isPersonAccount(String string) {
        return this.iPersonAccountTypes.contains(string);
    }

    public boolean isGroup(String string) {
        return this.iGroupTypes.contains(string);
    }

    public boolean containGroup(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                if (!this.isGroup(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getGroupSearchBases() {
        return this.iGroupSearchBases;
    }

    public List getSupportedEntitTypes() {
        return this.iLdapEntityTypeList;
    }

    public short getOperator(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals("=")) {
            return 0;
        }
        if (string.equals("!=")) {
            return 1;
        }
        if (string.equals(">")) {
            return 2;
        }
        if (string.equals("<")) {
            return 3;
        }
        if (string.equals(">=")) {
            return 4;
        }
        if (string.equals("<=")) {
            return 5;
        }
        return -1;
    }

    public boolean isActiveDirectory() {
        return this.iLdapType.startsWith("AD");
    }

    public boolean isDefaultMbrAttr() {
        String string = "isDefaultMbrAttr";
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, string, "use default member attribute: " + this.iUseDefaultMbrAttr);
        }
        return this.iUseDefaultMbrAttr;
    }
}

