/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.ldap;

import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.wim.ConfigConstants;
import com.ibm.websphere.wim.DynamicConfigService;
import com.ibm.websphere.wim.SchemaConstants;
import com.ibm.websphere.wim.exception.DynamicUpdateConfigException;
import com.ibm.websphere.wim.exception.EntityAlreadyExistsException;
import com.ibm.websphere.wim.exception.EntityHasDescendantsException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InvalidInitPropertyException;
import com.ibm.websphere.wim.exception.MissingInitPropertyException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.ws.security.util.WSEncoderDecoder;
import com.ibm.ws.wim.adapter.ldap.CachedNamingEnumeration;
import com.ibm.ws.wim.adapter.ldap.LdapAttribute;
import com.ibm.ws.wim.adapter.ldap.LdapConfigManager;
import com.ibm.ws.wim.adapter.ldap.LdapConnectionBase;
import com.ibm.ws.wim.adapter.ldap.LdapConstants;
import com.ibm.ws.wim.adapter.ldap.LdapEntity;
import com.ibm.ws.wim.adapter.ldap.LdapEntry;
import com.ibm.ws.wim.adapter.ldap.LdapHelper;
import com.ibm.ws.wim.adapter.ldap.LdapURL;
import com.ibm.ws.wim.adapter.ldap.PagedResultsControl;
import com.ibm.ws.wim.adapter.ldap.TimedDirContext;
import com.ibm.ws.wim.util.CommonUtil;
import com.ibm.ws.wim.util.NodeHelper;
import com.sun.jndi.ldap.LdapName;
import commonj.sdo.DataObject;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;

public class LdapConnection
extends LdapConnectionBase
implements DynamicConfigService,
ConfigConstants,
SchemaConstants,
LdapConstants {
    public static final String WIM_SSL_SOCKE_FACTORY = "com.ibm.ws.security.registry.ldap.LdapSSLSocketFactory";
    public static final String JNDI_CALL = "JNDI_CALL ";
    public static final String WAS_SSL_SOCKE_FACTORY = "com.ibm.websphere.ssl.protocol.SSLSocketFactory";
    private static final String CLASSNAME = LdapConnection.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private LdapConfigManager iLdapConfigMgr = null;
    private String iReposId = null;
    private static final int URLTYPE_SINGLE = 0;
    private static final int URLTYPE_SEQUENCE = 1;
    private static final String ENVKEY_URL_LIST = "_URL_LIST_";
    private static final String ENVKEY_ACTIVE_URL = "_ACTIVE_URL_";
    private Hashtable iEnvironment = null;
    private String iSSLAlias = null;
    private boolean iEnableContextPool = true;
    private int iInitPoolSize = 1;
    private int iMaxPoolSize = 1;
    private int iPrefPoolSize = 1;
    private int iPoolTimeOut = 0;
    private int iPoolWaitTime = 3000;
    private List iContexts = null;
    private long iPoolCreateTimestamp = 0L;
    private long iPoolCreateTimestampMillisec = 0L;
    private int iLiveContexts = 0;
    private static Object lock = new Object();
    private Control[] iConnCtls = null;
    private int iTimeLimit = 0;
    private int iCountLimit = 0;
    private int iPageSize = 0;
    private NameParser iNameParser = null;
    private boolean iDiskOffLoad = false;
    private String iAttrsCacheName = "AttributesCache";
    private DistributedMap iAttrsCache = null;
    private int iAttrsCacheSize = 4000;
    private int iAttrsCacheTimeOut = 1200;
    private int iAttrsSizeLmit = 2000;
    private String iServerTTLAttr = null;
    private int iAttrsCacheDistPolicy = 2;
    private String iSearchResultsCacheName = "SearchResultsCache";
    private DistributedMap iSearchResultsCache = null;
    private int iSearchResultsCacheSize = 2000;
    private int iSearchResultsCacheTimeOut = 600;
    private int iSearchResultSizeLmit = 2000;
    private int iSearchResultsCacheDistPolicy = 2;
    private Map iEnityAttrIds = null;
    private String[] iAttrIds = null;
    private boolean iAttrsCacheEnabled = true;
    private boolean iSearchResultsCacheEnabled = true;
    private int iAttrRangeStep = 0;
    private static final String ATTR_RANGE_KEYWORD = ";range=";
    private static final String ATTR_RANGE_QUERY = ";range={0}-{1}";
    private static final String ATTR_RANGE_LAST_QUERY = ";range={0}-*";
    private boolean iWriteToSecondary = false;
    private boolean iReturnToPrimary = false;
    private long iQueryInterval = 900L;
    private long iLastQueryTime = System.currentTimeMillis() / 1000L;

    public LdapConnection(LdapConfigManager ldapConfigManager) {
        this.iLdapConfigMgr = ldapConfigManager;
    }

    public void initializeRetrieveAttrIds() {
        HashSet<String> hashSet;
        this.iEnityAttrIds = new Hashtable();
        LdapEntity[] ldapEntityArray = this.iLdapConfigMgr.getLdapEntities();
        HashSet<String> hashSet2 = new HashSet<String>();
        String[] stringArray = new String[]{};
        for (int i = 0; i < ldapEntityArray.length; ++i) {
            String string;
            hashSet = ldapEntityArray[i].getAttributes();
            hashSet.add("objectClass");
            String string2 = ldapEntityArray[i].getExtId();
            if (!"distinguishedName".equalsIgnoreCase(string2)) {
                hashSet.add(string2);
            }
            hashSet.remove("userPassword");
            hashSet.remove("unicodePwd");
            if (this.iServerTTLAttr != null) {
                hashSet.add(this.iServerTTLAttr);
            }
            if ((string = this.iLdapConfigMgr.getMembershipAttribute()) != null) {
                hashSet.add(string);
            }
            this.iEnityAttrIds.put(ldapEntityArray[i].getName(), hashSet.toArray(stringArray));
            hashSet2.addAll(hashSet);
        }
        hashSet2.add("objectClass");
        String[] stringArray2 = this.iLdapConfigMgr.getMemberAttributes();
        hashSet = new HashSet<String>(hashSet2);
        for (int i = 0; i < stringArray2.length; ++i) {
            hashSet.add(stringArray2[i]);
        }
        this.iAttrIds = hashSet2.toArray(stringArray);
    }

    public void invalidateAttributes(String string, String string2, String string3) {
        if (this.getAttributesCache() != null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "invalidateAttributes(String, String, String)", WIMMessageHelper.generateMsgParms(string, string2, string3));
            }
            if (string != null) {
                this.getAttributesCache().invalidate(LdapConnection.toKey(string));
            }
            if (string2 != null) {
                this.getAttributesCache().invalidate(string2);
            }
            if (string3 != null) {
                this.getAttributesCache().invalidate(LdapConnection.toKey(string3));
            }
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.exiting(CLASSNAME, "invalidateAttributes(String, String, String)", this.iAttrsCacheName + " size: " + this.getAttributesCache().size());
            }
        }
    }

    public void invalidateUserSecurityName(String string) {
        if (this.getAttributesCache() != null) {
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.entering(CLASSNAME, "invalidateAttributes(String userSecurityName)", WIMMessageHelper.generateMsgParms(string));
            }
            if (string != null) {
                String[] stringArray = this.iLdapConfigMgr.getLdapNodes();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    String string3 = LdapConnection.toKey(string, string2);
                    this.getAttributesCache().invalidate(string3);
                }
            }
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.exiting(CLASSNAME, "invalidateAttributes(String userSecurityName)", this.iAttrsCacheName + " size: " + this.getAttributesCache().size());
            }
        }
    }

    public void invalidateNamesCache() {
        if (this.getSearchResultsCache() != null) {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "invalidateNamesCache()");
            }
            this.getSearchResultsCache().clear();
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.exiting(CLASSNAME, "invalidateNamesCache()");
            }
        }
    }

    private DistributedMap getAttributesCache() {
        if (this.iAttrsCache == null) {
            this.createAttributesCache();
        }
        return this.iAttrsCache;
    }

    private void createAttributesCache() {
        if (this.iAttrsCacheEnabled) {
            if (CommonUtil.isDistributedCacheAvailable()) {
                this.iAttrsCache = CommonUtil.initDistributedCache(this.iAttrsCacheName, this.iAttrsCacheSize, this.iDiskOffLoad, this.iAttrsCacheDistPolicy);
                if (this.iAttrsCache != null && trcLogger.isLoggable(Level.CONFIG)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\nAttributes Cache: ").append(this.iAttrsCacheName).append(" is enabled:\n");
                    stringBuffer.append("\tCacheSize: ").append(this.iAttrsCacheSize).append("\n");
                    stringBuffer.append("\tCacheTimeOut: ").append(this.iAttrsCacheTimeOut).append("\n");
                    stringBuffer.append("\tDiskOffLoad: ").append(this.iDiskOffLoad).append("\n");
                    stringBuffer.append("\tCacheDistPolicy: ").append(this.iAttrsCacheDistPolicy);
                    trcLogger.logp(Level.CONFIG, CLASSNAME, "createAttributesCache", stringBuffer.toString());
                }
            } else {
                this.iAttrsCacheEnabled = false;
                if (trcLogger.isLoggable(Level.CONFIG)) {
                    trcLogger.logp(Level.CONFIG, CLASSNAME, "createAttributesCache", "Attributes Cache: " + this.iAttrsCacheName + " is disabled because there is no DynaCache environment.");
                }
            }
        }
    }

    private DistributedMap getSearchResultsCache() {
        if (this.iSearchResultsCache == null) {
            this.createSearchResultsCache();
        }
        return this.iSearchResultsCache;
    }

    private void createSearchResultsCache() {
        if (this.iSearchResultsCacheEnabled) {
            if (CommonUtil.isDistributedCacheAvailable()) {
                this.iSearchResultsCache = CommonUtil.initDistributedCache(this.iSearchResultsCacheName, this.iSearchResultsCacheSize, this.iDiskOffLoad, this.iSearchResultsCacheDistPolicy);
                if (this.iSearchResultsCache != null && trcLogger.isLoggable(Level.CONFIG)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\nSearch Results Cache: ").append(this.iSearchResultsCacheName).append(" is enabled:\n");
                    stringBuffer.append("\tCacheSize: ").append(this.iSearchResultsCacheSize).append("\n");
                    stringBuffer.append("\tCacheTimeOut: ").append(this.iSearchResultsCacheTimeOut).append("\n");
                    stringBuffer.append("\tDiskOffLoad: ").append(this.iDiskOffLoad).append("\n");
                    stringBuffer.append("\tCacheDistPolicy: ").append(this.iSearchResultsCacheDistPolicy);
                    trcLogger.logp(Level.CONFIG, CLASSNAME, "createSearchResultsCache", stringBuffer.toString());
                }
            } else {
                this.iSearchResultsCacheEnabled = false;
                if (trcLogger.isLoggable(Level.CONFIG)) {
                    trcLogger.logp(Level.CONFIG, CLASSNAME, "createSearchResultsCache", "Search Results Cache: " + this.iSearchResultsCacheName + " is disabled because there is no DynaCache environment.");
                }
            }
        }
    }

    private void initializeCaches(DataObject dataObject) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initializeCaches(DataObject)");
        }
        if (dataObject != null) {
            Object object;
            this.iDiskOffLoad = dataObject.getBoolean("cachesDiskOffLoad");
            DataObject dataObject2 = dataObject.getDataObject("attributesCache");
            if (dataObject2 != null) {
                this.iAttrsCacheEnabled = dataObject2.getBoolean("enabled");
                if (this.iAttrsCacheEnabled) {
                    this.iAttrsCacheSize = dataObject2.getInt("cacheSize");
                    this.iAttrsCacheTimeOut = dataObject2.getInt("cacheTimeOut");
                    this.iAttrsSizeLmit = dataObject2.getInt("attributeSizeLimit");
                    this.iServerTTLAttr = dataObject2.getString("serverTTLAttribute");
                    object = dataObject2.getString("cacheDistPolicy");
                    if (object != null) {
                        this.iAttrsCacheDistPolicy = LdapHelper.getCacheDistPolicyInt((String)object);
                    }
                    this.initializeRetrieveAttrIds();
                }
            }
            if ((object = dataObject.getDataObject("searchResultsCache")) != null) {
                this.iSearchResultsCacheEnabled = object.getBoolean("enabled");
                if (this.iSearchResultsCacheEnabled) {
                    this.iSearchResultsCacheSize = object.getInt("cacheSize");
                    this.iSearchResultsCacheTimeOut = object.getInt("cacheTimeOut");
                    this.iSearchResultSizeLmit = object.getInt("searchResultSizeLimit");
                    String string = object.getString("cacheDistPolicy");
                    if (string != null) {
                        this.iSearchResultsCacheDistPolicy = LdapHelper.getCacheDistPolicyInt(string);
                    }
                }
            }
        }
        if (this.iAttrsCacheEnabled) {
            this.createAttributesCache();
            if (this.iAttrsCache == null && trcLogger.isLoggable(Level.CONFIG)) {
                trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeCaches(DataObject)", "Attributes Cache: " + this.iAttrsCacheName + " is not available because DynaCache is not available yet.");
            }
        } else if (trcLogger.isLoggable(Level.CONFIG)) {
            trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeCaches(DataObject)", "Attributes Cache: " + this.iAttrsCacheName + " is disabled.");
        }
        if (this.iSearchResultsCacheEnabled) {
            this.createSearchResultsCache();
            if (this.iSearchResultsCache == null && trcLogger.isLoggable(Level.CONFIG)) {
                trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeCaches(DataObject)", "Search Results Cache: " + this.iSearchResultsCacheName + " is not available because DynaCache is not available yet.");
            }
        } else if (trcLogger.isLoggable(Level.CONFIG)) {
            trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeCaches(DataObject)", "Search Results Cache: " + this.iSearchResultsCacheName + " is disabled.");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initializeCaches(DataObject)");
        }
    }

    private void initializeContextPool(DataObject dataObject) throws WIMException {
        this.iEnableContextPool = true;
        if (dataObject != null) {
            this.iEnableContextPool = dataObject.getBoolean("enabled");
        }
        if (this.iEnableContextPool) {
            if (dataObject != null) {
                if (dataObject.isSet("initPoolSize")) {
                    this.iInitPoolSize = dataObject.getInt("initPoolSize");
                }
                if (dataObject.isSet("maxPoolSize")) {
                    this.iMaxPoolSize = dataObject.getInt("maxPoolSize");
                }
                if (dataObject.isSet("prefPoolSize")) {
                    this.iPrefPoolSize = dataObject.getInt("prefPoolSize");
                }
                if (this.iMaxPoolSize != 0 && this.iMaxPoolSize < this.iInitPoolSize) {
                    throw new InvalidInitPropertyException("INIT_POOL_SIZE_TOO_BIG", WIMMessageHelper.generateMsgParms(new Integer(this.iInitPoolSize), new Integer(this.iMaxPoolSize)), CLASSNAME, "initializeContextPool(DataObject)");
                }
                if (this.iMaxPoolSize != 0 && this.iPrefPoolSize != 0 && this.iMaxPoolSize < this.iPrefPoolSize) {
                    throw new InvalidInitPropertyException("PREF_POOL_SIZE_TOO_BIG", WIMMessageHelper.generateMsgParms(new Integer(this.iInitPoolSize), new Integer(this.iMaxPoolSize)), CLASSNAME, "initializeContextPool(DataObject)");
                }
                if (dataObject.isSet("poolTimeOut")) {
                    this.iPoolTimeOut = dataObject.getInt("poolTimeOut");
                }
                if (dataObject.isSet("poolWaitTime")) {
                    this.iPoolWaitTime = dataObject.getInt("poolWaitTime");
                }
            }
            if (trcLogger.isLoggable(Level.CONFIG)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\nContext Pool is enabled: ").append("\n");
                stringBuffer.append("\tInitPoolSize: ").append(this.iInitPoolSize).append("\n");
                stringBuffer.append("\tMaxPoolSize: ").append(this.iMaxPoolSize).append("\n");
                stringBuffer.append("\tPrefPoolSize: ").append(this.iPrefPoolSize).append("\n");
                stringBuffer.append("\tPoolTimeOut: ").append(this.iPoolTimeOut).append("\n");
                stringBuffer.append("\tPoolWaitTime: ").append(this.iPoolWaitTime);
                trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeContextPool(DataObject)", stringBuffer.toString());
            }
        } else {
            trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeContextPool(DataObject)", "\nContext Pool is disabled.");
        }
    }

    private void createContextPool(int n, String string) throws NamingException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "createContextPool", WIMMessageHelper.generateMsgParms(new Integer(n), string));
        }
        if (string == null) {
            string = this.getPrimaryURL();
        }
        if (this.iEnableContextPool) {
            long l = System.currentTimeMillis();
            long l2 = l / 1000L;
            if (l - this.iPoolCreateTimestampMillisec > 1000L) {
                Vector<DirContext> vector = new Vector<DirContext>(n);
                Hashtable hashtable = this.getEnvironment(1, string);
                String string2 = null;
                for (int i = 0; i < n; ++i) {
                    DirContext dirContext = this.createDirContext(hashtable, l2);
                    string2 = this.getProviderURL(dirContext);
                    if (!string.equalsIgnoreCase(string2)) {
                        hashtable = this.getEnvironment(1, string2);
                        string = string2;
                    }
                    vector.add(dirContext);
                    ++this.iLiveContexts;
                }
                this.setActiveURL(string);
                List list = this.iContexts;
                this.iContexts = vector;
                this.iPoolCreateTimestamp = l2;
                this.iPoolCreateTimestampMillisec = l;
                this.closeContextPool(list);
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "createContextPool", "Active Provider URL: " + this.getActiveURL());
                    trcLogger.logp(Level.FINEST, CLASSNAME, "createContextPool", "ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size());
                }
            } else {
                trcLogger.logp(Level.FINEST, CLASSNAME, "createContextPool", "Pool has already been purged within past second... skipping purge");
            }
        } else {
            this.setActiveURL(string);
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "createContextPool");
        }
    }

    private void closeContextPool(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                DirContext dirContext = (DirContext)list.get(i);
                try {
                    dirContext.close();
                    --this.iLiveContexts;
                    continue;
                }
                catch (NamingException namingException) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "closeContextPool", "Can not close LDAP connection: " + namingException.toString(true));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext createDirContext(String string, byte[] byArray) throws NamingException {
        String string2 = this.getActiveURL();
        Hashtable hashtable = this.getEnvironment(0, string2);
        hashtable.put("java.naming.security.principal", string);
        hashtable.put("java.naming.security.credentials", byArray);
        Properties properties = JSSEHelper.getInstance().getSSLPropertiesOnThread();
        try {
            if (this.iSSLAlias != null) {
                try {
                    trcLogger.logp(Level.FINE, CLASSNAME, "createDirContext(String, byte[])", "Use WAS SSL Configuration.");
                    LdapConnection.setWASSSLAlias(this.iSSLAlias, hashtable);
                }
                catch (Exception exception) {
                    throw new NamingException(exception.getMessage());
                }
            }
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.entering(CLASSNAME, "JNDI_CALL createDirContext(String, byte[])", hashtable.get("java.naming.provider.url"));
            }
            TimedDirContext timedDirContext = null;
            try {
                timedDirContext = new TimedDirContext(hashtable, this.getConnectionRequsetControls());
            }
            catch (NamingException namingException) {
                if (!this.isConnectionException(namingException, "createDirContext(String, byte[])")) {
                    throw namingException;
                }
                hashtable = this.getEnvironment(1, this.getNextURL(string2));
                timedDirContext = new TimedDirContext(hashtable, this.getConnectionRequsetControls());
                String string3 = this.getProviderURL(timedDirContext);
                long l = System.currentTimeMillis();
                Object object = lock;
                synchronized (object) {
                    if (l > this.iPoolCreateTimestampMillisec) {
                        this.createContextPool(this.iLiveContexts, string3);
                        timedDirContext.setCreateTimestamp(this.iPoolCreateTimestamp);
                    }
                }
            }
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.exiting(CLASSNAME, "JNDI_CALL createDirContext(String, byte[])", this.getProviderURL(timedDirContext));
            }
            TimedDirContext timedDirContext2 = timedDirContext;
            return timedDirContext2;
        }
        finally {
            JSSEHelper.getInstance().setSSLPropertiesOnThread(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext reCreateDirContext(DirContext dirContext, String string) throws WIMSystemException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "DirContext reCreateDirContext(String errorMessage)", "Communication exception occurs: " + string + " Creating a new connection.");
        }
        try {
            String string2 = this.getProviderURL(dirContext);
            DirContext dirContext2 = this.createDirContext(this.getEnvironment(1, this.getNextURL(string2)));
            String string3 = this.getProviderURL(dirContext2);
            Object object = lock;
            synchronized (object) {
                if (((TimedDirContext)dirContext).getCreateTimestamp() >= this.iPoolCreateTimestamp) {
                    this.createContextPool(this.iLiveContexts - 1, string3);
                    ((TimedDirContext)dirContext2).setCreateTimestamp(this.iPoolCreateTimestamp);
                }
            }
            dirContext.close();
            return dirContext2;
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "DirContext reCreateDirContext(String errorMessage)");
        }
    }

    public DirContext createDirContext(Hashtable hashtable) throws NamingException {
        return this.createDirContext(hashtable, System.currentTimeMillis() / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext createDirContext(Hashtable hashtable, long l) throws NamingException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "JNDI_CALL createDirContext(Hashtable, long)", WIMMessageHelper.generateMsgParms(hashtable.get("java.naming.provider.url"), hashtable.get("java.naming.security.principal")));
        }
        Properties properties = JSSEHelper.getInstance().getSSLPropertiesOnThread();
        try {
            if (this.iSSLAlias != null) {
                try {
                    LdapConnection.setWASSSLAlias(this.iSSLAlias, hashtable);
                }
                catch (Exception exception) {
                    throw new NamingException(exception.getMessage());
                }
            }
            TimedDirContext timedDirContext = new TimedDirContext(hashtable, this.getConnectionRequsetControls(), l);
            String string = this.getProviderURL(timedDirContext);
            if (!this.iEnableContextPool && !string.equalsIgnoreCase(this.getActiveURL())) {
                this.setActiveURL(string);
            }
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.exiting(CLASSNAME, "JNDI_CALL createDirContext(Hashtable, long)", string);
            }
            TimedDirContext timedDirContext2 = timedDirContext;
            return timedDirContext2;
        }
        finally {
            JSSEHelper.getInstance().setSSLPropertiesOnThread(properties);
        }
    }

    private void checkWritePermission(DirContext dirContext) throws OperationNotSupportedException {
        if (!this.iWriteToSecondary) {
            String string = this.getProviderURL(dirContext);
            if (!this.getPrimaryURL().equalsIgnoreCase(string)) {
                throw new OperationNotSupportedException("WRITE_TO_SECONDARY_SERVERS_NOT_ALLOWED", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "checkWritePermission");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String string) throws NamingException, WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "Object lookup(String name)", WIMMessageHelper.generateMsgParms(string));
        }
        DirContext dirContext = this.getDirContext();
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (CommunicationException communicationException) {
            dirContext = this.reCreateDirContext(dirContext, communicationException.toString());
            object = dirContext.lookup(string);
        }
        finally {
            this.releaseDirContext(dirContext);
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "Object lookup(String name)", WIMMessageHelper.generateMsgParms(object));
        }
        return object;
    }

    private boolean isConnectionException(NamingException namingException, String string) {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, string, "Exception caught:", namingException);
        }
        if (namingException instanceof CommunicationException) {
            return true;
        }
        return namingException instanceof ServiceUnavailableException;
    }

    public DirContext createSubcontext(String string, Attributes attributes2) throws WIMException {
        DirContext dirContext = null;
        DirContext dirContext2 = this.getDirContext();
        this.checkWritePermission(dirContext2);
        try {
            try {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.entering(CLASSNAME, "JNDI_CALL createSubcontext", WIMMessageHelper.generateMsgParms(string, this.printAttributes(attributes2)));
                }
                dirContext = dirContext2.createSubcontext(new LdapName(string), attributes2);
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.exiting(CLASSNAME, "JNDI_CALL createSubcontext");
                }
            }
            catch (NamingException namingException) {
                if (!this.isConnectionException(namingException, "createSubcontext")) {
                    throw namingException;
                }
                dirContext2 = this.reCreateDirContext(dirContext2, namingException.toString());
                dirContext = dirContext2.createSubcontext(new LdapName(string), attributes2);
            }
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "createSubcontext");
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new EntityNotFoundException("PARENT_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, nameNotFoundException.toString(true)), CLASSNAME, "createSubcontext");
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "createSubcontext");
        }
        finally {
            this.releaseDirContext(dirContext2);
        }
        return dirContext;
    }

    public void destroySubcontext(String string) throws WIMException {
        DirContext dirContext = this.getDirContext();
        this.checkWritePermission(dirContext);
        try {
            try {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.entering(CLASSNAME, "JNDI_CALL destroySubcontext", WIMMessageHelper.generateMsgParms(string));
                }
                dirContext.destroySubcontext(new LdapName(string));
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.exiting(CLASSNAME, "JNDI_CALL destroySubcontext");
                }
            }
            catch (NamingException namingException) {
                if (!this.isConnectionException(namingException, "destroySubcontext")) {
                    throw namingException;
                }
                dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                dirContext.destroySubcontext(new LdapName(string));
            }
        }
        catch (ContextNotEmptyException contextNotEmptyException) {
            throw new EntityHasDescendantsException("ENTITY_HAS_DESCENDENTS", WIMMessageHelper.generateMsgParms(string), Level.WARNING, CLASSNAME, "destroySubcontext");
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, nameNotFoundException.toString(true)), CLASSNAME, "destroySubcontext");
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "destroySubcontext");
        }
        finally {
            this.releaseDirContext(dirContext);
        }
    }

    private String[] addTTLAttribute(String[] stringArray) {
        if (this.iServerTTLAttr != null && stringArray != null) {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = this.iServerTTLAttr;
            return stringArray2;
        }
        return stringArray;
    }

    private int getTTLAttributeValue(Attributes attributes2) throws WIMSystemException {
        if (this.iServerTTLAttr == null || attributes2 == null) {
            return -1;
        }
        Attribute attribute = attributes2.get(this.iServerTTLAttr);
        if (attribute != null) {
            try {
                return Integer.parseInt((String)attribute.get());
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getTTLAttributeValue(Attributes");
            }
        }
        return -1;
    }

    private int getAttributesEntryTimeOut(Attributes attributes2) throws WIMSystemException {
        int n = this.getTTLAttributeValue(attributes2);
        if (n >= 0) {
            return n;
        }
        return this.iAttrsCacheTimeOut;
    }

    private int getNamesEntryTimeOut(Attributes attributes2) throws WIMSystemException {
        int n = this.getTTLAttributeValue(attributes2);
        if (n >= 0) {
            return n;
        }
        return this.iSearchResultsCacheTimeOut;
    }

    public Attributes getAttributes(String string, String[] stringArray) throws WIMException {
        Attributes attributes2 = null;
        if (this.iAttrRangeStep > 0) {
            attributes2 = this.getRangeAttributes(string, stringArray);
        } else {
            DirContext dirContext = this.getDirContext();
            try {
                try {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.entering(CLASSNAME, "JNDI_CALL getAttributes", WIMMessageHelper.generateMsgParms(string, WIMTraceHelper.printObjectArray(stringArray)));
                    }
                    attributes2 = dirContext.getAttributes(new LdapName(string), stringArray);
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.exiting(CLASSNAME, "JNDI_CALL getAttributes", attributes2.toString());
                    }
                }
                catch (NamingException namingException) {
                    if (!this.isConnectionException(namingException, "getAttributes")) {
                        throw namingException;
                    }
                    dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                    attributes2 = dirContext.getAttributes(new LdapName(string), stringArray);
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.exiting(CLASSNAME, "JNDI_CALL getAttributes", attributes2.toString());
                    }
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, nameNotFoundException.toString(true)), CLASSNAME, "getAttributes");
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getAttributes");
            }
            finally {
                this.releaseDirContext(dirContext);
            }
        }
        return attributes2;
    }

    private Attributes getRangeAttributes(String string, String[] stringArray) throws WIMException {
        Attributes attributes2 = null;
        DirContext dirContext = this.getDirContext();
        try {
            try {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.entering(CLASSNAME, "JNDI_CALL getAttributes(String, String[])", WIMMessageHelper.generateMsgParms(string, WIMTraceHelper.printObjectArray(stringArray)));
                }
                attributes2 = dirContext.getAttributes(new LdapName(string), stringArray);
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.exiting(CLASSNAME, "JNDI_CALL getAttributes(String, String[])", attributes2.toString());
                }
            }
            catch (NamingException namingException) {
                if (!this.isConnectionException(namingException, "getRangeAttributes")) {
                    throw namingException;
                }
                dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                attributes2 = dirContext.getAttributes(new LdapName(string), stringArray);
            }
            this.supportRangeAttributes(attributes2, string, dirContext);
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, nameNotFoundException.toString(true)), CLASSNAME, "getRangeAttributes");
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getRangeAttributes");
        }
        finally {
            this.releaseDirContext(dirContext);
        }
        return attributes2;
    }

    private boolean cacheAttributes(String[] stringArray, Attributes attributes2) throws WIMException {
        if (this.iAttrsSizeLmit == 0) {
            return true;
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)namingEnumeration.nextElement();
            if (attribute == null) continue;
            String string = attribute.getID();
            int n = attribute.size();
            if (n <= this.iAttrsSizeLmit) continue;
            return false;
        }
        return true;
    }

    private boolean cacheAttributes(Attributes attributes2) throws WIMException {
        if (this.iAttrsSizeLmit == 0) {
            return true;
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)namingEnumeration.nextElement();
            if (attribute == null) continue;
            String string = attribute.getID();
            int n = attribute.size();
            if (n <= this.iAttrsSizeLmit) continue;
            return false;
        }
        return true;
    }

    private String[] getRetrieveAttributes(String string, boolean bl) {
        String[] stringArray = null;
        stringArray = string != null ? (String[])this.iEnityAttrIds.get(string) : this.iAttrIds;
        if (bl) {
            String[] stringArray2 = this.iLdapConfigMgr.getMemberAttributes();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray2.length, stringArray2.length);
            return stringArray3;
        }
        return stringArray;
    }

    private void updateAttributesCache(String string, Attributes attributes2, Attributes attributes3) {
        if (attributes2.size() > 0) {
            attributes3 = attributes3 != null ? (Attributes)attributes3.clone() : new BasicAttributes(true);
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
            while (namingEnumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)namingEnumeration.nextElement();
                if (this.iAttrsSizeLmit > 0 && attribute.size() > this.iAttrsSizeLmit) continue;
                attributes3.put(attribute);
            }
            this.getAttributesCache().put(string, attributes3, 1, this.iAttrsCacheTimeOut, this.iAttrsCacheDistPolicy, null);
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "updateAttributeCache(key,missAttrs,cachedAttrs)", "Update " + this.iAttrsCacheName + "(size: " + this.getAttributesCache().size() + ")\n" + string + ": " + attributes3);
            }
        }
    }

    private void updateAttributesCache(String string, String string2, Attributes attributes2) {
        this.getAttributesCache().put(string, string2, 1, this.iAttrsCacheTimeOut, this.iAttrsCacheDistPolicy, null);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "updateAttributesCache(key,dn,newAttrs)", "Update " + this.iAttrsCacheName + "(size: " + this.getAttributesCache().size() + ")\n" + string + ": " + string2);
        }
        String string3 = LdapConnection.toKey(string2);
        Object object = this.getAttributesCache().get(string3);
        Attributes attributes3 = null;
        if (object != null && object instanceof Attributes) {
            attributes3 = (Attributes)object;
        }
        this.updateAttributesCache(string3, attributes2, attributes3);
    }

    private void addAttributes(Attributes attributes2, Attributes attributes3) {
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
        while (namingEnumeration.hasMoreElements()) {
            attributes3.put((Attribute)namingEnumeration.nextElement());
        }
    }

    public Attributes checkAttributesCache(String string, String[] stringArray) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "checkAttributesCache", WIMMessageHelper.generateMsgParms(string, WIMTraceHelper.printObjectArray(stringArray)));
        }
        Attributes attributes2 = null;
        if (this.getAttributesCache() != null) {
            String string2 = LdapConnection.toKey(string);
            Object object = this.getAttributesCache().get(string2);
            if (object != null && object instanceof Attributes) {
                Cloneable cloneable;
                ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                Attributes attributes3 = (Attributes)object;
                attributes2 = new BasicAttributes(true);
                for (int i = 0; i < stringArray.length; ++i) {
                    cloneable = LdapHelper.getIngoreCaseAttribute(attributes3, stringArray[i]);
                    if (cloneable != null) {
                        attributes2.put((Attribute)cloneable);
                        continue;
                    }
                    arrayList.add(stringArray[i]);
                }
                if (arrayList.size() > 0) {
                    Object[] objectArray = arrayList.toArray(new String[0]);
                    if (trcLogger.isLoggable(Level.FINEST)) {
                        trcLogger.logp(Level.FINEST, CLASSNAME, "checkAttributesCache", "Miss cache: " + string2 + " " + WIMTraceHelper.printObjectArray(objectArray));
                    }
                    cloneable = this.getAttributes(string, (String[])objectArray);
                    this.addAttributes((Attributes)cloneable, attributes2);
                    this.updateAttributesCache(string2, (Attributes)cloneable, attributes3);
                } else if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "checkAttributesCache", "Hit cache: " + string2);
                }
            } else {
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "checkAttributesCache", "Miss cache: " + string2);
                }
                attributes2 = this.getAttributes(string, stringArray);
                this.updateAttributesCache(string2, attributes2, null);
            }
        } else {
            attributes2 = this.getAttributes(string, stringArray);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "checkAttributesCache", attributes2.toString());
        }
        return attributes2;
    }

    public Name getCompoundName(String string) throws WIMException {
        try {
            return this.getNameParser().parse(string);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getCompoundName(String)");
        }
    }

    public Control[] getConnectionRequsetControls() {
        return this.iConnCtls;
    }

    public long getCountLimit() {
        return this.iCountLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDirContext(DirContext dirContext) throws WIMException {
        if (this.iEnableContextPool) {
            Object object = lock;
            synchronized (object) {
                if (this.iContexts.size() >= this.iPrefPoolSize || this.iMaxPoolSize != 0 && this.iLiveContexts > this.iMaxPoolSize || ((TimedDirContext)dirContext).getCreateTimestamp() < this.iPoolCreateTimestamp || !this.getProviderURL(dirContext).equalsIgnoreCase(this.getActiveURL())) {
                    try {
                        dirContext.close();
                    }
                    catch (NamingException namingException) {
                        throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "releaseDirContext");
                    }
                    --this.iLiveContexts;
                    if (trcLogger.isLoggable(Level.FINEST)) {
                        trcLogger.logp(Level.FINEST, CLASSNAME, "releaseDirContext", "Context is discarded.");
                    }
                } else {
                    this.iContexts.add(dirContext);
                    if (this.iPoolTimeOut > 0) {
                        ((TimedDirContext)dirContext).setPoolTimeStamp(System.currentTimeMillis() / 1000L);
                    }
                    lock.notifyAll();
                    if (trcLogger.isLoggable(Level.FINEST)) {
                        trcLogger.logp(Level.FINEST, CLASSNAME, "releaseDirContext", "Context is back to pool.");
                    }
                }
            }
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "releaseDirContext", "ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size());
            }
        } else {
            try {
                dirContext.close();
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "releaseDirContext");
            }
        }
    }

    private Hashtable getEnvironment(int n, String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(this.iEnvironment);
        List list = (List)hashtable.remove(ENVKEY_URL_LIST);
        int n2 = list.size();
        int n3 = this.getURLIndex(string, list);
        String string2 = null;
        for (int i = n3; i < n3 + n2; ++i) {
            string2 = i > n3 ? string2 + " " + (String)list.get(i % n2) : (String)list.get(i % n2);
            if (n == 0) break;
        }
        hashtable.put("java.naming.provider.url", string2);
        hashtable.remove(ENVKEY_ACTIVE_URL);
        return hashtable;
    }

    private int getURLIndex(String string, List list) {
        int n = 0;
        int n2 = list.size();
        if (string != null) {
            for (int i = 0; i < n2; ++i) {
                if (!((String)list.get(i)).equalsIgnoreCase(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private String getNextURL(String string) {
        List list = this.getEnvURLList();
        int n = this.getURLIndex(string, list);
        return (String)list.get((n + 1) % list.size());
    }

    private List getEnvURLList() {
        return (List)this.iEnvironment.get(ENVKEY_URL_LIST);
    }

    private String getPrimaryURL() {
        return (String)this.getEnvURLList().get(0);
    }

    private String getActiveURL() {
        return (String)this.iEnvironment.get(ENVKEY_ACTIVE_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveURL(String string) {
        Object object = lock;
        synchronized (object) {
            this.iEnvironment.put(ENVKEY_ACTIVE_URL, string);
        }
    }

    private String getProviderURL(DirContext dirContext) {
        try {
            return (String)dirContext.getEnvironment().get("java.naming.provider.url");
        }
        catch (NamingException namingException) {
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "getProviderURL", namingException.toString(true));
            }
            return "(null)";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext getDirContext() throws WIMSystemException {
        Object object = null;
        long l = System.currentTimeMillis() / 1000L;
        if (this.iEnableContextPool) {
            do {
                Object object2 = lock;
                synchronized (object2) {
                    if (this.iContexts == null) {
                        try {
                            this.createContextPool(this.iInitPoolSize, null);
                        }
                        catch (NamingException namingException) {
                            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getDirContext");
                        }
                    }
                    if (this.iContexts.size() > 0) {
                        object = (DirContext)this.iContexts.remove(this.iContexts.size() - 1);
                    } else {
                        if (this.iLiveContexts >= this.iMaxPoolSize && this.iMaxPoolSize != 0) {
                            try {
                                lock.wait(this.iPoolWaitTime);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            continue;
                        }
                        ++this.iLiveContexts;
                    }
                }
                object2 = null;
                if (object != null) {
                    if (this.iPoolTimeOut > 0 && l - ((TimedDirContext)object).getPoolTimestamp() > (long)this.iPoolTimeOut) {
                        if (trcLogger.isLoggable(Level.FINEST)) {
                            trcLogger.logp(Level.FINEST, CLASSNAME, "getDirContext", "ContextPool: context is time out.");
                        }
                        object2 = object;
                        object = null;
                    }
                } else if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "getDirContext", "ContextPool: no free context, create a new one...");
                }
                if (object == null) {
                    try {
                        object = this.createDirContext(this.getEnvironment(1, this.getActiveURL()));
                    }
                    catch (NamingException namingException) {
                        throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getDirContext");
                    }
                }
                if (this.iReturnToPrimary && l - this.iLastQueryTime > this.iQueryInterval) {
                    try {
                        String string = this.getProviderURL((DirContext)object);
                        String string2 = this.getPrimaryURL();
                        if (!string2.equalsIgnoreCase(string)) {
                            Object object3;
                            boolean bl;
                            block49: {
                                Hashtable hashtable = this.getEnvironment(0, string2);
                                bl = false;
                                try {
                                    if (trcLogger.isLoggable(Level.FINER)) {
                                        trcLogger.logp(Level.FINER, CLASSNAME, "getDirContext", "Ping primary server '" + string2 + "'...");
                                    }
                                    object3 = this.createDirContext(hashtable);
                                    if (trcLogger.isLoggable(Level.FINER)) {
                                        trcLogger.logp(Level.FINE, CLASSNAME, "getDirContext", "Ping primary server '" + string2 + "': success");
                                    }
                                    bl = true;
                                    DirContext dirContext = object;
                                    try {
                                        dirContext.close();
                                    }
                                    catch (NamingException namingException) {
                                        trcLogger.logp(Level.FINE, CLASSNAME, "getDirContext", "Can not close LDAP connection: " + namingException.toString(true));
                                    }
                                    object = object3;
                                }
                                catch (NamingException namingException) {
                                    if (!trcLogger.isLoggable(Level.FINE)) break block49;
                                    trcLogger.logp(Level.FINE, CLASSNAME, "getDirContext", "Ping primary server '" + string2 + "': fail");
                                }
                            }
                            if (bl) {
                                object3 = lock;
                                synchronized (object3) {
                                    if (!this.getActiveURL().equalsIgnoreCase(string2)) {
                                        this.createContextPool(this.iLiveContexts - 1, string2);
                                        ((TimedDirContext)object).setCreateTimestamp(this.iPoolCreateTimestamp);
                                    }
                                }
                            }
                        }
                        this.iLastQueryTime = l;
                    }
                    catch (NamingException namingException) {
                        throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getDirContext");
                    }
                }
                if (object2 == null) continue;
                try {
                    object2.close();
                }
                catch (NamingException namingException) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "getDirContext", "Can not close LDAP connection: " + namingException.toString(true));
                }
            } while (object == null);
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "getDirContext", "ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size());
            }
        } else {
            try {
                if (this.iReturnToPrimary && l - this.iLastQueryTime > this.iQueryInterval) {
                    block50: {
                        String string = this.getPrimaryURL();
                        if (!string.equalsIgnoreCase(this.getActiveURL())) {
                            Hashtable hashtable = this.getEnvironment(0, string);
                            try {
                                if (trcLogger.isLoggable(Level.FINER)) {
                                    trcLogger.logp(Level.FINER, CLASSNAME, "getDirContext", "Ping primary server '" + string + "'...");
                                }
                                object = this.createDirContext(hashtable);
                                if (trcLogger.isLoggable(Level.FINER)) {
                                    trcLogger.logp(Level.FINE, CLASSNAME, "getDirContext", "Ping primary server '" + string + "': success");
                                }
                            }
                            catch (NamingException namingException) {
                                if (!trcLogger.isLoggable(Level.FINE)) break block50;
                                trcLogger.logp(Level.FINE, CLASSNAME, "getDirContext", "Ping primary server '" + string + "': fail");
                            }
                        }
                    }
                    this.iLastQueryTime = l;
                }
                if (object == null) {
                    object = this.createDirContext(this.getEnvironment(1, this.getActiveURL()));
                }
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getDirContext");
            }
        }
        return object;
    }

    public NameParser getNameParser() throws WIMException {
        if (this.iNameParser == null) {
            DirContext dirContext = this.getDirContext();
            try {
                try {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.entering(CLASSNAME, "JNDI_CALL getNameParser()", WIMMessageHelper.generateMsgParms(""));
                    }
                    this.iNameParser = dirContext.getNameParser("");
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.exiting(CLASSNAME, "JNDI_CALL getNameParser()");
                    }
                }
                catch (NamingException namingException) {
                    if (!this.isConnectionException(namingException, "getNameParser()")) {
                        throw namingException;
                    }
                    dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                    this.iNameParser = dirContext.getNameParser("");
                }
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getNameParser()");
            }
            finally {
                this.releaseDirContext(dirContext);
            }
        }
        return this.iNameParser;
    }

    public void initialize(DataObject dataObject) throws WIMException {
        block4: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "initialize(DataObject)");
            }
            this.iReposId = dataObject.getString("id");
            this.initializeServers(dataObject.getDataObject("ldapServerConfiguration"));
            this.initializeContextPool(dataObject.getDataObject("contextPool"));
            this.iAttrsCacheName = this.iReposId + "/" + this.iAttrsCacheName;
            this.iSearchResultsCacheName = this.iReposId + "/" + this.iSearchResultsCacheName;
            try {
                this.createContextPool(this.iInitPoolSize, null);
            }
            catch (NamingException namingException) {
                if (!trcLogger.isLoggable(Level.FINE)) break block4;
                trcLogger.logp(Level.FINE, CLASSNAME, "initialize(DataObject)", "Can not create context pool: " + namingException.toString(true));
            }
        }
        this.initializeCaches(dataObject.getDataObject("cacheConfiguration"));
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize(DataObject)");
        }
    }

    private void initializeServers(DataObject dataObject) throws WIMException {
        this.iTimeLimit = dataObject.getInt("searchTimeLimit");
        this.iCountLimit = dataObject.getInt("searchCountLimit");
        if (dataObject.isSet("searchPageSize")) {
            this.iPageSize = dataObject.getInt("searchPageSize");
        } else if (this.iLdapConfigMgr.getLdapType().startsWith("AD") || this.iLdapConfigMgr.getLdapType().equals("ADAM")) {
            this.iPageSize = 1000;
        }
        if (dataObject.isSet("attributeRangeStep")) {
            this.iAttrRangeStep = dataObject.getInt("attributeRangeStep");
        } else if (this.iLdapConfigMgr.getLdapType().equals("AD2000") || this.iLdapConfigMgr.getLdapType().equals("ADAM")) {
            this.iAttrRangeStep = 1000;
        } else if (this.iLdapConfigMgr.getLdapType().startsWith("AD2003")) {
            this.iAttrRangeStep = 1500;
        }
        this.iWriteToSecondary = dataObject.getBoolean("allowWriteToSecondaryServers");
        this.iReturnToPrimary = dataObject.getBoolean("returnToPrimaryServer");
        this.iQueryInterval = dataObject.getInt("primaryServerQueryTimeInterval") * 60;
        this.initializeSSL(dataObject);
        List list = dataObject.getList("ldapServers");
        DataObject dataObject2 = (DataObject)list.get(0);
        this.iEnvironment = this.initializeEnvironmentProperties(dataObject2);
    }

    private Hashtable initializeEnvironmentProperties(DataObject dataObject) throws MissingInitPropertyException, WIMSystemException {
        String string;
        int n;
        String string2;
        Object object;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        List list = dataObject.getList("connections");
        boolean bl = dataObject.getBoolean("sslEnabled");
        String string3 = null;
        if (bl) {
            if (this.iSSLFactory != null) {
                hashtable.put("java.naming.ldap.factory.socket", this.iSSLFactory);
            }
            hashtable.put("java.naming.security.protocol", "ssl");
            string3 = "ldaps://";
        } else {
            string3 = "ldap://";
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = (DataObject)list.get(i);
            string2 = object.getString("host");
            int n2 = object.getInt("port");
            vector.add(string3 + string2.trim() + ":" + n2);
        }
        hashtable.put(ENVKEY_URL_LIST, vector);
        hashtable.put(ENVKEY_ACTIVE_URL, vector.get(0));
        String string4 = dataObject.getString("bindDN");
        if (string4 != null && string4.length() > 0) {
            hashtable.put("java.naming.security.principal", string4);
            object = dataObject.getString("bindPassword");
            if (object == null || ((String)object).length() == 0) {
                throw new MissingInitPropertyException("MISSING_INI_PROPERTY", WIMMessageHelper.generateMsgParms("bindPassword"), CLASSNAME, "initializeEnvironmentProperties");
            }
            object = new WSEncoderDecoder().decode((String)object);
            hashtable.put("java.naming.security.credentials", PasswordUtil.getByteArrayPassword((String)object));
        }
        object = dataObject.getString("authentication");
        hashtable.put("java.naming.security.authentication", object);
        string2 = dataObject.getString("referal");
        hashtable.put("java.naming.referral", string2);
        String string5 = dataObject.getString("derefAliases");
        if (!"always".equalsIgnoreCase(string5)) {
            hashtable.put("java.naming.ldap.derefAliases", string5);
        }
        boolean bl2 = dataObject.getBoolean("connectionPool");
        hashtable.put("com.sun.jndi.ldap.connect.pool", Boolean.toString(bl2));
        if (dataObject.isSet("connectTimeout") && (n = dataObject.getInt("connectTimeout")) > 0) {
            hashtable.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(n * 1000));
            hashtable.put("com.sun.jndi.ldap.read.timeout", Integer.toString(n * 1000));
        }
        if ((string = this.getBinaryAttributes()) != null && string.length() > 0) {
            hashtable.put("java.naming.ldap.attributes.binary", string);
        }
        List list2 = dataObject.getList("environmentProperties");
        for (int i = 0; i < list2.size(); ++i) {
            DataObject dataObject2 = (DataObject)list2.get(i);
            String string6 = dataObject2.getString("name");
            String string7 = dataObject2.getString("value");
            hashtable.put(string6, string7);
        }
        if (trcLogger.isLoggable(Level.CONFIG)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\nLDAP Server(s): ").append(vector).append("\n");
            stringBuffer.append("\tBind DN: ").append(string4).append("\n");
            stringBuffer.append("\tAhthenticate: ").append((String)object).append("\n");
            stringBuffer.append("\tReferal: ").append(string2).append("\n");
            stringBuffer.append("\tEnable Connection Pool: ").append(bl2).append("\n");
            stringBuffer.append("\tBinary Attributes: ").append(string).append("\n");
            stringBuffer.append("\tAdditional Evn Props: ").append(list2);
            trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeEnvironmentProperties", stringBuffer.toString());
        }
        return hashtable;
    }

    public String getSSLFactory() {
        return this.iSSLFactory;
    }

    private void initializeWIMSSL(DataObject dataObject) {
        String string;
        String string2;
        String string3 = dataObject.getString("sslKeyStore");
        String string4 = dataObject.getString("sslTrustStore");
        if (string3 == null && string4 == null) {
            if (trcLogger.isLoggable(Level.CONFIG)) {
                trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeWIMSSL(DataObject)", "Use default SSL settings.");
            }
            return;
        }
        if (trcLogger.isLoggable(Level.CONFIG)) {
            trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeWIMSSL(DataObject)", "Use SSL system properties.");
        }
        WSEncoderDecoder wSEncoderDecoder = new WSEncoderDecoder();
        if (string3 != null) {
            System.setProperty("javax.net.ssl.keyStore", string3);
            string2 = dataObject.getString("sslKeyStoreType");
            if (string2 != null) {
                System.setProperty("javax.net.ssl.keyStoreType", string2);
            }
            if ((string = dataObject.getString("sslKeyStorePassword")) != null) {
                string = wSEncoderDecoder.decode(string);
                System.setProperty("javax.net.ssl.keyStorePassword", string);
            }
            if (trcLogger.isLoggable(Level.CONFIG)) {
                trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeWIMSSL(DataObject)", "javax.net.ssl.keyStore=" + string3);
            }
        }
        if (string4 != null) {
            System.setProperty("javax.net.ssl.trustStore", string4);
            string2 = dataObject.getString("sslTrustStoreType");
            if (string2 != null) {
                System.setProperty("javax.net.ssl.trustStoreType", string2);
            }
            if ((string = dataObject.getString("sslTrustStorePassword")) != null) {
                string = wSEncoderDecoder.decode(string);
                System.setProperty("javax.net.ssl.trustStorePassword", string);
            }
            if (trcLogger.isLoggable(Level.CONFIG)) {
                trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeWIMSSL(DataObject)", "javax.net.ssl.trustStore=" + string4);
            }
        }
    }

    private void initializeSSL(DataObject dataObject) throws WIMConfigurationException {
        String string = dataObject.getString("sslConfiguration");
        if (string != null) {
            if (trcLogger.isLoggable(Level.CONFIG)) {
                trcLogger.logp(Level.CONFIG, CLASSNAME, "initializeSSL(DataObject)", "Use WAS SSL Configuration.");
            }
            this.iSSLAlias = string;
            this.iSSLFactory = WAS_SSL_SOCKE_FACTORY;
        } else {
            this.initializeWIMSSL(dataObject);
        }
    }

    private String getBinaryAttributes() {
        StringBuffer stringBuffer = new StringBuffer(10);
        Map map = this.iLdapConfigMgr.getAttributes();
        for (String string : map.keySet()) {
            LdapAttribute ldapAttribute = (LdapAttribute)map.get(string);
            if (!"octetString".equalsIgnoreCase(ldapAttribute.getSyntax())) continue;
            stringBuffer.append(ldapAttribute.getName()).append(" ");
        }
        return stringBuffer.toString().trim();
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException, WIMException {
        DirContext dirContext = this.getDirContext();
        this.checkWritePermission(dirContext);
        try {
            try {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.entering(CLASSNAME, "JNDI_CALL modifyAttributes(Name name, ModificationItem[] mods)", WIMMessageHelper.generateMsgParms(string, this.printModificationItem(modificationItemArray)));
                }
                dirContext.modifyAttributes(new LdapName(string), modificationItemArray);
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.exiting(CLASSNAME, "JNDI_CALL modifyAttributes(Name name, ModificationItem[] mods)");
                }
            }
            catch (NamingException namingException) {
                if (!this.isConnectionException(namingException, "modifyAttributes(Name name, ModificationItem[] mods)")) {
                    throw namingException;
                }
                dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                dirContext.modifyAttributes(new LdapName(string), modificationItemArray);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new EntityNotFoundException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(nameNotFoundException.toString(true)), CLASSNAME, "modifyAttributes(Name name, ModificationItem[] mods)");
        }
        catch (NamingException namingException) {
            trcLogger.logp(Level.SEVERE, CLASSNAME, "modifyAttributes(Name name, ModificationItem[] mods)", namingException.toString(true));
            throw namingException;
        }
        finally {
            this.releaseDirContext(dirContext);
        }
    }

    public void modifyAttributes(String string, int n, Attributes attributes2) throws NamingException, WIMException {
        DirContext dirContext = this.getDirContext();
        this.checkWritePermission(dirContext);
        try {
            try {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.entering(CLASSNAME, "JNDI_CALL modifyAttributes(Name, int, Attributes)", WIMMessageHelper.generateMsgParms(string, new Integer(n), this.printAttributes(attributes2)));
                }
                dirContext.modifyAttributes(new LdapName(string), n, attributes2);
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.exiting(CLASSNAME, "JNDI_CALL modifyAttributes(Name, int, Attributes)");
                }
            }
            catch (NamingException namingException) {
                if (!this.isConnectionException(namingException, "modifyAttributes(Name, int, Attributes)")) {
                    throw namingException;
                }
                dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                dirContext.modifyAttributes(new LdapName(string), n, attributes2);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new EntityNotFoundException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(nameNotFoundException.toString(true)), CLASSNAME, "modifyAttributes(Name, int, Attributes)");
        }
        catch (NamingException namingException) {
            trcLogger.logp(Level.SEVERE, CLASSNAME, "modifyAttributes(Name, int, Attributes)", namingException.toString(true));
            throw namingException;
        }
        finally {
            this.releaseDirContext(dirContext);
        }
    }

    public void rename(String string, String string2) throws WIMException {
        DirContext dirContext = this.getDirContext();
        this.checkWritePermission(dirContext);
        try {
            try {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.entering(CLASSNAME, "JNDI_CALL rename", WIMMessageHelper.generateMsgParms(string, string2));
                }
                dirContext.rename(string, string2);
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.exiting(CLASSNAME, "JNDI_CALL rename");
                }
            }
            catch (NamingException namingException) {
                if (!this.isConnectionException(namingException, "rename")) {
                    throw namingException;
                }
                dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                dirContext.rename(string, string2);
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "rename");
        }
        finally {
            this.releaseDirContext(dirContext);
        }
    }

    public Attributes getAttributesByExtId(String string, String[] stringArray, List list) throws WIMException {
        int namingException;
        Object wIMSystemException;
        Object object4;
        Serializable serializable;
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "getAttributesByExtId", WIMMessageHelper.generateMsgParms(string, WIMTraceHelper.printObjectArray(stringArray), list));
        }
        Attributes attributes2 = null;
        String string2 = null;
        boolean bl = false;
        Object object5 = null;
        String string3 = string;
        if (this.getAttributesCache() != null) {
            bl = true;
            object5 = this.getAttributesCache().get(string3);
        }
        if (object5 != null && object5 instanceof String) {
            string2 = (String)object5;
            try {
                attributes2 = this.checkAttributesCache(string2, stringArray);
                if (attributes2 != null) {
                    attributes2.put("distinguishedName", string2);
                }
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.exiting(CLASSNAME, "getAttributesByExtId", this.printAttributes(attributes2));
                }
                return attributes2;
            }
            catch (EntityNotFoundException entityNotFoundException) {
                this.getAttributesCache().invalidate(string3);
            }
        }
        if (bl && trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "getAttributesByExtId", "Miss cache: " + string3);
        }
        String[] stringArray2 = null;
        HashSet<String> hashSet = null;
        boolean bl2 = false;
        if (list != null && list.size() > 0) {
            hashSet = new HashSet<String>(list.size());
            serializable = new ArrayList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                object4 = this.iLdapConfigMgr.getLdapEntity((String)list.get(i));
                if (object4 == null) {
                    bl2 = true;
                    continue;
                }
                hashSet.add(object4.getExtId());
                serializable.addAll(object4.getSearchBaseList());
            }
            if (!bl2) {
                stringArray2 = serializable.toArray(new String[0]);
                stringArray2 = NodeHelper.getTopNodes(stringArray2);
            }
        }
        if (stringArray2 == null) {
            hashSet = this.iLdapConfigMgr.getExtIds();
            stringArray2 = this.iLdapConfigMgr.getTopLdapNodes();
        }
        if (hashSet.size() == 0) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getAttributesByExtId");
        }
        serializable = new StringBuffer(256);
        ArrayList<Object> arrayList = new ArrayList<Object>(hashSet.size());
        for (String object32 : hashSet) {
            try {
                wIMSystemException = this.iLdapConfigMgr.getLdapValue(string, "String", object32);
                if (wIMSystemException == null) continue;
                arrayList.add(wIMSystemException);
                ((StringBuffer)serializable).append("(").append(object32).append("={").append(arrayList.size() - 1).append("})");
            }
            catch (WIMSystemException wIMSystemException2) {
                if ("SYSTEM_EXCEPTION".equalsIgnoreCase(wIMSystemException2.getMessageKey())) {
                    throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.FINE, CLASSNAME, "getAttributesByExtId");
                }
                throw wIMSystemException2;
            }
        }
        if (arrayList.size() > 1) {
            serializable = new StringBuffer("(|" + serializable + ")");
        }
        object4 = arrayList.toArray();
        SearchControls searchControls = new SearchControls();
        searchControls.setTimeLimit(this.iTimeLimit);
        searchControls.setCountLimit(this.iCountLimit);
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(stringArray);
        searchControls.setReturningObjFlag(true);
        wIMSystemException = this.getDirContext();
        String string4 = null;
        try {
            for (namingException = 0; namingException < stringArray2.length; ++namingException) {
                string4 = stringArray2[namingException];
                NamingEnumeration<SearchResult> n3 = null;
                try {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.entering(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls", WIMMessageHelper.generateMsgParms(string4, serializable, WIMTraceHelper.printObjectArray(object4), LdapHelper.printSearchControls(searchControls)));
                    }
                    n3 = wIMSystemException.search(string4, ((StringBuffer)serializable).toString(), (Object[])object4, searchControls);
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.exiting(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls");
                    }
                }
                catch (NamingException namingException2) {
                    if (!this.isConnectionException(namingException2, "getAttributesByExtId")) {
                        throw namingException2;
                    }
                    wIMSystemException = this.reCreateDirContext((DirContext)wIMSystemException, namingException2.toString());
                    n3 = wIMSystemException.search(string4, ((StringBuffer)serializable).toString(), (Object[])object4, searchControls);
                }
                if (!n3.hasMoreElements() || (namingException4 = (SearchResult)n3.nextElement()) == null) continue;
                string2 = LdapHelper.prepareDN(((NameClassPair)namingException4).getName(), string4);
                attributes2 = ((SearchResult)namingException4).getAttributes();
                if (n3.hasMoreElements()) {
                    throw new WIMSystemException("DUPLICATE_EXTTERNAL_ID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getAttributesByExtId");
                }
                if (this.iAttrRangeStep > 0) {
                    this.supportRangeAttributes(attributes2, string2, (DirContext)wIMSystemException);
                }
                break;
            }
        }
        catch (NamingException namingException3) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException3.toString(true)), Level.SEVERE, CLASSNAME, "getAttributesByExtId");
        }
        finally {
            this.releaseDirContext((DirContext)wIMSystemException);
        }
        if (attributes2 != null) {
            if (bl) {
                this.updateAttributesCache(string3, string2, attributes2);
            }
            attributes2.put("distinguishedName", string2);
        } else {
            namingException = 1;
            if (this.iLdapConfigMgr.getLdapType().equalsIgnoreCase("SUNONE")) {
                int n = this.iLdapConfigMgr.getLdapEntities().length;
                Object namingException4 = this.iLdapConfigMgr.getLdapEntities();
                boolean bl3 = false;
                for (int namingException5 = 0; namingException5 < n; ++namingException5) {
                    if (!namingException4[namingException5].getName().equalsIgnoreCase("group") || !((LdapEntity)namingException4[namingException5]).getObjectClasses().contains("ldapsubentry")) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    namingException = 0;
                    serializable = new StringBuffer("(&(objectclass=ldapsubentry)" + serializable + ")");
                    wIMSystemException = this.getDirContext();
                    string4 = null;
                    try {
                        for (namingException5 = 0; namingException5 < stringArray2.length; ++namingException5) {
                            SearchResult searchResult;
                            string4 = stringArray2[namingException5];
                            NamingEnumeration<SearchResult> namingEnumeration = null;
                            if (trcLogger.isLoggable(Level.FINE)) {
                                trcLogger.entering(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls", WIMMessageHelper.generateMsgParms(string4, serializable, WIMTraceHelper.printObjectArray(object4), LdapHelper.printSearchControls(searchControls)));
                            }
                            namingEnumeration = wIMSystemException.search(string4, ((StringBuffer)serializable).toString(), (Object[])object4, searchControls);
                            if (trcLogger.isLoggable(Level.FINE)) {
                                trcLogger.exiting(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls");
                            }
                            if (!namingEnumeration.hasMoreElements() || (searchResult = (SearchResult)namingEnumeration.nextElement()) == null) continue;
                            string2 = LdapHelper.prepareDN(searchResult.getName(), string4);
                            attributes2 = searchResult.getAttributes();
                            if (!namingEnumeration.hasMoreElements()) break;
                            throw new WIMSystemException("DUPLICATE_EXTTERNAL_ID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getAttributesByExtId");
                        }
                    }
                    catch (NamingException namingException6) {
                        throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException6.toString(true)), Level.SEVERE, CLASSNAME, "getAttributesByExtId");
                    }
                    finally {
                        this.releaseDirContext((DirContext)wIMSystemException);
                    }
                } else {
                    namingException = 1;
                }
            } else {
                namingException = 1;
            }
            if (namingException != 0 || attributes2 == null) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getAttributesByExtId");
            }
            if (bl) {
                this.updateAttributesCache(string3, string2, attributes2);
            }
            attributes2.put("distinguishedName", string2);
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "getAttributesByExtId", this.printAttributes(attributes2));
        }
        return attributes2;
    }

    public Attributes getAttributesByUniqueName(String string, String[] stringArray, List list) throws WIMException {
        int n;
        String string2 = null;
        Attributes attributes2 = null;
        string = this.iLdapConfigMgr.switchToLdapNode(string);
        boolean bl = false;
        if (this.iLdapConfigMgr.needTranslateRDN()) {
            if (list != null && list.size() > 0) {
                for (n = 0; n < list.size(); ++n) {
                    if (!this.iLdapConfigMgr.needTranslateRDN((String)list.get(n))) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
        }
        if (!bl) {
            string2 = string;
            attributes2 = this.checkAttributesCache(string2, stringArray);
            attributes2.put("distinguishedName", string2);
            return attributes2;
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "getAttributesByUniqueName", WIMMessageHelper.generateMsgParms(string, WIMTraceHelper.printObjectArray(stringArray), list));
        }
        n = 0;
        Object object = null;
        String string3 = LdapConnection.toKey(string);
        if (this.getAttributesCache() != null) {
            n = 1;
            object = this.getAttributesCache().get(string3);
        }
        if (object != null && object instanceof String) {
            string2 = (String)object;
            try {
                attributes2 = this.checkAttributesCache(string2, stringArray);
                attributes2.put("distinguishedName", string2);
                return attributes2;
            }
            catch (EntityNotFoundException entityNotFoundException) {
                this.getAttributesCache().invalidate(string3);
            }
        }
        String string4 = this.iLdapConfigMgr.getLdapRDNFilter(null, LdapHelper.getRDN(string));
        String string5 = LdapHelper.getParentDN(string);
        SearchControls searchControls = new SearchControls();
        searchControls.setTimeLimit(this.iTimeLimit);
        searchControls.setCountLimit(this.iCountLimit);
        searchControls.setSearchScope(1);
        searchControls.setReturningAttributes(stringArray);
        searchControls.setReturningObjFlag(true);
        DirContext dirContext = this.getDirContext();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchResult searchResult;
            try {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.entering(CLASSNAME, "JNDI_CALL search(String, String SearchControls)", WIMMessageHelper.generateMsgParms(string5, string4, LdapHelper.printSearchControls(searchControls)));
                }
                namingEnumeration = dirContext.search(string5, string4, searchControls);
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.exiting(CLASSNAME, "JNDI_CALL search(String, String SearchControls)");
                }
            }
            catch (NamingException namingException) {
                if (!this.isConnectionException(namingException, "getAttributesByUniqueName")) {
                    throw namingException;
                }
                dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                namingEnumeration = dirContext.search(string5, string4, searchControls);
            }
            if (namingEnumeration.hasMoreElements() && (searchResult = (SearchResult)namingEnumeration.nextElement()) != null) {
                string2 = LdapHelper.prepareDN(searchResult.getName(), string5);
                attributes2 = searchResult.getAttributes();
                if (this.iAttrRangeStep > 0) {
                    this.supportRangeAttributes(attributes2, string2, dirContext);
                }
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string5), CLASSNAME, "getAttributesByUniqueName");
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getAttributesByUniqueName");
        }
        finally {
            this.releaseDirContext(dirContext);
        }
        if (attributes2 != null) {
            if (n != 0) {
                this.updateAttributesCache(string3, string2, attributes2);
            }
        } else {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getAttributesByUniqueName");
        }
        attributes2.put("distinguishedName", string2);
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "getAttributesByUniqueName", this.printAttributes(attributes2));
        }
        return attributes2;
    }

    public LdapEntry getEntityByIdentifier(DataObject dataObject, List list, List list2, boolean bl, boolean bl2) throws WIMException {
        return this.getEntityByIdentifier(dataObject.getString("externalName"), dataObject.getString("externalId"), dataObject.getString("uniqueName"), list, list2, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LdapEntry getEntityByIdentifier(String string, String string2, String string3, List list, List list2, boolean bl, boolean bl2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getEntityByIdentifier", WIMMessageHelper.generateMsgParms(string, string2, string3, list, list2, bl, bl2));
        }
        String[] stringArray = this.iLdapConfigMgr.getAttributeNames(list, list2, bl, bl2);
        Attributes attributes2 = null;
        Object var11_10 = null;
        if (string == null && !this.iLdapConfigMgr.needTranslateRDN()) {
            string = this.iLdapConfigMgr.switchToLdapNode(string3);
        }
        if (string2 != null) {
            if (this.iLdapConfigMgr.isAnyExtIdDN()) {
                string = LdapHelper.getValidDN(string2);
                if (string != null) {
                    attributes2 = this.checkAttributesCache(string, stringArray);
                } else {
                    if (string3 == null) throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(null), CLASSNAME, "getEntityByIdentifier");
                    attributes2 = this.getAttributesByUniqueName(string3, stringArray, list);
                    string = LdapHelper.getDNFromAttributes(attributes2);
                }
            } else {
                attributes2 = this.getAttributesByExtId(string2, stringArray, list);
                string = LdapHelper.getDNFromAttributes(attributes2);
            }
        } else if (string != null) {
            attributes2 = this.checkAttributesCache(string, stringArray);
        } else {
            if (string3 == null) throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(null), CLASSNAME, "getEntityByIdentifier");
            attributes2 = this.getAttributesByUniqueName(string3, stringArray, list);
            string = LdapHelper.getDNFromAttributes(attributes2);
        }
        String string4 = this.iLdapConfigMgr.getEntityType(attributes2, string3, string, string2, list);
        string3 = this.getUniqueName(string, string4, attributes2);
        if (string2 == null) {
            string2 = this.iLdapConfigMgr.getExtIdFromAttributes(string, string4, attributes2);
        }
        LdapEntry ldapEntry = new LdapEntry(string, string2, string3, string4, attributes2);
        if (!trcLogger.isLoggable(Level.FINER)) return ldapEntry;
        trcLogger.exiting(CLASSNAME, "getEntityByIdentifier", ldapEntry.toString());
        return ldapEntry;
    }

    private NamingEnumeration updateSearchCache(String string, String string2, NamingEnumeration namingEnumeration) throws WIMSystemException {
        CachedNamingEnumeration cachedNamingEnumeration = new CachedNamingEnumeration();
        CachedNamingEnumeration cachedNamingEnumeration2 = new CachedNamingEnumeration();
        int n = LdapConnection.cloneSearchResults(namingEnumeration, cachedNamingEnumeration, cachedNamingEnumeration2);
        if (this.iSearchResultSizeLmit == 0 || n < this.iSearchResultSizeLmit) {
            this.getSearchResultsCache().put(string2, cachedNamingEnumeration2, 1, this.iSearchResultsCacheTimeOut, this.iSearchResultsCacheDistPolicy, null);
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "updateSearchCache", "Update " + this.iSearchResultsCacheName + "(size: " + this.getSearchResultsCache().size() + ")\n" + string2);
            }
            if (this.getAttributesCache() != null) {
                try {
                    n = 0;
                    while (cachedNamingEnumeration2.hasMore()) {
                        SearchResult searchResult = (SearchResult)cachedNamingEnumeration2.nextElement();
                        String string3 = searchResult.getName();
                        String string4 = "";
                        string4 = string3 == null || string3.trim().length() == 0 ? string : string3 + "," + string;
                        Object object = this.getAttributesCache().get(string4);
                        Attributes attributes2 = null;
                        if (object != null && object instanceof Attributes) {
                            attributes2 = (Attributes)object;
                        }
                        this.updateAttributesCache(string4, searchResult.getAttributes(), attributes2);
                        if (++n <= 20) continue;
                        if (trcLogger.isLoggable(Level.FINEST)) {
                            trcLogger.logp(Level.FINEST, CLASSNAME, "updateSearchCache", "attribute cache updated with " + (n - 1) + " entries. skipping rest.");
                        }
                        break;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return cachedNamingEnumeration;
    }

    public NamingEnumeration checkSearchCache(String string, String string2, Object[] objectArray, SearchControls searchControls) throws WIMException {
        NamingEnumeration namingEnumeration = null;
        if (this.getSearchResultsCache() != null) {
            String string3 = null;
            string3 = objectArray == null ? LdapConnection.toKey(string, string2, searchControls) : LdapConnection.toKey(string, string2, objectArray, searchControls);
            CachedNamingEnumeration cachedNamingEnumeration = (CachedNamingEnumeration)this.getSearchResultsCache().get(string3);
            if (cachedNamingEnumeration == null) {
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "checkSearchCache", "Miss cache: " + string3);
                }
                namingEnumeration = this.search(string, string2, objectArray, searchControls);
                namingEnumeration = this.updateSearchCache(string, string3, namingEnumeration);
            } else {
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "checkSearchCache", "Hit cache: " + string3);
                }
                namingEnumeration = (CachedNamingEnumeration)cachedNamingEnumeration.clone();
            }
        } else {
            namingEnumeration = this.search(string, string2, objectArray, searchControls);
        }
        return namingEnumeration;
    }

    private NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws WIMException {
        if (this.iPageSize == 0) {
            DirContext dirContext = this.getDirContext();
            NamingEnumeration<SearchResult> namingEnumeration = null;
            try {
                try {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.entering(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls)", WIMMessageHelper.generateMsgParms(string, string2, WIMTraceHelper.printObjectArray(objectArray), LdapHelper.printSearchControls(searchControls)));
                    }
                    namingEnumeration = objectArray == null ? dirContext.search((Name)new LdapName(string), string2, searchControls) : dirContext.search(new LdapName(string), string2, objectArray, searchControls);
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.exiting(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls)");
                    }
                }
                catch (NamingException namingException) {
                    if (!this.isConnectionException(namingException, "search(String, String, Object[], SearchControls)")) {
                        throw namingException;
                    }
                    dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                    namingEnumeration = objectArray == null ? dirContext.search((Name)new LdapName(string), string2, searchControls) : dirContext.search(new LdapName(string), string2, objectArray, searchControls);
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.exiting(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls)");
                    }
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, nameNotFoundException.toString(true)), CLASSNAME, "search(String, String, Object[], SearchControls)");
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "search(String, String, Object[], SearchControls)");
            }
            finally {
                this.releaseDirContext(dirContext);
            }
            return namingEnumeration;
        }
        LdapContext ldapContext = (LdapContext)this.getDirContext();
        try {
            NamingEnumeration namingEnumeration;
            ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.iPageSize)});
            byte[] byArray = null;
            int n = 1;
            int n2 = 0;
            CachedNamingEnumeration cachedNamingEnumeration = new CachedNamingEnumeration();
            do {
                PagedResultsControl pagedResultsControl;
                namingEnumeration = null;
                try {
                    if (trcLogger.isLoggable(Level.FINEST)) {
                        trcLogger.logp(Level.FINEST, CLASSNAME, "search(String, String, Object[], SearchControls)", "Search page " + n);
                    }
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.entering(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls)", WIMMessageHelper.generateMsgParms(string, string2, WIMTraceHelper.printObjectArray(objectArray), LdapHelper.printSearchControls(searchControls)));
                    }
                    namingEnumeration = objectArray == null ? ldapContext.search((Name)new LdapName(string), string2, searchControls) : ldapContext.search(new LdapName(string), string2, objectArray, searchControls);
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.exiting(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls)");
                    }
                }
                catch (NamingException namingException) {
                    if (namingException instanceof CommunicationException || namingException instanceof ServiceUnavailableException) {
                        ldapContext = (LdapContext)this.reCreateDirContext(ldapContext, namingException.toString());
                        ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.iPageSize)});
                        if (trcLogger.isLoggable(Level.FINEST)) {
                            trcLogger.logp(Level.FINEST, CLASSNAME, "search(String, String, Object[], SearchControls)", "Search page " + n);
                        }
                        if (trcLogger.isLoggable(Level.FINE)) {
                            trcLogger.entering(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls)", WIMMessageHelper.generateMsgParms(string, string2, WIMTraceHelper.printObjectArray(objectArray), LdapHelper.printSearchControls(searchControls)));
                        }
                        namingEnumeration = objectArray == null ? ldapContext.search((Name)new LdapName(string), string2, searchControls) : ldapContext.search(new LdapName(string), string2, objectArray, searchControls);
                        if (trcLogger.isLoggable(Level.FINE)) {
                            trcLogger.exiting(CLASSNAME, "JNDI_CALL search(String, String, Object[], SearchControls)");
                        }
                    }
                    throw namingException;
                }
                if (namingEnumeration == null) continue;
                ++n;
                while (namingEnumeration.hasMoreElements()) {
                    cachedNamingEnumeration.add(namingEnumeration.nextElement());
                    ++n2;
                }
                Control[] controlArray = ldapContext.getResponseControls();
                if (controlArray == null || controlArray.length <= 0 || (byArray = (pagedResultsControl = new PagedResultsControl(controlArray[0].getEncodedValue())).getCookie()).length <= 0) continue;
                ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.iPageSize, byArray)});
            } while (byArray != null && byArray.length > 0);
            namingEnumeration = cachedNamingEnumeration;
            return namingEnumeration;
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "search(String, String, Object[], SearchControls)");
        }
        finally {
            try {
                ldapContext.setRequestControls(null);
            }
            catch (NamingException namingException) {
                trcLogger.logp(Level.SEVERE, CLASSNAME, "search(String, String, Object[], SearchControls)", namingException.toString(true));
            }
            this.releaseDirContext(ldapContext);
        }
    }

    public NamingEnumeration search(String string, String string2, int n, String[] stringArray, int n2, int n3) throws WIMException {
        SearchControls searchControls = new SearchControls(n, n2, n3, stringArray, true, false);
        return this.checkSearchCache(string, string2, null, searchControls);
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, int n, String[] stringArray, int n2, int n3) throws WIMException {
        SearchControls searchControls = new SearchControls(n, n2, n3, stringArray, true, false);
        return this.checkSearchCache(string, string2, objectArray, searchControls);
    }

    public NamingEnumeration search(String string, String string2, int n, String[] stringArray) throws WIMException {
        SearchControls searchControls = new SearchControls(n, this.iCountLimit, this.iTimeLimit, stringArray, true, false);
        return this.checkSearchCache(string, string2, null, searchControls);
    }

    public Set searchEntities(String string, String string2, Object[] objectArray, int n, List list, List list2, boolean bl, boolean bl2) throws WIMException {
        return this.searchEntities(string, string2, objectArray, n, list, list2, bl, bl2, this.iCountLimit, this.iTimeLimit);
    }

    public Map getDynamicGroups(String[] stringArray, List list, boolean bl) throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "getDynamicGroups", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printObjectArray(stringArray), list));
        }
        HashMap<String, LdapEntry> hashMap = new HashMap<String, LdapEntry>();
        String[] stringArray2 = this.iLdapConfigMgr.getAttributeNames(this.iLdapConfigMgr.getGroupTypes(), list, bl, false);
        String[] stringArray3 = this.iLdapConfigMgr.getDynamicMemberAttributes();
        String[] stringArray4 = stringArray2;
        stringArray2 = new String[stringArray4.length + stringArray3.length];
        System.arraycopy(stringArray4, 0, stringArray2, 0, stringArray4.length);
        System.arraycopy(stringArray3, 0, stringArray2, stringArray4.length, stringArray3.length);
        String string = this.iLdapConfigMgr.getDynamicGroupFilter();
        for (String string2 : stringArray) {
            NamingEnumeration namingEnumeration = this.search(string2, string, 2, stringArray2);
            while (namingEnumeration.hasMoreElements()) {
                String string3;
                SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                if (searchResult == null || (string3 = searchResult.getName()) == null || string3.trim().length() == 0) continue;
                String string4 = LdapHelper.prepareDN(string3, string2);
                Attributes attributes2 = searchResult.getAttributes();
                String string5 = this.iLdapConfigMgr.getExtIdFromAttributes(string4, "Group", attributes2);
                String string6 = this.getUniqueName(string4, "Group", attributes2);
                LdapEntry ldapEntry = new LdapEntry(string4, string5, string6, "Group", attributes2);
                hashMap.put(ldapEntry.getDN(), ldapEntry);
            }
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "getDynamicGroups", hashMap);
        }
        return hashMap;
    }

    public boolean isMemberInURLQuery(LdapURL[] ldapURLArray, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isMemberInURLQuery", WIMMessageHelper.generateMsgParms(WIMTraceHelper.printObjectArray(ldapURLArray), string));
        }
        boolean bl = false;
        String[] stringArray = new String[]{};
        String string2 = LdapHelper.getRDN(string);
        if (ldapURLArray != null) {
            for (int i = 0; i < ldapURLArray.length; ++i) {
                String string3;
                SearchResult searchResult;
                NamingEnumeration namingEnumeration;
                String string4;
                LdapURL ldapURL = ldapURLArray[i];
                if (!ldapURL.parsedOK() || !LdapHelper.isUnderBases(string, string4 = ldapURL.get_dn())) continue;
                int n = ldapURL.get_searchScope();
                String string5 = ldapURL.get_filter();
                if (n == 2) {
                    if (string5 == null) {
                        bl = true;
                        break;
                    }
                    namingEnumeration = this.search(string, string5, 0, stringArray);
                    if (!namingEnumeration.hasMoreElements()) continue;
                    bl = true;
                    break;
                }
                namingEnumeration = this.search(string4, string5 = string5 == null ? string2 : "(&(" + string5 + ")(" + string2 + "))", n, stringArray);
                if (!namingEnumeration.hasMoreElements() || (searchResult = (SearchResult)namingEnumeration.nextElement()) == null || !string.equalsIgnoreCase(string3 = LdapHelper.prepareDN(searchResult.getName(), string4))) continue;
                bl = true;
                break;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isMemberInURLQuery", bl);
        }
        return bl;
    }

    public Set searchEntities(String string, String string2, Object[] objectArray, int n, List list, List list2, boolean bl, boolean bl2, int n2, int n3) throws WIMException {
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.entering(CLASSNAME, "searchEntities", WIMMessageHelper.generateMsgParms(string, string2, WIMTraceHelper.printObjectArray(objectArray), new Integer(n), list, list2, bl, bl2));
        }
        String[] stringArray = this.iLdapConfigMgr.getAttributeNames(list, list2, bl, bl2);
        HashSet<LdapEntry> hashSet = new HashSet<LdapEntry>();
        NamingEnumeration namingEnumeration = null;
        namingEnumeration = objectArray == null ? this.search(string, string2, n, stringArray, n2, n3) : this.search(string, string2, objectArray, n, stringArray, n2, n3);
        try {
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                if (searchResult == null) continue;
                String string3 = searchResult.getName();
                String string4 = LdapHelper.prepareDN(string3, string);
                if (n != 0 && string.equalsIgnoreCase(string4)) continue;
                Attributes attributes2 = searchResult.getAttributes();
                String string5 = this.iLdapConfigMgr.getEntityType(attributes2, null, string4, null, list);
                String string6 = this.iLdapConfigMgr.getExtIdFromAttributes(string4, string5, attributes2);
                String string7 = this.getUniqueName(string4, string5, attributes2);
                LdapEntry ldapEntry = new LdapEntry(string4, string6, string7, string5, attributes2);
                hashSet.add(ldapEntry);
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "searchEntities");
        }
        if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.exiting(CLASSNAME, "searchEntities", hashSet);
        }
        return hashSet;
    }

    public void setConnectionRequsetControls(Control[] controlArray) {
        this.iConnCtls = controlArray;
    }

    public boolean setCountLimit(int n) {
        if (n >= 0) {
            this.iCountLimit = n;
            return true;
        }
        return false;
    }

    private static String toKey(String string, String string2) {
        int n = string.length() + string2.length() + 2;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string).append("|").append(string2.toLowerCase());
        return stringBuffer.toString();
    }

    private static String toKey(String string) {
        return string.toLowerCase();
    }

    private static String toKey(String string, String string2, SearchControls searchControls) {
        int n = string.length() + string2.length() + 100;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        stringBuffer.append("|");
        stringBuffer.append(string2);
        stringBuffer.append("|");
        stringBuffer.append(searchControls.getSearchScope());
        stringBuffer.append("|");
        stringBuffer.append(searchControls.getCountLimit());
        stringBuffer.append("|");
        stringBuffer.append(searchControls.getTimeLimit());
        String[] stringArray = searchControls.getReturningAttributes();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("|");
                stringBuffer.append(stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    private static String toKey(String string, String string2, Object[] objectArray, SearchControls searchControls) {
        int n;
        int n2 = string.length() + string2.length() + objectArray.length + 200;
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string);
        stringBuffer.append("|");
        stringBuffer.append(string2);
        String[] stringArray = searchControls.getReturningAttributes();
        for (n = 0; n < objectArray.length; ++n) {
            stringBuffer.append("|");
            stringBuffer.append(objectArray[n]);
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append("|");
                stringBuffer.append(stringArray[n]);
            }
        }
        return stringBuffer.toString();
    }

    private static int cloneSearchResults(NamingEnumeration namingEnumeration, CachedNamingEnumeration cachedNamingEnumeration, CachedNamingEnumeration cachedNamingEnumeration2) throws WIMSystemException {
        int n = 0;
        try {
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = (SearchResult)namingEnumeration.nextElement();
                Attributes attributes2 = (Attributes)searchResult.getAttributes().clone();
                SearchResult searchResult2 = new SearchResult(searchResult.getName(), null, null, attributes2);
                cachedNamingEnumeration.add(searchResult);
                cachedNamingEnumeration2.add(searchResult2);
                ++n;
            }
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            trcLogger.logp(Level.FINE, CLASSNAME, "cloneSearchResults(NamingEnumeration, CachedNamingEnumeration, CachedNamingEnumeration)", sizeLimitExceededException.toString(true), sizeLimitExceededException);
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "cloneSearchResults(NamingEnumeration, CachedNamingEnumeration, CachedNamingEnumeration)");
        }
        return n;
    }

    private String printAttributes(Attributes attributes2) {
        if (attributes2 == null) {
            return "null";
        }
        Set set = this.iLdapConfigMgr.getConfidentialAttributes();
        HashSet<Object> hashSet = new HashSet<Object>(set.size());
        Object object = attributes2.getIDs();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (!set.contains(string.toLowerCase())) continue;
            hashSet.add(string);
        }
        if (hashSet.size() == 0) {
            return attributes2.toString();
        }
        object = (Attributes)attributes2.clone();
        for (String string : hashSet) {
            BasicAttribute basicAttribute = new BasicAttribute(string, "****");
            object.put(basicAttribute);
        }
        return object.toString();
    }

    private String printModificationItem(ModificationItem[] modificationItemArray) {
        if (modificationItemArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(400);
        Set set = this.iLdapConfigMgr.getConfidentialAttributes();
        stringBuffer.append("[");
        for (int i = 0; i < modificationItemArray.length; ++i) {
            ModificationItem modificationItem = modificationItemArray[i];
            if (modificationItem != null) {
                Attribute attribute = modificationItem.getAttribute();
                if (attribute != null && set.contains(attribute.getID().toLowerCase())) {
                    BasicAttribute basicAttribute = new BasicAttribute(attribute.getID(), "****");
                    stringBuffer.append(new ModificationItem(modificationItem.getModificationOp(), basicAttribute));
                } else {
                    stringBuffer.append(modificationItem);
                }
            } else {
                stringBuffer.append("null");
            }
            if (i == modificationItemArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public List getAncestorDNs(String string, int n) throws WIMException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            NameParser nameParser = this.getNameParser();
            Name name2 = nameParser.parse(string);
            int n2 = name2.size();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (n == 0) {
                n = n2;
            }
            for (int i = n2 - 1; i >= n2 - n; --i) {
                name2.remove(i);
                arrayList.add(name2.toString());
            }
            return arrayList;
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getAncestorDNs");
        }
    }

    public String getUniqueName(String string, String string2, Attributes attributes2) throws WIMException {
        String string3 = null;
        string = this.iLdapConfigMgr.switchToNode(string);
        if (this.iLdapConfigMgr.needTranslateRDN() && this.iLdapConfigMgr.needTranslateRDN(string2)) {
            try {
                LdapEntity ldapEntity;
                if (string2 != null && (ldapEntity = this.iLdapConfigMgr.getLdapEntity(string2)) != null) {
                    String[] stringArray = LdapHelper.getRDNAttributes(string);
                    String[][] stringArray2 = ldapEntity.getWIMRDNProperties();
                    String[][] stringArray3 = ldapEntity.getWIMRDNAttributes();
                    String[][] stringArray4 = ldapEntity.getRDNAttributes();
                    Attribute[] attributeArray = new Attribute[stringArray2.length];
                    String[] stringArray5 = new String[stringArray2.length];
                    for (int i = 0; i < stringArray4.length; ++i) {
                        int n;
                        String[] stringArray6 = stringArray4[i];
                        boolean bl = true;
                        for (int j = 0; j < stringArray6.length; ++j) {
                            if (stringArray6[j].equalsIgnoreCase(stringArray[j])) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        String[] stringArray7 = stringArray2[i];
                        String[] stringArray8 = stringArray3[i];
                        boolean bl2 = false;
                        if (attributes2 == null) {
                            bl2 = true;
                        } else {
                            for (n = 0; n < stringArray8.length; ++n) {
                                if (attributes2.get(stringArray8[n]) != null) continue;
                                bl2 = true;
                                break;
                            }
                        }
                        if (bl2) {
                            attributes2 = this.getAttributes(string, stringArray8);
                        }
                        for (n = 0; n < stringArray8.length; ++n) {
                            attributeArray[n] = attributes2.get(stringArray8[n]);
                            if (attributeArray[n] == null) continue;
                            stringArray5[n] = (String)attributeArray[n].get();
                        }
                        string3 = LdapHelper.replaceRDN(string, stringArray7, stringArray5);
                    }
                }
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getUniqueName");
            }
        }
        if (string3 == null) {
            string3 = string;
        } else if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "getUniqueName", "Translated uniqueName: " + string3);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dynamicUpdateConfig(String string, Hashtable hashtable) throws WIMException {
        if ("websphere.usermanager.serviceprovider.update.ldap.bindinfo".equalsIgnoreCase(string)) {
            Object object;
            DataObject dataObject = (DataObject)hashtable.get("DYNA_CONFIG_KEY_REPOS_CONFIG");
            Hashtable<String, Object> hashtable2 = null;
            if (dataObject != null) {
                object = dataObject.getDataObject("ldapServerConfiguration");
                List list = object.getList("ldapServers");
                DataObject dataObject2 = (DataObject)list.get(0);
                hashtable2 = this.initializeEnvironmentProperties(dataObject2);
            } else {
                object = (String)hashtable.get("DYNA_CONFIG_KEY_LDAP_BIND_DN");
                byte[] byArray = (byte[])hashtable.get("DYNA_CONFIG_KEY_LDAP_BIND_PASSWORD");
                hashtable2 = new Hashtable<String, Object>(this.iEnvironment);
                if (object != null) {
                    hashtable2.put("java.naming.security.principal", object);
                }
                hashtable2.put("java.naming.security.credentials", byArray);
            }
            try {
                object = this.createDirContext(hashtable2);
                object.close();
            }
            catch (NamingException namingException) {
                throw new DynamicUpdateConfigException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "dynamicUpdateConfig");
            }
            if (dataObject != null) {
                this.initializeContextPool(dataObject.getDataObject("contextPool"));
            }
            try {
                object = lock;
                synchronized (object) {
                    this.iEnvironment = hashtable2;
                    this.createContextPool(this.iInitPoolSize, null);
                }
            }
            catch (NamingException namingException) {
                throw new DynamicUpdateConfigException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "dynamicUpdateConfig");
            }
        }
    }

    private void supportRangeAttributes(Attributes attributes2, String string, DirContext dirContext) throws WIMException, NamingException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "supportRangeAttributes");
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)namingEnumeration.nextElement();
            String string2 = attribute.getID();
            int n = string2.indexOf(ATTR_RANGE_KEYWORD);
            if (n <= -1) continue;
            String string3 = string2.substring(0, n);
            BasicAttribute basicAttribute = new BasicAttribute(string3);
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "supportRangeAttributes", "Range attriute retrieved: " + string2);
            }
            NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
            while (namingEnumeration2.hasMoreElements()) {
                basicAttribute.add(namingEnumeration2.nextElement());
            }
            int n2 = this.iAttrRangeStep;
            try {
                n2 = Integer.parseInt(string2.substring(string2.indexOf(45) + 1)) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n3 = n2 + this.iAttrRangeStep - 1;
            boolean bl = false;
            boolean bl2 = false;
            do {
                Object[] objectArray;
                Object object;
                String string4 = null;
                if (!bl2) {
                    object = new Object[]{new Integer(n2).toString(), new Integer(n3).toString()};
                    string4 = string3 + MessageFormat.format(ATTR_RANGE_QUERY, (Object[])object);
                } else {
                    object = new Object[]{new Integer(n2).toString()};
                    string4 = string3 + MessageFormat.format(ATTR_RANGE_LAST_QUERY, (Object[])object);
                }
                object = null;
                Object[] objectArray2 = new String[]{string4};
                try {
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.entering(CLASSNAME, "JNDI_CALL getAttributes(String, String[])", WIMMessageHelper.generateMsgParms(string, WIMTraceHelper.printObjectArray(objectArray2)));
                    }
                    object = dirContext.getAttributes(new LdapName(string), (String[])objectArray2);
                    if (trcLogger.isLoggable(Level.FINE)) {
                        trcLogger.exiting(CLASSNAME, "JNDI_CALL getAttributes(String, String[])", object.toString());
                    }
                }
                catch (NamingException namingException) {
                    if (namingException instanceof CommunicationException || namingException instanceof ServiceUnavailableException) {
                        dirContext = this.reCreateDirContext(dirContext, namingException.toString());
                        object = dirContext.getAttributes(new LdapName(string), (String[])objectArray2);
                    }
                    throw namingException;
                }
                Attribute attribute2 = object.get(string4);
                if (attribute2 == null) {
                    objectArray = new Object[]{new Integer(n2).toString()};
                    string4 = string3 + MessageFormat.format(ATTR_RANGE_LAST_QUERY, objectArray);
                    attribute2 = object.get(string4);
                    bl2 = true;
                }
                if (attribute2 != null) {
                    objectArray = attribute2.getAll();
                    while (objectArray.hasMoreElements()) {
                        basicAttribute.add(objectArray.nextElement());
                    }
                    if (!bl2) continue;
                    bl = true;
                    continue;
                }
                bl2 = true;
            } while (!bl);
            attributes2.put(basicAttribute);
            attributes2.remove(string2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "supportRangeAttributes");
        }
    }
}

