/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.ldap;

import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.wim.ConfigConstants;
import com.ibm.websphere.wim.SchemaConstants;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.adapter.ldap.LdapConstants;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LdapConnectionBase
implements ConfigConstants,
SchemaConstants,
LdapConstants {
    protected String iSSLFactory = null;
    public static final String WIM_SSL_SOCKE_FACTORY = "com.ibm.ws.security.registry.ldap.LdapSSLSocketFactory";
    public static final String JNDI_CALL = "JNDI_CALL ";
    public static final String WAS_SSL_SOCKE_FACTORY = "com.ibm.websphere.ssl.protocol.SSLSocketFactory";
    private static final String CLASSNAME = LdapConnectionBase.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public static void setWASSSLAlias(String string, Hashtable hashtable) throws WIMConfigurationException {
        trcLogger.entering(CLASSNAME, "setWASSSLAlias");
        try {
            HashMap<String, String> hashMap = null;
            String string2 = (String)hashtable.get("java.naming.provider.url");
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                string2 = stringTokenizer.nextToken();
                string2 = string2.replaceFirst("ldap", "http");
                URL uRL = new URL(string2);
                hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.ssl.direction", "outbound");
                hashMap.put(JSSEHelper.CONNECTION_INFO_REMOTE_HOST, uRL.getHost());
                hashMap.put(JSSEHelper.CONNECTION_INFO_REMOTE_PORT, uRL.getPort() == -1 ? "636" : Integer.toString(uRL.getPort()));
            }
            Properties properties = hashMap != null ? JSSEHelper.getInstance().getProperties(string, hashMap, null) : JSSEHelper.getInstance().getProperties(string);
            JSSEHelper.getInstance().setSSLPropertiesOnThread(properties);
            trcLogger.logp(Level.CONFIG, CLASSNAME, "setWASSSLAlias", "Properties for SSL Alias '" + string + "':" + properties);
        }
        catch (Exception exception) {
            throw new WIMConfigurationException("INVALID_INIT_PROPERTY", WIMMessageHelper.generateMsgParms("sslConfiguration"), CLASSNAME, "setWASSSLAlias", (Throwable)exception);
        }
        trcLogger.exiting(CLASSNAME, "setWASSSLAlias");
    }

    public static void resetWASSSLAlias() {
        JSSEHelper.getInstance().setSSLPropertiesOnThread(null);
    }
}

