/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.ldap;

import com.ibm.websphere.wim.exception.MissingInitPropertyException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.adapter.ldap.LdapHelper;
import com.ibm.ws.wim.util.NodeHelper;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;

public class LdapEntity {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LdapEntity.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private String iQEntityType = null;
    private String[][] iWIMRDNProps = null;
    private String[][] iWIMRDNAttrs = null;
    private String[][] iRDNAttrs = null;
    private String[] iRDNObjectClass = null;
    private List iObjectClasses = null;
    private Attribute[] iObjectClassAttrs = null;
    private String[] iSearchBases = null;
    private List iSearchBaseList = null;
    private String iSearchFilter = null;
    private Set iProps = null;
    private Map iPropToAttrMap = null;
    private Map iAttrToPropMap = null;
    private String iExtId = null;
    private boolean iTranslatedRDN = false;
    private Set iAttrs = null;

    public LdapEntity(DataObject dataObject) throws WIMException {
        this.iQEntityType = dataObject.getString("name");
        this.setRDNAttributes(dataObject.getList("rdnAttributes"));
        this.setObjectClasses(dataObject.getList("objectClasses"));
        this.setObjectClassesForCreate(dataObject.getList("objectClassesForCreate"));
        this.setSearchBases(dataObject.getList("searchBases"));
        this.setSearchFilter(dataObject.getString("searchFilter"));
        this.iAttrToPropMap = new Hashtable();
        this.iPropToAttrMap = new Hashtable();
        this.iAttrs = new HashSet();
        this.iProps = new HashSet();
    }

    public LdapEntity(String string) throws WIMException {
        this.iQEntityType = string;
        this.iAttrToPropMap = new Hashtable();
        this.iPropToAttrMap = new Hashtable();
        this.iAttrs = new HashSet();
        this.iProps = new HashSet();
    }

    public String getName() {
        return this.iQEntityType;
    }

    public void setObjectClasses(List list) {
        int n = list.size();
        this.iObjectClasses = new ArrayList(list.size());
        for (int i = 0; i < n; ++i) {
            String string = ((String)list.get(i)).toLowerCase();
            if (this.iObjectClasses.contains(string)) continue;
            this.iObjectClasses.add(string);
        }
    }

    public void setObjectClassesForCreate(List list) {
        if (this.iRDNObjectClass != null && this.iRDNObjectClass.length > 1) {
            int n;
            this.iObjectClassAttrs = new Attribute[this.iRDNObjectClass.length];
            for (n = 0; n < this.iRDNObjectClass.length; ++n) {
                this.iObjectClassAttrs[n] = new BasicAttribute("objectClass", this.iRDNObjectClass[n]);
                list.remove(this.iRDNObjectClass[n]);
            }
            for (n = 0; n < this.iObjectClassAttrs.length; ++n) {
                for (int i = 0; i < list.size(); ++i) {
                    this.iObjectClassAttrs[n].add(list.get(i));
                }
            }
        } else {
            this.iObjectClassAttrs = new Attribute[1];
            this.iObjectClassAttrs[0] = new BasicAttribute("objectClass");
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    this.iObjectClassAttrs[0].add(list.get(i));
                }
            } else {
                for (int i = 0; i < this.iObjectClasses.size(); ++i) {
                    this.iObjectClassAttrs[0].add((String)this.iObjectClasses.get(i));
                }
            }
        }
    }

    public Attribute getObjectClassAttribute(String string) {
        if (this.iObjectClassAttrs.length == 1 || string == null) {
            return this.iObjectClassAttrs[0];
        }
        String[] stringArray = LdapHelper.getRDNAttributes(string);
        for (int i = 0; i < this.iRDNAttrs.length; ++i) {
            String[] stringArray2 = this.iRDNAttrs[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                for (int k = 0; k < stringArray2.length; ++k) {
                    if (!stringArray2[j].equals(stringArray[k])) continue;
                    return this.iObjectClassAttrs[i];
                }
            }
        }
        return null;
    }

    public boolean startWithSameRDN(String string) {
        string = string.toLowerCase();
        String[][] stringArray = this.iRDNAttrs != null ? this.iRDNAttrs : this.iWIMRDNAttrs;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!string.startsWith(stringArray2[j])) continue;
                return true;
            }
        }
        return false;
    }

    public List getObjectClasses() {
        return this.iObjectClasses;
    }

    public String[][] getRDNAttributes() {
        if (this.iRDNAttrs == null) {
            return this.iWIMRDNAttrs;
        }
        return this.iRDNAttrs;
    }

    public List getRDNAttributesList() {
        String[][] stringArray = this.getRDNAttributes();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                arrayList.add(stringArray[i][j]);
            }
        }
        return arrayList;
    }

    public String[][] getWIMRDNAttributes() {
        return this.iWIMRDNAttrs;
    }

    public String[][] getWIMRDNProperties() {
        return this.iWIMRDNProps;
    }

    public void setRDNAttributes(String[][] stringArray, String[] stringArray2) {
        this.iRDNAttrs = stringArray;
        this.iRDNObjectClass = stringArray2;
    }

    public void setRDNAttributes(List list) throws MissingInitPropertyException {
        int n = list.size();
        if (n > 0) {
            this.iRDNAttrs = new String[n][];
            this.iRDNObjectClass = new String[n];
            if (n == 1) {
                DataObject dataObject = (DataObject)list.get(0);
                String[] stringArray = LdapHelper.getRDNs(dataObject.getString("name"));
                this.iRDNAttrs[0] = stringArray;
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    DataObject dataObject = (DataObject)list.get(i);
                    String string = dataObject.getString("name");
                    String[] stringArray = LdapHelper.getRDNs(dataObject.getString("name"));
                    this.iRDNAttrs[i] = stringArray;
                    String string2 = dataObject.getString("objectClass");
                    if (string2 == null) {
                        throw new MissingInitPropertyException("MISSING_INI_PROPERTY", WIMMessageHelper.generateMsgParms("objectClass"), CLASSNAME, "setRDNAttributes");
                    }
                    this.iRDNObjectClass[i] = string2.toLowerCase();
                }
            }
        }
    }

    public void setSearchBases(List list) {
        if (list.size() > 0) {
            this.iSearchBases = new String[0];
            this.iSearchBases = list.toArray(this.iSearchBases);
            this.iSearchBases = NodeHelper.getTopNodes(this.iSearchBases);
            this.iSearchBaseList = new ArrayList(this.iSearchBases.length);
            for (int i = 0; i < this.iSearchBases.length; ++i) {
                this.iSearchBaseList.add(this.iSearchBases[i]);
            }
        }
    }

    public void setSearchBases(String[] stringArray) {
        this.iSearchBases = stringArray;
        this.iSearchBaseList = new ArrayList(this.iSearchBases.length);
        for (int i = 0; i < this.iSearchBases.length; ++i) {
            this.iSearchBaseList.add(this.iSearchBases[i]);
        }
    }

    public String[] getSearchBases() {
        return this.iSearchBases;
    }

    public List getSearchBaseList() {
        return this.iSearchBaseList;
    }

    public void setSearchFilter(String string) {
        if (string != null && string.trim().length() > 0) {
            if ((string = string.trim()).length() > 0) {
                if (string.charAt(0) != '(' || string.charAt(string.length() - 1) != ')') {
                    string = "(" + string + ")";
                }
                this.iSearchFilter = string;
            }
        } else {
            int n = this.iObjectClasses.size();
            StringBuffer stringBuffer = new StringBuffer(n * 20);
            if (n > 1) {
                stringBuffer.append("(|");
            }
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("(").append("objectClass").append("=").append(this.iObjectClasses.get(i)).append(")");
            }
            if (n > 1) {
                stringBuffer.append(")");
            }
            this.iSearchFilter = stringBuffer.toString();
        }
    }

    public String getSearchFilter() {
        return this.iSearchFilter;
    }

    public Set getProperty(String string) {
        return (Set)this.iAttrToPropMap.get(string.toLowerCase());
    }

    public String getAttribute(String string) {
        Object v = this.iPropToAttrMap.get(string);
        if (v != null) {
            return (String)v;
        }
        return null;
    }

    public void addPropertyAttributeMap(String string, String string2) {
        String string3 = string;
        if (string.equalsIgnoreCase("ibm-primaryEmail")) {
            string3 = "ibmPrimaryEmail";
        } else if (string.equalsIgnoreCase("ibm-jobTitle")) {
            string3 = "ibmJobTitle";
        }
        if (string.equalsIgnoreCase("ibmPrimaryEmail") && string2.equalsIgnoreCase("ibmPrimaryEmail")) {
            string2 = "ibm-primaryEmail";
        }
        if (string.equalsIgnoreCase("ibmJobTitle") && string2.equalsIgnoreCase("ibmJobTitle")) {
            string2 = "ibm-jobTitle";
        }
        if (string.equalsIgnoreCase("ibm-primaryEmail") || string.equalsIgnoreCase("ibm-jobTitle")) {
            this.iPropToAttrMap.put(string3, string2);
            this.iPropToAttrMap.put(string, string2);
        } else {
            this.iPropToAttrMap.put(string3, string2);
        }
        String string4 = string2.toLowerCase();
        HashSet<String> hashSet = (HashSet<String>)this.iAttrToPropMap.get(string4);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.iAttrToPropMap.put(string4, hashSet);
        }
        if (string.equalsIgnoreCase("ibm-primaryEmail") || string.equalsIgnoreCase("ibm-jobTitle")) {
            hashSet.add(string3);
            hashSet.add(string);
            this.addProperty(string);
            this.addProperty(string3);
        } else {
            hashSet.add(string3);
            this.addProperty(string3);
        }
        this.addAttribute(string2);
    }

    public void setExtId(String string) {
        this.iExtId = string;
    }

    public String getExtId() {
        return this.iExtId;
    }

    public void setRDNProperties(String[][] stringArray, String[][] stringArray2) {
        this.iWIMRDNAttrs = stringArray2;
        this.iWIMRDNProps = stringArray;
        if (this.iRDNAttrs != null) {
            if (this.iRDNAttrs.length != this.iWIMRDNAttrs.length) {
                this.iTranslatedRDN = true;
                return;
            }
            for (int i = 0; i < this.iRDNAttrs.length; ++i) {
                if (Arrays.equals(this.iRDNAttrs[i], this.iWIMRDNAttrs[i])) continue;
                this.iTranslatedRDN = true;
                return;
            }
        } else {
            for (int i = 0; i < this.iWIMRDNAttrs.length; ++i) {
                if (Arrays.equals(this.iWIMRDNAttrs[i], this.iWIMRDNProps[i])) continue;
                this.iTranslatedRDN = true;
                return;
            }
        }
    }

    public void addObjectClass(String string) {
        if (!this.iObjectClasses.contains(string = string.toLowerCase())) {
            this.iObjectClasses.add(string);
        }
    }

    private void addAttribute(String string) {
        this.iAttrs.add(string);
    }

    private void addProperty(String string) {
        this.iProps.add(string);
    }

    public Set getAttributes() {
        return this.iAttrs;
    }

    public Set getProperties() {
        return this.iProps;
    }

    public boolean needTranslateRDN() {
        return this.iTranslatedRDN;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nEntityType: ").append(this.iQEntityType).append("\n");
        stringBuffer.append("\tWIMRDNProps: ").append(WIMTraceHelper.printObjectArray((Object[])this.iWIMRDNProps)).append("\n");
        stringBuffer.append("\tWIMRDNAttrs: ").append(WIMTraceHelper.printObjectArray((Object[])this.iWIMRDNAttrs)).append("\n");
        stringBuffer.append("\tRDNAttrs: ").append(WIMTraceHelper.printObjectArray((Object[])this.iRDNAttrs)).append("\n");
        stringBuffer.append("\tRDNObjectClasses: ").append(WIMTraceHelper.printObjectArray(this.iRDNObjectClass)).append("\n");
        stringBuffer.append("\tNeedTranslateRDN: ").append(this.iTranslatedRDN).append("\n");
        stringBuffer.append("\tObjectClasses: ").append(this.iObjectClasses).append("\n");
        stringBuffer.append("\tObjectClassesForCreate: ").append(WIMTraceHelper.printObjectArray(this.iObjectClassAttrs)).append("\n");
        stringBuffer.append("\tSearchBases: ").append(WIMTraceHelper.printObjectArray(this.iSearchBases)).append("\n");
        stringBuffer.append("\tSearchFilter: ").append(this.iSearchFilter).append("\n");
        stringBuffer.append("\tPropToAttrMap: ").append(this.iPropToAttrMap).append("\n");
        stringBuffer.append("\tAttrToPropMap: ").append(this.iAttrToPropMap).append("\n");
        stringBuffer.append("\tExtIdAttr: ").append(this.iExtId).append("\n");
        stringBuffer.append("\tAttributes: ").append(this.iAttrs).append("\n");
        return stringBuffer.toString();
    }
}

