/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.ldap;

import com.ibm.websphere.wim.exception.CertificateMapperException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.ldap.LdapAttribute;
import com.ibm.ws.wim.adapter.ldap.LdapURL;
import com.ibm.ws.wim.util.Base64Coder;
import com.ibm.ws.wim.util.StringUtil;
import com.sun.jndi.ldap.LdapName;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchControls;

public class LdapHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LdapHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static Map dnCache = new WeakHashMap(256);

    public static String getValidDN(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)dnCache.get(string);
        if (string2 == null) {
            try {
                LdapName ldapName = new LdapName(string);
                string2 = ldapName.getPrefix(ldapName.size()).toString();
                dnCache.put(string, string2);
            }
            catch (InvalidNameException invalidNameException) {
                string2 = null;
            }
        }
        return string2;
    }

    public static String getRDN(String string) {
        if (string == null || string.trim().length() == 0) {
            return string;
        }
        String string2 = null;
        try {
            LdapName ldapName = new LdapName(string);
            if (ldapName.size() == 0) {
                return string;
            }
            string2 = ldapName.get(ldapName.size() - 1);
        }
        catch (InvalidNameException invalidNameException) {
            string = string.trim();
            int n = string.indexOf(44);
            if (string.charAt(n - 1) == '\\') {
                n = string.indexOf(n, 44);
            }
            string2 = n > -1 ? string.substring(0, n).trim() : string;
        }
        return string2;
    }

    public static String getEntityType(String string, Attribute attribute) {
        if (string.startsWith("uid=")) {
            return "Person";
        }
        if (string.startsWith("cn=")) {
            return "Group";
        }
        if (string.startsWith("o=")) {
            return "OrgContainer";
        }
        if (string.startsWith("ou=")) {
            return "OrgContainer";
        }
        return null;
    }

    public static String[] getRDNs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), "+");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] getRDNValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), "+");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n <= -1) continue;
            arrayList.add(string2.substring(n + 1));
        }
        return arrayList.toArray(new String[0]);
    }

    public static Attribute getIngoreCaseAttribute(Attributes attributes2, String string) {
        if (attributes2 == null || string == null) {
            return null;
        }
        NamingEnumeration<String> namingEnumeration = attributes2.getIDs();
        while (namingEnumeration.hasMoreElements()) {
            String string2 = (String)namingEnumeration.nextElement();
            boolean bl = false;
            if (string.equalsIgnoreCase(string2)) {
                bl = true;
            } else {
                int n = string2.indexOf(";");
                if (n > 0 && string.equalsIgnoreCase(string2.substring(0, n))) {
                    bl = true;
                }
            }
            if (!bl) continue;
            return attributes2.get(string2);
        }
        return null;
    }

    public static short getMembershipScope(String string) {
        if (string != null) {
            if ("direct".equalsIgnoreCase(string = string.trim())) {
                return 0;
            }
            if ("nested".equalsIgnoreCase(string)) {
                return 1;
            }
            if ("all".equalsIgnoreCase(string)) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public static byte[] encodePassword(String string) throws WIMSystemException {
        byte[] byArray = null;
        try {
            String string2 = "Unicode";
            String string3 = "\"" + string + "\"";
            byte[] byArray2 = string3.getBytes(string2);
            byArray = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, byArray, 0, byArray2.length - 2);
            if (!(System.getProperty("os.arch").equals("x86") || System.getProperty("os.arch").equals("ia64") || System.getProperty("os.arch").equals("amd64"))) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "byte[] encodePassword(String)", "OS is '" + System.getProperty("os.arch") + "', do special formatting...");
                }
                for (int i = 0; i < byArray.length; i += 2) {
                    byte by = byArray[i];
                    byArray[i] = byArray[i + 1];
                    byArray[i + 1] = by;
                }
            }
        }
        catch (Exception exception) {
            throw new WIMSystemException(CLASSNAME, "byte[] encodePassword(String)", (Throwable)exception);
        }
        return byArray;
    }

    public static byte[] getOctetString(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < string.length() - 1; i += 2) {
            String string2 = string.substring(i, i + 2);
            int n2 = Integer.parseInt(string2, 16);
            byArray[n] = (byte)n2;
            ++n;
        }
        return byArray;
    }

    public static String getDateString(String string) {
        return string;
    }

    public static String getLDAPGeneralTime(Date date) {
        return new SimpleDateFormat("yyyyMMddHHmmss'Z'").format(date);
    }

    public static String getOctetString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String prepareDN(String string, String string2) {
        int n;
        if (string == null || string.trim().length() == 0) {
            return string2;
        }
        string = LdapHelper.unescapeDoubleBackslash(string);
        int n2 = string.length();
        if (string.charAt(0) == '\"' && string.charAt(n2 - 1) == '\"') {
            string = string.substring(1, n2 - 1);
        }
        if (string.startsWith("/")) {
            int n3;
            n = string.indexOf(58);
            if (n > -1 && (n3 = string.indexOf(47, n)) > 0) {
                string = string.substring(n3 + 1);
            }
        } else if (string.toLowerCase().startsWith("ldap://")) {
            int n4;
            int n5;
            n = 0;
            try {
                LdapURL ldapURL = new LdapURL(string);
                if (ldapURL.parsedOK()) {
                    string = ldapURL.get_dn();
                    n = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == 0 && (n5 = string.indexOf(58, "ldap://".length())) > 0 && (n4 = string.indexOf("/", n5)) > 0) {
                string = string.substring(n4 + 1);
            }
        }
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        while (stringTokenizer2.hasMoreTokens()) {
            string4 = stringTokenizer2.nextToken();
        }
        if (!(string3 = string3 != null ? string3.trim() : "").equalsIgnoreCase(string4 = string4 != null ? string4.trim() : "")) {
            string = string.length() > 0 ? string + "," + string2 : string2;
        }
        return string;
    }

    public static String unescapeDoubleBackslash(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string.length();
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '\\' && i + 1 < n && cArray[i + 1] == '\\') {
                ++i;
            }
            stringBuffer.append(cArray[i]);
        }
        return new String(stringBuffer);
    }

    public static String getDNFromAttributes(Attributes attributes2) throws WIMSystemException {
        try {
            Attribute attribute = attributes2.remove("distinguishedName");
            if (attribute != null) {
                return (String)attribute.get();
            }
            return null;
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), CLASSNAME, "getDNFromAttributes(Attributes)");
        }
    }

    public static String[] getRDNAttributes(String string) {
        String string2 = LdapHelper.getRDN(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2.toLowerCase(), "+");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(61);
            if (n <= -1) continue;
            arrayList.add(string3.substring(0, n));
        }
        return arrayList.toArray(new String[0]);
    }

    public static String replaceRDN(String string, String[] stringArray, String[] stringArray2) {
        String string2 = LdapHelper.getParentDN(string);
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length || stringArray.length == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray3 = LdapHelper.getRDNValues(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            if (i != 0) {
                stringBuffer.append("+");
            }
            if ((string3 = stringArray2[i]) == null) {
                string3 = stringArray3[i];
            }
            stringBuffer.append(stringArray[i] + "=" + LdapName.escapeAttributeValue(string3));
        }
        string = string2.length() == 0 ? stringBuffer.toString() : stringBuffer.append("," + string2).toString();
        return string;
    }

    public static String replaceRDN(String string, String string2, String string3) {
        String[] stringArray = new String[]{string2};
        String[] stringArray2 = new String[]{string3};
        return LdapHelper.replaceRDN(string, stringArray, stringArray2);
    }

    public static String getParentDN(String string) {
        String string2 = null;
        if (string == null || string.trim().length() == 0) {
            string2 = "";
        }
        try {
            LdapName ldapName = new LdapName(string);
            if (ldapName.size() == 0) {
                string2 = "";
            }
            ldapName.remove(ldapName.size() - 1);
            string2 = ldapName.toString();
        }
        catch (InvalidNameException invalidNameException) {
            string = string.trim();
            int n = string.indexOf(44);
            if (string.charAt(n - 1) == '\\') {
                n = string.indexOf(n, 44);
            }
            string2 = n > -1 ? string.substring(n + 1).trim() : "";
        }
        return string2;
    }

    public static boolean isUnderBases(String string, String string2) {
        return (string = LdapHelper.getValidDN(string)) != null && (string = string.toLowerCase()).endsWith(string2.toLowerCase());
    }

    public static boolean isEntityTypeInList(String string, List list) throws WIMException {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                if (!string2.equals(string) && !SchemaManager.singleton().isSuperType(string2, string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUnderBases(String string, String[] stringArray) {
        if ((string = LdapHelper.getValidDN(string)) != null) {
            string = string.toLowerCase();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.endsWith(stringArray[i].toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getAccountUniqueName(String string, String string2) {
        String[] stringArray = new String[]{"principalName"};
        String[] stringArray2 = new String[]{string2};
        return LdapHelper.replaceRDN(string, stringArray, stringArray2);
    }

    public static String getAccountExtId(String string) {
        return "account" + string;
    }

    public static Object getStringLdapValue(Object object, LdapAttribute ldapAttribute, String string) throws WIMSystemException {
        Object object2 = null;
        String string2 = (String)object;
        String string3 = "string";
        if (ldapAttribute != null) {
            string3 = ldapAttribute.getSyntax();
        }
        if ("unicodePwd".equalsIgnoreCase(string3)) {
            object2 = LdapHelper.encodePassword(string2);
        } else if ("octetString".equalsIgnoreCase(string3)) {
            try {
                object2 = LdapHelper.getOctetString(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(numberFormatException.toString()), CLASSNAME, "getStringLdapValue(Object, LdapAttribute, String)");
            }
        } else {
            object2 = string2;
        }
        return object2;
    }

    private static Date convertDatetoGMT(Date date) {
        Date date2;
        Date date3;
        TimeZone timeZone = TimeZone.getDefault();
        if (timeZone.inDaylightTime(date3 = new Date(date.getTime() - (long)timeZone.getRawOffset())) && timeZone.inDaylightTime(date2 = new Date(date3.getTime() - (long)timeZone.getDSTSavings()))) {
            date3 = date2;
        }
        return date3;
    }

    public static Object getDateLdapValue(Object object, LdapAttribute ldapAttribute, String string) throws WIMSystemException {
        try {
            String string2 = object.toString();
            Date date = null;
            boolean bl = string2.indexOf("Z") != -1;
            boolean bl2 = string2.indexOf(".") != -1;
            String string3 = null;
            if (bl) {
                date = bl2 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(string2) : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").parse(string2);
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                date = simpleDateFormat.parse(string2);
                date = LdapHelper.convertDatetoGMT(date);
                bl = true;
            }
            if (string.startsWith("IDS")) {
                string3 = bl ? new SimpleDateFormat("yyyyMMddHHmmss.SSSSSS'Z'").format(date) : new SimpleDateFormat("yyyyMMddHHmmss.SSSSSSZ").format(date);
            } else if (string.startsWith("SUNONE") || string.startsWith("DOMINO") || string.startsWith("NDS")) {
                string3 = bl ? new SimpleDateFormat("yyyyMMddHHmmss'Z'").format(date) : new SimpleDateFormat("yyyyMMddHHmmssZ").format(date);
            } else {
                if (bl) {
                    return new SimpleDateFormat("yyyyMMddHHmmss.S'Z'").format(date);
                }
                return new SimpleDateFormat("yyyyMMddHHmmss.SZ").format(date);
            }
            return string3;
        }
        catch (ParseException parseException) {
            throw new WIMSystemException("SYSTEM_EXCEPTION", WIMMessageHelper.generateMsgParms(parseException.toString()), Level.SEVERE, CLASSNAME, "getDateLdapValue(Object, LdapAttribute, String)");
        }
    }

    public static Object getIntLdapValue(Object object, LdapAttribute ldapAttribute, String string) {
        String string2 = null;
        if (object instanceof Integer) {
            string2 = object.toString();
        }
        string2 = object.toString();
        return string2;
    }

    public static String printSearchControls(SearchControls searchControls) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[searchScope: ").append(searchControls.getSearchScope());
        stringBuffer.append(", timeLimit: ").append(searchControls.getTimeLimit());
        stringBuffer.append(", countLimit: ").append(searchControls.getCountLimit());
        stringBuffer.append(", returningObjFlag: ").append(searchControls.getReturningObjFlag());
        stringBuffer.append(", returningAttributes: ").append(WIMTraceHelper.printObjectArray(searchControls.getReturningAttributes())).append("]");
        return stringBuffer.toString();
    }

    public static boolean inAttributes(String string, Attributes attributes2) {
        NamingEnumeration<String> namingEnumeration = attributes2.getIDs();
        while (namingEnumeration.hasMoreElements()) {
            String string2 = (String)namingEnumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static Attribute cloneAttribute(String string, Attribute attribute) throws WIMSystemException {
        BasicAttribute basicAttribute = new BasicAttribute(string);
        try {
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                basicAttribute.add(namingEnumeration.nextElement());
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "cloneAttribute");
        }
        return basicAttribute;
    }

    public static LdapURL[] getLdapURLs(Attribute attribute) throws WIMException {
        LdapURL[] ldapURLArray = new LdapURL[]{};
        if (attribute != null) {
            ArrayList<LdapURL> arrayList = new ArrayList<LdapURL>(attribute.size());
            try {
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    LdapURL ldapURL = new LdapURL((String)namingEnumeration.nextElement());
                    if (ldapURL.parsedOK()) {
                        arrayList.add(ldapURL);
                        continue;
                    }
                    if (!trcLogger.isLoggable(Level.FINE)) continue;
                    trcLogger.logp(Level.FINE, CLASSNAME, "getLdapURLs", "Member URL query: " + ldapURL.get_url() + " is invalid and ingored.");
                }
            }
            catch (NamingException namingException) {
                throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "getLdapURLs");
            }
            ldapURLArray = arrayList.toArray(ldapURLArray);
        }
        return ldapURLArray;
    }

    public static boolean containIngorecaseValue(Attribute attribute, String string) throws WIMSystemException {
        if (attribute == null || string == null) {
            return false;
        }
        try {
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                String string2 = (String)namingEnumeration.nextElement();
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        catch (NamingException namingException) {
            throw new WIMSystemException("NAMING_EXCEPTION", WIMMessageHelper.generateMsgParms(namingException.toString(true)), Level.SEVERE, CLASSNAME, "containIngorecaseValue");
        }
        return false;
    }

    public static String getUniqueKey(X509Certificate x509Certificate) {
        StringBuffer stringBuffer = new StringBuffer("subjectDN:");
        stringBuffer.append(x509Certificate.getSubjectDN().getName()).append("issuerDN:").append(x509Certificate.getIssuerDN().getName());
        return Base64Coder.base64Encode(LdapHelper.getDigest(stringBuffer.toString()));
    }

    private static String getDigest(String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            trcLogger.logp(Level.FINE, CLASSNAME, "getDigest", exception.toString());
            return null;
        }
        messageDigest.update(StringUtil.getBytes(string));
        return StringUtil.toString(messageDigest.digest());
    }

    static String getDNSubField(String string, String string2) throws CertificateMapperException {
        block4: {
            String string3;
            String string4;
            if (string.equals("DN")) {
                return string2;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            do {
                try {
                    string4 = stringTokenizer.nextToken(",= ");
                    string3 = stringTokenizer.nextToken(",");
                    if (string3 == null) continue;
                    string3 = string3.substring(1);
                }
                catch (NoSuchElementException noSuchElementException) {
                    trcLogger.logp(Level.FINE, CLASSNAME, "getDNSubField", noSuchElementException.toString());
                    break block4;
                }
            } while (!string4.equals(string));
            return string3;
        }
        throw new CertificateMapperException("UNKOWN_DN_FIELD", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getDNSubField");
    }

    public static String[] parseFilterDescriptor(String string) throws CertificateMapperException {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n < n3) {
            n = string.indexOf("${", n2);
            if (n == -1) {
                if (n2 >= n3) break;
                vector.addElement(string.substring(n2));
                break;
            }
            if (n2 < n) {
                vector.addElement(string.substring(n2, n));
            }
            if ((n = string.indexOf("}", n2 = n)) == -1) {
                throw new CertificateMapperException("INVALID_CERTIFICATE_FILTER", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "parseFilterDescriptor");
            }
            vector.addElement(string.substring(n2, ++n));
            n2 = n;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String toUpperCase(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.indexOf(223) != -1) {
            char[] cArray = new char[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                cArray[i] = c == '\u00df' ? c : Character.toUpperCase(c);
            }
            string2 = new String(cArray);
        } else {
            string2 = string.toUpperCase();
        }
        return string2;
    }

    public static int getCacheDistPolicyInt(String string) {
        int n = 2;
        if ("none".equalsIgnoreCase(string)) {
            n = 1;
        } else if ("push".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("push_pull".equalsIgnoreCase(string)) {
            n = 4;
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "getCacheDistPolicyInt", "CacheDistPolicy:" + string + "=>" + n);
        }
        return n;
    }
}

