/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.ldap;

import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LdapURL {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LdapURL.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    public static final String SCHEMENAME = "ldap";
    private String ENCODING = "UTF-8";
    private String ldapurl;
    private String scheme;
    private String hostport;
    private String host;
    private String port;
    private String dn;
    private String attributesBuffer;
    private String[] attributes;
    private String scope;
    private String filter;
    private String[] extensions;
    private boolean parsedOK;
    private String parseMsg;
    private boolean parsedone;
    private int length;

    public LdapURL(String string) {
        this.ldapurl = string;
        this.length = string.length();
        this.parsedOK = false;
        this.parseMsg = "Unparsed";
        this.parsedone = false;
    }

    public LdapURL() {
        this.ldapurl = null;
        this.parsedOK = false;
        this.parseMsg = "Unparsed";
        this.parsedone = false;
    }

    private void parse() throws UnsupportedEncodingException {
        int n = this.ldapurl.indexOf("://");
        this.schemeParser(0, n);
        if (this.parsedone) {
            return;
        }
        int n2 = this.ldapurl.indexOf("/", n + 3);
        this.hostPortParser(n + 3, n2);
        if (this.parsedone) {
            return;
        }
        int n3 = this.ldapurl.indexOf("?", n2 + 1);
        this.searchBaseDnParser(n2 + 1, n3);
        if (this.parsedone) {
            return;
        }
        int n4 = this.ldapurl.indexOf("?", n3 + 1);
        this.attributesParser(n3 + 1, n4);
        if (this.parsedone) {
            return;
        }
        int n5 = this.ldapurl.indexOf("?", n4 + 1);
        this.scopeParser(n4 + 1, n5);
        if (this.parsedone) {
            return;
        }
        int n6 = this.ldapurl.indexOf("?", n5 + 1);
        this.filterParser(n5 + 1, n6);
        if (this.parsedone) {
            return;
        }
        this.extensionsParser(n6 + 1);
        if (this.parsedone) {
            return;
        }
    }

    private void schemeParser(int n, int n2) {
        if (n2 > n) {
            this.scheme = this.ldapurl.substring(n, n2);
            if (this.scheme.compareToIgnoreCase(SCHEMENAME) == 0) {
                this.parseMsg = "scheme parsed";
            } else {
                this.parseMsg = "invalid ldap url";
                this.parsedone = true;
            }
        } else {
            this.parseMsg = "invalid ldap url";
            this.parsedone = true;
        }
    }

    private void hostPortParser(int n, int n2) throws UnsupportedEncodingException {
        if (n2 > n) {
            this.hostport = this.ldapurl.substring(n, n2);
            this.hostPortSubParser();
            this.parseMsg = "hostport parsed";
        } else if (n2 == n) {
            this.parseMsg = "no hostport";
        } else if (n2 == -1) {
            if (this.length >= n + 1) {
                this.hostport = this.ldapurl.substring(n);
                this.hostPortSubParser();
                this.parseMsg = "hostport parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void hostPortSubParser() throws UnsupportedEncodingException {
        if (this.hostport.length() > 0) {
            int n = this.hostport.lastIndexOf(":");
            if (n == -1) {
                this.host = URLDecoder.decode(this.hostport, this.ENCODING);
            } else {
                String string = this.hostport.substring(0, n);
                this.host = URLDecoder.decode(string, this.ENCODING);
                String string2 = this.hostport.substring(n + 1);
                this.port = URLDecoder.decode(string2, this.ENCODING);
            }
        }
    }

    private void searchBaseDnParser(int n, int n2) throws UnsupportedEncodingException {
        if (n2 > n) {
            String string = this.ldapurl.substring(n, n2);
            this.dn = URLDecoder.decode(string, this.ENCODING);
            this.parseMsg = "dn parsed";
        } else if (n2 == n) {
            this.parseMsg = "invalid ldap url";
            this.parsedone = true;
        } else if (n2 == -1) {
            if (this.length >= n + 1) {
                String string = this.ldapurl.substring(n);
                this.dn = URLDecoder.decode(string, this.ENCODING);
                this.parseMsg = "dn parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void attributesParser(int n, int n2) {
        if (n2 > n) {
            this.attributesBuffer = this.ldapurl.substring(n, n2);
            this.attributesSubParser();
            this.parseMsg = "attributes parsed";
        } else if (n2 == n) {
            this.parseMsg = "no attributes";
        } else if (n2 == -1) {
            if (this.length >= n + 1) {
                this.attributesBuffer = this.ldapurl.substring(n);
                this.attributesSubParser();
                this.parseMsg = "attributes parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void attributesSubParser() {
        int n = 0;
        int n2 = this.attributesBuffer.length();
        int n3 = 0;
        n = 0;
        while (n2 > n3 + 1) {
            int n4 = this.attributesBuffer.indexOf(",", n3);
            if (n4 > 0) {
                this.attributes[n] = this.attributesBuffer.substring(n3, n4);
            } else if (n4 == -1) {
                this.attributes[n] = this.attributesBuffer.substring(n3);
                break;
            }
            n3 = n4 + 1;
            ++n;
        }
    }

    private void scopeParser(int n, int n2) {
        if (n2 > n) {
            this.scope = this.ldapurl.substring(n, n2);
            this.parseMsg = "scope parsed";
        } else if (n2 == n) {
            this.parseMsg = "no scope";
        } else if (n2 == -1) {
            if (this.length >= n + 1) {
                this.scope = this.ldapurl.substring(n);
                this.parseMsg = "scope parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void filterParser(int n, int n2) throws UnsupportedEncodingException {
        if (n2 > n) {
            String string = this.ldapurl.substring(n, n2);
            this.filter = URLDecoder.decode(string, this.ENCODING);
            this.parseMsg = "filter parsed";
        } else if (n2 == n) {
            this.parseMsg = "no filter";
        } else if (n2 == -1) {
            if (this.length >= n + 1) {
                String string = this.ldapurl.substring(n);
                this.filter = URLDecoder.decode(string, this.ENCODING);
                this.parseMsg = "filter parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void extensionsParser(int n) {
        if (this.length >= n + 1) {
            String string = this.ldapurl.substring(n);
            int n2 = 0;
            int n3 = string.length();
            int n4 = 0;
            n2 = 0;
            while (n3 > n4 + 1) {
                int n5 = string.indexOf(",", n4);
                if (n5 > 0) {
                    this.extensions[n2] = string.substring(n4, n5);
                } else if (n5 == -1) {
                    this.extensions[n2] = string.substring(n4);
                    break;
                }
                n4 = n5 + 1;
                ++n2;
            }
            this.parseMsg = "extensions parsed";
        }
        this.parsedOK = true;
        this.parsedone = true;
    }

    public boolean parsedOK() throws WIMSystemException {
        String string = "parsedOK";
        try {
            if (!this.parsedone) {
                this.parse();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            trcLogger.logp(Level.SEVERE, CLASSNAME, string, unsupportedEncodingException.toString());
            throw new WIMSystemException("GENERIC", WIMMessageHelper.generateMsgParms(unsupportedEncodingException.toString()), CLASSNAME, string);
        }
        catch (Exception exception) {
            this.parsedOK = false;
        }
        return this.parsedOK;
    }

    public String get_parseMsg() {
        return this.parseMsg;
    }

    public String get_url() {
        return this.ldapurl;
    }

    public String get_host() {
        return this.host;
    }

    public String get_port() {
        return this.port;
    }

    public String get_dn() {
        return this.dn;
    }

    public String[] get_attributes() {
        return this.attributes;
    }

    public String get_scope() {
        return this.scope;
    }

    public String get_filter() {
        return this.filter;
    }

    public int get_searchScope() {
        int n = 0;
        String string = this.get_scope();
        if (string != null) {
            if (string.compareToIgnoreCase("base") == 0) {
                n = 0;
            } else if (string.compareToIgnoreCase("one") == 0) {
                n = 1;
            } else if (string.compareToIgnoreCase("sub") == 0) {
                n = 2;
            }
        }
        return n;
    }

    public String[] get_extensions() {
        return this.extensions;
    }

    public void dump() {
        trcLogger.log(Level.FINER, "---- URL Dump ---- ");
        trcLogger.log(Level.FINER, "URL: " + this.ldapurl);
        trcLogger.log(Level.FINER, "Parse message: " + this.parseMsg);
        trcLogger.log(Level.FINER, "host: " + this.host);
        trcLogger.log(Level.FINER, "port: " + this.port);
        trcLogger.log(Level.FINER, "DN: " + this.dn);
        trcLogger.log(Level.FINER, "scope: " + this.scope);
        trcLogger.log(Level.FINER, "filter: " + this.filter);
        trcLogger.log(Level.FINER, "attributes: ");
        for (int i = 0; i < this.attributes.length; ++i) {
            trcLogger.log(Level.FINER, "    " + this.attributes[i]);
        }
    }

    public String toString() {
        return this.ldapurl;
    }
}

