/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.ldap;

import javax.naming.NamingException;
import javax.naming.ldap.Control;

public class PagedResultsControl
implements Control {
    static final long serialVersionUID = -6415779103893000950L;
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String OID = "1.2.840.113556.1.4.319";
    int pageSize;
    private int ASN_BOOL = 1;
    private int ASN_INT = 2;
    private int ASN_OCTETS = 4;
    private int ASN_SEQ = 48;
    private byte[] value;
    private byte[] cookie;
    private int resultSize;

    public PagedResultsControl(int n) throws NamingException {
        this(n, new byte[0]);
    }

    public PagedResultsControl(int n, byte[] byArray) throws NamingException {
        this.pageSize = n;
        this.cookie = byArray;
        this.encode();
    }

    public PagedResultsControl(byte[] byArray) throws NamingException {
        this.value = byArray;
        this.decode();
    }

    public String getID() {
        return OID;
    }

    public byte[] getEncodedValue() {
        return this.value;
    }

    public boolean isCritical() {
        return true;
    }

    public byte[] getCookie() {
        if (this.cookie.length == 0) {
            return new byte[0];
        }
        return this.cookie;
    }

    private void encode() {
        byte[] byArray = new byte[this.cookie.length + 20];
        int n = byArray.length - 1;
        System.arraycopy(this.cookie, 0, byArray, n -= this.cookie.length, this.cookie.length);
        byArray[--n] = (byte)this.cookie.length;
        if (this.cookie.length > 127) {
            byArray[--n] = (byte)(this.cookie.length >> 8);
            if (this.cookie.length > Short.MAX_VALUE) {
                byArray[--n] = (byte)(this.cookie.length >> 16);
                byArray[--n] = -125;
            } else {
                byArray[--n] = -126;
            }
        }
        byArray[--n] = (byte)this.ASN_OCTETS;
        byArray[--n] = (byte)this.pageSize;
        int n2 = n--;
        if (this.pageSize > 127) {
            byArray[n] = (byte)(this.pageSize >> 8);
        }
        if (this.pageSize > Short.MAX_VALUE) {
            byArray[--n] = (byte)(this.pageSize >> 16);
        }
        byArray[--n] = (byte)(n2 - n);
        byArray[--n] = (byte)this.ASN_INT;
        int n3 = byArray.length - 1 - n;
        byArray[--n] = (byte)n3;
        if (n3 > 127) {
            byArray[--n] = (byte)(n3 >> 8);
            if (n3 > Short.MAX_VALUE) {
                byArray[--n] = (byte)(n3 >> 16);
                byArray[--n] = -125;
            } else {
                byArray[--n] = -126;
            }
        }
        byArray[--n] = (byte)this.ASN_SEQ;
        this.value = new byte[byArray.length - 1 - n];
        System.arraycopy(byArray, n, this.value, 0, this.value.length);
    }

    private void decode() throws NamingException {
        int n;
        int n2 = 0;
        if (this.value[n2++] != this.ASN_SEQ) {
            throw new NamingException("Illegal PagedResultsControl value");
        }
        if ((n = this.value[n2++] & 0xFF) > 127) {
            n2 += n - 128;
        }
        if (this.value[n2++] != this.ASN_INT) {
            throw new NamingException("Illegal PagedResultsControl value");
        }
        if ((n = this.value[n2++] & 0xFF) > 4) {
            throw new NamingException("Illegal PagedResultsControl value");
        }
        this.pageSize = 0;
        while (n-- > 0) {
            this.pageSize = (this.pageSize << 8) + (this.value[n2++] & 0xFF);
        }
        if (this.value[n2++] != this.ASN_OCTETS) {
            throw new NamingException("Illegal PagedResultsControl value");
        }
        if ((n = this.value[n2++] & 0xFF) > 127) {
            int n3 = n - 128;
            n = 0;
            while (n3-- > 0) {
                n = (n << 8) + (this.value[n2++] & 0xFF);
            }
        }
        this.cookie = new byte[n];
        System.arraycopy(this.value, n2, this.cookie, 0, this.cookie.length);
    }

    public int getResultSize() {
        return this.resultSize;
    }
}

