/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.urbridge;

import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.wim.exception.CertificateMapNotSupportedException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InitializationException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.exception.PasswordCheckFailedException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.registry.zOS.SAFRegistryImpl;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.urbridge.URBridgeEntity;
import com.ibm.ws.wim.adapter.urbridge.URBridgeEntityFactory;
import com.ibm.ws.wim.adapter.urbridge.URBridgeHelper;
import com.ibm.ws.wim.adapter.urbridge.URBridgeXPathHelper;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.wsspi.wim.Repository;
import com.ibm.wsspi.wim.RepositoryImpl;
import commonj.sdo.DataObject;
import java.io.ByteArrayInputStream;
import java.rmi.RemoteException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URBridge
extends RepositoryImpl
implements Repository {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    public static final String CLASSNAME = URBridge.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private UserRegistry reg = null;
    private Map attrMap = null;
    private String baseEntryName = null;
    private Map entityConfigMap = null;
    private String reposId = null;
    private SchemaManager schemaMgr = null;
    private Properties customPropertyMap = null;
    private String personAccountType = null;
    private String groupAccountType = null;
    static VariableMap variableMap = null;
    static String registryPropsFile = "/com/ibm/ws/security/registry/wsregistries.properties";

    private void setMapping() {
        this.attrMap = new HashMap(6);
        this.attrMap.put("groupSecurityNameProperty", this.customPropertyMap.get("groupSecurityNameProperty") == null ? "uniqueName" : this.customPropertyMap.get("groupSecurityNameProperty"));
        this.attrMap.put("groupDisplayNameProperty", this.customPropertyMap.get("groupDisplayNameProperty") == null ? "displayName" : this.customPropertyMap.get("groupDisplayNameProperty"));
        this.attrMap.put("uniqueGroupIdProperty", this.customPropertyMap.get("uniqueGroupIdProperty") == null ? "uniqueId" : this.customPropertyMap.get("uniqueGroupIdProperty"));
        this.attrMap.put("userDisplayNameProperty", this.customPropertyMap.get("userDisplayNameProperty") == null ? "displayName" : this.customPropertyMap.get("userDisplayNameProperty"));
        this.attrMap.put("userSecurityNameProperty", this.customPropertyMap.get("userSecurityNameProperty") == null ? "uniqueName" : this.customPropertyMap.get("userSecurityNameProperty"));
        this.attrMap.put("uniqueUserIdProperty", this.customPropertyMap.get("uniqueUserIdProperty") == null ? "uniqueId" : this.customPropertyMap.get("uniqueUserIdProperty"));
    }

    public void setBaseEntry(DataObject dataObject) throws WIMException {
        List list = dataObject.getList("baseEntries");
        if (list == null || list.size() < 1) {
            throw new WIMApplicationException("MISSING_BASE_ENTRY", WIMMessageHelper.generateMsgParms(this.reposId), Level.SEVERE, CLASSNAME, "setBaseEntry");
        }
        DataObject dataObject2 = (DataObject)list.get(0);
        this.baseEntryName = dataObject2.getString("name");
    }

    public void setReposId(DataObject dataObject) {
        this.reposId = dataObject.getString("id");
    }

    public void initialize(DataObject dataObject) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI initialize", "reposConfig:" + dataObject);
        }
        try {
            Class<?> clazz;
            Object obj;
            Object object;
            String string;
            this.schemaMgr = SchemaManager.singleton();
            this.setCustomProperties(dataObject.getList("CustomProperties"));
            this.setMapping();
            this.setBaseEntry(dataObject);
            this.setConfigEntityMapping(dataObject);
            URBridgeHelper.mapSupportedEntityTypeList();
            this.personAccountType = URBridgeHelper.getPersonAccountType();
            this.groupAccountType = URBridgeHelper.getGroupAccountType();
            this.setReposId(dataObject);
            Properties properties = new Properties();
            String string2 = string = this.customPropertyMap.get("registryImplClass") == null ? null : (String)this.customPropertyMap.get("registryImplClass");
            if (string == null) {
                object = System.getProperty("os.name");
                if (((String)object).startsWith("Windows")) {
                    object = "Windows";
                }
                properties.load(this.getClass().getResourceAsStream(registryPropsFile));
                string = properties.getProperty((String)object);
            }
            if (string == null) {
                throw new WIMApplicationException("MISSING_OR_INVALID_CUSTOM_REGISTRY_CLASS_NAME", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "initialize");
            }
            object = Thread.currentThread().getContextClassLoader();
            if (object == null) {
                object = this.getClass().getClassLoader();
            }
            if (!((obj = (clazz = Class.forName(string, true, (ClassLoader)object)).newInstance()) instanceof UserRegistry)) {
                throw new WIMApplicationException("MISSING_OR_INVALID_CUSTOM_REGISTRY_CLASS_NAME", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "initialize");
            }
            this.reg = (UserRegistry)obj;
            this.reg.initialize(this.customPropertyMap);
        }
        catch (Throwable throwable) {
            throw new InitializationException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(throwable.toString()), Level.SEVERE, CLASSNAME, "initialize", throwable);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI initialize", "reposConfig:" + dataObject);
        }
    }

    private void setConfigEntityMapping(DataObject dataObject) throws WIMException {
        List list = this.getSupportedEntityTypes();
        ConfigManager configManager = ConfigManager.singleton();
        String string = null;
        this.entityConfigMap = new HashMap(6);
        for (int i = 0; i < list.size(); ++i) {
            string = (String)list.get(i);
            String string2 = configManager.getRDNProperties(string) == null ? null : (String)configManager.getRDNProperties(string).get(0);
            this.entityConfigMap.put(string, string2);
        }
        if (this.entityConfigMap.get("LoginAccount") == null && this.entityConfigMap.get(this.personAccountType) != null) {
            this.entityConfigMap.put("LoginAccount", this.entityConfigMap.get(this.personAccountType));
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "setConfigEntityMapping", "entityConfigMap:" + this.entityConfigMap);
        }
    }

    private void setCustomProperties(List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "setCustomProperties", "propList:" + list);
        }
        this.customPropertyMap = new Properties();
        if (list == null) {
            return;
        }
        for (DataObject dataObject : list) {
            String string = dataObject.getString("name");
            String string2 = this.expandVar(dataObject.getString("value"));
            this.customPropertyMap.put(string, string2);
            if (!trcLogger.isLoggable(Level.FINEST)) continue;
            trcLogger.logp(Level.FINEST, CLASSNAME, "setCustomProperties", "custom properties " + this.customPropertyMap);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String expandVar(String string) throws WIMException {
        String string2 = null;
        if (variableMap == null) return string;
        try {
            string2 = variableMap.expand(string);
            if (!trcLogger.isLoggable(Level.FINEST)) return string2;
            trcLogger.logp(Level.FINEST, CLASSNAME, "expandVar", "Variable " + string + " expanded as " + string2);
            return string2;
        }
        catch (Exception exception) {
            throw new WIMApplicationException("WAS_VARIABLE_NOT_RESOLVED", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "expandVar", (Throwable)exception);
        }
    }

    public DataObject create(DataObject dataObject) throws WIMException {
        throw new WIMApplicationException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, CLASSNAME, "create");
    }

    public DataObject delete(DataObject dataObject) throws WIMException {
        throw new WIMApplicationException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, CLASSNAME, "delete");
    }

    public DataObject update(DataObject dataObject) throws WIMException {
        throw new WIMApplicationException("CANNOT_WRITE_TO_READ_ONLY_REPOSITORY", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, CLASSNAME, "update");
    }

    public DataObject get(DataObject dataObject) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI get", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject2 = null;
        DataObject dataObject3 = null;
        String string = null;
        try {
            List list = null;
            List list2 = null;
            List list3 = null;
            DataObject dataObject4 = dataObject;
            Map map = ControlsHelper.getControlMap(dataObject);
            DataObject dataObject5 = (DataObject)map.get("PropertyControl");
            DataObject dataObject6 = (DataObject)map.get("GroupMemberControl");
            DataObject dataObject7 = (DataObject)map.get("GroupMembershipControl");
            if (dataObject6 != null) {
                list2 = this.getAttributes(dataObject6, this.personAccountType);
            }
            if (dataObject7 != null) {
                list3 = this.getAttributes(dataObject7, this.groupAccountType);
            }
            List list4 = dataObject4.getList("entities");
            for (int i = 0; i < list4.size(); ++i) {
                int n;
                DataObject dataObject8 = (DataObject)list4.get(i);
                String string2 = this.validateEntity(dataObject8);
                string = dataObject8.getDataObject("identifier").getString("uniqueName");
                dataObject3 = this.schemaMgr.createRootDataObject();
                dataObject2 = dataObject3.createDataObject("entities", "http://www.ibm.com/websphere/wim", string2);
                DataObject dataObject9 = dataObject2.createDataObject("identifier");
                dataObject9.setString("repositoryId", this.reposId);
                URBridgeEntityFactory uRBridgeEntityFactory = new URBridgeEntityFactory();
                URBridgeEntity uRBridgeEntity = uRBridgeEntityFactory.createObject(dataObject2, this.reg, this.attrMap, this.baseEntryName, this.entityConfigMap);
                uRBridgeEntity.setSecurityNameProp(string);
                list = this.getAttributes(dataObject5, string2);
                if (list != null) {
                    uRBridgeEntity.populateEntity(list);
                }
                if (URBridgeHelper.isSuperType("Group", string2) && dataObject6 != null && list2 != null) {
                    n = 0;
                    if (dataObject6.isSet("countLimit")) {
                        n = dataObject6.getInt("countLimit");
                    }
                    uRBridgeEntity.getUsersForGroup(list2, n);
                    continue;
                }
                if (!URBridgeHelper.isSuperType("LoginAccount", string2) || dataObject7 == null || list3 == null) continue;
                n = 0;
                if (dataObject7.isSet("countLimit")) {
                    n = dataObject7.getInt("countLimit");
                }
                uRBridgeEntity.getGroupsForUser(list3, n);
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            if (bl) {
                trcLogger.logp(Level.FINER, CLASSNAME, "get", "The entity  " + string + " is not a valid Entity in " + this.reposId);
            }
        }
        catch (Exception exception) {
            throw new WIMApplicationException("ENTITY_GET_FAILED", WIMMessageHelper.generateMsgParms(string, exception.toString()), Level.SEVERE, CLASSNAME, "get", (Throwable)exception);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI get", WIMTraceHelper.printDataObject(dataObject3));
        }
        return dataObject3;
    }

    public DataObject search(DataObject dataObject) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "WIM_SPI search", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject2 = this.schemaMgr.createRootDataObject();
        try {
            URBridgeEntity uRBridgeEntity;
            DataObject dataObject3;
            DataObject dataObject4;
            int n;
            Object object;
            List<String> list;
            int n2;
            Collection collection;
            String string;
            int n3 = 0;
            Map map = ControlsHelper.getControlMap(dataObject);
            DataObject dataObject5 = (DataObject)map.get("SearchControl");
            if (dataObject5.isSet("countLimit")) {
                n3 = dataObject5.getInt("countLimit");
            }
            if ((string = dataObject5.getString("expression")) == null || string.length() == 0) {
                throw new SearchControlException("MISSING_SEARCH_EXPRESSION", Level.SEVERE, CLASSNAME, "search");
            }
            URBridgeXPathHelper uRBridgeXPathHelper = new URBridgeXPathHelper(string);
            string = uRBridgeXPathHelper.getExpression();
            Result result = null;
            boolean bl2 = dataObject5.getBoolean("returnSubType");
            List list2 = uRBridgeXPathHelper.getEntityTypes();
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList arrayList = null;
            if (bl2) {
                for (int i = 0; i < list2.size(); ++i) {
                    String string2 = (String)list2.get(i);
                    collection = this.schemaMgr.getSubEntityTypes(string2);
                    hashSet.add(string2);
                    if (collection == null) continue;
                    hashSet.addAll(collection);
                }
            } else {
                hashSet.addAll(list2);
            }
            arrayList = new ArrayList(hashSet);
            if (trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "search", "entityType List: " + arrayList);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                String string3 = (String)arrayList.get(n2);
                if (!URBridgeHelper.isSuperType("Group", string3)) continue;
                collection = this.getAttributes(dataObject5, string3);
                list = new ArrayList<String>();
                if (this.reg instanceof SAFRegistryImpl && !string.endsWith("*")) {
                    object = this.reg.getGroupSecurityName(string);
                    list.add((String)object);
                } else {
                    result = this.reg.getGroups(string, n3);
                    if (result != null) {
                        list = result.getList();
                    }
                }
                if (list.size() <= 0) break;
                list = result.getList();
                object = new URBridgeEntityFactory();
                for (n = 0; n < list.size(); ++n) {
                    dataObject4 = dataObject2.createDataObject("entities", "http://www.ibm.com/websphere/wim", string3);
                    dataObject3 = dataObject4.createDataObject("identifier");
                    uRBridgeEntity = ((URBridgeEntityFactory)object).createObject(dataObject4, this.reg, this.attrMap, this.baseEntryName, this.entityConfigMap);
                    uRBridgeEntity.setSecurityNameProp((String)list.get(n));
                    uRBridgeEntity.populateEntity((List)collection);
                    dataObject3.setString("repositoryId", this.reposId);
                }
                break;
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                String string4 = (String)arrayList.get(n2);
                if (!URBridgeHelper.isSuperType("LoginAccount", string4)) continue;
                collection = this.getAttributes(dataObject5, string4);
                list = new ArrayList();
                if (this.reg instanceof SAFRegistryImpl && !string.endsWith("*")) {
                    object = this.reg.getUserSecurityName(string);
                    list.add((String)object);
                } else {
                    result = this.reg.getUsers(string, n3);
                    if (result != null) {
                        list = result.getList();
                    }
                }
                if (list.size() > 0) {
                    list = result.getList();
                    object = new URBridgeEntityFactory();
                    for (n = 0; n < list.size(); ++n) {
                        dataObject4 = dataObject2.createDataObject("entities", "http://www.ibm.com/websphere/wim", string4);
                        dataObject3 = dataObject4.createDataObject("identifier");
                        uRBridgeEntity = ((URBridgeEntityFactory)object).createObject(dataObject4, this.reg, this.attrMap, this.baseEntryName, this.entityConfigMap);
                        uRBridgeEntity.setSecurityNameProp((String)list.get(n));
                        uRBridgeEntity.populateEntity((List)collection);
                        dataObject3.setString("repositoryId", this.reposId);
                    }
                }
                break;
            }
        }
        catch (WIMException wIMException) {
            throw wIMException;
        }
        catch (Exception exception) {
            throw new WIMApplicationException("ENTITY_SEARCH_FAILED", WIMMessageHelper.generateMsgParms(exception.toString()), Level.SEVERE, CLASSNAME, "search", (Throwable)exception);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI search", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    private String stripRDN(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(61);
        int n2 = string.indexOf("," + this.baseEntryName);
        if (n < 0 || n2 < 0 || n > n2) {
            return string;
        }
        String string2 = string.substring(n + 1, n2);
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    public DataObject login(DataObject var1_1) throws WIMException {
        var3_2 = URBridge.trcLogger.isLoggable(Level.FINER);
        if (var3_2) {
            URBridge.trcLogger.entering(URBridge.CLASSNAME, "WIM_SPI login", WIMTraceHelper.printDataObject(var1_1));
        }
        var4_3 = this.schemaMgr.createRootDataObject();
        var5_4 = new URBridgeEntityFactory();
        var6_5 = null;
        var7_6 = var1_1;
        var8_7 = ControlsHelper.getControlMap(var7_6);
        var9_8 = (DataObject)var8_7.get("LoginControl");
        if (var9_8 != null) {
            var6_5 = this.getAttributes(var9_8, "LoginAccount");
        }
        if ((var10_9 = var7_6.getList("entities")).size() > 0) {
            var11_10 = (DataObject)var10_9.get(0);
            var12_11 = var11_10.getType().getName();
            var13_12 = null;
            if (URBridgeHelper.isSuperType("LoginAccount", var12_11)) {
                if (var11_10.isSet("principalName")) {
                    var14_13 = var11_10.getString("principalName");
                    var15_14 = var11_10.getBytes("password");
                    if (var14_13 == null || var14_13.trim().length() == 0) {
                        throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", URBridge.CLASSNAME, "login");
                    }
                    if (var15_14 == null || var15_14.length == 0) {
                        throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PASSWORD", URBridge.CLASSNAME, "login");
                    }
                    var16_17 = new String(var15_14);
                    try {
                        var17_18 = false;
                        if (this.reg instanceof SAFRegistryImpl) {
                            var17_18 = this.reg.isValidUser((String)var14_13);
                        }
                        v0 = var17_18 = (var18_25 = this.reg.getUsers((String)var14_13, 0)).getList().size() > 0;
                        if (var17_18) {
                            try {
                                var13_12 = this.reg.checkPassword((String)var14_13, (String)var16_17);
                            }
                            catch (com.ibm.websphere.security.PasswordCheckFailedException var19_27) {
                                throw new PasswordCheckFailedException("PASSWORD_MATCH_FAILED_FOR_PRINCIPALNAME", WIMMessageHelper.generateMsgParms(var14_13), Level.WARNING, URBridge.CLASSNAME, "login", (Throwable)var19_27);
                            }
                            catch (Exception var19_28) {
                                throw new WIMApplicationException("CUSTOM_REGISTRY_EXCEPTION", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, URBridge.CLASSNAME, "login", (Throwable)var19_28);
                            }
                        }
                        if (!var3_2) ** GOTO lbl70
                        URBridge.trcLogger.logp(Level.FINER, URBridge.CLASSNAME, "WIM_SPI login", "principal, " + (String)var14_13 + ", not found in " + this.reposId);
                    }
                    catch (CustomRegistryException var17_19) {
                        throw new WIMApplicationException("CUSTOM_REGISTRY_EXCEPTION", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, URBridge.CLASSNAME, "login", (Throwable)var17_19);
                    }
                    catch (RemoteException var17_20) {
                        throw new WIMApplicationException("CUSTOM_REGISTRY_EXCEPTION", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, URBridge.CLASSNAME, "login", (Throwable)var17_20);
                    }
                } else if (var11_10.isSet("certificate")) {
                    var14_13 = var11_10.getList("certificate");
                    var15_15 = var14_13.size();
                    if (var15_15 > 0) {
                        var16_17 = new X509Certificate[var15_15];
                        for (var17_21 = 0; var17_21 < ((X509Certificate[])var16_17).length; ++var17_21) {
                            var18_26 = new ByteArrayInputStream((byte[])var14_13.get(var17_21));
                            try {
                                var19_29 = CertificateFactory.getInstance("X.509");
                                var16_17[var17_21] = (X509Certificate)var19_29.generateCertificate(var18_26);
                                var18_26.close();
                                continue;
                            }
                            catch (Exception var19_30) {
                                throw new WIMApplicationException("CERTIFICATE_GENERATE_FAILED", null, Level.WARNING, URBridge.CLASSNAME, "login", (Throwable)var19_30);
                            }
                        }
                        try {
                            var13_12 = this.reg.mapCertificate((X509Certificate[])var16_17);
                        }
                        catch (CertificateMapFailedException var17_22) {
                            throw new com.ibm.websphere.wim.exception.CertificateMapFailedException("CERTIFICATE_MAP_FAILED", Level.WARNING, URBridge.CLASSNAME, "login", (Throwable)var17_22);
                        }
                        catch (com.ibm.websphere.security.CertificateMapNotSupportedException var17_23) {
                            throw new CertificateMapNotSupportedException("AUTHENTICATION_WITH_CERT_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(this.reposId), URBridge.CLASSNAME, "login", (Throwable)var17_23);
                        }
                        catch (Exception var17_24) {
                            throw new WIMApplicationException("CUSTOM_REGISTRY_EXCEPTION", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, URBridge.CLASSNAME, "login", (Throwable)var17_24);
                        }
                    }
                } else {
                    throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", URBridge.CLASSNAME, "login");
                }
lbl70:
                // 5 sources

                if (var13_12 != null) {
                    var14_13 = var4_3.createDataObject("entities", "http://www.ibm.com/websphere/wim", URBridgeHelper.getPersonAccountType());
                    var15_16 = var14_13.createDataObject("identifier");
                    var14_13.setString("principalName", var13_12);
                    var16_17 = var5_4.createObject((DataObject)var14_13, this.reg, this.attrMap, this.baseEntryName, this.entityConfigMap);
                    var16_17.setSecurityNameProp(var13_12);
                    if (var6_5 != null) {
                        var16_17.populateEntity(var6_5);
                    }
                    var15_16.setString("repositoryId", this.reposId);
                }
            } else {
                throw new WIMApplicationException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(var12_11), Level.WARNING, URBridge.CLASSNAME, "login");
            }
        }
        if (var3_2) {
            URBridge.trcLogger.exiting(URBridge.CLASSNAME, "WIM_SPI login", WIMTraceHelper.printDataObject(var4_3));
        }
        return var4_3;
    }

    private List getAttributes(DataObject dataObject, String string) {
        List list = new ArrayList(10);
        if (dataObject != null && dataObject.isSet("properties")) {
            list = dataObject.getList("properties");
        }
        if (list.size() > 0 && "*".equals((String)list.get(0))) {
            list = this.getAttributes(string);
        }
        list.addAll(this.getIdentifierAttributes(string));
        return list;
    }

    private List getAttributes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        arrayList.add((String)this.entityConfigMap.get(string));
        if (URBridgeHelper.isSuperType("Group", string)) {
            arrayList.add((String)this.attrMap.get("groupDisplayNameProperty"));
        } else if (URBridgeHelper.isSuperType("LoginAccount", string)) {
            arrayList.add("principalName");
            arrayList.add((String)this.attrMap.get("userDisplayNameProperty"));
        } else if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "getAttributes(entityType)", "Entity type " + string + " is invalid and is ignored.");
        }
        return arrayList;
    }

    private List getIdentifierAttributes(String string) {
        ArrayList arrayList = new ArrayList(4);
        if (URBridgeHelper.isSuperType("Group", string)) {
            arrayList.add(this.attrMap.get("uniqueGroupIdProperty"));
            arrayList.add(this.attrMap.get("groupSecurityNameProperty"));
        } else if (URBridgeHelper.isSuperType("LoginAccount", string)) {
            arrayList.add(this.attrMap.get("uniqueUserIdProperty"));
            arrayList.add(this.attrMap.get("userSecurityNameProperty"));
        } else if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "getIdentifierAttributes", "Entity type " + string + " is invalid and is ignored.");
        }
        return arrayList;
    }

    private String validateEntity(DataObject dataObject) throws WIMException {
        String string = "validateEntity";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (dataObject.getDataObject("identifier").isSet("uniqueName")) {
            string3 = this.stripRDN(dataObject.getDataObject("identifier").getString("uniqueName"));
        } else if (dataObject.getDataObject("identifier").isSet("externalName")) {
            string3 = this.stripRDN(dataObject.getDataObject("identifier").getString("externalName"));
        } else if (dataObject.getDataObject("identifier").isSet("uniqueId")) {
            string4 = dataObject.getDataObject("identifier").getString("uniqueId");
        } else if (dataObject.getDataObject("identifier").isSet("externalId")) {
            string4 = dataObject.getDataObject("identifier").getString("externalId");
        }
        if (string4 != null && string4.trim().length() > 0) {
            string3 = this.getSecNameFromUniqueID(string4);
        }
        if (string3 != null && string3.trim().length() > 0) {
            string2 = this.getEntityTypeFromUniqueName(string3);
            dataObject.getDataObject("identifier").setString("uniqueName", string3);
        }
        if (bl) {
            trcLogger.logp(Level.FINER, CLASSNAME, string, "The entity type for " + string3 + " is " + string2);
        }
        if (string2 == null) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string3), Level.SEVERE, CLASSNAME, string);
        }
        return string2;
    }

    private String getEntityTypeFromUniqueName(String string) throws WIMException {
        String string2 = "getEntityTypeFromUniqueName";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        String string3 = null;
        Result result = null;
        try {
            if (this.reg instanceof SAFRegistryImpl) {
                if (this.reg.isValidUser(string)) {
                    string3 = this.personAccountType;
                } else if (this.reg.isValidGroup(string)) {
                    string3 = this.groupAccountType;
                }
            } else {
                result = this.reg.getUsers(string, 0);
                if (result.getList().size() > 0) {
                    string3 = this.personAccountType;
                } else {
                    result = this.reg.getGroups(string, 0);
                    if (result.getList().size() > 0) {
                        string3 = this.groupAccountType;
                    }
                }
            }
        }
        catch (CustomRegistryException customRegistryException) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2, (Throwable)customRegistryException);
        }
        catch (RemoteException remoteException) {
            throw new WIMApplicationException("CUSTOM_REGISTRY_EXCEPTION", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, CLASSNAME, string2, (Throwable)remoteException);
        }
        if (bl) {
            trcLogger.logp(Level.FINER, CLASSNAME, string2, "The entity type for " + string + " is " + string3);
        }
        return string3;
    }

    private String getSecNameFromUniqueID(String string) throws WIMException {
        String string2 = "getSecNameFromUniqueID";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        String string3 = null;
        try {
            string3 = this.reg.getUserSecurityName(string);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            try {
                string3 = this.reg.getGroupSecurityName(string);
            }
            catch (EntryNotFoundException entryNotFoundException2) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2, (Throwable)entryNotFoundException);
            }
            catch (CustomRegistryException customRegistryException) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2, (Throwable)entryNotFoundException);
            }
            catch (RemoteException remoteException) {
                throw new WIMApplicationException("CUSTOM_REGISTRY_EXCEPTION", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, CLASSNAME, string2, (Throwable)remoteException);
            }
        }
        catch (CustomRegistryException customRegistryException) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2, (Throwable)customRegistryException);
        }
        catch (RemoteException remoteException) {
            throw new WIMApplicationException("CUSTOM_REGISTRY_EXCEPTION", WIMMessageHelper.generateMsgParms(this.reposId), Level.WARNING, CLASSNAME, string2, (Throwable)remoteException);
        }
        if (bl) {
            trcLogger.logp(Level.FINER, CLASSNAME, string2, "The Security Name for " + string + " is " + string3);
        }
        return string3;
    }

    public DataObject getSchema(DataObject dataObject) throws WIMException {
        DataObject dataObject2;
        DataObject dataObject3;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "WIM_SPI getSchema", WIMTraceHelper.printDataObject(dataObject));
        }
        if ((dataObject3 = (dataObject2 = this.schemaMgr.createRootDataObject()).getDataObject("schema")) == null) {
            dataObject3 = dataObject2.createDataObject("schema");
        }
        Map map = ControlsHelper.getControlMap(dataObject);
        DataObject dataObject4 = (DataObject)map.get("DataTypeControl");
        DataObject dataObject5 = (DataObject)map.get("PropertyDefinitionControl");
        DataObject dataObject6 = (DataObject)map.get("EntityTypeControl");
        if (dataObject4 == null) {
            if (dataObject6 != null) {
                List list = this.getSupportedEntityTypes();
                List list2 = dataObject6.getList("entityTypeNames");
                if (list2 == null || list2.size() == 0) {
                    if (list != null && list.size() > 0) {
                        for (int i = 0; i < list.size(); ++i) {
                            DataObject dataObject7 = dataObject3.createDataObject("entitySchema");
                            String string = (String)list.get(i);
                            String string2 = this.schemaMgr.getTypeNsURI(string);
                            dataObject7.set("entityName", (Object)string);
                            dataObject7.set("nsURI", (Object)string2);
                        }
                    }
                } else {
                    for (int i = 0; i < list2.size(); ++i) {
                        String string = (String)list2.get(i);
                        if (list.contains(string)) {
                            DataObject dataObject8 = dataObject3.createDataObject("entitySchema");
                            String string3 = this.schemaMgr.getTypeNsURI(string);
                            dataObject8.set("entityName", (Object)string);
                            dataObject8.set("nsURI", (Object)string3);
                            continue;
                        }
                        if (!trcLogger.isLoggable(Level.FINER)) continue;
                        trcLogger.logp(Level.FINER, CLASSNAME, "getSchema", "The entity type " + string + " is not supported in repository " + this.reposId);
                    }
                }
            } else if (dataObject5 != null) {
                String string = dataObject5.getString("entityTypeName");
                List list = dataObject5.getList("propertyNames");
                if (list != null && list.size() > 0) {
                    List list3 = this.getAttributes(string);
                    if (list3 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            String string4 = (String)list.get(i);
                            if (!list3.contains(string4)) continue;
                            DataObject dataObject9 = dataObject3.createDataObject("propertySchema");
                            dataObject9.setString("propertyName", string4);
                        }
                    }
                } else {
                    List list4 = this.getAttributes(string);
                    for (int i = 0; list4 != null && i < list4.size(); ++i) {
                        String string5 = (String)list4.get(i);
                        DataObject dataObject10 = dataObject3.createDataObject("propertySchema");
                        dataObject10.setString("propertyName", string5);
                    }
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "WIM_SPI getSchema", WIMTraceHelper.printDataObject(dataObject2));
        }
        return dataObject2;
    }

    public DataObject createSchema(DataObject dataObject) throws WIMException {
        throw new OperationNotSupportedException("OPERATION_NOT_SUPPORTED_IN_REPOSITORY", WIMMessageHelper.generateMsgParms("createSchema", this.reposId), CLASSNAME, "createSchema");
    }

    public List getSupportedEntityTypes() throws WIMException {
        ConfigManager configManager = ConfigManager.singleton();
        return configManager.getSupportedEntityTypes();
    }

    public UserRegistry getRegistry() {
        return this.reg;
    }

    static {
        try {
            variableMap = VariableMapFactory.getVariableMap();
        }
        catch (Exception exception) {
            variableMap = null;
            trcLogger.logp(Level.SEVERE, CLASSNAME, "<init>", "Variables cannot be expanded since variableMap is not initialized.Either start the Websphere Application Server or Replace variables with respective Values.");
        }
    }
}

