/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.urbridge;

import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import commonj.sdo.DataObject;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class URBridgeEntity {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    public static final String CLASSNAME = URBridgeEntity.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    Map attrMap;
    String baseEntryName;
    UserRegistry reg;
    DataObject entity;
    Map entityConfigMap;
    protected String securityNameProp;
    protected String uniqueIdProp;
    protected String displayNameProp;
    protected String rdnProp;

    public URBridgeEntity(DataObject dataObject, UserRegistry userRegistry, Map map, String string, Map map2) {
        this.entity = dataObject;
        this.reg = userRegistry;
        this.attrMap = map;
        this.entityConfigMap = map2;
        this.baseEntryName = string;
    }

    public abstract String getSecurityNameForEntity(String var1) throws Exception;

    public abstract String getUniqueIdForEntity(String var1) throws Exception;

    public abstract String getDisplayNameForEntity(String var1) throws Exception;

    public void populateEntity(List list) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "populateEntity");
        }
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            try {
                if (string.equals(this.securityNameProp)) {
                    this.getSecurityName(true);
                    continue;
                }
                if (string.equals(this.uniqueIdProp)) {
                    bl2 = true;
                    this.getUniqueId(true);
                    continue;
                }
                if (string.equals(this.displayNameProp)) {
                    this.getDisplayName(true);
                    continue;
                }
                if (string.equals(this.rdnProp)) {
                    this.entity.setString(this.rdnProp, this.stripRDN(this.entity.getDataObject("identifier").getString(this.securityNameProp)));
                    continue;
                }
                if (!string.equals("principalName")) continue;
                this.entity.setString("principalName", this.stripRDN(this.entity.getDataObject("identifier").getString(this.securityNameProp)));
                continue;
            }
            catch (Exception exception) {
                throw new WIMApplicationException(CLASSNAME, "populateEntity", (Throwable)exception);
            }
        }
        if (this.entity.getDataObject("identifier").isSet(this.uniqueIdProp)) {
            this.entity.getDataObject("identifier").setString("externalId", this.stripRDN(this.entity.getDataObject("identifier").getString(this.uniqueIdProp)));
        }
        if (!bl2) {
            this.entity.getDataObject("identifier").unset(this.uniqueIdProp);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "populateEntity");
        }
    }

    public void setSecurityNameProp(String string) {
        if (string != null) {
            String string2 = this.buildRDN(this.stripRDN(string));
            this.entity.getDataObject("identifier").setString(this.securityNameProp, string2);
        }
    }

    public String getSecurityName(boolean bl) throws Exception {
        if (this.entity.getDataObject("identifier").isSet(this.securityNameProp)) {
            return this.stripRDN(this.entity.getDataObject("identifier").getString(this.securityNameProp));
        }
        if (!this.entity.getDataObject("identifier").isSet(this.uniqueIdProp)) {
            throw new WIMApplicationException("REQUIRED_IDENTIFIERS_MISSING", null, Level.WARNING, CLASSNAME, "getSecurityName");
        }
        String string = this.entity.getDataObject("identifier").getString(this.uniqueIdProp);
        String string2 = this.getSecurityNameForEntity(string);
        if (bl) {
            String string3 = this.buildRDN(string2);
            this.entity.getDataObject("identifier").setString(this.securityNameProp, string3);
        }
        return string2;
    }

    public String getUniqueId(boolean bl) throws Exception {
        String string = null;
        String string2 = null;
        if (this.entity.getDataObject("identifier").isSet(this.uniqueIdProp)) {
            string2 = this.entity.getDataObject("identifier").getString(this.uniqueIdProp);
            return string2;
        }
        string = this.entity.getDataObject("identifier").getString(this.securityNameProp);
        if (string2 == null && string == null) {
            throw new WIMApplicationException("REQUIRED_IDENTIFIERS_MISSING", null, Level.WARNING, CLASSNAME, "getUniqueId");
        }
        string = this.stripRDN(string);
        string2 = this.getUniqueIdForEntity(string);
        if (bl) {
            this.entity.getDataObject("identifier").setString(this.uniqueIdProp, string2);
        }
        return string2;
    }

    public String getDisplayName(boolean bl) throws Exception {
        String string = null;
        String string2 = this.stripRDN(this.getSecurityName(false));
        string = this.getDisplayNameForEntity(string2);
        if (string != null && string.trim().length() != 0 && bl) {
            this.entity.getList("displayName").add(string);
        }
        return string;
    }

    public String stripRDN(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(61);
        int n2 = string.indexOf("," + this.baseEntryName);
        if (n < 0 || n2 < 0 || n > n2) {
            return string;
        }
        String string2 = string.substring(n + 1, n2);
        return string2;
    }

    public String buildRDN(String string) {
        String string2 = (String)this.entityConfigMap.get(this.entity.getType().getName());
        String string3 = string2 + "=" + string + "," + this.baseEntryName;
        return string3;
    }

    public void setRDNPropValue(String string) {
        if (string != null) {
            this.entity.setString((String)this.entityConfigMap.get(this.entity.getType().getName()), string);
        }
    }

    public void getGroupsForUser(List list, int n) throws Exception {
        throw new WIMApplicationException("METHOD_NOT_IMPLEMENTED", WIMMessageHelper.generateMsgParms("getGroupsForUser", CLASSNAME), Level.WARNING, CLASSNAME, "getGroupsForUser");
    }

    public void getUsersForGroup(List list, int n) throws Exception {
        throw new WIMApplicationException("METHOD_NOT_IMPLEMENTED", WIMMessageHelper.generateMsgParms("getUsersForGroup", CLASSNAME), Level.WARNING, CLASSNAME, "getUsersForGroup");
    }
}

