/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.urbridge;

import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.adapter.urbridge.URBridgeEntity;
import com.ibm.ws.wim.adapter.urbridge.URBridgeGroup;
import com.ibm.ws.wim.adapter.urbridge.URBridgeHelper;
import com.ibm.ws.wim.adapter.urbridge.URBridgePerson;
import commonj.sdo.DataObject;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URBridgeEntityFactory {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    public static final String CLASSNAME = URBridgeEntityFactory.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public URBridgeEntity createObject(DataObject dataObject, UserRegistry userRegistry, Map map, String string, Map map2) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createObject", WIMTraceHelper.printDataGraph(dataObject));
        }
        String string2 = dataObject.getType().getName();
        URBridgeEntity uRBridgeEntity = null;
        if (URBridgeHelper.isSuperType("Group", string2)) {
            uRBridgeEntity = new URBridgeGroup(dataObject, userRegistry, map, string, map2);
        } else if (URBridgeHelper.isSuperType("LoginAccount", string2)) {
            uRBridgeEntity = new URBridgePerson(dataObject, userRegistry, map, string, map2);
        } else {
            throw new WIMApplicationException("ENTITY_TYPE_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms(string2), Level.WARNING, CLASSNAME, "createObject");
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createObject", WIMTraceHelper.printDataGraph(dataObject));
        }
        return uRBridgeEntity;
    }
}

