/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.urbridge;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.urbridge.URBridge;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URBridgeHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    public static final String CLASSNAME;
    private static final Logger trcLogger;
    private static SchemaManager schemaMgr;
    private static ConfigManager configManager;
    private static List personAccountTypeList;
    private static List groupAccountTypeList;

    public static boolean isSuperType(String string, String string2) {
        return string.equals(string2) || schemaMgr.isSuperType(string, string2);
    }

    public static void mapSupportedEntityTypeList() {
        List list = configManager.getSupportedEntityTypes();
        personAccountTypeList = new ArrayList(6);
        groupAccountTypeList = new ArrayList(6);
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (URBridgeHelper.isSuperType("PersonAccount", string)) {
                personAccountTypeList.add(string);
            }
            if (!URBridgeHelper.isSuperType("Group", string)) continue;
            groupAccountTypeList.add(string);
        }
    }

    public static String getPersonAccountType() {
        return (String)personAccountTypeList.get(0);
    }

    public static String getGroupAccountType() {
        return (String)groupAccountTypeList.get(0);
    }

    static {
        block2: {
            CLASSNAME = URBridge.class.getName();
            trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
            schemaMgr = null;
            configManager = null;
            personAccountTypeList = null;
            groupAccountTypeList = null;
            try {
                schemaMgr = SchemaManager.singleton();
                configManager = ConfigManager.singleton();
            }
            catch (WIMException wIMException) {
                if (!trcLogger.isLoggable(Level.FINE)) break block2;
                trcLogger.logp(Level.FINE, CLASSNAME, "staticInit", "failed to get SchemaManager:", wIMException);
            }
        }
    }
}

