/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.urbridge;

import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.urbridge.URBridgeEntity;
import com.ibm.ws.wim.adapter.urbridge.URBridgeEntityFactory;
import com.ibm.ws.wim.adapter.urbridge.URBridgeHelper;
import commonj.sdo.DataObject;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class URBridgePerson
extends URBridgeEntity {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public URBridgePerson(DataObject dataObject, UserRegistry userRegistry, Map map, String string, Map map2) {
        super(dataObject, userRegistry, map, string, map2);
        this.securityNameProp = (String)map.get("userSecurityNameProperty");
        this.uniqueIdProp = (String)map.get("uniqueUserIdProperty");
        this.displayNameProp = (String)map.get("userDisplayNameProperty");
        this.rdnProp = (String)map2.get(this.entity.getType().getName());
    }

    public String getUniqueIdForEntity(String string) throws Exception {
        return this.reg.getUniqueUserId(string);
    }

    public String getSecurityNameForEntity(String string) throws Exception {
        return this.reg.getUserSecurityName(string);
    }

    public String getDisplayNameForEntity(String string) throws Exception {
        return this.reg.getUserDisplayName(string);
    }

    public void getGroupsForUser(List list, int n) throws WIMException {
        String string = "getGroupsForUser";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string, WIMTraceHelper.printDataObject(this.entity));
        }
        String string2 = null;
        try {
            string2 = this.getSecurityName(false);
            List list2 = this.reg.getGroupsForUser(string2);
            n = n == 0 ? list2.size() : n;
            n = n < 0 ? 0 : n;
            n = list2.size() > n ? n : list2.size();
            for (int i = 0; i < n; ++i) {
                DataObject dataObject = SchemaManager.singleton().createRootDataObject();
                DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", URBridgeHelper.getGroupAccountType());
                DataObject dataObject3 = dataObject2.createDataObject("identifier");
                URBridgeEntityFactory uRBridgeEntityFactory = new URBridgeEntityFactory();
                URBridgeEntity uRBridgeEntity = uRBridgeEntityFactory.createObject(dataObject2, this.reg, this.attrMap, this.baseEntryName, this.entityConfigMap);
                uRBridgeEntity.setSecurityNameProp((String)list2.get(i));
                uRBridgeEntity.populateEntity(list);
                uRBridgeEntity.setRDNPropValue(this.stripRDN((String)list2.get(i)));
                this.entity.getList("groups").add(dataObject2);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string, (Throwable)entryNotFoundException);
        }
        catch (NotImplementedException notImplementedException) {
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, string, (Throwable)notImplementedException);
        }
        catch (Exception exception) {
            throw new WIMApplicationException("ENTITY_GET_FAILED", WIMMessageHelper.generateMsgParms(string2, exception.toString()), Level.SEVERE, CLASSNAME, string, (Throwable)exception);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, string, WIMTraceHelper.printDataObject(this.entity));
        }
    }
}

