/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.adapter.urbridge;

import com.ibm.websphere.wim.exception.PropertyNotDefinedException;
import com.ibm.websphere.wim.exception.SearchControlException;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.xpath.TokenMgrError;
import com.ibm.ws.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.wim.xpath.mapping.datatype.XPathNode;
import commonj.sdo.Property;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URBridgeXPathHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    private static final String CLASSNAME = URBridgeXPathHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private List entityTypes = null;
    private XPathNode node = null;

    public URBridgeXPathHelper() {
    }

    public URBridgeXPathHelper(String string) throws WIMException {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "<init>", "searchExpr=" + string);
        }
        this.parseSearchExpression(string);
    }

    public List getEntityTypes() {
        return this.entityTypes;
    }

    public XPathNode getNode() {
        return this.node;
    }

    public void parseSearchExpression(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, "parseSearchExpression", "parsing " + string);
        }
        try {
            if (string == null || string.trim().length() == 0) {
                return;
            }
            WIMXPathInterpreter wIMXPathInterpreter = new WIMXPathInterpreter(new StringReader(string));
            this.node = wIMXPathInterpreter.parse(null);
            this.entityTypes = wIMXPathInterpreter.getEntityTypes();
            HashMap hashMap = new HashMap();
            if (this.node != null) {
                SchemaManager schemaManager = SchemaManager.singleton();
                Iterator iterator = this.node.getPropertyNodes(hashMap);
                while (iterator.hasNext()) {
                    PropertyNode propertyNode = (PropertyNode)iterator.next();
                    propertyNode.setName(this.removeNamespace(propertyNode.getName()));
                    String string2 = propertyNode.getName();
                    Property property = null;
                    Object var10_11 = null;
                    Iterator iterator2 = this.entityTypes.iterator();
                    while (iterator2.hasNext() && property == null) {
                        String string3 = (String)iterator2.next();
                        if (string3.equalsIgnoreCase("LoginAccount")) {
                            string3 = "PersonAccount";
                        }
                        property = schemaManager.getProperty(string3, string2);
                    }
                    if (property != null) continue;
                    throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED_FOR_ENTITY", WIMMessageHelper.generateMsgParms(string2, this.entityTypes), CLASSNAME, "parseSearchExpression");
                }
            }
        }
        catch (Exception exception) {
            throw new WIMApplicationException("MALFORMED_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), Level.WARNING, CLASSNAME, "parseSearchExpression", (Throwable)exception);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new SearchControlException("INVALID_SEARCH_EXPRESSION", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "parseSearchExpression", (Throwable)tokenMgrError);
        }
    }

    public String removeNamespace(String string) {
        String string2 = string.replace('\'', ' ').trim();
        int n = string2.indexOf(":");
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }

    public String getExpression() throws Exception {
        switch (this.node.getNodeType()) {
            case 0: {
                return this.getExpression((PropertyNode)this.node);
            }
        }
        return "";
    }

    private String getExpression(PropertyNode propertyNode) throws Exception {
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getExpression", "propNode " + propertyNode);
        }
        String string = (String)propertyNode.getValue();
        if (bl) {
            trcLogger.exiting(CLASSNAME, "getExpression", "pattern=" + string);
        }
        return string;
    }
}

