/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.adapter;

import com.ibm.websphere.wim.SchemaConstants;
import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.MultipleEntriesFoundException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.websphere.wmm.MemberService;
import com.ibm.websphere.wmm.datatype.AttributeDefinition;
import com.ibm.websphere.wmm.datatype.AttributeDefinitionSet;
import com.ibm.websphere.wmm.datatype.Attributes;
import com.ibm.websphere.wmm.datatype.ConfigurationData;
import com.ibm.websphere.wmm.datatype.GroupScope;
import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.MemberIdentifierList;
import com.ibm.websphere.wmm.datatype.MemberIdentifierSet;
import com.ibm.websphere.wmm.datatype.MemberList;
import com.ibm.websphere.wmm.datatype.MemberSet;
import com.ibm.websphere.wmm.datatype.MemberTypeAttributeMap;
import com.ibm.websphere.wmm.datatype.PageControl;
import com.ibm.websphere.wmm.datatype.SearchCriteria;
import com.ibm.websphere.wmm.datatype.SearchResponseControl;
import com.ibm.websphere.wmm.datatype.SortControl;
import com.ibm.websphere.wmm.datatype.StringIterator;
import com.ibm.websphere.wmm.datatype.StringSet;
import com.ibm.websphere.wmm.exception.CertificateMapFailedException;
import com.ibm.websphere.wmm.exception.CertificateMapNotSupportedException;
import com.ibm.websphere.wmm.exception.EntryNotFoundException;
import com.ibm.websphere.wmm.exception.NotImplementedException;
import com.ibm.websphere.wmm.exception.OperationNotSupportedException;
import com.ibm.websphere.wmm.exception.PasswordCheckFailedException;
import com.ibm.websphere.wmm.exception.WMMException;
import com.ibm.websphere.wmm.exception.WMMSystemException;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.bridge.assembler.DataObjectAssembler;
import com.ibm.ws.wim.bridge.assembler.object.AttributeDefinitionAssembler;
import com.ibm.ws.wim.bridge.assembler.object.AttributeDefinitionSetAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberIdentifierAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberIdentifierListAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberIdentifierSetAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberListAssembler;
import com.ibm.ws.wim.bridge.assembler.object.MemberSetAssembler;
import com.ibm.ws.wim.bridge.assembler.object.SearchResponseControlAssembler;
import com.ibm.ws.wim.bridge.assembler.object.StringSetAssembler;
import com.ibm.ws.wim.bridge.util.EntityTypeResolver;
import com.ibm.ws.wim.bridge.util.ExceptionConverter;
import com.ibm.ws.wim.bridge.util.ParameterHandler;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.ParticipatingBaseEntriesType;
import com.ibm.ws.wim.configmodel.RealmConfigurationType;
import com.ibm.ws.wim.configmodel.RealmDefaultParentType;
import com.ibm.ws.wim.configmodel.RealmType;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.ws.wmm.datatype.impl.ConfigurationDataImpl;
import com.ibm.ws.wmm.datatype.impl.MemberIdentifierData;
import com.ibm.ws.wmm.registry.WMMRealm;
import com.ibm.ws.wmm.registry.WMMRealms;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EAttributeImpl;

public class WMM2WIMBridgeAdapter
implements MemberService,
SchemaConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = WMM2WIMBridgeAdapter.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static WMM2WIMBridgeAdapter instance = null;
    protected EPackage schema = null;
    protected Map entitySchema = null;
    protected Map wmmwimAttrMap = new HashMap();
    protected Map wimwmmAttrMap = new HashMap();

    private WMM2WIMBridgeAdapter() {
        this.wmmwimAttrMap.put("userPassword", "password");
        this.wimwmmAttrMap.put("password", "userPassword");
        this.entitySchema = new HashMap(4);
        try {
            this.schema = SchemaManager.singleton().getSchemaPackage(null);
            for (short s = 0; s < 4; s = (short)(s + 1)) {
                String string = EntityTypeResolver.getWimEntityType(s);
                DataObject dataObject = ServiceProvider.singleton().createRootDataObject();
                DataObject dataObject2 = SDOHelper.createControlDataObject(dataObject, null, "PropertyDefinitionControl");
                dataObject2.setString("entityTypeName", string);
                this.entitySchema.put(string, ServiceProvider.singleton().getSchema(dataObject).getDataObject("schema"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static WMM2WIMBridgeAdapter singleton() {
        if (instance == null) {
            instance = new WMM2WIMBridgeAdapter();
        }
        return instance;
    }

    public void assignMembersToGroup(MemberIdentifier memberIdentifier, MemberIdentifierSet memberIdentifierSet, short s) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assignMembersToGroup(group, memberids, mode)", "(" + memberIdentifier + ", " + memberIdentifierSet + ", " + s + ")");
        }
        try {
            if (memberIdentifier != null && memberIdentifierSet != null) {
                DataGraph dataGraph = ParameterHandler.assignMembersToGroup(memberIdentifier, memberIdentifierSet, s);
                DataObject dataObject = ServiceProvider.singleton().update(dataGraph.getRootObject().getDataObject("Root"));
            } else {
                trcLogger.logp(Level.FINER, CLASSNAME, "assignMembersToGroup(group, memberids, mode)", "groupId [" + memberIdentifier + "] or memberIds [" + memberIdentifierSet + "] is null. ");
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assignMembersToGroup(group, memberids, mode)");
        }
    }

    public void assignMemberToGroup(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assignMembersToGroup(group, memberids, mode)", "(" + memberIdentifier + ", " + memberIdentifier2 + ")");
        }
        try {
            if (memberIdentifier != null && memberIdentifier2 != null) {
                DataGraph dataGraph = ParameterHandler.assignMemberToGroup(memberIdentifier, memberIdentifier2);
                DataObject dataObject = ServiceProvider.singleton().update(dataGraph.getRootObject().getDataObject("Root"));
            } else {
                trcLogger.logp(Level.FINER, CLASSNAME, "assignMembersToGroup(group, memberids, mode)", "groupId [" + memberIdentifier + "] or memberId [" + memberIdentifier2 + "] is null. ");
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "assignMembersToGroup(group, memberids, mode)");
        }
    }

    public void createAttributeDefinition(AttributeDefinition attributeDefinition, String string) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createAttributeDefinition(attributeDefinition, path)", "(" + attributeDefinition + ", " + string + ")");
        }
        try {
            DataGraph dataGraph = ParameterHandler.createAttributeDefinition(attributeDefinition, string);
            DataObject dataObject = ServiceProvider.singleton().createSchema(dataGraph.getRootObject().getDataObject("Root"));
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createAttributeDefinition(attributeDefinition, path)");
        }
    }

    public void createLookAsideAttributeDefinition(AttributeDefinition attributeDefinition) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createLookAsideAttributeDefinition(attributeDefinition)", "(" + attributeDefinition + ")");
        }
        try {
            DataGraph dataGraph = ParameterHandler.createLookasideAttributeDefinition(attributeDefinition);
            DataObject dataObject = ServiceProvider.singleton().createSchema(dataGraph.getRootObject().getDataObject("Root"));
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createLookAsideAttributeDefinition(attributeDefinition)");
        }
    }

    public MemberIdentifier createMember(Member member) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "createMember(mbr)", "(" + member + ")");
        }
        MemberIdentifier memberIdentifier = null;
        try {
            Object object;
            DataGraph dataGraph = ParameterHandler.createMember(member);
            DataObject dataObject = ServiceProvider.singleton().create(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null && (object = dataObject.getList("entities")) != null && object.size() > 0) {
                dataObject2 = ((DataObject)object.get(0)).getDataObject("identifier");
            }
            if (dataObject2 != null) {
                MemberIdentifier memberIdentifier2;
                object = new DataObjectAssembler(MemberIdentifierAssembler.getInstance(dataObject2));
                memberIdentifier = memberIdentifier2 = (MemberIdentifier)object.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "createMember(mbr)", memberIdentifier);
        }
        return memberIdentifier;
    }

    public MemberIdentifierList getAncestorIdentifiers(MemberIdentifier memberIdentifier, short s, short s2) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getAncestorIdentifiers(memberid, scope, returnedIdType)");
        }
        MemberIdentifierList memberIdentifierList = null;
        try {
            DataGraph dataGraph = ParameterHandler.getAncestorIdentifiers(memberIdentifier, s);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            List list = null;
            if (dataObject != null) {
                list = dataObject.getList("entities");
            }
            if (list != null) {
                MemberIdentifierList memberIdentifierList2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberIdentifierListAssembler.getInstance(list));
                memberIdentifierList = memberIdentifierList2 = (MemberIdentifierList)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getAncestorIdentifiers(memberid, scope, returnedIdType)", memberIdentifierList);
        }
        return memberIdentifierList;
    }

    public AttributeDefinition getAttributeDefinition(String string, String string2) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getAttributeDefinition(attributeName, path)", "(" + string + ", " + string2 + ")");
        }
        AttributeDefinition attributeDefinition = null;
        try {
            List list;
            DataGraph dataGraph = ParameterHandler.getAttributeDefinition(string, string2);
            DataObject dataObject = ServiceProvider.singleton().getSchema(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null && (list = dataObject.getDataObject("schema").getList("propertySchema")) != null) {
                AttributeDefinition attributeDefinition2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(AttributeDefinitionAssembler.getInstance((DataObject)list.get(0)));
                attributeDefinition = attributeDefinition2 = (AttributeDefinition)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getAttributeDefinition(attributeName, path)", attributeDefinition);
        }
        return attributeDefinition;
    }

    public AttributeDefinitionSet getAttributeDefinitions(short s, String string) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getAttributeDefinitions(memberType, path)", "(" + s + ", " + string + ")");
        }
        AttributeDefinitionSet attributeDefinitionSet = null;
        try {
            List list;
            DataGraph dataGraph = ParameterHandler.getAttributeDefinitions(s, string);
            DataObject dataObject = ServiceProvider.singleton().getSchema(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null && (list = dataObject.getDataObject("schema").getList("propertySchema")) != null) {
                AttributeDefinitionSet attributeDefinitionSet2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(AttributeDefinitionSetAssembler.getInstance(list));
                attributeDefinitionSet = attributeDefinitionSet2 = (AttributeDefinitionSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getAttributeDefinitions(memberType, path)", attributeDefinitionSet);
        }
        return attributeDefinitionSet;
    }

    public String getExternalDN(MemberIdentifier memberIdentifier) throws RemoteException, WMMException {
        String string;
        block8: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "getExternalDN (memberId)", "(" + memberIdentifier + ")");
            }
            string = null;
            try {
                DataGraph dataGraph = ParameterHandler.getExternalDn(memberIdentifier);
                DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
                if (dataObject == null) break block8;
                List list = dataObject.getList("entities");
                if (list != null && list.size() == 1) {
                    DataObject dataObject2 = (DataObject)list.get(0);
                    DataObject dataObject3 = dataObject2.getDataObject("identifier");
                    if (dataObject3 == null) {
                        throw new EntityNotFoundException(CLASSNAME, "getExternalDN (memberId)", "identifier == null");
                    }
                    string = dataObject3.getString("externalName");
                    break block8;
                }
                throw new EntityNotFoundException("GENERIC", WIMMessageHelper.generateMsgParms("entities is empty"), CLASSNAME, "getExternalDN (memberId)");
            }
            catch (WIMException wIMException) {
                throw ExceptionConverter.toWMMException(wIMException);
            }
            catch (RemoteException remoteException) {
                throw remoteException;
            }
            catch (Exception exception) {
                throw new WMMSystemException(exception);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getExternalDN (memberId)", string);
        }
        return string;
    }

    public MemberIdentifierSet getGroupIdentifiersForMember(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, GroupScope groupScope, short s) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getGroupIdentifiersForMember(memberId, baseMemberId, scope, returnedIdType)");
        }
        MemberIdentifierSet memberIdentifierSet = null;
        try {
            List list;
            DataGraph dataGraph = ParameterHandler.getGroupIdentifiersForMember(memberIdentifier, memberIdentifier2, groupScope);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null && (list = dataObject.getList("entities")) != null) {
                MemberIdentifierSet memberIdentifierSet2;
                List list2 = ((DataObject)list.get(0)).getList("groups");
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberIdentifierSetAssembler.getInstance(list2));
                memberIdentifierSet = memberIdentifierSet2 = (MemberIdentifierSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getGroupIdentifiersForMember(memberId, baseMemberId, scope, returnedIdType)", memberIdentifierSet);
        }
        return memberIdentifierSet;
    }

    public MemberIdentifierSet getGroupMemberIdentifiers(MemberIdentifier memberIdentifier, GroupScope groupScope, short s, short[] sArray) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getGroupMemberIdentifiers(groupId, scope, returnedIdType, returnedMemberTypes)");
        }
        MemberIdentifierSet memberIdentifierSet = null;
        try {
            List list;
            DataGraph dataGraph = ParameterHandler.getGroupMemberIdentifiers(memberIdentifier, groupScope, sArray);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null && (list = ((DataObject)dataObject.getList("entities").get(0)).getList("members")) != null) {
                MemberIdentifierSet memberIdentifierSet2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberIdentifierSetAssembler.getInstance(list));
                memberIdentifierSet = memberIdentifierSet2 = (MemberIdentifierSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getGroupMemberIdentifiers(groupId, scope, returnedIdType, returnedMemberTypes)", memberIdentifierSet);
        }
        return memberIdentifierSet;
    }

    public MemberSet getGroupMembers(MemberIdentifier memberIdentifier, GroupScope groupScope, MemberTypeAttributeMap memberTypeAttributeMap) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getGroupMembers(groupId, scope, returnedMemberTypesAndAttributes)");
        }
        MemberSet memberSet = null;
        try {
            DataGraph dataGraph = ParameterHandler.getGroupMembers(memberIdentifier, groupScope, memberTypeAttributeMap);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null) {
                MemberSet memberSet2;
                DataObject dataObject2 = (DataObject)dataObject.getList("entities").get(0);
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberSetAssembler.getInstance(dataObject2, "members"));
                memberSet = memberSet2 = (MemberSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getGroupMembers(groupId, scope, returnedMemberTypesAndAttributes)", memberSet);
        }
        return memberSet;
    }

    public MemberSet getGroupMembers(MemberIdentifier memberIdentifier, GroupScope groupScope, MemberIdentifierSet memberIdentifierSet, MemberTypeAttributeMap memberTypeAttributeMap) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getGroupMembers(groupId, scope, returnedMemberTypesAndAttributes)");
        }
        MemberSet memberSet = null;
        try {
            DataGraph dataGraph = ParameterHandler.getGroupMembers(memberIdentifier, groupScope, memberIdentifierSet, memberTypeAttributeMap);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null) {
                MemberSet memberSet2;
                DataObject dataObject2 = (DataObject)dataObject.getList("entities").get(0);
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberSetAssembler.getInstance(dataObject2, "members"));
                memberSet = memberSet2 = (MemberSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getGroupMembers(groupId, scope, returnedMemberTypesAndAttributes)", memberSet);
        }
        return memberSet;
    }

    public MemberSet getGroupsForMember(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, GroupScope groupScope, StringSet stringSet) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getGroupMembers(groupId, scope, returnedMemberTypesAndAttributes)");
        }
        MemberSet memberSet = null;
        try {
            DataGraph dataGraph = ParameterHandler.getGroupsForMember(memberIdentifier, memberIdentifier2, groupScope, stringSet);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null) {
                MemberSet memberSet2;
                DataObject dataObject2 = (DataObject)dataObject.getList("entities").get(0);
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberSetAssembler.getInstance(dataObject2, "groups"));
                memberSet = memberSet2 = (MemberSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getGroupMembers(groupId, scope, returnedMemberTypesAndAttributes)", memberSet);
        }
        return memberSet;
    }

    public MemberSet getGroupsForMember(MemberIdentifier memberIdentifier, GroupScope groupScope, MemberIdentifierSet memberIdentifierSet, StringSet stringSet) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getGroupMembers(groupId, scope, baseMemberIdSet, attributeName)");
        }
        MemberSet memberSet = null;
        try {
            DataGraph dataGraph = ParameterHandler.getGroupsForMember(memberIdentifier, groupScope, memberIdentifierSet, stringSet);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null) {
                MemberSet memberSet2;
                DataObject dataObject2 = (DataObject)dataObject.getList("entities").get(0);
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberSetAssembler.getInstance(dataObject2, "groups"));
                memberSet = memberSet2 = (MemberSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getGroupMembers(groupId, scope, baseMemberIdSet, attributeName)", memberSet);
        }
        return memberSet;
    }

    public Member getMember(MemberIdentifier memberIdentifier, StringSet stringSet) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getMember(mbrid, attributeNames)", "(" + memberIdentifier + ", " + stringSet + ")");
        }
        Member member = null;
        try {
            List list;
            DataGraph dataGraph = ParameterHandler.getMember(memberIdentifier, stringSet);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                DataObject dataObject3 = dataObject;
                list = dataObject3.getList("entities");
                if (list.size() == 0) {
                    throw new EntityNotFoundException("GENERIC", WIMMessageHelper.generateMsgParms("returned entities is empty"), CLASSNAME, "getMember(mbrid, attributeNames)");
                }
            } else {
                throw new EntityNotFoundException("GENERIC", WIMMessageHelper.generateMsgParms("returned data graph is null"), CLASSNAME, "getMember(mbrid, attributeNames)");
            }
            dataObject2 = (DataObject)list.get(0);
            DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberAssembler.getInstance(dataObject2));
            member = (Member)dataObjectAssembler.assemble();
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getMember(mbrid, attributeNames)", member);
        }
        return member;
    }

    public Member getMember(MemberIdentifier memberIdentifier, StringSet stringSet, String string) throws RemoteException, WMMException {
        return this.getMember(memberIdentifier, stringSet);
    }

    public MemberIdentifier getMemberIdentifier(String string) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getMemberIdentifier(externalDn)", "(" + string + ")");
        }
        MemberIdentifier memberIdentifier = null;
        try {
            Object object;
            DataGraph dataGraph = ParameterHandler.getMemberIdentifier(string);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null && (object = dataObject.getList("entities")) != null && object.size() > 0) {
                dataObject2 = ((DataObject)object.get(0)).getDataObject("identifier");
            }
            if (dataObject2 != null) {
                MemberIdentifier memberIdentifier2;
                object = new DataObjectAssembler(MemberIdentifierAssembler.getInstance(dataObject2));
                memberIdentifier = memberIdentifier2 = (MemberIdentifier)object.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getMemberIdentifier(externalDn)", memberIdentifier);
        }
        return memberIdentifier;
    }

    public MemberList getMembers(short s, MemberIdentifierSet memberIdentifierSet, StringSet stringSet, SortControl sortControl) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getMembers(memberType, memberIds, attributeNames, sortControl)", "(" + s + ", " + memberIdentifierSet + ", " + stringSet + ", " + sortControl + ")");
        }
        MemberList memberList = null;
        try {
            DataGraph dataGraph = ParameterHandler.getMembers(s, memberIdentifierSet, stringSet, sortControl);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                dataObject2 = dataObject;
            }
            if (dataObject2 != null) {
                MemberList memberList2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberListAssembler.getInstance(dataObject2));
                memberList = memberList2 = (MemberList)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getMembers(memberType, memberIds, attributeNames, sortControl)", memberList);
        }
        return memberList;
    }

    public MemberList getMembers(short s, MemberIdentifierSet memberIdentifierSet, StringSet stringSet, String string, SortControl sortControl) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getMembers(memberType, memberIds, attributeNames, sortControl)", "(" + s + ", " + memberIdentifierSet + ", " + stringSet + ", " + string + ", " + sortControl + ")");
        }
        MemberList memberList = this.getMembers(s, memberIdentifierSet, stringSet, sortControl);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getMembers(memberType, memberIds, attributeNames, sortControl)", memberList);
        }
        return memberList;
    }

    public MemberSet getMembers(short s, MemberIdentifierSet memberIdentifierSet, StringSet stringSet) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getMembers(memberType, memberIds, attributeNames, sortControl)", "(" + s + ", " + memberIdentifierSet + ", " + stringSet + ")");
        }
        MemberSet memberSet = null;
        try {
            DataGraph dataGraph = ParameterHandler.getMembers(s, memberIdentifierSet, stringSet, null);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                dataObject2 = dataObject;
            }
            if (dataObject2 != null) {
                MemberSet memberSet2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberSetAssembler.getInstance(dataObject2, "entities"));
                memberSet = memberSet2 = (MemberSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getMembers(memberType, memberIds, attributeNames, sortControl)", memberSet);
        }
        return memberSet;
    }

    public MemberSet getMembers(short s, MemberIdentifierSet memberIdentifierSet, StringSet stringSet, String string) throws RemoteException, WMMException {
        return this.getMembers(s, memberIdentifierSet, stringSet);
    }

    public MemberList getMembersRecursively(MemberIdentifier memberIdentifier, String string, StringSet stringSet, int n) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getMembersRecursively(memberId, recursionAttributeName, returnAttrNames, maxListSize)", "(" + memberIdentifier + ", " + string + ", " + stringSet + ", " + n + ")");
        }
        Object var6_5 = null;
        throw new OperationNotSupportedException("GENERIC", CLASSNAME, "getMembersRecursively(memberId, recursionAttributeName, returnAttrNames, maxListSize)", WIMMessageHelper.generateMsgParms("getMembersRecursively(memberId, recursionAttributeName, returnAttrNames, maxListSize)"));
    }

    public Member getPersonByAccountName(String string, String string2, StringSet stringSet) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getPersonByAccountName(accountName, realmName, attributeNames)", "(" + string + ", " + string2 + ", " + stringSet + ")");
        }
        Member member = null;
        try {
            List list;
            DataGraph dataGraph = ParameterHandler.getPersonByAccountName(string, string2, stringSet);
            DataObject dataObject = ServiceProvider.singleton().search(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                DataObject dataObject3 = dataObject;
                list = dataObject3.getList("entities");
                if (list.size() == 0) {
                    throw new EntityNotFoundException("GENERIC", WIMMessageHelper.generateMsgParms("returned entities is empty"), CLASSNAME, "getPersonByAccountName(accountName, realmName, attributeNames)");
                }
                if (list.size() > 1) {
                    throw new MultipleEntriesFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getPersonByAccountName(accountName, realmName, attributeNames)");
                }
            } else {
                throw new EntityNotFoundException("GENERIC", WIMMessageHelper.generateMsgParms("returned data graph is null"), CLASSNAME, "getPersonByAccountName(accountName, realmName, attributeNames)");
            }
            dataObject2 = (DataObject)list.get(0);
            DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberAssembler.getInstance(dataObject2));
            member = (Member)dataObjectAssembler.assemble();
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getPersonByAccountName(accountName, realmName, attributeNames)", member);
        }
        return member;
    }

    public Member getPersonByAccountName(String string, String string2, StringSet stringSet, String string3) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getPersonByAccountName(accountName, realmName, attributeNames, context)", "(" + string + ", " + string2 + ", " + stringSet + ", " + string3 + ")");
        }
        Member member = this.getPersonByAccountName(string, string2, stringSet);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getPersonByAccountName(accountName, realmName, attributeNames, context)", member);
        }
        return member;
    }

    public boolean isMemberInGroup(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, GroupScope groupScope) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "isMemberInGroup(groupId, memberId, scope)", "(" + memberIdentifier + ", " + memberIdentifier2 + ", " + groupScope + ")");
        }
        boolean bl = false;
        try {
            DataGraph dataGraph = ParameterHandler.isMemberInGroup(memberIdentifier, memberIdentifier2, groupScope);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                dataObject2 = dataObject;
                Map map = ControlsHelper.getControlMap(dataObject);
                DataObject dataObject3 = (DataObject)map.get("CheckGroupMembershipControl");
                if (dataObject3 != null) {
                    bl = dataObject3.getBoolean("inGroup");
                }
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "isMemberInGroup(groupId, memberId, scope)", "" + bl);
        }
        return bl;
    }

    public MemberIdentifier moveMember(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "moveMember(memberId, parentmemberId)", "(" + memberIdentifier + ", " + memberIdentifier2 + ")");
        }
        throw new OperationNotSupportedException("GENERIC", CLASSNAME, "moveMember(memberId, parentmemberId)", WIMMessageHelper.generateMsgParms("moveMember(memberId, parentmemberId)"));
    }

    public void removeMember(MemberIdentifier memberIdentifier, boolean bl) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "removeMember(memberId, removeDescendants)", "(" + memberIdentifier + ", " + bl + ")");
        }
        try {
            DataGraph dataGraph = ParameterHandler.removeMember(memberIdentifier, bl);
            DataObject dataObject = ServiceProvider.singleton().delete(dataGraph.getRootObject().getDataObject("Root"));
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "removeMember(memberId, removeDescendants)");
        }
    }

    public MemberIdentifier renameMember(MemberIdentifier memberIdentifier, String string) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "renameMember(memberId, newMemberRDNvalue)", "(" + memberIdentifier + ", " + string + ")");
        }
        MemberIdentifier memberIdentifier2 = null;
        try {
            List list;
            DataGraph dataGraph = ParameterHandler.renameMember(memberIdentifier, string);
            DataObject dataObject = ServiceProvider.singleton().update(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null && (list = dataObject.getList("entities")) != null && list.size() > 0) {
                MemberIdentifier memberIdentifier3;
                dataObject2 = ((DataObject)list.get(0)).getDataObject("identifier");
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberIdentifierAssembler.getInstance(dataObject2));
                memberIdentifier2 = memberIdentifier3 = (MemberIdentifier)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "renameMember(memberId, newMemberRDNvalue)", memberIdentifier2);
        }
        return memberIdentifier2;
    }

    public void unassignMemberFromGroup(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "unassignMemberFromGroup(groupId, memberid)", "(" + memberIdentifier + ", " + memberIdentifier2 + ")");
        }
        try {
            if (memberIdentifier != null && memberIdentifier2 != null) {
                DataGraph dataGraph = ParameterHandler.unassignMemberFromGroup(memberIdentifier, memberIdentifier2);
                DataObject dataObject = ServiceProvider.singleton().update(dataGraph.getRootObject().getDataObject("Root"));
            } else {
                trcLogger.logp(Level.FINER, CLASSNAME, "unassignMemberFromGroup(groupId, memberid)", "groupId [" + memberIdentifier + "] or memberId [" + memberIdentifier2 + "] is null. ");
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "unassignMemberFromGroup(groupId, memberid)");
        }
    }

    public void unassignMembersFromGroup(MemberIdentifier memberIdentifier, MemberIdentifierSet memberIdentifierSet) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "unassignMembersFromGroup(groupId, memberids)", "(" + memberIdentifier + ", " + memberIdentifierSet + ")");
        }
        try {
            if (memberIdentifier != null && memberIdentifierSet != null) {
                DataGraph dataGraph = ParameterHandler.unassignMembersFromGroup(memberIdentifier, memberIdentifierSet);
                DataObject dataObject = ServiceProvider.singleton().update(dataGraph.getRootObject().getDataObject("Root"));
            } else {
                trcLogger.logp(Level.FINER, CLASSNAME, "unassignMembersFromGroup(groupId, memberids)", "groupId [" + memberIdentifier + "] or memberIds [" + memberIdentifierSet + "] is null. ");
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "unassignMembersFromGroup(groupId, memberids)");
        }
    }

    public MemberIdentifier updateMember(Member member) throws WMMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "updateMember(member)", "(" + member + ")");
        }
        MemberIdentifier memberIdentifier = null;
        try {
            DataGraph dataGraph = ParameterHandler.updateMember(member);
            DataObject dataObject = ServiceProvider.singleton().update(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                dataObject2 = dataObject.getDataObject("entities.0").getDataObject("identifier");
            }
            if (dataObject2 != null) {
                MemberIdentifier memberIdentifier2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberIdentifierAssembler.getInstance(dataObject2));
                memberIdentifier = memberIdentifier2 = (MemberIdentifier)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateMember(member)", memberIdentifier);
        }
        return memberIdentifier;
    }

    public StringSet getAttributeDatatypes(String string) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getAttributeDatatypes(path)", "(" + string + ")");
        }
        StringSet stringSet = null;
        try {
            DataGraph dataGraph = ParameterHandler.getAttributeDatatypes(string);
            DataObject dataObject = ServiceProvider.singleton().getSchema(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                StringSet stringSet2;
                dataObject2 = dataObject;
                List list = dataObject2.getDataObject("schema").getList("propertyDataTypes");
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(StringSetAssembler.getInstance(list));
                stringSet = stringSet2 = (StringSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getAttributeDatatypes(path)", stringSet);
        }
        return stringSet;
    }

    public MemberIdentifierSet getDescendantIdentifiers(MemberIdentifier memberIdentifier, short s, short s2, short[] sArray) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getDescendantIdentifiers(memberid, scope, returnedIdTypes)", "(" + memberIdentifier + ", " + s + ", " + s2 + ", " + sArray + ")");
        }
        MemberIdentifierSet memberIdentifierSet = null;
        try {
            DataGraph dataGraph = ParameterHandler.getDescendants(memberIdentifier, s);
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            List list = null;
            if (dataObject != null) {
                list = dataObject.getList("entities");
            }
            if (list != null) {
                MemberIdentifierSet memberIdentifierSet2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberIdentifierSetAssembler.getInstance(list));
                memberIdentifierSet = memberIdentifierSet2 = (MemberIdentifierSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDescendantIdentifiers(memberid, scope, returnedIdTypes)", memberIdentifierSet);
        }
        return memberIdentifierSet;
    }

    public StringSet getLookAsideAttributeDatatypes() throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getLookasideAttributeDatatypes()");
        }
        StringSet stringSet = null;
        try {
            DataGraph dataGraph = ParameterHandler.getLookasideAttributeDatatypes();
            DataObject dataObject = ServiceProvider.singleton().get(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                dataObject2 = dataObject;
            }
            if (dataObject2 != null) {
                StringSet stringSet2;
                List list = dataObject2.getDataObject("schema").getList("propertyDataTypes");
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(StringSetAssembler.getInstance(list));
                stringSet = stringSet2 = (StringSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getLookasideAttributeDatatypes()", stringSet);
        }
        return stringSet;
    }

    public MemberSet search(short s, SearchCriteria searchCriteria, StringSet stringSet, int n, int n2) throws WMMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "search(memberType, searchCriteria, resultAttributes,searchTimeout,maxSearchResults)");
        }
        MemberSet memberSet = null;
        try {
            DataGraph dataGraph = ParameterHandler.search(s, searchCriteria, stringSet, n, n2);
            DataObject dataObject = ServiceProvider.singleton().search(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null) {
                MemberSet memberSet2;
                DataObject dataObject2 = dataObject;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberSetAssembler.getInstance(dataObject2, "entities"));
                memberSet = memberSet2 = (MemberSet)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "search(memberType, searchCriteria, resultAttributes,searchTimeout,maxSearchResults)", memberSet);
        }
        return memberSet;
    }

    public MemberSet search(short s, StringSet stringSet, String string, StringSet stringSet2, int n, int n2) throws WMMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "search(memberType, searchBases, searchExpression, requestedAttributes,timeout,maxResult)");
        }
        throw new WMMSystemException("GQL search -> Unsupported method. ");
    }

    public SearchResponseControl search(short s, SearchCriteria searchCriteria, SortControl sortControl, PageControl pageControl, StringSet stringSet, int n, int n2) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "search(memberType, searchCriteria, resultAttributes,searchTimeout,maxSearchResults)");
        }
        SearchResponseControl searchResponseControl = null;
        try {
            DataGraph dataGraph = ParameterHandler.search(s, searchCriteria, sortControl, pageControl, stringSet, n, n2);
            DataObject dataObject = ServiceProvider.singleton().search(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null) {
                SearchResponseControl searchResponseControl2;
                DataObject dataObject2 = dataObject;
                boolean bl = false;
                if (sortControl != null) {
                    bl = true;
                }
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(SearchResponseControlAssembler.getInstance(dataObject2, bl));
                searchResponseControl = searchResponseControl2 = (SearchResponseControl)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "search(memberType, searchCriteria, resultAttributes,searchTimeout,maxSearchResults)", searchResponseControl);
        }
        return searchResponseControl;
    }

    public SearchResponseControl searchAgain(PageControl pageControl) throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "searchAgain(pageCtrl)");
        }
        SearchResponseControl searchResponseControl = null;
        try {
            DataGraph dataGraph = ParameterHandler.searchAgain(pageControl);
            DataObject dataObject = ServiceProvider.singleton().search(dataGraph.getRootObject().getDataObject("Root"));
            if (dataObject != null) {
                SearchResponseControl searchResponseControl2;
                DataObject dataObject2 = dataObject;
                boolean bl = false;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(SearchResponseControlAssembler.getInstance(dataObject2, bl));
                searchResponseControl = searchResponseControl2 = (SearchResponseControl)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "searchAgain(pageCtrl)", searchResponseControl);
        }
        return searchResponseControl;
    }

    public Member checkPassword(String string, String string2, StringSet stringSet, StringSet stringSet2) throws RemoteException, EntryNotFoundException, PasswordCheckFailedException, com.ibm.websphere.wmm.exception.MultipleEntriesFoundException, NotImplementedException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "checkPassword(userSecurityName, password, searchBases, requestedAttributes)", "(" + string + ", " + string2 + ", " + stringSet + ", " + stringSet2 + ")");
        }
        Member member = null;
        try {
            DataGraph dataGraph = ParameterHandler.checkPassword(string, string2, stringSet, stringSet2);
            DataObject dataObject = ServiceProvider.singleton().login(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                dataObject2 = (DataObject)dataObject.getList("entities").get(0);
            }
            if (dataObject2 != null) {
                Member member2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberAssembler.getInstance(dataObject2));
                member = member2 = (Member)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "checkPassword(userSecurityName, password, searchBases, requestedAttributes)", member);
        }
        return member;
    }

    public Member checkPassword(String string, String string2, StringSet stringSet, StringSet stringSet2, String string3) throws RemoteException, EntryNotFoundException, PasswordCheckFailedException, com.ibm.websphere.wmm.exception.MultipleEntriesFoundException, NotImplementedException, WMMException {
        return this.checkPassword(string, string2, stringSet, stringSet2);
    }

    public Member mapCertificate(X509Certificate[] x509CertificateArray, StringSet stringSet) throws RemoteException, CertificateMapNotSupportedException, CertificateMapFailedException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "checkPassword(userSecurityName, password, searchBases, requestedAttributes)");
        }
        Member member = null;
        try {
            DataGraph dataGraph = ParameterHandler.mapCertificate(x509CertificateArray, stringSet);
            DataObject dataObject = ServiceProvider.singleton().login(dataGraph.getRootObject().getDataObject("Root"));
            DataObject dataObject2 = null;
            if (dataObject != null) {
                dataObject2 = dataObject.getDataObject("entities");
            }
            if (dataObject2 != null) {
                Member member2;
                DataObjectAssembler dataObjectAssembler = new DataObjectAssembler(MemberAssembler.getInstance(dataObject2));
                member = member2 = (Member)dataObjectAssembler.assemble();
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "checkPassword(userSecurityName, password, searchBases, requestedAttributes)", member);
        }
        return member;
    }

    public ConfigurationData getConfigurationData() throws RemoteException, WMMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getConfigurationData()");
        }
        ConfigurationDataImpl configurationDataImpl = new ConfigurationDataImpl();
        try {
            ConfigurationProviderType configurationProviderType = (ConfigurationProviderType)ServiceProvider.singleton().getConfig();
            RealmConfigurationType realmConfigurationType = configurationProviderType.getRealmConfiguration();
            if (realmConfigurationType != null) {
                String string = realmConfigurationType.getDefaultRealm();
                List list = realmConfigurationType.getRealms();
                int n = list.size();
                HashMap<String, WMMRealm> hashMap = new HashMap<String, WMMRealm>();
                for (int i = 0; i < n; ++i) {
                    Set<Object> set;
                    Object object;
                    RealmType realmType = (RealmType)list.get(i);
                    if (realmType == null) continue;
                    WMMRealm wMMRealm = new WMMRealm();
                    String string2 = realmType.getName();
                    wMMRealm.setRealmId(string2);
                    String string3 = realmType.getDelimiter();
                    wMMRealm.setDelimiter(string3);
                    if (string.equals(string2)) {
                        wMMRealm.setDefaultRealm(true);
                    }
                    List list2 = realmType.getDefaultParents();
                    Set set2 = null;
                    HashMap<String, HashSet<String[]>> hashMap2 = null;
                    if (list2 != null && list2.size() != 0) {
                        for (int j = 0; j < list2.size(); ++j) {
                            if (hashMap2 == null) {
                                hashMap2 = new HashMap<String, HashSet<String[]>>();
                            }
                            RealmDefaultParentType realmDefaultParentType = (RealmDefaultParentType)list2.get(j);
                            object = realmDefaultParentType.getEntityTypeName();
                            String string4 = realmDefaultParentType.getParentUniqueName();
                            set = (Set)hashMap2.get(string4.toLowerCase());
                            if (set == null) {
                                set = new HashSet<String[]>();
                            }
                            set.add(object);
                            hashMap2.put(string4.toLowerCase(), (HashSet<String[]>)set);
                        }
                        set2 = hashMap2.keySet();
                    }
                    List list3 = realmType.getParticipatingBaseEntries();
                    int n2 = list3.size();
                    object = new String[n2];
                    for (int j = 0; j < n2; ++j) {
                        String string5;
                        set = (ParticipatingBaseEntriesType)list3.get(j);
                        object[j] = string5 = set.getName();
                        if (set2 == null || !set2.contains(string5.toLowerCase())) continue;
                        Set set3 = (Set)hashMap2.get(string5.toLowerCase());
                        for (String string6 : set3) {
                            wMMRealm.setDefaultParent(EntityTypeResolver.getWmmEntityType(string6, string5), string5);
                        }
                    }
                    wMMRealm.setWmmNodes((String[])object);
                    hashMap.put(string2, wMMRealm);
                }
                WMMRealms wMMRealms = new WMMRealms(hashMap);
                configurationDataImpl.setValue("WMMUR", wMMRealms);
            }
        }
        catch (WIMException wIMException) {
            throw ExceptionConverter.toWMMException(wIMException);
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new WMMSystemException(exception);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getConfigurationData()");
        }
        return configurationDataImpl;
    }

    public String getWIMPropName(String string) {
        String string2 = (String)this.wmmwimAttrMap.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public String getWMMAttrName(String string) {
        String string2 = (String)this.wimwmmAttrMap.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public boolean isPropertyMultiValue(String string, String string2) {
        DataObject dataObject = (DataObject)this.entitySchema.get(string);
        DataObject dataObject2 = dataObject.getDataObject("propertySchema[propertyName=" + string2 + "]");
        boolean bl = false;
        if (dataObject2 != null) {
            bl = dataObject2.getBoolean("multiValued");
        }
        return bl;
    }

    public String getPropertyDataType(String string, String string2) {
        DataObject dataObject = (DataObject)this.entitySchema.get(string);
        DataObject dataObject2 = dataObject.getDataObject("propertySchema[propertyName=" + string2 + "]");
        String string3 = "String";
        if (dataObject2 != null) {
            string3 = dataObject2.getString("dataType");
        }
        return string3;
    }

    protected void addIdentifier(DataObject dataObject, MemberIdentifier memberIdentifier) {
        if (memberIdentifier.getMemberDN() != null) {
            dataObject.setString("uniqueName", memberIdentifier.getMemberDN());
        }
        if (memberIdentifier.getMemberUniqueId() != null) {
            dataObject.setString("uniqueId", memberIdentifier.getMemberUniqueId());
        }
    }

    public Object getPropertyValue(String string, Object object) {
        if (string.equals("DateTime") || string.equals("Date")) {
            Timestamp timestamp = (Timestamp)object;
            return SDOHelper.getDateString(new Date(timestamp.getTime()));
        }
        if (string.equals("IdentifierType")) {
            MemberIdentifier memberIdentifier = (MemberIdentifier)object;
            DataObject dataObject = SDOHelper.createDataObject("http://www.ibm.com/websphere/wim", "IdentifierType");
            this.addIdentifier(dataObject, memberIdentifier);
            return dataObject;
        }
        if (string.equals("Int") && object instanceof String) {
            try {
                return new Integer((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
        }
        return object;
    }

    public Object getAttributeValue(String string, Object object) {
        if (string.equals("DateTime")) {
            String string2 = (String)object;
            string2 = string2.substring(0, 23);
            string2 = string2.replace('T', ' ');
            return Timestamp.valueOf(string2);
        }
        if (string.equals("IdentifierType")) {
            MemberIdentifierData memberIdentifierData = new MemberIdentifierData();
            DataObject dataObject = (DataObject)object;
            memberIdentifierData.setMemberDN(dataObject.getString("uniqueName"));
            memberIdentifierData.setMemberUniqueId(dataObject.getString("uniqueId"));
            return memberIdentifierData;
        }
        return object;
    }

    public void addEntityDataObject(DataObject dataObject, Member member) throws WIMException {
        MemberIdentifier memberIdentifier;
        String string = EntityTypeResolver.getWimEntityType(member.getMemberType());
        DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", string);
        MemberIdentifier memberIdentifier2 = member.getMemberIdentifier();
        if (memberIdentifier2 != null) {
            this.addIdentifier(dataObject2.createDataObject("identifier"), memberIdentifier2);
        }
        if ((memberIdentifier = member.getParentMemberIdentifier()) != null) {
            this.addIdentifier(dataObject2.createDataObject("parent").createDataObject("identifier"), memberIdentifier);
        }
        Attributes attributes2 = member.getAttributes();
        StringIterator stringIterator = attributes2.getAttributeNames().iterator();
        while (stringIterator.hasNext()) {
            String string2;
            String string3 = stringIterator.next();
            String string4 = this.getWIMPropName(string3);
            List list = attributes2.getAttribute(string3).getValues();
            if (string4.equals("password")) {
                string2 = (String)list.get(0);
                dataObject2.setBytes(string4, PasswordUtil.getByteArrayPassword(string2));
                continue;
            }
            string2 = this.getPropertyDataType(string, string4);
            if (this.isPropertyMultiValue(string, string4)) {
                for (int i = 0; i < list.size(); ++i) {
                    dataObject2.getList(string4).add(this.getPropertyValue(string2, list.get(i)));
                }
                continue;
            }
            dataObject2.set(string4, this.getPropertyValue(string2, list.get(0)));
        }
    }

    protected EObject getEAttribute(String string, String string2) {
        EClassifier eClassifier;
        String string3 = "EObject getEAttribute(" + string + ", " + string2 + ")";
        EStructuralFeature eStructuralFeature = null;
        if (string2.equalsIgnoreCase("userPassword")) {
            string2 = "password";
        }
        if ((eClassifier = this.schema.getEClassifier(string)) instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            EStructuralFeature eStructuralFeature2 = eClass.getEStructuralFeature(string2);
            String string4 = eStructuralFeature2.getEType().getName();
            if (eStructuralFeature2 instanceof EAttributeImpl) {
                eStructuralFeature = eStructuralFeature2;
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, string3, "Retrun eAttribute: " + eStructuralFeature);
                }
            }
        }
        return eStructuralFeature;
    }

    protected boolean isAttributeMultiValue(String string, String string2) {
        String string3 = "isAttributeMultiValue(" + string + ", " + string2 + ")";
        boolean bl = false;
        EObject eObject = this.getEAttribute(string, string2);
        EAttributeImpl eAttributeImpl = (EAttributeImpl)eObject;
        int n = eAttributeImpl.getUpperBound();
        if (n > 1 || n == -1) {
            bl = true;
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, string3, "Retrun result: " + bl);
        }
        return bl;
    }

    protected EPackage getSchema() {
        return this.schema;
    }

    protected String getAttributeType(String string, String string2) {
        String string3 = "getAttributeType(" + string + ", " + string2 + ")";
        String string4 = null;
        EObject eObject = this.getEAttribute(string, string2);
        EAttributeImpl eAttributeImpl = (EAttributeImpl)eObject;
        EDataType eDataType = eAttributeImpl.getEAttributeType();
        string4 = eDataType.getClass().getName();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.logp(Level.FINEST, CLASSNAME, string3, "Retrun result: " + string4);
        }
        return string4;
    }
}

