/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler;

import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.websphere.wmm.datatype.AttributeDefinition;
import com.ibm.websphere.wmm.datatype.GroupScope;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.MemberIdentifierIterator;
import com.ibm.websphere.wmm.datatype.MemberIdentifierSet;
import com.ibm.websphere.wmm.datatype.MemberTypeAttributeMap;
import com.ibm.websphere.wmm.datatype.SortControl;
import com.ibm.websphere.wmm.datatype.SortKey;
import com.ibm.websphere.wmm.datatype.StringIterator;
import com.ibm.websphere.wmm.datatype.StringSet;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.bridge.adapter.WMM2WIMBridgeAdapter;
import com.ibm.ws.wim.bridge.assembler.Assembler;
import com.ibm.ws.wim.bridge.assembler.AssemblerImpl;
import com.ibm.ws.wim.bridge.util.EntityTypeResolver;
import com.ibm.ws.wmm.datatype.impl.StringSetFactory;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataGraphAssembler
extends AssemblerImpl {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DataGraphAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    protected DataGraph result = null;
    private ServiceProvider sp = null;
    private String SEARCH_PRINCIPAL_NAME_TEMPLATE = "@xsi:type='PersonAccount' and principalName='%ACCOUNT_NAME%'";

    protected DataGraphAssembler() {
    }

    public DataGraphAssembler(Assembler assembler) {
        super(assembler);
    }

    public void initialization() {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialization()");
        }
        try {
            this.result = SchemaManager.singleton().createRootDataObject().getDataGraph();
        }
        catch (WIMException wIMException) {
            wIMException.printStackTrace();
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialization()");
        }
    }

    protected ServiceProvider getServiceProvider() {
        return this.sp;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        Object object = null;
        if (this.isValidate() && !this.assembler.validate()) {
            trcLogger.logp(Level.FINER, CLASSNAME, "assemble()", "validation fail. ");
            throw new WIMApplicationException("GENERIC", CLASSNAME, "assemble()");
        }
        object = this.assembler.assemble();
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "assemble()");
        }
        return object;
    }

    protected DataObject addEntity(DataObject dataObject, MemberIdentifier memberIdentifier) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addEntity(parent, mbrId)");
        }
        DataObject dataObject2 = dataObject.createDataObject("entities");
        DataObject dataObject3 = dataObject2.createDataObject("identifier");
        dataObject3.setString("uniqueId", memberIdentifier.getMemberUniqueId());
        dataObject3.setString("uniqueName", memberIdentifier.getMemberDN());
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addEntity(parent, mbrId)");
        }
        return dataObject2;
    }

    protected DataObject addEntity(DataObject dataObject, String string, MemberIdentifier memberIdentifier) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addEntity(parent, type, mbrId)");
        }
        DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", string);
        DataObject dataObject3 = dataObject2.createDataObject("identifier");
        dataObject3.setString("uniqueId", memberIdentifier.getMemberUniqueId());
        dataObject3.setString("uniqueName", memberIdentifier.getMemberDN());
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addEntity(parent, type, mbrId)");
        }
        return dataObject2;
    }

    protected DataObject addMembers(DataObject dataObject, MemberIdentifier memberIdentifier) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addMembers(parent, mbrId)");
        }
        DataObject dataObject2 = dataObject.createDataObject("members");
        DataObject dataObject3 = dataObject2.createDataObject("identifier");
        dataObject3.setString("uniqueId", memberIdentifier.getMemberUniqueId());
        dataObject3.setString("uniqueName", memberIdentifier.getMemberDN());
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addMembers(parent, mbrId)");
        }
        return dataObject2;
    }

    protected DataObject addMember(DataObject dataObject, MemberIdentifier memberIdentifier) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addMember(prent, mbrId)");
        }
        DataObject dataObject2 = dataObject.createDataObject("members");
        DataObject dataObject3 = dataObject2.createDataObject("identifier");
        dataObject3.setString("uniqueId", memberIdentifier.getMemberUniqueId());
        dataObject3.setString("uniqueName", memberIdentifier.getMemberDN());
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addMember(prent, mbrId)");
        }
        return dataObject2;
    }

    protected DataObject addPropertySchema(DataObject dataObject, AttributeDefinition attributeDefinition) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addPropertySchema(root, attrDef)");
        }
        DataObject dataObject2 = dataObject.createDataObject("propertySchema");
        String string = attributeDefinition.getName();
        dataObject2.setString("propertyName", string);
        dataObject2.setString("nsURI", "http://www.ibm.com/websphere/wmm");
        Map map = attributeDefinition.getMetaData();
        for (String string2 : map.keySet()) {
            String string3 = (String)map.get(string2);
            DataObject dataObject3 = dataObject2.createDataObject("metaData");
            dataObject3.setString("name", string2);
            dataObject3.getList("values").add(string3);
            if (!trcLogger.isLoggable(Level.FINEST)) continue;
            trcLogger.logp(Level.FINEST, CLASSNAME, "addPropertySchema(root, attrDef)", "add meta data [" + string2 + "]-[" + string3 + "]");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addPropertySchema(root, attrDef)");
        }
        return dataObject2;
    }

    protected DataObject addEntitySchema(DataObject dataObject, String string) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addPropertySchema(root, entityType)");
        }
        DataObject dataObject2 = dataObject.createDataObject("entitySchema");
        dataObject2.setString("entityName", string);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addPropertySchema(root, entityType)");
        }
        return dataObject2;
    }

    protected DataObject addPropertySchema(DataObject dataObject, String string) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addPropertySchema(schema, attrName)");
        }
        DataObject dataObject2 = dataObject.createDataObject("propertySchema");
        dataObject2.setString("propertyName", string);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addPropertySchema(schema, attrName)");
        }
        return dataObject2;
    }

    protected DataObject addLookasidePropertySchema(DataObject dataObject, AttributeDefinition attributeDefinition) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addLookasidePropertySchema(schema, attrDef)");
        }
        DataObject dataObject2 = dataObject.createDataObject("ExtensionPropertyDefinitionControl");
        String string = attributeDefinition.getName();
        dataObject2.setString("propertyName", string);
        Map map = attributeDefinition.getMetaData();
        for (String string2 : map.keySet()) {
            String string3 = (String)map.get(string2);
            DataObject dataObject3 = dataObject2.createDataObject("metaData");
            dataObject3.setString("name", string2);
            dataObject3.setString("value", string3);
            if (!trcLogger.isLoggable(Level.FINEST)) continue;
            trcLogger.logp(Level.FINEST, CLASSNAME, "addLookasidePropertySchema(schema, attrDef)", "add meta data [" + string2 + "]-[" + string3 + "]");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addLookasidePropertySchema(schema, attrDef)");
        }
        return dataObject2;
    }

    protected DataObject addLookasideDatatypeControl(DataObject dataObject) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addLookasideDatatypeControl(root)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "ExtensionPropertyDataTypeControl");
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addLookasideDatatypeControl(root)");
        }
        return dataObject2;
    }

    protected void addAncestorControl(DataObject dataObject, short s) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addAncestorControl(root, scope)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "AncestorControl");
        if (s == 0) {
            dataObject2.setInt("level", 1);
        } else if (s == 1) {
            dataObject2.setInt("level", 0);
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, "addAncestorControl(root, scope)", "specified scope is not right [" + s + "], using default 1. ");
            dataObject2.setInt("level", 1);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addAncestorControl(root, scope)");
        }
    }

    protected void addRealmContext(DataObject dataObject, String string) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addRealmContext(root, realmName)");
        }
        if (string != null) {
            DataObject dataObject2 = SDOHelper.createContextDataObject(dataObject, null, "Context");
            dataObject2.setString("key", "realm");
            dataObject2.setString("value", string);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addRealmContext(root, realmName)");
        }
    }

    protected void addDescendantControl(DataObject dataObject, short s) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addDescendantControl(root, scope)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "DescendantControl");
        if (s == 1) {
            dataObject2.setInt("level", 1);
        } else if (s == 0) {
            dataObject2.setInt("level", 0);
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, "addDescendantControl(root, scope)", "specified scope is not right [" + s + "], using default 1. ");
            dataObject2.setInt("level", 1);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addDescendantControl(root, scope)");
        }
    }

    protected void addEntities(DataObject dataObject, MemberIdentifierSet memberIdentifierSet) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addEntities(root, memberIds)");
        }
        MemberIdentifierIterator memberIdentifierIterator = memberIdentifierSet.iterator();
        while (memberIdentifierIterator.hasNext()) {
            MemberIdentifier memberIdentifier = memberIdentifierIterator.next();
            if (memberIdentifier == null) continue;
            DataObject dataObject2 = dataObject.createDataObject("entities").createDataObject("identifier");
            dataObject2.setString("uniqueId", memberIdentifier.getMemberUniqueId());
            dataObject2.setString("uniqueName", memberIdentifier.getMemberDN());
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addEntities(root, memberIds)");
        }
    }

    protected void addPropertiesControl(DataObject dataObject, StringSet stringSet) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addPropertiesControl(root, attrSet)");
        }
        if (stringSet == null || stringSet.size() > 0) {
            DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
            if (stringSet == null) {
                dataObject2.getList("properties").add("*");
                dataObject2.getList("properties").add("createTimestamp");
                dataObject2.getList("properties").add("modifyTimestamp");
            } else {
                StringIterator stringIterator = stringSet.iterator();
                while (stringIterator.hasNext()) {
                    String string = stringIterator.next();
                    dataObject2.getList("properties").add(WMM2WIMBridgeAdapter.singleton().getWIMPropName(string));
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addPropertiesControl(root, attrSet)");
        }
    }

    protected void addSearchControlForPrincipalName(DataObject dataObject, String string, StringSet stringSet) {
        Object object;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addPropertiesControl(root, accountName, attrSet)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
        if (string != null) {
            object = this.SEARCH_PRINCIPAL_NAME_TEMPLATE.replaceFirst("%ACCOUNT_NAME%", string);
            dataObject2.setString("expression", (String)object);
        }
        if (stringSet == null || stringSet.size() > 0) {
            if (stringSet == null) {
                dataObject2.getList("properties").add("*");
                dataObject2.getList("properties").add("createTimestamp");
                dataObject2.getList("properties").add("modifyTimestamp");
            } else {
                object = stringSet.iterator();
                while (object.hasNext()) {
                    String string2 = object.next();
                    dataObject2.getList("properties").add(WMM2WIMBridgeAdapter.singleton().getWIMPropName(string2));
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addPropertiesControl(root, accountName, attrSet)");
        }
    }

    protected void addPropertiesFilter(DataObject dataObject, StringSet stringSet) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addPropertiesFilter(ctrl, attrSet)");
        }
        StringIterator stringIterator = stringSet.iterator();
        while (stringIterator.hasNext()) {
            String string = stringIterator.next();
            dataObject.getList("properties").add(string);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addPropertiesFilter(ctrl, attrSet)");
        }
    }

    protected void addSortControl(DataObject dataObject, SortControl sortControl) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addSortControl(root, sortControl)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SortControl");
        Locale locale = sortControl.getLocale();
        if (locale != null) {
            dataObject2.setString("locale", locale.toString());
        }
        SortKey[] sortKeyArray = sortControl.getSortKeys();
        for (int i = 0; i < sortKeyArray.length; ++i) {
            SortKey sortKey = sortKeyArray[i];
            DataObject dataObject3 = dataObject2.createDataObject("sortKeys");
            dataObject3.setString("propertyName", sortKey.getAttributeName());
            if (sortKey.isDescending()) {
                dataObject3.setBoolean("ascendingOrder", false);
                continue;
            }
            dataObject3.setBoolean("ascendingOrder", true);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addSortControl(root, sortControl)");
        }
    }

    protected void addEntityTypesFilter(DataObject dataObject, short[] sArray) throws WIMException {
        String string = "@xsi:type='";
        String string2 = "'";
        String string3 = " or ";
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addEntityTypesFilter(ctrl, types)");
        }
        if (dataObject != null && sArray != null) {
            String string4 = null;
            for (int i = 0; i < sArray.length; ++i) {
                short s = sArray[i];
                String string5 = EntityTypeResolver.getWimEntityType(s);
                string4 = string4 == null ? string + string5 + string2 : string4 + string3 + string + string5 + string2;
            }
            dataObject.setString("expression", string4);
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINER, CLASSNAME, "addEntityTypesFilter(ctrl, types)", "set search expression: " + string4);
            }
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, "addEntityTypesFilter(ctrl, types)", "ctrl or types is null.");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addEntityTypesFilter(ctrl, types)");
        }
    }

    protected DataObject addGroupMemberControlForAssign(DataObject dataObject, short s) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addGroupMemberControlForAssign(root, assignMode)", new Short(s));
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMemberControl");
        if (s == 0) {
            dataObject2.setInt("modifyMode", 1);
        } else if (s == 1) {
            dataObject2.setInt("modifyMode", 2);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addGroupMemberControlForAssign(root, assignMode)");
        }
        return dataObject2;
    }

    protected DataObject addGroupMemberControlForUnAssign(DataObject dataObject) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addGroupMemberControlForUnAssign(root)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMemberControl");
        dataObject2.setInt("modifyMode", 3);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addGroupMemberControlForUnAssign(root)");
        }
        return dataObject2;
    }

    protected DataObject addGroupMemberControl(DataObject dataObject, String string, GroupScope groupScope) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addGroupmembershipControl(root, ctrlType, groupScope)", string);
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", string);
        if (groupScope != null) {
            short s = groupScope.getGroupMembershipScope();
            short s2 = groupScope.getMembershipHierarchyScope();
            if (s == 0) {
                dataObject2.setInt("level", 1);
            } else if (s == 1) {
                dataObject2.setInt("level", 0);
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addGroupmembershipControl(root, ctrlType, groupScope)");
        }
        return dataObject2;
    }

    protected DataObject addDataTypeControl(DataObject dataObject, String string) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addDataTypeControl(root, path)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "DataTypeControl");
        dataObject2.setString("repositoryId", string);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addDataTypeControl(root, path)");
        }
        return dataObject2;
    }

    protected DataObject addLookasideDataTypeControl(DataObject dataObject) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addLookasideDataTypeControl(root)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "ExtensionPropertyDataTypeControl");
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addLookasideDataTypeControl(root)");
        }
        return dataObject2;
    }

    protected DataObject addExternalNameControl(DataObject dataObject) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addExternalNameControl(root)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "ExternalNameControl");
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addExternalNameControl(root)");
        }
        return dataObject2;
    }

    protected DataObject addCheckGroupMembershipControl(DataObject dataObject, GroupScope groupScope) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addCheckGroupMembershipControl(root, scope)");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "CheckGroupMembershipControl");
        if (groupScope != null) {
            short s = groupScope.getGroupMembershipScope();
            if (s == 0) {
                dataObject2.setInt("level", 1);
            } else if (s == 1) {
                dataObject2.setInt("level", 0);
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addCheckGroupMembershipControl(root, scope)");
        }
        return dataObject2;
    }

    protected void addSearchBase(DataObject dataObject, MemberIdentifier memberIdentifier) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addSearchBase(ctrl, baseMbrId)");
        }
        dataObject.getList("searchBases").add(memberIdentifier.getMemberDN());
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addSearchBase(ctrl, baseMbrId)");
        }
    }

    protected void addSearchBases(DataObject dataObject, MemberIdentifierSet memberIdentifierSet) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addSearchBases(ctrl, mbrIds)");
        }
        if (dataObject != null && memberIdentifierSet != null) {
            MemberIdentifierIterator memberIdentifierIterator = memberIdentifierSet.iterator();
            while (memberIdentifierIterator.hasNext()) {
                MemberIdentifier memberIdentifier = memberIdentifierIterator.next();
                String string = memberIdentifier.getMemberDN();
                dataObject.getList("searchBases").add(string);
                if (!trcLogger.isLoggable(Level.FINEST)) continue;
                trcLogger.logp(Level.FINER, CLASSNAME, "addSearchBases(ctrl, mbrIds)", "add search base: " + string);
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addSearchBases(ctrl, mbrIds)");
        }
    }

    protected void addSearchFilter(DataObject dataObject, MemberTypeAttributeMap memberTypeAttributeMap) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "addSearchBases(ctrl, filter)");
        }
        if (dataObject != null && memberTypeAttributeMap != null) {
            Object object;
            short[] sArray = memberTypeAttributeMap.getMemberTypes();
            this.addEntityTypesFilter(dataObject, sArray);
            StringSet stringSet = StringSetFactory.getInstance();
            for (int i = 0; i < sArray.length; ++i) {
                object = memberTypeAttributeMap.getAttributeNames(sArray[i]);
                if (object == null) {
                    stringSet = null;
                    break;
                }
                StringIterator stringIterator = object.iterator();
                while (stringIterator.hasNext()) {
                    String string = stringIterator.next();
                    if (stringSet.contains(string)) continue;
                    stringSet.add(string);
                }
            }
            if (stringSet == null) {
                dataObject.getList("properties").add("*");
                if (trcLogger.isLoggable(Level.FINEST)) {
                    trcLogger.logp(Level.FINER, CLASSNAME, "addSearchBases(ctrl, filter)", "retrieve all the properties.");
                }
            } else {
                StringIterator stringIterator = stringSet.iterator();
                while (stringIterator.hasNext()) {
                    object = stringIterator.next();
                    dataObject.getList("properties").add(object);
                    if (!trcLogger.isLoggable(Level.FINEST)) continue;
                    trcLogger.logp(Level.FINER, CLASSNAME, "addSearchBases(ctrl, filter)", "add attribute [" + (String)object + "]");
                }
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "addSearchBases(ctrl, filter)");
        }
    }
}

