/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.datagraph;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wmm.datatype.AttributeDefinition;
import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.ws.wim.bridge.adapter.WMM2WIMBridgeAdapter;
import com.ibm.ws.wim.bridge.assembler.DataGraphAssembler;
import commonj.sdo.DataObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateDataGraphAssembler
extends DataGraphAssembler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = CreateDataGraphAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private short constructMode = (short)-1;
    private Member mbr = null;
    private AttributeDefinition attributeDefinition = null;
    private String path = null;

    public static CreateDataGraphAssembler getInstance(Member member) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(Member mbr)", member);
        }
        CreateDataGraphAssembler createDataGraphAssembler = new CreateDataGraphAssembler();
        createDataGraphAssembler.initialization();
        createDataGraphAssembler.constructMode = (short)4;
        createDataGraphAssembler.mbr = member;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(Member mbr)", createDataGraphAssembler);
        }
        return createDataGraphAssembler;
    }

    public static CreateDataGraphAssembler getInstance(AttributeDefinition attributeDefinition, String string) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(attributeDefinition, path)");
        }
        CreateDataGraphAssembler createDataGraphAssembler = new CreateDataGraphAssembler();
        createDataGraphAssembler.initialization();
        createDataGraphAssembler.constructMode = (short)2;
        createDataGraphAssembler.attributeDefinition = attributeDefinition;
        createDataGraphAssembler.path = string;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(attributeDefinition, path)", createDataGraphAssembler);
        }
        return createDataGraphAssembler;
    }

    public static CreateDataGraphAssembler getInstance(short s, AttributeDefinition attributeDefinition) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(constructMode, attributeDefinition)");
        }
        CreateDataGraphAssembler createDataGraphAssembler = new CreateDataGraphAssembler();
        createDataGraphAssembler.initialization();
        if (s != 3) {
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("specified mode [" + s + "] not supported. "), CLASSNAME, "getInstance(constructMode, attributeDefinition)");
        }
        createDataGraphAssembler.constructMode = (short)3;
        createDataGraphAssembler.attributeDefinition = attributeDefinition;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(constructMode, attributeDefinition)", createDataGraphAssembler);
        }
        return createDataGraphAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "DataGraph assemble()");
        }
        switch (this.constructMode) {
            case 4: {
                this.createMember(this.mbr);
                break;
            }
            case 2: {
                this.createAttributeDefinition(this.attributeDefinition);
                break;
            }
            case 3: {
                this.createLookasideAttributeDefinition(this.attributeDefinition);
                break;
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "DataGraph assemble()", WIMTraceHelper.printDataGraph(this.result));
        }
        return this.result;
    }

    private void createMember(Member member) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "createMember(mbr)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        WMM2WIMBridgeAdapter.singleton().addEntityDataObject(dataObject, member);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "createMember(mbr)");
        }
    }

    private void createAttributeDefinition(AttributeDefinition attributeDefinition) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "createAttributeDefinition");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        DataObject dataObject2 = dataObject.createDataObject("schema");
        DataObject dataObject3 = this.addPropertySchema(dataObject2, attributeDefinition);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "createAttributeDefinition");
        }
    }

    private void createLookasideAttributeDefinition(AttributeDefinition attributeDefinition) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "createLookasideAttributeDefinition");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        DataObject dataObject2 = dataObject.createDataObject("schema");
        DataObject dataObject3 = this.addLookasidePropertySchema(dataObject2, attributeDefinition);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "createLookasideAttributeDefinition");
        }
    }
}

