/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.datagraph;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.ws.wim.bridge.assembler.DataGraphAssembler;
import commonj.sdo.DataObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeleteDataGraphAssembler
extends DataGraphAssembler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DeleteDataGraphAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private MemberIdentifier mbrId = null;
    private boolean removeDescendants;

    public static DeleteDataGraphAssembler getInstance(MemberIdentifier memberIdentifier, boolean bl) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(memberId, removeDescendants)");
        }
        DeleteDataGraphAssembler deleteDataGraphAssembler = new DeleteDataGraphAssembler();
        deleteDataGraphAssembler.initialization();
        deleteDataGraphAssembler.mbrId = memberIdentifier;
        deleteDataGraphAssembler.removeDescendants = bl;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(memberId, removeDescendants)");
        }
        return deleteDataGraphAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "DataGraph assemble()");
        }
        if (this.mbrId != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "Entity");
            DataObject dataObject3 = dataObject2.createDataObject("identifier");
            String string = this.mbrId.getMemberUniqueId();
            String string2 = this.mbrId.getMemberDN();
            if (string != null && string.trim().length() > 0) {
                dataObject3.setString("uniqueId", string.trim());
            }
            if (string2 != null && string2.trim().length() > 0) {
                dataObject3.setString("uniqueName", string2.trim());
            }
            DataObject dataObject4 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "DeleteControl");
            dataObject4.setBoolean("deleteDescendants", this.removeDescendants);
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, "DataGraph assemble()", "mbrId is null ");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "DataGraph assemble()");
        }
        return this.result;
    }
}

