/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.datagraph;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wmm.datatype.GroupScope;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.MemberIdentifierSet;
import com.ibm.websphere.wmm.datatype.MemberTypeAttributeMap;
import com.ibm.websphere.wmm.datatype.SortControl;
import com.ibm.websphere.wmm.datatype.StringSet;
import com.ibm.ws.wim.bridge.assembler.DataGraphAssembler;
import com.ibm.ws.wim.bridge.util.EntityTypeResolver;
import commonj.sdo.DataObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetDataGraphAssembler
extends DataGraphAssembler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = GetDataGraphAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private short constructMode = (short)-1;
    private MemberIdentifier mbrId = null;
    private MemberIdentifier grpId = null;
    private MemberIdentifier baseMbrId = null;
    private MemberIdentifierSet baseMbrIds = null;
    private short scope;
    private GroupScope groupScope = null;
    private MemberTypeAttributeMap returnedMemberTypesAndAttributes = null;
    private StringSet attributeNames = null;
    private short memberType;
    private SortControl sortControl = null;
    private MemberIdentifierSet memberIds = null;
    private String attributeName = null;
    private String path = null;
    private String externalDn = null;
    private String recursionAttrName = null;
    private StringSet returnAttrNames = null;
    private int maxListSize;
    private short[] returnedMbrTypes;

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,memberId)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s != 8) {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(mode,memberId)");
        }
        getDataGraphAssembler.initialization();
        getDataGraphAssembler.constructMode = (short)8;
        getDataGraphAssembler.mbrId = memberIdentifier;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,memberId)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(Member mbr)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        getDataGraphAssembler.initialization();
        if (s != 26) {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(Member mbr)");
        }
        getDataGraphAssembler.constructMode = (short)26;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(Member mbr)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, short s2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(methodName, memberId, scope)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s == 25) {
            getDataGraphAssembler.constructMode = (short)25;
            getDataGraphAssembler.initialization();
            getDataGraphAssembler.mbrId = memberIdentifier;
            getDataGraphAssembler.scope = s2;
        } else if (s == 5) {
            getDataGraphAssembler.constructMode = (short)5;
            getDataGraphAssembler.initialization();
            getDataGraphAssembler.mbrId = memberIdentifier;
            getDataGraphAssembler.scope = s2;
        } else {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(methodName, memberId, scope)");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(methodName, memberId, scope)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,attributeName, path)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s != 6) {
            String string3 = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "getInstance(mode,attributeName, path)");
        }
        getDataGraphAssembler.initialization();
        getDataGraphAssembler.constructMode = (short)6;
        getDataGraphAssembler.attributeName = string;
        getDataGraphAssembler.path = string2;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,attributeName, path)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,path)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        getDataGraphAssembler.initialization();
        if (s == 24) {
            getDataGraphAssembler.constructMode = (short)24;
            getDataGraphAssembler.path = string;
        } else if (s == 14) {
            getDataGraphAssembler.constructMode = (short)14;
            getDataGraphAssembler.externalDn = string;
        } else {
            String string2 = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "getInstance(mode,path)");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,path)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, short s2, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode, memberType, path)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        getDataGraphAssembler.initialization();
        if (s != 7) {
            String string2 = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "getInstance(mode, memberType, path)");
        }
        getDataGraphAssembler.constructMode = (short)7;
        getDataGraphAssembler.memberType = s2;
        getDataGraphAssembler.path = string;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode, memberType, path)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, GroupScope groupScope) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode, memberId, baseMemberId, scope)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        getDataGraphAssembler.initialization();
        if (s == 9) {
            getDataGraphAssembler.constructMode = (short)9;
            getDataGraphAssembler.mbrId = memberIdentifier;
            getDataGraphAssembler.baseMbrId = memberIdentifier2;
            getDataGraphAssembler.groupScope = groupScope;
        } else if (s == 18) {
            getDataGraphAssembler.constructMode = (short)18;
            getDataGraphAssembler.grpId = memberIdentifier;
            getDataGraphAssembler.mbrId = memberIdentifier2;
            getDataGraphAssembler.groupScope = groupScope;
        } else {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(mode, memberId, baseMemberId, scope)");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode, memberId, baseMemberId, scope)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, GroupScope groupScope, short[] sArray) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,memberId,scope,returnedTypes)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s != 10) {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(mode,memberId,scope,returnedTypes)");
        }
        getDataGraphAssembler.constructMode = (short)10;
        getDataGraphAssembler.initialization();
        getDataGraphAssembler.grpId = memberIdentifier;
        getDataGraphAssembler.groupScope = groupScope;
        getDataGraphAssembler.returnedMbrTypes = sArray;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,memberId,scope,returnedTypes)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, GroupScope groupScope, MemberTypeAttributeMap memberTypeAttributeMap) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(memberId, scope, returnedMemberTypesAndAttributes)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s != 11) {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(memberId, scope, returnedMemberTypesAndAttributes)");
        }
        getDataGraphAssembler.constructMode = (short)11;
        getDataGraphAssembler.initialization();
        getDataGraphAssembler.grpId = memberIdentifier;
        getDataGraphAssembler.groupScope = groupScope;
        getDataGraphAssembler.returnedMemberTypesAndAttributes = memberTypeAttributeMap;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(memberId, scope, returnedMemberTypesAndAttributes)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, GroupScope groupScope, MemberIdentifierSet memberIdentifierSet, MemberTypeAttributeMap memberTypeAttributeMap) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(memberId, scope, baseMemberIds, returnedMemberTypesAndAttributes)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s != 11) {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(memberId, scope, baseMemberIds, returnedMemberTypesAndAttributes)");
        }
        getDataGraphAssembler.constructMode = (short)11;
        getDataGraphAssembler.initialization();
        getDataGraphAssembler.grpId = memberIdentifier;
        getDataGraphAssembler.groupScope = groupScope;
        getDataGraphAssembler.baseMbrIds = memberIdentifierSet;
        getDataGraphAssembler.returnedMemberTypesAndAttributes = memberTypeAttributeMap;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(memberId, scope, baseMemberIds, returnedMemberTypesAndAttributes)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, GroupScope groupScope, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(memberId, scope, baseMemberIds, returnedMemberTypesAndAttributes)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s != 12) {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(memberId, scope, baseMemberIds, returnedMemberTypesAndAttributes)");
        }
        getDataGraphAssembler.constructMode = (short)12;
        getDataGraphAssembler.initialization();
        getDataGraphAssembler.mbrId = memberIdentifier;
        getDataGraphAssembler.baseMbrId = memberIdentifier2;
        getDataGraphAssembler.groupScope = groupScope;
        getDataGraphAssembler.attributeNames = stringSet;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(memberId, scope, baseMemberIds, returnedMemberTypesAndAttributes)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(memberId, returnedMemberTypesAndAttributes)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s != 13) {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(memberId, returnedMemberTypesAndAttributes)");
        }
        getDataGraphAssembler.constructMode = (short)13;
        getDataGraphAssembler.initialization();
        getDataGraphAssembler.mbrId = memberIdentifier;
        getDataGraphAssembler.attributeNames = stringSet;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(memberId, returnedMemberTypesAndAttributes)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifier memberIdentifier, GroupScope groupScope, MemberIdentifierSet memberIdentifierSet, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(memberId, scope, baseMemberIds, returnedMemberTypesAndAttributes)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s != 12) {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(memberId, scope, baseMemberIds, returnedMemberTypesAndAttributes)");
        }
        getDataGraphAssembler.constructMode = (short)12;
        getDataGraphAssembler.initialization();
        getDataGraphAssembler.mbrId = memberIdentifier;
        getDataGraphAssembler.baseMbrIds = memberIdentifierSet;
        getDataGraphAssembler.groupScope = groupScope;
        getDataGraphAssembler.attributeNames = stringSet;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(memberId, scope, baseMemberIds, returnedMemberTypesAndAttributes)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, short s2, MemberIdentifierSet memberIdentifierSet, StringSet stringSet, SortControl sortControl) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(mode,memberType, memberIds, attributeNames, sortControl)");
        }
        GetDataGraphAssembler getDataGraphAssembler = new GetDataGraphAssembler();
        if (s != 15) {
            String string = "specified mode [" + s + "] not support. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getInstance(mode,memberType, memberIds, attributeNames, sortControl)");
        }
        getDataGraphAssembler.constructMode = (short)15;
        getDataGraphAssembler.initialization();
        getDataGraphAssembler.memberType = s2;
        getDataGraphAssembler.memberIds = memberIdentifierSet;
        getDataGraphAssembler.attributeNames = stringSet;
        getDataGraphAssembler.sortControl = sortControl;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(mode,memberType, memberIds, attributeNames, sortControl)");
        }
        return getDataGraphAssembler;
    }

    public static GetDataGraphAssembler getInstance(short s, MemberIdentifierSet memberIdentifierSet, StringSet stringSet) throws WIMException {
        return GetDataGraphAssembler.getInstance((short)15, s, memberIdentifierSet, stringSet, null);
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        switch (this.constructMode) {
            case 5: {
                this.getAncestorIdentifiers(this.mbrId, this.scope);
                break;
            }
            case 25: {
                this.getDescendantIdentifiers(this.mbrId, this.scope);
                break;
            }
            case 9: {
                this.getGroupIdentifiersForMember();
                break;
            }
            case 10: {
                this.getGroupMemberIdentifiers(this.grpId, this.groupScope, this.returnedMbrTypes);
                break;
            }
            case 11: {
                this.getGroupMembers(this.grpId, this.groupScope, this.baseMbrIds, this.returnedMemberTypesAndAttributes);
                break;
            }
            case 12: {
                this.getGroupsForMember(this.mbrId, this.baseMbrId, this.baseMbrIds, this.groupScope, this.attributeNames);
                break;
            }
            case 13: {
                this.getMember();
                break;
            }
            case 15: {
                this.getMembers(this.memberType, this.memberIds, this.attributeNames, this.sortControl);
                break;
            }
            case 6: {
                this.getAttributeDefinition(this.attributeName, this.path);
                break;
            }
            case 7: {
                this.getAttributeDefinitions(this.memberType, this.path);
                break;
            }
            case 24: {
                this.getAttributeDatatypes(this.path);
                break;
            }
            case 26: {
                this.getLookasideAttributeDatatypes();
                break;
            }
            case 8: {
                this.getExternalDn(this.mbrId);
                break;
            }
            case 14: {
                this.getMemberIdentifier(this.externalDn);
                break;
            }
            case 18: {
                this.isMemberInGroup(this.grpId, this.mbrId, this.groupScope);
                break;
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "assemble()", WIMTraceHelper.printDataGraph(this.result));
        }
        return this.result;
    }

    private void isMemberInGroup(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, GroupScope groupScope) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "isMemberInGroup(grpId, mbrId, scope)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        if (memberIdentifier == null || memberIdentifier2 == null) {
            String string = "specified grpId [" + memberIdentifier + "] or mbrId [" + memberIdentifier2 + "] is null. ";
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "isMemberInGroup(grpId, mbrId, scope)");
        }
        DataObject dataObject2 = this.addEntity(dataObject, "Group", memberIdentifier);
        DataObject dataObject3 = dataObject2.createDataObject("members");
        DataObject dataObject4 = dataObject3.createDataObject("identifier");
        dataObject4.setString("uniqueId", memberIdentifier2.getMemberUniqueId());
        dataObject4.setString("uniqueName", memberIdentifier2.getMemberDN());
        this.addCheckGroupMembershipControl(dataObject, groupScope);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "isMemberInGroup(grpId, mbrId, scope)");
        }
    }

    private void getMemberIdentifier(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getMemberIdentifier(externalDn)");
        }
        if (string == null) {
            throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("extDn is null"), CLASSNAME, "getMemberIdentifier(externalDn)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        DataObject dataObject2 = dataObject.createDataObject("entities");
        DataObject dataObject3 = dataObject2.createDataObject("identifier");
        dataObject3.setString("externalName", string);
        this.addExternalNameControl(dataObject);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getMemberIdentifier(externalDn)");
        }
    }

    private void getExternalDn(MemberIdentifier memberIdentifier) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getExternalDn(mbrId)");
        }
        if (memberIdentifier != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            DataObject dataObject2 = dataObject.createDataObject("entities").createDataObject("identifier");
            dataObject2.setString("externalName", memberIdentifier.getMemberDN());
            DataObject dataObject3 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "ExternalNameControl");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getExternalDn(mbrId)");
        }
    }

    private void getLookasideAttributeDatatypes() {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getLookasideAttributeDatatypes()");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        this.addLookasideDataTypeControl(dataObject);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getLookasideAttributeDatatypes()");
        }
    }

    private void getAttributeDatatypes(String string) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getAttributeDatatypes(path)", "(" + string + ")");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        this.addDataTypeControl(dataObject, string);
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getAttributeDatatypes(path)");
        }
    }

    private void getAttributeDefinition(String string, String string2) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getAttributeDefinition(attrName,path)", "(" + string + ", " + string2 + ")");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyDefinitionControl");
        dataObject2.setString("entityTypeName", "PersonAccount");
        if (string != null) {
            dataObject2.getList("propertyNames").add(string);
        }
        if (string2 == null || string2.length() == 0) {
            trcLogger.logp(Level.FINER, CLASSNAME, "getAttributeDefinition(attrName,path)", "specified path is empty, leave repositoryId in datagraph null. ");
        } else {
            dataObject2.setString("repositoryId", string2);
            trcLogger.logp(Level.FINER, CLASSNAME, "getAttributeDefinition(attrName,path)", "specified path is not empty, set repositoryId in datagraph[" + string2 + "]");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getAttributeDefinition(attrName,path)");
        }
    }

    private void getAttributeDefinitions(short s, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getAttributeDefinitions(mbrType, path)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        String string2 = EntityTypeResolver.getWimEntityType(s);
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyDefinitionControl");
        dataObject2.setString("entityTypeName", string2);
        if (string == null || string.length() == 0) {
            trcLogger.logp(Level.FINER, CLASSNAME, "getAttributeDefinitions(mbrType, path)", "specified path is empty, leave repositoryId in datagraph null. ");
        } else {
            dataObject2.setString("repositoryId", string);
            trcLogger.logp(Level.FINER, CLASSNAME, "getAttributeDefinitions(mbrType, path)", "specified path is not empty, set repositoryId in datagraph[" + string + "]");
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getAttributeDefinitions(mbrType, path)");
        }
    }

    private void getAncestorIdentifiers(MemberIdentifier memberIdentifier, short s) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getAncestorIdentifiers(mbrId,scope)");
        }
        if (memberIdentifier != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            this.addEntity(dataObject, memberIdentifier);
            this.addAncestorControl(dataObject, s);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getAncestorIdentifiers(mbrId,scope)");
        }
    }

    private void getDescendantIdentifiers(MemberIdentifier memberIdentifier, short s) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getDescendantIdentifiers(mbrId,scope)");
        }
        if (memberIdentifier != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            this.addEntity(dataObject, memberIdentifier);
            this.addDescendantControl(dataObject, s);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getDescendantIdentifiers(mbrId,scope)");
        }
    }

    private void getGroupIdentifiersForMember() {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupIdentifiersForMember()");
        }
        if (this.mbrId != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            this.addEntity(dataObject, this.mbrId);
            if (this.groupScope != null) {
                DataObject dataObject2 = this.addGroupMemberControl(dataObject, "GroupMembershipControl", this.groupScope);
                this.addSearchBase(dataObject2, this.baseMbrId);
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupIdentifiersForMember()");
        }
    }

    private void getGroupsForMember(MemberIdentifier memberIdentifier, MemberIdentifier memberIdentifier2, MemberIdentifierSet memberIdentifierSet, GroupScope groupScope, StringSet stringSet) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupsForMember(id,baseId,baseIds,gScope,attrs)");
        }
        if (this.mbrId != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            this.addEntity(dataObject, memberIdentifier);
            DataObject dataObject2 = null;
            if (this.groupScope != null) {
                dataObject2 = this.addGroupMemberControl(dataObject, "GroupMembershipControl", groupScope);
            }
            if (memberIdentifier2 != null) {
                if (dataObject2 == null) {
                    dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMembershipControl");
                }
                this.addSearchBase(dataObject2, this.baseMbrId);
            }
            if (memberIdentifierSet != null) {
                if (dataObject2 == null) {
                    dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMembershipControl");
                }
                this.addSearchBases(dataObject2, memberIdentifierSet);
            }
            if (stringSet != null) {
                if (dataObject2 == null) {
                    dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMembershipControl");
                }
                this.addPropertiesFilter(dataObject2, stringSet);
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupsForMember(id,baseId,baseIds,gScope,attrs)");
        }
    }

    private void getGroupMemberIdentifiers(MemberIdentifier memberIdentifier, GroupScope groupScope, short[] sArray) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupMemberIdentifiers(mbrId,scope,types)");
        }
        if (memberIdentifier != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            this.addEntity(dataObject, memberIdentifier);
            DataObject dataObject2 = null;
            if (this.groupScope != null) {
                dataObject2 = this.addGroupMemberControl(dataObject, "GroupMemberControl", this.groupScope);
            }
            if (sArray != null) {
                this.addEntityTypesFilter(dataObject2, sArray);
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupMemberIdentifiers(mbrId,scope,types)");
        }
    }

    private void getGroupMembers(MemberIdentifier memberIdentifier, GroupScope groupScope, MemberIdentifierSet memberIdentifierSet, MemberTypeAttributeMap memberTypeAttributeMap) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getGroupMembers(grpid,groupscope,memberids,returnedMemberTypeAndAttributes)");
        }
        if (memberIdentifier != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            this.addEntity(dataObject, memberIdentifier);
            DataObject dataObject2 = this.addGroupMemberControl(dataObject, "GroupMemberControl", groupScope);
            if (this.baseMbrIds != null) {
                this.addSearchBases(dataObject2, memberIdentifierSet);
            }
            if (memberTypeAttributeMap != null) {
                this.addSearchFilter(dataObject2, memberTypeAttributeMap);
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getGroupMembers(grpid,groupscope,memberids,returnedMemberTypeAndAttributes)");
        }
    }

    private void getMember() {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getMember()");
        }
        if (this.mbrId != null) {
            DataObject dataObject = this.result.getRootObject().getDataObject("Root");
            this.addEntity(dataObject, this.mbrId);
            this.addPropertiesControl(dataObject, this.attributeNames);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getMember()");
        }
    }

    private void getMembers(short s, MemberIdentifierSet memberIdentifierSet, StringSet stringSet, SortControl sortControl) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getMembers(mbrType,mbrIds,attrs,sCtrl)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        this.addPropertiesControl(dataObject, stringSet);
        if (memberIdentifierSet != null) {
            this.addEntities(dataObject, memberIdentifierSet);
        }
        if (sortControl != null) {
            this.addSortControl(dataObject, sortControl);
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getMembers(mbrType,mbrIds,attrs,sCtrl)");
        }
    }
}

