/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.bridge.assembler.datagraph;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.websphere.wmm.datatype.StringIterator;
import com.ibm.websphere.wmm.datatype.StringSet;
import com.ibm.ws.wim.bridge.assembler.DataGraphAssembler;
import commonj.sdo.DataObject;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoginDataGraphAssembler
extends DataGraphAssembler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = LoginDataGraphAssembler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    final String WIM_REALM = "WIM.REALM";
    private static final short CHECK_PASSWORD = 0;
    private static final short MAP_CERTIFICATE = 1;
    private short constructMode = (short)-1;
    private String account = null;
    private String password = null;
    private StringSet searchBases = null;
    private StringSet requestedAttributes = null;
    private X509Certificate[] certificate = null;

    public static LoginDataGraphAssembler getInstance(String string, String string2, StringSet stringSet, StringSet stringSet2) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(userSecurityName, password, searchBases, requestedAttributes)");
        }
        LoginDataGraphAssembler loginDataGraphAssembler = new LoginDataGraphAssembler();
        loginDataGraphAssembler.initialization();
        loginDataGraphAssembler.constructMode = 0;
        loginDataGraphAssembler.account = string;
        loginDataGraphAssembler.password = string2;
        loginDataGraphAssembler.searchBases = stringSet;
        loginDataGraphAssembler.requestedAttributes = stringSet2;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(userSecurityName, password, searchBases, requestedAttributes)");
        }
        return loginDataGraphAssembler;
    }

    public static LoginDataGraphAssembler getInstance(X509Certificate[] x509CertificateArray, StringSet stringSet) {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "getInstance(cert, requestedAttributes)");
        }
        LoginDataGraphAssembler loginDataGraphAssembler = new LoginDataGraphAssembler();
        loginDataGraphAssembler.initialization();
        loginDataGraphAssembler.constructMode = 1;
        loginDataGraphAssembler.certificate = x509CertificateArray;
        loginDataGraphAssembler.requestedAttributes = stringSet;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "getInstance(cert, requestedAttributes)");
        }
        return loginDataGraphAssembler;
    }

    public Object assemble() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "assemble()");
        }
        switch (this.constructMode) {
            case 0: {
                this.checkPassword(this.account, this.password, this.searchBases, this.requestedAttributes);
                break;
            }
            case 1: {
                this.mapCertificate(this.certificate, this.requestedAttributes);
                break;
            }
            default: {
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms("unsupported construct mode [" + this.constructMode + "]", CLASSNAME, "assemble()"));
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "assemble()");
        }
        return this.result;
    }

    private void checkPassword(String string, String string2, StringSet stringSet, StringSet stringSet2) throws WIMException {
        String string3;
        StringIterator stringIterator;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "checkPassword(acct,pwd,sBases,attrs)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "PersonAccount");
        dataObject2.setString("principalName", string);
        byte[] byArray = PasswordUtil.getByteArrayPassword(string2);
        dataObject2.set("password", (Object)byArray);
        DataObject dataObject3 = null;
        if (this.searchBases != null) {
            dataObject3 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "LoginControl");
            stringIterator = stringSet.iterator();
            while (stringIterator.hasNext()) {
                string3 = stringIterator.next();
                dataObject3.getList("searchBases").add(string3);
                if (!trcLogger.isLoggable(Level.FINEST)) continue;
                trcLogger.logp(Level.FINER, CLASSNAME, "checkPassword(acct,pwd,sBases,attrs)", "add search base [" + string3 + "]");
            }
        }
        if (stringSet2 != null) {
            if (dataObject3 == null) {
                dataObject3 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "LoginControl");
            }
            stringIterator = stringSet2.iterator();
            while (stringIterator.hasNext()) {
                string3 = stringIterator.next();
                dataObject3.getList("properties").add(string3);
                if (!trcLogger.isLoggable(Level.FINEST)) continue;
                trcLogger.logp(Level.FINER, CLASSNAME, "checkPassword(acct,pwd,sBases,attrs)", "add properties [" + string3 + "]");
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "checkPassword(acct,pwd,sBases,attrs)");
        }
    }

    private void mapCertificate(X509Certificate[] x509CertificateArray, StringSet stringSet) throws WIMException {
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "mapCertificate(cert,attrs)");
        }
        DataObject dataObject = this.result.getRootObject().getDataObject("Root");
        DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "PersonAccount");
        if (x509CertificateArray != null && x509CertificateArray.length >= 1) {
            try {
                dataObject2.setBytes("certificate", x509CertificateArray[0].getEncoded());
            }
            catch (Exception exception) {
                throw new WIMApplicationException("GENERIC", WIMMessageHelper.generateMsgParms(exception.getMessage()), CLASSNAME, "mapCertificate(cert,attrs)");
            }
        }
        DataObject dataObject3 = null;
        if (stringSet != null) {
            if (dataObject3 == null) {
                dataObject3 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "LoginControl");
            }
            StringIterator stringIterator = stringSet.iterator();
            while (stringIterator.hasNext()) {
                String string = stringIterator.next();
                dataObject3.getList("properties").add(string);
                if (!trcLogger.isLoggable(Level.FINEST)) continue;
                trcLogger.logp(Level.FINER, CLASSNAME, "mapCertificate(cert,attrs)", "add properties [" + string + "]");
            }
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "mapCertificate(cert,attrs)");
        }
    }
}

